//
// Syd: rock-solid unikernel
// fuzz/src/wildmatch.rs: Fuzz target for glob matcher
//
// Copyright (c) 2023, 2024 Ali Polatel <alip@chesswob.org>
//
// SPDX-License-Identifier: GPL-3.0-or-later

use syd::wildmatch::wildmatch;

fn main() {
    afl::fuzz!(|data: &[u8]| {
        if data.len() < 2 {
            return;
        }

        // Use the first byte to determine a split point.
        let split_at = data[0] as usize % data.len();
        let (pattern, path) = data.split_at(split_at);

        // Fuzz it!
        let _ = wildmatch(pattern, path);
    });
}
