# v0.20.0

## Added
- Added help-text and visited accessibility properties
- Added a --minify argument to compile and batch-compile to emit XML with no comments or whitespace
- Extern class names can now include a "." for readability
- Added a linter (Sonny Piers, Neighborhoodie/STA)
- Added extension syntax for Gtk.LevelBar offsets (Matthijs Velsink)
- Allow translated string constants in expressions (Julian Sparber)
- Added support for some Pango types to be specified as strings (Matthijs Velsink)
- The formatter wraps long lines now
- Added support for Gtk.TryExpression
- Added support for `null` in expressions

### Language Server
- Added the signature of a long block as an inlay hint at the end of the block
- Added completions for available namespaces when typing a class name
- Added completions for imports
- Added completion for `translation-domain`
- Added object value completions
- Completions are now sorted. Up to five commonly used completions are highlighted at the top, based on statistics from a collection of open-source projects that use Blueprint.
- Hovering over the object in a signal shows the object's signature

## Changed
- blueprint-compiler now uses libgirepository to load typelib information, rather than a custom parser.
- Lookup expressions on an object reference no longer emit an unnecessary `<constant>` tag

## Fixed
- Skip unchanged files in batch-compile to prevent unnecessary rebuilds (Alice Mikhaylenko)
- Don't allow assigning true or false to an object
- Reversed the GIR search order so it searches user-configured paths before default ones (Qiu Wenbo)
- The decompiler properly quotes Gio.File properties
- Fixed a crash when an Adw.AlertDialog response block is malformed
- Error messages in the CLI show at least one caret under the source code line, even for diagnostics reported with zero length
- Fixed a crash when using `typeof` with enum and boxed types (Jamie Gravendeel)
- Treat `/* ... */` comments as inline in the formatter (Matthijs Velsink)
- Fixed a crash when an error is reported on an empty last line
- The decompiler no longer emits unnecessary signal flags
- Closure arguments are now type checked
- Expressions in property bindings are now type checked
- Added support for more primitive types and added type checking for conversions between them
- Fixed a crash when a string array is empty
- Bindings consisting of a single lookup can use flags even if they have a cast at the end

### Language Server
- Completions no longer add the body of an object when you're editing the class name of an existing object. Made similar changes for properties and signals.
- Fixed a crash that occurred when you hovered over a reference to an object that has an invalid class name.
- Signal completions now include a default name for the handler function

## Documentation
- Add Kate editor as having built in support (Zoey Ahmed)
- Link to Sublime Text syntax highlighting plugin (Nelson Benítez León)
- Link to Zed plugin (tfuxu)

# v0.18.0

## Added
- GtkBuilder now allows menus to be specified inline as a property value. Blueprint now supports this as well.

## Fixed
- Made reference_docs.json build reproducible (Sertonix)
- Correctly emit XML for nested templates (Tom Greig)
- Fix crash in language server while typing an AdwBreakpointSetter rule
- Update URLs after move to GNOME namespace on GitLab
- Fix crash when decompiling a lookup tag with no type attribute
- Fix incorrect result when decompiling a signal that has the template as its object
- Fix an incorrect "Duplicate object ID" error when an Adw.AlertDialog response had the same ID as an object

## Documentation
- Updated syntax in the example on the Overview page (Chris Mayo)
- Added examples of Gtk.Scale marks (Matthijs Velsink)
- Corrected errors in the index on the Extensions page (Matthijs Velsink)

# v0.16.0

## Added
- Added more "go to reference" implementations in the language server
- Added semantic token support for flag members in the language server
- Added property documentation to the hover tooltip for notify signals
- The language server now shows relevant sections of the reference documentation when hovering over keywords and symbols
- Added `not-swapped` flag to signal handlers, which may be needed for signal handlers that specify an object
- Added expression literals, which allow you to specify a Gtk.Expression property (as opposed to the existing expression support, which is for property bindings)

## Changed
- The formatter adds trailing commas to lists (Alexey Yerin)
- The formatter removes trailing whitespace from comments (Alexey Yerin)
- Autocompleting a commonly translated property automatically adds the `_("")` syntax
- Marking a single-quoted string as translatable now generates a warning, since gettext does not recognize it when using the configuration recommended in the blueprint documentation

## Fixed
- Added support for libgirepository-2.0 so that blueprint doesn't crash due to import conflicts on newer versions of PyGObject (Jordan Petridis)
- Fixed a bug when decompiling/porting files with enum values
- Fixed several issues where tests would fail with versions of GTK that added new deprecations
- Addressed a problem with the language server protocol in some editors (Luoyayu)
- Fixed an issue where the compiler would crash instead of reporting compiler errors
- Fixed a crash in the language server that occurred when a detailed signal (e.g. `notify::*`) was not complete
- The language server now properly implements the shutdown command, fixing support for some editors and improving robustness when restarting (Alexey Yerin)
- Marking a string in an array as translatable now generates an error, since it doesn't work
-

## Documentation
- Added mention of `null` in the Literal Values section
- Add apps to Built with Blueprint section (Benedek Dévényi, Vladimir Vaskov)
- Corrected and updated many parts of the documentation

# v0.14.0

## Added
- Added a warning for unused imports.
- Added an option to not print the diff when formatting with the CLI. (Gregor Niehl)
- Added support for building Gtk.ColumnViewRow, Gtk.ColumnViewCell, and Gtk.ListHeader widgets with Gtk.BuilderListItemFactory.
- Added support for the `after` keyword for signals. This was previously documented but not implemented. (Gregor Niehl)
- Added support for string arrays. (Diego Augusto)
- Added hover documentation for properties in lookup expressions.
- The decompiler supports action widgets, translation domains, `typeof<>` syntax, and expressions. It also supports extension syntax for Adw.Breakpoint, Gtk.BuilderListItemFactory, Gtk.ComboBoxText, Gtk.SizeGroup, and Gtk.StringList.
- Added a `decompile` subcommand to the CLI, which decompiles an XML .ui file to blueprint.
- Accessibility relations that allow multiple values are supported using list syntax. (Julian Schmidhuber)

## Changed
- The decompiler sorts imports alphabetically.
- Translatable strings use `translatable="yes"` instead of `translatable="true"` for compatibility with xgettext. (Marco Köpcke)
- The first line of the documentation is shown in the completion list when using the language server. (Sonny Piers)
- Object autocomplete uses a snippet to add the braces and position the cursor inside them. (Sonny Piers)
- The carets in the CLI diagnostic output now span the whole error message up to the end of the first line, rather than just the first character.
- The decompiler emits double quotes, which are compatible with gettext.

## Fixed
- Fixed deprecation warnings in the language server.
- The decompiler no longer duplicates translator comments on properties.
- Subtemplates no longer output a redundant `@generated` comment.
- When extension syntax from a library that is not available is used, the compiler emits an error instead of crashing.
- The language server reports semantic token positions correctly. (Szepesi Tibor)
- The decompiler no longer emits the deprecated `bind-property` syntax. (Sonny Piers)
- Fixed the tests when used as a Meson subproject. (Benoit Pierre)
- Signal autocomplete generates correct syntax. (Sonny Piers)
- The decompiler supports templates that do not specify a parent class. (Sonny Piers)
- Adw.Breakpoint setters that set a property on the template no longer cause a crash.
- Fixed type checking with templates that do not have a parent class.
- Fixed online documentation links for interfaces.
- The wording of edit suggestions is fixed for insertions and deletions.
- When an input file uses tabs instead of spaces, the diagnostic output on the CLI aligns the caret correctly.
- The decompiler emits correct syntax when a property binding refers to the template object.

## Documentation
- Fixed typos in "Built with Blueprint" section. (Valéry Febvre, Dexter Reed)

# v0.12.0

## Added

- Add support for Adw.AlertDialog (Sonny Piers)
- Emit warnings for deprecated APIs - lsp and compiler
- lsp: Document symbols
- lsp: "Go to definition" (ctrl+click)
- lsp: Code action for "namespace not imported" diagnostics, that adds the missing import
- Add a formatter - cli and lsp (Gregor Niehl)
- Support for translation domain - see documentation
- cli: Print code actions in error messages

## Changed

- compiler: Add a header notice mentionning the file is generated (Urtsi Santsi)
- decompiler: Use single quotes for output

## Fixed

- Fixed multine strings support with the escape newline character
- lsp: Fixed the signal completion, which was missing the "$"
- lsp: Fixed property value completion  (Ivan Kalinin)
- lsp: Added a missing semantic highlight (for the enum in Gtk.Scale marks)
- Handle big endian bitfields correctly (Jerry James)
- batch-compile: Fix mixing relative and absolute paths (Marco Köpcke )

## Documentation

- Fix grammar for bindings
- Add section on referencing templates

# v0.10.0

## Added

- The hover documentation now includes a link to the online documentation for the symbol, if available.
- Added hover documentation for the Adw.Breakpoint extensions, `condition` and `setters`.

## Changed

- Decompiling an empty file now produces an empty file rather than an error. (AkshayWarrier)
- More relevant documentation is shown when hovering over an identifier literal (such as an enum value or an object ID).

## Fixed

- Fixed an issue with the language server not conforming the spec. (seshotake)
- Fixed the signature section of the hover documentation for properties and signals.
- Fixed a bug where documentation was sometimes shown for a different symbol with the same name.
- Fixed a bug where documentation was not shown for accessibility properties that contain `-`.
- Number literals are now correctly parsed as floats if they contain a `.`, even if they are divisible by 1.

## Removed

- The `bind-property` keyword has been removed. Use `bind` instead. The old syntax is still accepted with a warning.

## Documentation

- Fixed the grammar for Extension, which was missing ExtAdwBreakpoint.


# v0.8.1

## Breaking Changes

- Duplicates in a number of places are now considered errors. For example, duplicate flags in several places, duplicate
  strings in Gtk.FileFilters, etc.

## Fixed

- Fixed a number of bugs in the XML output when using `template` to refer to the template object.

## Documentation

- Fixed the example for ExtListItemFactory

# v0.8.0

## Breaking Changes

- A trailing `|` is no longer allowed in flags.
- The primitive type names `gboolean`, `gchararray`, `gint`, `gint64`, `guint`, `guint64`, `gfloat`, `gdouble`, `utf8`, and `gtype` are no longer permitted. Use the non-`g`-prefixed versions instead.
- Translated strings may no longer have trailing commas.

## Added

- Added cast expressions, which are sometimes needed to specify type information in expressions.
- Added support for closure expressions.
- Added the `--typelib-path` command line argument, which allows adding directories to the search path for typelib files.
- Added custom compile and decompile commands to the language server. (Sonny Piers)
- Added support for [Adw.MessageDialog](https://gnome.pages.gitlab.gnome.org/libadwaita/doc/1-latest/class.MessageDialog.html#adwmessagedialog-as-gtkbuildable) custom syntax.
- Added support for inline sub-templates for [Gtk.BuilderListItemFactory](https://docs.gtk.org/gtk4/class.BuilderListItemFactory.html). (Cameron Dehning)
- Added support for [Adw.Breakpoint](https://gnome.pages.gitlab.gnome.org/libadwaita/doc/main/class.Breakpoint.html) custom syntax.
- Added a warning when an object ID might be confusing.
- Added support for [Gtk.Scale](https://docs.gtk.org/gtk4/class.Scale.html#gtkscale-as-gtkbuildable) custom syntax.

## Changed

Some of these changes affect syntax, but the old syntax is still accepted with a purple "upgrade" warning, so they are not breaking changes yet. In editors that support code actions, such as Visual Studio Code, the blueprint language server can automatically fix these warnings.

- The XML output uses the integer value rather than GIR name for enum values.
- Compiler errors are now printed to stderr rather than stdout. (Sonny Piers)
- Introduced `$` to indicate types or callbacks that are provided in application code.
  - Types that are provided by application code are now begin with a `$` rather than a leading `.`.
  - The handler name in a signal is now prefixed with `$`.
  - Closure expressions, which were added in this version, are also prefixed with `$`.
- When a namespace is not found, errors are supressed when the namespace is used.
- The compiler bug message now reports the version of blueprint-compiler.
- The `typeof` syntax now uses `<>` instead of `()` to match cast expressions.
- Menu sections and subsections can now have an ID.
- The interactive porting tool now ignores hidden folders. (Sonny Piers)
- Templates now use the typename syntax rather than an ID to specify the template's class. In most cases, this just means adding a `$` prefix to the ID, but for GtkListItem templates it should be shortened to ListItem (since the Gtk namespace is implied). The template object is now referenced with the `template` keyword rather than with the ID.

## Fixed

- Fixed a bug in the language server's acceptance of text change commands. (Sonny Piers)
- Fixed a bug in the display of diagnostics when the diagnostic is at the beginning of a line.
- Fixed a crash that occurred when dealing with array types.
- Fixed a bug that prevented Gio.File properties from being settable.

## Documentation

- Added a reference section to the documentation. This replaces the Examples page with a detailed description of each syntax feature, including a formal specification of the grammar.

# v0.6.0

## Breaking Changes
- Quoted and numeric literals are no longer interchangeable (e.g. `"800"` is no longer an accepted value for an
  integer type).
- Boxed types are now type checked.

## Added
- There is now syntax for `GType` literals: the `typeof()` pseudo-function. For example, list stores have an `item-type`
  property which is now specifiable like this: `item-type: typeof(.MyDataModel)`. See the documentation for more details.

## Changed
- The language server now logs to stderr.

## Fixed
- Fix the build on Windows, where backslashes in paths were not escaped. (William Roy)
- Remove the syntax for specifying menu objects inline, since it does not work.
- Fix a crash in the language server that was triggered in files with incomplete `using Gtk 4.0;` statements.
- Fixed compilation on big-endian systems.
- Fix an issue in the interactive port tool that would lead to missed files. (Frank Dana)

## Documentation
- Fix an issue for documentation contributors where changing the documentation files would not trigger a rebuild.
- Document the missing support for Gtk.Label `<attributes>`, which is intentional, and recommend alternatives. (Sonny
  Piers)
- Add a prominent warning that Blueprint is still experimental


# v0.4.0

## Added
- Lookup expressions
- With the language server, hovering over a diagnostic message now shows any
  associated hints.

## Changed
- The compiler now uses .typelib files rather than XML .gir files, which reduces
  dependencies and should reduce compile times by about half a second.

## Fixed
- Fix the decompiler/porting tool not importing the Adw namespace when needed
- Fix a crash when trying to compile an empty file
- Fix parsing of number tokens
- Fix a bug where action widgets did not work in templates
- Fix a crash in the language server that occurred when a `using` statement had
no version
- If a compiler bug is reported, the process now exits with a non-zero code
