# 新コメント扱い仕様ドラフト 抜け漏れ・曖昧点の調査結果

`draft/new_comment_treatment.md` を現行仕様（ドキュメント・実装）と照合し、抜け漏れ・曖昧な点を整理した。

---

## 方針決定（ドラフト反映済み）

- **ディレクティブ名**: 例を `# tombi: format.rules.table-keys-order.disabled = true` に統一した。
- **inline**: 削除。優先順位は「直前行の leading」のみ記載。
- **テーブル間の dangling**: 従来通り、その直前の root key/value もしくはテーブルに属する。
- **ファイル先頭の value ディレクティブ**: 次の key-value グループに紐づく。document 用 `#:tombi` は別体系のため影響なし。ドキュメントレベルのコメントディレクティブは**最初のコメントグループにのみ**記述可能と明記。
- **dangling が連続する場合**: 最後のコメントグループ以外は、空の要素グループを持つ dangling comment として保持する旨を追記。
- **document ディレクティブ**: `#:tombi` は value の `# tombi:` と異なるため本仕様の紐付けに影響しない。ただし最初のコメントグループにしか書けない。
- **array-values-order / inline table / array**: 同様のグループ・Separator ルールを適用する節を追加。
- **Separator の出力**: AST では空改行数 n を保持。フォーマッタでは 0 または 1 に圧縮して出力する旨を明記。
- **例の `<schema-order>`**: 具体例（3 グループ目は Schema 順）に差し替え。

---

## 1. 現行仕様との齟齬・用語の誤り（対応済み）

### 1.1 ディレクティブ名の誤記 → **対応済み**

- 例を `format.rules.table-keys-order.disabled = true` に統一した。

### 1.2 「inline」の定義不足 → **対応済み（削除）**

- 優先順位から「inline」を削除し、「直前行の leading」のみ記載。

---

## 2. 仕様の抜け漏れ

### 2.1 グループのスコープ（テーブル・ルート）→ **方針反映済み**

- **決定**: テーブル間の dangling は従来通り、直前の root key/value もしくはテーブルに属する。ドラフト §5 に追記済み。

### 2.2 テーブルヘッダ `[section]` と空行

- 上記と整合: テーブル「間」の dangling は前の要素に属するため、`[section]` 前の空行は前のグループ終端として扱われる。

### 2.3 ファイル先頭・ドキュメント先頭との関係 → **方針反映済み**

- **決定**: ファイル先頭の value ディレクティブは次の key-value グループに紐づく。document 用 `#:tombi` は別体系で影響なし。ドキュメントレベルは最初のコメントグループにのみ記述可能。ドラフト §6 に追記済み。

### 2.4 配列要素のソート（array-values-order）とグループ → **方針反映済み**

- **決定**: array-values-order および inline table / array にも同様のグループ・Separator ルールを適用する。「スコープ: テーブル以外のソート対象」節を追加済み。

### 2.5 出力時の連続空行数 → **方針反映済み**

- **決定**: AST では空改行数 n を保持。フォーマッタでは 0 または 1 に圧縮して出力。ドラフト §1 に追記済み。

### 2.6 グループ先頭・末尾の両方にディレクティブがある場合

- **問題**: 「グループ先頭の dangling のディレクティブはグループ全体に作用」「グループ末尾の dangling のディレクティブもグループ全体に作用」とあるが、**同一グループの先頭と末尾に異なるディレクティブ**（例: 先頭で disabled、末尾で ascending）がある場合の優先順位が未定義。
- **推奨**: 優先順位（例: 先頭優先 / 末尾優先 / エラー）を 1 行でよいので規定する。

### 2.7 複数ディレクティブ・複数コメントが同じグループ先頭にある場合

- **問題**: グループ先頭に「通常コメント＋ディレクティブ」が複数行ある場合、ディレクティブは「グループの先頭キー」に付くのか「グループ全体」に付くのかは、例では「グループ全体の自動ソートに作用」と書かれており、意味は分かる。一方で、**複数の value directive が同じグループ先頭に並んだ場合**（例: table-keys-order と lint 系）の解釈は現行ドキュメントに従うとしてよいが、ドラフトでは「グループ全体に作用」が format に限られる旨を書いておくと安全。
- **推奨**: 「グループ先頭/末尾の dangling に書かれた **format** 系ディレクティブが、そのグループ全体のソートに作用する」と限定して書く。

---

## 3. 曖昧な点・解釈が分かれる点

### 3.1 「空行」の定義

- **現行実装**: `node.rs` の `group_comments` では、**連続する 2 つの LINE_BREAK**（または WHITESPACE を挟んだ 2 つの LINE_BREAK）で「新しいグループ」としている。つまり「1 行空き」= 改行 2 回分。
- **ドラフト**: 「空行」「次ノードとの間の空行」とだけある。
- **推奨**: 「空行 = 改行のみの行（空白のみの行も空行とみなす）」など、1 行で定義を入れる。実装との対応（LINE_BREAK の扱い）は実装メモでよい。

### 3.2 Dangling の「前ノード」「次ノード」

- **問題**: 「前ノードとの間に空行が無ければ」「次ノードとの間に空行あり」など、**ノード**が key-value に限定してよいか、`[table]` や配列・インライン表なども含むかが書かれていない。現行の begin/end dangling は「key_values の前」「key_values の後」で区切られている。
- **推奨**: 本仕様では「ノード」を key-value に限定するか、テーブルヘッダもノードに含めるかを明示する。少なくとも「グループ境界の判定に使うノード」を列挙する。

### 3.3 例の出力のプレースホルダー → **対応済み**

- `<schema-order>` を具体例（3 グループ目は Schema 順のキー並び）に差し替え、注釈を追加済み。

### 3.4 未解決の論点の位置づけ → **対応済み**

- 「連続空行数は Separator(n) で保持」は §1 で確定方針として記載。未解決の論点からは削除し、「Schema との整合」「inline table / array of tables 内のグループ境界の具体的扱い」に整理済み。

---

## 4. 現行挙動との変更点の明文化（推奨）

- **treatment-of-comments.mdx**: 現行は「key と key の間の空行で区切られた dangling は、**leading にマージして空行を削除**」している。ドラフトでは**空行を残し、グループ境界とする**ため、同じ入力でも挙動が変わる。
- **推奨**: ドラフトの「背景」または「既存課題」に、「現行では key 間の空行で区切られたコメントは leading にマージされ空行は削除される。本提案では空行を Separator として保持し、グループ境界として扱う」と 1 文追加すると、仕様変更の意図が明確になる。

---

## 5. チェックリスト（仕様確定前に確認するとよい項目）

| # | 項目 | 状態 |
|---|------|------|
| 1 | 例の `format.disabled` → `format.rules.table-keys-order.disabled` に統一 | **対応済み** |
| 2 | 「inline」の削除 | **対応済み** |
| 3 | テーブル間の dangling は直前の root key/value またはテーブルに属する | **対応済み** |
| 4 | ファイル先頭の value ディレクティブは次のグループに紐づく / document は最初のコメントグループのみ | **対応済み** |
| 5 | array-values-order・inline table・array に同様のルールを適用 | **対応済み** |
| 6 | Separator: AST で n 保持、フォーマッタで 0/1 に圧縮 | **対応済み** |
| 7 | 同一グループで先頭・末尾ディレクティブが両方ある場合の優先順位 | 要追記 |
| 8 | 「空行」の定義（改行のみの行など） | 要追記 |
| 9 | 境界判定に使う「ノード」の範囲（key-value のみか） | 要追記 |
| 10 | `<schema-order>` を実際の例に変更 | **対応済み** |
| 11 | 未解決の論点の整理（Separator(n) を確定に） | **対応済み** |
| 12 | dangling 連続時は最後以外を「空の要素グループの dangling」として保持 | **対応済み** |

---

以上を反映済み。残りは 7・8・9 の追記検討。
