# mkdocs-htmlproofer-plugin [![PyPI - Version](https://img.shields.io/pypi/v/mkdocs-htmlproofer-plugin.svg)](https://pypi.org/project/mkdocs-htmlproofer-plugin)

[![GitHub Actions](https://github.com/manuzhang/mkdocs-htmlproofer-plugin/actions/workflows/ci.yml/badge.svg)](https://github.com/manuzhang/mkdocs-htmlproofer-plugin/actions/workflows/ci.yml)

*A [MkDocs](https://www.mkdocs.org/) plugin that validates URLs, including anchors, in rendered html files*.

> [!NOTE]
> [MkDocs 1.6+ supports native validation of anchors](https://www.mkdocs.org/user-guide/configuration/#validation).

## Installation

0. Prerequisites

* Python >= 3.10
* MkDocs >= 1.4.0

1. Install the package with pip:

```bash
pip install mkdocs-htmlproofer-plugin
```

2. Enable the plugin in your `mkdocs.yml`:

> [!NOTE]
> If you have no `plugins` entry in your config file yet, you'll likely also want to add the `search` plugin.
MkDocs enables it by default if there is no `plugins` entry set, but now you have to enable it explicitly.

```yaml
plugins:
    - search
    - htmlproofer
```

## Configuring

### `enabled`

True by default, allows toggling whether the plugin is enabled.
Useful for local development where you may want faster build times.

```yaml
plugins:
  - htmlproofer:
      enabled: !ENV [ENABLED_HTMLPROOFER, True]
```

Which enables you do disable the plugin locally using:

```bash
export ENABLED_HTMLPROOFER=false
mkdocs serve
```


### `raise_error`

Optionally, you may raise an error and fail the build on first bad url status. Takes precedense over `raise_error_after_finish`.

```yaml
plugins:
  - htmlproofer:
      raise_error: True
```

### `raise_error_after_finish`

Optionally, you may want to raise an error and fail the build on at least one bad url status after all links have been checked.

```yaml
plugins:
  - htmlproofer:
      raise_error_after_finish: True
```

### `raise_error_excludes`

When specifying `raise_error: True` or `raise_error_after_finish: True`, it is possible to ignore errors
for combinations of URLs and status codes with `raise_error_excludes`. Each URL supports unix style wildcards `*`, `[]`, `?`, etc.

```yaml
plugins:
  - search
  - htmlproofer:
      raise_error: True
      raise_error_excludes:
        504: ['https://www.mkdocs.org/']
        404: ['https://github.com/manuzhang/*']
        400: ['*']
```

### `ignore_urls`

Avoid validating the given list of URLs by ignoring them altogether. Each URL in the
list supports unix style wildcards `*`, `[]`, `?`, etc.

Unlike `raise_error_excludes`, ignored URLs will not be fetched at all.

```yaml
plugins:
  - search
  - htmlproofer:
      raise_error: True
      ignore_urls:
        - https://github.com/myprivateorg/*
        - https://app.dynamic-service-of-some-kind.io*
```

### `warn_on_ignored_urls`

Log a warning when ignoring URLs with `ignore_urls` option. Defaults to `false` (no warning).

```yaml
plugins:
  - search
  - htmlproofer:
      raise_error: True
      ignore_urls:
        - https://github.com/myprivateorg/*
        - https://app.dynamic-service-of-some-kind.io*
      warn_on_ignored_urls: true
```

### `ignore_pages`

Avoid validating the URLs on the given list of markdown pages by ignoring them altogether.
Each page in the list supports unix style wildcards `*`, `[]`, `?`, etc.

```yaml
plugins:
  - search
  - htmlproofer:
      raise_error: True
      ignore_pages:
        - path/to/file
        - path/to/folder/*
```

### `validate_external_urls`

Avoids validating any external URLs (i.e those starting with http:// or https://).
This will be faster if you just want to validate local anchors, as it does not make any network requests.

```yaml
plugins:
  - htmlproofer:
      validate_external_urls: False
```

### `validate_rendered_template`

Validates the entire rendered template for each page - including the navigation, header, footer, etc.
This defaults to off because it is much slower and often redundant to repeat for every single page.

```yaml
plugins:
  - htmlproofer:
      validate_rendered_template: True
```

### `skip_downloads`

Optionally skip downloading of a remote URLs content via GET request. This can
considerably reduce the time taken to validate URLs.

```yaml
plugins:
  - htmlproofer:
      skip_downloads: True
```

### `retry_max_times`

Sets the maximum number of HTTP request retries when checking a URL. Defaults to 0 (no retries).

```yaml
plugins:
  - htmlproofer:
      retry_max_times: 3
```

### `max_workers`

Optionally set the maximum number of worker threads used to validate URLs concurrently.
By default, this is not set and the [default of Python's `ThreadPoolExecutor`](https://docs.python.org/3/library/concurrent.futures.html#concurrent.futures.ThreadPoolExecutor) is used.

```yaml
plugins:
  - htmlproofer:
      max_workers: 16
```

## Compatibility with `attr_list` extension

If you need to manually specify anchors make use of the `attr_list` [extension](https://python-markdown.github.io/extensions/attr_list) in the markdown.
This can be useful for multilingual documentation to keep anchors as language neutral permalinks in all languages.

* A sample for a heading `# Grüße {#greetings}` (the slugified generated anchor `Gre` is overwritten with `greetings`).
* This also works for images `this is a nice image [](foo-bar.png){#nice-image}`
* And generally for paragraphs:
```markdown
Listing: This is noteworthy.
{#paragraphanchor}
```

## Improving

More information about plugins in the [MkDocs documentation](http://www.mkdocs.org/user-guide/plugins/)

## Acknowledgement

This work is based on the [mkdocs-markdownextradata-plugin](https://github.com/rosscdh/mkdocs-markdownextradata-plugin) project and the [Finding and Fixing Website Link Rot with Python, BeautifulSoup and Requests](https://www.twilio.com/en-us/blog/find-fix-website-link-rot-python-beautifulsoup-requests-html) article.
