// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Traces struct {
	orig  *otlpcollectortrace.ExportTraceServiceRequest
	state *State
}

func GetOrigTraces(ms Traces) *otlpcollectortrace.ExportTraceServiceRequest {
	return ms.orig
}

func GetTracesState(ms Traces) *State {
	return ms.state
}

func NewTraces(orig *otlpcollectortrace.ExportTraceServiceRequest, state *State) Traces {
	return Traces{orig: orig, state: state}
}

var (
	protoPoolExportTraceServiceRequest = sync.Pool{
		New: func() any {
			return &otlpcollectortrace.ExportTraceServiceRequest{}
		},
	}
)

func NewOrigExportTraceServiceRequest() *otlpcollectortrace.ExportTraceServiceRequest {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectortrace.ExportTraceServiceRequest{}
	}
	return protoPoolExportTraceServiceRequest.Get().(*otlpcollectortrace.ExportTraceServiceRequest)
}

func DeleteOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.ResourceSpans {
		DeleteOrigResourceSpans(orig.ResourceSpans[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolExportTraceServiceRequest.Put(orig)
	}
}

func CopyOrigExportTraceServiceRequest(dest, src *otlpcollectortrace.ExportTraceServiceRequest) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.ResourceSpans = CopyOrigResourceSpansSlice(dest.ResourceSpans, src.ResourceSpans)
}

func GenTestOrigExportTraceServiceRequest() *otlpcollectortrace.ExportTraceServiceRequest {
	orig := NewOrigExportTraceServiceRequest()
	orig.ResourceSpans = GenerateOrigTestResourceSpansSlice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceSpans) > 0 {
		dest.WriteObjectField("resourceSpans")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceSpans(orig.ResourceSpans[0], dest)
		for i := 1; i < len(orig.ResourceSpans); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceSpans(orig.ResourceSpans[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigTraces unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceSpans", "resource_spans":
			for iter.ReadArray() {
				orig.ResourceSpans = append(orig.ResourceSpans, NewOrigResourceSpans())
				UnmarshalJSONOrigResourceSpans(orig.ResourceSpans[len(orig.ResourceSpans)-1], iter)
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceSpans {
		l = SizeProtoOrigResourceSpans(orig.ResourceSpans[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceSpans) - 1; i >= 0; i-- {
		l = MarshalProtoOrigResourceSpans(orig.ResourceSpans[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportTraceServiceRequest(orig *otlpcollectortrace.ExportTraceServiceRequest, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceSpans", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceSpans = append(orig.ResourceSpans, NewOrigResourceSpans())
			err = UnmarshalProtoOrigResourceSpans(orig.ResourceSpans[len(orig.ResourceSpans)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
