package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartVisualService invokes the ehpc.StartVisualService API synchronously
func (client *Client) StartVisualService(request *StartVisualServiceRequest) (response *StartVisualServiceResponse, err error) {
	response = CreateStartVisualServiceResponse()
	err = client.DoAction(request, response)
	return
}

// StartVisualServiceWithChan invokes the ehpc.StartVisualService API asynchronously
func (client *Client) StartVisualServiceWithChan(request *StartVisualServiceRequest) (<-chan *StartVisualServiceResponse, <-chan error) {
	responseChan := make(chan *StartVisualServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartVisualService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartVisualServiceWithCallback invokes the ehpc.StartVisualService API asynchronously
func (client *Client) StartVisualServiceWithCallback(request *StartVisualServiceRequest, callback func(response *StartVisualServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartVisualServiceResponse
		var err error
		defer close(result)
		response, err = client.StartVisualService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartVisualServiceRequest is the request struct for api StartVisualService
type StartVisualServiceRequest struct {
	*requests.RpcRequest
	ClusterId string           `position:"Query" name:"ClusterId"`
	Port      requests.Integer `position:"Query" name:"Port"`
	CidrIp    string           `position:"Query" name:"CidrIp"`
}

// StartVisualServiceResponse is the response struct for api StartVisualService
type StartVisualServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateStartVisualServiceRequest creates a request to invoke StartVisualService API
func CreateStartVisualServiceRequest() (request *StartVisualServiceRequest) {
	request = &StartVisualServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "StartVisualService", "", "")
	request.Method = requests.GET
	return
}

// CreateStartVisualServiceResponse creates a response to parse from StartVisualService response
func CreateStartVisualServiceResponse() (response *StartVisualServiceResponse) {
	response = &StartVisualServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
