package servicefabric

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplicationDefinitionKind enumerates the values for application definition kind.
type ApplicationDefinitionKind string

const (
	// Compose Indicates the application is defined by compose file(s). The value is 1.
	Compose ApplicationDefinitionKind = "Compose"
	// Invalid Indicates the application definition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is 65535.
	Invalid ApplicationDefinitionKind = "Invalid"
	// ServiceFabricApplicationDescription Indicates the application is defined by a Service Fabric application
	// description. The value is 0.
	ServiceFabricApplicationDescription ApplicationDefinitionKind = "ServiceFabricApplicationDescription"
)

// PossibleApplicationDefinitionKindValues returns an array of possible values for the ApplicationDefinitionKind const type.
func PossibleApplicationDefinitionKindValues() []ApplicationDefinitionKind {
	return []ApplicationDefinitionKind{Compose, Invalid, ServiceFabricApplicationDescription}
}

// ApplicationPackageCleanupPolicy enumerates the values for application package cleanup policy.
type ApplicationPackageCleanupPolicy string

const (
	// ApplicationPackageCleanupPolicyAutomatic Indicates that the service fabric runtime determines when to do
	// the application package cleanup. By default, cleanup is done on successful provision. The value is 2.
	ApplicationPackageCleanupPolicyAutomatic ApplicationPackageCleanupPolicy = "Automatic"
	// ApplicationPackageCleanupPolicyDefault Indicates that the cleanup policy of application packages is
	// based on the cluster setting "CleanupApplicationPackageOnProvisionSuccess." The value is 1.
	ApplicationPackageCleanupPolicyDefault ApplicationPackageCleanupPolicy = "Default"
	// ApplicationPackageCleanupPolicyInvalid Indicates that the application package cleanup policy is invalid.
	// This value is default. The value is zero.
	ApplicationPackageCleanupPolicyInvalid ApplicationPackageCleanupPolicy = "Invalid"
	// ApplicationPackageCleanupPolicyManual Indicates that the user has to explicitly clean up the application
	// package. The value is 3.
	ApplicationPackageCleanupPolicyManual ApplicationPackageCleanupPolicy = "Manual"
)

// PossibleApplicationPackageCleanupPolicyValues returns an array of possible values for the ApplicationPackageCleanupPolicy const type.
func PossibleApplicationPackageCleanupPolicyValues() []ApplicationPackageCleanupPolicy {
	return []ApplicationPackageCleanupPolicy{ApplicationPackageCleanupPolicyAutomatic, ApplicationPackageCleanupPolicyDefault, ApplicationPackageCleanupPolicyInvalid, ApplicationPackageCleanupPolicyManual}
}

// ApplicationScopedVolumeKind enumerates the values for application scoped volume kind.
type ApplicationScopedVolumeKind string

const (
	// ServiceFabricVolumeDisk Provides Service Fabric High Availability Volume Disk
	ServiceFabricVolumeDisk ApplicationScopedVolumeKind = "ServiceFabricVolumeDisk"
)

// PossibleApplicationScopedVolumeKindValues returns an array of possible values for the ApplicationScopedVolumeKind const type.
func PossibleApplicationScopedVolumeKindValues() []ApplicationScopedVolumeKind {
	return []ApplicationScopedVolumeKind{ServiceFabricVolumeDisk}
}

// ApplicationStatus enumerates the values for application status.
type ApplicationStatus string

const (
	// ApplicationStatusCreating Indicates the application status is creating. The value is 3.
	ApplicationStatusCreating ApplicationStatus = "Creating"
	// ApplicationStatusDeleting Indicates the application status is deleting. The value is 4.
	ApplicationStatusDeleting ApplicationStatus = "Deleting"
	// ApplicationStatusFailed Indicates the creation or deletion of application was terminated due to
	// persistent failures. Another create/delete request can be accepted to resume a failed application. The
	// value is 5.
	ApplicationStatusFailed ApplicationStatus = "Failed"
	// ApplicationStatusInvalid Indicates the application status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ApplicationStatusInvalid ApplicationStatus = "Invalid"
	// ApplicationStatusReady Indicates the application status is ready. The value is 1.
	ApplicationStatusReady ApplicationStatus = "Ready"
	// ApplicationStatusUpgrading Indicates the application status is upgrading. The value is 2.
	ApplicationStatusUpgrading ApplicationStatus = "Upgrading"
)

// PossibleApplicationStatusValues returns an array of possible values for the ApplicationStatus const type.
func PossibleApplicationStatusValues() []ApplicationStatus {
	return []ApplicationStatus{ApplicationStatusCreating, ApplicationStatusDeleting, ApplicationStatusFailed, ApplicationStatusInvalid, ApplicationStatusReady, ApplicationStatusUpgrading}
}

// ApplicationTypeDefinitionKind enumerates the values for application type definition kind.
type ApplicationTypeDefinitionKind string

const (
	// ApplicationTypeDefinitionKindCompose Indicates the application type is defined and created implicitly as
	// part of a compose deployment. The value is 2.
	ApplicationTypeDefinitionKindCompose ApplicationTypeDefinitionKind = "Compose"
	// ApplicationTypeDefinitionKindInvalid Indicates the application type definition kind is invalid. All
	// Service Fabric enumerations have the invalid type. The value is 0.
	ApplicationTypeDefinitionKindInvalid ApplicationTypeDefinitionKind = "Invalid"
	// ApplicationTypeDefinitionKindServiceFabricApplicationPackage Indicates the application type is defined
	// and created by a Service Fabric application package provided by the user. The value is 1.
	ApplicationTypeDefinitionKindServiceFabricApplicationPackage ApplicationTypeDefinitionKind = "ServiceFabricApplicationPackage"
)

// PossibleApplicationTypeDefinitionKindValues returns an array of possible values for the ApplicationTypeDefinitionKind const type.
func PossibleApplicationTypeDefinitionKindValues() []ApplicationTypeDefinitionKind {
	return []ApplicationTypeDefinitionKind{ApplicationTypeDefinitionKindCompose, ApplicationTypeDefinitionKindInvalid, ApplicationTypeDefinitionKindServiceFabricApplicationPackage}
}

// ApplicationTypeStatus enumerates the values for application type status.
type ApplicationTypeStatus string

const (
	// ApplicationTypeStatusAvailable Indicates that the application type is fully provisioned and is available
	// for use. An application of this type and version can be created. The value is 2.
	ApplicationTypeStatusAvailable ApplicationTypeStatus = "Available"
	// ApplicationTypeStatusFailed Indicates that the application type provisioning failed and it is
	// unavailable for use. The failure details can be obtained from the application type information query.
	// The failed application type information remains in the cluster until it is unprovisioned or
	// reprovisioned successfully. The value is 4.
	ApplicationTypeStatusFailed ApplicationTypeStatus = "Failed"
	// ApplicationTypeStatusInvalid Indicates the application type status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ApplicationTypeStatusInvalid ApplicationTypeStatus = "Invalid"
	// ApplicationTypeStatusProvisioning Indicates that the application type is being provisioned in the
	// cluster. The value is 1.
	ApplicationTypeStatusProvisioning ApplicationTypeStatus = "Provisioning"
	// ApplicationTypeStatusUnprovisioning Indicates that the application type is in process of being
	// unprovisioned from the cluster. The value is 3.
	ApplicationTypeStatusUnprovisioning ApplicationTypeStatus = "Unprovisioning"
)

// PossibleApplicationTypeStatusValues returns an array of possible values for the ApplicationTypeStatus const type.
func PossibleApplicationTypeStatusValues() []ApplicationTypeStatus {
	return []ApplicationTypeStatus{ApplicationTypeStatusAvailable, ApplicationTypeStatusFailed, ApplicationTypeStatusInvalid, ApplicationTypeStatusProvisioning, ApplicationTypeStatusUnprovisioning}
}

// AutoScalingMechanismKind enumerates the values for auto scaling mechanism kind.
type AutoScalingMechanismKind string

const (
	// AddRemoveReplica Indicates that scaling should be performed by adding or removing replicas.
	AddRemoveReplica AutoScalingMechanismKind = "AddRemoveReplica"
)

// PossibleAutoScalingMechanismKindValues returns an array of possible values for the AutoScalingMechanismKind const type.
func PossibleAutoScalingMechanismKindValues() []AutoScalingMechanismKind {
	return []AutoScalingMechanismKind{AddRemoveReplica}
}

// AutoScalingMetricKind enumerates the values for auto scaling metric kind.
type AutoScalingMetricKind string

const (
	// Resource Indicates that the metric is one of resources, like cpu or memory.
	Resource AutoScalingMetricKind = "Resource"
)

// PossibleAutoScalingMetricKindValues returns an array of possible values for the AutoScalingMetricKind const type.
func PossibleAutoScalingMetricKindValues() []AutoScalingMetricKind {
	return []AutoScalingMetricKind{Resource}
}

// AutoScalingResourceMetricName enumerates the values for auto scaling resource metric name.
type AutoScalingResourceMetricName string

const (
	// CPU Indicates that the resource is CPU cores.
	CPU AutoScalingResourceMetricName = "cpu"
	// MemoryInGB Indicates that the resource is memory in GB.
	MemoryInGB AutoScalingResourceMetricName = "memoryInGB"
)

// PossibleAutoScalingResourceMetricNameValues returns an array of possible values for the AutoScalingResourceMetricName const type.
func PossibleAutoScalingResourceMetricNameValues() []AutoScalingResourceMetricName {
	return []AutoScalingResourceMetricName{CPU, MemoryInGB}
}

// AutoScalingTriggerKind enumerates the values for auto scaling trigger kind.
type AutoScalingTriggerKind string

const (
	// AverageLoad Indicates that scaling should be performed based on average load of all replicas in the
	// service.
	AverageLoad AutoScalingTriggerKind = "AverageLoad"
)

// PossibleAutoScalingTriggerKindValues returns an array of possible values for the AutoScalingTriggerKind const type.
func PossibleAutoScalingTriggerKindValues() []AutoScalingTriggerKind {
	return []AutoScalingTriggerKind{AverageLoad}
}

// BackupEntityKind enumerates the values for backup entity kind.
type BackupEntityKind string

const (
	// BackupEntityKindApplication Indicates the entity is a Service Fabric application.
	BackupEntityKindApplication BackupEntityKind = "Application"
	// BackupEntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the
	// invalid type.
	BackupEntityKindInvalid BackupEntityKind = "Invalid"
	// BackupEntityKindPartition Indicates the entity is a Service Fabric partition.
	BackupEntityKindPartition BackupEntityKind = "Partition"
	// BackupEntityKindService Indicates the entity is a Service Fabric service.
	BackupEntityKindService BackupEntityKind = "Service"
)

// PossibleBackupEntityKindValues returns an array of possible values for the BackupEntityKind const type.
func PossibleBackupEntityKindValues() []BackupEntityKind {
	return []BackupEntityKind{BackupEntityKindApplication, BackupEntityKindInvalid, BackupEntityKindPartition, BackupEntityKindService}
}

// BackupPolicyScope enumerates the values for backup policy scope.
type BackupPolicyScope string

const (
	// BackupPolicyScopeApplication Indicates the backup policy is applied at application level. All services
	// and partitions of the application inherit this policy unless explicitly overridden at service or
	// partition level.
	BackupPolicyScopeApplication BackupPolicyScope = "Application"
	// BackupPolicyScopeInvalid Indicates an invalid backup policy scope type. All Service Fabric enumerations
	// have the invalid type.
	BackupPolicyScopeInvalid BackupPolicyScope = "Invalid"
	// BackupPolicyScopePartition Indicates the backup policy is applied at partition level. Hence overriding
	// any policy which may have applied at partition's service or application level.
	BackupPolicyScopePartition BackupPolicyScope = "Partition"
	// BackupPolicyScopeService Indicates the backup policy is applied at service level. All partitions of the
	// service inherit this policy unless explicitly overridden at partition level.
	BackupPolicyScopeService BackupPolicyScope = "Service"
)

// PossibleBackupPolicyScopeValues returns an array of possible values for the BackupPolicyScope const type.
func PossibleBackupPolicyScopeValues() []BackupPolicyScope {
	return []BackupPolicyScope{BackupPolicyScopeApplication, BackupPolicyScopeInvalid, BackupPolicyScopePartition, BackupPolicyScopeService}
}

// BackupScheduleFrequencyType enumerates the values for backup schedule frequency type.
type BackupScheduleFrequencyType string

const (
	// BackupScheduleFrequencyTypeDaily Indicates that the time based backup schedule is repeated at a daily
	// frequency.
	BackupScheduleFrequencyTypeDaily BackupScheduleFrequencyType = "Daily"
	// BackupScheduleFrequencyTypeInvalid Indicates an invalid backup schedule frequency type. All Service
	// Fabric enumerations have the invalid type.
	BackupScheduleFrequencyTypeInvalid BackupScheduleFrequencyType = "Invalid"
	// BackupScheduleFrequencyTypeWeekly Indicates that the time based backup schedule is repeated at a weekly
	// frequency.
	BackupScheduleFrequencyTypeWeekly BackupScheduleFrequencyType = "Weekly"
)

// PossibleBackupScheduleFrequencyTypeValues returns an array of possible values for the BackupScheduleFrequencyType const type.
func PossibleBackupScheduleFrequencyTypeValues() []BackupScheduleFrequencyType {
	return []BackupScheduleFrequencyType{BackupScheduleFrequencyTypeDaily, BackupScheduleFrequencyTypeInvalid, BackupScheduleFrequencyTypeWeekly}
}

// BackupScheduleKind enumerates the values for backup schedule kind.
type BackupScheduleKind string

const (
	// BackupScheduleKindFrequencyBased Indicates a frequency-based backup schedule.
	BackupScheduleKindFrequencyBased BackupScheduleKind = "FrequencyBased"
	// BackupScheduleKindInvalid Indicates an invalid backup schedule kind. All Service Fabric enumerations
	// have the invalid type.
	BackupScheduleKindInvalid BackupScheduleKind = "Invalid"
	// BackupScheduleKindTimeBased Indicates a time-based backup schedule.
	BackupScheduleKindTimeBased BackupScheduleKind = "TimeBased"
)

// PossibleBackupScheduleKindValues returns an array of possible values for the BackupScheduleKind const type.
func PossibleBackupScheduleKindValues() []BackupScheduleKind {
	return []BackupScheduleKind{BackupScheduleKindFrequencyBased, BackupScheduleKindInvalid, BackupScheduleKindTimeBased}
}

// BackupState enumerates the values for backup state.
type BackupState string

const (
	// BackupStateAccepted Operation has been validated and accepted. Backup is yet to be triggered.
	BackupStateAccepted BackupState = "Accepted"
	// BackupStateBackupInProgress Backup operation has been triggered and is under process.
	BackupStateBackupInProgress BackupState = "BackupInProgress"
	// BackupStateFailure Operation completed with failure.
	BackupStateFailure BackupState = "Failure"
	// BackupStateInvalid Indicates an invalid backup state. All Service Fabric enumerations have the invalid
	// type.
	BackupStateInvalid BackupState = "Invalid"
	// BackupStateSuccess Operation completed with success.
	BackupStateSuccess BackupState = "Success"
	// BackupStateTimeout Operation timed out.
	BackupStateTimeout BackupState = "Timeout"
)

// PossibleBackupStateValues returns an array of possible values for the BackupState const type.
func PossibleBackupStateValues() []BackupState {
	return []BackupState{BackupStateAccepted, BackupStateBackupInProgress, BackupStateFailure, BackupStateInvalid, BackupStateSuccess, BackupStateTimeout}
}

// BackupStorageKind enumerates the values for backup storage kind.
type BackupStorageKind string

const (
	// BackupStorageKindAzureBlobStore Indicates Azure blob store to be used as backup storage.
	BackupStorageKindAzureBlobStore BackupStorageKind = "AzureBlobStore"
	// BackupStorageKindFileShare Indicates file/ SMB share to be used as backup storage.
	BackupStorageKindFileShare BackupStorageKind = "FileShare"
	// BackupStorageKindInvalid Indicates an invalid backup storage kind. All Service Fabric enumerations have
	// the invalid type.
	BackupStorageKindInvalid BackupStorageKind = "Invalid"
)

// PossibleBackupStorageKindValues returns an array of possible values for the BackupStorageKind const type.
func PossibleBackupStorageKindValues() []BackupStorageKind {
	return []BackupStorageKind{BackupStorageKindAzureBlobStore, BackupStorageKindFileShare, BackupStorageKindInvalid}
}

// BackupSuspensionScope enumerates the values for backup suspension scope.
type BackupSuspensionScope string

const (
	// BackupSuspensionScopeApplication Indicates the backup suspension is applied at application level. All
	// services and partitions of the application are hence suspended for backup.
	BackupSuspensionScopeApplication BackupSuspensionScope = "Application"
	// BackupSuspensionScopeInvalid Indicates an invalid backup suspension scope type also indicating entity is
	// not suspended. All Service Fabric enumerations have the invalid type.
	BackupSuspensionScopeInvalid BackupSuspensionScope = "Invalid"
	// BackupSuspensionScopePartition Indicates the backup suspension is applied at partition level.
	BackupSuspensionScopePartition BackupSuspensionScope = "Partition"
	// BackupSuspensionScopeService Indicates the backup suspension is applied at service level. All partitions
	// of the service are hence suspended for backup.
	BackupSuspensionScopeService BackupSuspensionScope = "Service"
)

// PossibleBackupSuspensionScopeValues returns an array of possible values for the BackupSuspensionScope const type.
func PossibleBackupSuspensionScopeValues() []BackupSuspensionScope {
	return []BackupSuspensionScope{BackupSuspensionScopeApplication, BackupSuspensionScopeInvalid, BackupSuspensionScopePartition, BackupSuspensionScopeService}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// BackupTypeFull Indicates a full backup.
	BackupTypeFull BackupType = "Full"
	// BackupTypeIncremental Indicates an incremental backup. A backup chain is comprised of a full backup
	// followed by 0 or more incremental backups.
	BackupTypeIncremental BackupType = "Incremental"
	// BackupTypeInvalid Indicates an invalid backup type. All Service Fabric enumerations have the invalid
	// type.
	BackupTypeInvalid BackupType = "Invalid"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{BackupTypeFull, BackupTypeIncremental, BackupTypeInvalid}
}

// ChaosEventKind enumerates the values for chaos event kind.
type ChaosEventKind string

const (
	// ChaosEventKindExecutingFaults Indicates a Chaos event that gets generated when Chaos has decided on the
	// faults for an iteration. This Chaos event contains the details of the faults as a list of strings.
	ChaosEventKindExecutingFaults ChaosEventKind = "ExecutingFaults"
	// ChaosEventKindInvalid Indicates an invalid Chaos event kind. All Service Fabric enumerations have the
	// invalid type.
	ChaosEventKindInvalid ChaosEventKind = "Invalid"
	// ChaosEventKindStarted Indicates a Chaos event that gets generated when Chaos is started.
	ChaosEventKindStarted ChaosEventKind = "Started"
	// ChaosEventKindStopped Indicates a Chaos event that gets generated when Chaos stops because either the
	// user issued a stop or the time to run was up.
	ChaosEventKindStopped ChaosEventKind = "Stopped"
	// ChaosEventKindTestError Indicates a Chaos event that gets generated when an unexpected event has
	// occurred in the Chaos engine, for example, due to the cluster snapshot being inconsistent, while
	// faulting a faultable entity Chaos found that the entity was already faulted.
	ChaosEventKindTestError ChaosEventKind = "TestError"
	// ChaosEventKindValidationFailed Indicates a Chaos event that gets generated when the cluster entities do
	// not become stable and healthy within ChaosParameters.MaxClusterStabilizationTimeoutInSeconds.
	ChaosEventKindValidationFailed ChaosEventKind = "ValidationFailed"
	// ChaosEventKindWaiting Indicates a Chaos event that gets generated when Chaos is waiting for the cluster
	// to become ready for faulting, for example, Chaos may be waiting for the on-going upgrade to finish.
	ChaosEventKindWaiting ChaosEventKind = "Waiting"
)

// PossibleChaosEventKindValues returns an array of possible values for the ChaosEventKind const type.
func PossibleChaosEventKindValues() []ChaosEventKind {
	return []ChaosEventKind{ChaosEventKindExecutingFaults, ChaosEventKindInvalid, ChaosEventKindStarted, ChaosEventKindStopped, ChaosEventKindTestError, ChaosEventKindValidationFailed, ChaosEventKindWaiting}
}

// ChaosScheduleStatus enumerates the values for chaos schedule status.
type ChaosScheduleStatus string

const (
	// ChaosScheduleStatusActive Indicates that the schedule is active and is being used to schedule runs of
	// Chaos. The value is two.
	ChaosScheduleStatusActive ChaosScheduleStatus = "Active"
	// ChaosScheduleStatusExpired Indicates that the schedule is expired and will no longer be used to schedule
	// runs of Chaos. The value is three.
	ChaosScheduleStatusExpired ChaosScheduleStatus = "Expired"
	// ChaosScheduleStatusInvalid Indicates an invalid Chaos Schedule status. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ChaosScheduleStatusInvalid ChaosScheduleStatus = "Invalid"
	// ChaosScheduleStatusPending Indicates that the schedule is pending and is not yet being used to schedule
	// runs of Chaos but will be used when the start time is passed. The value is four.
	ChaosScheduleStatusPending ChaosScheduleStatus = "Pending"
	// ChaosScheduleStatusStopped Indicates that the schedule is stopped and not being used to schedule runs of
	// chaos. The value is one.
	ChaosScheduleStatusStopped ChaosScheduleStatus = "Stopped"
)

// PossibleChaosScheduleStatusValues returns an array of possible values for the ChaosScheduleStatus const type.
func PossibleChaosScheduleStatusValues() []ChaosScheduleStatus {
	return []ChaosScheduleStatus{ChaosScheduleStatusActive, ChaosScheduleStatusExpired, ChaosScheduleStatusInvalid, ChaosScheduleStatusPending, ChaosScheduleStatusStopped}
}

// ChaosStatus enumerates the values for chaos status.
type ChaosStatus string

const (
	// ChaosStatusInvalid Indicates an invalid Chaos status. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	ChaosStatusInvalid ChaosStatus = "Invalid"
	// ChaosStatusRunning Indicates that Chaos is not stopped. The value is one.
	ChaosStatusRunning ChaosStatus = "Running"
	// ChaosStatusStopped Indicates that Chaos is not scheduling further faults. The value is two.
	ChaosStatusStopped ChaosStatus = "Stopped"
)

// PossibleChaosStatusValues returns an array of possible values for the ChaosStatus const type.
func PossibleChaosStatusValues() []ChaosStatus {
	return []ChaosStatus{ChaosStatusInvalid, ChaosStatusRunning, ChaosStatusStopped}
}

// ComposeDeploymentStatus enumerates the values for compose deployment status.
type ComposeDeploymentStatus string

const (
	// ComposeDeploymentStatusCreating Indicates that the compose deployment is being created in background.
	// The value is 2.
	ComposeDeploymentStatusCreating ComposeDeploymentStatus = "Creating"
	// ComposeDeploymentStatusDeleting Indicates that the compose deployment is being deleted in background.
	// The value is 5.
	ComposeDeploymentStatusDeleting ComposeDeploymentStatus = "Deleting"
	// ComposeDeploymentStatusFailed Indicates that the compose deployment was terminated due to persistent
	// failures. The value is 6.
	ComposeDeploymentStatusFailed ComposeDeploymentStatus = "Failed"
	// ComposeDeploymentStatusInvalid Indicates that the compose deployment status is invalid. The value is
	// zero.
	ComposeDeploymentStatusInvalid ComposeDeploymentStatus = "Invalid"
	// ComposeDeploymentStatusProvisioning Indicates that the compose deployment is being provisioned in
	// background. The value is 1.
	ComposeDeploymentStatusProvisioning ComposeDeploymentStatus = "Provisioning"
	// ComposeDeploymentStatusReady Indicates that the compose deployment has been successfully created or
	// upgraded. The value is 3.
	ComposeDeploymentStatusReady ComposeDeploymentStatus = "Ready"
	// ComposeDeploymentStatusUnprovisioning Indicates that the compose deployment is being unprovisioned in
	// background. The value is 4.
	ComposeDeploymentStatusUnprovisioning ComposeDeploymentStatus = "Unprovisioning"
	// ComposeDeploymentStatusUpgrading Indicates that the compose deployment is being upgraded in the
	// background. The value is 7.
	ComposeDeploymentStatusUpgrading ComposeDeploymentStatus = "Upgrading"
)

// PossibleComposeDeploymentStatusValues returns an array of possible values for the ComposeDeploymentStatus const type.
func PossibleComposeDeploymentStatusValues() []ComposeDeploymentStatus {
	return []ComposeDeploymentStatus{ComposeDeploymentStatusCreating, ComposeDeploymentStatusDeleting, ComposeDeploymentStatusFailed, ComposeDeploymentStatusInvalid, ComposeDeploymentStatusProvisioning, ComposeDeploymentStatusReady, ComposeDeploymentStatusUnprovisioning, ComposeDeploymentStatusUpgrading}
}

// ComposeDeploymentUpgradeState enumerates the values for compose deployment upgrade state.
type ComposeDeploymentUpgradeState string

const (
	// ComposeDeploymentUpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The
	// value is 9.
	ComposeDeploymentUpgradeStateFailed ComposeDeploymentUpgradeState = "Failed"
	// ComposeDeploymentUpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ComposeDeploymentUpgradeStateInvalid ComposeDeploymentUpgradeState = "Invalid"
	// ComposeDeploymentUpgradeStateProvisioningTarget The upgrade is in the progress of provisioning target
	// application type version. The value is 1.
	ComposeDeploymentUpgradeStateProvisioningTarget ComposeDeploymentUpgradeState = "ProvisioningTarget"
	// ComposeDeploymentUpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 8.
	ComposeDeploymentUpgradeStateRollingBackCompleted ComposeDeploymentUpgradeState = "RollingBackCompleted"
	// ComposeDeploymentUpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version
	// but is not complete yet. The value is 6.
	ComposeDeploymentUpgradeStateRollingBackInProgress ComposeDeploymentUpgradeState = "RollingBackInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value
	// is 5.
	ComposeDeploymentUpgradeStateRollingForwardCompleted ComposeDeploymentUpgradeState = "RollingForwardCompleted"
	// ComposeDeploymentUpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target
	// version but is not complete yet. The value is 2.
	ComposeDeploymentUpgradeStateRollingForwardInProgress ComposeDeploymentUpgradeState = "RollingForwardInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardPending The current upgrade domain has finished upgrading.
	// The overall upgrade is waiting for an explicit move next request in UnmonitoredManual mode or performing
	// health checks in Monitored mode. The value is 3
	ComposeDeploymentUpgradeStateRollingForwardPending ComposeDeploymentUpgradeState = "RollingForwardPending"
	// ComposeDeploymentUpgradeStateUnprovisioningCurrent The upgrade is in the progress of unprovisioning
	// current application type version and rolling forward to the target version is completed. The value is 4.
	ComposeDeploymentUpgradeStateUnprovisioningCurrent ComposeDeploymentUpgradeState = "UnprovisioningCurrent"
	// ComposeDeploymentUpgradeStateUnprovisioningTarget The upgrade is in the progress of unprovisioning
	// target application type version and rolling back to the current version is completed. The value is 7.
	ComposeDeploymentUpgradeStateUnprovisioningTarget ComposeDeploymentUpgradeState = "UnprovisioningTarget"
)

// PossibleComposeDeploymentUpgradeStateValues returns an array of possible values for the ComposeDeploymentUpgradeState const type.
func PossibleComposeDeploymentUpgradeStateValues() []ComposeDeploymentUpgradeState {
	return []ComposeDeploymentUpgradeState{ComposeDeploymentUpgradeStateFailed, ComposeDeploymentUpgradeStateInvalid, ComposeDeploymentUpgradeStateProvisioningTarget, ComposeDeploymentUpgradeStateRollingBackCompleted, ComposeDeploymentUpgradeStateRollingBackInProgress, ComposeDeploymentUpgradeStateRollingForwardCompleted, ComposeDeploymentUpgradeStateRollingForwardInProgress, ComposeDeploymentUpgradeStateRollingForwardPending, ComposeDeploymentUpgradeStateUnprovisioningCurrent, ComposeDeploymentUpgradeStateUnprovisioningTarget}
}

// CreateFabricDump enumerates the values for create fabric dump.
type CreateFabricDump string

const (
	// False ...
	False CreateFabricDump = "False"
	// True ...
	True CreateFabricDump = "True"
)

// PossibleCreateFabricDumpValues returns an array of possible values for the CreateFabricDump const type.
func PossibleCreateFabricDumpValues() []CreateFabricDump {
	return []CreateFabricDump{False, True}
}

// DataLossMode enumerates the values for data loss mode.
type DataLossMode string

const (
	// DataLossModeFullDataLoss FullDataLoss option will drop all the replicas which means that all the data
	// will be lost.
	DataLossModeFullDataLoss DataLossMode = "FullDataLoss"
	// DataLossModeInvalid Reserved.  Do not pass into API.
	DataLossModeInvalid DataLossMode = "Invalid"
	// DataLossModePartialDataLoss PartialDataLoss option will cause a quorum of replicas to go down,
	// triggering an OnDataLoss event in the system for the given partition.
	DataLossModePartialDataLoss DataLossMode = "PartialDataLoss"
)

// PossibleDataLossModeValues returns an array of possible values for the DataLossMode const type.
func PossibleDataLossModeValues() []DataLossMode {
	return []DataLossMode{DataLossModeFullDataLoss, DataLossModeInvalid, DataLossModePartialDataLoss}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday Indicates the Day referred is Friday.
	Friday DayOfWeek = "Friday"
	// Monday Indicates the Day referred is Monday.
	Monday DayOfWeek = "Monday"
	// Saturday Indicates the Day referred is Saturday.
	Saturday DayOfWeek = "Saturday"
	// Sunday Indicates the Day referred is Sunday.
	Sunday DayOfWeek = "Sunday"
	// Thursday Indicates the Day referred is Thursday.
	Thursday DayOfWeek = "Thursday"
	// Tuesday Indicates the Day referred is Tuesday.
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday Indicates the Day referred is Wednesday.
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DeactivationIntent enumerates the values for deactivation intent.
type DeactivationIntent string

const (
	// Pause Indicates that the node should be paused. The value is 1.
	Pause DeactivationIntent = "Pause"
	// RemoveData Indicates the intent is for the node to remove data. The value is 3.
	RemoveData DeactivationIntent = "RemoveData"
	// Restart Indicates that the intent is for the node to be restarted after a short period of time. The
	// value is 2.
	Restart DeactivationIntent = "Restart"
)

// PossibleDeactivationIntentValues returns an array of possible values for the DeactivationIntent const type.
func PossibleDeactivationIntentValues() []DeactivationIntent {
	return []DeactivationIntent{Pause, RemoveData, Restart}
}

// DeployedApplicationStatus enumerates the values for deployed application status.
type DeployedApplicationStatus string

const (
	// DeployedApplicationStatusActivating Indicates that the package is activating. The value is 2.
	DeployedApplicationStatusActivating DeployedApplicationStatus = "Activating"
	// DeployedApplicationStatusActive Indicates that the package is active. The value is 3.
	DeployedApplicationStatusActive DeployedApplicationStatus = "Active"
	// DeployedApplicationStatusDeactivating Indicates that the package is deactivating. The value is 5.
	DeployedApplicationStatusDeactivating DeployedApplicationStatus = "Deactivating"
	// DeployedApplicationStatusDownloading Indicates that the package is downloading from the ImageStore. The
	// value is 1.
	DeployedApplicationStatusDownloading DeployedApplicationStatus = "Downloading"
	// DeployedApplicationStatusInvalid Indicates that deployment status is not valid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	DeployedApplicationStatusInvalid DeployedApplicationStatus = "Invalid"
	// DeployedApplicationStatusUpgrading Indicates that the package is upgrading. The value is 4.
	DeployedApplicationStatusUpgrading DeployedApplicationStatus = "Upgrading"
)

// PossibleDeployedApplicationStatusValues returns an array of possible values for the DeployedApplicationStatus const type.
func PossibleDeployedApplicationStatusValues() []DeployedApplicationStatus {
	return []DeployedApplicationStatus{DeployedApplicationStatusActivating, DeployedApplicationStatusActive, DeployedApplicationStatusDeactivating, DeployedApplicationStatusDownloading, DeployedApplicationStatusInvalid, DeployedApplicationStatusUpgrading}
}

// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// DeploymentStatusActivating Indicates the application or service package is being activated. The value is
	// 2.
	DeploymentStatusActivating DeploymentStatus = "Activating"
	// DeploymentStatusActive Indicates the application or service package is active the node. The value is 3.
	DeploymentStatusActive DeploymentStatus = "Active"
	// DeploymentStatusDeactivating Indicates the application or service package is being deactivated. The
	// value is 5.
	DeploymentStatusDeactivating DeploymentStatus = "Deactivating"
	// DeploymentStatusDownloading Indicates the application or service package is being downloaded to the node
	// from the ImageStore. The value is 1.
	DeploymentStatusDownloading DeploymentStatus = "Downloading"
	// DeploymentStatusInvalid Indicates status of the application or service package is not known or invalid.
	// The value is 0.
	DeploymentStatusInvalid DeploymentStatus = "Invalid"
	// DeploymentStatusUpgrading Indicates the application or service package is being upgraded. The value is
	// 4.
	DeploymentStatusUpgrading DeploymentStatus = "Upgrading"
)

// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{DeploymentStatusActivating, DeploymentStatusActive, DeploymentStatusDeactivating, DeploymentStatusDownloading, DeploymentStatusInvalid, DeploymentStatusUpgrading}
}

// DiagnosticsSinkKind enumerates the values for diagnostics sink kind.
type DiagnosticsSinkKind string

const (
	// DiagnosticsSinkKindAzureInternalMonitoringPipeline Diagnostics settings for Geneva.
	DiagnosticsSinkKindAzureInternalMonitoringPipeline DiagnosticsSinkKind = "AzureInternalMonitoringPipeline"
	// DiagnosticsSinkKindInvalid Indicates an invalid sink kind. All Service Fabric enumerations have the
	// invalid type.
	DiagnosticsSinkKindInvalid DiagnosticsSinkKind = "Invalid"
)

// PossibleDiagnosticsSinkKindValues returns an array of possible values for the DiagnosticsSinkKind const type.
func PossibleDiagnosticsSinkKindValues() []DiagnosticsSinkKind {
	return []DiagnosticsSinkKind{DiagnosticsSinkKindAzureInternalMonitoringPipeline, DiagnosticsSinkKindInvalid}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindApplication Indicates the entity is a Service Fabric application. The value is 4.
	EntityKindApplication EntityKind = "Application"
	// EntityKindCluster Indicates the entity is a Service Fabric cluster. The value is 8.
	EntityKindCluster EntityKind = "Cluster"
	// EntityKindDeployedApplication Indicates the entity is a Service Fabric deployed application. The value
	// is 6.
	EntityKindDeployedApplication EntityKind = "DeployedApplication"
	// EntityKindDeployedServicePackage Indicates the entity is a Service Fabric deployed service package. The
	// value is 7.
	EntityKindDeployedServicePackage EntityKind = "DeployedServicePackage"
	// EntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	EntityKindInvalid EntityKind = "Invalid"
	// EntityKindNode Indicates the entity is a Service Fabric node. The value is 1.
	EntityKindNode EntityKind = "Node"
	// EntityKindPartition Indicates the entity is a Service Fabric partition. The value is 2.
	EntityKindPartition EntityKind = "Partition"
	// EntityKindReplica Indicates the entity is a Service Fabric replica. The value is 5.
	EntityKindReplica EntityKind = "Replica"
	// EntityKindService Indicates the entity is a Service Fabric service. The value is 3.
	EntityKindService EntityKind = "Service"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindApplication, EntityKindCluster, EntityKindDeployedApplication, EntityKindDeployedServicePackage, EntityKindInvalid, EntityKindNode, EntityKindPartition, EntityKindReplica, EntityKindService}
}

// EntityKindBasicBackupEntity enumerates the values for entity kind basic backup entity.
type EntityKindBasicBackupEntity string

const (
	// EntityKindApplication1 ...
	EntityKindApplication1 EntityKindBasicBackupEntity = "Application"
	// EntityKindBackupEntity ...
	EntityKindBackupEntity EntityKindBasicBackupEntity = "BackupEntity"
	// EntityKindPartition1 ...
	EntityKindPartition1 EntityKindBasicBackupEntity = "Partition"
	// EntityKindService1 ...
	EntityKindService1 EntityKindBasicBackupEntity = "Service"
)

// PossibleEntityKindBasicBackupEntityValues returns an array of possible values for the EntityKindBasicBackupEntity const type.
func PossibleEntityKindBasicBackupEntityValues() []EntityKindBasicBackupEntity {
	return []EntityKindBasicBackupEntity{EntityKindApplication1, EntityKindBackupEntity, EntityKindPartition1, EntityKindService1}
}

// EntryPointStatus enumerates the values for entry point status.
type EntryPointStatus string

const (
	// EntryPointStatusInvalid Indicates status of entry point is not known or invalid. The value is 0.
	EntryPointStatusInvalid EntryPointStatus = "Invalid"
	// EntryPointStatusPending Indicates the entry point is scheduled to be started. The value is 1.
	EntryPointStatusPending EntryPointStatus = "Pending"
	// EntryPointStatusStarted Indicates the entry point was started successfully and is running. The value is
	// 3.
	EntryPointStatusStarted EntryPointStatus = "Started"
	// EntryPointStatusStarting Indicates the entry point is being started. The value is 2.
	EntryPointStatusStarting EntryPointStatus = "Starting"
	// EntryPointStatusStopped Indicates the entry point is not running. The value is 5.
	EntryPointStatusStopped EntryPointStatus = "Stopped"
	// EntryPointStatusStopping Indicates the entry point is being stopped. The value is 4.
	EntryPointStatusStopping EntryPointStatus = "Stopping"
)

// PossibleEntryPointStatusValues returns an array of possible values for the EntryPointStatus const type.
func PossibleEntryPointStatusValues() []EntryPointStatus {
	return []EntryPointStatus{EntryPointStatusInvalid, EntryPointStatusPending, EntryPointStatusStarted, EntryPointStatusStarting, EntryPointStatusStopped, EntryPointStatusStopping}
}

// FabricErrorCodes enumerates the values for fabric error codes.
type FabricErrorCodes string

const (
	// EABORT ...
	EABORT FabricErrorCodes = "E_ABORT"
	// EFAIL ...
	EFAIL FabricErrorCodes = "E_FAIL"
	// EINVALIDARG ...
	EINVALIDARG FabricErrorCodes = "E_INVALIDARG"
	// FABRICEAPPLICATIONALREADYEXISTS ...
	FABRICEAPPLICATIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_APPLICATION_ALREADY_EXISTS"
	// FABRICEAPPLICATIONALREADYINTARGETVERSION ...
	FABRICEAPPLICATIONALREADYINTARGETVERSION FabricErrorCodes = "FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION"
	// FABRICEAPPLICATIONNOTFOUND ...
	FABRICEAPPLICATIONNOTFOUND FabricErrorCodes = "FABRIC_E_APPLICATION_NOT_FOUND"
	// FABRICEAPPLICATIONNOTUPGRADING ...
	FABRICEAPPLICATIONNOTUPGRADING FabricErrorCodes = "FABRIC_E_APPLICATION_NOT_UPGRADING"
	// FABRICEAPPLICATIONTYPEALREADYEXISTS ...
	FABRICEAPPLICATIONTYPEALREADYEXISTS FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS"
	// FABRICEAPPLICATIONTYPEINUSE ...
	FABRICEAPPLICATIONTYPEINUSE FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_IN_USE"
	// FABRICEAPPLICATIONTYPENOTFOUND ...
	FABRICEAPPLICATIONTYPENOTFOUND FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_NOT_FOUND"
	// FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS ...
	FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEINPROGRESS ...
	FABRICEAPPLICATIONUPGRADEINPROGRESS FabricErrorCodes = "FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEVALIDATIONERROR ...
	FABRICEAPPLICATIONUPGRADEVALIDATIONERROR FabricErrorCodes = "FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR"
	// FABRICEBACKUPINPROGRESS ...
	FABRICEBACKUPINPROGRESS FabricErrorCodes = "FABRIC_E_BACKUP_IN_PROGRESS"
	// FABRICEBACKUPISENABLED ...
	FABRICEBACKUPISENABLED FabricErrorCodes = "FABRIC_E_BACKUP_IS_ENABLED"
	// FABRICEBACKUPNOTENABLED ...
	FABRICEBACKUPNOTENABLED FabricErrorCodes = "FABRIC_E_BACKUP_NOT_ENABLED"
	// FABRICEBACKUPPOLICYALREADYEXISTING ...
	FABRICEBACKUPPOLICYALREADYEXISTING FabricErrorCodes = "FABRIC_E_BACKUP_POLICY_ALREADY_EXISTING"
	// FABRICEBACKUPPOLICYNOTEXISTING ...
	FABRICEBACKUPPOLICYNOTEXISTING FabricErrorCodes = "FABRIC_E_BACKUP_POLICY_NOT_EXISTING"
	// FABRICECOMMUNICATIONERROR ...
	FABRICECOMMUNICATIONERROR FabricErrorCodes = "FABRIC_E_COMMUNICATION_ERROR"
	// FABRICECONFIGURATIONPARAMETERNOTFOUND ...
	FABRICECONFIGURATIONPARAMETERNOTFOUND FabricErrorCodes = "FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND"
	// FABRICECONFIGURATIONSECTIONNOTFOUND ...
	FABRICECONFIGURATIONSECTIONNOTFOUND FabricErrorCodes = "FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND"
	// FABRICEDIRECTORYNOTFOUND ...
	FABRICEDIRECTORYNOTFOUND FabricErrorCodes = "FABRIC_E_DIRECTORY_NOT_FOUND"
	// FABRICEENUMERATIONCOMPLETED ...
	FABRICEENUMERATIONCOMPLETED FabricErrorCodes = "FABRIC_E_ENUMERATION_COMPLETED"
	// FABRICEFABRICALREADYINTARGETVERSION ...
	FABRICEFABRICALREADYINTARGETVERSION FabricErrorCodes = "FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION"
	// FABRICEFABRICNOTUPGRADING ...
	FABRICEFABRICNOTUPGRADING FabricErrorCodes = "FABRIC_E_FABRIC_NOT_UPGRADING"
	// FABRICEFABRICUPGRADEINPROGRESS ...
	FABRICEFABRICUPGRADEINPROGRESS FabricErrorCodes = "FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS"
	// FABRICEFABRICUPGRADEVALIDATIONERROR ...
	FABRICEFABRICUPGRADEVALIDATIONERROR FabricErrorCodes = "FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR"
	// FABRICEFABRICVERSIONALREADYEXISTS ...
	FABRICEFABRICVERSIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS"
	// FABRICEFABRICVERSIONINUSE ...
	FABRICEFABRICVERSIONINUSE FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_IN_USE"
	// FABRICEFABRICVERSIONNOTFOUND ...
	FABRICEFABRICVERSIONNOTFOUND FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_NOT_FOUND"
	// FABRICEFAULTANALYSISSERVICENOTEXISTING ...
	FABRICEFAULTANALYSISSERVICENOTEXISTING FabricErrorCodes = "FABRIC_E_FAULT_ANALYSIS_SERVICE_NOT_EXISTING"
	// FABRICEFILENOTFOUND ...
	FABRICEFILENOTFOUND FabricErrorCodes = "FABRIC_E_FILE_NOT_FOUND"
	// FABRICEHEALTHENTITYNOTFOUND ...
	FABRICEHEALTHENTITYNOTFOUND FabricErrorCodes = "FABRIC_E_HEALTH_ENTITY_NOT_FOUND"
	// FABRICEHEALTHSTALEREPORT ...
	FABRICEHEALTHSTALEREPORT FabricErrorCodes = "FABRIC_E_HEALTH_STALE_REPORT"
	// FABRICEIMAGEBUILDERRESERVEDDIRECTORYERROR ...
	FABRICEIMAGEBUILDERRESERVEDDIRECTORYERROR FabricErrorCodes = "FABRIC_E_IMAGEBUILDER_RESERVED_DIRECTORY_ERROR"
	// FABRICEIMAGEBUILDERVALIDATIONERROR ...
	FABRICEIMAGEBUILDERVALIDATIONERROR FabricErrorCodes = "FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR"
	// FABRICEINSTANCEIDMISMATCH ...
	FABRICEINSTANCEIDMISMATCH FabricErrorCodes = "FABRIC_E_INSTANCE_ID_MISMATCH"
	// FABRICEINVALIDADDRESS ...
	FABRICEINVALIDADDRESS FabricErrorCodes = "FABRIC_E_INVALID_ADDRESS"
	// FABRICEINVALIDATOMICGROUP ...
	FABRICEINVALIDATOMICGROUP FabricErrorCodes = "FABRIC_E_INVALID_ATOMIC_GROUP"
	// FABRICEINVALIDCONFIGURATION ...
	FABRICEINVALIDCONFIGURATION FabricErrorCodes = "FABRIC_E_INVALID_CONFIGURATION"
	// FABRICEINVALIDFORSTATELESSSERVICES ...
	FABRICEINVALIDFORSTATELESSSERVICES FabricErrorCodes = "FABRIC_E_INVALID_FOR_STATELESS_SERVICES"
	// FABRICEINVALIDNAMEURI ...
	FABRICEINVALIDNAMEURI FabricErrorCodes = "FABRIC_E_INVALID_NAME_URI"
	// FABRICEINVALIDPARTITIONKEY ...
	FABRICEINVALIDPARTITIONKEY FabricErrorCodes = "FABRIC_E_INVALID_PARTITION_KEY"
	// FABRICEINVALIDSERVICESCALINGPOLICY ...
	FABRICEINVALIDSERVICESCALINGPOLICY FabricErrorCodes = "FABRIC_E_INVALID_SERVICE_SCALING_POLICY"
	// FABRICEKEYNOTFOUND ...
	FABRICEKEYNOTFOUND FabricErrorCodes = "FABRIC_E_KEY_NOT_FOUND"
	// FABRICEKEYTOOLARGE ...
	FABRICEKEYTOOLARGE FabricErrorCodes = "FABRIC_E_KEY_TOO_LARGE"
	// FABRICENAMEALREADYEXISTS ...
	FABRICENAMEALREADYEXISTS FabricErrorCodes = "FABRIC_E_NAME_ALREADY_EXISTS"
	// FABRICENAMEDOESNOTEXIST ...
	FABRICENAMEDOESNOTEXIST FabricErrorCodes = "FABRIC_E_NAME_DOES_NOT_EXIST"
	// FABRICENAMENOTEMPTY ...
	FABRICENAMENOTEMPTY FabricErrorCodes = "FABRIC_E_NAME_NOT_EMPTY"
	// FABRICENODEHASNOTSTOPPEDYET ...
	FABRICENODEHASNOTSTOPPEDYET FabricErrorCodes = "FABRIC_E_NODE_HAS_NOT_STOPPED_YET"
	// FABRICENODEISUP ...
	FABRICENODEISUP FabricErrorCodes = "FABRIC_E_NODE_IS_UP"
	// FABRICENODENOTFOUND ...
	FABRICENODENOTFOUND FabricErrorCodes = "FABRIC_E_NODE_NOT_FOUND"
	// FABRICENOTPRIMARY ...
	FABRICENOTPRIMARY FabricErrorCodes = "FABRIC_E_NOT_PRIMARY"
	// FABRICENOTREADY ...
	FABRICENOTREADY FabricErrorCodes = "FABRIC_E_NOT_READY"
	// FABRICENOWRITEQUORUM ...
	FABRICENOWRITEQUORUM FabricErrorCodes = "FABRIC_E_NO_WRITE_QUORUM"
	// FABRICEOPERATIONNOTCOMPLETE ...
	FABRICEOPERATIONNOTCOMPLETE FabricErrorCodes = "FABRIC_E_OPERATION_NOT_COMPLETE"
	// FABRICEPARTITIONNOTFOUND ...
	FABRICEPARTITIONNOTFOUND FabricErrorCodes = "FABRIC_E_PARTITION_NOT_FOUND"
	// FABRICEPATHTOOLONG ...
	FABRICEPATHTOOLONG FabricErrorCodes = "FABRIC_E_PATH_TOO_LONG"
	// FABRICEPROPERTYCHECKFAILED ...
	FABRICEPROPERTYCHECKFAILED FabricErrorCodes = "FABRIC_E_PROPERTY_CHECK_FAILED"
	// FABRICEPROPERTYDOESNOTEXIST ...
	FABRICEPROPERTYDOESNOTEXIST FabricErrorCodes = "FABRIC_E_PROPERTY_DOES_NOT_EXIST"
	// FABRICERECONFIGURATIONPENDING ...
	FABRICERECONFIGURATIONPENDING FabricErrorCodes = "FABRIC_E_RECONFIGURATION_PENDING"
	// FABRICEREPLICADOESNOTEXIST ...
	FABRICEREPLICADOESNOTEXIST FabricErrorCodes = "FABRIC_E_REPLICA_DOES_NOT_EXIST"
	// FABRICERESTOREINPROGRESS ...
	FABRICERESTOREINPROGRESS FabricErrorCodes = "FABRIC_E_RESTORE_IN_PROGRESS"
	// FABRICERESTORESOURCETARGETPARTITIONMISMATCH ...
	FABRICERESTORESOURCETARGETPARTITIONMISMATCH FabricErrorCodes = "FABRIC_E_RESTORE_SOURCE_TARGET_PARTITION_MISMATCH"
	// FABRICESEQUENCENUMBERCHECKFAILED ...
	FABRICESEQUENCENUMBERCHECKFAILED FabricErrorCodes = "FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED"
	// FABRICESERVICEAFFINITYCHAINNOTSUPPORTED ...
	FABRICESERVICEAFFINITYCHAINNOTSUPPORTED FabricErrorCodes = "FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED"
	// FABRICESERVICEALREADYEXISTS ...
	FABRICESERVICEALREADYEXISTS FabricErrorCodes = "FABRIC_E_SERVICE_ALREADY_EXISTS"
	// FABRICESERVICEDOESNOTEXIST ...
	FABRICESERVICEDOESNOTEXIST FabricErrorCodes = "FABRIC_E_SERVICE_DOES_NOT_EXIST"
	// FABRICESERVICEGROUPALREADYEXISTS ...
	FABRICESERVICEGROUPALREADYEXISTS FabricErrorCodes = "FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS"
	// FABRICESERVICEGROUPDOESNOTEXIST ...
	FABRICESERVICEGROUPDOESNOTEXIST FabricErrorCodes = "FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST"
	// FABRICESERVICEMANIFESTNOTFOUND ...
	FABRICESERVICEMANIFESTNOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_MANIFEST_NOT_FOUND"
	// FABRICESERVICEMETADATAMISMATCH ...
	FABRICESERVICEMETADATAMISMATCH FabricErrorCodes = "FABRIC_E_SERVICE_METADATA_MISMATCH"
	// FABRICESERVICEOFFLINE ...
	FABRICESERVICEOFFLINE FabricErrorCodes = "FABRIC_E_SERVICE_OFFLINE"
	// FABRICESERVICETYPEMISMATCH ...
	FABRICESERVICETYPEMISMATCH FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_MISMATCH"
	// FABRICESERVICETYPENOTFOUND ...
	FABRICESERVICETYPENOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_NOT_FOUND"
	// FABRICESERVICETYPETEMPLATENOTFOUND ...
	FABRICESERVICETYPETEMPLATENOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND"
	// FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS ...
	FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_SINGLE_INSTANCE_APPLICATION_ALREADY_EXISTS"
	// FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND ...
	FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND FabricErrorCodes = "FABRIC_E_SINGLE_INSTANCE_APPLICATION_NOT_FOUND"
	// FABRICETIMEOUT ...
	FABRICETIMEOUT FabricErrorCodes = "FABRIC_E_TIMEOUT"
	// FABRICEVALUEEMPTY ...
	FABRICEVALUEEMPTY FabricErrorCodes = "FABRIC_E_VALUE_EMPTY"
	// FABRICEVALUETOOLARGE ...
	FABRICEVALUETOOLARGE FabricErrorCodes = "FABRIC_E_VALUE_TOO_LARGE"
	// FABRICEVOLUMEALREADYEXISTS ...
	FABRICEVOLUMEALREADYEXISTS FabricErrorCodes = "FABRIC_E_VOLUME_ALREADY_EXISTS"
	// FABRICEVOLUMENOTFOUND ...
	FABRICEVOLUMENOTFOUND FabricErrorCodes = "FABRIC_E_VOLUME_NOT_FOUND"
	// SerializationError ...
	SerializationError FabricErrorCodes = "SerializationError"
)

// PossibleFabricErrorCodesValues returns an array of possible values for the FabricErrorCodes const type.
func PossibleFabricErrorCodesValues() []FabricErrorCodes {
	return []FabricErrorCodes{EABORT, EFAIL, EINVALIDARG, FABRICEAPPLICATIONALREADYEXISTS, FABRICEAPPLICATIONALREADYINTARGETVERSION, FABRICEAPPLICATIONNOTFOUND, FABRICEAPPLICATIONNOTUPGRADING, FABRICEAPPLICATIONTYPEALREADYEXISTS, FABRICEAPPLICATIONTYPEINUSE, FABRICEAPPLICATIONTYPENOTFOUND, FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS, FABRICEAPPLICATIONUPGRADEINPROGRESS, FABRICEAPPLICATIONUPGRADEVALIDATIONERROR, FABRICEBACKUPINPROGRESS, FABRICEBACKUPISENABLED, FABRICEBACKUPNOTENABLED, FABRICEBACKUPPOLICYALREADYEXISTING, FABRICEBACKUPPOLICYNOTEXISTING, FABRICECOMMUNICATIONERROR, FABRICECONFIGURATIONPARAMETERNOTFOUND, FABRICECONFIGURATIONSECTIONNOTFOUND, FABRICEDIRECTORYNOTFOUND, FABRICEENUMERATIONCOMPLETED, FABRICEFABRICALREADYINTARGETVERSION, FABRICEFABRICNOTUPGRADING, FABRICEFABRICUPGRADEINPROGRESS, FABRICEFABRICUPGRADEVALIDATIONERROR, FABRICEFABRICVERSIONALREADYEXISTS, FABRICEFABRICVERSIONINUSE, FABRICEFABRICVERSIONNOTFOUND, FABRICEFAULTANALYSISSERVICENOTEXISTING, FABRICEFILENOTFOUND, FABRICEHEALTHENTITYNOTFOUND, FABRICEHEALTHSTALEREPORT, FABRICEIMAGEBUILDERRESERVEDDIRECTORYERROR, FABRICEIMAGEBUILDERVALIDATIONERROR, FABRICEINSTANCEIDMISMATCH, FABRICEINVALIDADDRESS, FABRICEINVALIDATOMICGROUP, FABRICEINVALIDCONFIGURATION, FABRICEINVALIDFORSTATELESSSERVICES, FABRICEINVALIDNAMEURI, FABRICEINVALIDPARTITIONKEY, FABRICEINVALIDSERVICESCALINGPOLICY, FABRICEKEYNOTFOUND, FABRICEKEYTOOLARGE, FABRICENAMEALREADYEXISTS, FABRICENAMEDOESNOTEXIST, FABRICENAMENOTEMPTY, FABRICENODEHASNOTSTOPPEDYET, FABRICENODEISUP, FABRICENODENOTFOUND, FABRICENOTPRIMARY, FABRICENOTREADY, FABRICENOWRITEQUORUM, FABRICEOPERATIONNOTCOMPLETE, FABRICEPARTITIONNOTFOUND, FABRICEPATHTOOLONG, FABRICEPROPERTYCHECKFAILED, FABRICEPROPERTYDOESNOTEXIST, FABRICERECONFIGURATIONPENDING, FABRICEREPLICADOESNOTEXIST, FABRICERESTOREINPROGRESS, FABRICERESTORESOURCETARGETPARTITIONMISMATCH, FABRICESEQUENCENUMBERCHECKFAILED, FABRICESERVICEAFFINITYCHAINNOTSUPPORTED, FABRICESERVICEALREADYEXISTS, FABRICESERVICEDOESNOTEXIST, FABRICESERVICEGROUPALREADYEXISTS, FABRICESERVICEGROUPDOESNOTEXIST, FABRICESERVICEMANIFESTNOTFOUND, FABRICESERVICEMETADATAMISMATCH, FABRICESERVICEOFFLINE, FABRICESERVICETYPEMISMATCH, FABRICESERVICETYPENOTFOUND, FABRICESERVICETYPETEMPLATENOTFOUND, FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS, FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND, FABRICETIMEOUT, FABRICEVALUEEMPTY, FABRICEVALUETOOLARGE, FABRICEVOLUMEALREADYEXISTS, FABRICEVOLUMENOTFOUND, SerializationError}
}

// FabricEventKind enumerates the values for fabric event kind.
type FabricEventKind string

const (
	// FabricEventKindApplicationContainerInstanceExited ...
	FabricEventKindApplicationContainerInstanceExited FabricEventKind = "ApplicationContainerInstanceExited"
	// FabricEventKindApplicationCreated ...
	FabricEventKindApplicationCreated FabricEventKind = "ApplicationCreated"
	// FabricEventKindApplicationDeleted ...
	FabricEventKindApplicationDeleted FabricEventKind = "ApplicationDeleted"
	// FabricEventKindApplicationEvent ...
	FabricEventKindApplicationEvent FabricEventKind = "ApplicationEvent"
	// FabricEventKindApplicationHealthReportExpired ...
	FabricEventKindApplicationHealthReportExpired FabricEventKind = "ApplicationHealthReportExpired"
	// FabricEventKindApplicationNewHealthReport ...
	FabricEventKindApplicationNewHealthReport FabricEventKind = "ApplicationNewHealthReport"
	// FabricEventKindApplicationProcessExited ...
	FabricEventKindApplicationProcessExited FabricEventKind = "ApplicationProcessExited"
	// FabricEventKindApplicationUpgradeCompleted ...
	FabricEventKindApplicationUpgradeCompleted FabricEventKind = "ApplicationUpgradeCompleted"
	// FabricEventKindApplicationUpgradeDomainCompleted ...
	FabricEventKindApplicationUpgradeDomainCompleted FabricEventKind = "ApplicationUpgradeDomainCompleted"
	// FabricEventKindApplicationUpgradeRollbackCompleted ...
	FabricEventKindApplicationUpgradeRollbackCompleted FabricEventKind = "ApplicationUpgradeRollbackCompleted"
	// FabricEventKindApplicationUpgradeRollbackStarted ...
	FabricEventKindApplicationUpgradeRollbackStarted FabricEventKind = "ApplicationUpgradeRollbackStarted"
	// FabricEventKindApplicationUpgradeStarted ...
	FabricEventKindApplicationUpgradeStarted FabricEventKind = "ApplicationUpgradeStarted"
	// FabricEventKindChaosCodePackageRestartScheduled ...
	FabricEventKindChaosCodePackageRestartScheduled FabricEventKind = "ChaosCodePackageRestartScheduled"
	// FabricEventKindChaosNodeRestartScheduled ...
	FabricEventKindChaosNodeRestartScheduled FabricEventKind = "ChaosNodeRestartScheduled"
	// FabricEventKindChaosPartitionPrimaryMoveScheduled ...
	FabricEventKindChaosPartitionPrimaryMoveScheduled FabricEventKind = "ChaosPartitionPrimaryMoveScheduled"
	// FabricEventKindChaosPartitionSecondaryMoveScheduled ...
	FabricEventKindChaosPartitionSecondaryMoveScheduled FabricEventKind = "ChaosPartitionSecondaryMoveScheduled"
	// FabricEventKindChaosReplicaRemovalScheduled ...
	FabricEventKindChaosReplicaRemovalScheduled FabricEventKind = "ChaosReplicaRemovalScheduled"
	// FabricEventKindChaosReplicaRestartScheduled ...
	FabricEventKindChaosReplicaRestartScheduled FabricEventKind = "ChaosReplicaRestartScheduled"
	// FabricEventKindChaosStarted ...
	FabricEventKindChaosStarted FabricEventKind = "ChaosStarted"
	// FabricEventKindChaosStopped ...
	FabricEventKindChaosStopped FabricEventKind = "ChaosStopped"
	// FabricEventKindClusterEvent ...
	FabricEventKindClusterEvent FabricEventKind = "ClusterEvent"
	// FabricEventKindClusterHealthReportExpired ...
	FabricEventKindClusterHealthReportExpired FabricEventKind = "ClusterHealthReportExpired"
	// FabricEventKindClusterNewHealthReport ...
	FabricEventKindClusterNewHealthReport FabricEventKind = "ClusterNewHealthReport"
	// FabricEventKindClusterUpgradeCompleted ...
	FabricEventKindClusterUpgradeCompleted FabricEventKind = "ClusterUpgradeCompleted"
	// FabricEventKindClusterUpgradeDomainCompleted ...
	FabricEventKindClusterUpgradeDomainCompleted FabricEventKind = "ClusterUpgradeDomainCompleted"
	// FabricEventKindClusterUpgradeRollbackCompleted ...
	FabricEventKindClusterUpgradeRollbackCompleted FabricEventKind = "ClusterUpgradeRollbackCompleted"
	// FabricEventKindClusterUpgradeRollbackStarted ...
	FabricEventKindClusterUpgradeRollbackStarted FabricEventKind = "ClusterUpgradeRollbackStarted"
	// FabricEventKindClusterUpgradeStarted ...
	FabricEventKindClusterUpgradeStarted FabricEventKind = "ClusterUpgradeStarted"
	// FabricEventKindContainerInstanceEvent ...
	FabricEventKindContainerInstanceEvent FabricEventKind = "ContainerInstanceEvent"
	// FabricEventKindDeployedApplicationHealthReportExpired ...
	FabricEventKindDeployedApplicationHealthReportExpired FabricEventKind = "DeployedApplicationHealthReportExpired"
	// FabricEventKindDeployedApplicationNewHealthReport ...
	FabricEventKindDeployedApplicationNewHealthReport FabricEventKind = "DeployedApplicationNewHealthReport"
	// FabricEventKindDeployedServicePackageHealthReportExpired ...
	FabricEventKindDeployedServicePackageHealthReportExpired FabricEventKind = "DeployedServicePackageHealthReportExpired"
	// FabricEventKindDeployedServicePackageNewHealthReport ...
	FabricEventKindDeployedServicePackageNewHealthReport FabricEventKind = "DeployedServicePackageNewHealthReport"
	// FabricEventKindNodeAborted ...
	FabricEventKindNodeAborted FabricEventKind = "NodeAborted"
	// FabricEventKindNodeAddedToCluster ...
	FabricEventKindNodeAddedToCluster FabricEventKind = "NodeAddedToCluster"
	// FabricEventKindNodeClosed ...
	FabricEventKindNodeClosed FabricEventKind = "NodeClosed"
	// FabricEventKindNodeDeactivateCompleted ...
	FabricEventKindNodeDeactivateCompleted FabricEventKind = "NodeDeactivateCompleted"
	// FabricEventKindNodeDeactivateStarted ...
	FabricEventKindNodeDeactivateStarted FabricEventKind = "NodeDeactivateStarted"
	// FabricEventKindNodeDown ...
	FabricEventKindNodeDown FabricEventKind = "NodeDown"
	// FabricEventKindNodeEvent ...
	FabricEventKindNodeEvent FabricEventKind = "NodeEvent"
	// FabricEventKindNodeHealthReportExpired ...
	FabricEventKindNodeHealthReportExpired FabricEventKind = "NodeHealthReportExpired"
	// FabricEventKindNodeNewHealthReport ...
	FabricEventKindNodeNewHealthReport FabricEventKind = "NodeNewHealthReport"
	// FabricEventKindNodeOpenFailed ...
	FabricEventKindNodeOpenFailed FabricEventKind = "NodeOpenFailed"
	// FabricEventKindNodeOpenSucceeded ...
	FabricEventKindNodeOpenSucceeded FabricEventKind = "NodeOpenSucceeded"
	// FabricEventKindNodeRemovedFromCluster ...
	FabricEventKindNodeRemovedFromCluster FabricEventKind = "NodeRemovedFromCluster"
	// FabricEventKindNodeUp ...
	FabricEventKindNodeUp FabricEventKind = "NodeUp"
	// FabricEventKindPartitionAnalysisEvent ...
	FabricEventKindPartitionAnalysisEvent FabricEventKind = "PartitionAnalysisEvent"
	// FabricEventKindPartitionEvent ...
	FabricEventKindPartitionEvent FabricEventKind = "PartitionEvent"
	// FabricEventKindPartitionHealthReportExpired ...
	FabricEventKindPartitionHealthReportExpired FabricEventKind = "PartitionHealthReportExpired"
	// FabricEventKindPartitionNewHealthReport ...
	FabricEventKindPartitionNewHealthReport FabricEventKind = "PartitionNewHealthReport"
	// FabricEventKindPartitionPrimaryMoveAnalysis ...
	FabricEventKindPartitionPrimaryMoveAnalysis FabricEventKind = "PartitionPrimaryMoveAnalysis"
	// FabricEventKindPartitionReconfigured ...
	FabricEventKindPartitionReconfigured FabricEventKind = "PartitionReconfigured"
	// FabricEventKindReplicaEvent ...
	FabricEventKindReplicaEvent FabricEventKind = "ReplicaEvent"
	// FabricEventKindServiceCreated ...
	FabricEventKindServiceCreated FabricEventKind = "ServiceCreated"
	// FabricEventKindServiceDeleted ...
	FabricEventKindServiceDeleted FabricEventKind = "ServiceDeleted"
	// FabricEventKindServiceEvent ...
	FabricEventKindServiceEvent FabricEventKind = "ServiceEvent"
	// FabricEventKindServiceHealthReportExpired ...
	FabricEventKindServiceHealthReportExpired FabricEventKind = "ServiceHealthReportExpired"
	// FabricEventKindServiceNewHealthReport ...
	FabricEventKindServiceNewHealthReport FabricEventKind = "ServiceNewHealthReport"
	// FabricEventKindStatefulReplicaHealthReportExpired ...
	FabricEventKindStatefulReplicaHealthReportExpired FabricEventKind = "StatefulReplicaHealthReportExpired"
	// FabricEventKindStatefulReplicaNewHealthReport ...
	FabricEventKindStatefulReplicaNewHealthReport FabricEventKind = "StatefulReplicaNewHealthReport"
	// FabricEventKindStatelessReplicaHealthReportExpired ...
	FabricEventKindStatelessReplicaHealthReportExpired FabricEventKind = "StatelessReplicaHealthReportExpired"
	// FabricEventKindStatelessReplicaNewHealthReport ...
	FabricEventKindStatelessReplicaNewHealthReport FabricEventKind = "StatelessReplicaNewHealthReport"
)

// PossibleFabricEventKindValues returns an array of possible values for the FabricEventKind const type.
func PossibleFabricEventKindValues() []FabricEventKind {
	return []FabricEventKind{FabricEventKindApplicationContainerInstanceExited, FabricEventKindApplicationCreated, FabricEventKindApplicationDeleted, FabricEventKindApplicationEvent, FabricEventKindApplicationHealthReportExpired, FabricEventKindApplicationNewHealthReport, FabricEventKindApplicationProcessExited, FabricEventKindApplicationUpgradeCompleted, FabricEventKindApplicationUpgradeDomainCompleted, FabricEventKindApplicationUpgradeRollbackCompleted, FabricEventKindApplicationUpgradeRollbackStarted, FabricEventKindApplicationUpgradeStarted, FabricEventKindChaosCodePackageRestartScheduled, FabricEventKindChaosNodeRestartScheduled, FabricEventKindChaosPartitionPrimaryMoveScheduled, FabricEventKindChaosPartitionSecondaryMoveScheduled, FabricEventKindChaosReplicaRemovalScheduled, FabricEventKindChaosReplicaRestartScheduled, FabricEventKindChaosStarted, FabricEventKindChaosStopped, FabricEventKindClusterEvent, FabricEventKindClusterHealthReportExpired, FabricEventKindClusterNewHealthReport, FabricEventKindClusterUpgradeCompleted, FabricEventKindClusterUpgradeDomainCompleted, FabricEventKindClusterUpgradeRollbackCompleted, FabricEventKindClusterUpgradeRollbackStarted, FabricEventKindClusterUpgradeStarted, FabricEventKindContainerInstanceEvent, FabricEventKindDeployedApplicationHealthReportExpired, FabricEventKindDeployedApplicationNewHealthReport, FabricEventKindDeployedServicePackageHealthReportExpired, FabricEventKindDeployedServicePackageNewHealthReport, FabricEventKindNodeAborted, FabricEventKindNodeAddedToCluster, FabricEventKindNodeClosed, FabricEventKindNodeDeactivateCompleted, FabricEventKindNodeDeactivateStarted, FabricEventKindNodeDown, FabricEventKindNodeEvent, FabricEventKindNodeHealthReportExpired, FabricEventKindNodeNewHealthReport, FabricEventKindNodeOpenFailed, FabricEventKindNodeOpenSucceeded, FabricEventKindNodeRemovedFromCluster, FabricEventKindNodeUp, FabricEventKindPartitionAnalysisEvent, FabricEventKindPartitionEvent, FabricEventKindPartitionHealthReportExpired, FabricEventKindPartitionNewHealthReport, FabricEventKindPartitionPrimaryMoveAnalysis, FabricEventKindPartitionReconfigured, FabricEventKindReplicaEvent, FabricEventKindServiceCreated, FabricEventKindServiceDeleted, FabricEventKindServiceEvent, FabricEventKindServiceHealthReportExpired, FabricEventKindServiceNewHealthReport, FabricEventKindStatefulReplicaHealthReportExpired, FabricEventKindStatefulReplicaNewHealthReport, FabricEventKindStatelessReplicaHealthReportExpired, FabricEventKindStatelessReplicaNewHealthReport}
}

// FabricReplicaStatus enumerates the values for fabric replica status.
type FabricReplicaStatus string

const (
	// FabricReplicaStatusDown Indicates that the replica is down.
	FabricReplicaStatusDown FabricReplicaStatus = "Down"
	// FabricReplicaStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	FabricReplicaStatusInvalid FabricReplicaStatus = "Invalid"
	// FabricReplicaStatusUp Indicates that the replica is up.
	FabricReplicaStatusUp FabricReplicaStatus = "Up"
)

// PossibleFabricReplicaStatusValues returns an array of possible values for the FabricReplicaStatus const type.
func PossibleFabricReplicaStatusValues() []FabricReplicaStatus {
	return []FabricReplicaStatus{FabricReplicaStatusDown, FabricReplicaStatusInvalid, FabricReplicaStatusUp}
}

// FailureAction enumerates the values for failure action.
type FailureAction string

const (
	// FailureActionInvalid Indicates the failure action is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	FailureActionInvalid FailureAction = "Invalid"
	// FailureActionManual The upgrade will switch to UnmonitoredManual upgrade mode. The value is 2
	FailureActionManual FailureAction = "Manual"
	// FailureActionRollback The upgrade will start rolling back automatically. The value is 1
	FailureActionRollback FailureAction = "Rollback"
)

// PossibleFailureActionValues returns an array of possible values for the FailureAction const type.
func PossibleFailureActionValues() []FailureAction {
	return []FailureAction{FailureActionInvalid, FailureActionManual, FailureActionRollback}
}

// FailureReason enumerates the values for failure reason.
type FailureReason string

const (
	// HealthCheck The upgrade failed due to health policy violations. The value is 2
	HealthCheck FailureReason = "HealthCheck"
	// Interrupted There was an external request to roll back the upgrade. The value is 1
	Interrupted FailureReason = "Interrupted"
	// None Indicates the reason is invalid or unknown. All Service Fabric enumerations have the invalid type.
	// The value is zero.
	None FailureReason = "None"
	// OverallUpgradeTimeout The overall upgrade took longer than the allowed upgrade timeout to process. The
	// value is 4
	OverallUpgradeTimeout FailureReason = "OverallUpgradeTimeout"
	// UpgradeDomainTimeout An upgrade domain took longer than the allowed upgrade domain timeout to process.
	// The value is 3
	UpgradeDomainTimeout FailureReason = "UpgradeDomainTimeout"
)

// PossibleFailureReasonValues returns an array of possible values for the FailureReason const type.
func PossibleFailureReasonValues() []FailureReason {
	return []FailureReason{HealthCheck, Interrupted, None, OverallUpgradeTimeout, UpgradeDomainTimeout}
}

// HeaderMatchType enumerates the values for header match type.
type HeaderMatchType string

const (
	// Exact ...
	Exact HeaderMatchType = "exact"
)

// PossibleHeaderMatchTypeValues returns an array of possible values for the HeaderMatchType const type.
func PossibleHeaderMatchTypeValues() []HeaderMatchType {
	return []HeaderMatchType{Exact}
}

// HealthEvaluationKind enumerates the values for health evaluation kind.
type HealthEvaluationKind string

const (
	// HealthEvaluationKindApplication Indicates that the health evaluation is for an application. The value is
	// 18.
	HealthEvaluationKindApplication HealthEvaluationKind = "Application"
	// HealthEvaluationKindApplications Indicates that the health evaluation is for the cluster applications.
	// The value is 8.
	HealthEvaluationKindApplications HealthEvaluationKind = "Applications"
	// HealthEvaluationKindApplicationTypeApplications – Indicates that the health evaluation is for
	// applications of an application type. The value is 21.
	HealthEvaluationKindApplicationTypeApplications HealthEvaluationKind = "ApplicationTypeApplications"
	// HealthEvaluationKindDeltaNodesCheck Indicates that the health evaluation is for the delta of unhealthy
	// cluster nodes. The value is 19.
	HealthEvaluationKindDeltaNodesCheck HealthEvaluationKind = "DeltaNodesCheck"
	// HealthEvaluationKindDeployedApplication Indicates that the health evaluation is for a deployed
	// application. The value is 17.
	HealthEvaluationKindDeployedApplication HealthEvaluationKind = "DeployedApplication"
	// HealthEvaluationKindDeployedApplications Indicates that the health evaluation is for the deployed
	// applications of an application. The value is 5.
	HealthEvaluationKindDeployedApplications HealthEvaluationKind = "DeployedApplications"
	// HealthEvaluationKindDeployedServicePackage Indicates that the health evaluation is for a deployed
	// service package. The value is 16.
	HealthEvaluationKindDeployedServicePackage HealthEvaluationKind = "DeployedServicePackage"
	// HealthEvaluationKindDeployedServicePackages Indicates that the health evaluation is for the deployed
	// service packages of a deployed application. The value is 4.
	HealthEvaluationKindDeployedServicePackages HealthEvaluationKind = "DeployedServicePackages"
	// HealthEvaluationKindEvent Indicates that the health evaluation is for a health event. The value is 1.
	HealthEvaluationKindEvent HealthEvaluationKind = "Event"
	// HealthEvaluationKindInvalid Indicates that the health evaluation is invalid. The value is zero.
	HealthEvaluationKindInvalid HealthEvaluationKind = "Invalid"
	// HealthEvaluationKindNode Indicates that the health evaluation is for a node. The value is 12.
	HealthEvaluationKindNode HealthEvaluationKind = "Node"
	// HealthEvaluationKindNodes Indicates that the health evaluation is for the cluster nodes. The value is 7.
	HealthEvaluationKindNodes HealthEvaluationKind = "Nodes"
	// HealthEvaluationKindPartition Indicates that the health evaluation is for a partition. The value is 14.
	HealthEvaluationKindPartition HealthEvaluationKind = "Partition"
	// HealthEvaluationKindPartitions Indicates that the health evaluation is for the partitions of a service.
	// The value is 3.
	HealthEvaluationKindPartitions HealthEvaluationKind = "Partitions"
	// HealthEvaluationKindReplica Indicates that the health evaluation is for a replica. The value is 13.
	HealthEvaluationKindReplica HealthEvaluationKind = "Replica"
	// HealthEvaluationKindReplicas Indicates that the health evaluation is for the replicas of a partition.
	// The value is 2.
	HealthEvaluationKindReplicas HealthEvaluationKind = "Replicas"
	// HealthEvaluationKindService Indicates that the health evaluation is for a service. The value is 15.
	HealthEvaluationKindService HealthEvaluationKind = "Service"
	// HealthEvaluationKindServices Indicates that the health evaluation is for services of an application. The
	// value is 6.
	HealthEvaluationKindServices HealthEvaluationKind = "Services"
	// HealthEvaluationKindSystemApplication Indicates that the health evaluation is for the system
	// application. The value is 9.
	HealthEvaluationKindSystemApplication HealthEvaluationKind = "SystemApplication"
	// HealthEvaluationKindUpgradeDomainDeltaNodesCheck Indicates that the health evaluation is for the delta
	// of unhealthy upgrade domain cluster nodes. The value is 20.
	HealthEvaluationKindUpgradeDomainDeltaNodesCheck HealthEvaluationKind = "UpgradeDomainDeltaNodesCheck"
	// HealthEvaluationKindUpgradeDomainDeployedApplications Indicates that the health evaluation is for the
	// deployed applications of an application in an upgrade domain. The value is 10.
	HealthEvaluationKindUpgradeDomainDeployedApplications HealthEvaluationKind = "UpgradeDomainDeployedApplications"
	// HealthEvaluationKindUpgradeDomainNodes Indicates that the health evaluation is for the cluster nodes in
	// an upgrade domain. The value is 11.
	HealthEvaluationKindUpgradeDomainNodes HealthEvaluationKind = "UpgradeDomainNodes"
)

// PossibleHealthEvaluationKindValues returns an array of possible values for the HealthEvaluationKind const type.
func PossibleHealthEvaluationKindValues() []HealthEvaluationKind {
	return []HealthEvaluationKind{HealthEvaluationKindApplication, HealthEvaluationKindApplications, HealthEvaluationKindApplicationTypeApplications, HealthEvaluationKindDeltaNodesCheck, HealthEvaluationKindDeployedApplication, HealthEvaluationKindDeployedApplications, HealthEvaluationKindDeployedServicePackage, HealthEvaluationKindDeployedServicePackages, HealthEvaluationKindEvent, HealthEvaluationKindInvalid, HealthEvaluationKindNode, HealthEvaluationKindNodes, HealthEvaluationKindPartition, HealthEvaluationKindPartitions, HealthEvaluationKindReplica, HealthEvaluationKindReplicas, HealthEvaluationKindService, HealthEvaluationKindServices, HealthEvaluationKindSystemApplication, HealthEvaluationKindUpgradeDomainDeltaNodesCheck, HealthEvaluationKindUpgradeDomainDeployedApplications, HealthEvaluationKindUpgradeDomainNodes}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateError Indicates the health state is at an error level. Error health state should be
	// investigated, as they can impact the correct functionality of the cluster. The value is 3.
	HealthStateError HealthState = "Error"
	// HealthStateInvalid Indicates an invalid health state. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStateOk Indicates the health state is okay. The value is 1.
	HealthStateOk HealthState = "Ok"
	// HealthStateUnknown Indicates an unknown health status. The value is 65535.
	HealthStateUnknown HealthState = "Unknown"
	// HealthStateWarning Indicates the health state is at a warning level. The value is 2.
	HealthStateWarning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateError, HealthStateInvalid, HealthStateOk, HealthStateUnknown, HealthStateWarning}
}

// HostIsolationMode enumerates the values for host isolation mode.
type HostIsolationMode string

const (
	// HostIsolationModeHyperV Indicates the ContainerHost is a Hyper-V container. This applies to only Windows
	// containers. The value is 2.
	HostIsolationModeHyperV HostIsolationMode = "HyperV"
	// HostIsolationModeNone Indicates the isolation mode is not applicable for given HostType. The value is 0.
	HostIsolationModeNone HostIsolationMode = "None"
	// HostIsolationModeProcess This is the default isolation mode for a ContainerHost. The value is 1.
	HostIsolationModeProcess HostIsolationMode = "Process"
)

// PossibleHostIsolationModeValues returns an array of possible values for the HostIsolationMode const type.
func PossibleHostIsolationModeValues() []HostIsolationMode {
	return []HostIsolationMode{HostIsolationModeHyperV, HostIsolationModeNone, HostIsolationModeProcess}
}

// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeContainerHost Indicates the host is a container. The value is 2.
	HostTypeContainerHost HostType = "ContainerHost"
	// HostTypeExeHost Indicates the host is an executable. The value is 1.
	HostTypeExeHost HostType = "ExeHost"
	// HostTypeInvalid Indicates the type of host is not known or invalid. The value is 0.
	HostTypeInvalid HostType = "Invalid"
)

// PossibleHostTypeValues returns an array of possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{HostTypeContainerHost, HostTypeExeHost, HostTypeInvalid}
}

// ImpactLevel enumerates the values for impact level.
type ImpactLevel string

const (
	// ImpactLevelInvalid ...
	ImpactLevelInvalid ImpactLevel = "Invalid"
	// ImpactLevelNone ...
	ImpactLevelNone ImpactLevel = "None"
	// ImpactLevelRemoveData ...
	ImpactLevelRemoveData ImpactLevel = "RemoveData"
	// ImpactLevelRemoveNode ...
	ImpactLevelRemoveNode ImpactLevel = "RemoveNode"
	// ImpactLevelRestart ...
	ImpactLevelRestart ImpactLevel = "Restart"
)

// PossibleImpactLevelValues returns an array of possible values for the ImpactLevel const type.
func PossibleImpactLevelValues() []ImpactLevel {
	return []ImpactLevel{ImpactLevelInvalid, ImpactLevelNone, ImpactLevelRemoveData, ImpactLevelRemoveNode, ImpactLevelRestart}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindApplication ...
	KindApplication Kind = "Application"
	// KindApplications ...
	KindApplications Kind = "Applications"
	// KindApplicationTypeApplications ...
	KindApplicationTypeApplications Kind = "ApplicationTypeApplications"
	// KindDeltaNodesCheck ...
	KindDeltaNodesCheck Kind = "DeltaNodesCheck"
	// KindDeployedApplication ...
	KindDeployedApplication Kind = "DeployedApplication"
	// KindDeployedApplications ...
	KindDeployedApplications Kind = "DeployedApplications"
	// KindDeployedServicePackage ...
	KindDeployedServicePackage Kind = "DeployedServicePackage"
	// KindDeployedServicePackages ...
	KindDeployedServicePackages Kind = "DeployedServicePackages"
	// KindEvent ...
	KindEvent Kind = "Event"
	// KindHealthEvaluation ...
	KindHealthEvaluation Kind = "HealthEvaluation"
	// KindNode ...
	KindNode Kind = "Node"
	// KindNodes ...
	KindNodes Kind = "Nodes"
	// KindPartition ...
	KindPartition Kind = "Partition"
	// KindPartitions ...
	KindPartitions Kind = "Partitions"
	// KindReplica ...
	KindReplica Kind = "Replica"
	// KindReplicas ...
	KindReplicas Kind = "Replicas"
	// KindService ...
	KindService Kind = "Service"
	// KindServices ...
	KindServices Kind = "Services"
	// KindSystemApplication ...
	KindSystemApplication Kind = "SystemApplication"
	// KindUpgradeDomainDeltaNodesCheck ...
	KindUpgradeDomainDeltaNodesCheck Kind = "UpgradeDomainDeltaNodesCheck"
	// KindUpgradeDomainNodes ...
	KindUpgradeDomainNodes Kind = "UpgradeDomainNodes"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindApplication, KindApplications, KindApplicationTypeApplications, KindDeltaNodesCheck, KindDeployedApplication, KindDeployedApplications, KindDeployedServicePackage, KindDeployedServicePackages, KindEvent, KindHealthEvaluation, KindNode, KindNodes, KindPartition, KindPartitions, KindReplica, KindReplicas, KindService, KindServices, KindSystemApplication, KindUpgradeDomainDeltaNodesCheck, KindUpgradeDomainNodes}
}

// KindBasicApplicationScopedVolumeCreationParameters enumerates the values for kind basic application scoped
// volume creation parameters.
type KindBasicApplicationScopedVolumeCreationParameters string

const (
	// KindApplicationScopedVolumeCreationParameters ...
	KindApplicationScopedVolumeCreationParameters KindBasicApplicationScopedVolumeCreationParameters = "ApplicationScopedVolumeCreationParameters"
	// KindServiceFabricVolumeDisk ...
	KindServiceFabricVolumeDisk KindBasicApplicationScopedVolumeCreationParameters = "ServiceFabricVolumeDisk"
)

// PossibleKindBasicApplicationScopedVolumeCreationParametersValues returns an array of possible values for the KindBasicApplicationScopedVolumeCreationParameters const type.
func PossibleKindBasicApplicationScopedVolumeCreationParametersValues() []KindBasicApplicationScopedVolumeCreationParameters {
	return []KindBasicApplicationScopedVolumeCreationParameters{KindApplicationScopedVolumeCreationParameters, KindServiceFabricVolumeDisk}
}

// KindBasicAutoScalingMechanism enumerates the values for kind basic auto scaling mechanism.
type KindBasicAutoScalingMechanism string

const (
	// KindAddRemoveReplica ...
	KindAddRemoveReplica KindBasicAutoScalingMechanism = "AddRemoveReplica"
	// KindAutoScalingMechanism ...
	KindAutoScalingMechanism KindBasicAutoScalingMechanism = "AutoScalingMechanism"
)

// PossibleKindBasicAutoScalingMechanismValues returns an array of possible values for the KindBasicAutoScalingMechanism const type.
func PossibleKindBasicAutoScalingMechanismValues() []KindBasicAutoScalingMechanism {
	return []KindBasicAutoScalingMechanism{KindAddRemoveReplica, KindAutoScalingMechanism}
}

// KindBasicAutoScalingMetric enumerates the values for kind basic auto scaling metric.
type KindBasicAutoScalingMetric string

const (
	// KindAutoScalingMetric ...
	KindAutoScalingMetric KindBasicAutoScalingMetric = "AutoScalingMetric"
	// KindResource ...
	KindResource KindBasicAutoScalingMetric = "Resource"
)

// PossibleKindBasicAutoScalingMetricValues returns an array of possible values for the KindBasicAutoScalingMetric const type.
func PossibleKindBasicAutoScalingMetricValues() []KindBasicAutoScalingMetric {
	return []KindBasicAutoScalingMetric{KindAutoScalingMetric, KindResource}
}

// KindBasicAutoScalingTrigger enumerates the values for kind basic auto scaling trigger.
type KindBasicAutoScalingTrigger string

const (
	// KindAutoScalingTrigger ...
	KindAutoScalingTrigger KindBasicAutoScalingTrigger = "AutoScalingTrigger"
	// KindAverageLoad ...
	KindAverageLoad KindBasicAutoScalingTrigger = "AverageLoad"
)

// PossibleKindBasicAutoScalingTriggerValues returns an array of possible values for the KindBasicAutoScalingTrigger const type.
func PossibleKindBasicAutoScalingTriggerValues() []KindBasicAutoScalingTrigger {
	return []KindBasicAutoScalingTrigger{KindAutoScalingTrigger, KindAverageLoad}
}

// KindBasicBackupConfigurationInfo enumerates the values for kind basic backup configuration info.
type KindBasicBackupConfigurationInfo string

const (
	// KindBasicBackupConfigurationInfoKindApplication ...
	KindBasicBackupConfigurationInfoKindApplication KindBasicBackupConfigurationInfo = "Application"
	// KindBasicBackupConfigurationInfoKindBackupConfigurationInfo ...
	KindBasicBackupConfigurationInfoKindBackupConfigurationInfo KindBasicBackupConfigurationInfo = "BackupConfigurationInfo"
	// KindBasicBackupConfigurationInfoKindPartition ...
	KindBasicBackupConfigurationInfoKindPartition KindBasicBackupConfigurationInfo = "Partition"
	// KindBasicBackupConfigurationInfoKindService ...
	KindBasicBackupConfigurationInfoKindService KindBasicBackupConfigurationInfo = "Service"
)

// PossibleKindBasicBackupConfigurationInfoValues returns an array of possible values for the KindBasicBackupConfigurationInfo const type.
func PossibleKindBasicBackupConfigurationInfoValues() []KindBasicBackupConfigurationInfo {
	return []KindBasicBackupConfigurationInfo{KindBasicBackupConfigurationInfoKindApplication, KindBasicBackupConfigurationInfoKindBackupConfigurationInfo, KindBasicBackupConfigurationInfoKindPartition, KindBasicBackupConfigurationInfoKindService}
}

// KindBasicChaosEvent enumerates the values for kind basic chaos event.
type KindBasicChaosEvent string

const (
	// KindChaosEvent ...
	KindChaosEvent KindBasicChaosEvent = "ChaosEvent"
	// KindExecutingFaults ...
	KindExecutingFaults KindBasicChaosEvent = "ExecutingFaults"
	// KindStarted ...
	KindStarted KindBasicChaosEvent = "Started"
	// KindStopped ...
	KindStopped KindBasicChaosEvent = "Stopped"
	// KindTestError ...
	KindTestError KindBasicChaosEvent = "TestError"
	// KindValidationFailed ...
	KindValidationFailed KindBasicChaosEvent = "ValidationFailed"
	// KindWaiting ...
	KindWaiting KindBasicChaosEvent = "Waiting"
)

// PossibleKindBasicChaosEventValues returns an array of possible values for the KindBasicChaosEvent const type.
func PossibleKindBasicChaosEventValues() []KindBasicChaosEvent {
	return []KindBasicChaosEvent{KindChaosEvent, KindExecutingFaults, KindStarted, KindStopped, KindTestError, KindValidationFailed, KindWaiting}
}

// KindBasicDiagnosticsSinkProperties enumerates the values for kind basic diagnostics sink properties.
type KindBasicDiagnosticsSinkProperties string

const (
	// KindAzureInternalMonitoringPipeline ...
	KindAzureInternalMonitoringPipeline KindBasicDiagnosticsSinkProperties = "AzureInternalMonitoringPipeline"
	// KindDiagnosticsSinkProperties ...
	KindDiagnosticsSinkProperties KindBasicDiagnosticsSinkProperties = "DiagnosticsSinkProperties"
)

// PossibleKindBasicDiagnosticsSinkPropertiesValues returns an array of possible values for the KindBasicDiagnosticsSinkProperties const type.
func PossibleKindBasicDiagnosticsSinkPropertiesValues() []KindBasicDiagnosticsSinkProperties {
	return []KindBasicDiagnosticsSinkProperties{KindAzureInternalMonitoringPipeline, KindDiagnosticsSinkProperties}
}

// KindBasicFabricEvent enumerates the values for kind basic fabric event.
type KindBasicFabricEvent string

const (
	// KindApplicationContainerInstanceExited ...
	KindApplicationContainerInstanceExited KindBasicFabricEvent = "ApplicationContainerInstanceExited"
	// KindApplicationCreated ...
	KindApplicationCreated KindBasicFabricEvent = "ApplicationCreated"
	// KindApplicationDeleted ...
	KindApplicationDeleted KindBasicFabricEvent = "ApplicationDeleted"
	// KindApplicationEvent ...
	KindApplicationEvent KindBasicFabricEvent = "ApplicationEvent"
	// KindApplicationHealthReportExpired ...
	KindApplicationHealthReportExpired KindBasicFabricEvent = "ApplicationHealthReportExpired"
	// KindApplicationNewHealthReport ...
	KindApplicationNewHealthReport KindBasicFabricEvent = "ApplicationNewHealthReport"
	// KindApplicationProcessExited ...
	KindApplicationProcessExited KindBasicFabricEvent = "ApplicationProcessExited"
	// KindApplicationUpgradeCompleted ...
	KindApplicationUpgradeCompleted KindBasicFabricEvent = "ApplicationUpgradeCompleted"
	// KindApplicationUpgradeDomainCompleted ...
	KindApplicationUpgradeDomainCompleted KindBasicFabricEvent = "ApplicationUpgradeDomainCompleted"
	// KindApplicationUpgradeRollbackCompleted ...
	KindApplicationUpgradeRollbackCompleted KindBasicFabricEvent = "ApplicationUpgradeRollbackCompleted"
	// KindApplicationUpgradeRollbackStarted ...
	KindApplicationUpgradeRollbackStarted KindBasicFabricEvent = "ApplicationUpgradeRollbackStarted"
	// KindApplicationUpgradeStarted ...
	KindApplicationUpgradeStarted KindBasicFabricEvent = "ApplicationUpgradeStarted"
	// KindChaosCodePackageRestartScheduled ...
	KindChaosCodePackageRestartScheduled KindBasicFabricEvent = "ChaosCodePackageRestartScheduled"
	// KindChaosNodeRestartScheduled ...
	KindChaosNodeRestartScheduled KindBasicFabricEvent = "ChaosNodeRestartScheduled"
	// KindChaosPartitionPrimaryMoveScheduled ...
	KindChaosPartitionPrimaryMoveScheduled KindBasicFabricEvent = "ChaosPartitionPrimaryMoveScheduled"
	// KindChaosPartitionSecondaryMoveScheduled ...
	KindChaosPartitionSecondaryMoveScheduled KindBasicFabricEvent = "ChaosPartitionSecondaryMoveScheduled"
	// KindChaosReplicaRemovalScheduled ...
	KindChaosReplicaRemovalScheduled KindBasicFabricEvent = "ChaosReplicaRemovalScheduled"
	// KindChaosReplicaRestartScheduled ...
	KindChaosReplicaRestartScheduled KindBasicFabricEvent = "ChaosReplicaRestartScheduled"
	// KindChaosStarted ...
	KindChaosStarted KindBasicFabricEvent = "ChaosStarted"
	// KindChaosStopped ...
	KindChaosStopped KindBasicFabricEvent = "ChaosStopped"
	// KindClusterEvent ...
	KindClusterEvent KindBasicFabricEvent = "ClusterEvent"
	// KindClusterHealthReportExpired ...
	KindClusterHealthReportExpired KindBasicFabricEvent = "ClusterHealthReportExpired"
	// KindClusterNewHealthReport ...
	KindClusterNewHealthReport KindBasicFabricEvent = "ClusterNewHealthReport"
	// KindClusterUpgradeCompleted ...
	KindClusterUpgradeCompleted KindBasicFabricEvent = "ClusterUpgradeCompleted"
	// KindClusterUpgradeDomainCompleted ...
	KindClusterUpgradeDomainCompleted KindBasicFabricEvent = "ClusterUpgradeDomainCompleted"
	// KindClusterUpgradeRollbackCompleted ...
	KindClusterUpgradeRollbackCompleted KindBasicFabricEvent = "ClusterUpgradeRollbackCompleted"
	// KindClusterUpgradeRollbackStarted ...
	KindClusterUpgradeRollbackStarted KindBasicFabricEvent = "ClusterUpgradeRollbackStarted"
	// KindClusterUpgradeStarted ...
	KindClusterUpgradeStarted KindBasicFabricEvent = "ClusterUpgradeStarted"
	// KindContainerInstanceEvent ...
	KindContainerInstanceEvent KindBasicFabricEvent = "ContainerInstanceEvent"
	// KindDeployedApplicationHealthReportExpired ...
	KindDeployedApplicationHealthReportExpired KindBasicFabricEvent = "DeployedApplicationHealthReportExpired"
	// KindDeployedApplicationNewHealthReport ...
	KindDeployedApplicationNewHealthReport KindBasicFabricEvent = "DeployedApplicationNewHealthReport"
	// KindDeployedServicePackageHealthReportExpired ...
	KindDeployedServicePackageHealthReportExpired KindBasicFabricEvent = "DeployedServicePackageHealthReportExpired"
	// KindDeployedServicePackageNewHealthReport ...
	KindDeployedServicePackageNewHealthReport KindBasicFabricEvent = "DeployedServicePackageNewHealthReport"
	// KindFabricEvent ...
	KindFabricEvent KindBasicFabricEvent = "FabricEvent"
	// KindNodeAborted ...
	KindNodeAborted KindBasicFabricEvent = "NodeAborted"
	// KindNodeAddedToCluster ...
	KindNodeAddedToCluster KindBasicFabricEvent = "NodeAddedToCluster"
	// KindNodeClosed ...
	KindNodeClosed KindBasicFabricEvent = "NodeClosed"
	// KindNodeDeactivateCompleted ...
	KindNodeDeactivateCompleted KindBasicFabricEvent = "NodeDeactivateCompleted"
	// KindNodeDeactivateStarted ...
	KindNodeDeactivateStarted KindBasicFabricEvent = "NodeDeactivateStarted"
	// KindNodeDown ...
	KindNodeDown KindBasicFabricEvent = "NodeDown"
	// KindNodeEvent ...
	KindNodeEvent KindBasicFabricEvent = "NodeEvent"
	// KindNodeHealthReportExpired ...
	KindNodeHealthReportExpired KindBasicFabricEvent = "NodeHealthReportExpired"
	// KindNodeNewHealthReport ...
	KindNodeNewHealthReport KindBasicFabricEvent = "NodeNewHealthReport"
	// KindNodeOpenFailed ...
	KindNodeOpenFailed KindBasicFabricEvent = "NodeOpenFailed"
	// KindNodeOpenSucceeded ...
	KindNodeOpenSucceeded KindBasicFabricEvent = "NodeOpenSucceeded"
	// KindNodeRemovedFromCluster ...
	KindNodeRemovedFromCluster KindBasicFabricEvent = "NodeRemovedFromCluster"
	// KindNodeUp ...
	KindNodeUp KindBasicFabricEvent = "NodeUp"
	// KindPartitionAnalysisEvent ...
	KindPartitionAnalysisEvent KindBasicFabricEvent = "PartitionAnalysisEvent"
	// KindPartitionEvent ...
	KindPartitionEvent KindBasicFabricEvent = "PartitionEvent"
	// KindPartitionHealthReportExpired ...
	KindPartitionHealthReportExpired KindBasicFabricEvent = "PartitionHealthReportExpired"
	// KindPartitionNewHealthReport ...
	KindPartitionNewHealthReport KindBasicFabricEvent = "PartitionNewHealthReport"
	// KindPartitionPrimaryMoveAnalysis ...
	KindPartitionPrimaryMoveAnalysis KindBasicFabricEvent = "PartitionPrimaryMoveAnalysis"
	// KindPartitionReconfigured ...
	KindPartitionReconfigured KindBasicFabricEvent = "PartitionReconfigured"
	// KindReplicaEvent ...
	KindReplicaEvent KindBasicFabricEvent = "ReplicaEvent"
	// KindServiceCreated ...
	KindServiceCreated KindBasicFabricEvent = "ServiceCreated"
	// KindServiceDeleted ...
	KindServiceDeleted KindBasicFabricEvent = "ServiceDeleted"
	// KindServiceEvent ...
	KindServiceEvent KindBasicFabricEvent = "ServiceEvent"
	// KindServiceHealthReportExpired ...
	KindServiceHealthReportExpired KindBasicFabricEvent = "ServiceHealthReportExpired"
	// KindServiceNewHealthReport ...
	KindServiceNewHealthReport KindBasicFabricEvent = "ServiceNewHealthReport"
	// KindStatefulReplicaHealthReportExpired ...
	KindStatefulReplicaHealthReportExpired KindBasicFabricEvent = "StatefulReplicaHealthReportExpired"
	// KindStatefulReplicaNewHealthReport ...
	KindStatefulReplicaNewHealthReport KindBasicFabricEvent = "StatefulReplicaNewHealthReport"
	// KindStatelessReplicaHealthReportExpired ...
	KindStatelessReplicaHealthReportExpired KindBasicFabricEvent = "StatelessReplicaHealthReportExpired"
	// KindStatelessReplicaNewHealthReport ...
	KindStatelessReplicaNewHealthReport KindBasicFabricEvent = "StatelessReplicaNewHealthReport"
)

// PossibleKindBasicFabricEventValues returns an array of possible values for the KindBasicFabricEvent const type.
func PossibleKindBasicFabricEventValues() []KindBasicFabricEvent {
	return []KindBasicFabricEvent{KindApplicationContainerInstanceExited, KindApplicationCreated, KindApplicationDeleted, KindApplicationEvent, KindApplicationHealthReportExpired, KindApplicationNewHealthReport, KindApplicationProcessExited, KindApplicationUpgradeCompleted, KindApplicationUpgradeDomainCompleted, KindApplicationUpgradeRollbackCompleted, KindApplicationUpgradeRollbackStarted, KindApplicationUpgradeStarted, KindChaosCodePackageRestartScheduled, KindChaosNodeRestartScheduled, KindChaosPartitionPrimaryMoveScheduled, KindChaosPartitionSecondaryMoveScheduled, KindChaosReplicaRemovalScheduled, KindChaosReplicaRestartScheduled, KindChaosStarted, KindChaosStopped, KindClusterEvent, KindClusterHealthReportExpired, KindClusterNewHealthReport, KindClusterUpgradeCompleted, KindClusterUpgradeDomainCompleted, KindClusterUpgradeRollbackCompleted, KindClusterUpgradeRollbackStarted, KindClusterUpgradeStarted, KindContainerInstanceEvent, KindDeployedApplicationHealthReportExpired, KindDeployedApplicationNewHealthReport, KindDeployedServicePackageHealthReportExpired, KindDeployedServicePackageNewHealthReport, KindFabricEvent, KindNodeAborted, KindNodeAddedToCluster, KindNodeClosed, KindNodeDeactivateCompleted, KindNodeDeactivateStarted, KindNodeDown, KindNodeEvent, KindNodeHealthReportExpired, KindNodeNewHealthReport, KindNodeOpenFailed, KindNodeOpenSucceeded, KindNodeRemovedFromCluster, KindNodeUp, KindPartitionAnalysisEvent, KindPartitionEvent, KindPartitionHealthReportExpired, KindPartitionNewHealthReport, KindPartitionPrimaryMoveAnalysis, KindPartitionReconfigured, KindReplicaEvent, KindServiceCreated, KindServiceDeleted, KindServiceEvent, KindServiceHealthReportExpired, KindServiceNewHealthReport, KindStatefulReplicaHealthReportExpired, KindStatefulReplicaNewHealthReport, KindStatelessReplicaHealthReportExpired, KindStatelessReplicaNewHealthReport}
}

// KindBasicNetworkResourcePropertiesBase enumerates the values for kind basic network resource properties
// base.
type KindBasicNetworkResourcePropertiesBase string

const (
	// KindLocal ...
	KindLocal KindBasicNetworkResourcePropertiesBase = "Local"
	// KindNetworkResourceProperties ...
	KindNetworkResourceProperties KindBasicNetworkResourcePropertiesBase = "NetworkResourceProperties"
	// KindNetworkResourcePropertiesBase ...
	KindNetworkResourcePropertiesBase KindBasicNetworkResourcePropertiesBase = "NetworkResourcePropertiesBase"
)

// PossibleKindBasicNetworkResourcePropertiesBaseValues returns an array of possible values for the KindBasicNetworkResourcePropertiesBase const type.
func PossibleKindBasicNetworkResourcePropertiesBaseValues() []KindBasicNetworkResourcePropertiesBase {
	return []KindBasicNetworkResourcePropertiesBase{KindLocal, KindNetworkResourceProperties, KindNetworkResourcePropertiesBase}
}

// KindBasicPropertyBatchInfo enumerates the values for kind basic property batch info.
type KindBasicPropertyBatchInfo string

const (
	// KindFailed ...
	KindFailed KindBasicPropertyBatchInfo = "Failed"
	// KindPropertyBatchInfo ...
	KindPropertyBatchInfo KindBasicPropertyBatchInfo = "PropertyBatchInfo"
	// KindSuccessful ...
	KindSuccessful KindBasicPropertyBatchInfo = "Successful"
)

// PossibleKindBasicPropertyBatchInfoValues returns an array of possible values for the KindBasicPropertyBatchInfo const type.
func PossibleKindBasicPropertyBatchInfoValues() []KindBasicPropertyBatchInfo {
	return []KindBasicPropertyBatchInfo{KindFailed, KindPropertyBatchInfo, KindSuccessful}
}

// KindBasicPropertyBatchOperation enumerates the values for kind basic property batch operation.
type KindBasicPropertyBatchOperation string

const (
	// KindCheckExists ...
	KindCheckExists KindBasicPropertyBatchOperation = "CheckExists"
	// KindCheckSequence ...
	KindCheckSequence KindBasicPropertyBatchOperation = "CheckSequence"
	// KindCheckValue ...
	KindCheckValue KindBasicPropertyBatchOperation = "CheckValue"
	// KindDelete ...
	KindDelete KindBasicPropertyBatchOperation = "Delete"
	// KindGet ...
	KindGet KindBasicPropertyBatchOperation = "Get"
	// KindPropertyBatchOperation ...
	KindPropertyBatchOperation KindBasicPropertyBatchOperation = "PropertyBatchOperation"
	// KindPut ...
	KindPut KindBasicPropertyBatchOperation = "Put"
)

// PossibleKindBasicPropertyBatchOperationValues returns an array of possible values for the KindBasicPropertyBatchOperation const type.
func PossibleKindBasicPropertyBatchOperationValues() []KindBasicPropertyBatchOperation {
	return []KindBasicPropertyBatchOperation{KindCheckExists, KindCheckSequence, KindCheckValue, KindDelete, KindGet, KindPropertyBatchOperation, KindPut}
}

// KindBasicPropertyValue enumerates the values for kind basic property value.
type KindBasicPropertyValue string

const (
	// KindBinary ...
	KindBinary KindBasicPropertyValue = "Binary"
	// KindDouble ...
	KindDouble KindBasicPropertyValue = "Double"
	// KindGUID ...
	KindGUID KindBasicPropertyValue = "Guid"
	// KindInt64 ...
	KindInt64 KindBasicPropertyValue = "Int64"
	// KindPropertyValue ...
	KindPropertyValue KindBasicPropertyValue = "PropertyValue"
	// KindString ...
	KindString KindBasicPropertyValue = "String"
)

// PossibleKindBasicPropertyValueValues returns an array of possible values for the KindBasicPropertyValue const type.
func PossibleKindBasicPropertyValueValues() []KindBasicPropertyValue {
	return []KindBasicPropertyValue{KindBinary, KindDouble, KindGUID, KindInt64, KindPropertyValue, KindString}
}

// KindBasicProvisionApplicationTypeDescriptionBase enumerates the values for kind basic provision application
// type description base.
type KindBasicProvisionApplicationTypeDescriptionBase string

const (
	// KindExternalStore ...
	KindExternalStore KindBasicProvisionApplicationTypeDescriptionBase = "ExternalStore"
	// KindImageStorePath ...
	KindImageStorePath KindBasicProvisionApplicationTypeDescriptionBase = "ImageStorePath"
	// KindProvisionApplicationTypeDescriptionBase ...
	KindProvisionApplicationTypeDescriptionBase KindBasicProvisionApplicationTypeDescriptionBase = "ProvisionApplicationTypeDescriptionBase"
)

// PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues returns an array of possible values for the KindBasicProvisionApplicationTypeDescriptionBase const type.
func PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues() []KindBasicProvisionApplicationTypeDescriptionBase {
	return []KindBasicProvisionApplicationTypeDescriptionBase{KindExternalStore, KindImageStorePath, KindProvisionApplicationTypeDescriptionBase}
}

// KindBasicRepairImpactDescriptionBase enumerates the values for kind basic repair impact description base.
type KindBasicRepairImpactDescriptionBase string

const (
	// KindBasicRepairImpactDescriptionBaseKindNode ...
	KindBasicRepairImpactDescriptionBaseKindNode KindBasicRepairImpactDescriptionBase = "Node"
	// KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase ...
	KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase KindBasicRepairImpactDescriptionBase = "RepairImpactDescriptionBase"
)

// PossibleKindBasicRepairImpactDescriptionBaseValues returns an array of possible values for the KindBasicRepairImpactDescriptionBase const type.
func PossibleKindBasicRepairImpactDescriptionBaseValues() []KindBasicRepairImpactDescriptionBase {
	return []KindBasicRepairImpactDescriptionBase{KindBasicRepairImpactDescriptionBaseKindNode, KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase}
}

// KindBasicRepairTargetDescriptionBase enumerates the values for kind basic repair target description base.
type KindBasicRepairTargetDescriptionBase string

const (
	// KindBasicRepairTargetDescriptionBaseKindNode ...
	KindBasicRepairTargetDescriptionBaseKindNode KindBasicRepairTargetDescriptionBase = "Node"
	// KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase ...
	KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase KindBasicRepairTargetDescriptionBase = "RepairTargetDescriptionBase"
)

// PossibleKindBasicRepairTargetDescriptionBaseValues returns an array of possible values for the KindBasicRepairTargetDescriptionBase const type.
func PossibleKindBasicRepairTargetDescriptionBaseValues() []KindBasicRepairTargetDescriptionBase {
	return []KindBasicRepairTargetDescriptionBase{KindBasicRepairTargetDescriptionBaseKindNode, KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase}
}

// KindBasicReplicaStatusBase enumerates the values for kind basic replica status base.
type KindBasicReplicaStatusBase string

const (
	// KindKeyValueStore ...
	KindKeyValueStore KindBasicReplicaStatusBase = "KeyValueStore"
	// KindReplicaStatusBase ...
	KindReplicaStatusBase KindBasicReplicaStatusBase = "ReplicaStatusBase"
)

// PossibleKindBasicReplicaStatusBaseValues returns an array of possible values for the KindBasicReplicaStatusBase const type.
func PossibleKindBasicReplicaStatusBaseValues() []KindBasicReplicaStatusBase {
	return []KindBasicReplicaStatusBase{KindKeyValueStore, KindReplicaStatusBase}
}

// KindBasicReplicatorStatus enumerates the values for kind basic replicator status.
type KindBasicReplicatorStatus string

const (
	// KindActiveSecondary ...
	KindActiveSecondary KindBasicReplicatorStatus = "ActiveSecondary"
	// KindIdleSecondary ...
	KindIdleSecondary KindBasicReplicatorStatus = "IdleSecondary"
	// KindPrimary ...
	KindPrimary KindBasicReplicatorStatus = "Primary"
	// KindReplicatorStatus ...
	KindReplicatorStatus KindBasicReplicatorStatus = "ReplicatorStatus"
	// KindSecondaryReplicatorStatus ...
	KindSecondaryReplicatorStatus KindBasicReplicatorStatus = "SecondaryReplicatorStatus"
)

// PossibleKindBasicReplicatorStatusValues returns an array of possible values for the KindBasicReplicatorStatus const type.
func PossibleKindBasicReplicatorStatusValues() []KindBasicReplicatorStatus {
	return []KindBasicReplicatorStatus{KindActiveSecondary, KindIdleSecondary, KindPrimary, KindReplicatorStatus, KindSecondaryReplicatorStatus}
}

// KindBasicSafetyCheck enumerates the values for kind basic safety check.
type KindBasicSafetyCheck string

const (
	// KindEnsureAvailability ...
	KindEnsureAvailability KindBasicSafetyCheck = "EnsureAvailability"
	// KindEnsurePartitionQuorum ...
	KindEnsurePartitionQuorum KindBasicSafetyCheck = "EnsurePartitionQuorum"
	// KindEnsureSeedNodeQuorum ...
	KindEnsureSeedNodeQuorum KindBasicSafetyCheck = "EnsureSeedNodeQuorum"
	// KindPartitionSafetyCheck ...
	KindPartitionSafetyCheck KindBasicSafetyCheck = "PartitionSafetyCheck"
	// KindSafetyCheck ...
	KindSafetyCheck KindBasicSafetyCheck = "SafetyCheck"
	// KindWaitForInbuildReplica ...
	KindWaitForInbuildReplica KindBasicSafetyCheck = "WaitForInbuildReplica"
	// KindWaitForPrimaryPlacement ...
	KindWaitForPrimaryPlacement KindBasicSafetyCheck = "WaitForPrimaryPlacement"
	// KindWaitForPrimarySwap ...
	KindWaitForPrimarySwap KindBasicSafetyCheck = "WaitForPrimarySwap"
	// KindWaitForReconfiguration ...
	KindWaitForReconfiguration KindBasicSafetyCheck = "WaitForReconfiguration"
)

// PossibleKindBasicSafetyCheckValues returns an array of possible values for the KindBasicSafetyCheck const type.
func PossibleKindBasicSafetyCheckValues() []KindBasicSafetyCheck {
	return []KindBasicSafetyCheck{KindEnsureAvailability, KindEnsurePartitionQuorum, KindEnsureSeedNodeQuorum, KindPartitionSafetyCheck, KindSafetyCheck, KindWaitForInbuildReplica, KindWaitForPrimaryPlacement, KindWaitForPrimarySwap, KindWaitForReconfiguration}
}

// KindBasicScalingMechanismDescription enumerates the values for kind basic scaling mechanism description.
type KindBasicScalingMechanismDescription string

const (
	// KindAddRemoveIncrementalNamedPartition ...
	KindAddRemoveIncrementalNamedPartition KindBasicScalingMechanismDescription = "AddRemoveIncrementalNamedPartition"
	// KindPartitionInstanceCount ...
	KindPartitionInstanceCount KindBasicScalingMechanismDescription = "PartitionInstanceCount"
	// KindScalingMechanismDescription ...
	KindScalingMechanismDescription KindBasicScalingMechanismDescription = "ScalingMechanismDescription"
)

// PossibleKindBasicScalingMechanismDescriptionValues returns an array of possible values for the KindBasicScalingMechanismDescription const type.
func PossibleKindBasicScalingMechanismDescriptionValues() []KindBasicScalingMechanismDescription {
	return []KindBasicScalingMechanismDescription{KindAddRemoveIncrementalNamedPartition, KindPartitionInstanceCount, KindScalingMechanismDescription}
}

// KindBasicScalingTriggerDescription enumerates the values for kind basic scaling trigger description.
type KindBasicScalingTriggerDescription string

const (
	// KindAveragePartitionLoad ...
	KindAveragePartitionLoad KindBasicScalingTriggerDescription = "AveragePartitionLoad"
	// KindAverageServiceLoad ...
	KindAverageServiceLoad KindBasicScalingTriggerDescription = "AverageServiceLoad"
	// KindScalingTriggerDescription ...
	KindScalingTriggerDescription KindBasicScalingTriggerDescription = "ScalingTriggerDescription"
)

// PossibleKindBasicScalingTriggerDescriptionValues returns an array of possible values for the KindBasicScalingTriggerDescription const type.
func PossibleKindBasicScalingTriggerDescriptionValues() []KindBasicScalingTriggerDescription {
	return []KindBasicScalingTriggerDescription{KindAveragePartitionLoad, KindAverageServiceLoad, KindScalingTriggerDescription}
}

// KindBasicSecretResourcePropertiesBase enumerates the values for kind basic secret resource properties base.
type KindBasicSecretResourcePropertiesBase string

const (
	// KindInlinedValue ...
	KindInlinedValue KindBasicSecretResourcePropertiesBase = "inlinedValue"
	// KindSecretResourceProperties ...
	KindSecretResourceProperties KindBasicSecretResourcePropertiesBase = "SecretResourceProperties"
	// KindSecretResourcePropertiesBase ...
	KindSecretResourcePropertiesBase KindBasicSecretResourcePropertiesBase = "SecretResourcePropertiesBase"
)

// PossibleKindBasicSecretResourcePropertiesBaseValues returns an array of possible values for the KindBasicSecretResourcePropertiesBase const type.
func PossibleKindBasicSecretResourcePropertiesBaseValues() []KindBasicSecretResourcePropertiesBase {
	return []KindBasicSecretResourcePropertiesBase{KindInlinedValue, KindSecretResourceProperties, KindSecretResourcePropertiesBase}
}

// KindBasicServiceTypeDescription enumerates the values for kind basic service type description.
type KindBasicServiceTypeDescription string

const (
	// KindServiceTypeDescription ...
	KindServiceTypeDescription KindBasicServiceTypeDescription = "ServiceTypeDescription"
	// KindStateful ...
	KindStateful KindBasicServiceTypeDescription = "Stateful"
	// KindStateless ...
	KindStateless KindBasicServiceTypeDescription = "Stateless"
)

// PossibleKindBasicServiceTypeDescriptionValues returns an array of possible values for the KindBasicServiceTypeDescription const type.
func PossibleKindBasicServiceTypeDescriptionValues() []KindBasicServiceTypeDescription {
	return []KindBasicServiceTypeDescription{KindServiceTypeDescription, KindStateful, KindStateless}
}

// MoveCost enumerates the values for move cost.
type MoveCost string

const (
	// High Specifies the move cost of the service as High. The value is 3.
	High MoveCost = "High"
	// Low Specifies the move cost of the service as Low. The value is 1.
	Low MoveCost = "Low"
	// Medium Specifies the move cost of the service as Medium. The value is 2.
	Medium MoveCost = "Medium"
	// Zero Zero move cost. This value is zero.
	Zero MoveCost = "Zero"
)

// PossibleMoveCostValues returns an array of possible values for the MoveCost const type.
func PossibleMoveCostValues() []MoveCost {
	return []MoveCost{High, Low, Medium, Zero}
}

// NetworkKind enumerates the values for network kind.
type NetworkKind string

const (
	// Local Indicates a container network local to a single Service Fabric cluster. The value is 1.
	Local NetworkKind = "Local"
)

// PossibleNetworkKindValues returns an array of possible values for the NetworkKind const type.
func PossibleNetworkKindValues() []NetworkKind {
	return []NetworkKind{Local}
}

// NodeDeactivationIntent enumerates the values for node deactivation intent.
type NodeDeactivationIntent string

const (
	// NodeDeactivationIntentInvalid Indicates the node deactivation intent is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationIntentInvalid NodeDeactivationIntent = "Invalid"
	// NodeDeactivationIntentPause Indicates that the node should be paused. The value is 1.
	NodeDeactivationIntentPause NodeDeactivationIntent = "Pause"
	// NodeDeactivationIntentRemoveData Indicates that the intent is to reimage the node. Service Fabric does
	// not reimage the node, this action is done outside of Service Fabric. The value is 3.
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = "RemoveData"
	// NodeDeactivationIntentRemoveNode Indicates that the node is being decommissioned and is not expected to
	// return. Service Fabric does not decommission the node, this action is done outside of Service Fabric.
	// The value is 4.
	NodeDeactivationIntentRemoveNode NodeDeactivationIntent = "RemoveNode"
	// NodeDeactivationIntentRestart Indicates that the intent is for the node to be restarted after a short
	// period of time. Service Fabric does not restart the node, this action is done outside of Service Fabric.
	// The value is 2.
	NodeDeactivationIntentRestart NodeDeactivationIntent = "Restart"
)

// PossibleNodeDeactivationIntentValues returns an array of possible values for the NodeDeactivationIntent const type.
func PossibleNodeDeactivationIntentValues() []NodeDeactivationIntent {
	return []NodeDeactivationIntent{NodeDeactivationIntentInvalid, NodeDeactivationIntentPause, NodeDeactivationIntentRemoveData, NodeDeactivationIntentRemoveNode, NodeDeactivationIntentRestart}
}

// NodeDeactivationStatus enumerates the values for node deactivation status.
type NodeDeactivationStatus string

const (
	// NodeDeactivationStatusCompleted The task is completed. The value is 3.
	NodeDeactivationStatusCompleted NodeDeactivationStatus = "Completed"
	// NodeDeactivationStatusNone No status is associated with the task. The value is zero.
	NodeDeactivationStatusNone NodeDeactivationStatus = "None"
	// NodeDeactivationStatusSafetyCheckComplete When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that all safety checks have been completed. The value is 2.
	NodeDeactivationStatusSafetyCheckComplete NodeDeactivationStatus = "SafetyCheckComplete"
	// NodeDeactivationStatusSafetyCheckInProgress When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that one or more safety checks are in progress. The value is 1.
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = "SafetyCheckInProgress"
)

// PossibleNodeDeactivationStatusValues returns an array of possible values for the NodeDeactivationStatus const type.
func PossibleNodeDeactivationStatusValues() []NodeDeactivationStatus {
	return []NodeDeactivationStatus{NodeDeactivationStatusCompleted, NodeDeactivationStatusNone, NodeDeactivationStatusSafetyCheckComplete, NodeDeactivationStatusSafetyCheckInProgress}
}

// NodeDeactivationTaskType enumerates the values for node deactivation task type.
type NodeDeactivationTaskType string

const (
	// NodeDeactivationTaskTypeClient Specifies that the task was created by using the public API. The value is
	// 3.
	NodeDeactivationTaskTypeClient NodeDeactivationTaskType = "Client"
	// NodeDeactivationTaskTypeInfrastructure Specifies the task created by Infrastructure hosting the nodes.
	// The value is 1.
	NodeDeactivationTaskTypeInfrastructure NodeDeactivationTaskType = "Infrastructure"
	// NodeDeactivationTaskTypeInvalid Indicates the node deactivation task type is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationTaskTypeInvalid NodeDeactivationTaskType = "Invalid"
	// NodeDeactivationTaskTypeRepair Specifies the task that was created by the Repair Manager service. The
	// value is 2.
	NodeDeactivationTaskTypeRepair NodeDeactivationTaskType = "Repair"
)

// PossibleNodeDeactivationTaskTypeValues returns an array of possible values for the NodeDeactivationTaskType const type.
func PossibleNodeDeactivationTaskTypeValues() []NodeDeactivationTaskType {
	return []NodeDeactivationTaskType{NodeDeactivationTaskTypeClient, NodeDeactivationTaskTypeInfrastructure, NodeDeactivationTaskTypeInvalid, NodeDeactivationTaskTypeRepair}
}

// NodeStatus enumerates the values for node status.
type NodeStatus string

const (
	// NodeStatusDisabled Indicates the node is disabled. The value is 5.
	NodeStatusDisabled NodeStatus = "Disabled"
	// NodeStatusDisabling Indicates the node is in the process of being disabled. The value is 4.
	NodeStatusDisabling NodeStatus = "Disabling"
	// NodeStatusDown Indicates the node is down. The value is 2.
	NodeStatusDown NodeStatus = "Down"
	// NodeStatusEnabling Indicates the node is in process of being enabled. The value is 3.
	NodeStatusEnabling NodeStatus = "Enabling"
	// NodeStatusInvalid Indicates the node status is invalid. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	NodeStatusInvalid NodeStatus = "Invalid"
	// NodeStatusRemoved Indicates the node is removed. A node would be in Removed state if NodeStateRemoved
	// API has been called for this node. In other words, Service Fabric has been informed that the persisted
	// state on the node has been permanently lost. The value is 7.
	NodeStatusRemoved NodeStatus = "Removed"
	// NodeStatusUnknown Indicates the node is unknown. A node would be in Unknown state if Service Fabric does
	// not have authoritative information about that node. This can happen if the system learns about a node at
	// runtime.The value is 6.
	NodeStatusUnknown NodeStatus = "Unknown"
	// NodeStatusUp Indicates the node is up. The value is 1.
	NodeStatusUp NodeStatus = "Up"
)

// PossibleNodeStatusValues returns an array of possible values for the NodeStatus const type.
func PossibleNodeStatusValues() []NodeStatus {
	return []NodeStatus{NodeStatusDisabled, NodeStatusDisabling, NodeStatusDown, NodeStatusEnabling, NodeStatusInvalid, NodeStatusRemoved, NodeStatusUnknown, NodeStatusUp}
}

// NodeStatusFilter enumerates the values for node status filter.
type NodeStatusFilter string

const (
	// All This filter value will match all of the nodes.
	All NodeStatusFilter = "all"
	// Default This filter value will match all of the nodes excepts the ones with status as Unknown or
	// Removed.
	Default NodeStatusFilter = "default"
	// Disabled This filter value will match nodes that are Disabled.
	Disabled NodeStatusFilter = "disabled"
	// Disabling This filter value will match nodes that are in the process of being disabled with status as
	// Disabling.
	Disabling NodeStatusFilter = "disabling"
	// Down This filter value will match nodes that are Down.
	Down NodeStatusFilter = "down"
	// Enabling This filter value will match nodes that are in the process of being enabled with status as
	// Enabling.
	Enabling NodeStatusFilter = "enabling"
	// Removed This filter value will match nodes whose status is Removed. These are the nodes that are removed
	// from the cluster using the RemoveNodeState API.
	Removed NodeStatusFilter = "removed"
	// Unknown This filter value will match nodes whose status is Unknown. A node would be in Unknown state if
	// Service Fabric does not have authoritative information about that node. This can happen if the system
	// learns about a node at runtime.
	Unknown NodeStatusFilter = "unknown"
	// Up This filter value will match nodes that are Up.
	Up NodeStatusFilter = "up"
)

// PossibleNodeStatusFilterValues returns an array of possible values for the NodeStatusFilter const type.
func PossibleNodeStatusFilterValues() []NodeStatusFilter {
	return []NodeStatusFilter{All, Default, Disabled, Disabling, Down, Enabling, Removed, Unknown, Up}
}

// NodeTransitionType enumerates the values for node transition type.
type NodeTransitionType string

const (
	// NodeTransitionTypeInvalid Reserved.  Do not pass into API.
	NodeTransitionTypeInvalid NodeTransitionType = "Invalid"
	// NodeTransitionTypeStart Transition a stopped node to up.
	NodeTransitionTypeStart NodeTransitionType = "Start"
	// NodeTransitionTypeStop Transition an up node to stopped.
	NodeTransitionTypeStop NodeTransitionType = "Stop"
)

// PossibleNodeTransitionTypeValues returns an array of possible values for the NodeTransitionType const type.
func PossibleNodeTransitionTypeValues() []NodeTransitionType {
	return []NodeTransitionType{NodeTransitionTypeInvalid, NodeTransitionTypeStart, NodeTransitionTypeStop}
}

// NodeUpgradePhase enumerates the values for node upgrade phase.
type NodeUpgradePhase string

const (
	// NodeUpgradePhaseInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	NodeUpgradePhaseInvalid NodeUpgradePhase = "Invalid"
	// NodeUpgradePhasePostUpgradeSafetyCheck The upgrade has completed and post upgrade safety checks are
	// being performed. The value is 3
	NodeUpgradePhasePostUpgradeSafetyCheck NodeUpgradePhase = "PostUpgradeSafetyCheck"
	// NodeUpgradePhasePreUpgradeSafetyCheck The upgrade has not started yet due to pending safety checks. The
	// value is 1
	NodeUpgradePhasePreUpgradeSafetyCheck NodeUpgradePhase = "PreUpgradeSafetyCheck"
	// NodeUpgradePhaseUpgrading The upgrade is in progress. The value is 2
	NodeUpgradePhaseUpgrading NodeUpgradePhase = "Upgrading"
)

// PossibleNodeUpgradePhaseValues returns an array of possible values for the NodeUpgradePhase const type.
func PossibleNodeUpgradePhaseValues() []NodeUpgradePhase {
	return []NodeUpgradePhase{NodeUpgradePhaseInvalid, NodeUpgradePhasePostUpgradeSafetyCheck, NodeUpgradePhasePreUpgradeSafetyCheck, NodeUpgradePhaseUpgrading}
}

// OperatingSystemType enumerates the values for operating system type.
type OperatingSystemType string

const (
	// Linux The required operating system is Linux.
	Linux OperatingSystemType = "Linux"
	// Windows The required operating system is Windows.
	Windows OperatingSystemType = "Windows"
)

// PossibleOperatingSystemTypeValues returns an array of possible values for the OperatingSystemType const type.
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return []OperatingSystemType{Linux, Windows}
}

// OperationState enumerates the values for operation state.
type OperationState string

const (
	// OperationStateCancelled The operation was cancelled by the user using CancelOperation, and is no longer
	// running.
	OperationStateCancelled OperationState = "Cancelled"
	// OperationStateCompleted The operation has completed successfully and is no longer running.
	OperationStateCompleted OperationState = "Completed"
	// OperationStateFaulted The operation has failed and is no longer running.
	OperationStateFaulted OperationState = "Faulted"
	// OperationStateForceCancelled The operation was cancelled by the user using CancelOperation, with the
	// force parameter set to true.  It is no longer running.  Refer to CancelOperation for more details.
	OperationStateForceCancelled OperationState = "ForceCancelled"
	// OperationStateInvalid The operation state is invalid.
	OperationStateInvalid OperationState = "Invalid"
	// OperationStateRollingBack The operation is rolling back internal system state because it encountered a
	// fatal error or was cancelled by the user.  "RollingBack"     does not refer to user state.  For example,
	// if CancelOperation is called on a command of type PartitionDataLoss, state of "RollingBack" does not
	// mean service data is being restored (assuming the command has progressed far enough to cause data loss).
	// It means the system is rolling back/cleaning up internal system state associated with the command.
	OperationStateRollingBack OperationState = "RollingBack"
	// OperationStateRunning The operation is in progress.
	OperationStateRunning OperationState = "Running"
)

// PossibleOperationStateValues returns an array of possible values for the OperationState const type.
func PossibleOperationStateValues() []OperationState {
	return []OperationState{OperationStateCancelled, OperationStateCompleted, OperationStateFaulted, OperationStateForceCancelled, OperationStateInvalid, OperationStateRollingBack, OperationStateRunning}
}

// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid The operation state is invalid.
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeNodeTransition An operation started using the StartNodeTransition API.
	OperationTypeNodeTransition OperationType = "NodeTransition"
	// OperationTypePartitionDataLoss An operation started using the StartDataLoss API.
	OperationTypePartitionDataLoss OperationType = "PartitionDataLoss"
	// OperationTypePartitionQuorumLoss An operation started using the StartQuorumLoss API.
	OperationTypePartitionQuorumLoss OperationType = "PartitionQuorumLoss"
	// OperationTypePartitionRestart An operation started using the StartPartitionRestart API.
	OperationTypePartitionRestart OperationType = "PartitionRestart"
)

// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeNodeTransition, OperationTypePartitionDataLoss, OperationTypePartitionQuorumLoss, OperationTypePartitionRestart}
}

// PackageSharingPolicyScope enumerates the values for package sharing policy scope.
type PackageSharingPolicyScope string

const (
	// PackageSharingPolicyScopeAll Share all code, config and data packages from corresponding service
	// manifest. The value is 1.
	PackageSharingPolicyScopeAll PackageSharingPolicyScope = "All"
	// PackageSharingPolicyScopeCode Share all code packages from corresponding service manifest. The value is
	// 2.
	PackageSharingPolicyScopeCode PackageSharingPolicyScope = "Code"
	// PackageSharingPolicyScopeConfig Share all config packages from corresponding service manifest. The value
	// is 3.
	PackageSharingPolicyScopeConfig PackageSharingPolicyScope = "Config"
	// PackageSharingPolicyScopeData Share all data packages from corresponding service manifest. The value is
	// 4.
	PackageSharingPolicyScopeData PackageSharingPolicyScope = "Data"
	// PackageSharingPolicyScopeNone No package sharing policy scope. The value is 0.
	PackageSharingPolicyScopeNone PackageSharingPolicyScope = "None"
)

// PossiblePackageSharingPolicyScopeValues returns an array of possible values for the PackageSharingPolicyScope const type.
func PossiblePackageSharingPolicyScopeValues() []PackageSharingPolicyScope {
	return []PackageSharingPolicyScope{PackageSharingPolicyScopeAll, PackageSharingPolicyScopeCode, PackageSharingPolicyScopeConfig, PackageSharingPolicyScopeData, PackageSharingPolicyScopeNone}
}

// PartitionAccessStatus enumerates the values for partition access status.
type PartitionAccessStatus string

const (
	// PartitionAccessStatusGranted Indicates that the read or write operation access is granted and the
	// operation is allowed.
	PartitionAccessStatusGranted PartitionAccessStatus = "Granted"
	// PartitionAccessStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	PartitionAccessStatusInvalid PartitionAccessStatus = "Invalid"
	// PartitionAccessStatusNotPrimary Indicates that this client request was received by a replica that is not
	// a Primary replica.
	PartitionAccessStatusNotPrimary PartitionAccessStatus = "NotPrimary"
	// PartitionAccessStatusNoWriteQuorum Indicates that no write quorum is available and, therefore, no write
	// operation can be accepted.
	PartitionAccessStatusNoWriteQuorum PartitionAccessStatus = "NoWriteQuorum"
	// PartitionAccessStatusReconfigurationPending Indicates that the client should try again later, because a
	// reconfiguration is in progress.
	PartitionAccessStatusReconfigurationPending PartitionAccessStatus = "ReconfigurationPending"
)

// PossiblePartitionAccessStatusValues returns an array of possible values for the PartitionAccessStatus const type.
func PossiblePartitionAccessStatusValues() []PartitionAccessStatus {
	return []PartitionAccessStatus{PartitionAccessStatusGranted, PartitionAccessStatusInvalid, PartitionAccessStatusNotPrimary, PartitionAccessStatusNoWriteQuorum, PartitionAccessStatusReconfigurationPending}
}

// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// PartitionSchemeInvalid Indicates the partition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PartitionSchemeInvalid PartitionScheme = "Invalid"
	// PartitionSchemeNamed Indicates that the partition is based on string names, and is a
	// NamedPartitionSchemeDescription object. The value is 3
	PartitionSchemeNamed PartitionScheme = "Named"
	// PartitionSchemeSingleton Indicates that the partition is based on string names, and is a
	// SingletonPartitionSchemeDescription object, The value is 1.
	PartitionSchemeSingleton PartitionScheme = "Singleton"
	// PartitionSchemeUniformInt64Range Indicates that the partition is based on Int64 key ranges, and is a
	// UniformInt64RangePartitionSchemeDescription object. The value is 2.
	PartitionSchemeUniformInt64Range PartitionScheme = "UniformInt64Range"
)

// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{PartitionSchemeInvalid, PartitionSchemeNamed, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// PartitionSchemeBasicPartitionSchemeDescription enumerates the values for partition scheme basic partition
// scheme description.
type PartitionSchemeBasicPartitionSchemeDescription string

const (
	// PartitionSchemeNamed1 ...
	PartitionSchemeNamed1 PartitionSchemeBasicPartitionSchemeDescription = "Named"
	// PartitionSchemePartitionSchemeDescription ...
	PartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = "PartitionSchemeDescription"
	// PartitionSchemeSingleton1 ...
	PartitionSchemeSingleton1 PartitionSchemeBasicPartitionSchemeDescription = "Singleton"
	// PartitionSchemeUniformInt64Range1 ...
	PartitionSchemeUniformInt64Range1 PartitionSchemeBasicPartitionSchemeDescription = "UniformInt64Range"
)

// PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues returns an array of possible values for the PartitionSchemeBasicPartitionSchemeDescription const type.
func PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues() []PartitionSchemeBasicPartitionSchemeDescription {
	return []PartitionSchemeBasicPartitionSchemeDescription{PartitionSchemeNamed1, PartitionSchemePartitionSchemeDescription, PartitionSchemeSingleton1, PartitionSchemeUniformInt64Range1}
}

// PropertyBatchInfoKind enumerates the values for property batch info kind.
type PropertyBatchInfoKind string

const (
	// PropertyBatchInfoKindFailed The property batch failed.
	PropertyBatchInfoKindFailed PropertyBatchInfoKind = "Failed"
	// PropertyBatchInfoKindInvalid Indicates the property batch info is invalid. All Service Fabric
	// enumerations have the invalid type.
	PropertyBatchInfoKindInvalid PropertyBatchInfoKind = "Invalid"
	// PropertyBatchInfoKindSuccessful The property batch succeeded.
	PropertyBatchInfoKindSuccessful PropertyBatchInfoKind = "Successful"
)

// PossiblePropertyBatchInfoKindValues returns an array of possible values for the PropertyBatchInfoKind const type.
func PossiblePropertyBatchInfoKindValues() []PropertyBatchInfoKind {
	return []PropertyBatchInfoKind{PropertyBatchInfoKindFailed, PropertyBatchInfoKindInvalid, PropertyBatchInfoKindSuccessful}
}

// PropertyBatchOperationKind enumerates the values for property batch operation kind.
type PropertyBatchOperationKind string

const (
	// PropertyBatchOperationKindCheckExists The operation will check that a property exists or doesn't exists,
	// depending on the provided value. The value is 3.
	PropertyBatchOperationKindCheckExists PropertyBatchOperationKind = "CheckExists"
	// PropertyBatchOperationKindCheckSequence The operation will ensure that the sequence number is equal to
	// the provided value. The value is 4.
	PropertyBatchOperationKindCheckSequence PropertyBatchOperationKind = "CheckSequence"
	// PropertyBatchOperationKindCheckValue The operation will ensure that the value of a property is equal to
	// the provided value. The value is 7.
	PropertyBatchOperationKindCheckValue PropertyBatchOperationKind = "CheckValue"
	// PropertyBatchOperationKindDelete The operation will delete a property. The value is 5.
	PropertyBatchOperationKindDelete PropertyBatchOperationKind = "Delete"
	// PropertyBatchOperationKindGet The operation will get a property. The value is 2.
	PropertyBatchOperationKindGet PropertyBatchOperationKind = "Get"
	// PropertyBatchOperationKindInvalid Indicates the property operation is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	PropertyBatchOperationKindInvalid PropertyBatchOperationKind = "Invalid"
	// PropertyBatchOperationKindPut The operation will create or edit a property. The value is 1.
	PropertyBatchOperationKindPut PropertyBatchOperationKind = "Put"
)

// PossiblePropertyBatchOperationKindValues returns an array of possible values for the PropertyBatchOperationKind const type.
func PossiblePropertyBatchOperationKindValues() []PropertyBatchOperationKind {
	return []PropertyBatchOperationKind{PropertyBatchOperationKindCheckExists, PropertyBatchOperationKindCheckSequence, PropertyBatchOperationKindCheckValue, PropertyBatchOperationKindDelete, PropertyBatchOperationKindGet, PropertyBatchOperationKindInvalid, PropertyBatchOperationKindPut}
}

// PropertyValueKind enumerates the values for property value kind.
type PropertyValueKind string

const (
	// PropertyValueKindBinary The data inside the property is a binary blob. The value is 1.
	PropertyValueKindBinary PropertyValueKind = "Binary"
	// PropertyValueKindDouble The data inside the property is a double. The value is 3.
	PropertyValueKindDouble PropertyValueKind = "Double"
	// PropertyValueKindGUID The data inside the property is a guid. The value is 5.
	PropertyValueKindGUID PropertyValueKind = "Guid"
	// PropertyValueKindInt64 The data inside the property is an int64. The value is 2.
	PropertyValueKindInt64 PropertyValueKind = "Int64"
	// PropertyValueKindInvalid Indicates the property is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PropertyValueKindInvalid PropertyValueKind = "Invalid"
	// PropertyValueKindString The data inside the property is a string. The value is 4.
	PropertyValueKindString PropertyValueKind = "String"
)

// PossiblePropertyValueKindValues returns an array of possible values for the PropertyValueKind const type.
func PossiblePropertyValueKindValues() []PropertyValueKind {
	return []PropertyValueKind{PropertyValueKindBinary, PropertyValueKindDouble, PropertyValueKindGUID, PropertyValueKindInt64, PropertyValueKindInvalid, PropertyValueKindString}
}

// ProvisionApplicationTypeKind enumerates the values for provision application type kind.
type ProvisionApplicationTypeKind string

const (
	// ProvisionApplicationTypeKindExternalStore Indicates that the provision is for an application package
	// that was previously uploaded to an external store. The application package ends with the extension
	// *.sfpkg. The value is 2.
	ProvisionApplicationTypeKindExternalStore ProvisionApplicationTypeKind = "ExternalStore"
	// ProvisionApplicationTypeKindImageStorePath Indicates that the provision is for a package that was
	// previously uploaded to the image store. The value is 1.
	ProvisionApplicationTypeKindImageStorePath ProvisionApplicationTypeKind = "ImageStorePath"
	// ProvisionApplicationTypeKindInvalid Indicates that the provision kind is invalid. This value is default
	// and should not be used. The value is zero.
	ProvisionApplicationTypeKindInvalid ProvisionApplicationTypeKind = "Invalid"
)

// PossibleProvisionApplicationTypeKindValues returns an array of possible values for the ProvisionApplicationTypeKind const type.
func PossibleProvisionApplicationTypeKindValues() []ProvisionApplicationTypeKind {
	return []ProvisionApplicationTypeKind{ProvisionApplicationTypeKindExternalStore, ProvisionApplicationTypeKindImageStorePath, ProvisionApplicationTypeKindInvalid}
}

// QuorumLossMode enumerates the values for quorum loss mode.
type QuorumLossMode string

const (
	// QuorumLossModeAllReplicas ...
	QuorumLossModeAllReplicas QuorumLossMode = "AllReplicas"
	// QuorumLossModeInvalid Reserved.  Do not pass into API.
	QuorumLossModeInvalid QuorumLossMode = "Invalid"
	// QuorumLossModeQuorumReplicas Partial Quorum loss mode : Minimum number of replicas for a partition will
	// be down that will cause a quorum loss.
	QuorumLossModeQuorumReplicas QuorumLossMode = "QuorumReplicas"
)

// PossibleQuorumLossModeValues returns an array of possible values for the QuorumLossMode const type.
func PossibleQuorumLossModeValues() []QuorumLossMode {
	return []QuorumLossMode{QuorumLossModeAllReplicas, QuorumLossModeInvalid, QuorumLossModeQuorumReplicas}
}

// ReconfigurationPhase enumerates the values for reconfiguration phase.
type ReconfigurationPhase string

const (
	// ReconfigurationPhaseAbortPhaseZero This phase is for internal use only.
	ReconfigurationPhaseAbortPhaseZero ReconfigurationPhase = "AbortPhaseZero"
	// ReconfigurationPhaseNone Specifies that there is no reconfiguration in progress.
	ReconfigurationPhaseNone ReconfigurationPhase = "None"
	// ReconfigurationPhasePhase0 Refers to the phase where the reconfiguration is transferring data from the
	// previous primary to the new primary.
	ReconfigurationPhasePhase0 ReconfigurationPhase = "Phase0"
	// ReconfigurationPhasePhase1 Refers to the phase where the reconfiguration is querying the replica set for
	// the progress.
	ReconfigurationPhasePhase1 ReconfigurationPhase = "Phase1"
	// ReconfigurationPhasePhase2 Refers to the phase where the reconfiguration is ensuring that data from the
	// current primary is present in a majority of the replica set.
	ReconfigurationPhasePhase2 ReconfigurationPhase = "Phase2"
	// ReconfigurationPhasePhase3 This phase is for internal use only.
	ReconfigurationPhasePhase3 ReconfigurationPhase = "Phase3"
	// ReconfigurationPhasePhase4 This phase is for internal use only.
	ReconfigurationPhasePhase4 ReconfigurationPhase = "Phase4"
	// ReconfigurationPhaseUnknown Indicates the invalid reconfiguration phase.
	ReconfigurationPhaseUnknown ReconfigurationPhase = "Unknown"
)

// PossibleReconfigurationPhaseValues returns an array of possible values for the ReconfigurationPhase const type.
func PossibleReconfigurationPhaseValues() []ReconfigurationPhase {
	return []ReconfigurationPhase{ReconfigurationPhaseAbortPhaseZero, ReconfigurationPhaseNone, ReconfigurationPhasePhase0, ReconfigurationPhasePhase1, ReconfigurationPhasePhase2, ReconfigurationPhasePhase3, ReconfigurationPhasePhase4, ReconfigurationPhaseUnknown}
}

// ReconfigurationType enumerates the values for reconfiguration type.
type ReconfigurationType string

const (
	// ReconfigurationTypeFailover Reconfiguration triggered in response to a primary going down. This could be
	// due to many reasons such as primary replica crashing etc.
	ReconfigurationTypeFailover ReconfigurationType = "Failover"
	// ReconfigurationTypeOther Reconfigurations where the primary replica is not changing.
	ReconfigurationTypeOther ReconfigurationType = "Other"
	// ReconfigurationTypeSwapPrimary Specifies that the primary replica is being swapped with a different
	// replica.
	ReconfigurationTypeSwapPrimary ReconfigurationType = "SwapPrimary"
	// ReconfigurationTypeUnknown Indicates the invalid reconfiguration type.
	ReconfigurationTypeUnknown ReconfigurationType = "Unknown"
)

// PossibleReconfigurationTypeValues returns an array of possible values for the ReconfigurationType const type.
func PossibleReconfigurationTypeValues() []ReconfigurationType {
	return []ReconfigurationType{ReconfigurationTypeFailover, ReconfigurationTypeOther, ReconfigurationTypeSwapPrimary, ReconfigurationTypeUnknown}
}

// RepairImpactKind enumerates the values for repair impact kind.
type RepairImpactKind string

const (
	// RepairImpactKindInvalid The repair impact is not valid or is of an unknown type.
	RepairImpactKindInvalid RepairImpactKind = "Invalid"
	// RepairImpactKindNode The repair impact affects a set of Service Fabric nodes.
	RepairImpactKindNode RepairImpactKind = "Node"
)

// PossibleRepairImpactKindValues returns an array of possible values for the RepairImpactKind const type.
func PossibleRepairImpactKindValues() []RepairImpactKind {
	return []RepairImpactKind{RepairImpactKindInvalid, RepairImpactKindNode}
}

// RepairTargetKind enumerates the values for repair target kind.
type RepairTargetKind string

const (
	// RepairTargetKindInvalid The repair target is not valid or is of an unknown type.
	RepairTargetKindInvalid RepairTargetKind = "Invalid"
	// RepairTargetKindNode The repair target is a set of Service Fabric nodes.
	RepairTargetKindNode RepairTargetKind = "Node"
)

// PossibleRepairTargetKindValues returns an array of possible values for the RepairTargetKind const type.
func PossibleRepairTargetKindValues() []RepairTargetKind {
	return []RepairTargetKind{RepairTargetKindInvalid, RepairTargetKindNode}
}

// RepairTaskHealthCheckState enumerates the values for repair task health check state.
type RepairTaskHealthCheckState string

const (
	// InProgress Indicates that the health check is in progress.
	InProgress RepairTaskHealthCheckState = "InProgress"
	// NotStarted Indicates that the health check has not started.
	NotStarted RepairTaskHealthCheckState = "NotStarted"
	// Skipped Indicates that the health check was skipped.
	Skipped RepairTaskHealthCheckState = "Skipped"
	// Succeeded Indicates that the health check succeeded.
	Succeeded RepairTaskHealthCheckState = "Succeeded"
	// TimedOut Indicates that the health check timed out.
	TimedOut RepairTaskHealthCheckState = "TimedOut"
)

// PossibleRepairTaskHealthCheckStateValues returns an array of possible values for the RepairTaskHealthCheckState const type.
func PossibleRepairTaskHealthCheckStateValues() []RepairTaskHealthCheckState {
	return []RepairTaskHealthCheckState{InProgress, NotStarted, Skipped, Succeeded, TimedOut}
}

// ReplicaHealthReportServiceKind enumerates the values for replica health report service kind.
type ReplicaHealthReportServiceKind string

const (
	// Stateful Uses Service Fabric to make its state or part of its state highly available and reliable. The
	// value is 2.
	Stateful ReplicaHealthReportServiceKind = "Stateful"
	// Stateless Does not use Service Fabric to make its state highly available or reliable. The value is 1
	Stateless ReplicaHealthReportServiceKind = "Stateless"
)

// PossibleReplicaHealthReportServiceKindValues returns an array of possible values for the ReplicaHealthReportServiceKind const type.
func PossibleReplicaHealthReportServiceKindValues() []ReplicaHealthReportServiceKind {
	return []ReplicaHealthReportServiceKind{Stateful, Stateless}
}

// ReplicaKind enumerates the values for replica kind.
type ReplicaKind string

const (
	// ReplicaKindInvalid Represents an invalid replica kind. The value is zero.
	ReplicaKindInvalid ReplicaKind = "Invalid"
	// ReplicaKindKeyValueStore Represents a key value store replica. The value is 1
	ReplicaKindKeyValueStore ReplicaKind = "KeyValueStore"
)

// PossibleReplicaKindValues returns an array of possible values for the ReplicaKind const type.
func PossibleReplicaKindValues() []ReplicaKind {
	return []ReplicaKind{ReplicaKindInvalid, ReplicaKindKeyValueStore}
}

// ReplicaRole enumerates the values for replica role.
type ReplicaRole string

const (
	// ReplicaRoleActiveSecondary Refers to a replica in the set that receives state updates from the Primary
	// replica, applies them, and sends acknowledgements back. Secondary replicas must participate in the write
	// quorum for a replica set. There can be multiple active Secondary replicas in a replica set at a time.
	// The number of active Secondary replicas is configurable that the reliability subsystem should maintain.
	// The value is 4.
	ReplicaRoleActiveSecondary ReplicaRole = "ActiveSecondary"
	// ReplicaRoleIdleSecondary Refers to a replica in the set that receives a state transfer from the Primary
	// replica to prepare for becoming an active Secondary replica. There can be multiple Idle Secondary
	// replicas in a replica set at a time. Idle Secondary replicas do not count as a part of a write quorum.
	// The value is 3.
	ReplicaRoleIdleSecondary ReplicaRole = "IdleSecondary"
	// ReplicaRoleNone Specifies that the replica has no responsibility in regard to the replica set. The value
	// is 1
	ReplicaRoleNone ReplicaRole = "None"
	// ReplicaRolePrimary Refers to the replica in the set on which all read and write operations are complete
	// in order to enforce strong consistency semantics. Read operations are handled directly by the Primary
	// replica, while write operations must be acknowledged by a quorum of the replicas in the replica set.
	// There can only be one Primary replica in a replica set at a time. The value is 2.
	ReplicaRolePrimary ReplicaRole = "Primary"
	// ReplicaRoleUnknown Indicates the initial role that a replica is created in. The value is zero.
	ReplicaRoleUnknown ReplicaRole = "Unknown"
)

// PossibleReplicaRoleValues returns an array of possible values for the ReplicaRole const type.
func PossibleReplicaRoleValues() []ReplicaRole {
	return []ReplicaRole{ReplicaRoleActiveSecondary, ReplicaRoleIdleSecondary, ReplicaRoleNone, ReplicaRolePrimary, ReplicaRoleUnknown}
}

// ReplicaStatus enumerates the values for replica status.
type ReplicaStatus string

const (
	// ReplicaStatusDown The replica is down. The value is 4.
	ReplicaStatusDown ReplicaStatus = "Down"
	// ReplicaStatusDropped Replica is dropped. This means that the replica has been removed from the replica
	// set. If it is persisted, its state has been deleted. The value is 5.
	ReplicaStatusDropped ReplicaStatus = "Dropped"
	// ReplicaStatusInBuild The replica is being built. This means that a primary replica is seeding this
	// replica. The value is 1.
	ReplicaStatusInBuild ReplicaStatus = "InBuild"
	// ReplicaStatusInvalid Indicates the replica status is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ReplicaStatusInvalid ReplicaStatus = "Invalid"
	// ReplicaStatusReady The replica is ready. The value is 3.
	ReplicaStatusReady ReplicaStatus = "Ready"
	// ReplicaStatusStandby The replica is in standby. The value is 2.
	ReplicaStatusStandby ReplicaStatus = "Standby"
)

// PossibleReplicaStatusValues returns an array of possible values for the ReplicaStatus const type.
func PossibleReplicaStatusValues() []ReplicaStatus {
	return []ReplicaStatus{ReplicaStatusDown, ReplicaStatusDropped, ReplicaStatusInBuild, ReplicaStatusInvalid, ReplicaStatusReady, ReplicaStatusStandby}
}

// ReplicatorOperationName enumerates the values for replicator operation name.
type ReplicatorOperationName string

const (
	// ReplicatorOperationNameAbort Replicator is being aborted.
	ReplicatorOperationNameAbort ReplicatorOperationName = "Abort"
	// ReplicatorOperationNameBuild Replicator is in the process of building one or more replicas.
	ReplicatorOperationNameBuild ReplicatorOperationName = "Build"
	// ReplicatorOperationNameChangeRole Replicator is in the process of changing its role.
	ReplicatorOperationNameChangeRole ReplicatorOperationName = "ChangeRole"
	// ReplicatorOperationNameClose Replicator is closing.
	ReplicatorOperationNameClose ReplicatorOperationName = "Close"
	// ReplicatorOperationNameInvalid Default value if the replicator is not yet ready.
	ReplicatorOperationNameInvalid ReplicatorOperationName = "Invalid"
	// ReplicatorOperationNameNone Replicator is not running any operation from Service Fabric perspective.
	ReplicatorOperationNameNone ReplicatorOperationName = "None"
	// ReplicatorOperationNameOnDataLoss Replicator is handling the data loss condition, where the user service
	// may potentially be recovering state from an external source.
	ReplicatorOperationNameOnDataLoss ReplicatorOperationName = "OnDataLoss"
	// ReplicatorOperationNameOpen Replicator is opening.
	ReplicatorOperationNameOpen ReplicatorOperationName = "Open"
	// ReplicatorOperationNameUpdateEpoch Due to a change in the replica set, replicator is being updated with
	// its Epoch.
	ReplicatorOperationNameUpdateEpoch ReplicatorOperationName = "UpdateEpoch"
	// ReplicatorOperationNameWaitForCatchup Replicator is waiting for a quorum of replicas to be caught up to
	// the latest state.
	ReplicatorOperationNameWaitForCatchup ReplicatorOperationName = "WaitForCatchup"
)

// PossibleReplicatorOperationNameValues returns an array of possible values for the ReplicatorOperationName const type.
func PossibleReplicatorOperationNameValues() []ReplicatorOperationName {
	return []ReplicatorOperationName{ReplicatorOperationNameAbort, ReplicatorOperationNameBuild, ReplicatorOperationNameChangeRole, ReplicatorOperationNameClose, ReplicatorOperationNameInvalid, ReplicatorOperationNameNone, ReplicatorOperationNameOnDataLoss, ReplicatorOperationNameOpen, ReplicatorOperationNameUpdateEpoch, ReplicatorOperationNameWaitForCatchup}
}

// ResourceStatus enumerates the values for resource status.
type ResourceStatus string

const (
	// ResourceStatusCreating Indicates the resource is being created. The value is 3.
	ResourceStatusCreating ResourceStatus = "Creating"
	// ResourceStatusDeleting Indicates the resource is being deleted. The value is 4.
	ResourceStatusDeleting ResourceStatus = "Deleting"
	// ResourceStatusFailed Indicates the resource is not functional due to persistent failures. See
	// statusDetails property for more details. The value is 5.
	ResourceStatusFailed ResourceStatus = "Failed"
	// ResourceStatusReady Indicates the resource is ready. The value is 1.
	ResourceStatusReady ResourceStatus = "Ready"
	// ResourceStatusUnknown Indicates the resource status is unknown. The value is zero.
	ResourceStatusUnknown ResourceStatus = "Unknown"
	// ResourceStatusUpgrading Indicates the resource is upgrading. The value is 2.
	ResourceStatusUpgrading ResourceStatus = "Upgrading"
)

// PossibleResourceStatusValues returns an array of possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{ResourceStatusCreating, ResourceStatusDeleting, ResourceStatusFailed, ResourceStatusReady, ResourceStatusUnknown, ResourceStatusUpgrading}
}

// RestartPartitionMode enumerates the values for restart partition mode.
type RestartPartitionMode string

const (
	// RestartPartitionModeAllReplicasOrInstances All replicas or instances in the partition are restarted at
	// once.
	RestartPartitionModeAllReplicasOrInstances RestartPartitionMode = "AllReplicasOrInstances"
	// RestartPartitionModeInvalid Reserved.  Do not pass into API.
	RestartPartitionModeInvalid RestartPartitionMode = "Invalid"
	// RestartPartitionModeOnlyActiveSecondaries Only the secondary replicas are restarted.
	RestartPartitionModeOnlyActiveSecondaries RestartPartitionMode = "OnlyActiveSecondaries"
)

// PossibleRestartPartitionModeValues returns an array of possible values for the RestartPartitionMode const type.
func PossibleRestartPartitionModeValues() []RestartPartitionMode {
	return []RestartPartitionMode{RestartPartitionModeAllReplicasOrInstances, RestartPartitionModeInvalid, RestartPartitionModeOnlyActiveSecondaries}
}

// RestoreState enumerates the values for restore state.
type RestoreState string

const (
	// RestoreStateAccepted Operation has been validated and accepted. Restore is yet to be triggered.
	RestoreStateAccepted RestoreState = "Accepted"
	// RestoreStateFailure Operation completed with failure.
	RestoreStateFailure RestoreState = "Failure"
	// RestoreStateInvalid Indicates an invalid restore state. All Service Fabric enumerations have the invalid
	// type.
	RestoreStateInvalid RestoreState = "Invalid"
	// RestoreStateRestoreInProgress Restore operation has been triggered and is under process.
	RestoreStateRestoreInProgress RestoreState = "RestoreInProgress"
	// RestoreStateSuccess Operation completed with success.
	RestoreStateSuccess RestoreState = "Success"
	// RestoreStateTimeout Operation timed out.
	RestoreStateTimeout RestoreState = "Timeout"
)

// PossibleRestoreStateValues returns an array of possible values for the RestoreState const type.
func PossibleRestoreStateValues() []RestoreState {
	return []RestoreState{RestoreStateAccepted, RestoreStateFailure, RestoreStateInvalid, RestoreStateRestoreInProgress, RestoreStateSuccess, RestoreStateTimeout}
}

// ResultStatus enumerates the values for result status.
type ResultStatus string

const (
	// ResultStatusCancelled Indicates that the repair task was cancelled prior to execution.
	ResultStatusCancelled ResultStatus = "Cancelled"
	// ResultStatusFailed Indicates that there was a failure during execution of the repair task. Some work may
	// have been performed.
	ResultStatusFailed ResultStatus = "Failed"
	// ResultStatusInterrupted Indicates that execution of the repair task was interrupted by a cancellation
	// request after some work had already been performed.
	ResultStatusInterrupted ResultStatus = "Interrupted"
	// ResultStatusInvalid Indicates that the repair task result is invalid. All Service Fabric enumerations
	// have the invalid value.
	ResultStatusInvalid ResultStatus = "Invalid"
	// ResultStatusPending Indicates that the repair task result is not yet available, because the repair task
	// has not finished executing.
	ResultStatusPending ResultStatus = "Pending"
	// ResultStatusSucceeded Indicates that the repair task completed execution successfully.
	ResultStatusSucceeded ResultStatus = "Succeeded"
)

// PossibleResultStatusValues returns an array of possible values for the ResultStatus const type.
func PossibleResultStatusValues() []ResultStatus {
	return []ResultStatus{ResultStatusCancelled, ResultStatusFailed, ResultStatusInterrupted, ResultStatusInvalid, ResultStatusPending, ResultStatusSucceeded}
}

// RetentionPolicyType enumerates the values for retention policy type.
type RetentionPolicyType string

const (
	// RetentionPolicyTypeBasic Indicates a basic retention policy type.
	RetentionPolicyTypeBasic RetentionPolicyType = "Basic"
	// RetentionPolicyTypeInvalid Indicates an invalid retention policy type.
	RetentionPolicyTypeInvalid RetentionPolicyType = "Invalid"
)

// PossibleRetentionPolicyTypeValues returns an array of possible values for the RetentionPolicyType const type.
func PossibleRetentionPolicyTypeValues() []RetentionPolicyType {
	return []RetentionPolicyType{RetentionPolicyTypeBasic, RetentionPolicyTypeInvalid}
}

// RetentionPolicyTypeBasicBasicRetentionPolicyDescription enumerates the values for retention policy type
// basic basic retention policy description.
type RetentionPolicyTypeBasicBasicRetentionPolicyDescription string

const (
	// RetentionPolicyTypeBasic1 ...
	RetentionPolicyTypeBasic1 RetentionPolicyTypeBasicBasicRetentionPolicyDescription = "Basic"
	// RetentionPolicyTypeRetentionPolicyDescription ...
	RetentionPolicyTypeRetentionPolicyDescription RetentionPolicyTypeBasicBasicRetentionPolicyDescription = "RetentionPolicyDescription"
)

// PossibleRetentionPolicyTypeBasicBasicRetentionPolicyDescriptionValues returns an array of possible values for the RetentionPolicyTypeBasicBasicRetentionPolicyDescription const type.
func PossibleRetentionPolicyTypeBasicBasicRetentionPolicyDescriptionValues() []RetentionPolicyTypeBasicBasicRetentionPolicyDescription {
	return []RetentionPolicyTypeBasicBasicRetentionPolicyDescription{RetentionPolicyTypeBasic1, RetentionPolicyTypeRetentionPolicyDescription}
}

// SafetyCheckKind enumerates the values for safety check kind.
type SafetyCheckKind string

const (
	// SafetyCheckKindEnsureAvailability Indicates that there is either a stateless service partition on the
	// node having exactly one instance, or there is a primary replica on the node for which the partition is
	// quorum loss. In both cases, bringing down the replicas due to upgrade will result in loss of
	// availability. The value is 7.
	SafetyCheckKindEnsureAvailability SafetyCheckKind = "EnsureAvailability"
	// SafetyCheckKindEnsurePartitionQuorum Indicates that there is some partition for which if we bring down
	// the replica on the node, it will result in quorum loss for that partition. The value is 2.
	SafetyCheckKindEnsurePartitionQuorum SafetyCheckKind = "EnsurePartitionQuorum"
	// SafetyCheckKindEnsureSeedNodeQuorum Indicates that if we bring down the node then this will result in
	// global seed node quorum loss. The value is 1.
	SafetyCheckKindEnsureSeedNodeQuorum SafetyCheckKind = "EnsureSeedNodeQuorum"
	// SafetyCheckKindInvalid Indicates that the upgrade safety check kind is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	SafetyCheckKindInvalid SafetyCheckKind = "Invalid"
	// SafetyCheckKindWaitForInbuildReplica Indicates that there is either a replica on the node that is going
	// through copy, or there is a primary replica on the node that is copying data to some other replica. In
	// both cases, bringing down the replica on the node due to upgrade will abort the copy. The value is 6.
	SafetyCheckKindWaitForInbuildReplica SafetyCheckKind = "WaitForInbuildReplica"
	// SafetyCheckKindWaitForPrimaryPlacement Indicates that there is some replica on the node that was moved
	// out of this node due to upgrade. Service Fabric is now waiting for the primary to be moved back to this
	// node. The value is 3.
	SafetyCheckKindWaitForPrimaryPlacement SafetyCheckKind = "WaitForPrimaryPlacement"
	// SafetyCheckKindWaitForPrimarySwap Indicates that Service Fabric is waiting for a primary replica to be
	// moved out of the node before starting upgrade on that node. The value is 4.
	SafetyCheckKindWaitForPrimarySwap SafetyCheckKind = "WaitForPrimarySwap"
	// SafetyCheckKindWaitForReconfiguration Indicates that there is some replica on the node that is involved
	// in a reconfiguration. Service Fabric is waiting for the reconfiguration to be complete before staring
	// upgrade on that node. The value is 5.
	SafetyCheckKindWaitForReconfiguration SafetyCheckKind = "WaitForReconfiguration"
)

// PossibleSafetyCheckKindValues returns an array of possible values for the SafetyCheckKind const type.
func PossibleSafetyCheckKindValues() []SafetyCheckKind {
	return []SafetyCheckKind{SafetyCheckKindEnsureAvailability, SafetyCheckKindEnsurePartitionQuorum, SafetyCheckKindEnsureSeedNodeQuorum, SafetyCheckKindInvalid, SafetyCheckKindWaitForInbuildReplica, SafetyCheckKindWaitForPrimaryPlacement, SafetyCheckKindWaitForPrimarySwap, SafetyCheckKindWaitForReconfiguration}
}

// ScalingMechanismKind enumerates the values for scaling mechanism kind.
type ScalingMechanismKind string

const (
	// ScalingMechanismKindAddRemoveIncrementalNamedPartition Indicates a mechanism for scaling where new named
	// partitions are added or removed from a service. The value is 2.
	ScalingMechanismKindAddRemoveIncrementalNamedPartition ScalingMechanismKind = "AddRemoveIncrementalNamedPartition"
	// ScalingMechanismKindInvalid Indicates the scaling mechanism is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ScalingMechanismKindInvalid ScalingMechanismKind = "Invalid"
	// ScalingMechanismKindPartitionInstanceCount Indicates a mechanism for scaling where new instances are
	// added or removed from a partition. The value is 1.
	ScalingMechanismKindPartitionInstanceCount ScalingMechanismKind = "PartitionInstanceCount"
)

// PossibleScalingMechanismKindValues returns an array of possible values for the ScalingMechanismKind const type.
func PossibleScalingMechanismKindValues() []ScalingMechanismKind {
	return []ScalingMechanismKind{ScalingMechanismKindAddRemoveIncrementalNamedPartition, ScalingMechanismKindInvalid, ScalingMechanismKindPartitionInstanceCount}
}

// ScalingTriggerKind enumerates the values for scaling trigger kind.
type ScalingTriggerKind string

const (
	// ScalingTriggerKindAveragePartitionLoad Indicates a trigger where scaling decisions are made based on
	// average load of a partition. The value is 1.
	ScalingTriggerKindAveragePartitionLoad ScalingTriggerKind = "AveragePartitionLoad"
	// ScalingTriggerKindAverageServiceLoad Indicates a trigger where scaling decisions are made based on
	// average load of a service. The value is 2.
	ScalingTriggerKindAverageServiceLoad ScalingTriggerKind = "AverageServiceLoad"
	// ScalingTriggerKindInvalid Indicates the scaling trigger is invalid. All Service Fabric enumerations have
	// the invalid type. The value is zero.
	ScalingTriggerKindInvalid ScalingTriggerKind = "Invalid"
)

// PossibleScalingTriggerKindValues returns an array of possible values for the ScalingTriggerKind const type.
func PossibleScalingTriggerKindValues() []ScalingTriggerKind {
	return []ScalingTriggerKind{ScalingTriggerKindAveragePartitionLoad, ScalingTriggerKindAverageServiceLoad, ScalingTriggerKindInvalid}
}

// ScheduleKind enumerates the values for schedule kind.
type ScheduleKind string

const (
	// ScheduleKindBackupScheduleDescription ...
	ScheduleKindBackupScheduleDescription ScheduleKind = "BackupScheduleDescription"
	// ScheduleKindFrequencyBased ...
	ScheduleKindFrequencyBased ScheduleKind = "FrequencyBased"
	// ScheduleKindTimeBased ...
	ScheduleKindTimeBased ScheduleKind = "TimeBased"
)

// PossibleScheduleKindValues returns an array of possible values for the ScheduleKind const type.
func PossibleScheduleKindValues() []ScheduleKind {
	return []ScheduleKind{ScheduleKindBackupScheduleDescription, ScheduleKindFrequencyBased, ScheduleKindTimeBased}
}

// SecretKind enumerates the values for secret kind.
type SecretKind string

const (
	// InlinedValue A simple secret resource whose plaintext value is provided by the user.
	InlinedValue SecretKind = "inlinedValue"
)

// PossibleSecretKindValues returns an array of possible values for the SecretKind const type.
func PossibleSecretKindValues() []SecretKind {
	return []SecretKind{InlinedValue}
}

// ServiceCorrelationScheme enumerates the values for service correlation scheme.
type ServiceCorrelationScheme string

const (
	// ServiceCorrelationSchemeAffinity Indicates that this service has an affinity relationship with another
	// service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity
	// options. The value is 1.
	ServiceCorrelationSchemeAffinity ServiceCorrelationScheme = "Affinity"
	// ServiceCorrelationSchemeAlignedAffinity Aligned affinity ensures that the primaries of the partitions of
	// the affinitized services are collocated on the same nodes. This is the default and is the same as
	// selecting the Affinity scheme. The value is 2.
	ServiceCorrelationSchemeAlignedAffinity ServiceCorrelationScheme = "AlignedAffinity"
	// ServiceCorrelationSchemeInvalid An invalid correlation scheme. Cannot be used. The value is zero.
	ServiceCorrelationSchemeInvalid ServiceCorrelationScheme = "Invalid"
	// ServiceCorrelationSchemeNonAlignedAffinity Non-Aligned affinity guarantees that all replicas of each
	// service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas
	// of particular role will be collocated. The value is 3.
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = "NonAlignedAffinity"
)

// PossibleServiceCorrelationSchemeValues returns an array of possible values for the ServiceCorrelationScheme const type.
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return []ServiceCorrelationScheme{ServiceCorrelationSchemeAffinity, ServiceCorrelationSchemeAlignedAffinity, ServiceCorrelationSchemeInvalid, ServiceCorrelationSchemeNonAlignedAffinity}
}

// ServiceEndpointRole enumerates the values for service endpoint role.
type ServiceEndpointRole string

const (
	// ServiceEndpointRoleInvalid Indicates the service endpoint role is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceEndpointRoleInvalid ServiceEndpointRole = "Invalid"
	// ServiceEndpointRoleStatefulPrimary Indicates that the service endpoint is of a primary replica of a
	// stateful service. The value is 2.
	ServiceEndpointRoleStatefulPrimary ServiceEndpointRole = "StatefulPrimary"
	// ServiceEndpointRoleStatefulSecondary Indicates that the service endpoint is of a secondary replica of a
	// stateful service. The value is 3.
	ServiceEndpointRoleStatefulSecondary ServiceEndpointRole = "StatefulSecondary"
	// ServiceEndpointRoleStateless Indicates that the service endpoint is of a stateless service. The value is
	// 1.
	ServiceEndpointRoleStateless ServiceEndpointRole = "Stateless"
)

// PossibleServiceEndpointRoleValues returns an array of possible values for the ServiceEndpointRole const type.
func PossibleServiceEndpointRoleValues() []ServiceEndpointRole {
	return []ServiceEndpointRole{ServiceEndpointRoleInvalid, ServiceEndpointRoleStatefulPrimary, ServiceEndpointRoleStatefulSecondary, ServiceEndpointRoleStateless}
}

// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindInvalid Indicates the service kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ServiceKindInvalid ServiceKind = "Invalid"
	// ServiceKindStateful Uses Service Fabric to make its state or part of its state highly available and
	// reliable. The value is 2.
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless Does not use Service Fabric to make its state highly available or reliable. The
	// value is 1.
	ServiceKindStateless ServiceKind = "Stateless"
)

// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindInvalid, ServiceKindStateful, ServiceKindStateless}
}

// ServiceKindBasicDeployedServiceReplicaDetailInfo enumerates the values for service kind basic deployed
// service replica detail info.
type ServiceKindBasicDeployedServiceReplicaDetailInfo string

const (
	// ServiceKindDeployedServiceReplicaDetailInfo ...
	ServiceKindDeployedServiceReplicaDetailInfo ServiceKindBasicDeployedServiceReplicaDetailInfo = "DeployedServiceReplicaDetailInfo"
	// ServiceKindStateful1 ...
	ServiceKindStateful1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateful"
	// ServiceKindStateless1 ...
	ServiceKindStateless1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateless"
)

// PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaDetailInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues() []ServiceKindBasicDeployedServiceReplicaDetailInfo {
	return []ServiceKindBasicDeployedServiceReplicaDetailInfo{ServiceKindDeployedServiceReplicaDetailInfo, ServiceKindStateful1, ServiceKindStateless1}
}

// ServiceKindBasicDeployedServiceReplicaInfo enumerates the values for service kind basic deployed service
// replica info.
type ServiceKindBasicDeployedServiceReplicaInfo string

const (
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ServiceKindBasicDeployedServiceReplicaInfo = "DeployedServiceReplicaInfo"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ServiceKindBasicDeployedServiceReplicaInfo = "Stateful"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ServiceKindBasicDeployedServiceReplicaInfo = "Stateless"
)

// PossibleServiceKindBasicDeployedServiceReplicaInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaInfoValues() []ServiceKindBasicDeployedServiceReplicaInfo {
	return []ServiceKindBasicDeployedServiceReplicaInfo{ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless}
}

// ServiceKindBasicReplicaHealth enumerates the values for service kind basic replica health.
type ServiceKindBasicReplicaHealth string

const (
	// ServiceKindBasicReplicaHealthServiceKindReplicaHealth ...
	ServiceKindBasicReplicaHealthServiceKindReplicaHealth ServiceKindBasicReplicaHealth = "ReplicaHealth"
	// ServiceKindBasicReplicaHealthServiceKindStateful ...
	ServiceKindBasicReplicaHealthServiceKindStateful ServiceKindBasicReplicaHealth = "Stateful"
	// ServiceKindBasicReplicaHealthServiceKindStateless ...
	ServiceKindBasicReplicaHealthServiceKindStateless ServiceKindBasicReplicaHealth = "Stateless"
)

// PossibleServiceKindBasicReplicaHealthValues returns an array of possible values for the ServiceKindBasicReplicaHealth const type.
func PossibleServiceKindBasicReplicaHealthValues() []ServiceKindBasicReplicaHealth {
	return []ServiceKindBasicReplicaHealth{ServiceKindBasicReplicaHealthServiceKindReplicaHealth, ServiceKindBasicReplicaHealthServiceKindStateful, ServiceKindBasicReplicaHealthServiceKindStateless}
}

// ServiceKindBasicReplicaHealthState enumerates the values for service kind basic replica health state.
type ServiceKindBasicReplicaHealthState string

const (
	// ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ...
	ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ServiceKindBasicReplicaHealthState = "ReplicaHealthState"
	// ServiceKindBasicReplicaHealthStateServiceKindStateful ...
	ServiceKindBasicReplicaHealthStateServiceKindStateful ServiceKindBasicReplicaHealthState = "Stateful"
	// ServiceKindBasicReplicaHealthStateServiceKindStateless ...
	ServiceKindBasicReplicaHealthStateServiceKindStateless ServiceKindBasicReplicaHealthState = "Stateless"
)

// PossibleServiceKindBasicReplicaHealthStateValues returns an array of possible values for the ServiceKindBasicReplicaHealthState const type.
func PossibleServiceKindBasicReplicaHealthStateValues() []ServiceKindBasicReplicaHealthState {
	return []ServiceKindBasicReplicaHealthState{ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState, ServiceKindBasicReplicaHealthStateServiceKindStateful, ServiceKindBasicReplicaHealthStateServiceKindStateless}
}

// ServiceKindBasicReplicaInfo enumerates the values for service kind basic replica info.
type ServiceKindBasicReplicaInfo string

const (
	// ServiceKindBasicReplicaInfoServiceKindReplicaInfo ...
	ServiceKindBasicReplicaInfoServiceKindReplicaInfo ServiceKindBasicReplicaInfo = "ReplicaInfo"
	// ServiceKindBasicReplicaInfoServiceKindStateful ...
	ServiceKindBasicReplicaInfoServiceKindStateful ServiceKindBasicReplicaInfo = "Stateful"
	// ServiceKindBasicReplicaInfoServiceKindStateless ...
	ServiceKindBasicReplicaInfoServiceKindStateless ServiceKindBasicReplicaInfo = "Stateless"
)

// PossibleServiceKindBasicReplicaInfoValues returns an array of possible values for the ServiceKindBasicReplicaInfo const type.
func PossibleServiceKindBasicReplicaInfoValues() []ServiceKindBasicReplicaInfo {
	return []ServiceKindBasicReplicaInfo{ServiceKindBasicReplicaInfoServiceKindReplicaInfo, ServiceKindBasicReplicaInfoServiceKindStateful, ServiceKindBasicReplicaInfoServiceKindStateless}
}

// ServiceKindBasicServiceDescription enumerates the values for service kind basic service description.
type ServiceKindBasicServiceDescription string

const (
	// ServiceKindBasicServiceDescriptionServiceKindServiceDescription ...
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = "ServiceDescription"
	// ServiceKindBasicServiceDescriptionServiceKindStateful ...
	ServiceKindBasicServiceDescriptionServiceKindStateful ServiceKindBasicServiceDescription = "Stateful"
	// ServiceKindBasicServiceDescriptionServiceKindStateless ...
	ServiceKindBasicServiceDescriptionServiceKindStateless ServiceKindBasicServiceDescription = "Stateless"
)

// PossibleServiceKindBasicServiceDescriptionValues returns an array of possible values for the ServiceKindBasicServiceDescription const type.
func PossibleServiceKindBasicServiceDescriptionValues() []ServiceKindBasicServiceDescription {
	return []ServiceKindBasicServiceDescription{ServiceKindBasicServiceDescriptionServiceKindServiceDescription, ServiceKindBasicServiceDescriptionServiceKindStateful, ServiceKindBasicServiceDescriptionServiceKindStateless}
}

// ServiceKindBasicServiceInfo enumerates the values for service kind basic service info.
type ServiceKindBasicServiceInfo string

const (
	// ServiceKindBasicServiceInfoServiceKindServiceInfo ...
	ServiceKindBasicServiceInfoServiceKindServiceInfo ServiceKindBasicServiceInfo = "ServiceInfo"
	// ServiceKindBasicServiceInfoServiceKindStateful ...
	ServiceKindBasicServiceInfoServiceKindStateful ServiceKindBasicServiceInfo = "Stateful"
	// ServiceKindBasicServiceInfoServiceKindStateless ...
	ServiceKindBasicServiceInfoServiceKindStateless ServiceKindBasicServiceInfo = "Stateless"
)

// PossibleServiceKindBasicServiceInfoValues returns an array of possible values for the ServiceKindBasicServiceInfo const type.
func PossibleServiceKindBasicServiceInfoValues() []ServiceKindBasicServiceInfo {
	return []ServiceKindBasicServiceInfo{ServiceKindBasicServiceInfoServiceKindServiceInfo, ServiceKindBasicServiceInfoServiceKindStateful, ServiceKindBasicServiceInfoServiceKindStateless}
}

// ServiceKindBasicServicePartitionInfo enumerates the values for service kind basic service partition info.
type ServiceKindBasicServicePartitionInfo string

const (
	// ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ...
	ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ServiceKindBasicServicePartitionInfo = "ServicePartitionInfo"
	// ServiceKindBasicServicePartitionInfoServiceKindStateful ...
	ServiceKindBasicServicePartitionInfoServiceKindStateful ServiceKindBasicServicePartitionInfo = "Stateful"
	// ServiceKindBasicServicePartitionInfoServiceKindStateless ...
	ServiceKindBasicServicePartitionInfoServiceKindStateless ServiceKindBasicServicePartitionInfo = "Stateless"
)

// PossibleServiceKindBasicServicePartitionInfoValues returns an array of possible values for the ServiceKindBasicServicePartitionInfo const type.
func PossibleServiceKindBasicServicePartitionInfoValues() []ServiceKindBasicServicePartitionInfo {
	return []ServiceKindBasicServicePartitionInfo{ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo, ServiceKindBasicServicePartitionInfoServiceKindStateful, ServiceKindBasicServicePartitionInfoServiceKindStateless}
}

// ServiceKindBasicServiceUpdateDescription enumerates the values for service kind basic service update
// description.
type ServiceKindBasicServiceUpdateDescription string

const (
	// ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ServiceKindBasicServiceUpdateDescription = "ServiceUpdateDescription"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ServiceKindBasicServiceUpdateDescription = "Stateful"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ServiceKindBasicServiceUpdateDescription = "Stateless"
)

// PossibleServiceKindBasicServiceUpdateDescriptionValues returns an array of possible values for the ServiceKindBasicServiceUpdateDescription const type.
func PossibleServiceKindBasicServiceUpdateDescriptionValues() []ServiceKindBasicServiceUpdateDescription {
	return []ServiceKindBasicServiceUpdateDescription{ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription, ServiceKindBasicServiceUpdateDescriptionServiceKindStateful, ServiceKindBasicServiceUpdateDescriptionServiceKindStateless}
}

// ServiceLoadMetricWeight enumerates the values for service load metric weight.
type ServiceLoadMetricWeight string

const (
	// ServiceLoadMetricWeightHigh Specifies the metric weight of the service load as High. The value is 3.
	ServiceLoadMetricWeightHigh ServiceLoadMetricWeight = "High"
	// ServiceLoadMetricWeightLow Specifies the metric weight of the service load as Low. The value is 1.
	ServiceLoadMetricWeightLow ServiceLoadMetricWeight = "Low"
	// ServiceLoadMetricWeightMedium Specifies the metric weight of the service load as Medium. The value is 2.
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = "Medium"
	// ServiceLoadMetricWeightZero Disables resource balancing for this metric. This value is zero.
	ServiceLoadMetricWeightZero ServiceLoadMetricWeight = "Zero"
)

// PossibleServiceLoadMetricWeightValues returns an array of possible values for the ServiceLoadMetricWeight const type.
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return []ServiceLoadMetricWeight{ServiceLoadMetricWeightHigh, ServiceLoadMetricWeightLow, ServiceLoadMetricWeightMedium, ServiceLoadMetricWeightZero}
}

// ServiceOperationName enumerates the values for service operation name.
type ServiceOperationName string

const (
	// ServiceOperationNameAbort The service replica or instance is being aborted.
	ServiceOperationNameAbort ServiceOperationName = "Abort"
	// ServiceOperationNameChangeRole The service replica is changing roles.
	ServiceOperationNameChangeRole ServiceOperationName = "ChangeRole"
	// ServiceOperationNameClose The service replica or instance is being closed.
	ServiceOperationNameClose ServiceOperationName = "Close"
	// ServiceOperationNameNone The service replica or instance is not going through any life-cycle changes.
	ServiceOperationNameNone ServiceOperationName = "None"
	// ServiceOperationNameOpen The service replica or instance is being opened.
	ServiceOperationNameOpen ServiceOperationName = "Open"
	// ServiceOperationNameUnknown Reserved for future use.
	ServiceOperationNameUnknown ServiceOperationName = "Unknown"
)

// PossibleServiceOperationNameValues returns an array of possible values for the ServiceOperationName const type.
func PossibleServiceOperationNameValues() []ServiceOperationName {
	return []ServiceOperationName{ServiceOperationNameAbort, ServiceOperationNameChangeRole, ServiceOperationNameClose, ServiceOperationNameNone, ServiceOperationNameOpen, ServiceOperationNameUnknown}
}

// ServicePackageActivationMode enumerates the values for service package activation mode.
type ServicePackageActivationMode string

const (
	// ExclusiveProcess With this activation mode, each replica or instance of service, on a given node, will
	// have its own dedicated activation of service package on a node. The value is 1.
	ExclusiveProcess ServicePackageActivationMode = "ExclusiveProcess"
	// SharedProcess This is the default activation mode. With this activation mode, replicas or instances from
	// different partition(s) of service, on a given node, will share same activation of service package on a
	// node. The value is zero.
	SharedProcess ServicePackageActivationMode = "SharedProcess"
)

// PossibleServicePackageActivationModeValues returns an array of possible values for the ServicePackageActivationMode const type.
func PossibleServicePackageActivationModeValues() []ServicePackageActivationMode {
	return []ServicePackageActivationMode{ExclusiveProcess, SharedProcess}
}

// ServicePartitionKind enumerates the values for service partition kind.
type ServicePartitionKind string

const (
	// ServicePartitionKindInt64Range Indicates that the partition is based on Int64 key ranges, and
	// UniformInt64RangePartitionSchemeDescription was specified while creating the service. The value is 2.
	ServicePartitionKindInt64Range ServicePartitionKind = "Int64Range"
	// ServicePartitionKindInvalid Indicates the partition kind is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionKindInvalid ServicePartitionKind = "Invalid"
	// ServicePartitionKindNamed Indicates that the partition is based on string names, and
	// NamedPartitionInformation  was specified while creating the service. The value is 3.
	ServicePartitionKindNamed ServicePartitionKind = "Named"
	// ServicePartitionKindSingleton Indicates that there is only one partition, and
	// SingletonPartitionSchemeDescription was specified while creating the service. The value is 1.
	ServicePartitionKindSingleton ServicePartitionKind = "Singleton"
)

// PossibleServicePartitionKindValues returns an array of possible values for the ServicePartitionKind const type.
func PossibleServicePartitionKindValues() []ServicePartitionKind {
	return []ServicePartitionKind{ServicePartitionKindInt64Range, ServicePartitionKindInvalid, ServicePartitionKindNamed, ServicePartitionKindSingleton}
}

// ServicePartitionKindBasicPartitionInformation enumerates the values for service partition kind basic
// partition information.
type ServicePartitionKindBasicPartitionInformation string

const (
	// ServicePartitionKindInt64Range1 ...
	ServicePartitionKindInt64Range1 ServicePartitionKindBasicPartitionInformation = "Int64Range"
	// ServicePartitionKindNamed1 ...
	ServicePartitionKindNamed1 ServicePartitionKindBasicPartitionInformation = "Named"
	// ServicePartitionKindPartitionInformation ...
	ServicePartitionKindPartitionInformation ServicePartitionKindBasicPartitionInformation = "PartitionInformation"
	// ServicePartitionKindSingleton1 ...
	ServicePartitionKindSingleton1 ServicePartitionKindBasicPartitionInformation = "Singleton"
)

// PossibleServicePartitionKindBasicPartitionInformationValues returns an array of possible values for the ServicePartitionKindBasicPartitionInformation const type.
func PossibleServicePartitionKindBasicPartitionInformationValues() []ServicePartitionKindBasicPartitionInformation {
	return []ServicePartitionKindBasicPartitionInformation{ServicePartitionKindInt64Range1, ServicePartitionKindNamed1, ServicePartitionKindPartitionInformation, ServicePartitionKindSingleton1}
}

// ServicePartitionStatus enumerates the values for service partition status.
type ServicePartitionStatus string

const (
	// ServicePartitionStatusDeleting Indicates that the partition is being deleted. The value is 5.
	ServicePartitionStatusDeleting ServicePartitionStatus = "Deleting"
	// ServicePartitionStatusInQuorumLoss Indicates that the partition is in quorum loss. This means that
	// number of replicas that are up and participating in a replica set is less than MinReplicaSetSize for
	// this partition. The value is 3.
	ServicePartitionStatusInQuorumLoss ServicePartitionStatus = "InQuorumLoss"
	// ServicePartitionStatusInvalid Indicates the partition status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionStatusInvalid ServicePartitionStatus = "Invalid"
	// ServicePartitionStatusNotReady Indicates that the partition is not ready. This status is returned when
	// none of the other states apply. The value is 2.
	ServicePartitionStatusNotReady ServicePartitionStatus = "NotReady"
	// ServicePartitionStatusReady Indicates that the partition is ready. This means that for a stateless
	// service partition there is at least one instance that is up and for a stateful service partition the
	// number of ready replicas is greater than or equal to the MinReplicaSetSize. The value is 1.
	ServicePartitionStatusReady ServicePartitionStatus = "Ready"
	// ServicePartitionStatusReconfiguring Indicates that the partition is undergoing reconfiguration of its
	// replica sets. This can happen due to failover, upgrade, load balancing or addition or removal of
	// replicas from the replica set. The value is 4.
	ServicePartitionStatusReconfiguring ServicePartitionStatus = "Reconfiguring"
)

// PossibleServicePartitionStatusValues returns an array of possible values for the ServicePartitionStatus const type.
func PossibleServicePartitionStatusValues() []ServicePartitionStatus {
	return []ServicePartitionStatus{ServicePartitionStatusDeleting, ServicePartitionStatusInQuorumLoss, ServicePartitionStatusInvalid, ServicePartitionStatusNotReady, ServicePartitionStatusReady, ServicePartitionStatusReconfiguring}
}

// ServicePlacementPolicyType enumerates the values for service placement policy type.
type ServicePlacementPolicyType string

const (
	// ServicePlacementPolicyTypeInvalid Indicates the type of the placement policy is invalid. All Service
	// Fabric enumerations have the invalid type. The value is zero.
	ServicePlacementPolicyTypeInvalid ServicePlacementPolicyType = "Invalid"
	// ServicePlacementPolicyTypeInvalidDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade
	// domain cannot be used for placement of this service. The value is 1.
	ServicePlacementPolicyTypeInvalidDomain ServicePlacementPolicyType = "InvalidDomain"
	// ServicePlacementPolicyTypeNonPartiallyPlaceService Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible
	// all replicas of a particular partition of the service should be placed atomically. The value is 5.
	ServicePlacementPolicyTypeNonPartiallyPlaceService ServicePlacementPolicyType = "NonPartiallyPlaceService"
	// ServicePlacementPolicyTypePreferPrimaryDomain Indicates that the ServicePlacementPolicyDescription is of
	// type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the Primary
	// replica for the partitions of the service should be located in a particular domain as an optimization.
	// The value is 3.
	ServicePlacementPolicyTypePreferPrimaryDomain ServicePlacementPolicyType = "PreferPrimaryDomain"
	// ServicePlacementPolicyTypeRequireDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service
	// must be placed in a specific domain. The value is 2.
	ServicePlacementPolicyTypeRequireDomain ServicePlacementPolicyType = "RequireDomain"
	// ServicePlacementPolicyTypeRequireDomainDistribution Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementRequireDomainDistributionPolicyDescription, indicating that the system will
	// disallow placement of any two replicas from the same partition in the same domain at any time. The value
	// is 4.
	ServicePlacementPolicyTypeRequireDomainDistribution ServicePlacementPolicyType = "RequireDomainDistribution"
)

// PossibleServicePlacementPolicyTypeValues returns an array of possible values for the ServicePlacementPolicyType const type.
func PossibleServicePlacementPolicyTypeValues() []ServicePlacementPolicyType {
	return []ServicePlacementPolicyType{ServicePlacementPolicyTypeInvalid, ServicePlacementPolicyTypeInvalidDomain, ServicePlacementPolicyTypeNonPartiallyPlaceService, ServicePlacementPolicyTypePreferPrimaryDomain, ServicePlacementPolicyTypeRequireDomain, ServicePlacementPolicyTypeRequireDomainDistribution}
}

// ServiceStatus enumerates the values for service status.
type ServiceStatus string

const (
	// ServiceStatusActive Indicates the service status is active. The value is 1.
	ServiceStatusActive ServiceStatus = "Active"
	// ServiceStatusCreating Indicates the service is being created. The value is 4.
	ServiceStatusCreating ServiceStatus = "Creating"
	// ServiceStatusDeleting Indicates the service is being deleted. The value is 3.
	ServiceStatusDeleting ServiceStatus = "Deleting"
	// ServiceStatusFailed Indicates creation or deletion was terminated due to persistent failures. Another
	// create/delete request can be accepted. The value is 5.
	ServiceStatusFailed ServiceStatus = "Failed"
	// ServiceStatusUnknown Indicates the service status is unknown. The value is zero.
	ServiceStatusUnknown ServiceStatus = "Unknown"
	// ServiceStatusUpgrading Indicates the service is upgrading. The value is 2.
	ServiceStatusUpgrading ServiceStatus = "Upgrading"
)

// PossibleServiceStatusValues returns an array of possible values for the ServiceStatus const type.
func PossibleServiceStatusValues() []ServiceStatus {
	return []ServiceStatus{ServiceStatusActive, ServiceStatusCreating, ServiceStatusDeleting, ServiceStatusFailed, ServiceStatusUnknown, ServiceStatusUpgrading}
}

// ServiceTypeRegistrationStatus enumerates the values for service type registration status.
type ServiceTypeRegistrationStatus string

const (
	// ServiceTypeRegistrationStatusDisabled Indicates that the service type is disabled on this node. A type
	// gets disabled when there are too many failures of the code package hosting the service type. If the
	// service type is disabled, new replicas of that service type will not be placed on the node until it is
	// enabled again. The service type is enabled again after the process hosting it comes up and re-registers
	// the type or a preconfigured time interval has passed. The value is 1.
	ServiceTypeRegistrationStatusDisabled ServiceTypeRegistrationStatus = "Disabled"
	// ServiceTypeRegistrationStatusEnabled Indicates that the service type is enabled on this node. Replicas
	// of this service type can be placed on this node when the code package registers the service type. The
	// value is 2.
	ServiceTypeRegistrationStatusEnabled ServiceTypeRegistrationStatus = "Enabled"
	// ServiceTypeRegistrationStatusInvalid Indicates the registration status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceTypeRegistrationStatusInvalid ServiceTypeRegistrationStatus = "Invalid"
	// ServiceTypeRegistrationStatusRegistered Indicates that the service type is enabled and registered on the
	// node by a code package. Replicas of this service type can now be placed on this node. The value is 3.
	ServiceTypeRegistrationStatusRegistered ServiceTypeRegistrationStatus = "Registered"
)

// PossibleServiceTypeRegistrationStatusValues returns an array of possible values for the ServiceTypeRegistrationStatus const type.
func PossibleServiceTypeRegistrationStatusValues() []ServiceTypeRegistrationStatus {
	return []ServiceTypeRegistrationStatus{ServiceTypeRegistrationStatusDisabled, ServiceTypeRegistrationStatusEnabled, ServiceTypeRegistrationStatusInvalid, ServiceTypeRegistrationStatusRegistered}
}

// SizeTypes enumerates the values for size types.
type SizeTypes string

const (
	// SizeTypesLarge ...
	SizeTypesLarge SizeTypes = "Large"
	// SizeTypesMedium ...
	SizeTypesMedium SizeTypes = "Medium"
	// SizeTypesSmall ...
	SizeTypesSmall SizeTypes = "Small"
)

// PossibleSizeTypesValues returns an array of possible values for the SizeTypes const type.
func PossibleSizeTypesValues() []SizeTypes {
	return []SizeTypes{SizeTypesLarge, SizeTypesMedium, SizeTypesSmall}
}

// State enumerates the values for state.
type State string

const (
	// StateApproved Indicates that the repair task has been approved by the Repair Manager and is safe to
	// execute.
	StateApproved State = "Approved"
	// StateClaimed Indicates that the repair task has been claimed by a repair executor.
	StateClaimed State = "Claimed"
	// StateCompleted Indicates that the repair task has completed, and no further state changes will occur.
	StateCompleted State = "Completed"
	// StateCreated Indicates that the repair task has been created.
	StateCreated State = "Created"
	// StateExecuting Indicates that execution of the repair task is in progress.
	StateExecuting State = "Executing"
	// StateInvalid Indicates that the repair task state is invalid. All Service Fabric enumerations have the
	// invalid value.
	StateInvalid State = "Invalid"
	// StatePreparing Indicates that the Repair Manager is preparing the system to handle the impact of the
	// repair task, usually by taking resources offline gracefully.
	StatePreparing State = "Preparing"
	// StateRestoring Indicates that the Repair Manager is restoring the system to its pre-repair state,
	// usually by bringing resources back online.
	StateRestoring State = "Restoring"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateApproved, StateClaimed, StateCompleted, StateCreated, StateExecuting, StateInvalid, StatePreparing, StateRestoring}
}

// StorageKind enumerates the values for storage kind.
type StorageKind string

const (
	// StorageKindAzureBlobStore ...
	StorageKindAzureBlobStore StorageKind = "AzureBlobStore"
	// StorageKindBackupStorageDescription ...
	StorageKindBackupStorageDescription StorageKind = "BackupStorageDescription"
	// StorageKindFileShare ...
	StorageKindFileShare StorageKind = "FileShare"
)

// PossibleStorageKindValues returns an array of possible values for the StorageKind const type.
func PossibleStorageKindValues() []StorageKind {
	return []StorageKind{StorageKindAzureBlobStore, StorageKindBackupStorageDescription, StorageKindFileShare}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeInvalidDomain ...
	TypeInvalidDomain Type = "InvalidDomain"
	// TypeNonPartiallyPlaceService ...
	TypeNonPartiallyPlaceService Type = "NonPartiallyPlaceService"
	// TypePreferPrimaryDomain ...
	TypePreferPrimaryDomain Type = "PreferPrimaryDomain"
	// TypeRequireDomain ...
	TypeRequireDomain Type = "RequireDomain"
	// TypeRequireDomainDistribution ...
	TypeRequireDomainDistribution Type = "RequireDomainDistribution"
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeInvalidDomain, TypeNonPartiallyPlaceService, TypePreferPrimaryDomain, TypeRequireDomain, TypeRequireDomainDistribution, TypeServicePlacementPolicyDescription}
}

// UpgradeDomainState enumerates the values for upgrade domain state.
type UpgradeDomainState string

const (
	// UpgradeDomainStateCompleted The upgrade domain has completed upgrade. The value is 3
	UpgradeDomainStateCompleted UpgradeDomainState = "Completed"
	// UpgradeDomainStateInProgress The upgrade domain is being upgraded but not complete yet. The value is 2
	UpgradeDomainStateInProgress UpgradeDomainState = "InProgress"
	// UpgradeDomainStateInvalid Indicates the upgrade domain state is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	UpgradeDomainStateInvalid UpgradeDomainState = "Invalid"
	// UpgradeDomainStatePending The upgrade domain has not started upgrading yet. The value is 1
	UpgradeDomainStatePending UpgradeDomainState = "Pending"
)

// PossibleUpgradeDomainStateValues returns an array of possible values for the UpgradeDomainState const type.
func PossibleUpgradeDomainStateValues() []UpgradeDomainState {
	return []UpgradeDomainState{UpgradeDomainStateCompleted, UpgradeDomainStateInProgress, UpgradeDomainStateInvalid, UpgradeDomainStatePending}
}

// UpgradeKind enumerates the values for upgrade kind.
type UpgradeKind string

const (
	// UpgradeKindInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeKindInvalid UpgradeKind = "Invalid"
	// UpgradeKindRolling The upgrade progresses one upgrade domain at a time. The value is 1
	UpgradeKindRolling UpgradeKind = "Rolling"
)

// PossibleUpgradeKindValues returns an array of possible values for the UpgradeKind const type.
func PossibleUpgradeKindValues() []UpgradeKind {
	return []UpgradeKind{UpgradeKindInvalid, UpgradeKindRolling}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeInvalid Indicates the upgrade mode is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeModeInvalid UpgradeMode = "Invalid"
	// UpgradeModeMonitored The upgrade will stop after completing each upgrade domain and automatically
	// monitor health before proceeding. The value is 3
	UpgradeModeMonitored UpgradeMode = "Monitored"
	// UpgradeModeUnmonitoredAuto The upgrade will proceed automatically without performing any health
	// monitoring. The value is 1
	UpgradeModeUnmonitoredAuto UpgradeMode = "UnmonitoredAuto"
	// UpgradeModeUnmonitoredManual The upgrade will stop after completing each upgrade domain, giving the
	// opportunity to manually monitor health before proceeding. The value is 2
	UpgradeModeUnmonitoredManual UpgradeMode = "UnmonitoredManual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeInvalid, UpgradeModeMonitored, UpgradeModeUnmonitoredAuto, UpgradeModeUnmonitoredManual}
}

// UpgradeSortOrder enumerates the values for upgrade sort order.
type UpgradeSortOrder string

const (
	// UpgradeSortOrderDefault Indicates that the default sort order (as specified in cluster manifest) will be
	// used. The value is 1.
	UpgradeSortOrderDefault UpgradeSortOrder = "Default"
	// UpgradeSortOrderInvalid Indicates that this sort order is not valid. All Service Fabric enumerations
	// have the invalid type. The value is 0.
	UpgradeSortOrderInvalid UpgradeSortOrder = "Invalid"
	// UpgradeSortOrderLexicographical Indicates that forward lexicographical sort order (UD names sorted as
	// strings) will be used. The value is 3.
	UpgradeSortOrderLexicographical UpgradeSortOrder = "Lexicographical"
	// UpgradeSortOrderNumeric Indicates that forward numeric sort order (UD names sorted as numbers) will be
	// used. The value is 2.
	UpgradeSortOrderNumeric UpgradeSortOrder = "Numeric"
	// UpgradeSortOrderReverseLexicographical Indicates that reverse lexicographical sort order (UD names
	// sorted as strings) will be used. The value is 5.
	UpgradeSortOrderReverseLexicographical UpgradeSortOrder = "ReverseLexicographical"
	// UpgradeSortOrderReverseNumeric Indicates that reverse numeric sort order (UD names sorted as numbers)
	// will be used. The value is 4.
	UpgradeSortOrderReverseNumeric UpgradeSortOrder = "ReverseNumeric"
)

// PossibleUpgradeSortOrderValues returns an array of possible values for the UpgradeSortOrder const type.
func PossibleUpgradeSortOrderValues() []UpgradeSortOrder {
	return []UpgradeSortOrder{UpgradeSortOrderDefault, UpgradeSortOrderInvalid, UpgradeSortOrderLexicographical, UpgradeSortOrderNumeric, UpgradeSortOrderReverseLexicographical, UpgradeSortOrderReverseNumeric}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The value is 6
	UpgradeStateFailed UpgradeState = "Failed"
	// UpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeStateInvalid UpgradeState = "Invalid"
	// UpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 2
	UpgradeStateRollingBackCompleted UpgradeState = "RollingBackCompleted"
	// UpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version but is not
	// complete yet. The value is 1
	UpgradeStateRollingBackInProgress UpgradeState = "RollingBackInProgress"
	// UpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value is 5
	UpgradeStateRollingForwardCompleted UpgradeState = "RollingForwardCompleted"
	// UpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target version but is not
	// complete yet. The value is 4
	UpgradeStateRollingForwardInProgress UpgradeState = "RollingForwardInProgress"
	// UpgradeStateRollingForwardPending The current upgrade domain has finished upgrading. The overall upgrade
	// is waiting for an explicit move next request in UnmonitoredManual mode or performing health checks in
	// Monitored mode. The value is 3
	UpgradeStateRollingForwardPending UpgradeState = "RollingForwardPending"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateFailed, UpgradeStateInvalid, UpgradeStateRollingBackCompleted, UpgradeStateRollingBackInProgress, UpgradeStateRollingForwardCompleted, UpgradeStateRollingForwardInProgress, UpgradeStateRollingForwardPending}
}

// UpgradeType enumerates the values for upgrade type.
type UpgradeType string

const (
	// UpgradeTypeInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeTypeInvalid UpgradeType = "Invalid"
	// UpgradeTypeRolling The upgrade progresses one upgrade domain at a time. The value is 1.
	UpgradeTypeRolling UpgradeType = "Rolling"
	// UpgradeTypeRollingForceRestart The upgrade gets restarted by force. The value is 2.
	UpgradeTypeRollingForceRestart UpgradeType = "Rolling_ForceRestart"
)

// PossibleUpgradeTypeValues returns an array of possible values for the UpgradeType const type.
func PossibleUpgradeTypeValues() []UpgradeType {
	return []UpgradeType{UpgradeTypeInvalid, UpgradeTypeRolling, UpgradeTypeRollingForceRestart}
}

// VolumeProvider enumerates the values for volume provider.
type VolumeProvider string

const (
	// SFAzureFile Provides volumes that are backed by Azure Files.
	SFAzureFile VolumeProvider = "SFAzureFile"
)

// PossibleVolumeProviderValues returns an array of possible values for the VolumeProvider const type.
func PossibleVolumeProviderValues() []VolumeProvider {
	return []VolumeProvider{SFAzureFile}
}
