# Release Notes - v2.8.40

**Date**: 2026-02-15

## 📝 Executive Summary

```text
2.8.40 2026-02-15

- chore: add Daniel Lewart(@lewart3) to contributors list.
- chore: remediate Arbitrary File Write vulnerability in tmp (GHSA-52f5-9888-hmc6) by forcing update to 0.2.4+ via npm overrides.
- chore: bump version to 2.8.40.
- feat: overhaul InnoDB Redo Log Capacity logic to consider RAM size and workload writes.
- feat: add support for `innodb_dedicated_server` detection in Redo Log diagnostics.
- feat: implement multi-cloud autodiscovery for AWS RDS/Aurora, GCP Cloud SQL, Azure (Flexible/Managed), and DigitalOcean.
- feat: add granular SSL/TLS security checks (certificate expiration, remote user SSL enforcement).
- feat: add infrastructure-aware tuning (SSD/NVMe vs HDD detection and architecture reporting).
- fix: resolve MySQL 9.x compatibility issues and SQL execution regressions (RC 256).
- test: add comprehensive unit test suite for core logic coverage (InnoDB, MyISAM, Query Cache, Stats).
- test: add dedicated unit test for cloud discovery logic (tests/cloud_discovery.t).
- refactor: replace massive system calls (awk, grep, uname, getconf, sysctl) with native Core Perl functions for Linux.
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 12 | +12 | 🚀 |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 2 | +2 | 🚀 |
| Information Points | 10 | +10 | 🚀 |

## 🧪 New Diagnostic Capabilities

### 🛑 New Risk Detections
- Table $dbname.$tbname has no index defined
- innodb_snapshot_isolation is OFF with REPEATABLE-READ (Stricter snapshot isolation is disabled)

### ℹ️ New Information Points
- Auto-generating raw output file: $raw_output_file
- Dumpdir: $opt{dumpdir}
- Dumping information schema
- Dumping performance schema
- Dumping sys schema
- General MyIsam metrics:
- InnoDB Snapshot Isolation: 
- SKIPPING $sys_view
- Transaction Isolation Level: $isolation
- table_definition_cache (

## 🛠️ Internal Commit History

Initial release or no previous tag found.

## ⚙️ Technical Evolutions

### ➕ CLI Options Added
- `--CLOUD`
- `--CONNECTION`
- `--MISC`
- `--Modeling`
- `--OUTPUT`
- `--PERFORMANCE`
- `--Performance`
- `--Security`
- `--System`
- `--architecture`
- `--azure`
- `--bannedports`
- `--buffers`
- `--checkversion`
- `--cloud`
- `--compare-file`
- `--container`
- `--cvefile`
- `--data`
- `--dbgpattern`
- `--debug`
- `--defaultarch`
- `--defaults-extra-file`
- `--defaults-file`
- `--dumpdir`
- `--experimental`
- `--feature`
- `--forcemem`
- `--forceswap`
- `--host`
- `--ignore-tables`
- `--json`
- `--login-path`
- `--max-password-checks`
- `--maxportallowed`
- `--mysqladmin`
- `--mysqlcmd`
- `--noask`
- `--nobad`
- `--nogood`
- `--noinfo`
- `--nondedicated`
- `--noprettyicon`
- `--noprocess`
- `--outputfile`
- `--passenv`
- `--passwordfile`
- `--pipe`
- `--pipe_name`
- `--port`
- `--prettyjson`
- `--protocol`
- `--reportfile`
- `--schemadir`
- `--server-log`
- `--silent`
- `--skippassword`
- `--skipsize`
- `--socket`
- `--ssh-host`
- `--ssh-identity-file`
- `--ssh-password`
- `--ssh-user`
- `--ssl-ca`
- `--storage_type`
- `--sysbench-file`
- `--template`
- `--updateversion`
- `--userenv`

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
