/*========================== begin_copyright_notice ============================

Copyright (C) 2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//
// Builtins in this file use manual mangling that is mismatched with their argument types.
// The following text explains the reason for this.
//
// These i4 conversions use i4 vector input arguments.
// This is reflected in the mangled names generated by the SPIRV translator.
// For example: _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv3_i
// Notice that i4 is mangled as 'i', which is the same as the mangling for 'int'.
//
// Addressing of the i4 datatype is not supported by the GPU hardware; therefore, IGC has to
// promote it to a full byte (i8). The promotion of i4 vector arguments to i8 vector
// arguments is done in the PromoteSubByte pass.
//
// __attribute__((overloadable)) cannot be used here because it would lead to
// mangling based on 'char', which maps to 'c'.
// For example: _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv2_c
// Therefore, we are forced to define these builtins with their original name mangling manually.
//

// ConvertE2M1ToE4M3INTEL
uchar _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELi(char a) {
  return __builtin_IB_shfl_idx4_to_fp8(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat8), a);
}
uchar2 _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv2_i(char1 a) {
  return as_uchar2(__builtin_IB_shfl_idx4_to_fp8_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat8), a.s0));
}
uchar3 _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv3_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat8), a)).xyz;
}
uchar4 _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv4_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat8), a));
}
uchar8 _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv8_i(char4 a) {
  return as_uchar8(__builtin_IB_shfl_idx4_to_fp8_4_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat8), a));
}
uchar16 _Z38__builtin_spirv_ConvertE2M1ToE4M3INTELDv16_i(char8 a) {
  return as_uchar16(__builtin_IB_shfl_idx4_to_fp8_8_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat8), a));
}

// ConvertE2M1ToE5M2INTEL
uchar _Z38__builtin_spirv_ConvertE2M1ToE5M2INTELi(char a) {
  return __builtin_IB_shfl_idx4_to_fp8(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat8), a);
}
uchar2 _Z38__builtin_spirv_ConvertE2M1ToE5M2INTELDv2_i(char1 a) {
  return as_uchar2(__builtin_IB_shfl_idx4_to_fp8_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat8), a.s0));
}
uchar3 _Z38__builtin_spirv_ConvertE2M1ToE5M2INTELDv3_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat8), a)).xyz;
}
uchar4 _Z38__builtin_spirv_ConvertE2M1ToE5M2INTELDv4_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat8), a));
}
uchar8 _Z38__builtin_spirv_ConvertE2M1ToE5M2INTELDv8_i(char4 a) {
  return as_uchar8(__builtin_IB_shfl_idx4_to_fp8_4_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat8), a));
}
uchar16 _Z38__builtin_spirv_ConvertE2M1ToE5M2INTELDv16_i(char8 a) {
  return as_uchar16(__builtin_IB_shfl_idx4_to_fp8_8_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat8), a));
}

// ConvertInt4ToE4M3INTEL
uchar _Z38__builtin_spirv_ConvertInt4ToE4M3INTELi(char a) {
  return __builtin_IB_shfl_idx4_to_fp8(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat8), a);
}
uchar2 _Z38__builtin_spirv_ConvertInt4ToE4M3INTELDv2_i(char1 a) {
  return as_uchar2(__builtin_IB_shfl_idx4_to_fp8_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat8), a.s0));
}
uchar3 _Z38__builtin_spirv_ConvertInt4ToE4M3INTELDv3_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat8), a)).xyz;
}
uchar4 _Z38__builtin_spirv_ConvertInt4ToE4M3INTELDv4_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat8), a));
}
uchar8 _Z38__builtin_spirv_ConvertInt4ToE4M3INTELDv8_i(char4 a) {
  return as_uchar8(__builtin_IB_shfl_idx4_to_fp8_4_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat8), a));
}
uchar16 _Z38__builtin_spirv_ConvertInt4ToE4M3INTELDv16_i(char8 a) {
  return as_uchar16(__builtin_IB_shfl_idx4_to_fp8_8_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat8), a));
}

// ConvertInt4ToE5M2INTEL
uchar _Z38__builtin_spirv_ConvertInt4ToE5M2INTELi(char a) {
  return __builtin_IB_shfl_idx4_to_fp8(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat8), a);
}
uchar2 _Z38__builtin_spirv_ConvertInt4ToE5M2INTELDv2_i(char1 a) {
  return as_uchar2(__builtin_IB_shfl_idx4_to_fp8_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat8), a.s0));
}
uchar3 _Z38__builtin_spirv_ConvertInt4ToE5M2INTELDv3_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat8), a)).xyz;
}
uchar4 _Z38__builtin_spirv_ConvertInt4ToE5M2INTELDv4_i(char2 a) {
  return as_uchar4(__builtin_IB_shfl_idx4_to_fp8_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat8), a));
}
uchar8 _Z38__builtin_spirv_ConvertInt4ToE5M2INTELDv8_i(char4 a) {
  return as_uchar8(__builtin_IB_shfl_idx4_to_fp8_4_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat8), a));
}
uchar16 _Z38__builtin_spirv_ConvertInt4ToE5M2INTELDv16_i(char8 a) {
  return as_uchar16(__builtin_IB_shfl_idx4_to_fp8_8_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat8), a));
}

// ConvertE2M1ToFP16INTEL
half _Z38__builtin_spirv_ConvertE2M1ToFP16INTELi(char a) {
  return as_half(__builtin_IB_shfl_idx4_to_fp16(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat16), a));
}
half2 _Z38__builtin_spirv_ConvertE2M1ToFP16INTELDv2_i(char1 a) {
  return as_half2(__builtin_IB_shfl_idx4_to_fp16_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat16), a.s0));
}
half3 _Z38__builtin_spirv_ConvertE2M1ToFP16INTELDv3_i(char2 a) {
  return as_half4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat16), a)).xyz;
}
half4 _Z38__builtin_spirv_ConvertE2M1ToFP16INTELDv4_i(char2 a) {
  return as_half4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat16), a));
}
half8 _Z38__builtin_spirv_ConvertE2M1ToFP16INTELDv8_i(char4 a) {
  return as_half8(__builtin_IB_shfl_idx4_to_fp16_4_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat16), a));
}
half16 _Z38__builtin_spirv_ConvertE2M1ToFP16INTELDv16_i(char8 a) {
  return as_half16(__builtin_IB_shfl_idx4_to_fp16_8_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_hfloat16), a));
}

// ConvertE2M1ToBF16INTEL
short _Z38__builtin_spirv_ConvertE2M1ToBF16INTELi(char a) {
  return __builtin_IB_shfl_idx4_to_fp16(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat16), a);
}
short2 _Z38__builtin_spirv_ConvertE2M1ToBF16INTELDv2_i(char1 a) {
  return as_short2(__builtin_IB_shfl_idx4_to_fp16_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat16), a.s0));
}
short3 _Z38__builtin_spirv_ConvertE2M1ToBF16INTELDv3_i(char2 a) {
  return as_short4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat16), a)).xyz;
}
short4 _Z38__builtin_spirv_ConvertE2M1ToBF16INTELDv4_i(char2 a) {
  return as_short4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat16), a));
}
short8 _Z38__builtin_spirv_ConvertE2M1ToBF16INTELDv8_i(char4 a) {
  return as_short8(__builtin_IB_shfl_idx4_to_fp16_4_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat16), a));
}
short16 _Z38__builtin_spirv_ConvertE2M1ToBF16INTELDv16_i(char8 a) {
  return as_short16(__builtin_IB_shfl_idx4_to_fp16_8_packed(__builtin_IB_shfl_idx4_lut(LUT_e2m1_to_bfloat16), a));
}

// ConvertInt4ToBF16INTEL
ushort _Z38__builtin_spirv_ConvertInt4ToBF16INTELi(char a) {
  return __builtin_IB_shfl_idx4_to_fp16(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat16), a);
}
ushort2 _Z38__builtin_spirv_ConvertInt4ToBF16INTELDv2_i(char1 a) {
  return as_ushort2(__builtin_IB_shfl_idx4_to_fp16_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat16), a.s0));
}
ushort3 _Z38__builtin_spirv_ConvertInt4ToBF16INTELDv3_i(char2 a) {
  return as_ushort4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat16), a)).xyz;
}
ushort4 _Z38__builtin_spirv_ConvertInt4ToBF16INTELDv4_i(char2 a) {
  return as_ushort4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat16), a));
}
ushort8 _Z38__builtin_spirv_ConvertInt4ToBF16INTELDv8_i(char4 a) {
  return as_ushort8(__builtin_IB_shfl_idx4_to_fp16_4_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat16), a));
}
ushort16 _Z38__builtin_spirv_ConvertInt4ToBF16INTELDv16_i(char8 a) {
  return as_ushort16(__builtin_IB_shfl_idx4_to_fp16_8_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_bfloat16), a));
}

// ConvertInt4ToFP16INTEL
half _Z38__builtin_spirv_ConvertInt4ToFP16INTELi(char a) {
  return as_half(__builtin_IB_shfl_idx4_to_fp16(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat16), a));
}
half2 _Z38__builtin_spirv_ConvertInt4ToFP16INTELDv2_i(char1 a) {
  return as_half2(__builtin_IB_shfl_idx4_to_fp16_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat16), a.s0));
}
half3 _Z38__builtin_spirv_ConvertInt4ToFP16INTELDv3_i(char2 a) {
  return as_half4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat16), a)).xyz;
}
half4 _Z38__builtin_spirv_ConvertInt4ToFP16INTELDv4_i(char2 a) {
  return as_half4(__builtin_IB_shfl_idx4_to_fp16_2_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat16), a));
}
half8 _Z38__builtin_spirv_ConvertInt4ToFP16INTELDv8_i(char4 a) {
  return as_half8(__builtin_IB_shfl_idx4_to_fp16_4_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat16), a));
}
half16 _Z38__builtin_spirv_ConvertInt4ToFP16INTELDv16_i(char8 a) {
  return as_half16(__builtin_IB_shfl_idx4_to_fp16_8_packed(__builtin_IB_shfl_idx4_lut(LUT_int4_to_hfloat16), a));
}
