/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Properties;
import net.eyde.personalblog.beans.Post;
import net.eyde.personalblog.service.InitializationManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ImportExportService {
    private static Properties hibernate_properties;
    private static Log log;
    Properties connProperties;
    String insert_statement = "insert into t_posts (post_id, reference, title, category, content, created, modified, version) values (?,?,?,?,?,?,?,?)";

    static {
        log = LogFactory.getLog(InitializationManager.class);
    }

    public boolean loadDbConnectParms() {
        log.debug((Object)"loading DB connection parameters from hibernate file");
        URL url = this.getClass().getResource("/hibernate.properties");
        hibernate_properties = new Properties();
        try {
            hibernate_properties.load(url.openStream());
        }
        catch (Exception e) {
            log.error((Object)"error loading hibernate properties", (Throwable)e);
            return false;
        }
        log.debug((Object)"DB connect properties loaded");
        return true;
    }

    public void importPostsFromXml() {
        log.debug((Object)"load posts from xml");
        Statement stmt = null;
        Connection conn = null;
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            Class.forName(hibernate_properties.getProperty("hibernate.connection.driver_class"));
            conn = DriverManager.getConnection(String.valueOf(hibernate_properties.getProperty("hibernate.connection.url")) + "?user=" + hibernate_properties.getProperty("hibernate.connection.username") + "&password=" + hibernate_properties.getProperty("hibernate.connection.password"));
            stmt = conn.prepareStatement(this.insert_statement);
        }
        catch (SQLException e) {
            log.debug((Object)("error code:" + e.getErrorCode()));
            log.error((Object)"import error", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"import error", (Throwable)e);
        }
        try {
            SAXReader xmlReader = new SAXReader();
            InputStream is = this.getClass().getResourceAsStream("/backup.xml");
            Document doc = xmlReader.read(is);
            Element root = doc.getRootElement();
            log.debug((Object)("ROOT NAME: " + root.getName()));
            Iterator i = root.elementIterator("t_posts");
            while (i.hasNext()) {
                Element post = (Element)i.next();
                Post work = new Post();
                Iterator j = post.elementIterator();
                while (j.hasNext()) {
                    Element field = (Element)j.next();
                    log.debug((Object)("NAME: " + field.getName()));
                    log.debug((Object)("TEXT: " + field.getText()));
                    if (field.getName().equals("title")) {
                        work.setTitle(field.getText());
                        continue;
                    }
                    if (field.getName().equals("category")) {
                        work.setCategory(field.getText());
                        continue;
                    }
                    if (field.getName().equals("content")) {
                        work.setContent(field.getText());
                        continue;
                    }
                    if (field.getName().equals("created")) {
                        calendar.set(1, Integer.parseInt(field.getText().substring(0, 4)));
                        calendar.set(2, Integer.parseInt(field.getText().substring(5, 7)) - 1);
                        calendar.set(5, Integer.parseInt(field.getText().substring(8, 10)));
                        work.setCreated(calendar.getTime());
                        continue;
                    }
                    if (field.getName().equals("modified")) {
                        calendar.set(1, Integer.parseInt(field.getText().substring(0, 4)));
                        calendar.set(2, Integer.parseInt(field.getText().substring(5, 7)) - 1);
                        calendar.set(5, Integer.parseInt(field.getText().substring(8, 10)));
                        work.setModified(calendar.getTime());
                        continue;
                    }
                    if (field.getName().equals("version")) {
                        work.setVersion(Integer.parseInt(field.getText()));
                        continue;
                    }
                    if (field.getName().equals("post_id")) {
                        work.setId(field.getText());
                        continue;
                    }
                    if (field.getName().equals("reference")) {
                        work.setReference(field.getText());
                        continue;
                    }
                    log.debug((Object)"element not found");
                }
                try {
                    stmt.setString(1, work.getId());
                    stmt.setString(2, work.getReference());
                    stmt.setString(3, work.getTitle());
                    stmt.setString(4, work.getCategory());
                    stmt.setString(5, work.getContent());
                    stmt.setTimestamp(6, new Timestamp(work.getCreated().getTime()));
                    stmt.setTimestamp(7, new Timestamp(work.getModified().getTime()));
                    stmt.setInt(8, work.getVersion());
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    log.debug((Object)("error code:" + e.getErrorCode()));
                    log.error((Object)"import error", (Throwable)e);
                }
            }
        }
        catch (DocumentException de) {
            log.debug((Object)"document error", (Throwable)de);
        }
        catch (Exception e) {
            log.error((Object)"import error", (Throwable)e);
        }
        try {
            log.debug((Object)"Closing connections");
            stmt.close();
            conn.close();
        }
        catch (SQLException se) {
            log.debug((Object)("error code:" + se.getErrorCode()));
            log.debug((Object)"sql error", (Throwable)se);
        }
        catch (Exception e) {
            log.debug((Object)"general error", (Throwable)e);
        }
        log.debug((Object)"create tables- end");
    }
}

