// Class: ReadDNN
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : DNN::DNN
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.07/07       [395015]
Creator        : qati
Date           : Fri Sep 16 00:15:59 2016
Host           : Linux Q 4.4.0-34-generic #53-Ubuntu SMP Wed Jul 27 16:06:39 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /media/share/code/GSOC/wd/notebooks
Training events: 6000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "Normalize" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
Layout: "TANH|100,SOFTSIGN|50,undefined" [neural network layout]
ErrorStrategy: "CROSSENTROPY" [error strategy (regression: sum of squares; classification: crossentropy; multiclass: crossentropy/mutual exclusive cross entropy]
WeightInitialization: "XAVIER" [Weight initialization strategy]
TrainingStrategy: "LearningRate=0.00001,Momentum=0.3,Repetitions=3,ConvergenceSteps=100,BatchSize=30,TestRepetitions=7,WeightDecay=0,Regularization=NONE,DropRepetitions=3,Multithreading=true|LearningRate=0.00001,Momentum=0.3,Repetitions=3,ConvergenceSteps=100,BatchSize=30,TestRepetitions=7,WeightDecay=0,Regularization=NONE,DropRepetitions=3,Multithreading=true|LearningRate=0.00001,Momentum=0.3,Repetitions=3,ConvergenceSteps=100,BatchSize=30,TestRepetitions=7,WeightDecay=0,Regularization=NONE,DropRepetitions=3,Multithreading=true" [defines the training strategies]
SignalWeightsSum: "1.000000e+03" [Sum of weights of signal; Is used to compute the significance on the fly]
BackgroundWeightsSum: "1.000000e+03" [Sum of weights of background; Is used to compute the significance on the fly]
# Default:
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-8.96602058411,7.69307804108]
var1-var2                     myvar2                        myvar2                        Expression 2                  F                                 'F'    [-4.08540010452,4.0258936882]
var3                          var3                          var3                          Variable 3                    F                                 'F'    [-5.05078554153,4.35967063904]
var4                          var4                          var4                          Variable 4                    F                                 'F'    [-5.95050764084,4.92254400253]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   F                                 'F'    [-9.91655540466,9.52782058716]
var1*3                        spec2                         spec2                         Spectator 2                   F                                 'F'    [-14.874833107,14.2917308807]


============================================================================ */

#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadDNN : public IClassifierReader {

 public:

   // constructor
   ReadDNN( std::vector<std::string>& theInputVars ) 
      : IClassifierReader(),
        fClassName( "ReadDNN" ),
        fNvars( 4 ),
        fIsNormalised( false )
   {      
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -1.10738468170166;
      fVmax[0] = 1.02512526512146;
      fVmin[1] = -0.906628906726837;
      fVmax[1] = 1.00079560279846;
      fVmin[2] = -1.06492817401886;
      fVmax[2] = 1.0602114200592;
      fVmin[3] = -1.18707489967346;
      fVmax[3] = 1.01989054679871;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadDNN() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the 
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   double fMin_1[3][4];
   double fMax_1[3][4];
   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   const bool fIsNormalised;
   bool IsNormalised() const { return fIsNormalised; }
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   inline double ReadDNN::GetMvaValue( const std::vector<double>& inputValues ) const
   {
      // classifier response value
      double retval = 0;

      // classifier response, sanity check first
      if (!IsStatusClean()) {
         std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                   << " because status is dirty" << std::endl;
         retval = 0;
      }
      else {
         if (IsNormalised()) {
            // normalise variables
            std::vector<double> iV;
            iV.reserve(inputValues.size());
            int ivar = 0;
            for (std::vector<double>::const_iterator varIt = inputValues.begin();
                 varIt != inputValues.end(); varIt++, ivar++) {
               iV.push_back(NormVariable( *varIt, fVmin[ivar], fVmax[ivar] ));
            }
            Transform( iV, -1 );
            retval = GetMvaValue__( iV );
         }
         else {
            std::vector<double> iV;
            int ivar = 0;
            for (std::vector<double>::const_iterator varIt = inputValues.begin();
                 varIt != inputValues.end(); varIt++, ivar++) {
               iV.push_back(*varIt);
            }
            Transform( iV, -1 );
            retval = GetMvaValue__( iV );
         }
      }

      return retval;
   }

//_______________________________________________________________________
inline void ReadDNN::InitTransform_1()
{
   // Normalization transformation, initialisation
   fMin_1[0][0] = -5.05625915527;
   fMax_1[0][0] = 6.3994679451;
   fMin_1[1][0] = -8.96602058411;
   fMax_1[1][0] = 7.69307804108;
   fMin_1[2][0] = -8.96602058411;
   fMax_1[2][0] = 7.69307804108;
   fMin_1[0][1] = -4.08540010452;
   fMax_1[0][1] = 3.40126919746;
   fMin_1[1][1] = -3.67916750908;
   fMax_1[1][1] = 4.0258936882;
   fMin_1[2][1] = -4.08540010452;
   fMax_1[2][1] = 4.0258936882;
   fMin_1[0][2] = -3.18263268471;
   fMax_1[0][2] = 3.84756541252;
   fMin_1[1][2] = -5.05078554153;
   fMax_1[1][2] = 4.35967063904;
   fMin_1[2][2] = -5.05078554153;
   fMax_1[2][2] = 4.35967063904;
   fMin_1[0][3] = -2.99590206146;
   fMax_1[0][3] = 4.5351858139;
   fMin_1[1][3] = -5.95050764084;
   fMax_1[1][3] = 4.92254400253;
   fMin_1[2][3] = -5.95050764084;
   fMax_1[2][3] = 4.92254400253;
}

//_______________________________________________________________________
inline void ReadDNN::Transform_1( std::vector<double>& iv, int cls) const
{
   // Normalization transformation
   if (cls < 0 || cls > 2) {
   if (2 > 1 ) cls = 2;
      else cls = 2;
   }
   const int nVar = 4;

   // get indices of used variables

   // define the indices of the variables which are transformed by this transformation
   static std::vector<int> indicesGet;
   static std::vector<int> indicesPut;

   if ( indicesGet.empty() ) { 
      indicesGet.reserve(fNvars);
      indicesGet.push_back( 0);
      indicesGet.push_back( 1);
      indicesGet.push_back( 2);
      indicesGet.push_back( 3);
   } 
   if ( indicesPut.empty() ) { 
      indicesPut.reserve(fNvars);
      indicesPut.push_back( 0);
      indicesPut.push_back( 1);
      indicesPut.push_back( 2);
      indicesPut.push_back( 3);
   } 

   static std::vector<double> dv;
   dv.resize(nVar);
   for (int ivar=0; ivar<nVar; ivar++) dv[ivar] = iv[indicesGet.at(ivar)];
   for (int ivar=0;ivar<4;ivar++) {
      double offset = fMin_1[cls][ivar];
      double scale  = 1.0/(fMax_1[cls][ivar]-fMin_1[cls][ivar]);
      iv[indicesPut.at(ivar)] = (dv[ivar]-offset)*scale * 2 - 1;
   }
}

//_______________________________________________________________________
inline void ReadDNN::InitTransform()
{
   InitTransform_1();
}

//_______________________________________________________________________
inline void ReadDNN::Transform( std::vector<double>& iv, int sigOrBgd ) const
{
   Transform_1( iv, sigOrBgd );
}
