// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketCors`](crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name for which to get the cors configuration.</p> <p>When you use this API operation with an access point, provide the alias of the access point in place of the bucket name.</p> <p>When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code <code>InvalidAccessPointAliasError</code> is returned. For more information about <code>InvalidAccessPointAliasError</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`GetBucketCorsOutput`](crate::operation::get_bucket_cors::GetBucketCorsOutput) with field(s):
    ///   - [`cors_rules(Option<Vec::<CorsRule>>)`](crate::operation::get_bucket_cors::GetBucketCorsOutput::cors_rules): <p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketCorsError>`](crate::operation::get_bucket_cors::GetBucketCorsError)
    pub fn get_bucket_cors(&self) -> crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder {
        crate::operation::get_bucket_cors::builders::GetBucketCorsFluentBuilder::new(self.handle.clone())
    }
}
