/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.CSmartSelector;
import org.jkiss.dbeaver.ui.controls.DatabaseLabelProviders;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;

public class SelectDataSourceCombo
extends CSmartSelector<DBPDataSourceContainer> {
    private static final Log log = Log.getLog(SelectDataSourceCombo.class);
    private final List<DBRRunnableParametrized<DBPDataSourceContainer>> listeners = new ArrayList<DBRRunnableParametrized<DBPDataSourceContainer>>();

    public SelectDataSourceCombo(Composite comboGroup) {
        super(comboGroup, 2060, (ILabelProvider)new DatabaseLabelProviders.ConnectionLabelProvider());
    }

    protected void dropDown(boolean drop) {
        if (!drop) {
            return;
        }
        this.showConnectionSelector();
    }

    public void showConnectionSelector() {
        SelectDataSourceDialog dialog = new SelectDataSourceDialog(this.getShell(), this.getActiveProject(), (DBPDataSourceContainer)this.getSelectedItem());
        dialog.setModeless(true);
        if (dialog.open() == 1) {
            return;
        }
        DBPDataSourceContainer dataSource = dialog.getDataSource();
        this.select(dataSource);
        this.onDataSourceChange(dataSource);
    }

    protected DBPProject getActiveProject() {
        return DBWorkbench.getPlatform().getWorkspace().getActiveProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDataSourceChange(DBPDataSourceContainer dataSource) {
        ArrayList<DBRRunnableParametrized<DBPDataSourceContainer>> listenersCopy;
        List<DBRRunnableParametrized<DBPDataSourceContainer>> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<DBRRunnableParametrized<DBPDataSourceContainer>>(this.listeners);
        }
        for (DBRRunnableParametrized dBRRunnableParametrized : listenersCopy) {
            try {
                dBRRunnableParametrized.run((Object)dataSource);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void addSelectionListener(DBRRunnableParametrized<DBPDataSourceContainer> listener) {
        this.listeners.add(listener);
    }

    public void addProjectDataSources() {
        this.addItem(null);
        DBPProject activeProject = this.getActiveProject();
        if (activeProject != null) {
            for (DBPDataSourceContainer ds : activeProject.getDataSourceRegistry().getDataSources()) {
                this.addItem(ds);
            }
        }
    }
}

