/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.exec.DBExceptionWithHistory;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.ProgressMonitorWithExceptionContext;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class DriverDependenciesTree {
    private static final Log log = Log.getLog(DriverDependenciesTree.class);
    public static final String NETWORK_TEST_URL = "https://repo1.maven.org";
    private final DBRRunnableContext runnableContext;
    private final DBPDriver driver;
    private final Collection<? extends DBPDriverLibrary> libraries;
    private final DBPDriverDependencies dependencies;
    private final boolean editable;
    private final Tree filesTree;
    private TreeEditor treeEditor;

    public DriverDependenciesTree(Composite parent, DBRRunnableContext runnableContext, DBPDriverDependencies dependencies, DBPDriver driver, Collection<? extends DBPDriverLibrary> libraries, boolean editable) {
        this.runnableContext = runnableContext;
        this.driver = driver;
        this.libraries = libraries;
        this.dependencies = dependencies;
        this.editable = editable;
        this.filesTree = new Tree(parent, 67584);
        this.filesTree.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.minimumHeight = this.filesTree.getHeaderHeight() + this.filesTree.getItemHeight() * 3;
        this.filesTree.setLayoutData((Object)gd);
        UIUtils.createTreeColumn((Tree)this.filesTree, (int)16384, (String)"File");
        UIUtils.createTreeColumn((Tree)this.filesTree, (int)16384, (String)"Version");
        UIUtils.createTreeColumn((Tree)this.filesTree, (int)16384, (String)"Description");
        if (editable) {
            this.treeEditor = new TreeEditor(this.filesTree);
            this.treeEditor.horizontalAlignment = 131072;
            this.treeEditor.verticalAlignment = 0x1000000;
            this.treeEditor.grabHorizontal = true;
            this.treeEditor.minimumWidth = 50;
            this.filesTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    TreeItem item = DriverDependenciesTree.this.filesTree.getItem(new Point(e.x, e.y));
                    if (item != null && item.getData() instanceof DBPDriverDependencies.DependencyNode && UIUtils.getColumnAtPos((TreeItem)item, (int)e.x, (int)e.y) == 1) {
                        DriverDependenciesTree.this.showVersionEditor(item);
                        return;
                    }
                    DriverDependenciesTree.this.disposeOldEditor();
                }
            });
        }
    }

    public Tree getTree() {
        return this.filesTree;
    }

    public DBPDriver getDriver() {
        return this.driver;
    }

    public Collection<? extends DBPDriverLibrary> getLibraries() {
        return this.libraries;
    }

    public boolean loadLibDependencies() throws DBException {
        boolean resolved = false;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            this.runnableContext.run(true, true, monitor -> {
                ProgressMonitorWithExceptionContext monitorWithExceptions = new ProgressMonitorWithExceptionContext(monitor);
                monitorWithExceptions.beginTask("Resolve dependencies", 100);
                try {
                    this.dependencies.resolveDependencies((DBRProgressMonitor)monitorWithExceptions);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    exceptions.addAll(monitorWithExceptions.getExceptions());
                    monitorWithExceptions.done();
                }
            });
            resolved = true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            exceptions.add(cause);
            throw new DBExceptionWithHistory("Error resolving dependencies", cause, exceptions);
        }
        this.filesTree.removeAll();
        int totalItems = 1;
        for (DBPDriverDependencies.DependencyNode node : this.dependencies.getLibraryMap()) {
            if (this.editable && node.library.getType().equals((Object)DBPDriverLibrary.FileType.license)) continue;
            DBPDriverLibrary library = node.library;
            TreeItem item = new TreeItem(this.filesTree, 0);
            this.grayOutInstalledArtifact(node, item);
            item.setData((Object)node);
            item.setImage(DBeaverIcons.getImage((DBPImage)library.getIcon()));
            item.setText(0, library.getDisplayName());
            item.setText(1, CommonUtils.notEmpty((String)library.getVersion()));
            item.setText(2, CommonUtils.notEmpty((String)library.getDescription()));
            if (this.editable) {
                item.setFont(1, BaseThemeSettings.instance.treeAndTableFontBold);
                item.setText(1, NLS.bind((String)UIConnectionMessages.dialog_driver_download_version_change_label, (Object)item.getText(1)));
            }
            ++totalItems;
            if (!this.addDependencies(item, node)) continue;
            item.setExpanded(true);
            totalItems += item.getItemCount();
        }
        UIUtils.packColumns((Tree)this.filesTree);
        int missingFiles = 0;
        for (DBPDriverDependencies.DependencyNode node : this.dependencies.getLibraryList()) {
            Path localFile = node.library.getLocalFile();
            if (localFile != null && Files.exists(localFile, new LinkOption[0])) continue;
            ++missingFiles;
        }
        if (missingFiles == 0) {
            // empty if block
        }
        return resolved;
    }

    private void grayOutInstalledArtifact(DBPDriverDependencies.DependencyNode node, TreeItem item) {
        Path localFile = node.library.getLocalFile();
        try {
            if (node.library.isInvalidLibrary()) {
                item.setBackground(BaseThemeSettings.instance.colorError);
            } else if (this.editable && localFile != null && Files.exists(localFile, new LinkOption[0]) && Files.size(localFile) > 0L) {
                item.setBackground(BaseThemeSettings.instance.colorSuccess);
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error reading " + node.library.getDisplayName() + " local file"), (Throwable)ex);
        }
    }

    public boolean handleDownloadError(DBException causeException) {
        try {
            this.checkNetworkAccessible();
        }
        catch (DBException dbException) {
            if (causeException instanceof DBExceptionWithHistory) {
                DBExceptionWithHistory exceptionWithHistory = (DBExceptionWithHistory)causeException;
                List exceptions = exceptionWithHistory.getExceptions();
                exceptions.add(dbException);
                DBWorkbench.getPlatformUI().showError("Download error", String.format("Network error: %s", dbException.getMessage()), GeneralUtils.transformExceptionsToStatus((List)exceptions));
            }
            DBWorkbench.getPlatformUI().showError("Download error", String.format("Network error: %s", dbException.getMessage()), (Throwable)dbException);
            return false;
        }
        return true;
    }

    private void checkNetworkAccessible() throws DBException {
        try {
            WebUtils.openConnection((String)NETWORK_TEST_URL, (String)GeneralUtils.getProductTitle());
        }
        catch (IOException e) {
            String message = RuntimeUtils.isWindows() && CommonUtils.hasCause((Throwable)e, SSLHandshakeException.class) ? (DBWorkbench.getPlatform().getApplication().hasProductFeature("connection/simpleTruststore") ? UIConnectionMessages.dialog_driver_download_network_unavailable_cert_msg : UIConnectionMessages.dialog_driver_download_network_unavailable_cert_msg_advanced) : UIConnectionMessages.dialog_driver_download_network_unavailable_msg;
            String exceptionMessage = message + "\n" + e.getClass().getName() + ":" + e.getMessage();
            throw new DBException(exceptionMessage);
        }
    }

    public void resizeTree() {
        if (this.filesTree.isDisposed()) {
            return;
        }
        Shell shell = this.filesTree.getShell();
        Point curSize = shell.getSize();
        int itemHeight = this.filesTree.getItemHeight();
        shell.setSize(curSize.x, Math.min((int)((double)UIUtils.getActiveWorkbenchWindow().getShell().getSize().y * 0.66), shell.computeSize((int)-1, (int)-1).y) + itemHeight * 2);
        shell.layout();
    }

    private boolean addDependencies(TreeItem parent, DBPDriverDependencies.DependencyNode node) {
        List dependencies = node.dependencies;
        if (dependencies != null && !dependencies.isEmpty()) {
            for (DBPDriverDependencies.DependencyNode dep : dependencies) {
                TreeItem item = new TreeItem(parent, 0);
                item.setImage(DBeaverIcons.getImage((DBPImage)dep.library.getIcon()));
                item.setText(0, dep.library.getDisplayName());
                item.setText(1, CommonUtils.notEmpty((String)dep.library.getVersion()));
                item.setText(2, CommonUtils.notEmpty((String)dep.library.getDescription()));
                this.grayOutInstalledArtifact(dep, item);
                if (dep.duplicate) {
                    item.setBackground(BaseThemeSettings.instance.colorWarning);
                    continue;
                }
                this.addDependencies(item, dep);
            }
            return true;
        }
        return false;
    }

    private void disposeOldEditor() {
        Control oldEditor;
        if (this.treeEditor.getEditor() != null) {
            this.treeEditor.getEditor().dispose();
        }
        if ((oldEditor = this.treeEditor.getEditor()) != null) {
            oldEditor.dispose();
        }
    }

    private void showVersionEditor(TreeItem item) {
        this.disposeOldEditor();
        final DBPDriverDependencies.DependencyNode dependencyNode = (DBPDriverDependencies.DependencyNode)item.getData();
        if (dependencyNode == null || dependencyNode.library == null || !dependencyNode.library.isDownloadable()) {
            return;
        }
        final ArrayList<String> allVersions = new ArrayList<String>();
        try {
            this.runnableContext.run(true, true, monitor -> {
                try {
                    allVersions.addAll(dependencyNode.library.getAvailableVersions(monitor));
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Versions", "Error reading versions", e.getTargetException());
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        String currentVersion = CommonUtils.notEmpty((String)dependencyNode.library.getVersion());
        if (!allVersions.contains(currentVersion)) {
            allVersions.add(currentVersion);
        }
        final CCombo editor = new CCombo((Composite)this.filesTree, 12);
        editor.setVisibleItemCount(15);
        editor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newVersion = (String)allVersions.get(editor.getSelectionIndex());
                DriverDependenciesTree.this.disposeOldEditor();
                DBPDriverLibrary dBPDriverLibrary = dependencyNode.library;
                if (dBPDriverLibrary instanceof DriverLibraryMavenArtifact) {
                    DriverLibraryMavenArtifact mavenLib = (DriverLibraryMavenArtifact)dBPDriverLibrary;
                    DriverDependenciesTree.this.setLibraryVersion(mavenLib, newVersion);
                }
            }
        });
        for (String version : allVersions) {
            editor.add(version);
        }
        int currentVersionIndex = allVersions.indexOf(currentVersion);
        editor.setItem(currentVersionIndex, NLS.bind((String)UIConnectionMessages.dialog_driver_download_current_version_label, (Object)currentVersion));
        editor.select(currentVersionIndex);
        this.treeEditor.setEditor((Control)editor, item, 1);
        editor.setListVisible(true);
    }

    protected void setLibraryVersion(DriverLibraryMavenArtifact library, String version) {
    }
}

