/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jexl3.JexlContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPObjectWithOrdinalPosition;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.AlphanumericComparator;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNUtils {
    private static final Log log = Log.getLog(DBNUtils.class);

    @Nullable
    public static DBNDatabaseNode getNodeByObject(@NotNull DBSObject object) {
        DBNModel model = DBNUtils.getNavigatorModel(object);
        return model == null ? null : model.getNodeByObject(object);
    }

    @Nullable
    public static DBNModel getNavigatorModel(@NotNull DBSObject object) {
        DBPProject project = DBUtils.getObjectOwnerProject(object);
        if (project == null) {
            return null;
        }
        return project.getNavigatorModel();
    }

    @Nullable
    public static DBNDatabaseNode getNodeByObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, boolean addFiltered) {
        DBNModel model = DBNUtils.getNavigatorModel(object);
        return model == null ? null : model.getNodeByObject(monitor, object, addFiltered);
    }

    @Nullable
    public static DBNDatabaseNode getChildFolder(@NotNull DBRProgressMonitor monitor, @NotNull DBNDatabaseNode node, @NotNull Class<?> folderType) {
        try {
            for (DBNDatabaseNode childNode : ArrayUtils.safeArray((Object[])node.getChildren(monitor))) {
                Class<?> objectClass;
                DBNDatabaseFolder folder;
                DBXTreeFolder meta;
                if (!(childNode instanceof DBNDatabaseFolder) || CommonUtils.isEmpty((String)(meta = (folder = (DBNDatabaseFolder)childNode).getMeta()).getType()) || (objectClass = meta.getSource().getObjectClass(meta.getType())) == null || !folderType.isAssignableFrom(objectClass)) continue;
                return childNode;
            }
        }
        catch (DBException e) {
            log.error("Error reading child folder", e);
        }
        return null;
    }

    @Nullable
    public static DBNNode[] getNodeChildrenFiltered(@NotNull DBRProgressMonitor monitor, @NotNull DBNNode node, boolean forTree) throws DBException {
        DBNNode[] children = node.getChildren(monitor);
        if (children != null && children.length > 0) {
            children = DBNUtils.filterNavigableChildren(children, forTree);
        }
        return children;
    }

    @NotNull
    public static DBNNode[] filterNavigableChildren(@NotNull DBNNode[] children, boolean forTree) {
        DBNNode[] result;
        if (ArrayUtils.isEmpty((Object[])children)) {
            return children;
        }
        if (forTree) {
            ArrayList<DBNNode> filtered = new ArrayList<DBNNode>();
            for (DBNNode node : children) {
                DBNDatabaseNode dbNode;
                DBPHiddenObject hiddenObject;
                if (node instanceof DBPHiddenObject && (hiddenObject = (DBPHiddenObject)((Object)node)).isHidden() || node instanceof DBNDatabaseNode && !(dbNode = (DBNDatabaseNode)node).getMeta().isNavigable()) continue;
                filtered.add(node);
            }
            result = filtered.toArray(new DBNNode[0]);
        } else {
            result = children;
        }
        DBNUtils.sortNodes(result);
        return result;
    }

    private static void sortNodes(@NotNull DBNNode[] children) {
        DBNDatabaseItem item;
        if (children.length == 0) {
            return;
        }
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        DBNNode firstChild = children[0];
        if (firstChild.getAdapter(Path.class) != null) {
            Arrays.sort(children, NodeFolderComparator.INSTANCE);
            return;
        }
        if (firstChild instanceof DBNContainer) {
            return;
        }
        if (firstChild instanceof DBNDatabaseItem && (item = (DBNDatabaseItem)firstChild).getObject() instanceof DBSTableColumn) {
            if (prefStore.getBoolean("navigator.sort.case.insensitive")) {
                Arrays.sort(children, new NodeNameComparator());
            }
            return;
        }
        if (firstChild instanceof DBNDatabaseItem && (item = (DBNDatabaseItem)firstChild).getObject() instanceof DBPObjectWithOrdinalPosition) {
            return;
        }
        NodeNameComparator comparator = null;
        if (prefStore.getBoolean("navigator.sort.forlers.first") || DBNUtils.isMergedEntity(firstChild)) {
            comparator = NodeFolderComparator.INSTANCE.thenComparing((o1, o2) -> {
                if (o1 instanceof DBNContainer && o2 instanceof DBNContainer) {
                    return 0;
                }
                if (o1 instanceof DBNContainer) {
                    return 1;
                }
                if (o2 instanceof DBNContainer) {
                    return -1;
                }
                return 0;
            });
        }
        if (prefStore.getBoolean("navigator.sort.case.insensitive")) {
            Comparator<DBNNode> comparator2 = comparator = Objects.isNull(comparator) ? new NodeNameComparator() : comparator.thenComparing(new NodeNameComparator());
        }
        if (comparator != null) {
            Arrays.sort(children, comparator);
        }
    }

    private static boolean isMergedEntity(@NotNull DBNNode node) {
        DBNDatabaseNode dbNode;
        return node instanceof DBNDatabaseNode && (dbNode = (DBNDatabaseNode)node).getObject() instanceof DBSEntity && dbNode.getObject().getDataSource().getContainer().getNavigatorSettings().isMergeEntities();
    }

    public static boolean isDefaultElement(@Nullable Object element) {
        if (element instanceof DBSWrapper) {
            DBSWrapper wrapper = (DBSWrapper)element;
            DBSObject object = wrapper.getObject();
            if (object != null) {
                DBCExecutionContextDefaults contextDefaults;
                DBCExecutionContext defaultContext;
                if (object instanceof DBSInstance) {
                    DBSInstance i = (DBSInstance)object;
                    DBSObject dBSObject = object.getParentObject();
                    if (dBSObject instanceof DBSInstanceContainer) {
                        DBSInstanceContainer ic = (DBSInstanceContainer)dBSObject;
                        return ic.getDefaultInstance() == i;
                    }
                }
                if ((defaultContext = DBUtils.getDefaultContext(object, false)) != null && (contextDefaults = defaultContext.getContextDefaults()) != null) {
                    return Objects.equals(contextDefaults.getDefaultCatalog(), object) || Objects.equals(contextDefaults.getDefaultSchema(), object);
                }
            }
        } else if (element instanceof DBNProject) {
            DBNProject nodeProject = (DBNProject)element;
            return nodeProject.getProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        }
        return false;
    }

    @NotNull
    public static String getLastNodePathSegment(@NotNull String path) {
        int divPos = path.lastIndexOf(47);
        return divPos == -1 ? path : path.substring(divPos + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isReadOnly(@NotNull DBNNode node) {
        if (!(node instanceof DBNDatabaseNode)) return false;
        DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
        if (node instanceof DBNDataSource) return false;
        if (dbNode.getDataSourceContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) return false;
        return true;
    }

    public static boolean isFolderNode(@NotNull DBNNode node) {
        return node.allowsChildren();
    }

    @Nullable
    public static DBXTreeItem getValidItemsMeta(@NotNull DBRProgressMonitor monitor, @NotNull DBNDatabaseNode dbNode) throws DBException {
        DBXTreeNode dBXTreeNode;
        List<DBXTreeNode> childMetas;
        Class<?> expectedChildrenType;
        DBXTreeItem itemsMeta = dbNode.getItemsMeta();
        if (itemsMeta != null && itemsMeta.isOptional() && (expectedChildrenType = dbNode.getChildrenOrFolderClass(itemsMeta)) != null && (childMetas = itemsMeta.getChildren(dbNode)).size() == 1 && (dBXTreeNode = childMetas.getFirst()) instanceof DBXTreeItem) {
            DBXTreeItem nestedMeta = (DBXTreeItem)dBXTreeNode;
            DBNDatabaseNode[] nodeChildren = dbNode.getChildren(monitor);
            if (nodeChildren != null && nodeChildren.length > 0 && !expectedChildrenType.isInstance(nodeChildren[0].getObject())) {
                itemsMeta = nestedMeta;
            }
        }
        return itemsMeta;
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<T> type, DBNNode node) {
        if (node == null) {
            return null;
        }
        for (DBNNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (type.isInstance(parent)) {
                return type.cast(parent);
            }
            if (parent instanceof DBNRoot) break;
        }
        return null;
    }

    public static JexlContext makeContext(final @NotNull DBNNode node) {
        return new JexlContext(){

            public Object get(String name) {
                if (node instanceof DBNDatabaseNode) {
                    DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
                    switch (name) {
                        case "object": {
                            return dbNode.getValueObject();
                        }
                        case "dataSource": {
                            return dbNode.getDataSource();
                        }
                        case "connected": {
                            return dbNode.getDataSource() != null;
                        }
                    }
                }
                return null;
            }

            public void set(String name, Object value) {
                log.warn("Set is not implemented in DBX model");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean has(String name) {
                if (!(node instanceof DBNDatabaseNode)) return false;
                DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
                if (!name.equals("object")) return false;
                if (dbNode.getValueObject() == null) return false;
                return true;
            }
        };
    }

    public static String decodeNodePath(@NotNull String nodePath) {
        return nodePath.replace("%2F", "/").replace("%25", "%");
    }

    public static String encodeNodePath(@NotNull String path) {
        return path.replace("%", "%25").replace("/", "%2F");
    }

    public static void disposeNode(@NotNull DBNNode node, boolean reflect) {
        node.dispose(reflect);
    }

    @Nullable
    public static DBNDatabaseNode getDefaultDatabaseNodeToOpen(DBRProgressMonitor monitor, DBPDataSource dataSource) throws DBException {
        DBSObject objectToOpen;
        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
        if (dataSource instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)((Object)dataSource);
            DBNUtils.getConnectionEntities(monitor, container, entities);
        }
        if ((objectToOpen = entities.size() == 1 ? (DBSObject)entities.getFirst() : (entities.size() > 1 ? ((DBSEntity)entities.getFirst()).getParentObject() : dataSource)) == null) {
            throw new DBException("No entities found in file datasource");
        }
        return DBNUtils.getNodeByObject(monitor, objectToOpen, true);
    }

    private static void getConnectionEntities(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull List<DBSEntity> entities) throws DBException {
        for (DBSObject child : CommonUtils.safeCollection(container.getChildren(monitor))) {
            if (child instanceof DBSEntity) {
                DBSEntity entity = (DBSEntity)child;
                entities.add(entity);
                continue;
            }
            if (!(child instanceof DBSObjectContainer)) continue;
            DBSObjectContainer oc = (DBSObjectContainer)child;
            DBNUtils.getConnectionEntities(monitor, oc, entities);
        }
    }

    private static class NodeFolderComparator
    implements Comparator<DBNNode> {
        static final NodeFolderComparator INSTANCE = new NodeFolderComparator();

        private NodeFolderComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            int first = NodeFolderComparator.isFolderNode(node1) ? -1 : 1;
            int second = NodeFolderComparator.isFolderNode(node2) ? -1 : 1;
            return first - second;
        }

        private static boolean isFolderNode(DBNNode node) {
            DBNDatabaseNode dbn;
            if (node instanceof DBNDatabaseNode && (dbn = (DBNDatabaseNode)node).getObject() instanceof DBPObjectWithOrdinalPosition) {
                return false;
            }
            return node instanceof DBNContainer || node.allowsChildren();
        }
    }

    private static class NodeNameComparator
    implements Comparator<DBNNode> {
        private final AlphanumericComparator alphanumericComparator = AlphanumericComparator.getInstance();
        private final boolean caseInsensitive = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.sort.case.insensitive.ignore.case");

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            return this.caseInsensitive ? this.alphanumericComparator.compareIgnoreCase((CharSequence)node1.getNodeDisplayName(), (CharSequence)node2.getNodeDisplayName()) : this.alphanumericComparator.compare((CharSequence)node1.getNodeDisplayName(), (CharSequence)node2.getNodeDisplayName());
        }
    }
}

