/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.tools;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.ui.tools.ExasolExportTableToolDialog;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ExasolExportTableToolCommandHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ExasolExportTableToolCommandHandler.class);

    public Object execute(ExecutionEvent event) {
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        List tables = CommonUtils.filterCollection((Collection)selectedObjects, ExasolTable.class);
        List views = CommonUtils.filterCollection((Collection)selectedObjects, ExasolView.class);
        List schemas = CommonUtils.filterCollection((Collection)selectedObjects, ExasolSchema.class);
        for (Object schema : schemas) {
            try {
                tables.addAll(schema.getTables((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        HashSet<ExasolTableBase> tableBaseObjects = new HashSet<ExasolTableBase>();
        for (ExasolTable table : tables) {
            tableBaseObjects.add((ExasolTableBase)table);
        }
        for (ExasolView view : views) {
            tableBaseObjects.add((ExasolTableBase)view);
        }
        if (!tableBaseObjects.isEmpty()) {
            ExasolExportTableToolDialog dialog = new ExasolExportTableToolDialog(HandlerUtil.getActivePart((ExecutionEvent)event).getSite(), tableBaseObjects);
            return dialog.open();
        }
        return null;
    }
}

