/*
Licensed to the Software Freedom Conservancy (SFC) under one
or more contributor license agreements. See the NOTICE file
distributed with this work for additional information
regarding copyright ownership. The SFC licenses this file
to you under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#ifndef keycodes_h
#define keycodes_h

#define WD_KEY_NULL      0xE000U
#define WD_KEY_CANCEL    0xE001U
#define WD_KEY_HELP      0xE002U
#define WD_KEY_BACKSPACE 0xE003U
#define WD_KEY_TAB       0xE004U
#define WD_KEY_CLEAR     0xE005U
#define WD_KEY_RETURN    0xE006U
#define WD_KEY_ENTER     0xE007U
#define WD_KEY_SHIFT     0xE008U
#define WD_KEY_CONTROL   0xE009U
#define WD_KEY_ALT       0xE00AU
#define WD_KEY_PAUSE     0xE00BU
#define WD_KEY_ESCAPE    0xE00CU
#define WD_KEY_SPACE     0xE00DU
#define WD_KEY_PAGEUP    0xE00EU
#define WD_KEY_PAGEDOWN  0xE00FU
#define WD_KEY_END       0xE010U
#define WD_KEY_HOME      0xE011U
#define WD_KEY_LEFT      0xE012U
#define WD_KEY_UP        0xE013U
#define WD_KEY_RIGHT     0xE014U
#define WD_KEY_DOWN      0xE015U
#define WD_KEY_INSERT    0xE016U
#define WD_KEY_DELETE    0xE017U
#define WD_KEY_SEMICOLON 0xE018U
#define WD_KEY_EQUALS    0xE019U
#define WD_KEY_NUMPAD0   0xE01AU
#define WD_KEY_NUMPAD1   0xE01BU
#define WD_KEY_NUMPAD2   0xE01CU
#define WD_KEY_NUMPAD3   0xE01DU
#define WD_KEY_NUMPAD4   0xE01EU
#define WD_KEY_NUMPAD5   0xE01FU
#define WD_KEY_NUMPAD6   0xE020U
#define WD_KEY_NUMPAD7   0xE021U
#define WD_KEY_NUMPAD8   0xE022U
#define WD_KEY_NUMPAD9   0xE023U
#define WD_KEY_MULTIPLY  0xE024U
#define WD_KEY_ADD       0xE025U
#define WD_KEY_SEPARATOR 0xE026U
#define WD_KEY_SUBTRACT  0xE027U
#define WD_KEY_DECIMAL   0xE028U
#define WD_KEY_DIVIDE    0xE029U
#define WD_KEY_F1        0xE031U
#define WD_KEY_F2        0xE032U
#define WD_KEY_F3        0xE033U
#define WD_KEY_F4        0xE034U
#define WD_KEY_F5        0xE035U
#define WD_KEY_F6        0xE036U
#define WD_KEY_F7        0xE037U
#define WD_KEY_F8        0xE038U
#define WD_KEY_F9        0xE039U
#define WD_KEY_F10       0xE03AU
#define WD_KEY_F11       0xE03BU
#define WD_KEY_F12       0xE03CU
#define WD_KEY_META      0xE03DU

#endif  // keycodes_h
