/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;

@NonNullByDefault
public class TopicEventFilter
implements EventFilter {
    private final List<Pattern> topicsRegexes;

    public TopicEventFilter(String topicRegex) {
        this.topicsRegexes = List.of(Pattern.compile(topicRegex));
    }

    public TopicEventFilter(List<String> topicsRegexes) {
        ArrayList<Pattern> tmpTopicsRegexes = new ArrayList<Pattern>();
        for (String topicRegex : topicsRegexes) {
            tmpTopicsRegexes.add(Pattern.compile(topicRegex));
        }
        this.topicsRegexes = Collections.unmodifiableList(tmpTopicsRegexes);
    }

    @Override
    public boolean apply(Event event) {
        return this.topicsRegexes.stream().anyMatch(p -> p.matcher(event.getTopic()).matches());
    }
}

