/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	poolv1beta1 "kubevirt.io/api/pool/v1beta1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachinePoolsGetter has a method to return a VirtualMachinePoolInterface.
// A group's client should implement this interface.
type VirtualMachinePoolsGetter interface {
	VirtualMachinePools(namespace string) VirtualMachinePoolInterface
}

// VirtualMachinePoolInterface has methods to work with VirtualMachinePool resources.
type VirtualMachinePoolInterface interface {
	Create(ctx context.Context, virtualMachinePool *poolv1beta1.VirtualMachinePool, opts v1.CreateOptions) (*poolv1beta1.VirtualMachinePool, error)
	Update(ctx context.Context, virtualMachinePool *poolv1beta1.VirtualMachinePool, opts v1.UpdateOptions) (*poolv1beta1.VirtualMachinePool, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, virtualMachinePool *poolv1beta1.VirtualMachinePool, opts v1.UpdateOptions) (*poolv1beta1.VirtualMachinePool, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*poolv1beta1.VirtualMachinePool, error)
	List(ctx context.Context, opts v1.ListOptions) (*poolv1beta1.VirtualMachinePoolList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *poolv1beta1.VirtualMachinePool, err error)
	VirtualMachinePoolExpansion
}

// virtualMachinePools implements VirtualMachinePoolInterface
type virtualMachinePools struct {
	*gentype.ClientWithList[*poolv1beta1.VirtualMachinePool, *poolv1beta1.VirtualMachinePoolList]
}

// newVirtualMachinePools returns a VirtualMachinePools
func newVirtualMachinePools(c *PoolV1beta1Client, namespace string) *virtualMachinePools {
	return &virtualMachinePools{
		gentype.NewClientWithList[*poolv1beta1.VirtualMachinePool, *poolv1beta1.VirtualMachinePoolList](
			"virtualmachinepools",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *poolv1beta1.VirtualMachinePool { return &poolv1beta1.VirtualMachinePool{} },
			func() *poolv1beta1.VirtualMachinePoolList { return &poolv1beta1.VirtualMachinePoolList{} },
		),
	}
}
