/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	corev1 "kubevirt.io/api/core/v1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachineInstancesGetter has a method to return a VirtualMachineInstanceInterface.
// A group's client should implement this interface.
type VirtualMachineInstancesGetter interface {
	VirtualMachineInstances(namespace string) VirtualMachineInstanceInterface
}

// VirtualMachineInstanceInterface has methods to work with VirtualMachineInstance resources.
type VirtualMachineInstanceInterface interface {
	Create(ctx context.Context, virtualMachineInstance *corev1.VirtualMachineInstance, opts metav1.CreateOptions) (*corev1.VirtualMachineInstance, error)
	Update(ctx context.Context, virtualMachineInstance *corev1.VirtualMachineInstance, opts metav1.UpdateOptions) (*corev1.VirtualMachineInstance, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*corev1.VirtualMachineInstance, error)
	List(ctx context.Context, opts metav1.ListOptions) (*corev1.VirtualMachineInstanceList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *corev1.VirtualMachineInstance, err error)
	VirtualMachineInstanceExpansion
}

// virtualMachineInstances implements VirtualMachineInstanceInterface
type virtualMachineInstances struct {
	*gentype.ClientWithList[*corev1.VirtualMachineInstance, *corev1.VirtualMachineInstanceList]
}

// newVirtualMachineInstances returns a VirtualMachineInstances
func newVirtualMachineInstances(c *KubevirtV1Client, namespace string) *virtualMachineInstances {
	return &virtualMachineInstances{
		gentype.NewClientWithList[*corev1.VirtualMachineInstance, *corev1.VirtualMachineInstanceList](
			"virtualmachineinstances",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *corev1.VirtualMachineInstance { return &corev1.VirtualMachineInstance{} },
			func() *corev1.VirtualMachineInstanceList { return &corev1.VirtualMachineInstanceList{} },
		),
	}
}
