/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/kubernetes-csi/external-snapshotter/client/v4/apis/volumesnapshot/v1"
	gentype "k8s.io/client-go/gentype"
	volumesnapshotv1 "kubevirt.io/client-go/externalsnapshotter/typed/volumesnapshot/v1"
)

// fakeVolumeSnapshotClasses implements VolumeSnapshotClassInterface
type fakeVolumeSnapshotClasses struct {
	*gentype.FakeClientWithList[*v1.VolumeSnapshotClass, *v1.VolumeSnapshotClassList]
	Fake *FakeSnapshotV1
}

func newFakeVolumeSnapshotClasses(fake *FakeSnapshotV1) volumesnapshotv1.VolumeSnapshotClassInterface {
	return &fakeVolumeSnapshotClasses{
		gentype.NewFakeClientWithList[*v1.VolumeSnapshotClass, *v1.VolumeSnapshotClassList](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("volumesnapshotclasses"),
			v1.SchemeGroupVersion.WithKind("VolumeSnapshotClass"),
			func() *v1.VolumeSnapshotClass { return &v1.VolumeSnapshotClass{} },
			func() *v1.VolumeSnapshotClassList { return &v1.VolumeSnapshotClassList{} },
			func(dst, src *v1.VolumeSnapshotClassList) { dst.ListMeta = src.ListMeta },
			func(list *v1.VolumeSnapshotClassList) []*v1.VolumeSnapshotClass {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v1.VolumeSnapshotClassList, items []*v1.VolumeSnapshotClass) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
