/* rpl.c generated by valac 0.56.18, the Vala compiler
 * generated from rpl.vala, do not modify */

/* rpl: search and replace text in files*/
/**/
/* © 2025 Reuben Thomas <rrt@sc3d.org>*/
/**/
/* This program is free software; you can redistribute it and/or modify*/
/* it under the terms of the GNU General Public License as published by*/
/* the Free Software Foundation; either version 3, or (at your option)*/
/* any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, see <https://www.gnu.org/licenses/>.*/

#define _GNU_SOURCE

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <cmdline-vala.h>
#include <pcre2.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <locale.h>
#include <fnmatch.h>
#include <sys/stat.h>
#include <binary-io.h>
#include <unistd.h>
#include <fcntl.h>
#include <uchardet/uchardet.h>
#include <time.h>
#include <stat-time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	CASE_LOWER,
	CASE_UPPER,
	CASE_CAPITALIZED,
	CASE_MIXED
} Case;

#define TYPE_CASE (case_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _pcre2_match_data_free0(var) ((var == NULL) ? NULL : (var = (pcre2_match_data_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FD_INPUT_STREAM (fd_input_stream_get_type ())
#define FD_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FD_INPUT_STREAM, FdInputStream))
#define FD_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FD_INPUT_STREAM, FdInputStreamClass))
#define IS_FD_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FD_INPUT_STREAM))
#define IS_FD_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FD_INPUT_STREAM))
#define FD_INPUT_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FD_INPUT_STREAM, FdInputStreamClass))

typedef struct _FdInputStream FdInputStream;
typedef struct _FdInputStreamClass FdInputStreamClass;

#define TYPE_FD_OUTPUT_STREAM (fd_output_stream_get_type ())
#define FD_OUTPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FD_OUTPUT_STREAM, FdOutputStream))
#define FD_OUTPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FD_OUTPUT_STREAM, FdOutputStreamClass))
#define IS_FD_OUTPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FD_OUTPUT_STREAM))
#define IS_FD_OUTPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FD_OUTPUT_STREAM))
#define FD_OUTPUT_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FD_OUTPUT_STREAM, FdOutputStreamClass))

typedef struct _FdOutputStream FdOutputStream;
typedef struct _FdOutputStreamClass FdOutputStreamClass;
#define _pcre2_code_free0(var) ((var == NULL) ? NULL : (var = (pcre2_code_free (var), NULL)))
#define _pcre2_compile_context_free0(var) ((var == NULL) ? NULL : (var = (pcre2_compile_context_free (var), NULL)))

#define TYPE_PREFIX_INPUT_STREAM (prefix_input_stream_get_type ())
#define PREFIX_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFIX_INPUT_STREAM, PrefixInputStream))
#define PREFIX_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFIX_INPUT_STREAM, PrefixInputStreamClass))
#define IS_PREFIX_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFIX_INPUT_STREAM))
#define IS_PREFIX_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFIX_INPUT_STREAM))
#define PREFIX_INPUT_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFIX_INPUT_STREAM, PrefixInputStreamClass))

typedef struct _PrefixInputStream PrefixInputStream;
typedef struct _PrefixInputStreamClass PrefixInputStreamClass;
#define _uchardet_delete0(var) ((var == NULL) ? NULL : (var = (uchardet_delete (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN gchar* program_name;
VALA_EXTERN gint initial_buf_size;
gint initial_buf_size = 1024 * 1024;
VALA_EXTERN gengetopt_args_info args_info;
gchar* program_name = NULL;
gengetopt_args_info args_info = {0};

VALA_EXTERN void info (const gchar* msg);
VALA_EXTERN void warn (const gchar* msg);
VALA_EXTERN void die (gint code,
          const gchar* msg);
VALA_EXTERN GType case_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Case casetype (GString* str);
VALA_EXTERN GString* caselike (GString* model,
                   GString* str);
VALA_EXTERN void set_string_builder_len (GString* s,
                             gssize new_len);
VALA_EXTERN void append_string_builder_slice (GString* a,
                                  GString* b,
                                  gssize start,
                                  gssize end);
VALA_EXTERN void append_string_builder_tail (GString* a,
                                 GString* b,
                                 gssize start);
VALA_EXTERN gsize check_utf8 (guchar* init_s,
                  gsize len);
VALA_EXTERN gboolean read_all (GInputStream* input,
                   GString* buf,
                   GError** error);
VALA_EXTERN void write_all (GOutputStream* output,
                guint8* buf,
                gsize len,
                GError** error);
VALA_EXTERN GString* string_builder_sized (gsize size);
VALA_EXTERN gssize replace (GInputStream* input,
                const gchar* input_filename,
                GOutputStream* output,
                pcre2_code* old_regex,
                uint32_t replace_opts,
                GString* new_pattern,
                GError** error);
VALA_EXTERN void remove_temp_file (const gchar* tmp_path);
VALA_EXTERN GList* get_dir_tree (GFile* file);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN GString* slurp_patterns (const gchar* filename);
static gint _vala_main (gchar** argv,
                 gint argv_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN FdInputStream* fd_input_stream_new (gint fd);
VALA_EXTERN FdInputStream* fd_input_stream_construct (GType object_type,
                                          gint fd);
VALA_EXTERN GType fd_input_stream_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FdInputStream, g_object_unref)
VALA_EXTERN FdOutputStream* fd_output_stream_new (gint fd);
VALA_EXTERN FdOutputStream* fd_output_stream_construct (GType object_type,
                                            gint fd);
VALA_EXTERN GType fd_output_stream_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FdOutputStream, g_object_unref)
VALA_EXTERN PrefixInputStream* prefix_input_stream_new (guint8* prefix,
                                            gint prefix_length1,
                                            GInputStream* base_stream);
VALA_EXTERN PrefixInputStream* prefix_input_stream_construct (GType object_type,
                                                  guint8* prefix,
                                                  gint prefix_length1,
                                                  GInputStream* base_stream);
VALA_EXTERN GType prefix_input_stream_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrefixInputStream, g_object_unref)
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 199 "rpl.c"
}

void
info (const gchar* msg)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 26 "rpl.vala"
	g_return_if_fail (msg != NULL);
#line 27 "rpl.vala"
	_tmp0_ = stderr;
#line 27 "rpl.vala"
	_tmp1_ = string_to_string (msg);
#line 27 "rpl.vala"
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
#line 27 "rpl.vala"
	_tmp3_ = _tmp2_;
#line 27 "rpl.vala"
	fprintf (_tmp0_, "%s", _tmp3_);
#line 27 "rpl.vala"
	_g_free0 (_tmp3_);
#line 223 "rpl.c"
}

void
warn (const gchar* msg)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 30 "rpl.vala"
	g_return_if_fail (msg != NULL);
#line 31 "rpl.vala"
	_tmp0_ = program_name;
#line 31 "rpl.vala"
	_tmp1_ = string_to_string (_tmp0_);
#line 31 "rpl.vala"
	_tmp2_ = string_to_string (msg);
#line 31 "rpl.vala"
	_tmp3_ = g_strconcat (_tmp1_, ": ", _tmp2_, NULL);
#line 31 "rpl.vala"
	_tmp4_ = _tmp3_;
#line 31 "rpl.vala"
	info (_tmp4_);
#line 31 "rpl.vala"
	_g_free0 (_tmp4_);
#line 250 "rpl.c"
}

void
die (gint code,
     const gchar* msg)
{
#line 34 "rpl.vala"
	g_return_if_fail (msg != NULL);
#line 35 "rpl.vala"
	warn (msg);
#line 36 "rpl.vala"
	exit (code);
#line 263 "rpl.c"
}

static GType
case_get_type_once (void)
{
	static const GEnumValue values[] = {{CASE_LOWER, "CASE_LOWER", "lower"}, {CASE_UPPER, "CASE_UPPER", "upper"}, {CASE_CAPITALIZED, "CASE_CAPITALIZED", "capitalized"}, {CASE_MIXED, "CASE_MIXED", "mixed"}, {0, NULL, NULL}};
	GType case_type_id;
	case_type_id = g_enum_register_static ("Case", values);
	return case_type_id;
}

GType
case_get_type (void)
{
	static volatile gsize case_type_id__once = 0;
	if (g_once_init_enter (&case_type_id__once)) {
		GType case_type_id;
		case_type_id = case_get_type_once ();
		g_once_init_leave (&case_type_id__once, case_type_id);
	}
	return case_type_id__once;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
#line 1302 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1303 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1304 "glib-2.0.vapi"
	if (_vala_c != ((gunichar) 0)) {
#line 300 "rpl.c"
		gchar* _tmp0_;
#line 1305 "glib-2.0.vapi"
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1305 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1306 "glib-2.0.vapi"
		result = TRUE;
#line 1306 "glib-2.0.vapi"
		if (c) {
#line 1306 "glib-2.0.vapi"
			*c = _vala_c;
#line 312 "rpl.c"
		}
#line 1306 "glib-2.0.vapi"
		return result;
#line 316 "rpl.c"
	} else {
#line 1308 "glib-2.0.vapi"
		result = FALSE;
#line 1308 "glib-2.0.vapi"
		if (c) {
#line 1308 "glib-2.0.vapi"
			*c = _vala_c;
#line 324 "rpl.c"
		}
#line 1308 "glib-2.0.vapi"
		return result;
#line 328 "rpl.c"
	}
}

Case
casetype (GString* str)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint index = 0;
	gunichar c = 0U;
	gboolean ok = FALSE;
	const gchar* _tmp6_;
	gunichar _tmp7_ = 0U;
	gboolean _tmp8_;
	Case result;
#line 49 "rpl.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 49 "rpl.vala"
	_vala_return_val_if_fail (str->len > ((gssize) 0), "str.len > 0", 0);
#line 52 "rpl.vala"
	_tmp0_ = str->str;
#line 52 "rpl.vala"
	_tmp1_ = g_utf8_strup (_tmp0_, str->len);
#line 52 "rpl.vala"
	_tmp2_ = str->str;
#line 52 "rpl.vala"
	if (memcmp (_tmp1_, _tmp2_, (gsize) str->len) == 0) {
#line 53 "rpl.vala"
		result = CASE_UPPER;
#line 53 "rpl.vala"
		return result;
#line 361 "rpl.c"
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
#line 54 "rpl.vala"
		_tmp3_ = str->str;
#line 54 "rpl.vala"
		_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 54 "rpl.vala"
		_tmp5_ = str->str;
#line 54 "rpl.vala"
		if (memcmp (_tmp4_, _tmp5_, (gsize) str->len) == 0) {
#line 55 "rpl.vala"
			result = CASE_LOWER;
#line 55 "rpl.vala"
			return result;
#line 378 "rpl.c"
		}
	}
#line 58 "rpl.vala"
	index = 0;
#line 59 "rpl.vala"
	c = (gunichar) 0;
#line 60 "rpl.vala"
	_tmp6_ = str->str;
#line 60 "rpl.vala"
	_tmp8_ = string_get_next_char (_tmp6_, &index, &_tmp7_);
#line 60 "rpl.vala"
	c = _tmp7_;
#line 60 "rpl.vala"
	ok = _tmp8_;
#line 61 "rpl.vala"
	_vala_assert (ok, "ok");
#line 62 "rpl.vala"
	if (g_unichar_isupper (c)) {
#line 397 "rpl.c"
		gboolean all_lower = FALSE;
#line 64 "rpl.vala"
		all_lower = TRUE;
#line 66 "rpl.vala"
		while (TRUE) {
#line 403 "rpl.c"
			const gchar* _tmp9_;
			gunichar _tmp10_ = 0U;
			gboolean _tmp11_;
#line 66 "rpl.vala"
			_tmp9_ = str->str;
#line 66 "rpl.vala"
			_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
#line 66 "rpl.vala"
			c = _tmp10_;
#line 66 "rpl.vala"
			if (!_tmp11_) {
#line 66 "rpl.vala"
				break;
#line 417 "rpl.c"
			}
#line 67 "rpl.vala"
			if (!g_unichar_islower (c)) {
#line 68 "rpl.vala"
				all_lower = FALSE;
#line 423 "rpl.c"
			}
		}
#line 71 "rpl.vala"
		if (all_lower) {
#line 72 "rpl.vala"
			result = CASE_CAPITALIZED;
#line 72 "rpl.vala"
			return result;
#line 432 "rpl.c"
		}
	}
#line 75 "rpl.vala"
	result = CASE_MIXED;
#line 75 "rpl.vala"
	return result;
#line 439 "rpl.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 453 "rpl.c"
}

GString*
caselike (GString* model,
          GString* str)
{
	GString* res = NULL;
	GString* _tmp0_;
	GString* result;
#line 78 "rpl.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 78 "rpl.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 79 "rpl.vala"
	_tmp0_ = g_string_new ("");
#line 79 "rpl.vala"
	res = _tmp0_;
#line 80 "rpl.vala"
	if (str->len > ((gssize) 0)) {
#line 81 "rpl.vala"
		switch (casetype (model)) {
#line 81 "rpl.vala"
			case CASE_LOWER:
#line 477 "rpl.c"
			{
				GString* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
#line 83 "rpl.vala"
				_tmp1_ = res;
#line 83 "rpl.vala"
				_tmp2_ = str->str;
#line 83 "rpl.vala"
				_tmp3_ = g_utf8_strdown (_tmp2_, str->len);
#line 83 "rpl.vala"
				_tmp4_ = _tmp3_;
#line 83 "rpl.vala"
				g_string_append_len (_tmp1_, _tmp4_, str->len);
#line 83 "rpl.vala"
				_g_free0 (_tmp4_);
#line 84 "rpl.vala"
				break;
#line 497 "rpl.c"
			}
#line 81 "rpl.vala"
			case CASE_UPPER:
#line 501 "rpl.c"
			{
				GString* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
#line 86 "rpl.vala"
				_tmp5_ = res;
#line 86 "rpl.vala"
				_tmp6_ = str->str;
#line 86 "rpl.vala"
				_tmp7_ = g_utf8_strup (_tmp6_, str->len);
#line 86 "rpl.vala"
				_tmp8_ = _tmp7_;
#line 86 "rpl.vala"
				g_string_append_len (_tmp5_, _tmp8_, str->len);
#line 86 "rpl.vala"
				_g_free0 (_tmp8_);
#line 87 "rpl.vala"
				break;
#line 521 "rpl.c"
			}
#line 81 "rpl.vala"
			case CASE_CAPITALIZED:
#line 525 "rpl.c"
			{
				{
					gint index = 0;
					gunichar c = 0U;
					gboolean ok = FALSE;
					const gchar* _tmp9_;
					gunichar _tmp10_ = 0U;
					gboolean _tmp11_;
					GString* _tmp12_;
					const gchar* _tmp13_;
					GString* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 89 "rpl.vala"
					index = 0;
#line 90 "rpl.vala"
					c = (gunichar) 0;
#line 91 "rpl.vala"
					_tmp9_ = str->str;
#line 91 "rpl.vala"
					_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
#line 91 "rpl.vala"
					c = _tmp10_;
#line 91 "rpl.vala"
					ok = _tmp11_;
#line 92 "rpl.vala"
					_vala_assert (ok, "ok");
#line 93 "rpl.vala"
					_tmp12_ = res;
#line 93 "rpl.vala"
					_tmp13_ = str->str;
#line 93 "rpl.vala"
					g_string_append_unichar (_tmp12_, g_unichar_toupper (string_get_char (_tmp13_, (glong) 0)));
#line 94 "rpl.vala"
					_tmp14_ = res;
#line 94 "rpl.vala"
					_tmp15_ = str->str;
#line 94 "rpl.vala"
					_tmp16_ = g_utf8_strdown ((const gchar*) (((gchar*) _tmp15_) + index), str->len - index);
#line 94 "rpl.vala"
					_tmp17_ = _tmp16_;
#line 94 "rpl.vala"
					g_string_append_len (_tmp14_, _tmp17_, str->len - index);
#line 94 "rpl.vala"
					_g_free0 (_tmp17_);
#line 95 "rpl.vala"
					break;
#line 574 "rpl.c"
				}
			}
#line 81 "rpl.vala"
			case CASE_MIXED:
#line 579 "rpl.c"
			{
				GString* _tmp18_;
				const gchar* _tmp19_;
#line 98 "rpl.vala"
				_tmp18_ = res;
#line 98 "rpl.vala"
				_tmp19_ = str->str;
#line 98 "rpl.vala"
				g_string_append_len (_tmp18_, _tmp19_, str->len);
#line 99 "rpl.vala"
				break;
#line 591 "rpl.c"
			}
			default:
#line 81 "rpl.vala"
			break;
#line 596 "rpl.c"
		}
	}
#line 102 "rpl.vala"
	result = res;
#line 102 "rpl.vala"
	return result;
#line 603 "rpl.c"
}

void
set_string_builder_len (GString* s,
                        gssize new_len)
{
	const gchar* _tmp0_;
#line 106 "rpl.vala"
	g_return_if_fail (s != NULL);
#line 106 "rpl.vala"
	_vala_return_if_fail (((gssize) 0) <= new_len, "0 <= new_len");
#line 106 "rpl.vala"
	_vala_return_if_fail (new_len <= s->allocated_len, "new_len <= s.allocated_len");
#line 110 "rpl.vala"
	_tmp0_ = s->str;
#line 110 "rpl.vala"
	((gchar*) _tmp0_)[new_len] = '\0';
#line 111 "rpl.vala"
	s->len = new_len;
#line 623 "rpl.c"
}

void
append_string_builder_slice (GString* a,
                             GString* b,
                             gssize start,
                             gssize end)
{
	const gchar* _tmp0_;
#line 115 "rpl.vala"
	g_return_if_fail (a != NULL);
#line 115 "rpl.vala"
	g_return_if_fail (b != NULL);
#line 115 "rpl.vala"
	_vala_return_if_fail (((gssize) 0) <= start, "0 <= start");
#line 115 "rpl.vala"
	_vala_return_if_fail (start <= end, "start <= end");
#line 115 "rpl.vala"
	_vala_return_if_fail (end <= b->len, "end <= b.len");
#line 120 "rpl.vala"
	_tmp0_ = b->str;
#line 120 "rpl.vala"
	g_string_append_len (a, (const gchar*) (((gchar*) _tmp0_) + start), end - start);
#line 647 "rpl.c"
}

void
append_string_builder_tail (GString* a,
                            GString* b,
                            gssize start)
{
#line 124 "rpl.vala"
	g_return_if_fail (a != NULL);
#line 124 "rpl.vala"
	g_return_if_fail (b != NULL);
#line 124 "rpl.vala"
	_vala_return_if_fail (((gssize) 0) <= start, "0 <= start");
#line 124 "rpl.vala"
	_vala_return_if_fail (start <= b->len, "start <= b.len");
#line 127 "rpl.vala"
	append_string_builder_slice (a, b, start, b->len);
#line 665 "rpl.c"
}

gsize
check_utf8 (guchar* init_s,
            gsize len)
{
	guchar* end = NULL;
	guchar* valid_to = NULL;
	guchar* _tmp8_;
	gsize result;
#line 132 "rpl.vala"
	end = init_s + len;
#line 133 "rpl.vala"
	valid_to = init_s;
#line 134 "rpl.vala"
	while (TRUE) {
#line 682 "rpl.c"
		gboolean _tmp0_ = FALSE;
		guchar* _tmp1_;
		guchar* _tmp2_;
		guchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		guchar* _tmp7_;
#line 134 "rpl.vala"
		_tmp1_ = valid_to;
#line 134 "rpl.vala"
		_tmp2_ = end;
#line 134 "rpl.vala"
		_tmp3_ = valid_to;
#line 134 "rpl.vala"
		_tmp5_ = g_utf8_validate_len ((const gchar*) _tmp1_, _tmp2_ - _tmp3_, &_tmp4_);
#line 134 "rpl.vala"
		valid_to = _tmp4_;
#line 134 "rpl.vala"
		if (!_tmp5_) {
#line 702 "rpl.c"
			guchar* _tmp6_;
#line 135 "rpl.vala"
			_tmp6_ = valid_to;
#line 135 "rpl.vala"
			_tmp0_ = (*_tmp6_) == ((guchar) '\0');
#line 708 "rpl.c"
		} else {
#line 134 "rpl.vala"
			_tmp0_ = FALSE;
#line 712 "rpl.c"
		}
#line 134 "rpl.vala"
		if (!_tmp0_) {
#line 134 "rpl.vala"
			break;
#line 718 "rpl.c"
		}
#line 136 "rpl.vala"
		_tmp7_ = valid_to;
#line 136 "rpl.vala"
		valid_to = _tmp7_ + 1;
#line 724 "rpl.c"
	}
#line 138 "rpl.vala"
	_tmp8_ = valid_to;
#line 138 "rpl.vala"
	result = _tmp8_ - init_s;
#line 138 "rpl.vala"
	return result;
#line 732 "rpl.c"
}

static guint8*
g_string_get_data (GString* self,
                   gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	const gchar* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 5825 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 5826 "glib-2.0.vapi"
	_tmp0_ = self->str;
#line 5826 "glib-2.0.vapi"
	res = (guint8*) _tmp0_;
#line 5826 "glib-2.0.vapi"
	res_length1 = -1;
#line 5826 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 5827 "glib-2.0.vapi"
	res_length1 = (gint) self->len;
#line 5828 "glib-2.0.vapi"
	_tmp1_ = res;
#line 5828 "glib-2.0.vapi"
	_tmp1__length1 = res_length1;
#line 5828 "glib-2.0.vapi"
	if (result_length1) {
#line 5828 "glib-2.0.vapi"
		*result_length1 = _tmp1__length1;
#line 766 "rpl.c"
	}
#line 5828 "glib-2.0.vapi"
	result = _tmp1_;
#line 5828 "glib-2.0.vapi"
	return result;
#line 772 "rpl.c"
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 157 "rpl.vala"
	return self ? g_error_copy (self) : NULL;
#line 780 "rpl.c"
}

gboolean
read_all (GInputStream* input,
          GString* buf,
          GError** error)
{
	gsize n_read = 0UL;
	gengetopt_args_info _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 145 "rpl.vala"
	g_return_val_if_fail (input != NULL, FALSE);
#line 145 "rpl.vala"
	g_return_val_if_fail (buf != NULL, FALSE);
#line 146 "rpl.vala"
	n_read = (gsize) 0;
#line 798 "rpl.c"
	{
		gboolean _tmp0_ = FALSE;
#line 147 "rpl.vala"
		_tmp0_ = TRUE;
#line 147 "rpl.vala"
		while (TRUE) {
#line 147 "rpl.vala"
			if (!_tmp0_) {
#line 807 "rpl.c"
				gboolean _tmp1_ = FALSE;
#line 161 "rpl.vala"
				if (n_read > ((gsize) 0)) {
#line 161 "rpl.vala"
					_tmp1_ = buf->len < buf->allocated_len;
#line 813 "rpl.c"
				} else {
#line 161 "rpl.vala"
					_tmp1_ = FALSE;
#line 817 "rpl.c"
				}
#line 161 "rpl.vala"
				if (!_tmp1_) {
#line 161 "rpl.vala"
					break;
#line 823 "rpl.c"
				}
			}
#line 147 "rpl.vala"
			_tmp0_ = FALSE;
#line 828 "rpl.c"
			{
				guint8* _tmp2_;
				gint _tmp2__length1;
				gint _tmp3_ = 0;
				guint8* _tmp4_;
				gint _tmp4__length1;
				gsize _tmp5_ = 0UL;
#line 149 "rpl.vala"
				_tmp2_ = g_string_get_data (buf, &_tmp3_);
#line 149 "rpl.vala"
				_tmp2__length1 = _tmp3_;
#line 149 "rpl.vala"
				_tmp4_ = _tmp2_;
#line 149 "rpl.vala"
				_tmp4__length1 = _tmp2__length1;
#line 149 "rpl.vala"
				g_input_stream_read_all (input, ((guint8*) (((guint8*) _tmp4_) + buf->len)) + 0, (gsize) (((gint) MIN ((gsize) (buf->allocated_len - buf->len), (gsize) initial_buf_size)) - 0), &_tmp5_, NULL, &_inner_error0_);
#line 149 "rpl.vala"
				n_read = _tmp5_;
#line 149 "rpl.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 850 "rpl.c"
					gboolean _tmp6_ = FALSE;
#line 149 "rpl.vala"
					if (_inner_error0_->domain == G_IO_ERROR) {
#line 854 "rpl.c"
						goto __catch0_g_io_error;
					}
#line 149 "rpl.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 149 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 149 "rpl.vala"
					return _tmp6_;
#line 863 "rpl.c"
				}
			}
			goto __finally0;
			__catch0_g_io_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				GError* _tmp9_;
				GError* _tmp10_;
#line 148 "rpl.vala"
				e = _inner_error0_;
#line 148 "rpl.vala"
				_inner_error0_ = NULL;
#line 154 "rpl.vala"
				_tmp7_ = e;
#line 154 "rpl.vala"
				if (g_error_matches (_tmp7_, G_IO_ERROR, G_IO_ERROR_INVALID_DATA)) {
#line 881 "rpl.c"
					GError* _tmp8_;
#line 155 "rpl.vala"
					_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, "error decoding input");
#line 155 "rpl.vala"
					_inner_error0_ = _tmp8_;
#line 155 "rpl.vala"
					_g_error_free0 (e);
#line 889 "rpl.c"
					goto __finally0;
				}
#line 157 "rpl.vala"
				_tmp9_ = e;
#line 157 "rpl.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 157 "rpl.vala"
				_inner_error0_ = _tmp10_;
#line 157 "rpl.vala"
				_g_error_free0 (e);
#line 900 "rpl.c"
				goto __finally0;
			}
			__finally0:
#line 148 "rpl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 148 "rpl.vala"
				if (_inner_error0_->domain == G_IO_ERROR) {
#line 908 "rpl.c"
					gboolean _tmp11_ = FALSE;
#line 148 "rpl.vala"
					g_propagate_error (error, _inner_error0_);
#line 148 "rpl.vala"
					return _tmp11_;
#line 914 "rpl.c"
				} else {
					gboolean _tmp12_ = FALSE;
#line 148 "rpl.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 148 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 148 "rpl.vala"
					return _tmp12_;
#line 923 "rpl.c"
				}
			}
#line 159 "rpl.vala"
			set_string_builder_len (buf, buf->len + ((gssize) n_read));
#line 928 "rpl.c"
		}
	}
#line 162 "rpl.vala"
	_tmp13_ = args_info;
#line 162 "rpl.vala"
	if (_tmp13_.verbose_given) {
#line 935 "rpl.c"
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 163 "rpl.vala"
		_tmp14_ = g_strdup_printf ("%" G_GSSIZE_FORMAT, buf->len);
#line 163 "rpl.vala"
		_tmp15_ = _tmp14_;
#line 163 "rpl.vala"
		_tmp16_ = g_strconcat ("bytes read: ", _tmp15_, NULL);
#line 163 "rpl.vala"
		_tmp17_ = _tmp16_;
#line 163 "rpl.vala"
		warn (_tmp17_);
#line 163 "rpl.vala"
		_g_free0 (_tmp17_);
#line 163 "rpl.vala"
		_g_free0 (_tmp15_);
#line 954 "rpl.c"
	}
#line 165 "rpl.vala"
	result = buf->len == buf->allocated_len;
#line 165 "rpl.vala"
	return result;
#line 960 "rpl.c"
}

void
write_all (GOutputStream* output,
           guint8* buf,
           gsize len,
           GError** error)
{
	gsize tot_written = 0UL;
	GError* _inner_error0_ = NULL;
#line 171 "rpl.vala"
	g_return_if_fail (output != NULL);
#line 172 "rpl.vala"
	if (output == NULL) {
#line 173 "rpl.vala"
		return;
#line 977 "rpl.c"
	}
#line 175 "rpl.vala"
	tot_written = (gsize) 0;
#line 981 "rpl.c"
	{
		gboolean _tmp0_ = FALSE;
#line 176 "rpl.vala"
		_tmp0_ = TRUE;
#line 176 "rpl.vala"
		while (TRUE) {
#line 988 "rpl.c"
			gsize n_written = 0UL;
			gsize _tmp1_ = 0UL;
#line 176 "rpl.vala"
			if (!_tmp0_) {
#line 180 "rpl.vala"
				if (!(tot_written < len)) {
#line 180 "rpl.vala"
					break;
#line 997 "rpl.c"
				}
			}
#line 176 "rpl.vala"
			_tmp0_ = FALSE;
#line 178 "rpl.vala"
			g_output_stream_write_all (output, ((guint8*) (buf + tot_written)) + 0, (gsize) (((gint) MIN ((gsize) initial_buf_size, len - tot_written)) - 0), &_tmp1_, NULL, &_inner_error0_);
#line 178 "rpl.vala"
			n_written = _tmp1_;
#line 178 "rpl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "rpl.vala"
				if (_inner_error0_->domain == G_IO_ERROR) {
#line 178 "rpl.vala"
					g_propagate_error (error, _inner_error0_);
#line 178 "rpl.vala"
					return;
#line 1014 "rpl.c"
				} else {
#line 178 "rpl.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 178 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 178 "rpl.vala"
					return;
#line 1022 "rpl.c"
				}
			}
#line 179 "rpl.vala"
			tot_written += n_written;
#line 1027 "rpl.c"
		}
	}
}

GString*
string_builder_sized (gsize size)
{
	GString* _tmp0_;
	GString* result;
#line 185 "rpl.vala"
	_tmp0_ = g_string_sized_new (size - 1);
#line 185 "rpl.vala"
	result = _tmp0_;
#line 185 "rpl.vala"
	return result;
#line 1043 "rpl.c"
}

static guint32
_vala_pcre2_pattern_info_maxlookbehind (pcre2_code* self)
{
	guint32 res = 0U;
	guint32 result;
#line 416 "pcre2.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 417 "pcre2.vapi"
	res = (guint32) 0;
#line 418 "pcre2.vapi"
	pcre2_pattern_info (self, PCRE2_INFO_MAXLOOKBEHIND, &res);
#line 419 "pcre2.vapi"
	result = res;
#line 419 "pcre2.vapi"
	return result;
#line 1061 "rpl.c"
}

static pcre2_match_data*
_vala_pcre2_match (pcre2_code* self,
                   PCRE2_UCHAR* subject,
                   gsize subject_len,
                   gsize startoffset,
                   guint32 options,
                   gint* rc)
{
	gint _vala_rc = 0;
	pcre2_match_data* match = NULL;
	pcre2_match_data* _tmp0_;
	pcre2_match_data* _tmp1_;
	pcre2_match_data* _tmp2_;
	pcre2_match_data* result;
#line 436 "pcre2.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 437 "pcre2.vapi"
	_tmp0_ = pcre2_match_data_create_from_pattern (self, NULL);
#line 437 "pcre2.vapi"
	match = _tmp0_;
#line 438 "pcre2.vapi"
	_tmp1_ = match;
#line 438 "pcre2.vapi"
	if (_tmp1_ == NULL) {
#line 439 "pcre2.vapi"
		_vala_rc = (gint) PCRE2_ERROR_NOMEMORY;
#line 440 "pcre2.vapi"
		result = NULL;
#line 440 "pcre2.vapi"
		_pcre2_match_data_free0 (match);
#line 440 "pcre2.vapi"
		if (rc) {
#line 440 "pcre2.vapi"
			*rc = _vala_rc;
#line 1098 "rpl.c"
		}
#line 440 "pcre2.vapi"
		return result;
#line 1102 "rpl.c"
	}
#line 442 "pcre2.vapi"
	_tmp2_ = match;
#line 442 "pcre2.vapi"
	_vala_rc = pcre2_match (self, subject, subject_len / sizeof (PCRE2_UCHAR), startoffset, options, _tmp2_, NULL);
#line 443 "pcre2.vapi"
	result = match;
#line 443 "pcre2.vapi"
	if (rc) {
#line 443 "pcre2.vapi"
		*rc = _vala_rc;
#line 1114 "rpl.c"
	}
#line 443 "pcre2.vapi"
	return result;
#line 1118 "rpl.c"
}

static gchar*
_vala_pcre2_get_error_message (gint errorcode)
{
	guint8* msg = NULL;
	guint8* _tmp0_;
	gint msg_length1;
	gint _msg_size_;
	gint rc = 0;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
#line 560 "pcre2.vapi"
	_tmp0_ = g_new0 (guint8, 256);
#line 560 "pcre2.vapi"
	msg = _tmp0_;
#line 560 "pcre2.vapi"
	msg_length1 = 256;
#line 560 "pcre2.vapi"
	_msg_size_ = msg_length1;
#line 561 "pcre2.vapi"
	_tmp1_ = msg;
#line 561 "pcre2.vapi"
	_tmp1__length1 = msg_length1;
#line 561 "pcre2.vapi"
	rc = pcre2_get_error_message (errorcode, _tmp1_, (size_t) _tmp1__length1);
#line 562 "pcre2.vapi"
	if (rc < 0) {
#line 1151 "rpl.c"
		gchar* _tmp2_;
#line 563 "pcre2.vapi"
		_tmp2_ = g_strdup ("Error getting error message!");
#line 563 "pcre2.vapi"
		result = _tmp2_;
#line 563 "pcre2.vapi"
		msg = (g_free (msg), NULL);
#line 563 "pcre2.vapi"
		return result;
#line 1161 "rpl.c"
	}
#line 565 "pcre2.vapi"
	_tmp3_ = msg;
#line 565 "pcre2.vapi"
	_tmp3__length1 = msg_length1;
#line 565 "pcre2.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 565 "pcre2.vapi"
	result = _tmp4_;
#line 565 "pcre2.vapi"
	msg = (g_free (msg), NULL);
#line 565 "pcre2.vapi"
	return result;
#line 1175 "rpl.c"
}

static gsize*
pcre2_get_ovector (pcre2_match_data* self,
                   gint* result_length1)
{
	gsize* result;
	gsize* vec = NULL;
	gsize* _tmp0_;
	gint vec_length1;
	gint _vec_size_;
	gsize* _tmp1_;
	gint _tmp1__length1;
#line 526 "pcre2.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 527 "pcre2.vapi"
	_tmp0_ = pcre2_get_ovector_pointer (self);
#line 527 "pcre2.vapi"
	vec = (gsize*) _tmp0_;
#line 527 "pcre2.vapi"
	vec_length1 = sizeof (gsize) / sizeof (gsize);
#line 527 "pcre2.vapi"
	_vec_size_ = vec_length1;
#line 528 "pcre2.vapi"
	vec_length1 = ((gint) pcre2_get_ovector_count (self)) * 2;
#line 529 "pcre2.vapi"
	_tmp1_ = vec;
#line 529 "pcre2.vapi"
	_tmp1__length1 = vec_length1;
#line 529 "pcre2.vapi"
	if (result_length1) {
#line 529 "pcre2.vapi"
		*result_length1 = _tmp1__length1;
#line 1209 "rpl.c"
	}
#line 529 "pcre2.vapi"
	result = _tmp1_;
#line 529 "pcre2.vapi"
	return result;
#line 1215 "rpl.c"
}

static gsize
pcre2_group_start (pcre2_match_data* self,
                   guint32 n)
{
	gsize* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gsize* _tmp2_;
	gint _tmp2__length1;
	gsize _tmp3_;
	gsize result;
#line 533 "pcre2.vapi"
	g_return_val_if_fail (self != NULL, 0UL);
#line 534 "pcre2.vapi"
	if (n > pcre2_get_ovector_count (self)) {
#line 535 "pcre2.vapi"
		result = (gsize) G_MAXSIZE;
#line 535 "pcre2.vapi"
		return result;
#line 1237 "rpl.c"
	}
#line 537 "pcre2.vapi"
	_tmp0_ = pcre2_get_ovector (self, &_tmp1_);
#line 537 "pcre2.vapi"
	_tmp0__length1 = _tmp1_;
#line 537 "pcre2.vapi"
	_tmp2_ = _tmp0_;
#line 537 "pcre2.vapi"
	_tmp2__length1 = _tmp0__length1;
#line 537 "pcre2.vapi"
	_tmp3_ = _tmp2_[n * 2];
#line 537 "pcre2.vapi"
	result = _tmp3_;
#line 537 "pcre2.vapi"
	return result;
#line 1253 "rpl.c"
}

static gsize
pcre2_group_end (pcre2_match_data* self,
                 guint32 n)
{
	gsize* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gsize* _tmp2_;
	gint _tmp2__length1;
	gsize _tmp3_;
	gsize result;
#line 540 "pcre2.vapi"
	g_return_val_if_fail (self != NULL, 0UL);
#line 541 "pcre2.vapi"
	if (n > pcre2_get_ovector_count (self)) {
#line 542 "pcre2.vapi"
		result = (gsize) G_MAXSIZE;
#line 542 "pcre2.vapi"
		return result;
#line 1275 "rpl.c"
	}
#line 544 "pcre2.vapi"
	_tmp0_ = pcre2_get_ovector (self, &_tmp1_);
#line 544 "pcre2.vapi"
	_tmp0__length1 = _tmp1_;
#line 544 "pcre2.vapi"
	_tmp2_ = _tmp0_;
#line 544 "pcre2.vapi"
	_tmp2__length1 = _tmp0__length1;
#line 544 "pcre2.vapi"
	_tmp3_ = _tmp2_[(n * 2) + 1];
#line 544 "pcre2.vapi"
	result = _tmp3_;
#line 544 "pcre2.vapi"
	return result;
#line 1291 "rpl.c"
}

static GString*
_vala_pcre2_substitute (pcre2_code* self,
                        PCRE2_UCHAR* subject,
                        gsize subject_len,
                        gsize startoffset,
                        uint32_t options,
                        pcre2_match_data* match,
                        GString* replacement,
                        gint* rc)
{
	gint _vala_rc = 0;
	gsize out_length = 0UL;
	GString* output = NULL;
	GString* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GString* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	GString* _tmp20_;
	GString* result;
#line 459 "pcre2.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 459 "pcre2.vapi"
	g_return_val_if_fail (match != NULL, NULL);
#line 459 "pcre2.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 461 "pcre2.vapi"
	if ((options & PCRE2_SUBSTITUTE_REPLACEMENT_ONLY) == PCRE2_SUBSTITUTE_REPLACEMENT_ONLY) {
#line 462 "pcre2.vapi"
		out_length = (gsize) replacement->len;
#line 1334 "rpl.c"
	} else {
#line 464 "pcre2.vapi"
		out_length = subject_len + replacement->len;
#line 1338 "rpl.c"
	}
#line 467 "pcre2.vapi"
	_tmp0_ = g_string_sized_new (out_length);
#line 467 "pcre2.vapi"
	output = _tmp0_;
#line 468 "pcre2.vapi"
	_tmp1_ = g_string_get_data (replacement, &_tmp2_);
#line 468 "pcre2.vapi"
	_tmp1__length1 = _tmp2_;
#line 468 "pcre2.vapi"
	_tmp3_ = _tmp1_;
#line 468 "pcre2.vapi"
	_tmp3__length1 = _tmp1__length1;
#line 468 "pcre2.vapi"
	_tmp4_ = output;
#line 468 "pcre2.vapi"
	_tmp5_ = g_string_get_data (_tmp4_, &_tmp6_);
#line 468 "pcre2.vapi"
	_tmp5__length1 = _tmp6_;
#line 468 "pcre2.vapi"
	_tmp7_ = _tmp5_;
#line 468 "pcre2.vapi"
	_tmp7__length1 = _tmp5__length1;
#line 468 "pcre2.vapi"
	_tmp8_ = pcre2_substitute (self, subject, subject_len, startoffset, options | PCRE2_SUBSTITUTE_OVERFLOW_LENGTH, match, NULL, _tmp3_, (gsize) replacement->len, _tmp7_, &out_length);
#line 468 "pcre2.vapi"
	_vala_rc = _tmp8_;
#line 469 "pcre2.vapi"
	if (_vala_rc == ((gint) PCRE2_ERROR_NOMEMORY)) {
#line 1368 "rpl.c"
		GString* _tmp9_;
		guint8* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_ = 0;
		guint8* _tmp12_;
		gint _tmp12__length1;
		GString* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_ = 0;
		guint8* _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_;
#line 470 "pcre2.vapi"
		_tmp9_ = g_string_sized_new (out_length);
#line 470 "pcre2.vapi"
		_g_string_free0 (output);
#line 470 "pcre2.vapi"
		output = _tmp9_;
#line 471 "pcre2.vapi"
		_tmp10_ = g_string_get_data (replacement, &_tmp11_);
#line 471 "pcre2.vapi"
		_tmp10__length1 = _tmp11_;
#line 471 "pcre2.vapi"
		_tmp12_ = _tmp10_;
#line 471 "pcre2.vapi"
		_tmp12__length1 = _tmp10__length1;
#line 471 "pcre2.vapi"
		_tmp13_ = output;
#line 471 "pcre2.vapi"
		_tmp14_ = g_string_get_data (_tmp13_, &_tmp15_);
#line 471 "pcre2.vapi"
		_tmp14__length1 = _tmp15_;
#line 471 "pcre2.vapi"
		_tmp16_ = _tmp14_;
#line 471 "pcre2.vapi"
		_tmp16__length1 = _tmp14__length1;
#line 471 "pcre2.vapi"
		_tmp17_ = pcre2_substitute (self, subject, subject_len, startoffset, options, match, NULL, _tmp12_, (gsize) replacement->len, _tmp16_, &out_length);
#line 471 "pcre2.vapi"
		_vala_rc = _tmp17_;
#line 472 "pcre2.vapi"
		_vala_assert (_vala_rc != ((gint) PCRE2_ERROR_NOMEMORY), "rc != Error.NOMEMORY");
#line 1412 "rpl.c"
	}
#line 474 "pcre2.vapi"
	_tmp18_ = output;
#line 474 "pcre2.vapi"
	_tmp19_ = _tmp18_->str;
#line 474 "pcre2.vapi"
	((gchar*) _tmp19_)[out_length] = '\0';
#line 475 "pcre2.vapi"
	_tmp20_ = output;
#line 475 "pcre2.vapi"
	_tmp20_->len = (gssize) out_length;
#line 476 "pcre2.vapi"
	result = output;
#line 476 "pcre2.vapi"
	if (rc) {
#line 476 "pcre2.vapi"
		*rc = _vala_rc;
#line 1430 "rpl.c"
	}
#line 476 "pcre2.vapi"
	return result;
#line 1434 "rpl.c"
}

gssize
replace (GInputStream* input,
         const gchar* input_filename,
         GOutputStream* output,
         pcre2_code* old_regex,
         uint32_t replace_opts,
         GString* new_pattern,
         GError** error)
{
	gboolean lookbehind = FALSE;
	gssize num_matches = 0L;
#line 197 "rpl.vala"
	static const gsize MAX_LOOKBEHIND_BYTES = (gsize) (255 * 6);
#line 1450 "rpl.c"
	gboolean at_bob = FALSE;
	GString* tonext = NULL;
	GString* _tmp0_;
	gboolean prev_match_is_empty = FALSE;
	gboolean is_partial = FALSE;
	gssize match_from = 0L;
	gengetopt_args_info _tmp87_;
	GError* _inner_error0_ = NULL;
	gssize result;
#line 188 "rpl.vala"
	g_return_val_if_fail (input != NULL, 0L);
#line 188 "rpl.vala"
	g_return_val_if_fail (input_filename != NULL, 0L);
#line 188 "rpl.vala"
	g_return_val_if_fail (old_regex != NULL, 0L);
#line 188 "rpl.vala"
	g_return_val_if_fail (new_pattern != NULL, 0L);
#line 195 "rpl.vala"
	lookbehind = _vala_pcre2_pattern_info_maxlookbehind (old_regex) != ((guint32) 0);
#line 196 "rpl.vala"
	num_matches = (gssize) 0;
#line 198 "rpl.vala"
	at_bob = TRUE;
#line 199 "rpl.vala"
	_tmp0_ = string_builder_sized ((gsize) initial_buf_size);
#line 199 "rpl.vala"
	tonext = _tmp0_;
#line 200 "rpl.vala"
	prev_match_is_empty = FALSE;
#line 201 "rpl.vala"
	is_partial = TRUE;
#line 202 "rpl.vala"
	match_from = (gssize) 0;
#line 1484 "rpl.c"
	{
		gboolean _tmp1_ = FALSE;
#line 203 "rpl.vala"
		_tmp1_ = TRUE;
#line 203 "rpl.vala"
		while (TRUE) {
#line 1491 "rpl.c"
			GString* search_str = NULL;
			GString* _tmp2_;
			GString* _tmp3_;
			gboolean _tmp9_ = FALSE;
			GString* _tmp10_;
			gssize valid_len = 0L;
			GString* _tmp13_;
			const gchar* _tmp14_;
			GString* _tmp15_;
			gssize _tmp16_ = 0L;
			gssize minimum_valid_len = 0L;
			gssize keep_from = 0L;
			GString* _tmp85_;
			GString* _tmp86_;
#line 203 "rpl.vala"
			if (!_tmp1_) {
#line 307 "rpl.vala"
				if (!is_partial) {
#line 307 "rpl.vala"
					break;
#line 1512 "rpl.c"
				}
			}
#line 203 "rpl.vala"
			_tmp1_ = FALSE;
#line 205 "rpl.vala"
			_tmp2_ = tonext;
#line 205 "rpl.vala"
			_tmp3_ = tonext;
#line 205 "rpl.vala"
			if ((2 * _tmp2_->len) > _tmp3_->allocated_len) {
#line 1523 "rpl.c"
				GString* _tmp4_;
				GString* _tmp5_;
				GString* _tmp6_;
				GString* _tmp7_;
#line 206 "rpl.vala"
				_tmp4_ = tonext;
#line 206 "rpl.vala"
				_tmp5_ = string_builder_sized ((gsize) (2 * _tmp4_->len));
#line 206 "rpl.vala"
				_g_string_free0 (search_str);
#line 206 "rpl.vala"
				search_str = _tmp5_;
#line 207 "rpl.vala"
				_tmp6_ = search_str;
#line 207 "rpl.vala"
				_tmp7_ = tonext;
#line 207 "rpl.vala"
				append_string_builder_tail (_tmp6_, _tmp7_, (gssize) 0);
#line 208 "rpl.vala"
				_g_string_free0 (tonext);
#line 208 "rpl.vala"
				tonext = NULL;
#line 1546 "rpl.c"
			} else {
				GString* _tmp8_;
#line 210 "rpl.vala"
				_tmp8_ = tonext;
#line 210 "rpl.vala"
				tonext = NULL;
#line 210 "rpl.vala"
				_g_string_free0 (search_str);
#line 210 "rpl.vala"
				search_str = _tmp8_;
#line 1557 "rpl.c"
			}
#line 212 "rpl.vala"
			_tmp10_ = search_str;
#line 212 "rpl.vala"
			_tmp9_ = read_all (input, _tmp10_, &_inner_error0_);
#line 212 "rpl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 212 "rpl.vala"
				if (_inner_error0_->domain == G_IO_ERROR) {
#line 1567 "rpl.c"
					gssize _tmp11_ = -1L;
#line 212 "rpl.vala"
					g_propagate_error (error, _inner_error0_);
#line 212 "rpl.vala"
					_g_string_free0 (search_str);
#line 212 "rpl.vala"
					_g_string_free0 (tonext);
#line 212 "rpl.vala"
					return _tmp11_;
#line 1577 "rpl.c"
				} else {
					gssize _tmp12_ = -1L;
#line 212 "rpl.vala"
					_g_string_free0 (search_str);
#line 212 "rpl.vala"
					_g_string_free0 (tonext);
#line 212 "rpl.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 212 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 212 "rpl.vala"
					return _tmp12_;
#line 1590 "rpl.c"
				}
			}
#line 212 "rpl.vala"
			is_partial = _tmp9_;
#line 218 "rpl.vala"
			_tmp13_ = search_str;
#line 218 "rpl.vala"
			_tmp14_ = _tmp13_->str;
#line 218 "rpl.vala"
			_tmp15_ = search_str;
#line 218 "rpl.vala"
			valid_len = match_from + ((gssize) check_utf8 (((gchar*) _tmp14_) + match_from, (gsize) (_tmp15_->len - match_from)));
#line 219 "rpl.vala"
			if (is_partial) {
#line 1605 "rpl.c"
				GString* _tmp17_;
#line 219 "rpl.vala"
				_tmp17_ = search_str;
#line 219 "rpl.vala"
				_tmp16_ = _tmp17_->len - 5;
#line 1611 "rpl.c"
			} else {
				GString* _tmp18_;
#line 219 "rpl.vala"
				_tmp18_ = search_str;
#line 219 "rpl.vala"
				_tmp16_ = _tmp18_->len;
#line 1618 "rpl.c"
			}
#line 219 "rpl.vala"
			minimum_valid_len = _tmp16_;
#line 220 "rpl.vala"
			if (valid_len < minimum_valid_len) {
#line 1624 "rpl.c"
				GError* _tmp19_;
#line 222 "rpl.vala"
				_tmp19_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, "error decoding input");
#line 222 "rpl.vala"
				_inner_error0_ = _tmp19_;
#line 222 "rpl.vala"
				if (_inner_error0_->domain == G_IO_ERROR) {
#line 1632 "rpl.c"
					gssize _tmp20_ = -1L;
#line 222 "rpl.vala"
					g_propagate_error (error, _inner_error0_);
#line 222 "rpl.vala"
					_g_string_free0 (search_str);
#line 222 "rpl.vala"
					_g_string_free0 (tonext);
#line 222 "rpl.vala"
					return _tmp20_;
#line 1642 "rpl.c"
				} else {
					gssize _tmp21_ = -1L;
#line 222 "rpl.vala"
					_g_string_free0 (search_str);
#line 222 "rpl.vala"
					_g_string_free0 (tonext);
#line 222 "rpl.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 222 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 222 "rpl.vala"
					return _tmp21_;
#line 1655 "rpl.c"
				}
			}
#line 225 "rpl.vala"
			while (TRUE) {
#line 1660 "rpl.c"
				uint32_t _tmp34_ = 0U;
				gint _tmp35_ = 0;
				uint32_t flags = 0U;
				gint rc = 0;
				pcre2_match_data* match = NULL;
				GString* _tmp36_;
				guint8* _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_ = 0;
				guint8* _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_ = 0;
				pcre2_match_data* _tmp41_;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gssize start_pos = 0L;
				gssize end_pos = 0L;
				GString* _tmp51_;
				guint8* _tmp52_;
				gint _tmp52__length1;
				gint _tmp53_ = 0;
				guint8* _tmp54_;
				gint _tmp54__length1;
				gboolean _tmp57_ = FALSE;
				GString* replacement = NULL;
				GString* _tmp58_;
				guint8* _tmp59_;
				gint _tmp59__length1;
				gint _tmp60_ = 0;
				guint8* _tmp61_;
				gint _tmp61__length1;
				pcre2_match_data* _tmp62_;
				gint _tmp63_ = 0;
				GString* _tmp64_;
				gengetopt_args_info _tmp70_;
				GString* _tmp78_;
				guint8* _tmp79_;
				gint _tmp79__length1;
				gint _tmp80_ = 0;
				guint8* _tmp81_;
				gint _tmp81__length1;
				GString* _tmp82_;
#line 228 "rpl.vala"
				if (prev_match_is_empty) {
#line 1705 "rpl.c"
					gint c_len = 0;
					gunichar c = 0U;
					GString* _tmp22_;
					guint8* _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_ = 0;
					guint8* _tmp25_;
					gint _tmp25__length1;
					gunichar _tmp26_ = 0U;
					gboolean _tmp27_;
					GString* _tmp28_;
					guint8* _tmp29_;
					gint _tmp29__length1;
					gint _tmp30_ = 0;
					guint8* _tmp31_;
					gint _tmp31__length1;
#line 229 "rpl.vala"
					c_len = 0;
#line 231 "rpl.vala"
					_tmp22_ = search_str;
#line 231 "rpl.vala"
					_tmp23_ = g_string_get_data (_tmp22_, &_tmp24_);
#line 231 "rpl.vala"
					_tmp23__length1 = _tmp24_;
#line 231 "rpl.vala"
					_tmp25_ = _tmp23_;
#line 231 "rpl.vala"
					_tmp25__length1 = _tmp23__length1;
#line 231 "rpl.vala"
					_tmp27_ = string_get_next_char ((const gchar*) (((gchar*) _tmp25_) + match_from), &c_len, &_tmp26_);
#line 231 "rpl.vala"
					c = _tmp26_;
#line 231 "rpl.vala"
					if (!_tmp27_) {
#line 233 "rpl.vala"
						break;
#line 1742 "rpl.c"
					}
#line 235 "rpl.vala"
					_tmp28_ = search_str;
#line 235 "rpl.vala"
					_tmp29_ = g_string_get_data (_tmp28_, &_tmp30_);
#line 235 "rpl.vala"
					_tmp29__length1 = _tmp30_;
#line 235 "rpl.vala"
					_tmp31_ = _tmp29_;
#line 235 "rpl.vala"
					_tmp31__length1 = _tmp29__length1;
#line 235 "rpl.vala"
					write_all (output, ((gchar*) _tmp31_) + match_from, (gsize) c_len, &_inner_error0_);
#line 235 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 235 "rpl.vala"
						if (_inner_error0_->domain == G_IO_ERROR) {
#line 1760 "rpl.c"
							gssize _tmp32_ = -1L;
#line 235 "rpl.vala"
							g_propagate_error (error, _inner_error0_);
#line 235 "rpl.vala"
							_g_string_free0 (search_str);
#line 235 "rpl.vala"
							_g_string_free0 (tonext);
#line 235 "rpl.vala"
							return _tmp32_;
#line 1770 "rpl.c"
						} else {
							gssize _tmp33_ = -1L;
#line 235 "rpl.vala"
							_g_string_free0 (search_str);
#line 235 "rpl.vala"
							_g_string_free0 (tonext);
#line 235 "rpl.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 235 "rpl.vala"
							g_clear_error (&_inner_error0_);
#line 235 "rpl.vala"
							return _tmp33_;
#line 1783 "rpl.c"
						}
					}
#line 236 "rpl.vala"
					match_from += (gssize) c_len;
#line 1788 "rpl.c"
				}
#line 241 "rpl.vala"
				if (is_partial) {
#line 241 "rpl.vala"
					_tmp34_ = PCRE2_PARTIAL_HARD;
#line 1794 "rpl.c"
				} else {
#line 241 "rpl.vala"
					_tmp34_ = 0;
#line 1798 "rpl.c"
				}
#line 242 "rpl.vala"
				if (at_bob) {
#line 242 "rpl.vala"
					_tmp35_ = 0;
#line 1804 "rpl.c"
				} else {
#line 242 "rpl.vala"
					_tmp35_ = (gint) PCRE2_NOTBOL;
#line 1808 "rpl.c"
				}
#line 240 "rpl.vala"
				flags = (PCRE2_NO_UTF_CHECK | _tmp34_) | _tmp35_;
#line 244 "rpl.vala"
				_tmp36_ = search_str;
#line 244 "rpl.vala"
				_tmp37_ = g_string_get_data (_tmp36_, &_tmp38_);
#line 244 "rpl.vala"
				_tmp37__length1 = _tmp38_;
#line 244 "rpl.vala"
				_tmp39_ = _tmp37_;
#line 244 "rpl.vala"
				_tmp39__length1 = _tmp37__length1;
#line 244 "rpl.vala"
				_tmp41_ = _vala_pcre2_match (old_regex, _tmp39_, (gsize) valid_len, (gsize) match_from, (guint32) flags, &_tmp40_);
#line 244 "rpl.vala"
				rc = _tmp40_;
#line 244 "rpl.vala"
				match = _tmp41_;
#line 245 "rpl.vala"
				if (rc < 0) {
#line 245 "rpl.vala"
					_tmp43_ = rc != ((gint) PCRE2_ERROR_NOMATCH);
#line 1832 "rpl.c"
				} else {
#line 245 "rpl.vala"
					_tmp43_ = FALSE;
#line 1836 "rpl.c"
				}
#line 245 "rpl.vala"
				if (_tmp43_) {
#line 245 "rpl.vala"
					_tmp42_ = rc != ((gint) PCRE2_ERROR_PARTIAL);
#line 1842 "rpl.c"
				} else {
#line 245 "rpl.vala"
					_tmp42_ = FALSE;
#line 1846 "rpl.c"
				}
#line 245 "rpl.vala"
				if (_tmp42_) {
#line 1850 "rpl.c"
					gchar* _tmp44_;
					gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
#line 246 "rpl.vala"
					_tmp44_ = _vala_pcre2_get_error_message (rc);
#line 246 "rpl.vala"
					_tmp45_ = _tmp44_;
#line 246 "rpl.vala"
					_tmp46_ = string_to_string (_tmp45_);
#line 246 "rpl.vala"
					_tmp47_ = g_strconcat ("error in search: ", _tmp46_, NULL);
#line 246 "rpl.vala"
					_tmp48_ = _tmp47_;
#line 246 "rpl.vala"
					warn (_tmp48_);
#line 246 "rpl.vala"
					_g_free0 (_tmp48_);
#line 246 "rpl.vala"
					_g_free0 (_tmp45_);
#line 247 "rpl.vala"
					result = (gssize) -1;
#line 247 "rpl.vala"
					_pcre2_match_data_free0 (match);
#line 247 "rpl.vala"
					_g_string_free0 (search_str);
#line 247 "rpl.vala"
					_g_string_free0 (tonext);
#line 247 "rpl.vala"
					return result;
#line 1882 "rpl.c"
				}
#line 251 "rpl.vala"
				start_pos = valid_len;
#line 252 "rpl.vala"
				end_pos = valid_len;
#line 253 "rpl.vala"
				if (rc != ((gint) PCRE2_ERROR_NOMATCH)) {
#line 1890 "rpl.c"
					pcre2_match_data* _tmp49_;
					pcre2_match_data* _tmp50_;
#line 254 "rpl.vala"
					_tmp49_ = match;
#line 254 "rpl.vala"
					start_pos = (gssize) pcre2_group_start (_tmp49_, (guint32) 0);
#line 255 "rpl.vala"
					_tmp50_ = match;
#line 255 "rpl.vala"
					end_pos = (gssize) pcre2_group_end (_tmp50_, (guint32) 0);
#line 1901 "rpl.c"
				}
#line 257 "rpl.vala"
				_tmp51_ = search_str;
#line 257 "rpl.vala"
				_tmp52_ = g_string_get_data (_tmp51_, &_tmp53_);
#line 257 "rpl.vala"
				_tmp52__length1 = _tmp53_;
#line 257 "rpl.vala"
				_tmp54_ = _tmp52_;
#line 257 "rpl.vala"
				_tmp54__length1 = _tmp52__length1;
#line 257 "rpl.vala"
				write_all (output, ((gchar*) _tmp54_) + match_from, (gsize) (start_pos - match_from), &_inner_error0_);
#line 257 "rpl.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 257 "rpl.vala"
					if (_inner_error0_->domain == G_IO_ERROR) {
#line 1919 "rpl.c"
						gssize _tmp55_ = -1L;
#line 257 "rpl.vala"
						g_propagate_error (error, _inner_error0_);
#line 257 "rpl.vala"
						_pcre2_match_data_free0 (match);
#line 257 "rpl.vala"
						_g_string_free0 (search_str);
#line 257 "rpl.vala"
						_g_string_free0 (tonext);
#line 257 "rpl.vala"
						return _tmp55_;
#line 1931 "rpl.c"
					} else {
						gssize _tmp56_ = -1L;
#line 257 "rpl.vala"
						_pcre2_match_data_free0 (match);
#line 257 "rpl.vala"
						_g_string_free0 (search_str);
#line 257 "rpl.vala"
						_g_string_free0 (tonext);
#line 257 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 257 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 257 "rpl.vala"
						return _tmp56_;
#line 1946 "rpl.c"
					}
				}
#line 260 "rpl.vala"
				if (rc == ((gint) PCRE2_ERROR_NOMATCH)) {
#line 260 "rpl.vala"
					_tmp57_ = TRUE;
#line 1953 "rpl.c"
				} else {
#line 260 "rpl.vala"
					_tmp57_ = rc == ((gint) PCRE2_ERROR_PARTIAL);
#line 1957 "rpl.c"
				}
#line 260 "rpl.vala"
				if (_tmp57_) {
#line 262 "rpl.vala"
					match_from = start_pos;
#line 263 "rpl.vala"
					prev_match_is_empty = FALSE;
#line 264 "rpl.vala"
					_pcre2_match_data_free0 (match);
#line 264 "rpl.vala"
					break;
#line 1969 "rpl.c"
				}
#line 267 "rpl.vala"
				prev_match_is_empty = start_pos == end_pos;
#line 270 "rpl.vala"
				_tmp58_ = search_str;
#line 270 "rpl.vala"
				_tmp59_ = g_string_get_data (_tmp58_, &_tmp60_);
#line 270 "rpl.vala"
				_tmp59__length1 = _tmp60_;
#line 270 "rpl.vala"
				_tmp61_ = _tmp59_;
#line 270 "rpl.vala"
				_tmp61__length1 = _tmp59__length1;
#line 270 "rpl.vala"
				_tmp62_ = match;
#line 270 "rpl.vala"
				_tmp64_ = _vala_pcre2_substitute (old_regex, _tmp61_, (gsize) valid_len, (gsize) match_from, (((replace_opts | PCRE2_NOTEMPTY) | PCRE2_SUBSTITUTE_MATCHED) | PCRE2_SUBSTITUTE_REPLACEMENT_ONLY) | PCRE2_NO_UTF_CHECK, _tmp62_, new_pattern, &_tmp63_);
#line 270 "rpl.vala"
				rc = _tmp63_;
#line 270 "rpl.vala"
				replacement = _tmp64_;
#line 277 "rpl.vala"
				if (rc < 0) {
#line 1993 "rpl.c"
					gchar* _tmp65_;
					gchar* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
#line 278 "rpl.vala"
					_tmp65_ = _vala_pcre2_get_error_message (rc);
#line 278 "rpl.vala"
					_tmp66_ = _tmp65_;
#line 278 "rpl.vala"
					_tmp67_ = string_to_string (_tmp66_);
#line 278 "rpl.vala"
					_tmp68_ = g_strconcat ("error in replacement: ", _tmp67_, NULL);
#line 278 "rpl.vala"
					_tmp69_ = _tmp68_;
#line 278 "rpl.vala"
					warn (_tmp69_);
#line 278 "rpl.vala"
					_g_free0 (_tmp69_);
#line 278 "rpl.vala"
					_g_free0 (_tmp66_);
#line 279 "rpl.vala"
					result = (gssize) -1;
#line 279 "rpl.vala"
					_g_string_free0 (replacement);
#line 279 "rpl.vala"
					_pcre2_match_data_free0 (match);
#line 279 "rpl.vala"
					_g_string_free0 (search_str);
#line 279 "rpl.vala"
					_g_string_free0 (tonext);
#line 279 "rpl.vala"
					return result;
#line 2027 "rpl.c"
				}
#line 283 "rpl.vala"
				_tmp70_ = args_info;
#line 283 "rpl.vala"
				if (_tmp70_.match_case_given) {
#line 2033 "rpl.c"
					GString* model = NULL;
					GString* _tmp71_;
					GString* _tmp72_;
					GString* _tmp73_;
					GString* recased = NULL;
					GString* _tmp74_;
					GString* _tmp75_;
					GString* _tmp76_;
					GString* _tmp77_;
#line 284 "rpl.vala"
					_tmp71_ = g_string_new ("");
#line 284 "rpl.vala"
					model = _tmp71_;
#line 285 "rpl.vala"
					_tmp72_ = model;
#line 285 "rpl.vala"
					_tmp73_ = search_str;
#line 285 "rpl.vala"
					append_string_builder_slice (_tmp72_, _tmp73_, start_pos, end_pos);
#line 286 "rpl.vala"
					_tmp74_ = model;
#line 286 "rpl.vala"
					_tmp75_ = replacement;
#line 286 "rpl.vala"
					_tmp76_ = caselike (_tmp74_, _tmp75_);
#line 286 "rpl.vala"
					recased = _tmp76_;
#line 287 "rpl.vala"
					_tmp77_ = recased;
#line 287 "rpl.vala"
					recased = NULL;
#line 287 "rpl.vala"
					_g_string_free0 (replacement);
#line 287 "rpl.vala"
					replacement = _tmp77_;
#line 283 "rpl.vala"
					_g_string_free0 (recased);
#line 283 "rpl.vala"
					_g_string_free0 (model);
#line 2073 "rpl.c"
				}
#line 290 "rpl.vala"
				_tmp78_ = replacement;
#line 290 "rpl.vala"
				_tmp79_ = g_string_get_data (_tmp78_, &_tmp80_);
#line 290 "rpl.vala"
				_tmp79__length1 = _tmp80_;
#line 290 "rpl.vala"
				_tmp81_ = _tmp79_;
#line 290 "rpl.vala"
				_tmp81__length1 = _tmp79__length1;
#line 290 "rpl.vala"
				_tmp82_ = replacement;
#line 290 "rpl.vala"
				write_all (output, _tmp81_, (gsize) _tmp82_->len, &_inner_error0_);
#line 290 "rpl.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 290 "rpl.vala"
					if (_inner_error0_->domain == G_IO_ERROR) {
#line 2093 "rpl.c"
						gssize _tmp83_ = -1L;
#line 290 "rpl.vala"
						g_propagate_error (error, _inner_error0_);
#line 290 "rpl.vala"
						_g_string_free0 (replacement);
#line 290 "rpl.vala"
						_pcre2_match_data_free0 (match);
#line 290 "rpl.vala"
						_g_string_free0 (search_str);
#line 290 "rpl.vala"
						_g_string_free0 (tonext);
#line 290 "rpl.vala"
						return _tmp83_;
#line 2107 "rpl.c"
					} else {
						gssize _tmp84_ = -1L;
#line 290 "rpl.vala"
						_g_string_free0 (replacement);
#line 290 "rpl.vala"
						_pcre2_match_data_free0 (match);
#line 290 "rpl.vala"
						_g_string_free0 (search_str);
#line 290 "rpl.vala"
						_g_string_free0 (tonext);
#line 290 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 290 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 290 "rpl.vala"
						return _tmp84_;
#line 2124 "rpl.c"
					}
				}
#line 293 "rpl.vala"
				match_from = end_pos;
#line 295 "rpl.vala"
				num_matches += (gssize) 1;
#line 225 "rpl.vala"
				_g_string_free0 (replacement);
#line 225 "rpl.vala"
				_pcre2_match_data_free0 (match);
#line 2135 "rpl.c"
			}
#line 299 "rpl.vala"
			keep_from = match_from;
#line 300 "rpl.vala"
			if (lookbehind) {
#line 301 "rpl.vala"
				keep_from = MAX ((gssize) 0, keep_from - ((gssize) MAX_LOOKBEHIND_BYTES));
#line 2143 "rpl.c"
			}
#line 302 "rpl.vala"
			_tmp85_ = search_str;
#line 302 "rpl.vala"
			g_string_erase (_tmp85_, (gssize) 0, keep_from);
#line 303 "rpl.vala"
			match_from -= keep_from;
#line 304 "rpl.vala"
			_tmp86_ = search_str;
#line 304 "rpl.vala"
			search_str = NULL;
#line 304 "rpl.vala"
			_g_string_free0 (tonext);
#line 304 "rpl.vala"
			tonext = _tmp86_;
#line 306 "rpl.vala"
			at_bob = FALSE;
#line 203 "rpl.vala"
			_g_string_free0 (search_str);
#line 2163 "rpl.c"
		}
	}
#line 309 "rpl.vala"
	_tmp87_ = args_info;
#line 309 "rpl.vala"
	if (_tmp87_.verbose_given) {
#line 310 "rpl.vala"
		warn ("no input left, exiting");
#line 2172 "rpl.c"
	}
#line 313 "rpl.vala"
	result = num_matches;
#line 313 "rpl.vala"
	_g_string_free0 (tonext);
#line 313 "rpl.vala"
	return result;
#line 2180 "rpl.c"
}

void
remove_temp_file (const gchar* tmp_path)
{
	gint rc = 0;
#line 319 "rpl.vala"
	g_return_if_fail (tmp_path != NULL);
#line 320 "rpl.vala"
	rc = g_remove (tmp_path);
#line 321 "rpl.vala"
	if (rc < 0) {
#line 2193 "rpl.c"
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 322 "rpl.vala"
		_tmp0_ = string_to_string (tmp_path);
#line 322 "rpl.vala"
		_tmp1_ = g_strerror (errno);
#line 322 "rpl.vala"
		_tmp2_ = string_to_string (_tmp1_);
#line 322 "rpl.vala"
		_tmp3_ = g_strconcat ("error removing temporary file ", _tmp0_, ": ", _tmp2_, NULL);
#line 322 "rpl.vala"
		_tmp4_ = _tmp3_;
#line 322 "rpl.vala"
		warn (_tmp4_);
#line 322 "rpl.vala"
		_g_free0 (_tmp4_);
#line 2213 "rpl.c"
	}
}

static void
_g_free0_ (gpointer var)
{
#line 329 "rpl.vala"
	var = (g_free (var), NULL);
#line 2222 "rpl.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 329 "rpl.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 2230 "rpl.c"
}

GList*
get_dir_tree (GFile* file)
{
	GList* results = NULL;
	GError* _inner_error0_ = NULL;
	GList* result;
#line 327 "rpl.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 328 "rpl.vala"
	results = NULL;
#line 2243 "rpl.c"
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* info = NULL;
#line 330 "rpl.vala"
		_tmp0_ = g_file_enumerate_children (file, "standard::name,standard::type", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
#line 330 "rpl.vala"
		enumerator = _tmp0_;
#line 330 "rpl.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2254 "rpl.c"
			goto __catch0_g_error;
		}
#line 335 "rpl.vala"
		info = NULL;
#line 336 "rpl.vala"
		while (TRUE) {
#line 2261 "rpl.c"
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFile* child = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			GFileInfo* _tmp9_;
#line 336 "rpl.vala"
			_tmp2_ = enumerator;
#line 336 "rpl.vala"
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
#line 336 "rpl.vala"
			_tmp1_ = _tmp3_;
#line 336 "rpl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 336 "rpl.vala"
				_g_object_unref0 (info);
#line 336 "rpl.vala"
				_g_object_unref0 (enumerator);
#line 2284 "rpl.c"
				goto __catch0_g_error;
			}
#line 336 "rpl.vala"
			_tmp4_ = _tmp1_;
#line 336 "rpl.vala"
			_tmp1_ = NULL;
#line 336 "rpl.vala"
			_g_object_unref0 (info);
#line 336 "rpl.vala"
			info = _tmp4_;
#line 336 "rpl.vala"
			_tmp5_ = info;
#line 336 "rpl.vala"
			if (!(_tmp5_ != NULL)) {
#line 336 "rpl.vala"
				_g_object_unref0 (_tmp1_);
#line 336 "rpl.vala"
				break;
#line 2303 "rpl.c"
			}
#line 337 "rpl.vala"
			_tmp6_ = info;
#line 337 "rpl.vala"
			_tmp7_ = g_file_info_get_name (_tmp6_);
#line 337 "rpl.vala"
			_tmp8_ = g_file_resolve_relative_path (file, _tmp7_);
#line 337 "rpl.vala"
			child = _tmp8_;
#line 338 "rpl.vala"
			_tmp9_ = info;
#line 338 "rpl.vala"
			if (g_file_info_get_file_type (_tmp9_) == G_FILE_TYPE_DIRECTORY) {
#line 2317 "rpl.c"
				GFile* _tmp10_;
				GList* _tmp11_;
#line 339 "rpl.vala"
				_tmp10_ = child;
#line 339 "rpl.vala"
				_tmp11_ = get_dir_tree (_tmp10_);
#line 339 "rpl.vala"
				results = g_list_concat (results, _tmp11_);
#line 2326 "rpl.c"
			} else {
				GFile* _tmp12_;
				gchar* _tmp13_;
#line 341 "rpl.vala"
				_tmp12_ = child;
#line 341 "rpl.vala"
				_tmp13_ = g_file_get_path (_tmp12_);
#line 341 "rpl.vala"
				results = g_list_append (results, _tmp13_);
#line 2336 "rpl.c"
			}
#line 336 "rpl.vala"
			_g_object_unref0 (child);
#line 336 "rpl.vala"
			_g_object_unref0 (_tmp1_);
#line 2342 "rpl.c"
		}
#line 329 "rpl.vala"
		_g_object_unref0 (info);
#line 329 "rpl.vala"
		_g_object_unref0 (enumerator);
#line 2348 "rpl.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
#line 329 "rpl.vala"
		e = _inner_error0_;
#line 329 "rpl.vala"
		_inner_error0_ = NULL;
#line 345 "rpl.vala"
		_tmp14_ = g_file_get_path (file);
#line 345 "rpl.vala"
		_tmp15_ = _tmp14_;
#line 345 "rpl.vala"
		_tmp16_ = string_to_string (_tmp15_);
#line 345 "rpl.vala"
		_tmp17_ = e;
#line 345 "rpl.vala"
		_tmp18_ = _tmp17_->message;
#line 345 "rpl.vala"
		_tmp19_ = string_to_string (_tmp18_);
#line 345 "rpl.vala"
		_tmp20_ = g_strconcat ("error while recursively examining ", _tmp16_, ": ", _tmp19_, NULL);
#line 345 "rpl.vala"
		_tmp21_ = _tmp20_;
#line 345 "rpl.vala"
		warn (_tmp21_);
#line 345 "rpl.vala"
		_g_free0 (_tmp21_);
#line 345 "rpl.vala"
		_g_free0 (_tmp15_);
#line 329 "rpl.vala"
		_g_error_free0 (e);
#line 2390 "rpl.c"
	}
	__finally0:
#line 329 "rpl.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 329 "rpl.vala"
		(results == NULL) ? NULL : (results = (_g_list_free__g_free0_ (results), NULL));
#line 329 "rpl.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 329 "rpl.vala"
		g_clear_error (&_inner_error0_);
#line 329 "rpl.vala"
		return NULL;
#line 2403 "rpl.c"
	}
#line 347 "rpl.vala"
	result = results;
#line 347 "rpl.vala"
	return result;
#line 2409 "rpl.c"
}

GString*
slurp_patterns (const gchar* filename)
{
	guint8* input = NULL;
	gint input_length1;
	gint _input_size_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GString* _tmp6_;
	GError* _inner_error0_ = NULL;
	GString* result;
#line 350 "rpl.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 351 "rpl.vala"
	input = NULL;
#line 351 "rpl.vala"
	input_length1 = 0;
#line 351 "rpl.vala"
	_input_size_ = input_length1;
#line 2431 "rpl.c"
	{
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
#line 353 "rpl.vala"
		g_file_get_contents (filename, (gchar**) (&_tmp0_), &_tmp1_, &_inner_error0_);
#line 353 "rpl.vala"
		input = (g_free (input), NULL);
#line 353 "rpl.vala"
		input = _tmp0_;
#line 353 "rpl.vala"
		input_length1 = _tmp1_;
#line 353 "rpl.vala"
		_input_size_ = input_length1;
#line 353 "rpl.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2447 "rpl.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 352 "rpl.vala"
		g_clear_error (&_inner_error0_);
#line 355 "rpl.vala"
		_tmp2_ = string_to_string (filename);
#line 355 "rpl.vala"
		_tmp3_ = g_strconcat ("error reading pattern file ", _tmp2_, NULL);
#line 355 "rpl.vala"
		_tmp4_ = _tmp3_;
#line 355 "rpl.vala"
		die (1, _tmp4_);
#line 355 "rpl.vala"
		_g_free0 (_tmp4_);
#line 2469 "rpl.c"
	}
	__finally0:
#line 352 "rpl.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 352 "rpl.vala"
		input = (g_free (input), NULL);
#line 352 "rpl.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 352 "rpl.vala"
		g_clear_error (&_inner_error0_);
#line 352 "rpl.vala"
		return NULL;
#line 2482 "rpl.c"
	}
#line 357 "rpl.vala"
	_tmp5_ = input;
#line 357 "rpl.vala"
	_tmp5__length1 = input_length1;
#line 357 "rpl.vala"
	_tmp6_ = g_string_new_len ((gchar*) _tmp5_, (_tmp5__length1 * sizeof (guint8)) / sizeof (gchar));
#line 357 "rpl.vala"
	result = _tmp6_;
#line 357 "rpl.vala"
	input = (g_free (input), NULL);
#line 357 "rpl.vala"
	return result;
#line 2496 "rpl.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 367 "rpl.vala"
	if (length >= 0) {
#line 2505 "rpl.c"
		gchar** result;
		gssize i;
#line 367 "rpl.vala"
		result = g_new0 (gchar*, length + 1);
#line 367 "rpl.vala"
		for (i = 0; i < length; i++) {
#line 2512 "rpl.c"
			gchar* _tmp0_;
#line 367 "rpl.vala"
			_tmp0_ = g_strdup (self[i]);
#line 367 "rpl.vala"
			result[i] = _tmp0_;
#line 2518 "rpl.c"
		}
#line 367 "rpl.vala"
		return result;
#line 2522 "rpl.c"
	}
#line 367 "rpl.vala"
	return NULL;
#line 2526 "rpl.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 603 "rpl.vala"
	return self ? g_object_ref (self) : NULL;
#line 2534 "rpl.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 2553 "rpl.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 2570 "rpl.c"
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
#line 4109 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 4111 "glib-2.0.vapi"
	ret = NULL;
#line 4112 "glib-2.0.vapi"
	while (TRUE) {
#line 2586 "rpl.c"
		GString* _tmp0_;
		GString* _tmp2_;
#line 4112 "glib-2.0.vapi"
		c = fgetc (self);
#line 4112 "glib-2.0.vapi"
		if (!(c != EOF)) {
#line 4112 "glib-2.0.vapi"
			break;
#line 2595 "rpl.c"
		}
#line 4113 "glib-2.0.vapi"
		_tmp0_ = ret;
#line 4113 "glib-2.0.vapi"
		if (_tmp0_ == NULL) {
#line 2601 "rpl.c"
			GString* _tmp1_;
#line 4114 "glib-2.0.vapi"
			_tmp1_ = g_string_new ("");
#line 4114 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 4114 "glib-2.0.vapi"
			ret = _tmp1_;
#line 2609 "rpl.c"
		}
#line 4116 "glib-2.0.vapi"
		if (c == ((gint) '\n')) {
#line 4117 "glib-2.0.vapi"
			break;
#line 2615 "rpl.c"
		}
#line 4119 "glib-2.0.vapi"
		_tmp2_ = ret;
#line 4119 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
#line 2621 "rpl.c"
	}
#line 4121 "glib-2.0.vapi"
	_tmp3_ = ret;
#line 4121 "glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4122 "glib-2.0.vapi"
		result = NULL;
#line 4122 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4122 "glib-2.0.vapi"
		return result;
#line 2633 "rpl.c"
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
#line 4124 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 4124 "glib-2.0.vapi"
		_tmp5_ = ((GString*) _tmp4_)->str;
#line 4124 "glib-2.0.vapi"
		((GString*) _tmp4_)->str = NULL;
#line 4124 "glib-2.0.vapi"
		result = _tmp5_;
#line 4124 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4124 "glib-2.0.vapi"
		return result;
#line 2649 "rpl.c"
	}
}

static gint
_vala_main (gchar** argv,
            gint argv_length1)
{
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gengetopt_args_info _tmp4_ = {0};
	gint res = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	gengetopt_args_info _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GList* files = NULL;
	gengetopt_args_info _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gengetopt_args_info _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GList* _tmp16_;
	GString* old_text = NULL;
	GString* new_text = NULL;
	gengetopt_args_info _tmp44_;
	gengetopt_args_info _tmp61_;
	gboolean _tmp78_ = FALSE;
	gengetopt_args_info _tmp79_;
	gchar* encoding = NULL;
	gengetopt_args_info _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	const gchar* _tmp84_;
	pcre2_compile_context* ccontext = NULL;
	pcre2_compile_context* _tmp87_;
	gengetopt_args_info _tmp88_;
	uint32_t opts = 0U;
	uint32_t replace_opts = 0U;
	gengetopt_args_info _tmp90_;
	gboolean _tmp91_ = FALSE;
	gengetopt_args_info _tmp92_;
	gint errorcode = 0;
	gsize erroroffset = 0UL;
	pcre2_code* regex = NULL;
	GString* _tmp94_;
	guint8* _tmp95_;
	gint _tmp95__length1;
	gint _tmp96_ = 0;
	guint8* _tmp97_;
	gint _tmp97__length1;
	pcre2_compile_context* _tmp98_;
	gint _tmp99_ = 0;
	gsize _tmp100_ = 0UL;
	pcre2_code* _tmp101_;
	pcre2_code* _tmp102_;
	gboolean _tmp110_ = FALSE;
	pcre2_code* _tmp111_;
	gsize total_files = 0UL;
	gsize matched_files = 0UL;
	gsize total_matches = 0UL;
	GList* _tmp113_;
	gengetopt_args_info _tmp371_;
	GError* _inner_error0_ = NULL;
	gint result;
#line 361 "rpl.vala"
	setlocale (LC_ALL, "");
#line 367 "rpl.vala"
	_tmp0_ = (argv != NULL) ? _vala_array_dup1 (argv, argv_length1) : argv;
#line 367 "rpl.vala"
	_tmp0__length1 = argv_length1;
#line 367 "rpl.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 367 "rpl.vala"
	args = _tmp0_;
#line 367 "rpl.vala"
	args_length1 = _tmp0__length1;
#line 367 "rpl.vala"
	_args_size_ = args_length1;
#line 369 "rpl.vala"
	g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);
#line 370 "rpl.vala"
	_tmp1_ = args;
#line 370 "rpl.vala"
	_tmp1__length1 = args_length1;
#line 370 "rpl.vala"
	_tmp2_ = _tmp1_[0];
#line 370 "rpl.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 370 "rpl.vala"
	_g_free0 (program_name);
#line 370 "rpl.vala"
	program_name = _tmp3_;
#line 373 "rpl.vala"
	 (&args_info);
#line 373 "rpl.vala"
	args_info = _tmp4_;
#line 375 "rpl.vala"
	_tmp5_ = args;
#line 375 "rpl.vala"
	_tmp5__length1 = args_length1;
#line 375 "rpl.vala"
	_tmp6_ = cmdline_parser ((gint) _tmp5__length1, _tmp5_, &args_info);
#line 375 "rpl.vala"
	res = _tmp6_;
#line 376 "rpl.vala"
	_vala_assert (res == 0, "res == 0");
#line 377 "rpl.vala"
	_tmp7_ = args_info;
#line 377 "rpl.vala"
	_tmp8_ = _tmp7_.inputs;
#line 377 "rpl.vala"
	_tmp8__length1 = _tmp7_.inputs_num;
#line 377 "rpl.vala"
	if (_tmp8__length1 < 2) {
#line 378 "rpl.vala"
		cmdline_parser_print_help ();
#line 379 "rpl.vala"
		exit (EXIT_FAILURE);
#line 2778 "rpl.c"
	}
#line 383 "rpl.vala"
	files = NULL;
#line 384 "rpl.vala"
	_tmp9_ = args_info;
#line 384 "rpl.vala"
	_tmp10_ = _tmp9_.inputs;
#line 384 "rpl.vala"
	_tmp10__length1 = _tmp9_.inputs_num;
#line 384 "rpl.vala"
	_tmp11_ = args_info;
#line 384 "rpl.vala"
	_tmp12_ = _tmp11_.inputs;
#line 384 "rpl.vala"
	_tmp12__length1 = _tmp11_.inputs_num;
#line 2794 "rpl.c"
	{
		gchar** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
#line 384 "rpl.vala"
		file_collection = _tmp12_ + 2;
#line 384 "rpl.vala"
		file_collection_length1 = _tmp12__length1 - 2;
#line 384 "rpl.vala"
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
#line 2806 "rpl.c"
			gchar* _tmp13_;
			gchar* file = NULL;
#line 384 "rpl.vala"
			_tmp13_ = g_strdup (file_collection[file_it]);
#line 384 "rpl.vala"
			file = _tmp13_;
#line 2813 "rpl.c"
			{
				const gchar* _tmp14_;
				gchar* _tmp15_;
#line 385 "rpl.vala"
				_tmp14_ = file;
#line 385 "rpl.vala"
				_tmp15_ = g_strdup (_tmp14_);
#line 385 "rpl.vala"
				files = g_list_append (files, _tmp15_);
#line 384 "rpl.vala"
				_g_free0 (file);
#line 2825 "rpl.c"
			}
		}
	}
#line 387 "rpl.vala"
	_tmp16_ = files;
#line 387 "rpl.vala"
	if (g_list_length (_tmp16_) == ((guint) 0)) {
#line 2833 "rpl.c"
		gengetopt_args_info _tmp17_;
		gchar* _tmp18_;
#line 388 "rpl.vala"
		_tmp17_ = args_info;
#line 388 "rpl.vala"
		if (_tmp17_.recursive_given) {
#line 389 "rpl.vala"
			die (1, "cannot use --recursive with no file arguments!");
#line 2842 "rpl.c"
		}
#line 391 "rpl.vala"
		_tmp18_ = g_strdup ("-");
#line 391 "rpl.vala"
		files = g_list_append (files, _tmp18_);
#line 2848 "rpl.c"
	} else {
		gengetopt_args_info _tmp19_;
		gengetopt_args_info _tmp30_;
		GList* _tmp43_;
#line 394 "rpl.vala"
		_tmp19_ = args_info;
#line 394 "rpl.vala"
		if (_tmp19_.recursive_given) {
#line 2857 "rpl.c"
			GList* expanded_files = NULL;
			GList* _tmp20_;
			GList* _tmp29_;
#line 395 "rpl.vala"
			expanded_files = NULL;
#line 396 "rpl.vala"
			_tmp20_ = files;
#line 2865 "rpl.c"
			{
				GList* file_collection = NULL;
				GList* file_it = NULL;
#line 396 "rpl.vala"
				file_collection = _tmp20_;
#line 396 "rpl.vala"
				for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2873 "rpl.c"
					gchar* _tmp21_;
					gchar* file = NULL;
#line 396 "rpl.vala"
					_tmp21_ = g_strdup ((const gchar*) file_it->data);
#line 396 "rpl.vala"
					file = _tmp21_;
#line 2880 "rpl.c"
					{
						const gchar* _tmp22_;
#line 397 "rpl.vala"
						_tmp22_ = file;
#line 397 "rpl.vala"
						if (g_file_test (_tmp22_, G_FILE_TEST_IS_DIR)) {
#line 2887 "rpl.c"
							const gchar* _tmp23_;
							GFile* _tmp24_;
							GFile* _tmp25_;
							GList* _tmp26_;
#line 398 "rpl.vala"
							_tmp23_ = file;
#line 398 "rpl.vala"
							_tmp24_ = g_file_new_for_path (_tmp23_);
#line 398 "rpl.vala"
							_tmp25_ = _tmp24_;
#line 398 "rpl.vala"
							_tmp26_ = get_dir_tree (_tmp25_);
#line 398 "rpl.vala"
							expanded_files = g_list_concat (expanded_files, _tmp26_);
#line 398 "rpl.vala"
							_g_object_unref0 (_tmp25_);
#line 2904 "rpl.c"
						} else {
							const gchar* _tmp27_;
							gchar* _tmp28_;
#line 400 "rpl.vala"
							_tmp27_ = file;
#line 400 "rpl.vala"
							_tmp28_ = g_strdup (_tmp27_);
#line 400 "rpl.vala"
							expanded_files = g_list_append (expanded_files, _tmp28_);
#line 2914 "rpl.c"
						}
#line 396 "rpl.vala"
						_g_free0 (file);
#line 2918 "rpl.c"
					}
				}
			}
#line 403 "rpl.vala"
			_tmp29_ = expanded_files;
#line 403 "rpl.vala"
			expanded_files = NULL;
#line 403 "rpl.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 403 "rpl.vala"
			files = _tmp29_;
#line 394 "rpl.vala"
			(expanded_files == NULL) ? NULL : (expanded_files = (_g_list_free__g_free0_ (expanded_files), NULL));
#line 2932 "rpl.c"
		}
#line 407 "rpl.vala"
		_tmp30_ = args_info;
#line 407 "rpl.vala"
		if (_tmp30_.glob_given > ((guint) 0)) {
#line 2938 "rpl.c"
			GList* filtered_files = NULL;
			GList* _tmp31_;
			GList* _tmp42_;
#line 408 "rpl.vala"
			filtered_files = NULL;
#line 409 "rpl.vala"
			_tmp31_ = files;
#line 2946 "rpl.c"
			{
				GList* file_collection = NULL;
				GList* file_it = NULL;
#line 409 "rpl.vala"
				file_collection = _tmp31_;
#line 409 "rpl.vala"
				for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
#line 2954 "rpl.c"
					gchar* _tmp32_;
					gchar* file = NULL;
#line 409 "rpl.vala"
					_tmp32_ = g_strdup ((const gchar*) file_it->data);
#line 409 "rpl.vala"
					file = _tmp32_;
#line 2961 "rpl.c"
					{
						{
							gint i = 0;
#line 410 "rpl.vala"
							i = 0;
#line 2967 "rpl.c"
							{
								gboolean _tmp33_ = FALSE;
#line 410 "rpl.vala"
								_tmp33_ = TRUE;
#line 410 "rpl.vala"
								while (TRUE) {
#line 2974 "rpl.c"
									gengetopt_args_info _tmp35_;
									gengetopt_args_info _tmp36_;
									gchar** _tmp37_;
									gint _tmp37__length1;
									const gchar* _tmp38_;
									const gchar* _tmp39_;
#line 410 "rpl.vala"
									if (!_tmp33_) {
#line 2983 "rpl.c"
										gint _tmp34_;
#line 410 "rpl.vala"
										_tmp34_ = i;
#line 410 "rpl.vala"
										i = _tmp34_ + 1;
#line 2989 "rpl.c"
									}
#line 410 "rpl.vala"
									_tmp33_ = FALSE;
#line 410 "rpl.vala"
									_tmp35_ = args_info;
#line 410 "rpl.vala"
									if (!(((guint) i) < _tmp35_.glob_given)) {
#line 410 "rpl.vala"
										break;
#line 2999 "rpl.c"
									}
#line 411 "rpl.vala"
									_tmp36_ = args_info;
#line 411 "rpl.vala"
									_tmp37_ = _tmp36_.glob_arg;
#line 411 "rpl.vala"
									_tmp37__length1 = -1;
#line 411 "rpl.vala"
									_tmp38_ = _tmp37_[i];
#line 411 "rpl.vala"
									_tmp39_ = file;
#line 411 "rpl.vala"
									if (fnmatch (_tmp38_, _tmp39_, FNM_NOESCAPE | FNM_PERIOD) == 0) {
#line 3013 "rpl.c"
										const gchar* _tmp40_;
										gchar* _tmp41_;
#line 412 "rpl.vala"
										_tmp40_ = file;
#line 412 "rpl.vala"
										_tmp41_ = g_strdup (_tmp40_);
#line 412 "rpl.vala"
										filtered_files = g_list_append (filtered_files, _tmp41_);
#line 413 "rpl.vala"
										break;
#line 3024 "rpl.c"
									}
								}
							}
						}
#line 409 "rpl.vala"
						_g_free0 (file);
#line 3031 "rpl.c"
					}
				}
			}
#line 417 "rpl.vala"
			_tmp42_ = filtered_files;
#line 417 "rpl.vala"
			filtered_files = NULL;
#line 417 "rpl.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 417 "rpl.vala"
			files = _tmp42_;
#line 407 "rpl.vala"
			(filtered_files == NULL) ? NULL : (filtered_files = (_g_list_free__g_free0_ (filtered_files), NULL));
#line 3045 "rpl.c"
		}
#line 421 "rpl.vala"
		_tmp43_ = files;
#line 421 "rpl.vala"
		if (g_list_length (_tmp43_) == ((guint) 0)) {
#line 422 "rpl.vala"
			die (1, "the given filename patterns did not match any files!");
#line 3053 "rpl.c"
		}
	}
#line 429 "rpl.vala"
	_tmp44_ = args_info;
#line 429 "rpl.vala"
	if (_tmp44_.files_given) {
#line 3060 "rpl.c"
		gengetopt_args_info _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		GString* _tmp48_;
		gengetopt_args_info _tmp49_;
		gchar** _tmp50_;
		gint _tmp50__length1;
		const gchar* _tmp51_;
		GString* _tmp52_;
#line 430 "rpl.vala"
		_tmp45_ = args_info;
#line 430 "rpl.vala"
		_tmp46_ = _tmp45_.inputs;
#line 430 "rpl.vala"
		_tmp46__length1 = _tmp45_.inputs_num;
#line 430 "rpl.vala"
		_tmp47_ = _tmp46_[0];
#line 430 "rpl.vala"
		_tmp48_ = slurp_patterns (_tmp47_);
#line 430 "rpl.vala"
		_g_string_free0 (old_text);
#line 430 "rpl.vala"
		old_text = _tmp48_;
#line 431 "rpl.vala"
		_tmp49_ = args_info;
#line 431 "rpl.vala"
		_tmp50_ = _tmp49_.inputs;
#line 431 "rpl.vala"
		_tmp50__length1 = _tmp49_.inputs_num;
#line 431 "rpl.vala"
		_tmp51_ = _tmp50_[1];
#line 431 "rpl.vala"
		_tmp52_ = slurp_patterns (_tmp51_);
#line 431 "rpl.vala"
		_g_string_free0 (new_text);
#line 431 "rpl.vala"
		new_text = _tmp52_;
#line 3099 "rpl.c"
	} else {
		gengetopt_args_info _tmp53_;
		gchar** _tmp54_;
		gint _tmp54__length1;
		const gchar* _tmp55_;
		GString* _tmp56_;
		gengetopt_args_info _tmp57_;
		gchar** _tmp58_;
		gint _tmp58__length1;
		const gchar* _tmp59_;
		GString* _tmp60_;
#line 433 "rpl.vala"
		_tmp53_ = args_info;
#line 433 "rpl.vala"
		_tmp54_ = _tmp53_.inputs;
#line 433 "rpl.vala"
		_tmp54__length1 = _tmp53_.inputs_num;
#line 433 "rpl.vala"
		_tmp55_ = _tmp54_[0];
#line 433 "rpl.vala"
		_tmp56_ = g_string_new (_tmp55_);
#line 433 "rpl.vala"
		_g_string_free0 (old_text);
#line 433 "rpl.vala"
		old_text = _tmp56_;
#line 434 "rpl.vala"
		_tmp57_ = args_info;
#line 434 "rpl.vala"
		_tmp58_ = _tmp57_.inputs;
#line 434 "rpl.vala"
		_tmp58__length1 = _tmp57_.inputs_num;
#line 434 "rpl.vala"
		_tmp59_ = _tmp58_[1];
#line 434 "rpl.vala"
		_tmp60_ = g_string_new (_tmp59_);
#line 434 "rpl.vala"
		_g_string_free0 (new_text);
#line 434 "rpl.vala"
		new_text = _tmp60_;
#line 3139 "rpl.c"
	}
#line 438 "rpl.vala"
	_tmp61_ = args_info;
#line 438 "rpl.vala"
	if (!_tmp61_.quiet_given) {
#line 3145 "rpl.c"
		const gchar* _tmp62_ = NULL;
		gengetopt_args_info _tmp63_;
		const gchar* _tmp64_ = NULL;
		gengetopt_args_info _tmp65_;
		const gchar* _tmp68_ = NULL;
		gengetopt_args_info _tmp69_;
		GString* _tmp70_;
		GString* _tmp71_;
		const gchar* _tmp72_;
		GString* _tmp73_;
		GString* _tmp74_;
		const gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
#line 440 "rpl.vala"
		_tmp63_ = args_info;
#line 440 "rpl.vala"
		if (_tmp63_.dry_run_given) {
#line 440 "rpl.vala"
			_tmp62_ = "simulating replacement of";
#line 3166 "rpl.c"
		} else {
#line 440 "rpl.vala"
			_tmp62_ = "replacing";
#line 3170 "rpl.c"
		}
#line 443 "rpl.vala"
		_tmp65_ = args_info;
#line 443 "rpl.vala"
		if (_tmp65_.ignore_case_given) {
#line 443 "rpl.vala"
			_tmp64_ = "ignoring case";
#line 3178 "rpl.c"
		} else {
			const gchar* _tmp66_ = NULL;
			gengetopt_args_info _tmp67_;
#line 443 "rpl.vala"
			_tmp67_ = args_info;
#line 443 "rpl.vala"
			if (_tmp67_.match_case_given) {
#line 443 "rpl.vala"
				_tmp66_ = "matching case";
#line 3188 "rpl.c"
			} else {
#line 443 "rpl.vala"
				_tmp66_ = "case sensitive";
#line 3192 "rpl.c"
			}
#line 443 "rpl.vala"
			_tmp64_ = _tmp66_;
#line 3196 "rpl.c"
		}
#line 444 "rpl.vala"
		_tmp69_ = args_info;
#line 444 "rpl.vala"
		if (_tmp69_.whole_words_given) {
#line 444 "rpl.vala"
			_tmp68_ = "whole words only";
#line 3204 "rpl.c"
		} else {
#line 444 "rpl.vala"
			_tmp68_ = "partial words matched";
#line 3208 "rpl.c"
		}
#line 439 "rpl.vala"
		_tmp70_ = old_text;
#line 439 "rpl.vala"
		_tmp71_ = old_text;
#line 439 "rpl.vala"
		_tmp72_ = _tmp71_->str;
#line 439 "rpl.vala"
		_tmp73_ = new_text;
#line 439 "rpl.vala"
		_tmp74_ = new_text;
#line 439 "rpl.vala"
		_tmp75_ = _tmp74_->str;
#line 439 "rpl.vala"
		_tmp76_ = g_strdup_printf ("%s \"%.*s\" with \"%.*s\" (%s; %s)", _tmp62_, (gint) _tmp70_->len, _tmp72_, (gint) _tmp73_->len, _tmp75_, _tmp64_, _tmp68_);
#line 439 "rpl.vala"
		_tmp77_ = _tmp76_;
#line 439 "rpl.vala"
		warn (_tmp77_);
#line 439 "rpl.vala"
		_g_free0 (_tmp77_);
#line 3230 "rpl.c"
	}
#line 448 "rpl.vala"
	_tmp79_ = args_info;
#line 448 "rpl.vala"
	if (_tmp79_.dry_run_given) {
#line 3236 "rpl.c"
		gengetopt_args_info _tmp80_;
#line 448 "rpl.vala"
		_tmp80_ = args_info;
#line 448 "rpl.vala"
		_tmp78_ = !_tmp80_.quiet_given;
#line 3242 "rpl.c"
	} else {
#line 448 "rpl.vala"
		_tmp78_ = FALSE;
#line 3246 "rpl.c"
	}
#line 448 "rpl.vala"
	if (_tmp78_) {
#line 449 "rpl.vala"
		warn ("the files listed below would be modified in a replace operation");
#line 3252 "rpl.c"
	}
#line 452 "rpl.vala"
	_tmp81_ = args_info;
#line 452 "rpl.vala"
	_tmp82_ = _tmp81_.encoding_arg;
#line 452 "rpl.vala"
	_tmp83_ = g_strdup (_tmp82_);
#line 452 "rpl.vala"
	encoding = _tmp83_;
#line 453 "rpl.vala"
	_tmp84_ = encoding;
#line 453 "rpl.vala"
	if (_tmp84_ != NULL) {
#line 3266 "rpl.c"
		const gchar* _tmp85_;
		gchar* _tmp86_;
#line 454 "rpl.vala"
		_tmp85_ = encoding;
#line 454 "rpl.vala"
		_tmp86_ = g_utf8_strup (_tmp85_, (gssize) -1);
#line 454 "rpl.vala"
		_g_free0 (encoding);
#line 454 "rpl.vala"
		encoding = _tmp86_;
#line 3277 "rpl.c"
	}
#line 457 "rpl.vala"
	_tmp87_ = pcre2_compile_context_create (NULL);
#line 457 "rpl.vala"
	ccontext = _tmp87_;
#line 458 "rpl.vala"
	_tmp88_ = args_info;
#line 458 "rpl.vala"
	if (_tmp88_.whole_words_given) {
#line 3287 "rpl.c"
		pcre2_compile_context* _tmp89_;
#line 459 "rpl.vala"
		_tmp89_ = ccontext;
#line 459 "rpl.vala"
		pcre2_set_compile_extra_options (_tmp89_, PCRE2_EXTRA_MATCH_WORD);
#line 3293 "rpl.c"
	}
#line 462 "rpl.vala"
	opts = (PCRE2_MULTILINE | PCRE2_UTF) | PCRE2_UCP;
#line 463 "rpl.vala"
	replace_opts = 0;
#line 464 "rpl.vala"
	_tmp90_ = args_info;
#line 464 "rpl.vala"
	if (_tmp90_.fixed_strings_given) {
#line 465 "rpl.vala"
		opts = PCRE2_LITERAL;
#line 466 "rpl.vala"
		replace_opts |= PCRE2_SUBSTITUTE_LITERAL;
#line 3307 "rpl.c"
	}
#line 468 "rpl.vala"
	_tmp92_ = args_info;
#line 468 "rpl.vala"
	if (_tmp92_.ignore_case_given) {
#line 468 "rpl.vala"
		_tmp91_ = TRUE;
#line 3315 "rpl.c"
	} else {
		gengetopt_args_info _tmp93_;
#line 468 "rpl.vala"
		_tmp93_ = args_info;
#line 468 "rpl.vala"
		_tmp91_ = _tmp93_.match_case_given;
#line 3322 "rpl.c"
	}
#line 468 "rpl.vala"
	if (_tmp91_) {
#line 469 "rpl.vala"
		opts |= PCRE2_CASELESS;
#line 3328 "rpl.c"
	}
#line 473 "rpl.vala"
	_tmp94_ = old_text;
#line 473 "rpl.vala"
	_tmp95_ = g_string_get_data (_tmp94_, &_tmp96_);
#line 473 "rpl.vala"
	_tmp95__length1 = _tmp96_;
#line 473 "rpl.vala"
	_tmp97_ = _tmp95_;
#line 473 "rpl.vala"
	_tmp97__length1 = _tmp95__length1;
#line 473 "rpl.vala"
	_tmp98_ = ccontext;
#line 473 "rpl.vala"
	_tmp101_ = pcre2_compile ((PCRE2_UCHAR*) _tmp97_, (size_t) ((_tmp97__length1 * sizeof (guint8)) / sizeof (PCRE2_UCHAR)), opts, &_tmp99_, &_tmp100_, _tmp98_);
#line 473 "rpl.vala"
	errorcode = _tmp99_;
#line 473 "rpl.vala"
	erroroffset = _tmp100_;
#line 473 "rpl.vala"
	regex = _tmp101_;
#line 474 "rpl.vala"
	_tmp102_ = regex;
#line 474 "rpl.vala"
	if (_tmp102_ == NULL) {
#line 3354 "rpl.c"
		GString* _tmp103_;
		GString* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
#line 475 "rpl.vala"
		_tmp103_ = old_text;
#line 475 "rpl.vala"
		_tmp104_ = old_text;
#line 475 "rpl.vala"
		_tmp105_ = _tmp104_->str;
#line 475 "rpl.vala"
		_tmp106_ = _vala_pcre2_get_error_message (errorcode);
#line 475 "rpl.vala"
		_tmp107_ = _tmp106_;
#line 475 "rpl.vala"
		_tmp108_ = g_strdup_printf ("bad regex %.*s (%s)", (gint) _tmp103_->len, _tmp105_, _tmp107_);
#line 475 "rpl.vala"
		_tmp109_ = _tmp108_;
#line 475 "rpl.vala"
		die (1, _tmp109_);
#line 475 "rpl.vala"
		_g_free0 (_tmp109_);
#line 475 "rpl.vala"
		_g_free0 (_tmp107_);
#line 3382 "rpl.c"
	}
#line 477 "rpl.vala"
	_tmp111_ = regex;
#line 477 "rpl.vala"
	if (pcre2_jit_compile (_tmp111_, PCRE2_JIT_COMPLETE | PCRE2_JIT_PARTIAL_HARD) != 0) {
#line 3388 "rpl.c"
		gengetopt_args_info _tmp112_;
#line 478 "rpl.vala"
		_tmp112_ = args_info;
#line 478 "rpl.vala"
		_tmp110_ = _tmp112_.verbose_given;
#line 3394 "rpl.c"
	} else {
#line 477 "rpl.vala"
		_tmp110_ = FALSE;
#line 3398 "rpl.c"
	}
#line 477 "rpl.vala"
	if (_tmp110_) {
#line 479 "rpl.vala"
		warn ("JIT compilation of regular expression failed");
#line 3404 "rpl.c"
	}
#line 483 "rpl.vala"
	total_files = (gsize) 0;
#line 484 "rpl.vala"
	matched_files = (gsize) 0;
#line 485 "rpl.vala"
	total_matches = (gsize) 0;
#line 486 "rpl.vala"
	_tmp113_ = files;
#line 3414 "rpl.c"
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
#line 486 "rpl.vala"
		filename_collection = _tmp113_;
#line 486 "rpl.vala"
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
#line 3422 "rpl.c"
			gchar* _tmp114_;
			gchar* filename = NULL;
#line 486 "rpl.vala"
			_tmp114_ = g_strdup ((const gchar*) filename_it->data);
#line 486 "rpl.vala"
			filename = _tmp114_;
#line 3429 "rpl.c"
			{
				gboolean have_perms = FALSE;
				struct stat perms = {0};
				GInputStream* input = NULL;
				GOutputStream* output = NULL;
				gchar* tmp_path = NULL;
				const gchar* _tmp115_;
				GInputStream* _tmp185_;
				GBufferedInputStream* _tmp186_;
				GOutputStream* _tmp187_;
				GBufferedOutputStream* _tmp188_;
				gboolean _tmp189_ = FALSE;
				gengetopt_args_info _tmp190_;
				gengetopt_args_info _tmp196_;
				gssize num_matches = 0L;
				const gchar* _tmp252_;
				GOutputStream* _tmp296_;
				gengetopt_args_info _tmp306_;
				const gchar* _tmp327_;
#line 487 "rpl.vala"
				have_perms = FALSE;
#line 488 "rpl.vala"
				memset (&perms, 0, sizeof (struct stat));
#line 491 "rpl.vala"
				tmp_path = NULL;
#line 492 "rpl.vala"
				_tmp115_ = filename;
#line 492 "rpl.vala"
				if (g_strcmp0 (_tmp115_, "-") == 0) {
#line 3459 "rpl.c"
					gchar* _tmp116_;
					FdInputStream* _tmp117_;
					FdOutputStream* _tmp118_;
#line 493 "rpl.vala"
					initial_buf_size = 64 * 1024;
#line 494 "rpl.vala"
					_tmp116_ = g_strdup ("standard input");
#line 494 "rpl.vala"
					_g_free0 (filename);
#line 494 "rpl.vala"
					filename = _tmp116_;
#line 495 "rpl.vala"
					set_binary_mode (STDIN_FILENO, O_BINARY);
#line 496 "rpl.vala"
					_tmp117_ = fd_input_stream_new (STDIN_FILENO);
#line 496 "rpl.vala"
					_g_object_unref0 (input);
#line 496 "rpl.vala"
					input = (GInputStream*) _tmp117_;
#line 497 "rpl.vala"
					set_binary_mode (STDOUT_FILENO, O_BINARY);
#line 498 "rpl.vala"
					_tmp118_ = fd_output_stream_new (STDOUT_FILENO);
#line 498 "rpl.vala"
					_g_object_unref0 (output);
#line 498 "rpl.vala"
					output = (GOutputStream*) _tmp118_;
#line 3487 "rpl.c"
				} else {
					const gchar* _tmp119_;
					struct stat _tmp120_ = {0};
					gint _tmp121_;
					struct stat _tmp128_;
					gengetopt_args_info _tmp153_;
#line 501 "rpl.vala"
					_tmp119_ = filename;
#line 501 "rpl.vala"
					_tmp121_ = lstat (_tmp119_, &_tmp120_);
#line 501 "rpl.vala"
					perms = _tmp120_;
#line 501 "rpl.vala"
					if (_tmp121_ != 0) {
#line 3502 "rpl.c"
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						const gchar* _tmp124_;
						const gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
#line 502 "rpl.vala"
						_tmp122_ = filename;
#line 502 "rpl.vala"
						_tmp123_ = string_to_string (_tmp122_);
#line 502 "rpl.vala"
						_tmp124_ = g_strerror (errno);
#line 502 "rpl.vala"
						_tmp125_ = string_to_string (_tmp124_);
#line 502 "rpl.vala"
						_tmp126_ = g_strconcat ("skipping ", _tmp123_, ": ", _tmp125_, NULL);
#line 502 "rpl.vala"
						_tmp127_ = _tmp126_;
#line 502 "rpl.vala"
						warn (_tmp127_);
#line 502 "rpl.vala"
						_g_free0 (_tmp127_);
#line 503 "rpl.vala"
						_g_free0 (tmp_path);
#line 503 "rpl.vala"
						_g_object_unref0 (output);
#line 503 "rpl.vala"
						_g_object_unref0 (input);
#line 503 "rpl.vala"
						_g_free0 (filename);
#line 503 "rpl.vala"
						continue;
#line 3535 "rpl.c"
					}
#line 505 "rpl.vala"
					have_perms = TRUE;
#line 506 "rpl.vala"
					_tmp128_ = perms;
#line 506 "rpl.vala"
					if (S_ISDIR (_tmp128_.st_mode)) {
#line 3543 "rpl.c"
						const gchar* _tmp129_;
						const gchar* _tmp130_;
						gchar* _tmp131_;
						gchar* _tmp132_;
#line 507 "rpl.vala"
						_tmp129_ = filename;
#line 507 "rpl.vala"
						_tmp130_ = string_to_string (_tmp129_);
#line 507 "rpl.vala"
						_tmp131_ = g_strconcat ("skipping directory ", _tmp130_, NULL);
#line 507 "rpl.vala"
						_tmp132_ = _tmp131_;
#line 507 "rpl.vala"
						warn (_tmp132_);
#line 507 "rpl.vala"
						_g_free0 (_tmp132_);
#line 508 "rpl.vala"
						_g_free0 (tmp_path);
#line 508 "rpl.vala"
						_g_object_unref0 (output);
#line 508 "rpl.vala"
						_g_object_unref0 (input);
#line 508 "rpl.vala"
						_g_free0 (filename);
#line 508 "rpl.vala"
						continue;
#line 3570 "rpl.c"
					} else {
						struct stat _tmp133_;
#line 509 "rpl.vala"
						_tmp133_ = perms;
#line 509 "rpl.vala"
						if (!S_ISREG (_tmp133_.st_mode)) {
#line 3577 "rpl.c"
							const gchar* _tmp134_;
							const gchar* _tmp135_;
							gchar* _tmp136_;
							gchar* _tmp137_;
#line 510 "rpl.vala"
							_tmp134_ = filename;
#line 510 "rpl.vala"
							_tmp135_ = string_to_string (_tmp134_);
#line 510 "rpl.vala"
							_tmp136_ = g_strconcat ("skipping ", _tmp135_, ": not a regular file", NULL);
#line 510 "rpl.vala"
							_tmp137_ = _tmp136_;
#line 510 "rpl.vala"
							warn (_tmp137_);
#line 510 "rpl.vala"
							_g_free0 (_tmp137_);
#line 511 "rpl.vala"
							_g_free0 (tmp_path);
#line 511 "rpl.vala"
							_g_object_unref0 (output);
#line 511 "rpl.vala"
							_g_object_unref0 (input);
#line 511 "rpl.vala"
							_g_free0 (filename);
#line 511 "rpl.vala"
							continue;
#line 3604 "rpl.c"
						}
					}
					{
						GFileInputStream* _tmp138_ = NULL;
						const gchar* _tmp139_;
						GFile* _tmp140_;
						GFile* _tmp141_;
						GFileInputStream* _tmp142_;
						GFileInputStream* _tmp143_;
						GFileInputStream* _tmp144_;
#line 516 "rpl.vala"
						_tmp139_ = filename;
#line 516 "rpl.vala"
						_tmp140_ = g_file_new_for_path (_tmp139_);
#line 516 "rpl.vala"
						_tmp141_ = _tmp140_;
#line 516 "rpl.vala"
						_tmp142_ = g_file_read (_tmp141_, NULL, &_inner_error0_);
#line 516 "rpl.vala"
						_tmp143_ = _tmp142_;
#line 516 "rpl.vala"
						_g_object_unref0 (_tmp141_);
#line 516 "rpl.vala"
						_tmp138_ = _tmp143_;
#line 516 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3631 "rpl.c"
							goto __catch0_g_error;
						}
#line 516 "rpl.vala"
						_tmp144_ = _tmp138_;
#line 516 "rpl.vala"
						_tmp138_ = NULL;
#line 516 "rpl.vala"
						_g_object_unref0 (input);
#line 516 "rpl.vala"
						input = (GInputStream*) _tmp144_;
#line 515 "rpl.vala"
						_g_object_unref0 (_tmp138_);
#line 3644 "rpl.c"
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp145_;
						const gchar* _tmp146_;
						GError* _tmp147_;
						const gchar* _tmp148_;
						const gchar* _tmp149_;
						gchar* _tmp150_;
						gchar* _tmp151_;
#line 515 "rpl.vala"
						e = _inner_error0_;
#line 515 "rpl.vala"
						_inner_error0_ = NULL;
#line 518 "rpl.vala"
						_tmp145_ = filename;
#line 518 "rpl.vala"
						_tmp146_ = string_to_string (_tmp145_);
#line 518 "rpl.vala"
						_tmp147_ = e;
#line 518 "rpl.vala"
						_tmp148_ = _tmp147_->message;
#line 518 "rpl.vala"
						_tmp149_ = string_to_string (_tmp148_);
#line 518 "rpl.vala"
						_tmp150_ = g_strconcat ("skipping ", _tmp146_, ": ", _tmp149_, NULL);
#line 518 "rpl.vala"
						_tmp151_ = _tmp150_;
#line 518 "rpl.vala"
						warn (_tmp151_);
#line 518 "rpl.vala"
						_g_free0 (_tmp151_);
#line 519 "rpl.vala"
						_g_error_free0 (e);
#line 519 "rpl.vala"
						_g_free0 (tmp_path);
#line 519 "rpl.vala"
						_g_object_unref0 (output);
#line 519 "rpl.vala"
						_g_object_unref0 (input);
#line 519 "rpl.vala"
						_g_free0 (filename);
#line 519 "rpl.vala"
						continue;
#line 3691 "rpl.c"
					}
					__finally0:
#line 515 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3696 "rpl.c"
						gint _tmp152_ = -1;
#line 515 "rpl.vala"
						_g_free0 (tmp_path);
#line 515 "rpl.vala"
						_g_object_unref0 (output);
#line 515 "rpl.vala"
						_g_object_unref0 (input);
#line 515 "rpl.vala"
						_g_free0 (filename);
#line 515 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 515 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 515 "rpl.vala"
						_g_free0 (encoding);
#line 515 "rpl.vala"
						_g_string_free0 (new_text);
#line 515 "rpl.vala"
						_g_string_free0 (old_text);
#line 515 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 515 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 515 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 515 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 515 "rpl.vala"
						return _tmp152_;
#line 3726 "rpl.c"
					}
#line 523 "rpl.vala"
					_tmp153_ = args_info;
#line 523 "rpl.vala"
					if (_tmp153_.dry_run_given) {
#line 524 "rpl.vala"
						_g_object_unref0 (output);
#line 524 "rpl.vala"
						output = NULL;
#line 3736 "rpl.c"
					} else {
						const gchar* _tmp154_;
						gchar* _tmp155_;
						gchar* _tmp156_;
						gchar* _tmp157_;
						gint fd = 0;
						const gchar* _tmp158_;
						FdOutputStream* _tmp165_;
						gboolean _tmp166_ = FALSE;
						gboolean _tmp167_ = FALSE;
						const gchar* _tmp168_;
						struct stat _tmp169_;
						struct stat _tmp170_;
#line 526 "rpl.vala"
						_tmp154_ = filename;
#line 526 "rpl.vala"
						_tmp155_ = g_path_get_dirname (_tmp154_);
#line 526 "rpl.vala"
						_tmp156_ = _tmp155_;
#line 526 "rpl.vala"
						_tmp157_ = g_build_filename (_tmp156_, ".tmp.rpl-XXXXXX", NULL);
#line 526 "rpl.vala"
						_g_free0 (tmp_path);
#line 526 "rpl.vala"
						tmp_path = _tmp157_;
#line 526 "rpl.vala"
						_g_free0 (_tmp156_);
#line 527 "rpl.vala"
						_tmp158_ = tmp_path;
#line 527 "rpl.vala"
						fd = g_mkstemp (_tmp158_);
#line 528 "rpl.vala"
						if (fd == -1) {
#line 3770 "rpl.c"
							const gchar* _tmp159_;
							const gchar* _tmp160_;
							const gchar* _tmp161_;
							const gchar* _tmp162_;
							gchar* _tmp163_;
							gchar* _tmp164_;
#line 529 "rpl.vala"
							_tmp159_ = filename;
#line 529 "rpl.vala"
							_tmp160_ = string_to_string (_tmp159_);
#line 529 "rpl.vala"
							_tmp161_ = strerror (errno);
#line 529 "rpl.vala"
							_tmp162_ = string_to_string (_tmp161_);
#line 529 "rpl.vala"
							_tmp163_ = g_strconcat ("skipping ", _tmp160_, ": cannot create temp file: ", _tmp162_, NULL);
#line 529 "rpl.vala"
							_tmp164_ = _tmp163_;
#line 529 "rpl.vala"
							warn (_tmp164_);
#line 529 "rpl.vala"
							_g_free0 (_tmp164_);
#line 530 "rpl.vala"
							_g_free0 (tmp_path);
#line 530 "rpl.vala"
							_g_object_unref0 (output);
#line 530 "rpl.vala"
							_g_object_unref0 (input);
#line 530 "rpl.vala"
							_g_free0 (filename);
#line 530 "rpl.vala"
							continue;
#line 3803 "rpl.c"
						}
#line 532 "rpl.vala"
						_tmp165_ = fd_output_stream_new (fd);
#line 532 "rpl.vala"
						_g_object_unref0 (output);
#line 532 "rpl.vala"
						output = (GOutputStream*) _tmp165_;
#line 535 "rpl.vala"
						errno = 0;
#line 536 "rpl.vala"
						_tmp168_ = tmp_path;
#line 536 "rpl.vala"
						_tmp169_ = perms;
#line 536 "rpl.vala"
						_tmp170_ = perms;
#line 536 "rpl.vala"
						if (chown (_tmp168_, _tmp169_.st_uid, _tmp170_.st_gid) != 0) {
#line 536 "rpl.vala"
							_tmp167_ = errno != ENOSYS;
#line 3823 "rpl.c"
						} else {
#line 536 "rpl.vala"
							_tmp167_ = FALSE;
#line 3827 "rpl.c"
						}
#line 536 "rpl.vala"
						if (_tmp167_) {
#line 536 "rpl.vala"
							_tmp166_ = TRUE;
#line 3833 "rpl.c"
						} else {
							const gchar* _tmp171_;
							struct stat _tmp172_;
#line 537 "rpl.vala"
							_tmp171_ = tmp_path;
#line 537 "rpl.vala"
							_tmp172_ = perms;
#line 537 "rpl.vala"
							_tmp166_ = chmod (_tmp171_, _tmp172_.st_mode) != 0;
#line 3843 "rpl.c"
						}
#line 536 "rpl.vala"
						if (_tmp166_) {
#line 3847 "rpl.c"
							const gchar* _tmp173_;
							const gchar* _tmp174_;
							const gchar* _tmp175_;
							const gchar* _tmp176_;
							gchar* _tmp177_;
							gchar* _tmp178_;
							gengetopt_args_info _tmp179_;
#line 538 "rpl.vala"
							_tmp173_ = filename;
#line 538 "rpl.vala"
							_tmp174_ = string_to_string (_tmp173_);
#line 538 "rpl.vala"
							_tmp175_ = g_strerror (errno);
#line 538 "rpl.vala"
							_tmp176_ = string_to_string (_tmp175_);
#line 538 "rpl.vala"
							_tmp177_ = g_strconcat ("unable to set attributes of ", _tmp174_, ": ", _tmp176_, NULL);
#line 538 "rpl.vala"
							_tmp178_ = _tmp177_;
#line 538 "rpl.vala"
							warn (_tmp178_);
#line 538 "rpl.vala"
							_g_free0 (_tmp178_);
#line 539 "rpl.vala"
							_tmp179_ = args_info;
#line 539 "rpl.vala"
							if (_tmp179_.force_given) {
#line 540 "rpl.vala"
								warn ("new file attributes may not match!");
#line 3877 "rpl.c"
							} else {
								const gchar* _tmp180_;
								const gchar* _tmp181_;
								gchar* _tmp182_;
								gchar* _tmp183_;
								const gchar* _tmp184_;
#line 542 "rpl.vala"
								_tmp180_ = filename;
#line 542 "rpl.vala"
								_tmp181_ = string_to_string (_tmp180_);
#line 542 "rpl.vala"
								_tmp182_ = g_strconcat ("skipping ", _tmp181_, "!", NULL);
#line 542 "rpl.vala"
								_tmp183_ = _tmp182_;
#line 542 "rpl.vala"
								warn (_tmp183_);
#line 542 "rpl.vala"
								_g_free0 (_tmp183_);
#line 543 "rpl.vala"
								_tmp184_ = tmp_path;
#line 543 "rpl.vala"
								remove_temp_file (_tmp184_);
#line 544 "rpl.vala"
								_g_free0 (tmp_path);
#line 544 "rpl.vala"
								_g_object_unref0 (output);
#line 544 "rpl.vala"
								_g_object_unref0 (input);
#line 544 "rpl.vala"
								_g_free0 (filename);
#line 544 "rpl.vala"
								continue;
#line 3910 "rpl.c"
							}
						}
					}
				}
#line 551 "rpl.vala"
				_tmp185_ = input;
#line 551 "rpl.vala"
				_tmp186_ = (GBufferedInputStream*) g_buffered_input_stream_new_sized (_tmp185_, (gsize) initial_buf_size);
#line 551 "rpl.vala"
				_g_object_unref0 (input);
#line 551 "rpl.vala"
				input = (GInputStream*) _tmp186_;
#line 552 "rpl.vala"
				_tmp187_ = output;
#line 552 "rpl.vala"
				_tmp188_ = (GBufferedOutputStream*) g_buffered_output_stream_new_sized (_tmp187_, (gsize) initial_buf_size);
#line 552 "rpl.vala"
				_g_object_unref0 (output);
#line 552 "rpl.vala"
				output = (GOutputStream*) _tmp188_;
#line 554 "rpl.vala"
				total_files += (gsize) 1;
#line 556 "rpl.vala"
				_tmp190_ = args_info;
#line 556 "rpl.vala"
				if (_tmp190_.verbose_given) {
#line 3937 "rpl.c"
					gengetopt_args_info _tmp191_;
#line 556 "rpl.vala"
					_tmp191_ = args_info;
#line 556 "rpl.vala"
					_tmp189_ = !_tmp191_.dry_run_given;
#line 3943 "rpl.c"
				} else {
#line 556 "rpl.vala"
					_tmp189_ = FALSE;
#line 3947 "rpl.c"
				}
#line 556 "rpl.vala"
				if (_tmp189_) {
#line 3951 "rpl.c"
					const gchar* _tmp192_;
					const gchar* _tmp193_;
					gchar* _tmp194_;
					gchar* _tmp195_;
#line 557 "rpl.vala"
					_tmp192_ = filename;
#line 557 "rpl.vala"
					_tmp193_ = string_to_string (_tmp192_);
#line 557 "rpl.vala"
					_tmp194_ = g_strconcat ("processing ", _tmp193_, NULL);
#line 557 "rpl.vala"
					_tmp195_ = _tmp194_;
#line 557 "rpl.vala"
					warn (_tmp195_);
#line 557 "rpl.vala"
					_g_free0 (_tmp195_);
#line 3968 "rpl.c"
				}
#line 561 "rpl.vala"
				_tmp196_ = args_info;
#line 561 "rpl.vala"
				if (!_tmp196_.encoding_given) {
#line 3974 "rpl.c"
					GString* buf = NULL;
					GString* _tmp197_;
					uchardet_t* detector = NULL;
					uchardet_t* _tmp215_;
					gboolean ok = FALSE;
					uchardet_t* _tmp216_;
					GString* _tmp217_;
					guint8* _tmp218_;
					gint _tmp218__length1;
					gint _tmp219_ = 0;
					guint8* _tmp220_;
					gint _tmp220__length1;
					uchardet_t* _tmp221_;
					gboolean encoding_guessed = FALSE;
					uchardet_t* _tmp222_;
					const gchar* _tmp223_;
					gchar* _tmp224_;
					const gchar* _tmp225_;
					const gchar* _tmp232_;
					gboolean _tmp240_ = FALSE;
					GString* _tmp245_;
					guint8* _tmp246_;
					gint _tmp246__length1;
					gint _tmp247_ = 0;
					guint8* _tmp248_;
					gint _tmp248__length1;
					GInputStream* _tmp249_;
					GInputStream* _tmp250_;
					PrefixInputStream* _tmp251_;
#line 563 "rpl.vala"
					_tmp197_ = string_builder_sized ((gsize) initial_buf_size);
#line 563 "rpl.vala"
					buf = _tmp197_;
#line 4008 "rpl.c"
					{
						GInputStream* _tmp198_;
						GString* _tmp199_;
						gengetopt_args_info _tmp201_;
#line 565 "rpl.vala"
						_tmp198_ = input;
#line 565 "rpl.vala"
						_tmp199_ = buf;
#line 565 "rpl.vala"
						read_all (_tmp198_, _tmp199_, &_inner_error0_);
#line 565 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4021 "rpl.c"
							gint _tmp200_ = -1;
#line 565 "rpl.vala"
							if (_inner_error0_->domain == G_IO_ERROR) {
#line 4025 "rpl.c"
								goto __catch1_g_io_error;
							}
#line 565 "rpl.vala"
							_g_string_free0 (buf);
#line 565 "rpl.vala"
							_g_free0 (tmp_path);
#line 565 "rpl.vala"
							_g_object_unref0 (output);
#line 565 "rpl.vala"
							_g_object_unref0 (input);
#line 565 "rpl.vala"
							_g_free0 (filename);
#line 565 "rpl.vala"
							_pcre2_code_free0 (regex);
#line 565 "rpl.vala"
							_pcre2_compile_context_free0 (ccontext);
#line 565 "rpl.vala"
							_g_free0 (encoding);
#line 565 "rpl.vala"
							_g_string_free0 (new_text);
#line 565 "rpl.vala"
							_g_string_free0 (old_text);
#line 565 "rpl.vala"
							(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 565 "rpl.vala"
							args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 565 "rpl.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 565 "rpl.vala"
							g_clear_error (&_inner_error0_);
#line 565 "rpl.vala"
							return _tmp200_;
#line 4058 "rpl.c"
						}
#line 566 "rpl.vala"
						_tmp201_ = args_info;
#line 566 "rpl.vala"
						if (_tmp201_.verbose_given) {
#line 4064 "rpl.c"
							GString* _tmp202_;
							gchar* _tmp203_;
							gchar* _tmp204_;
							gchar* _tmp205_;
							gchar* _tmp206_;
#line 567 "rpl.vala"
							_tmp202_ = buf;
#line 567 "rpl.vala"
							_tmp203_ = g_strdup_printf ("%" G_GSSIZE_FORMAT, _tmp202_->len);
#line 567 "rpl.vala"
							_tmp204_ = _tmp203_;
#line 567 "rpl.vala"
							_tmp205_ = g_strconcat ("bytes read to guess encoding: ", _tmp204_, NULL);
#line 567 "rpl.vala"
							_tmp206_ = _tmp205_;
#line 567 "rpl.vala"
							warn (_tmp206_);
#line 567 "rpl.vala"
							_g_free0 (_tmp206_);
#line 567 "rpl.vala"
							_g_free0 (_tmp204_);
#line 4086 "rpl.c"
						}
					}
					goto __finally1;
					__catch1_g_io_error:
					{
						GError* e = NULL;
						const gchar* _tmp207_;
						const gchar* _tmp208_;
						GError* _tmp209_;
						const gchar* _tmp210_;
						const gchar* _tmp211_;
						gchar* _tmp212_;
						gchar* _tmp213_;
#line 564 "rpl.vala"
						e = _inner_error0_;
#line 564 "rpl.vala"
						_inner_error0_ = NULL;
#line 569 "rpl.vala"
						_tmp207_ = filename;
#line 569 "rpl.vala"
						_tmp208_ = string_to_string (_tmp207_);
#line 569 "rpl.vala"
						_tmp209_ = e;
#line 569 "rpl.vala"
						_tmp210_ = _tmp209_->message;
#line 569 "rpl.vala"
						_tmp211_ = string_to_string (_tmp210_);
#line 569 "rpl.vala"
						_tmp212_ = g_strconcat ("error reading ", _tmp208_, ": ", _tmp211_, "; skipping!", NULL);
#line 569 "rpl.vala"
						_tmp213_ = _tmp212_;
#line 569 "rpl.vala"
						warn (_tmp213_);
#line 569 "rpl.vala"
						_g_free0 (_tmp213_);
#line 570 "rpl.vala"
						_g_error_free0 (e);
#line 570 "rpl.vala"
						_g_string_free0 (buf);
#line 570 "rpl.vala"
						_g_free0 (tmp_path);
#line 570 "rpl.vala"
						_g_object_unref0 (output);
#line 570 "rpl.vala"
						_g_object_unref0 (input);
#line 570 "rpl.vala"
						_g_free0 (filename);
#line 570 "rpl.vala"
						continue;
#line 4136 "rpl.c"
					}
					__finally1:
#line 564 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4141 "rpl.c"
						gint _tmp214_ = -1;
#line 564 "rpl.vala"
						_g_string_free0 (buf);
#line 564 "rpl.vala"
						_g_free0 (tmp_path);
#line 564 "rpl.vala"
						_g_object_unref0 (output);
#line 564 "rpl.vala"
						_g_object_unref0 (input);
#line 564 "rpl.vala"
						_g_free0 (filename);
#line 564 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 564 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 564 "rpl.vala"
						_g_free0 (encoding);
#line 564 "rpl.vala"
						_g_string_free0 (new_text);
#line 564 "rpl.vala"
						_g_string_free0 (old_text);
#line 564 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 564 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 564 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 564 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 564 "rpl.vala"
						return _tmp214_;
#line 4173 "rpl.c"
					}
#line 572 "rpl.vala"
					_tmp215_ = uchardet_new ();
#line 572 "rpl.vala"
					detector = _tmp215_;
#line 573 "rpl.vala"
					_tmp216_ = detector;
#line 573 "rpl.vala"
					_tmp217_ = buf;
#line 573 "rpl.vala"
					_tmp218_ = g_string_get_data (_tmp217_, &_tmp219_);
#line 573 "rpl.vala"
					_tmp218__length1 = _tmp219_;
#line 573 "rpl.vala"
					_tmp220_ = _tmp218_;
#line 573 "rpl.vala"
					_tmp220__length1 = _tmp218__length1;
#line 573 "rpl.vala"
					ok = uchardet_handle_data (_tmp216_, _tmp220_, (size_t) _tmp220__length1) == 0;
#line 574 "rpl.vala"
					_vala_assert (ok, "ok");
#line 575 "rpl.vala"
					_tmp221_ = detector;
#line 575 "rpl.vala"
					uchardet_data_end (_tmp221_);
#line 576 "rpl.vala"
					encoding_guessed = FALSE;
#line 577 "rpl.vala"
					_tmp222_ = detector;
#line 577 "rpl.vala"
					_tmp223_ = uchardet_get_charset (_tmp222_);
#line 577 "rpl.vala"
					_tmp224_ = g_utf8_strup (_tmp223_, (gssize) -1);
#line 577 "rpl.vala"
					_g_free0 (encoding);
#line 577 "rpl.vala"
					encoding = _tmp224_;
#line 578 "rpl.vala"
					_tmp225_ = encoding;
#line 578 "rpl.vala"
					if (g_strcmp0 (_tmp225_, "") != 0) {
#line 4215 "rpl.c"
						gengetopt_args_info _tmp226_;
#line 579 "rpl.vala"
						_tmp226_ = args_info;
#line 579 "rpl.vala"
						if (_tmp226_.verbose_given) {
#line 4221 "rpl.c"
							const gchar* _tmp227_;
							const gchar* _tmp228_;
							gchar* _tmp229_;
							gchar* _tmp230_;
#line 580 "rpl.vala"
							_tmp227_ = encoding;
#line 580 "rpl.vala"
							_tmp228_ = string_to_string (_tmp227_);
#line 580 "rpl.vala"
							_tmp229_ = g_strconcat ("guessed encoding '", _tmp228_, "'", NULL);
#line 580 "rpl.vala"
							_tmp230_ = _tmp229_;
#line 580 "rpl.vala"
							warn (_tmp230_);
#line 580 "rpl.vala"
							_g_free0 (_tmp230_);
#line 4238 "rpl.c"
						}
#line 582 "rpl.vala"
						encoding_guessed = TRUE;
#line 4242 "rpl.c"
					} else {
						gengetopt_args_info _tmp231_;
#line 584 "rpl.vala"
						_g_free0 (encoding);
#line 584 "rpl.vala"
						encoding = NULL;
#line 585 "rpl.vala"
						_tmp231_ = args_info;
#line 585 "rpl.vala"
						if (_tmp231_.verbose_given) {
#line 586 "rpl.vala"
							warn ("unable to guess encoding");
#line 4255 "rpl.c"
						}
					}
#line 591 "rpl.vala"
					_tmp232_ = encoding;
#line 591 "rpl.vala"
					if (_tmp232_ == NULL) {
#line 4262 "rpl.c"
						const gchar* _tmp233_ = NULL;
						gchar* _tmp234_;
						gengetopt_args_info _tmp235_;
#line 592 "rpl.vala"
						g_get_charset (&_tmp233_);
#line 592 "rpl.vala"
						_g_free0 (encoding);
#line 592 "rpl.vala"
						_tmp234_ = g_strdup (_tmp233_);
#line 592 "rpl.vala"
						encoding = _tmp234_;
#line 593 "rpl.vala"
						_tmp235_ = args_info;
#line 593 "rpl.vala"
						if (_tmp235_.verbose_given) {
#line 4278 "rpl.c"
							const gchar* _tmp236_;
							const gchar* _tmp237_;
							gchar* _tmp238_;
							gchar* _tmp239_;
#line 594 "rpl.vala"
							_tmp236_ = encoding;
#line 594 "rpl.vala"
							_tmp237_ = string_to_string (_tmp236_);
#line 594 "rpl.vala"
							_tmp238_ = g_strconcat ("could not guess encoding; using locale default '", _tmp237_, "'", NULL);
#line 594 "rpl.vala"
							_tmp239_ = _tmp238_;
#line 594 "rpl.vala"
							warn (_tmp239_);
#line 594 "rpl.vala"
							_g_free0 (_tmp239_);
#line 4295 "rpl.c"
						}
					}
#line 598 "rpl.vala"
					if (encoding_guessed) {
#line 4300 "rpl.c"
						gboolean _tmp241_ = FALSE;
						const gchar* _tmp242_;
#line 598 "rpl.vala"
						_tmp242_ = encoding;
#line 598 "rpl.vala"
						if (g_strcmp0 (_tmp242_, "ASCII") == 0) {
#line 598 "rpl.vala"
							_tmp241_ = TRUE;
#line 4309 "rpl.c"
						} else {
							const gchar* _tmp243_;
#line 598 "rpl.vala"
							_tmp243_ = encoding;
#line 598 "rpl.vala"
							_tmp241_ = g_strcmp0 (_tmp243_, "UTF-8") == 0;
#line 4316 "rpl.c"
						}
#line 598 "rpl.vala"
						_tmp240_ = _tmp241_;
#line 4320 "rpl.c"
					} else {
#line 598 "rpl.vala"
						_tmp240_ = FALSE;
#line 4324 "rpl.c"
					}
#line 598 "rpl.vala"
					if (_tmp240_) {
#line 4328 "rpl.c"
						gchar* _tmp244_;
#line 599 "rpl.vala"
						_tmp244_ = g_strdup ("UTF-8");
#line 599 "rpl.vala"
						_g_free0 (encoding);
#line 599 "rpl.vala"
						encoding = _tmp244_;
#line 4336 "rpl.c"
					}
#line 603 "rpl.vala"
					_tmp245_ = buf;
#line 603 "rpl.vala"
					_tmp246_ = g_string_get_data (_tmp245_, &_tmp247_);
#line 603 "rpl.vala"
					_tmp246__length1 = _tmp247_;
#line 603 "rpl.vala"
					_tmp248_ = _tmp246_;
#line 603 "rpl.vala"
					_tmp248__length1 = _tmp246__length1;
#line 603 "rpl.vala"
					_tmp249_ = input;
#line 603 "rpl.vala"
					_tmp250_ = _g_object_ref0 (_tmp249_);
#line 603 "rpl.vala"
					_tmp251_ = prefix_input_stream_new (_tmp248_, _tmp248__length1, _tmp250_);
#line 603 "rpl.vala"
					_g_object_unref0 (input);
#line 603 "rpl.vala"
					input = (GInputStream*) _tmp251_;
#line 561 "rpl.vala"
					_uchardet_delete0 (detector);
#line 561 "rpl.vala"
					_g_string_free0 (buf);
#line 4362 "rpl.c"
				}
#line 607 "rpl.vala"
				num_matches = (gssize) 0;
#line 608 "rpl.vala"
				_tmp252_ = encoding;
#line 608 "rpl.vala"
				if (g_strcmp0 (_tmp252_, "UTF-8") != 0) {
#line 4370 "rpl.c"
					GInputStream* _tmp264_;
					GBufferedInputStream* _tmp265_;
					GOutputStream* _tmp266_;
					GBufferedOutputStream* _tmp267_;
					{
						GCharsetConverter* iconverter = NULL;
						const gchar* _tmp253_;
						GCharsetConverter* _tmp254_;
						GInputStream* _tmp255_;
						GCharsetConverter* _tmp256_;
						GConverterInputStream* _tmp257_;
						GCharsetConverter* oconverter = NULL;
						const gchar* _tmp258_;
						GCharsetConverter* _tmp259_;
						GOutputStream* _tmp260_;
						GCharsetConverter* _tmp261_;
						GConverterOutputStream* _tmp262_;
#line 610 "rpl.vala"
						_tmp253_ = encoding;
#line 610 "rpl.vala"
						_tmp254_ = g_charset_converter_new ("UTF-8", _tmp253_, &_inner_error0_);
#line 610 "rpl.vala"
						iconverter = _tmp254_;
#line 610 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4396 "rpl.c"
							goto __catch2_g_error;
						}
#line 611 "rpl.vala"
						_tmp255_ = input;
#line 611 "rpl.vala"
						_tmp256_ = iconverter;
#line 611 "rpl.vala"
						_tmp257_ = (GConverterInputStream*) g_converter_input_stream_new (_tmp255_, (GConverter*) _tmp256_);
#line 611 "rpl.vala"
						_g_object_unref0 (input);
#line 611 "rpl.vala"
						input = (GInputStream*) _tmp257_;
#line 612 "rpl.vala"
						_tmp258_ = encoding;
#line 612 "rpl.vala"
						_tmp259_ = g_charset_converter_new (_tmp258_, "UTF-8", &_inner_error0_);
#line 612 "rpl.vala"
						oconverter = _tmp259_;
#line 612 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 612 "rpl.vala"
							_g_object_unref0 (iconverter);
#line 4419 "rpl.c"
							goto __catch2_g_error;
						}
#line 613 "rpl.vala"
						_tmp260_ = output;
#line 613 "rpl.vala"
						_tmp261_ = oconverter;
#line 613 "rpl.vala"
						_tmp262_ = (GConverterOutputStream*) g_converter_output_stream_new (_tmp260_, (GConverter*) _tmp261_);
#line 613 "rpl.vala"
						_g_object_unref0 (output);
#line 613 "rpl.vala"
						output = (GOutputStream*) _tmp262_;
#line 609 "rpl.vala"
						_g_object_unref0 (oconverter);
#line 609 "rpl.vala"
						_g_object_unref0 (iconverter);
#line 4436 "rpl.c"
					}
					goto __finally2;
					__catch2_g_error:
					{
#line 609 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 616 "rpl.vala"
						_vala_assert (FALSE, "false");
#line 4445 "rpl.c"
					}
					__finally2:
#line 609 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4450 "rpl.c"
						gint _tmp263_ = -1;
#line 609 "rpl.vala"
						_g_free0 (tmp_path);
#line 609 "rpl.vala"
						_g_object_unref0 (output);
#line 609 "rpl.vala"
						_g_object_unref0 (input);
#line 609 "rpl.vala"
						_g_free0 (filename);
#line 609 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 609 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 609 "rpl.vala"
						_g_free0 (encoding);
#line 609 "rpl.vala"
						_g_string_free0 (new_text);
#line 609 "rpl.vala"
						_g_string_free0 (old_text);
#line 609 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 609 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 609 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 609 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 609 "rpl.vala"
						return _tmp263_;
#line 4480 "rpl.c"
					}
#line 620 "rpl.vala"
					_tmp264_ = input;
#line 620 "rpl.vala"
					_tmp265_ = (GBufferedInputStream*) g_buffered_input_stream_new_sized (_tmp264_, (gsize) initial_buf_size);
#line 620 "rpl.vala"
					_g_object_unref0 (input);
#line 620 "rpl.vala"
					input = (GInputStream*) _tmp265_;
#line 621 "rpl.vala"
					_tmp266_ = output;
#line 621 "rpl.vala"
					_tmp267_ = (GBufferedOutputStream*) g_buffered_output_stream_new_sized (_tmp266_, (gsize) initial_buf_size);
#line 621 "rpl.vala"
					_g_object_unref0 (output);
#line 621 "rpl.vala"
					output = (GOutputStream*) _tmp267_;
#line 4498 "rpl.c"
				}
				{
					gssize _tmp268_ = 0L;
					GInputStream* _tmp269_;
					const gchar* _tmp270_;
					GOutputStream* _tmp271_;
					pcre2_code* _tmp272_;
					GString* _tmp273_;
#line 625 "rpl.vala"
					_tmp269_ = input;
#line 625 "rpl.vala"
					_tmp270_ = filename;
#line 625 "rpl.vala"
					_tmp271_ = output;
#line 625 "rpl.vala"
					_tmp272_ = regex;
#line 625 "rpl.vala"
					_tmp273_ = new_text;
#line 625 "rpl.vala"
					_tmp268_ = replace (_tmp269_, _tmp270_, _tmp271_, _tmp272_, replace_opts, _tmp273_, &_inner_error0_);
#line 625 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4521 "rpl.c"
						gint _tmp274_ = -1;
#line 625 "rpl.vala"
						if (_inner_error0_->domain == G_IO_ERROR) {
#line 4525 "rpl.c"
							goto __catch3_g_io_error;
						}
#line 625 "rpl.vala"
						_g_free0 (tmp_path);
#line 625 "rpl.vala"
						_g_object_unref0 (output);
#line 625 "rpl.vala"
						_g_object_unref0 (input);
#line 625 "rpl.vala"
						_g_free0 (filename);
#line 625 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 625 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 625 "rpl.vala"
						_g_free0 (encoding);
#line 625 "rpl.vala"
						_g_string_free0 (new_text);
#line 625 "rpl.vala"
						_g_string_free0 (old_text);
#line 625 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 625 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 625 "rpl.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 625 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 625 "rpl.vala"
						return _tmp274_;
#line 4556 "rpl.c"
					}
#line 625 "rpl.vala"
					num_matches = _tmp268_;
#line 4560 "rpl.c"
				}
				goto __finally3;
				__catch3_g_io_error:
				{
					GError* e = NULL;
					const gchar* _tmp275_;
					const gchar* _tmp276_;
					GError* _tmp277_;
					const gchar* _tmp278_;
					const gchar* _tmp279_;
					gchar* _tmp280_;
					gchar* _tmp281_;
					GError* _tmp282_;
#line 624 "rpl.vala"
					e = _inner_error0_;
#line 624 "rpl.vala"
					_inner_error0_ = NULL;
#line 627 "rpl.vala"
					_tmp275_ = filename;
#line 627 "rpl.vala"
					_tmp276_ = string_to_string (_tmp275_);
#line 627 "rpl.vala"
					_tmp277_ = e;
#line 627 "rpl.vala"
					_tmp278_ = _tmp277_->message;
#line 627 "rpl.vala"
					_tmp279_ = string_to_string (_tmp278_);
#line 627 "rpl.vala"
					_tmp280_ = g_strconcat ("error processing ", _tmp276_, ": ", _tmp279_, "; skipping!", NULL);
#line 627 "rpl.vala"
					_tmp281_ = _tmp280_;
#line 627 "rpl.vala"
					warn (_tmp281_);
#line 627 "rpl.vala"
					_g_free0 (_tmp281_);
#line 628 "rpl.vala"
					_tmp282_ = e;
#line 628 "rpl.vala"
					if (g_error_matches (_tmp282_, G_IO_ERROR, G_IO_ERROR_INVALID_DATA)) {
#line 629 "rpl.vala"
						warn ("you can specify the encoding with --encoding");
#line 4602 "rpl.c"
					}
					{
						GInputStream* _tmp283_;
#line 632 "rpl.vala"
						_tmp283_ = input;
#line 632 "rpl.vala"
						g_input_stream_close (_tmp283_, NULL, &_inner_error0_);
#line 632 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4612 "rpl.c"
							gint _tmp284_ = -1;
#line 632 "rpl.vala"
							if (_inner_error0_->domain == G_IO_ERROR) {
#line 4616 "rpl.c"
								goto __catch4_g_io_error;
							}
#line 632 "rpl.vala"
							_g_error_free0 (e);
#line 632 "rpl.vala"
							_g_free0 (tmp_path);
#line 632 "rpl.vala"
							_g_object_unref0 (output);
#line 632 "rpl.vala"
							_g_object_unref0 (input);
#line 632 "rpl.vala"
							_g_free0 (filename);
#line 632 "rpl.vala"
							_pcre2_code_free0 (regex);
#line 632 "rpl.vala"
							_pcre2_compile_context_free0 (ccontext);
#line 632 "rpl.vala"
							_g_free0 (encoding);
#line 632 "rpl.vala"
							_g_string_free0 (new_text);
#line 632 "rpl.vala"
							_g_string_free0 (old_text);
#line 632 "rpl.vala"
							(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 632 "rpl.vala"
							args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 632 "rpl.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 632 "rpl.vala"
							g_clear_error (&_inner_error0_);
#line 632 "rpl.vala"
							return _tmp284_;
#line 4649 "rpl.c"
						}
					}
					goto __finally4;
					__catch4_g_io_error:
					{
#line 631 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 4657 "rpl.c"
					}
					__finally4:
#line 631 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4662 "rpl.c"
						gint _tmp285_ = -1;
#line 631 "rpl.vala"
						_g_error_free0 (e);
#line 631 "rpl.vala"
						_g_free0 (tmp_path);
#line 631 "rpl.vala"
						_g_object_unref0 (output);
#line 631 "rpl.vala"
						_g_object_unref0 (input);
#line 631 "rpl.vala"
						_g_free0 (filename);
#line 631 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 631 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 631 "rpl.vala"
						_g_free0 (encoding);
#line 631 "rpl.vala"
						_g_string_free0 (new_text);
#line 631 "rpl.vala"
						_g_string_free0 (old_text);
#line 631 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 631 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 631 "rpl.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 631 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 631 "rpl.vala"
						return _tmp285_;
#line 4694 "rpl.c"
					}
#line 634 "rpl.vala"
					num_matches = (gssize) -1;
#line 624 "rpl.vala"
					_g_error_free0 (e);
#line 4700 "rpl.c"
				}
				__finally3:
#line 624 "rpl.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4705 "rpl.c"
					gint _tmp286_ = -1;
#line 624 "rpl.vala"
					_g_free0 (tmp_path);
#line 624 "rpl.vala"
					_g_object_unref0 (output);
#line 624 "rpl.vala"
					_g_object_unref0 (input);
#line 624 "rpl.vala"
					_g_free0 (filename);
#line 624 "rpl.vala"
					_pcre2_code_free0 (regex);
#line 624 "rpl.vala"
					_pcre2_compile_context_free0 (ccontext);
#line 624 "rpl.vala"
					_g_free0 (encoding);
#line 624 "rpl.vala"
					_g_string_free0 (new_text);
#line 624 "rpl.vala"
					_g_string_free0 (old_text);
#line 624 "rpl.vala"
					(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 624 "rpl.vala"
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 624 "rpl.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 624 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 624 "rpl.vala"
					return _tmp286_;
#line 4735 "rpl.c"
				}
				{
					GInputStream* _tmp287_;
#line 638 "rpl.vala"
					_tmp287_ = input;
#line 638 "rpl.vala"
					g_input_stream_close (_tmp287_, NULL, &_inner_error0_);
#line 638 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4745 "rpl.c"
						gint _tmp288_ = -1;
#line 638 "rpl.vala"
						if (_inner_error0_->domain == G_IO_ERROR) {
#line 4749 "rpl.c"
							goto __catch5_g_io_error;
						}
#line 638 "rpl.vala"
						_g_free0 (tmp_path);
#line 638 "rpl.vala"
						_g_object_unref0 (output);
#line 638 "rpl.vala"
						_g_object_unref0 (input);
#line 638 "rpl.vala"
						_g_free0 (filename);
#line 638 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 638 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 638 "rpl.vala"
						_g_free0 (encoding);
#line 638 "rpl.vala"
						_g_string_free0 (new_text);
#line 638 "rpl.vala"
						_g_string_free0 (old_text);
#line 638 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 638 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 638 "rpl.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 638 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 638 "rpl.vala"
						return _tmp288_;
#line 4780 "rpl.c"
					}
				}
				goto __finally5;
				__catch5_g_io_error:
				{
					const gchar* _tmp289_;
					const gchar* _tmp290_;
					const gchar* _tmp291_;
					const gchar* _tmp292_;
					gchar* _tmp293_;
					gchar* _tmp294_;
#line 637 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 640 "rpl.vala"
					_tmp289_ = filename;
#line 640 "rpl.vala"
					_tmp290_ = string_to_string (_tmp289_);
#line 640 "rpl.vala"
					_tmp291_ = g_strerror (errno);
#line 640 "rpl.vala"
					_tmp292_ = string_to_string (_tmp291_);
#line 640 "rpl.vala"
					_tmp293_ = g_strconcat ("error closing ", _tmp290_, ": ", _tmp292_, NULL);
#line 640 "rpl.vala"
					_tmp294_ = _tmp293_;
#line 640 "rpl.vala"
					warn (_tmp294_);
#line 640 "rpl.vala"
					_g_free0 (_tmp294_);
#line 4810 "rpl.c"
				}
				__finally5:
#line 637 "rpl.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4815 "rpl.c"
					gint _tmp295_ = -1;
#line 637 "rpl.vala"
					_g_free0 (tmp_path);
#line 637 "rpl.vala"
					_g_object_unref0 (output);
#line 637 "rpl.vala"
					_g_object_unref0 (input);
#line 637 "rpl.vala"
					_g_free0 (filename);
#line 637 "rpl.vala"
					_pcre2_code_free0 (regex);
#line 637 "rpl.vala"
					_pcre2_compile_context_free0 (ccontext);
#line 637 "rpl.vala"
					_g_free0 (encoding);
#line 637 "rpl.vala"
					_g_string_free0 (new_text);
#line 637 "rpl.vala"
					_g_string_free0 (old_text);
#line 637 "rpl.vala"
					(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 637 "rpl.vala"
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 637 "rpl.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 637 "rpl.vala"
					g_clear_error (&_inner_error0_);
#line 637 "rpl.vala"
					return _tmp295_;
#line 4845 "rpl.c"
				}
#line 642 "rpl.vala"
				_tmp296_ = output;
#line 642 "rpl.vala"
				if (_tmp296_ != NULL) {
#line 4851 "rpl.c"
					{
						GOutputStream* _tmp297_;
#line 644 "rpl.vala"
						_tmp297_ = output;
#line 644 "rpl.vala"
						g_output_stream_close (_tmp297_, NULL, &_inner_error0_);
#line 644 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4860 "rpl.c"
							gint _tmp298_ = -1;
#line 644 "rpl.vala"
							if (_inner_error0_->domain == G_IO_ERROR) {
#line 4864 "rpl.c"
								goto __catch6_g_io_error;
							}
#line 644 "rpl.vala"
							_g_free0 (tmp_path);
#line 644 "rpl.vala"
							_g_object_unref0 (output);
#line 644 "rpl.vala"
							_g_object_unref0 (input);
#line 644 "rpl.vala"
							_g_free0 (filename);
#line 644 "rpl.vala"
							_pcre2_code_free0 (regex);
#line 644 "rpl.vala"
							_pcre2_compile_context_free0 (ccontext);
#line 644 "rpl.vala"
							_g_free0 (encoding);
#line 644 "rpl.vala"
							_g_string_free0 (new_text);
#line 644 "rpl.vala"
							_g_string_free0 (old_text);
#line 644 "rpl.vala"
							(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 644 "rpl.vala"
							args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 644 "rpl.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 644 "rpl.vala"
							g_clear_error (&_inner_error0_);
#line 644 "rpl.vala"
							return _tmp298_;
#line 4895 "rpl.c"
						}
					}
					goto __finally6;
					__catch6_g_io_error:
					{
						const gchar* _tmp299_;
						const gchar* _tmp300_;
						gchar* _tmp301_;
						gchar* _tmp302_;
#line 643 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 646 "rpl.vala"
						_tmp299_ = g_strerror (errno);
#line 646 "rpl.vala"
						_tmp300_ = string_to_string (_tmp299_);
#line 646 "rpl.vala"
						_tmp301_ = g_strconcat ("error closing output: ", _tmp300_, NULL);
#line 646 "rpl.vala"
						_tmp302_ = _tmp301_;
#line 646 "rpl.vala"
						warn (_tmp302_);
#line 646 "rpl.vala"
						_g_free0 (_tmp302_);
#line 4919 "rpl.c"
					}
					__finally6:
#line 643 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4924 "rpl.c"
						gint _tmp303_ = -1;
#line 643 "rpl.vala"
						_g_free0 (tmp_path);
#line 643 "rpl.vala"
						_g_object_unref0 (output);
#line 643 "rpl.vala"
						_g_object_unref0 (input);
#line 643 "rpl.vala"
						_g_free0 (filename);
#line 643 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 643 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 643 "rpl.vala"
						_g_free0 (encoding);
#line 643 "rpl.vala"
						_g_string_free0 (new_text);
#line 643 "rpl.vala"
						_g_string_free0 (old_text);
#line 643 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 643 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 643 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 643 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 643 "rpl.vala"
						return _tmp303_;
#line 4954 "rpl.c"
					}
				}
#line 652 "rpl.vala"
				if (num_matches <= ((gssize) 0)) {
#line 4959 "rpl.c"
					const gchar* _tmp304_;
#line 653 "rpl.vala"
					_tmp304_ = tmp_path;
#line 653 "rpl.vala"
					if (_tmp304_ != NULL) {
#line 4965 "rpl.c"
						const gchar* _tmp305_;
#line 654 "rpl.vala"
						_tmp305_ = tmp_path;
#line 654 "rpl.vala"
						remove_temp_file (_tmp305_);
#line 4971 "rpl.c"
					}
#line 656 "rpl.vala"
					_g_free0 (tmp_path);
#line 656 "rpl.vala"
					_g_object_unref0 (output);
#line 656 "rpl.vala"
					_g_object_unref0 (input);
#line 656 "rpl.vala"
					_g_free0 (filename);
#line 656 "rpl.vala"
					continue;
#line 4983 "rpl.c"
				}
#line 658 "rpl.vala"
				matched_files += (gsize) 1;
#line 660 "rpl.vala"
				_tmp306_ = args_info;
#line 660 "rpl.vala"
				if (_tmp306_.prompt_given) {
#line 4991 "rpl.c"
					FILE* _tmp307_;
					const gchar* _tmp308_;
					const gchar* _tmp309_;
					gchar* _tmp310_;
					gchar* _tmp311_;
					gchar* line = NULL;
					gboolean _tmp320_ = FALSE;
					const gchar* _tmp321_;
#line 661 "rpl.vala"
					_tmp307_ = stderr;
#line 661 "rpl.vala"
					_tmp308_ = filename;
#line 661 "rpl.vala"
					_tmp309_ = string_to_string (_tmp308_);
#line 661 "rpl.vala"
					_tmp310_ = g_strconcat ("\nUpdate \"", _tmp309_, "\"? [Y/n] ", NULL);
#line 661 "rpl.vala"
					_tmp311_ = _tmp310_;
#line 661 "rpl.vala"
					fprintf (_tmp307_, "%s", _tmp311_);
#line 661 "rpl.vala"
					_g_free0 (_tmp311_);
#line 663 "rpl.vala"
					line = NULL;
#line 5016 "rpl.c"
					{
						gboolean _tmp312_ = FALSE;
#line 664 "rpl.vala"
						_tmp312_ = TRUE;
#line 664 "rpl.vala"
						while (TRUE) {
#line 5023 "rpl.c"
							FILE* _tmp318_;
							gchar* _tmp319_;
#line 664 "rpl.vala"
							if (!_tmp312_) {
#line 5028 "rpl.c"
								gboolean _tmp313_ = FALSE;
								const gchar* _tmp314_;
#line 666 "rpl.vala"
								_tmp314_ = line;
#line 666 "rpl.vala"
								if (g_strcmp0 (_tmp314_, "") != 0) {
#line 5035 "rpl.c"
									const gchar* _tmp315_;
									gchar* _tmp316_;
									gchar* _tmp317_;
#line 666 "rpl.vala"
									_tmp315_ = line;
#line 666 "rpl.vala"
									_tmp316_ = g_strdup_printf ("%c", string_get (_tmp315_, (glong) 0));
#line 666 "rpl.vala"
									_tmp317_ = _tmp316_;
#line 666 "rpl.vala"
									_tmp313_ = !string_contains ("YyNn", _tmp317_);
#line 666 "rpl.vala"
									_g_free0 (_tmp317_);
#line 5049 "rpl.c"
								} else {
#line 666 "rpl.vala"
									_tmp313_ = FALSE;
#line 5053 "rpl.c"
								}
#line 666 "rpl.vala"
								if (!_tmp313_) {
#line 666 "rpl.vala"
									break;
#line 5059 "rpl.c"
								}
							}
#line 664 "rpl.vala"
							_tmp312_ = FALSE;
#line 665 "rpl.vala"
							_tmp318_ = stdin;
#line 665 "rpl.vala"
							_tmp319_ = g_file_stream_read_line (_tmp318_);
#line 665 "rpl.vala"
							_g_free0 (line);
#line 665 "rpl.vala"
							line = _tmp319_;
#line 5072 "rpl.c"
						}
					}
#line 668 "rpl.vala"
					_tmp321_ = line;
#line 668 "rpl.vala"
					if (g_strcmp0 (_tmp321_, "") != 0) {
#line 5079 "rpl.c"
						const gchar* _tmp322_;
						gchar* _tmp323_;
						gchar* _tmp324_;
#line 668 "rpl.vala"
						_tmp322_ = line;
#line 668 "rpl.vala"
						_tmp323_ = g_strdup_printf ("%c", string_get (_tmp322_, (glong) 0));
#line 668 "rpl.vala"
						_tmp324_ = _tmp323_;
#line 668 "rpl.vala"
						_tmp320_ = string_contains ("Nn", _tmp324_);
#line 668 "rpl.vala"
						_g_free0 (_tmp324_);
#line 5093 "rpl.c"
					} else {
#line 668 "rpl.vala"
						_tmp320_ = FALSE;
#line 5097 "rpl.c"
					}
#line 668 "rpl.vala"
					if (_tmp320_) {
#line 5101 "rpl.c"
						const gchar* _tmp325_;
#line 669 "rpl.vala"
						info ("Not updated");
#line 670 "rpl.vala"
						_tmp325_ = tmp_path;
#line 670 "rpl.vala"
						if (_tmp325_ != NULL) {
#line 5109 "rpl.c"
							const gchar* _tmp326_;
#line 671 "rpl.vala"
							_tmp326_ = tmp_path;
#line 671 "rpl.vala"
							remove_temp_file (_tmp326_);
#line 5115 "rpl.c"
						}
#line 673 "rpl.vala"
						_g_free0 (line);
#line 673 "rpl.vala"
						_g_free0 (tmp_path);
#line 673 "rpl.vala"
						_g_object_unref0 (output);
#line 673 "rpl.vala"
						_g_object_unref0 (input);
#line 673 "rpl.vala"
						_g_free0 (filename);
#line 673 "rpl.vala"
						continue;
#line 5129 "rpl.c"
					}
#line 676 "rpl.vala"
					info ("Updated");
#line 660 "rpl.vala"
					_g_free0 (line);
#line 5135 "rpl.c"
				}
#line 679 "rpl.vala"
				_tmp327_ = tmp_path;
#line 679 "rpl.vala"
				if (_tmp327_ != NULL) {
#line 5141 "rpl.c"
					gengetopt_args_info _tmp328_;
					gboolean _tmp359_ = FALSE;
					gengetopt_args_info _tmp360_;
#line 680 "rpl.vala"
					_tmp328_ = args_info;
#line 680 "rpl.vala"
					if (_tmp328_.backup_given) {
#line 5149 "rpl.c"
						gchar* backup_name = NULL;
						const gchar* _tmp329_;
						const gchar* _tmp330_;
						gchar* _tmp331_;
						gint rc = 0;
						const gchar* _tmp332_;
						const gchar* _tmp333_;
#line 681 "rpl.vala"
						_tmp329_ = filename;
#line 681 "rpl.vala"
						_tmp330_ = string_to_string (_tmp329_);
#line 681 "rpl.vala"
						_tmp331_ = g_strconcat (_tmp330_, "~", NULL);
#line 681 "rpl.vala"
						backup_name = _tmp331_;
#line 682 "rpl.vala"
						_tmp332_ = filename;
#line 682 "rpl.vala"
						_tmp333_ = backup_name;
#line 682 "rpl.vala"
						rc = g_rename (_tmp332_, _tmp333_);
#line 683 "rpl.vala"
						if (rc < 0) {
#line 5173 "rpl.c"
							const gchar* _tmp334_;
							const gchar* _tmp335_;
							const gchar* _tmp336_;
							const gchar* _tmp337_;
							const gchar* _tmp338_;
							const gchar* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							const gchar* _tmp342_;
#line 684 "rpl.vala"
							_tmp334_ = filename;
#line 684 "rpl.vala"
							_tmp335_ = string_to_string (_tmp334_);
#line 684 "rpl.vala"
							_tmp336_ = backup_name;
#line 684 "rpl.vala"
							_tmp337_ = string_to_string (_tmp336_);
#line 684 "rpl.vala"
							_tmp338_ = g_strerror (errno);
#line 684 "rpl.vala"
							_tmp339_ = string_to_string (_tmp338_);
#line 684 "rpl.vala"
							_tmp340_ = g_strconcat ("error renaming ", _tmp335_, " to ", _tmp337_, ": ", _tmp339_, NULL);
#line 684 "rpl.vala"
							_tmp341_ = _tmp340_;
#line 684 "rpl.vala"
							warn (_tmp341_);
#line 684 "rpl.vala"
							_g_free0 (_tmp341_);
#line 685 "rpl.vala"
							_tmp342_ = tmp_path;
#line 685 "rpl.vala"
							remove_temp_file (_tmp342_);
#line 686 "rpl.vala"
							_g_free0 (backup_name);
#line 686 "rpl.vala"
							_g_free0 (tmp_path);
#line 686 "rpl.vala"
							_g_object_unref0 (output);
#line 686 "rpl.vala"
							_g_object_unref0 (input);
#line 686 "rpl.vala"
							_g_free0 (filename);
#line 686 "rpl.vala"
							continue;
#line 5219 "rpl.c"
						}
#line 680 "rpl.vala"
						_g_free0 (backup_name);
#line 5223 "rpl.c"
					}
					{
						GFile* src = NULL;
						const gchar* _tmp343_;
						GFile* _tmp344_;
						GFile* dst = NULL;
						const gchar* _tmp345_;
						GFile* _tmp346_;
						GFile* _tmp347_;
						GFile* _tmp348_;
#line 692 "rpl.vala"
						_tmp343_ = tmp_path;
#line 692 "rpl.vala"
						_tmp344_ = g_file_new_for_path (_tmp343_);
#line 692 "rpl.vala"
						src = _tmp344_;
#line 693 "rpl.vala"
						_tmp345_ = filename;
#line 693 "rpl.vala"
						_tmp346_ = g_file_new_for_path (_tmp345_);
#line 693 "rpl.vala"
						dst = _tmp346_;
#line 694 "rpl.vala"
						_tmp347_ = src;
#line 694 "rpl.vala"
						_tmp348_ = dst;
#line 694 "rpl.vala"
						g_file_move (_tmp347_, _tmp348_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
#line 694 "rpl.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 694 "rpl.vala"
							_g_object_unref0 (dst);
#line 694 "rpl.vala"
							_g_object_unref0 (src);
#line 5258 "rpl.c"
							goto __catch7_g_error;
						}
#line 691 "rpl.vala"
						_g_object_unref0 (dst);
#line 691 "rpl.vala"
						_g_object_unref0 (src);
#line 5265 "rpl.c"
					}
					goto __finally7;
					__catch7_g_error:
					{
						const gchar* _tmp349_;
						const gchar* _tmp350_;
						const gchar* _tmp351_;
						const gchar* _tmp352_;
						const gchar* _tmp353_;
						const gchar* _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						const gchar* _tmp357_;
#line 691 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 696 "rpl.vala"
						_tmp349_ = tmp_path;
#line 696 "rpl.vala"
						_tmp350_ = string_to_string (_tmp349_);
#line 696 "rpl.vala"
						_tmp351_ = filename;
#line 696 "rpl.vala"
						_tmp352_ = string_to_string (_tmp351_);
#line 696 "rpl.vala"
						_tmp353_ = g_strerror (errno);
#line 696 "rpl.vala"
						_tmp354_ = string_to_string (_tmp353_);
#line 696 "rpl.vala"
						_tmp355_ = g_strconcat ("error renaming ", _tmp350_, " to ", _tmp352_, ": ", _tmp354_, NULL);
#line 696 "rpl.vala"
						_tmp356_ = _tmp355_;
#line 696 "rpl.vala"
						warn (_tmp356_);
#line 696 "rpl.vala"
						_g_free0 (_tmp356_);
#line 697 "rpl.vala"
						_tmp357_ = tmp_path;
#line 697 "rpl.vala"
						remove_temp_file (_tmp357_);
#line 698 "rpl.vala"
						_g_free0 (tmp_path);
#line 698 "rpl.vala"
						_g_object_unref0 (output);
#line 698 "rpl.vala"
						_g_object_unref0 (input);
#line 698 "rpl.vala"
						_g_free0 (filename);
#line 698 "rpl.vala"
						continue;
#line 5315 "rpl.c"
					}
					__finally7:
#line 691 "rpl.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 5320 "rpl.c"
						gint _tmp358_ = -1;
#line 691 "rpl.vala"
						_g_free0 (tmp_path);
#line 691 "rpl.vala"
						_g_object_unref0 (output);
#line 691 "rpl.vala"
						_g_object_unref0 (input);
#line 691 "rpl.vala"
						_g_free0 (filename);
#line 691 "rpl.vala"
						_pcre2_code_free0 (regex);
#line 691 "rpl.vala"
						_pcre2_compile_context_free0 (ccontext);
#line 691 "rpl.vala"
						_g_free0 (encoding);
#line 691 "rpl.vala"
						_g_string_free0 (new_text);
#line 691 "rpl.vala"
						_g_string_free0 (old_text);
#line 691 "rpl.vala"
						(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 691 "rpl.vala"
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 691 "rpl.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 691 "rpl.vala"
						g_clear_error (&_inner_error0_);
#line 691 "rpl.vala"
						return _tmp358_;
#line 5350 "rpl.c"
					}
#line 702 "rpl.vala"
					_tmp360_ = args_info;
#line 702 "rpl.vala"
					if (_tmp360_.keep_times_given) {
#line 702 "rpl.vala"
						_tmp359_ = have_perms;
#line 5358 "rpl.c"
					} else {
#line 702 "rpl.vala"
						_tmp359_ = FALSE;
#line 5362 "rpl.c"
					}
#line 702 "rpl.vala"
					if (_tmp359_) {
#line 5366 "rpl.c"
						struct timespec times[2] = {0};
						struct stat _tmp361_;
						struct stat _tmp362_;
						struct timespec _tmp363_[2] = {0};
						gint rc2 = 0;
						const gchar* _tmp364_;
#line 703 "rpl.vala"
						_tmp361_ = perms;
#line 703 "rpl.vala"
						_tmp362_ = perms;
#line 703 "rpl.vala"
						_tmp363_[0] = (struct timespec) get_stat_atime (&_tmp361_);
#line 703 "rpl.vala"
						_tmp363_[1] = (struct timespec) get_stat_mtime (&_tmp362_);
#line 703 "rpl.vala"
						memcpy (times, _tmp363_, 2 * sizeof (struct timespec));
#line 704 "rpl.vala"
						_tmp364_ = filename;
#line 704 "rpl.vala"
						rc2 = utimensat (AT_FDCWD, _tmp364_, times, 0);
#line 705 "rpl.vala"
						if (rc2 < 0) {
#line 5389 "rpl.c"
							const gchar* _tmp365_;
							const gchar* _tmp366_;
							const gchar* _tmp367_;
							const gchar* _tmp368_;
							gchar* _tmp369_;
							gchar* _tmp370_;
#line 706 "rpl.vala"
							_tmp365_ = filename;
#line 706 "rpl.vala"
							_tmp366_ = string_to_string (_tmp365_);
#line 706 "rpl.vala"
							_tmp367_ = g_strerror (errno);
#line 706 "rpl.vala"
							_tmp368_ = string_to_string (_tmp367_);
#line 706 "rpl.vala"
							_tmp369_ = g_strconcat ("error setting timestamps of ", _tmp366_, ": ", _tmp368_, NULL);
#line 706 "rpl.vala"
							_tmp370_ = _tmp369_;
#line 706 "rpl.vala"
							warn (_tmp370_);
#line 706 "rpl.vala"
							_g_free0 (_tmp370_);
#line 5412 "rpl.c"
						}
					}
				}
#line 711 "rpl.vala"
				total_matches += (gsize) num_matches;
#line 486 "rpl.vala"
				_g_free0 (tmp_path);
#line 486 "rpl.vala"
				_g_object_unref0 (output);
#line 486 "rpl.vala"
				_g_object_unref0 (input);
#line 486 "rpl.vala"
				_g_free0 (filename);
#line 5426 "rpl.c"
			}
		}
	}
#line 715 "rpl.vala"
	_tmp371_ = args_info;
#line 715 "rpl.vala"
	if (!_tmp371_.quiet_given) {
#line 5434 "rpl.c"
		const gchar* _tmp372_ = NULL;
		gengetopt_args_info _tmp373_;
		const gchar* _tmp374_ = NULL;
		gchar* _tmp375_;
		gchar* _tmp376_;
#line 718 "rpl.vala"
		_tmp373_ = args_info;
#line 718 "rpl.vala"
		if (_tmp373_.dry_run_given) {
#line 718 "rpl.vala"
			_tmp372_ = "found";
#line 5446 "rpl.c"
		} else {
#line 718 "rpl.vala"
			_tmp372_ = "replaced";
#line 5450 "rpl.c"
		}
#line 721 "rpl.vala"
		if (total_files != ((gsize) 1)) {
#line 721 "rpl.vala"
			_tmp374_ = "s";
#line 5456 "rpl.c"
		} else {
#line 721 "rpl.vala"
			_tmp374_ = "";
#line 5460 "rpl.c"
		}
#line 716 "rpl.vala"
		_tmp375_ = g_strdup_printf ("%zu matches %s in %zu out of %zu file%s", total_matches, _tmp372_, matched_files, total_files, _tmp374_);
#line 716 "rpl.vala"
		_tmp376_ = _tmp375_;
#line 716 "rpl.vala"
		warn (_tmp376_);
#line 716 "rpl.vala"
		_g_free0 (_tmp376_);
#line 5470 "rpl.c"
	}
#line 725 "rpl.vala"
	result = EXIT_SUCCESS;
#line 725 "rpl.vala"
	_pcre2_code_free0 (regex);
#line 725 "rpl.vala"
	_pcre2_compile_context_free0 (ccontext);
#line 725 "rpl.vala"
	_g_free0 (encoding);
#line 725 "rpl.vala"
	_g_string_free0 (new_text);
#line 725 "rpl.vala"
	_g_string_free0 (old_text);
#line 725 "rpl.vala"
	(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
#line 725 "rpl.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 725 "rpl.vala"
	return result;
#line 5490 "rpl.c"
}

int
main (int argc,
      char ** argv)
{
#line 360 "rpl.vala"
	return _vala_main (argv, argc);
#line 5499 "rpl.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

