# 0.7.1 (2024-08-13)

### Added
- Add `set_id` function to packet

# 0.7.0 (2024-03-25)

### Fix (Breaking)
- Handle empty rdata parsing (when the lenght is 0)

# 0.6.2 (2024-02-27)

### Added 
-  Add NAPTR record type parsing (RFC 3403)

# 0.6.1 (2024-02-11)

### Fix
- Fixes invalid name lengths when generating uncompressed bytes from a packet that was parsed from compressed data.

# 0.6.0 (2024-01-06)

### Fix
- Fixes invalid rdata length when generating compressed packets.

### Changed (Breaking)
- Anotate TYPE with non_exhaustive
- QCLASS::match_qtype no longer matcher A and AAAA together

### Added (Breaking)
- Add SVBC record type parsing (RFC 9460)

# 0.5.7 (2023-10-17)

### Fix
- TryFrom<'str> for TXT generating invalid CharacterStrings
- `Name::is_subdomain_of` no longer return true for the same domain

### Added
- `Name::without` to extract subdomains from a domain

# 0.5.6 (2023-10-04)

### Fix
- Name compression now considers the full domain when creating pointers.

### Added
- Add TryFrom<'str> and TryInto<'str> for TXT records as a convenience to work with long TXT records

# 0.5.5 (2023-09-14)

### Fix
- Add derived traits to PacketFlag that where removed by the previous version

# 0.5.4 (2023-09-07)

### Added
- Support to parse CAA records

# 0.5.3 (2023-07-09)

### Added
- `write_to` and `write_compressed_to` functions to `Packet`

# 0.5.2 (2023-03-17)
- Add DeRef and DerefMut implemetations for the ResourceRecord wrapper macro

# 0.5.1 (2023-01-17)

### Fixed
- Prevent panic! when trying to parse an empty slice

# 0.5.0 (2022-12-10)

### Fixed
- Fixes parsing for Name, CharacterString and SOA types 

### Changed (Breaking)
- Header flags now use crate [bitflags](https://crates.io/crates/bitflags)
- Removed PacketBuf struct, due to how EDNS0 packets are constructed.  
It is necessary to parse the whole packet to be able to construct the header information, which renders the PacketBuf *on the fly* approach unreliable

### Added
- Add OPT record type from RFC 6891 (EDNS0 support)
- header_buffer module for packet header manipulation
- tests using sample files from bind9


# 0.4.7

- Remove `thiserror` dependency
- Add RFC 2136
- Add RFC 1183
- Add RFC 1706
- Add RFC 1876
- Add NOTIFY code (RFC 1995 and 1996)
- Add new error type `InsufficientData` for stream parsing

# 0.4.6
- Add cache flush bit parsing to resource records

# 0.4.5
- Fix TXT records length

# 0.4.4
-Fix PTR parsing with compression

# 0.4.3
- Improve error handling

# 0.4.2
- Fix Name compression when using multiple pointers

# 0.4.1
- Fix a panic when parsing TXT records of length 0

# 0.4.0
- Change internal data references to use Cow
- Add **into_owned** function to every resource
- Add **is_subdomain_of** for Name comparison
- Change RData::SRV to not use a Box anymore 

# 0.3.0
- Fix TXT Resource Record implementation
- Drop byteorder crate dependency

# 0.2.1
- Fix Name hash function
- Fix SRV compression

# 0.2.0

- Add Name compression
- Change DnsPacketContent visibility to pub(crate)
- Rename PacketSectionIter to QuestionsIter 

# 0.1.0

Initial project release
