/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.internal.provider.AbstractResourceBundleProvider;
import org.openhab.core.automation.module.provider.i18n.ModuleTypeI18nService;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true, service={ModuleTypeProvider.class, Provider.class}, property={"provider.type=bundle"})
public class ModuleTypeResourceBundleProvider
extends AbstractResourceBundleProvider<ModuleType>
implements ModuleTypeProvider {
    private final ModuleTypeI18nService moduleTypeI18nService;

    @Activate
    public ModuleTypeResourceBundleProvider(@Reference ModuleTypeI18nService moduleTypeI18nService) {
        super("OH-INF/automation/moduletypes/");
        this.moduleTypeI18nService = moduleTypeI18nService;
    }

    @Override
    @Activate
    protected void activate(@Nullable BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.module.type)")
    protected void addParser(Parser<ModuleType> parser, Map<String, String> properties) {
        super.addParser(parser, properties);
    }

    @Override
    protected void removeParser(Parser<ModuleType> parser, Map<String, String> properties) {
        super.removeParser(parser, properties);
    }

    public Collection<ModuleType> getAll() {
        return this.providedObjectsHolder.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public <T extends ModuleType> T getModuleType(String uid, @Nullable Locale locale) {
        return (T)this.getPerLocale((ModuleType)this.providedObjectsHolder.get(uid), locale);
    }

    public Collection<ModuleType> getModuleTypes(@Nullable Locale locale) {
        ArrayList<ModuleType> moduleTypesList = new ArrayList<ModuleType>();
        for (ModuleType mt : this.providedObjectsHolder.values()) {
            ModuleType mtPerLocale = this.getPerLocale(mt, locale);
            if (mtPerLocale == null) continue;
            moduleTypesList.add(mtPerLocale);
        }
        return moduleTypesList;
    }

    @Override
    protected String getUID(ModuleType parsedObject) {
        return parsedObject.getUID();
    }

    private @Nullable ModuleType getPerLocale(@Nullable ModuleType defModuleType, @Nullable Locale locale) {
        if (defModuleType == null) {
            return null;
        }
        String uid = defModuleType.getUID();
        Bundle bundle = this.getBundle(uid);
        return bundle != null ? this.moduleTypeI18nService.getModuleTypePerLocale(defModuleType, locale, bundle) : null;
    }
}

