# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from typing import Any, Literal

from ._types import Array

class SystemJacobian:
    _type: str
    linear_solver_type: Literal["GMRES", "direct"]

    def __init__(self, *args: Any, init: bool = True, **kwargs: Any) -> None: ...
    @property
    def side(self) -> Literal["none", "left", "right", "both"]: ...
    @side.setter
    def side(self, side: Literal["none", "left", "right", "both"]) -> None: ...

class EigenSparseJacobian(SystemJacobian):
    def print_contents(self) -> None: ...
    @property
    def matrix(self) -> Array: ...
    @property
    def jacobian(self) -> Array: ...

class EigenSparseDirectJacobian(EigenSparseJacobian): ...

class AdaptivePreconditioner(EigenSparseJacobian):
    @property
    def threshold(self) -> float: ...
    @threshold.setter
    def threshold(self, val: float) -> None: ...
    @property
    def ilut_fill_factor(self) -> float: ...
    @ilut_fill_factor.setter
    def ilut_fill_factor(self, val: float) -> None: ...
    @property
    def ilut_drop_tol(self) -> float: ...
    @ilut_drop_tol.setter
    def ilut_drop_tol(self, val: float) -> None: ...

class BandedJacobian(SystemJacobian): ...
