## RabbitMQ 4.1.3

RabbitMQ `4.1.3` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).


### Core Server

#### Bug Fixes

 * Fixes a rare file descriptor leak by quorum queues.

   GitHub issue: [rabbitmq/ra#553](https://github.com/rabbitmq/ra/pull/553)

 * Fixed two exceptions around [IEEE 754-2008](https://en.wikipedia.org/wiki/IEEE_754-2008_revision) serialization in the AMQP 1.0 implementation.

   GitHub issue: [#14213](https://github.com/rabbitmq/rabbitmq-server/pull/14213)

 * Queues originally defined before `3.8.0` could run into an exception
   when emitting metrics.

   GitHub issue: [#14214](https://github.com/rabbitmq/rabbitmq-server/pull/14214)

 * Avoids a potential classic queue exception logged when the queue was deleted.

   GitHub issue: [#14276](https://github.com/rabbitmq/rabbitmq-server/pull/14276)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics status` produced a stray line of debug output.

   GitHub issue: [#14266](https://github.com/rabbitmq/rabbitmq-server/pull/14266)

#### Enhancements

 * `rabbitmqctl list_deprecated_features` now lists feature state (`permitted`, `denied`) in the target cluster.

   GitHub issue: [#14229](https://github.com/rabbitmq/rabbitmq-server/pull/14229)

* Optimizes `rabbitmqctl list_queues` invocations that only request queue names.

  GitHub issue: [#14281](https://github.com/rabbitmq/rabbitmq-server/pull/14281)


### Dependency Changes

 * `ra` was upgraded to [`2.16.12`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.1.3.tar.xz`
instead of the source tarball produced by GitHub.
