/*
 *	Ported to Linux's Second Extended File System as part of the
 *	dump and restore backup suit
 *	Remy Card <card@Linux.EU.Org>, 1994-1997
 *	Stelian Pop <stelian@popies.net>, 1999-2000
 *	Stelian Pop <stelian@popies.net> - Alcôve <www.alcove.com>, 2000-2002
 */

/*
 * Copyright (c) 1980, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "config.h" // IWYU pragma: keep
#include <stdint.h>
#include "../include/protocols/dumprestore.h"

union u_spcl u_spcl;
union u_data u_data;

long long u_spcl_c_tapea(void) {
	return spcl.c_tapea_lo | (((uint64_t)spcl.c_tapea_hi) << 32);
}

void u_spcl_c_tapea_set(uint64_t v) {
	spcl.c_tapea_lo = v & 0xffffffffull;
	spcl.c_tapea_hi = v >> 32;
}

void u_spcl_c_tapea_add(uint64_t inc) {
	u_spcl_c_tapea_set(u_spcl_c_tapea() + inc);
}

long long u_spcl_c_firstrec(const struct s_spcl *buf) {
	return buf->c_firstrec_lo | (((uint64_t)buf->c_firstrec_hi) << 32);
}

void u_spcl_c_firstrec_set(uint64_t v) {
	spcl.c_firstrec_lo = v & 0xffffffffull;
	spcl.c_firstrec_hi = v >> 32;
}

int tapebuf_getcompressed(const struct tapebuf* tb)
{
	return *(const uint32_t*)tb & 1;
}
int tapebuf_getflags(const struct tapebuf* tb)
{
	return (*(const uint32_t*)tb&0xe) >> 1;
}
int tapebuf_getlength(const struct tapebuf* tb)
{
	return *(const uint32_t*)tb >> 4;
}

void tapebuf_setcompressed(struct tapebuf* tb, uint32_t v)
{
	*(uint32_t*)tb &= ~1;
	*(uint32_t*)tb |= (v&1);
}
void tapebuf_setflags(struct tapebuf* tb, uint32_t v)
{
	*(uint32_t*)tb &= ~0xe;
	*(uint32_t*)tb |= (v&0x07) << 1;
}
void tapebuf_setlength(struct tapebuf* tb, uint32_t v)
{
	*(uint32_t*)tb &= 0xf;
	*(uint32_t*)tb |= (v&((1<<28)-1)) << 4;
}

uint32_t get_s_addr_length(const uint8_t* ptr) {
	/*
	 * 1 - 64 encoded as 0-63 in n V[0] = (0nnnnnnf) (f is the data/sparse flag)
	 * if ( V[0] < 128 ) return (*V >> 1) + 1 )
	 * 65 - 16384 encoded as 0-16319 in Nn V[0] = (1nnnnnnf) V[1] = (NNNNNNNN)
	 * if (V[0] >= 128) return V[1]*64 + ((V[0]>>1)&63) + 65;
	 * 128 values left unused for future special cases (V[1] = 255) 1nnnnnnn 11111111
	 * if get_s_addr_length() >=65 then length is encoded in two bytes else in one.
	 */
	if (*ptr < 128)
		return (*ptr>>1)+1;
	return *(ptr+1)*64 + ((*ptr>>1)&63) + 65;
}
