---
ms.assetid: abf69b09-6528-42e0-b164-813c7c2c78e7
title: Schema updates in Windows Server
description: Schema changes made by Adprep.exe listed by operating system version.
author: xelu86
ms.author: alalve
ms.date: 02/06/2025
ms.topic: concept-article
---

# Windows Server Active Directory schema updates

This article lists the LDF (Log Database File) files that include the changes that Adprep.exe makes.

## Schema Updates in Windows Server 2025

Sch89.ldf through Sch91.ldf are introduced with Windows Server 2025.

### Sch91.ldf

```
dn: CN=Send-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=Receive-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=Public-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=Validated-SPN,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=Allowed-To-Authenticate,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=MS-TS-GatewayAccess,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 0feb936f-47b3-49f2-9386-1dedc2c23765
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 91
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch90.ldf

```
dn: CN=ms-DS-JetGetRecordSize3,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
attributeID: 1.2.840.113556.1.4.2377
attributeSyntax: 2.5.5.12
adminDisplayName: ms-DS-JetGetRecordSize3
adminDescription: This attribute dumps the result of JetGetRecordSize3 API.
oMSyntax: 64
lDAPDisplayName: msDS-JetGetRecordSize3
isSingleValued: TRUE
schemaIDGUID:: L4mhWZ5xo0eVpYYz3Ti6eA==
searchFlags: 0
showInAdvancedViewOnly: FALSE
systemFlags: 20
systemOnly: FALSE

dn: CN=ms-DS-JetDB-Page-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-JetDBPageSize
adminDisplayName: ms-DS-JetDB-Page-Size
adminDescription: Attribute used to indicate what page size the DSA supports.
attributeId: 1.2.840.113556.1.4.2378
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: YDqC2vBBiUyUKytwpsAD1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2377
-

dn: CN=NTDS-DSA,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2378
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Validated-MS-DS-JetDB-Page-Size,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
rightsGuid: da823a60-41f0-4c89-942b-2b70a6c003d4
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Validated write to MS DS Jet Database Page Size
localizationDisplayId: 84
validAccesses: 8
showInAdvancedViewOnly: TRUE

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

#
# Optional Feature Object
#
dn: CN=Database 32k Pages Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: msDS-OptionalFeature
msDS-OptionalFeatureGUID:: xiqYUnMeT3WuJHOuJ3WquA==
msDS-RequiredForestBehaviorVersion: 10
msDS-OptionalFeatureFlags: 1
systemFlags: -1946157056

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 90
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch89.ldf

```
dn: CN=ms-DS-Superseded-Service-Account-State,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-SupersededServiceAccountState
adminDisplayName: ms-DS-Superseded-Service-Account-State
adminDescription: This attribute is used to track whether a service account has been superseded by a Delegated Managed Service Account.
attributeID: 1.2.840.113556.1.4.2371
attributeSyntax: 2.5.5.9
oMSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: ljBppMOkzU64y3PNY5i3og==
systemFlags: 16

dn: CN=ms-DS-Delegated-MSA-State,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-DelegatedMSAState
adminDisplayName: ms-DS-Delegated-MSA-State
adminDescription: This attribute is used to track whether a DelegatedManagedServiceAccount has been Linked to a Service Account.
attributeID: 1.2.840.113556.1.4.2372
attributeSyntax: 2.5.5.9
oMSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: ihNcLzi9FkCItA7IfLtJGQ==
systemFlags: 16

dn: CN=ms-DS-Superseded-Managed-Account-Link,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-SupersededManagedAccountLink
adminDisplayName: ms-DS-Superseded-Managed-Account-Link
adminDescription: This attribute is the forward link from a service account to a delegated managed service account object.
attributeId: 1.2.840.113556.1.4.2373
attributeSyntax: 2.5.5.1
oMObjectClass:: KwwCh3McAIVK
oMSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: AuBSN75DyEizyiyy//vIoQ==
systemFlags: 16
InstanceType: 4
linkID: 2222

dn: CN=ms-DS-Superseded-Managed-Account-LinkBL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-SupersededManagedAccountLinkBL
adminDisplayName: ms-DS-Superseded-Managed-Account-LinkBL
adminDescription: This attribute is the back link from a service account to a delegated managed service account object.
attributeId: 1.2.840.113556.1.4.2374
attributeSyntax: 2.5.5.1
oMObjectClass:: KwwCh3McAIVK
oMSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: CnMF+v2eukukphyeVO9X1Q==
systemFlags: 16
InstanceType: 4
linkID: 2223

dn: CN=ms-DS-Managed-Account-Preceded-By-Link,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-ManagedAccountPrecededByLink
adminDisplayName: ms-DS-Managed-Account-Preceded-By-Link
adminDescription: This attribute is the forward link from a delegated managed service account to a service account object.
attributeId: 1.2.840.113556.1.4.2375
attributeSyntax: 2.5.5.1
oMObjectClass:: KwwCh3McAIVK
oMSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: K1uUoKJXvUOzJ00RKk6L0Q==
systemFlags: 16
InstanceType: 4
linkID: 2224

dn: CN=ms-DS-Managed-Account-Preceded-By-LinkBL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-ManagedAccountPrecededByLinkBL
adminDisplayName: ms-DS-Managed-Account-Preceded-By-LinkBL
adminDescription: This attribute is the back link from a delegated managed service account to a service account object.
attributeId: 1.2.840.113556.1.4.2376
attributeSyntax: 2.5.5.1
oMObjectClass:: KwwCh3McAIVK
oMSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: 8Ep3lFVTLECcmhJHDIc+Sg==
systemFlags: 16
InstanceType: 4
linkID: 2225

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2374
systemMayContain: 1.2.840.113556.1.4.2376
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2371
systemMayContain: 1.2.840.113556.1.4.2373
-

dn: CN=ms-DS-Group-Managed-Service-Account,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.3.30
-

dn: CN=ms-DS-Delegated-Managed-Service-Account,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
lDAPDisplayName: msDS-DelegatedManagedServiceAccount
adminDisplayName: ms-DS-Delegated-Managed-Service-Account
adminDescription: The delegated managed service account class is used to create an account which can supersede a legacy service account and shared by different computers.
governsId: 1.2.840.113556.1.5.302
objectClassCategory: 1
rdnAttId: cn
subClassOf: 1.2.840.113556.1.3.30
systemMustContain: 1.2.840.113556.1.4.2372
systemMustContain: 1.2.840.113556.1.4.2199
systemMayContain: 1.2.840.113556.1.4.2375
systemMayContain: 1.2.840.113556.1.4.2200
systemMayContain: 1.2.840.113556.1.4.2198
systemMayContain: 1.2.840.113556.1.4.2197
systemMayContain: 1.2.840.113556.1.4.2196
systemPossSuperiors: 1.2.840.113556.1.3.23
systemPossSuperiors: 2.5.6.5
schemaIDGUID:: b5PrD7NH8kmThh3twsI3ZQ==
defaultSecurityDescriptor: D:(OD;;CR;00299570-246d-11d0-a768-00aa006e0529;;WD)(OD;;RP;e362ed86-b728-0842-b27d-2dea7a9df218;;WD)(OA;;WP;5f202010-79a5-11d0-9020-00c04fc2d4cf;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;WP;bf967950-0de6-11d0-a285-00aa003049e2;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;WP;bf967953-0de6-11d0-a285-00aa003049e2;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;WP;3e0abfd0-126a-11d0-a060-00aa006c33ed;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;RP;46a9b11d-60ae-405a-b7e8-ff8a58d456d2;;S-1-5-32-560)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;CO)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;PS)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;CO)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;PS)(OA;;WP;4c164200-20c0-11d0-a768-00aa006e0529;;CO)(OA;;RPWP;77b5b886-944a-11d1-aebd-0000f80367c1;;PS)(A;;CCDCLCSWRPWPDTLOCRSDRCWDWO;;;DA)(A;;CCDCLCSWRPWPDTLOCRSDRCWDWO;;;AO)(A;;LCRPDTLOCRSDRC;;;CO)(A;;CCDCLCSWRPWPDTLOCRSDRCWDWO;;;SY)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Delegated-Managed-Service-Account,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 89
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
- 

```

## Schema Update in Windows Server 2019

Sch88.ldf is the only new file introduced with Windows Server 2019.

### Sch88.ldf

```
dn: CN=ms-DS-Preferred-Data-Location,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
attributeID: 1.2.840.113556.1.4.2366
attributeSyntax: 2.5.5.12
adminDisplayName: ms-DS-Preferred-Data-Location
adminDescription: ms-DS-Preferred-Data-Location
oMSyntax: 64
lDAPDisplayName: msDS-preferredDataLocation
isSingleValued: TRUE
schemaIDGUID:: 3ooM+pRMEEa6zhgO/e4hQA==
searchFlags: 0
showInAdvancedViewOnly: FALSE
systemFlags: 16
systemOnly: FALSE
rangeLower: 1
rangeUpper: 10
isMemberOfPartialAttributeSet: TRUE

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2366
-

dn: CN=Contact,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2366
-

dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2366
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 88
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-
```

## Schema Updates in Windows Server 2016

Sch70.ldf through Sch87.ldf are introduced with Windows Server 2016.

### Sch70.ldf

```
dn: CN=ms-DS-Device-MDMStatus,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-MDMStatus
adminDisplayName: ms-DS-Device-MDMStatus
adminDescription: This attribute is used to manage the mobile device management status of the device.
ldapDisplayName: msDS-DeviceMDMStatus
attributeId: 1.2.840.113556.1.4.2308
omSyntax: 64
attributeSyntax: 2.5.5.12
isSingleValued: TRUE
instanceType: 4
rangeUpper: 256
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: lo8K9sRXLEKjrZ4voJzm9w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2308
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 70
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch71.ldf

```
dn: CN=ms-DS-GeoCoordinates-Altitude,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 16
-

dn: CN=ms-DS-GeoCoordinates-Latitude,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 16
-

dn: CN=ms-DS-GeoCoordinates-Longitude,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 16
-

dn: CN=ms-DS-Device-OS-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 1
-

dn: CN=ms-DS-Device-OS-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 1
-

# Increase schema version
dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 71
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch72.ldf

```
dn: CN=ms-DS-External-Directory-Object-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
adminDisplayName: ms-DS-External-Directory-Object-Id
adminDescription: ms-DS-External-Directory-Object-Id
ldapDisplayName: msDS-ExternalDirectoryObjectId
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
attributeId: 1.2.840.113556.1.4.2310
attributeSyntax: 2.5.5.12
omSyntax: 64
isMemberOfPartialAttributeSet: TRUE
isSingleValued: TRUE
instanceType: 4
rangeUpper: 256
schemaIdGuid:: kL8pva1m4UCIexDfBwQZpg==
searchFlags: 9
showInAdvancedViewOnly: FALSE
systemOnly: FALSE
systemFlags: 16

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mayContain
mayContain: 1.2.840.113556.1.4.2310
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2273
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 72
-

```

### Sch73.ldf

```
dn: CN=ms-DS-Is-Compliant,CN=Schema,CN=Configuration,DC=x
changetype: ntdsSchemaAdd
objectClass: attributeSchema
CN: ms-DS-Is-Compliant
adminDescription: This attribute is used to determine if the object is compliant with company policies.
adminDisplayName: msDS-IsCompliant
lDAPDisplayName: msDS-IsCompliant
attributeId: 1.2.840.113556.1.4.2314
oMSyntax: 1
attributeSyntax: 2.5.5.8
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
schemaIDGUID:: D31SWcC34kyh3XHO9pYykg==
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2314
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 73
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch74.ldf

```
dn: CN=ms-DS-Key-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-KeyId
adminDisplayName: msDS-KeyId
adminDescription: This attribute contains a key identifier.
attributeId: 1.2.840.113556.1.4.2315
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: S/iUwq0vcUu+TJ/FcB9gug==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Key-Material,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-KeyMaterial
adminDisplayName: msDS-KeyMaterial
adminDescription: This attribute contains key material.
attributeId: 1.2.840.113556.1.4.2316
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: nw4uodveMU+PIRMRuVgYLw==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Key-Usage,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-KeyUsage
adminDisplayName: msDS-KeyUsage
adminDescription: This attribute identifies the usage scenario for the key.
attributeId: 1.2.840.113556.1.4.2317
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: TLRx3ropl0WeysM0is4ZFw==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Key-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-KeyPrincipal
adminDisplayName: msDS-KeyPrincipal
adminDescription: This attribute specifies the principal that a key object applies to.
attributeId: 1.2.840.113556.1.4.2318
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OyVhvQGUOUGmkzVvxADz6g==
systemFlags: 16
instanceType: 4
linkID: 2218
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Key-Principal-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-KeyPrincipalBL
adminDisplayName: msDS-KeyPrincipalBL
adminDescription: This attribute is the backlink for msDS-KeyPrincipal.
attributeId: 1.2.840.113556.1.4.2319
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
isMemberOfPartialAttributeSet: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: vI8y0XSFUEGIHQsQiIJ4eA==
systemFlags: 16
instanceType: 4
linkID: 2219
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Device-DN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-DeviceDN
adminDisplayName: msDS-DeviceDN
adminDescription: This attribute identifies the registered device from which this key object was provisioned.
attributeId: 1.2.840.113556.1.4.2320
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KREsZJk4IUeOIUg545iM5Q==
systemFlags: 16
instanceType: 4
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Computer-SID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ComputerSID
adminDisplayName: msDS-ComputerSID
adminDescription: This attribute identifies a domain-joined computer.
attributeId: 1.2.840.113556.1.4.2321
attributeSyntax: 2.5.5.17
omSyntax: 4
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: INf733IILkCZQPzXjbBJug==
systemFlags: 16
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Custom-Key-Information,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-CustomKeyInformation
adminDisplayName: msDS-CustomKeyInformation
adminDescription: This attribute contains additional information about the key.
attributeId: 1.2.840.113556.1.4.2322
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: iOnltuTlhkyirg2suXCg4Q==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4
showInAdvancedViewOnly: TRUE

dn: CN=ms-DS-Key-Approximate-Last-Logon-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
adminDisplayName: msDS-KeyApproximateLastLogonTimeStamp
adminDescription: The approximate time this key was last used in a logon operation.
ldapDisplayName: msDS-KeyApproximateLastLogonTimeStamp
attributeId: 1.2.840.113556.1.4.2323
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
instanceType: 4
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
schemaIdGuid:: jcmaZJqbQU2va/YW8qYuSg==
systemFlags: 16
showInAdvancedViewOnly: TRUE

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Key-Credential,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-KeyCredential
adminDisplayName: msDS-KeyCredential
adminDescription: An instance of this class contains key material.
governsId: 1.2.840.113556.1.5.297
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: Q1Uf7i58akeLP+EfSvbEmA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
defaultHidingValue: FALSE
showInAdvancedViewOnly: TRUE
systemOnly: FALSE
systemFlags: 16
instanceType: 4
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.3.23
systemMustContain: 1.2.840.113556.1.4.2315
systemMayContain: 1.2.840.113556.1.4.2316
systemMayContain: 1.2.840.113556.1.4.2317
systemMayContain: 1.2.840.113556.1.4.2318
systemMayContain: 1.2.840.113556.1.4.2320
systemMayContain: 1.2.840.113556.1.4.2321
systemMayContain: 1.2.840.113556.1.4.2322
systemMayContain: 1.2.840.113556.1.4.2323

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
add:systemMayContain
systemMayContain: 1.2.840.113556.1.4.2319
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 74
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch75.ldf

```
dn: CN=ms-DS-Device-Trust-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
CN: ms-DS-Device-Trust-Type
adminDescription: Represents join type for devices.
adminDisplayName: msDS-DeviceTrustType
lDAPDisplayName: msDS-DeviceTrustType
attributeId: 1.2.840.113556.1.4.2325
oMSyntax: 2
attributeSyntax: 2.5.5.9
instanceType: 4
isMemberOfPartialAttributeSet: TRUE
isSingleValued: TRUE
searchFlags: 0
showInAdvancedViewOnly: TRUE
systemOnly: FALSE
schemaIDGUID:: B2ikxNxqu0uX3mvtGBob/g==
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2325
-

#
# Optional Feature Object
#
dn: CN=Expiring Group Membership Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: msDS-OptionalFeature
msDS-OptionalFeatureFlags: 1
msDS-OptionalFeatureGUID:: c+hD7OjMQEa0qwf/5KtbzQ==
msDS-RequiredForestBehaviorVersion: 7
# 0x800000000
# 0x080000000
# 0x040000000
systemFlags: 2348810240

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 75
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch76.ldf

```
dn: CN=ms-DS-Shadow-Principal-Sid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: msDS-ShadowPrincipalSid
adminDisplayName: ms-DS-Shadow-Principal-Sid
adminDescription: Contains the SID of a principal from an external forest.
attributeID: 1.2.840.113556.1.4.2324
attributeSyntax: 2.5.5.17
oMSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIDGUID:: IgfMHbCq70+Vbydv4Z3hBw==
systemFlags: 16
instanceType: 4
showInAdvancedViewOnly: TRUE

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Shadow-Principal-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ShadowPrincipalContainer
adminDisplayName: ms-DS-Shadow-Principal-Container
adminDescription: Dedicated container for msDS-ShadowPrincipal objects.
governsId: 1.2.840.113556.1.5.298
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: RVX5ERLXUEy4R9J4FTfGMw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
defaultHidingValue: FALSE
showInAdvancedViewOnly: TRUE
systemOnly: FALSE
systemFlags: 16
instanceType: 4
subClassOf: container

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Shadow-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ShadowPrincipal
adminDisplayName: ms-DS-Shadow-Principal
adminDescription: Represents a principal from an external forest.
governsId: 1.2.840.113556.1.5.299
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: s0wPd0MWnEa3Zu3XeqdeFA==
defaultHidingValue: FALSE
showInAdvancedViewOnly: TRUE
systemOnly: FALSE
systemFlags: 16
instanceType: 4
subClassOf: top
systemPossSuperiors: msDS-ShadowPrincipalContainer
systemMayContain: member
systemMustContain: msDS-ShadowPrincipalSid

dn: CN=Shadow Principal Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: msDS-OptionalFeature
msDS-OptionalFeatureFlags: 1
msDS-OptionalFeatureGUID:: KbW388juRVatNjmTdiXpNg==
msDS-RequiredForestBehaviorVersion: 7
systemFlags: 2348810240

dn: CN=Shadow Principal Configuration,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: msDS-ShadowPrincipalContainer
showInAdvancedViewOnly: TRUE

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 76
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch77.ldf

```
dn: CN=ms-DS-Key-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Key-Material,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Key-Usage,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Key-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Device-DN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Computer-SID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Custom-Key-Information,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn: CN=ms-DS-Key-Approximate-Last-Logon-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: FALSE
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Key-Credential,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2252
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 77
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch78.ldf

```
#
# Optional Feature Object
#
dn: CN=Expiring Group Membership Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
# FLAG_ALLOW_RENAME 0x400000
systemFlags: 1073741824
-

dn: CN=Expiring Group Membership Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Privileged Access Management Feature
deleteoldrdn: 1

dn: CN=Privileged Access Management Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
# FLAG_DISALLOW_DELETE 0x80000000
# FLAG_DOMAIN_DISALLOW_RENAME0x08000000
# FLAG_DOMAIN_DISALLOW_MOVE0x04000000
systemFlags: 2348810240
-

dn: CN=Shadow Principal Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
# FLAG_DOMAIN_DISALLOW_RENAME0x08000000
# FLAG_DOMAIN_DISALLOW_MOVE0x04000000
replace: systemFlags
systemFlags: 201326592
-

dn: CN=Shadow Principal Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 78
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch79.ldf

```
dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2321
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 79
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch80.ldf

```
dn: CN=ms-DS-Key-Credential-Link,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
attributeID: 1.2.840.113556.1.4.2328
attributeSyntax: 2.5.5.7
adminDisplayName: ms-DS-Key-Credential-Link
adminDescription: Contains key material and usage.
oMSyntax: 127
oMObjectClass:: KoZIhvcUAQEBCw==
lDAPDisplayName: msDS-KeyCredentialLink
isSingleValued: FALSE
systemOnly: FALSE
schemaIDGUID:: D9ZHW5BgskCfNypN6I8wYw==
searchFlags: 0
showInAdvancedViewOnly: TRUE
systemFlags: 16
linkId: 2220

dn: CN=ms-DS-Key-Credential-Link-BL,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
attributeID: 1.2.840.113556.1.4.2329
attributeSyntax: 2.5.5.1
oMSyntax: 127
lDAPDisplayName: msDS-KeyCredentialLink-BL
isSingleValued: FALSE
systemOnly: FALSE
schemaIDGUID:: iNeKk18i7k6Tua0koVnh2w==
searchFlags: 0
showInAdvancedViewOnly: TRUE
systemFlags: 16
linkId: 2221

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2328
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2328
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 80
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch81.ldf

```
dn: CN=DS-Validated-Write-Computer,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
displayName: Validated write to computer attributes.
rightsGuid: 9b026da6-0d3c-465c-8bee-5199d7165cba
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
ShowInAdvancedViewOnly: TRUE
validAccesses: 8

dn: CN=ms-DS-Key-Credential-Link,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGUID
attributeSecurityGUID:: pm0CmzwNXEaL7lGZ1xZcug==
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 81
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch82.ldf

```
dn: CN=Dns-Zone-Scope-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
cn: Dns-Zone-Scope-Container
adminDisplayName: Dns-Zone-Scope-Container
adminDescription: Container for Dns Zone Scope objects.
ldapDisplayName: dnsZoneScopeContainer
rDNAttID: cn
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;ED)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;CC;;;AU)(A;;RPLCLORC;;;WD)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)
governsId: 1.2.840.113556.1.5.300
instanceType: 4
objectClassCategory: 1
schemaIdGuid:: k5Bp8lryIEKd6wPfTMSpxQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.5.85

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Dns-Zone-Scope,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
cn: Dns-Zone-Scope
adminDisplayName: Dns-Zone-Scope
adminDescription: A zonescope of a zone is another copy of the zone contained in the zone with different set of resource records.
ldapDisplayName: dnsZoneScope
rDNAttID: cn
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;ED)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;CC;;;AU)(A;;RPLCLORC;;;WD)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)
governsId: 1.2.840.113556.1.5.301
instanceType: 4
objectClassCategory: 1
schemaIdGuid:: YYpvaT8tzkCks+J138xJxQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.5.300
systemMustContain: 0.9.2342.19200300.100.1.25
systemMayContain: 1.2.840.113556.1.4.1306
systemMayContain: 1.2.840.113556.1.4.653

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Dns-Node,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.301
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 82
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch83.ldf

```
dn: CN=ms-DS-Expire-Passwords-On-Smart-Card-Only-Accounts,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
CN: ms-DS-Expire-Passwords-On-Smart-Card-Only-Accounts
attributeID: 1.2.840.113556.1.4.2344
attributeSyntax: 2.5.5.8
adminDisplayName: ms-DS-Expire-Passwords-On-Smart-Card-Only-Accounts
adminDescription: This attribute controls whether the passwords on smart-card-only accounts expire in accordance with the password policy.
oMSyntax: 1
lDAPDisplayName: msDS-ExpirePasswordsOnSmartCardOnlyAccounts
isSingleValued: TRUE
systemOnly: FALSE
schemaIDGUID:: SKsXNCTfsU+AsA/LNn4l4w==
systemFlags: 16
searchFlags: 0
instanceType: 4

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Domain-DNS,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2344
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 83
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch84.ldf

```
dn: CN=ms-DS-Token-Group-Names,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msds-tokenGroupNames
adminDisplayName: ms-DS-Token-Group-Names
adminDescription: The distinguished names of security groups the principal is directly or indirectly a member of.
attributeId: 1.2.840.113556.1.4.2345
attributeSyntax: 2.5.5.1
omSyntax: 127
omObjectClass:: KwwCh3McAIVK
isSingleValued: FALSE
systemOnly: TRUE
# 0x00000800 (Attribute is returned only on base searches.)
# searchFlags hex value 0x00000800
searchFlags: 2048
schemaIdGuid:: dgVlZZlGyU+NGCbgzQE3pg==
attributeSecurityGuid:: +IhwA+EK0hG0IgCgyWj5OQ==
showInAdvancedViewOnly: TRUE
# 0x00000001 (Attribute is not replicated)
# 0x00000004 (Attribute is constructed)
# 0x00000008 (Attribute is operational)
# 0x00000010 (Attribute is in the base schema)
# systemFlags hex value 0x0000001D
systemFlags: 29

dn: CN=ms-DS-Token-Group-Names-Global-And-Universal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msds-tokenGroupNamesGlobalAndUniversal
adminDisplayName: ms-DS-Token-Group-Names-Global-And-Universal
adminDescription: The distinguished names of global and universal security groups the principal is directly or indirectly a member of.
attributeId: 1.2.840.113556.1.4.2346
attributeSyntax: 2.5.5.1
omSyntax: 127
omObjectClass:: KwwCh3McAIVK
isSingleValued: FALSE
systemOnly: TRUE
# 0x00000800 (Attribute is returned only on base searches.)
# searchFlags hex value 0x00000800
searchFlags: 2048
schemaIdGuid:: 9NEG+iJ5rUq3nLIgH1RBfA==
attributeSecurityGuid:: +IhwA+EK0hG0IgCgyWj5OQ==
showInAdvancedViewOnly: TRUE
# 0x00000001 (Attribute is not replicated)
# 0x00000004 (Attribute is constructed)
# 0x00000008 (Attribute is operational)
# 0x00000010 (Attribute is in the base schema)
# systemFlags hex value 0x0000001D
systemFlags: 29

dn: CN=ms-DS-Token-Group-Names-No-GC-Acceptable,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msds-tokenGroupNamesNoGCAcceptable
adminDisplayName: ms-DS-Token-Group-Names-No-GC-Acceptable
adminDescription: The distinguished names of security groups the principal is directly or indirectly a member of as reported by the local DC.
attributeId: 1.2.840.113556.1.4.2347
attributeSyntax: 2.5.5.1
omSyntax: 127
omObjectClass:: KwwCh3McAIVK
isSingleValued: FALSE
systemOnly: TRUE
# 0x00000800 (Attribute is returned only on base searches.)
# searchFlags hex value 0x00000800
searchFlags: 2048
schemaIdGuid:: yMY/UvSaAkqc1z3qEp7rJw==
attributeSecurityGuid:: +IhwA+EK0hG0IgCgyWj5OQ==
showInAdvancedViewOnly: TRUE
# 0x00000001 (Attribute is not replicated)
# 0x00000004 (Attribute is constructed)
# 0x00000008 (Attribute is operational)
# 0x00000010 (Attribute is in the base schema)
# systemFlags hex value 0x0000001D
systemFlags: 29

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2345
systemMayContain: 1.2.840.113556.1.4.2346
systemMayContain: 1.2.840.113556.1.4.2347
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 84
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch85.ldf

```
dn: CN=ms-DS-User-Allowed-NTLM-Network-Authentication,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-UserAllowedNTLMNetworkAuthentication
adminDisplayName: ms-DS-User-Allowed-NTLM-Network-Authentication
adminDescription: This attribute is used to determine if a user is allowed to authenticate using NTLM authentication.
attributeId: 1.2.840.113556.1.4.2348
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
# searchFlags hex value 0x00000000
searchFlags: 0
# schemaIdGuid {7ece040f-9327-4cdc-aad3-037adfe62639}
schemaIdGuid:: DwTOfieT3Eyq0wN63+YmOQ==
# attributeSecurityGuid {00000000-0000-0000-0000-000000000000}
showInAdvancedViewOnly: TRUE
# systemFlags hex value 0x00000010
# 0x00000010 (Attribute is in the base schema)
systemFlags: 16

dn: CN=ms-DS-Service-Allowed-NTLM-Network-Authentication,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ServiceAllowedNTLMNetworkAuthentication
adminDisplayName: ms-DS-Service-Allowed-NTLM-Network-Authentication
adminDescription: This attribute is used to determine if a service is allowed to authenticate using NTLM authentication.
attributeId: 1.2.840.113556.1.4.2349
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
# searchFlags hex value 0x00000000
searchFlags: 0
# schemaIdGuid {278947b9-5222-435e-96b7-1503858c2b48}
schemaIdGuid:: uUeJJyJSXkOWtxUDhYwrSA==
# attributeSecurityGuid {00000000-0000-0000-0000-000000000000}
showInAdvancedViewOnly: TRUE
# systemFlags hex value 0x00000010
# 0x00000010 (Attribute is in the base schema)
systemFlags: 16

dn: CN=ms-DS-Strong-NTLM-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-StrongNTLMPolicy
adminDisplayName: ms-DS-Strong-NTLM-Policy
adminDescription: This attribute specifies policy options for NTLM secrets with strong entropy.
attributeId: 1.2.840.113556.1.4.2350
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
# searchFlags hex value 0x00000000
searchFlags: 0
# schemaIdGuid {aacd2170-482a-44c6-b66e-42c2f66a285c}
schemaIdGuid:: cCHNqipIxkS2bkLC9mooXA==
# attributeSecurityGuid {00000000-0000-0000-0000-000000000000}
showInAdvancedViewOnly: TRUE
# systemFlags hex value 0x00000010
# 0x00000010 (Attribute is in the base schema)
systemFlags: 16

dn: CN=ms-DS-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2348
systemMayContain: 1.2.840.113556.1.4.2349
systemMayContain: 1.2.840.113556.1.4.2350
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 85
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch86.ldf

```
dn: CN=ms-DS-Source-Anchor,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-SourceAnchor
adminDisplayName: ms-DS-Source-Anchor
adminDescription: Unique, immutable identifier for the object in the authoritative directory.
attributeId: 1.2.840.113556.1.4.2352
attributeSyntax: 2.5.5.12
# Syntax: String
oMSyntax: 64
isSingleValued: TRUE
# Note that we do not supply rangeUpper here.DS API enforces a maximum length of 256 Unicode characters,
# which may translate to more than 256 multi-byte characters in AD given that the AD syntax for this
# attribute is not String(Unicode).
rangeLower: 1
systemOnly: FALSE
# searchFlags: +fPDNTATTINDEX for SearchForAddressListObjects
# searchFlags: fPDNTATTINDEX | fPRESERVEONDELETE
searchFlags: 10
schemaIDGUID:: B/QCsEAT60G8oL19k44lqQ==
# attributeSecurityGuid {00000000-0000-0000-0000-000000000000}
showInAdvancedViewOnly: TRUE
# systemFlags hex value 0x00000010
# 0x00000010 (Attribute is in the base schema)
systemFlags: 16

dn: CN=ms-DS-Object-SOA,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ObjectSoa
adminDisplayName: ms-DS-Object-SOA
adminDescription: This attribute is used to identify the source of authority of the object.
attributeId: 1.2.840.113556.1.4.2353
attributeSyntax: 2.5.5.12
# Syntax: String
oMSyntax: 64
isSingleValued: TRUE
# Note that we do not supply rangeUpper here.DS API enforces a maximum length of 256 Unicode characters,
# which may translate to more than 256 multi-byte characters in AD given that the AD syntax for this
# attribute is not String(Unicode).
rangeLower: 1
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: 9b32NHkuO0yOFD2Tt1qriQ==
showInAdvancedViewOnly: TRUE
# systemFlags hex value 0x00000010
# 0x00000010 (Attribute is in the base schema)
systemFlags: 16

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2352
systemMayContain: 1.2.840.113556.1.4.2353
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 86
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

### Sch87.ldf

```
dn: CN=Send-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Receive-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Public-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Validated-SPN,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Allowed-To-Authenticate,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=MS-TS-GatewayAccess,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 87
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

```

## Schema Updates in Windows Server 2012 R2

Sch57.ldf through Sch69.ldf are introduced with Windows Server 2012 R2.

### Sch57.ldf

```
dn: CN=ms-DS-Issuer-Certificates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Issuer-Certificates
adminDisplayName: ms-DS-Issuer-Certificates
adminDescription: The keys used to sign certificates issued by the Registration Service.
ldapDisplayName: msDS-IssuerCertificates
attributeId: 1.2.840.113556.1.4.2240
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: FALSE
instanceType: 4
rangeLower: 1
rangeUpper: 65536
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: 2m89a5MIxEOJ+x+1KmYWqQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Registration-Quota,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Registration-Quota
adminDisplayName: ms-DS-Registration-Quota
adminDescription: Policy used to limit the number of registrations allowed for a single user.
ldapDisplayName: msDS-RegistrationQuota
attributeId: 1.2.840.113556.1.4.2241
omSyntax: 2
attributeSyntax: 2.5.5.9
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: woYyymQfeUCWvOYrYQ5zDw==
systemFlags: 16

dn: CN=ms-DS-Maximum-Registration-Inactivity-Period,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Maximum-Registration-Inactivity-Period
adminDisplayName: ms-DS-Maximum-Registration-Inactivity-Period
adminDescription: The maximum amount of days used to detect inactivty of registration objects.
ldapDisplayName: msDS-MaximumRegistrationInactivityPeriod
attributeId: 1.2.840.113556.1.4.2242
omSyntax: 2
attributeSyntax: 2.5.5.9
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: OapcCuYFykm4CAJbk2YQ5w==
systemFlags: 16

dn: CN=ms-DS-Is-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Is-Enabled
adminDisplayName: ms-DS-Is-Enabled
adminDescription: This attribute is used to enable or disable the user-device relationship.
ldapDisplayName: msDS-IsEnabled
attributeId: 1.2.840.113556.1.4.2248
omSyntax: 1
attributeSyntax: 2.5.5.8
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: DlypIoMfgkyUzr6miM/IcQ==
systemFlags: 16

dn: CN=ms-DS-Device-OS-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-OS-Type
adminDisplayName: ms-DS-Device-OS-Type
adminDescription: This attribute is used to track the type of device based on the OS.
ldapDisplayName: msDS-DeviceOSType
attributeId: 1.2.840.113556.1.4.2249
omSyntax: 64
attributeSyntax: 2.5.5.12
isSingleValued: FALSE
instanceType: 4
rangeLower: 0
rangeUpper: 1024
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: TUUOELvzy02EX41e3EccWQ==
systemFlags: 16

dn: CN=ms-DS-Device-OS-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-OS-Version
adminDisplayName: ms-DS-Device-OS-Version
adminDescription: This attribute is used to track the OS version of the device.
ldapDisplayName: msDS-DeviceOSVersion
attributeId: 1.2.840.113556.1.4.2250
omSyntax: 64
attributeSyntax: 2.5.5.12
isSingleValued: FALSE
instanceType: 4
rangeLower: 0
rangeUpper: 512
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: Y4z7cKtfBEWrnRSzKain+A==
systemFlags: 16

dn: CN=ms-DS-Device-Physical-IDs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-Physical-IDs
adminDisplayName: ms-DS-Device-Physical-IDs
adminDescription: This attribute is used to store identifiers of the physical device.
ldapDisplayName: msDS-DevicePhysicalIDs
attributeId: 1.2.840.113556.1.4.2251
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: FALSE
instanceType: 4
rangeLower: 1
rangeUpper: 10485760
searchFlags: 1
systemOnly: FALSE
schemaIdGuid:: FFRhkKCiR0Spk1NAlZm3Tg==
systemFlags: 16

dn: CN=ms-DS-Device-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-ID
adminDisplayName: ms-DS-Device-ID
adminDescription: This attribute stores the ID of the device.
ldapDisplayName: msDS-DeviceID
attributeId: 1.2.840.113556.1.4.2252
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: TRUE
instanceType: 4
rangeLower: 16
rangeUpper: 16
searchFlags: 1
systemOnly: FALSE
schemaIdGuid:: x4EBw0Jj+0GyeffFZsvgpw==
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device-Registration-Service-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
cn: ms-DS-Device-Registration-Service-Container
adminDisplayName: ms-DS-Device-Registration-Service-Container
adminDescription: A class for the container used to house all enrollment services used for device registrations.
ldapDisplayName: msDS-DeviceRegistrationServiceContainer
rDNAttID: cn
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
governsId: 1.2.840.113556.1.5.287
instanceType: 4
objectClassCategory: 1
schemaIdGuid:: zlULMc09kkOpbcnjU5fCTw==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.3.23

dn: CN=ms-DS-Device-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
cn: ms-DS-Device-Container
adminDisplayName: ms-DS-Device-Container
adminDescription: A class for the container used to hold device objects.
ldapDisplayName: msDS-DeviceContainer
rDNAttID: cn
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
governsId: 1.2.840.113556.1.5.289
instanceType: 4
objectClassCategory: 1
schemaIdGuid:: WIyefBuQqE627E656fwOEQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.5.67

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
cn: ms-DS-Device-Registration-Service
adminDisplayName: ms-DS-Device-Registration-Service
adminDescription: An object of this class holds the registration service configuration used for devices.
ldapDisplayName: msDS-DeviceRegistrationService
rDNAttID: cn
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
governsId: 1.2.840.113556.1.5.284
instanceType: 4
objectClassCategory: 1
schemaIdGuid:: Gjq8ltLj00mvEXsN951n9Q==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.5.287
systemMayContain: 1.2.840.113556.1.4.2240
systemMayContain: 1.2.840.113556.1.4.2241
systemMayContain: 1.2.840.113556.1.4.2242

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
cn: ms-DS-Device
adminDisplayName: ms-DS-Device
adminDescription: An object of this type represents a registered device.
ldapDisplayName: msDS-Device
rDNAttID: cn
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
governsId: 1.2.840.113556.1.5.286
instanceType: 4
objectClassCategory: 1
schemaIdGuid:: c7byXUFtdEez6NUujun/mQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.5.289
systemMayContain: 1.2.840.113556.1.4.2248
systemMayContain: 1.2.840.113556.1.4.2249
systemMayContain: 1.2.840.113556.1.4.2250
systemMayContain: 1.2.840.113556.1.4.2251
systemMayContain: 1.2.840.113556.1.4.2252

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 57
-
```

### Sch58.ldf

```
dn: CN=ms-DS-Resource-Property-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: FALSE
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 58
-
```

### Sch59.ldf

```
dn: CN=ms-DS-User-Device-Registration,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-User-Device-Registration-Container,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2246
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2244
-

dn: CN=ms-DS-User-Device-Registration-Link,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-User-Device-Registration-Link-BL,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-Authentication-Level,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-Approximate-Last-Use-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-Device-Reference,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: isDefunct
isDefunct: TRUE
-

dn: CN=ms-DS-Device-Location,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-Location
adminDisplayName: ms-DS-Device-Location
adminDescription: The DN under which the device objects will be created.
ldapDisplayName: msDS-DeviceLocation
attributeId: 1.2.840.113556.1.4.2261
omSyntax: 127
omObjectClass:: KwwCh3McAIVK
attributeSyntax: 2.5.5.1
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
systemOnly: TRUE
schemaIdGuid:: yFb74+hd9UWxsdK2zTHnYg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Registered-Owner,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Registered-Owner
adminDisplayName: ms-DS-Registered-Owner
adminDescription: Single valued binary attribute containing the primary SID referencing the first user to register the device. The value is not removed during de-registration, but could be managed by an administrator.
ldapDisplayName: msDS-RegisteredOwner
attributeId: 1.2.840.113556.1.4.2258
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: TRUE
instanceType: 4
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
schemaIdGuid:: 6SZ2YesBz0KZH85heYIjfg==
systemFlags: 18

dn: CN=ms-DS-Registered-Users,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Registered-Users
adminDisplayName: ms-DS-Registered-Users
adminDescription: Contains the list of users that have registered the device.Users in this list have all of the features provided by the "Company Portal" app.And they have SSO to company resources.
ldapDisplayName: msDS-RegisteredUsers
attributeId: 1.2.840.113556.1.4.2263
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: FALSE
instanceType: 4
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
schemaIdGuid:: DBZJBI5ayE+wUgHA9uSPAg==
systemFlags: 18

dn: CN=ms-DS-Approximate-Last-Logon-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Approximate-Last-Logon-Time-Stamp
adminDisplayName: ms-DS-Approximate-Last-Logon-Time-Stamp
adminDescription: The approximate time a user last logged on with from the device.
ldapDisplayName: msDS-ApproximateLastLogonTimeStamp
attributeId: 1.2.840.113556.1.4.2262
omSyntax: 65
attributeSyntax: 2.5.5.16
isSingleValued: TRUE
instanceType: 4
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
schemaIdGuid:: O5hPo8aEDE+QUKOhSh01pA==
systemFlags: 16

dn: CN=ms-DS-Device-Object-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Device-Object-Version
adminDisplayName: ms-DS-Device-Object-Version
adminDescription: This attribute is used to identify the schema version of the device.
ldapDisplayName: msDS-DeviceObjectVersion
attributeId: 1.2.840.113556.1.4.2257
omSyntax: 2
attributeSyntax: 2.5.5.9
isSingleValued: TRUE
instanceType: 4
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
schemaIdGuid:: Wmll73nxak6T3rAeBmgc+w==
systemFlags: 18

dn: CN=ms-DS-Device-OS-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isSingleValued
isSingleValued: TRUE
-

dn: CN=ms-DS-Device-OS-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 1
-

dn: CN=ms-DS-Device-OS-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isSingleValued
isSingleValued: TRUE
-

dn: CN=ms-DS-Device-Physical-IDs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: omSyntax
omSyntax: 64
-

dn: CN=ms-DS-Device-Physical-IDs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: attributeSyntax
attributeSyntax: 2.5.5.12
-

dn: CN=ms-DS-Device-Physical-IDs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 1024
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.2261
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2257
systemMayContain: 1.2.840.113556.1.4.2258
systemMayContain: 1.2.840.113556.1.4.2262
systemMayContain: 1.2.840.113556.1.4.2263
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2248
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.2248
systemMustContain: 1.2.840.113556.1.2.13
systemMustContain: 1.2.840.113556.1.4.867
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 59
-
```

### Sch60.ldf

```
dn: CN=ms-DS-Is-Member-Of-DL-Transitive,CN=Schema,CN=Configuration,DC=X
# This constructed attribute transitively expands the
# linked attribute "isMemberOfDL"
changetype: ntdsschemaadd
objectClass: attributeSchema
lDAPDisplayName: msds-memberOfTransitive
adminDisplayName: msds-memberOfTransitive
adminDescription: msds-memberOfTransitive
attributeID: 1.2.840.113556.1.4.2236
attributeSyntax: 2.5.5.1
oMSyntax: 127
oMObjectClass:: KwwCh3McAIVK
isSingleValued: FALSE
systemOnly: TRUE
# 0x800(only return on base search)
searchFlags: 2048
showInAdvancedViewOnly: TRUE
schemaIdGuid:: tmYhhkHJJ0eVZUi//ylB3g==
# 0x10 (base schema) +
# 0x08 (operational) +
# 0x04 (constructed) +
# 0x01 (not replicated)
systemFlags: 29

dn: CN=ms-DS-Member-Transitive,CN=Schema,CN=Configuration,DC=X
# This constructed attribute transitively expands the
# linked attribute "member"
changetype: ntdsschemaadd
objectClass: attributeSchema
lDAPDisplayName: msds-memberTransitive
adminDisplayName: msds-memberTransitive
adminDescription: msds-memberTransitive
attributeID: 1.2.840.113556.1.4.2238
attributeSyntax: 2.5.5.1
oMSyntax: 127
oMObjectClass:: KwwCh3McAIVK
isSingleValued: FALSE
systemOnly: TRUE
# 0x800(only return on base search)
searchFlags: 2048
showInAdvancedViewOnly: TRUE
schemaIdGuid:: WzkV4gSR2US4lDmeyeId/A==
# 0x10 (base schema) +
# 0x08 (operational) +
# 0x04 (constructed) +
# 0x01 (not replicated)
systemFlags: 29

dn: CN=ms-DS-Parent-Dist-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsschemaadd
objectClass: attributeSchema
lDAPDisplayName: msDS-parentdistname
adminDisplayName: ms-DS-Parent-Dist-Name
adminDescription: ms-DS-Parent-Dist-Name
attributeID: 1.2.840.113556.1.4.2203
attributeSyntax: 2.5.5.1
oMSyntax: 127
oMObjectClass:: KwwCh3McAIVK
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIDGUID:: ff4YuRqXBPSeIZJhq+yXCw==
showInAdvancedViewOnly: TRUE
# 0x10 (base schema) +
# 0x08 (operational) +
# 0x04 (constructed) +
# 0x01 (not replicated)
systemFlags: 29

dn: CN=ms-DS-Repl-Value-Meta-Data-Ext,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ReplValueMetaDataExt
adminDisplayName: ms-DS-Repl-Value-Meta-Data-Ext
adminDescription: ms-DS-Repl-Value-Meta-Data-Ext
attributeId: 1.2.840.113556.1.4.2235
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 79ICHq1EskamfZ/RjXgLyg==
showInAdvancedViewOnly: TRUE
# 0x10 (base schema) +
# 0x04 (constructed)
systemFlags: 20

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: cn=Top,cn=Schema,cn=Configuration,dc=X
changetype: ntdsschemamodify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2238
systemMayContain: 1.2.840.113556.1.4.2236
systemMayContain: 1.2.840.113556.1.4.2203
systemMayContain: 1.2.840.113556.1.4.2235
-

dn: CN=DS-Set-Owner,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
displayName: Set Owner of an object during creation.
rightsGuid: 4125c71f-7fac-4ff0-bcb7-f09a41325286
appliesTo: 26f11b08-a29d-4869-99bb-ef0b99fd883e
validAccesses: 256

dn: CN=DS-Bypass-Quota,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
displayName: Bypass the quota restrictions during creation.
rightsGuid: 88a9933e-e5c8-4f2a-9dd7-2527416b8092
appliesTo: 26f11b08-a29d-4869-99bb-ef0b99fd883e
validAccesses: 256

dn: CN=DS-Read-Partition-Secrets,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
displayName: Read secret attributes of objects in a Partition
rightsGuid: 084c93a2-620d-4879-a836-f0ae47de0e89
appliesTo: 26f11b08-a29d-4869-99bb-ef0b99fd883e
validAccesses: 256

dn: CN=DS-Write-Partition-Secrets,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
displayName: Write secret attributes of objects in a Partition
rightsGuid: 94825A8D-B171-4116-8146-1E34D8F54401
appliesTo: 26f11b08-a29d-4869-99bb-ef0b99fd883e
validAccesses: 256

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 60
-
```

### Sch61.ldf

```
dn: CN=ms-DS-Drs-Farm-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Drs-Farm-ID
adminDisplayName: ms-DS-Drs-Farm-ID
adminDescription: This attribute stores the name of the federation service this DRS object is associated with.
ldapDisplayName: msDS-DrsFarmID
attributeId: 1.2.840.113556.1.4.2265
omSyntax: 64
attributeSyntax: 2.5.5.12
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
isMemberOfPartialAttributeSet: TRUE
systemOnly: TRUE
schemaIdGuid:: ZvdVYC4gzUmovuUrsVnt+w==
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.2248
systemMustContain: 1.2.840.113556.1.4.2265
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 61
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-
```

### Sch62.ldf

```
dn: CN=ms-DS-Issuer-Public-Certificates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Issuer-Public-Certificates
adminDisplayName: ms-DS-Issuer-Public-Certificates
adminDescription: The public keysof the keys used to sign certificates issued by the Registration Service.
ldapDisplayName: msDS-IssuerPublicCertificates
attributeId: 1.2.840.113556.1.4.2269
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: FALSE
instanceType: 4
rangeLower: 1
rangeUpper: 65536
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: /u3xtdK0dkCrD2FINCsL9g==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2269
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 62
-

```

### Sch63.ldf

```
dn: CN=ms-DS-Issuer-Certificates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 128
-

dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
-

dn: CN=ms-DS-Device-Registration-Service-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 63
-

```

### Sch64.ldf

```
dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
-

dn: CN=ms-DS-Device-Registration-Service-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2252
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.2252
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 64
-
```

### Sch65.ldf

```
dn: CN=ms-DS-Registration-Quota,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Maximum-Registration-Inactivity-Period,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Registered-Owner,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Registered-Users,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Approximate-Last-Logon-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Is-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Device-OS-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Device-OS-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Device-Physical-IDs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Device-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Device-Object-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-Drs-Farm-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: showInAdvancedViewOnly
showInAdvancedViewOnly: TRUE
-

dn: CN=ms-DS-IsManaged,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-IsManaged
adminDisplayName: ms-DS-IsManaged
adminDescription: This attribute is used to indicate the device is managed by a on-premises MDM.
ldapDisplayName: msDS-IsManaged
attributeId: 1.2.840.113556.1.4.2270
omSyntax: 1
attributeSyntax: 2.5.5.8
isSingleValued: TRUE
instanceType: 4
searchFlags: 1
systemOnly: FALSE
schemaIdGuid:: zmpoYCds3kOk5fAML40zCQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Cloud-IsManaged,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Cloud-IsManaged
adminDisplayName: ms-DS-Cloud-IsManaged
adminDescription: This attribute is used to indicate the device is managed by a cloud MDM.
ldapDisplayName: msDS-CloudIsManaged
attributeId: 1.2.840.113556.1.4.2271
omSyntax: 1
attributeSyntax: 2.5.5.8
isSingleValued: TRUE
instanceType: 4
searchFlags: 1
systemOnly: FALSE
schemaIdGuid:: jroVU4+VUku9OBNJowTdYw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Cloud-Anchor,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Cloud-Anchor
adminDisplayName: ms-DS-Cloud-Anchor
adminDescription: This attribute is used by the DirSync engine to indicate the object SOA and to maintain the relationship between the on-premises and cloud object.
ldapDisplayName: msDS-CloudAnchor
attributeId: 1.2.840.113556.1.4.2273
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: gF5WeNQD40+vrIw7yi82Uw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Cloud-Issuer-Public-Certificates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Cloud-Issuer-Public-Certificates
adminDisplayName: ms-DS-Cloud-Issuer-Public-Certificates
adminDescription: The public keys used by the cloud DRS to sign certificates issued by the Registration Service.
ldapDisplayName: msDS-CloudIssuerPublicCertificates
attributeId: 1.2.840.113556.1.4.2274
omSyntax: 4
attributeSyntax: 2.5.5.10
isSingleValued: FALSE
instanceType: 4
rangeLower: 1
rangeUpper: 65536
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: T7XoodZL0k+Y4rzukqVUlw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Cloud-IsEnabled,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-Cloud-IsEnabled
adminDisplayName: ms-DS-Cloud-IsEnabled
adminDescription: This attribute is used to indicate whether cloud DRS is enabled.
ldapDisplayName: msDS-CloudIsEnabled
attributeId: 1.2.840.113556.1.4.2275
omSyntax: 1
attributeSyntax: 2.5.5.8
isSingleValued: TRUE
instanceType: 4
searchFlags: 0
systemOnly: FALSE
schemaIdGuid:: KIOEiU58b0+gEyjOOtKC3A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Device,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2270
systemMayContain: 1.2.840.113556.1.4.2271
systemMayContain: 1.2.840.113556.1.4.2273
-

dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2274
systemMayContain: 1.2.840.113556.1.4.2275
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 65
-
```

### Sch66.ldf

```
dn: CN=ms-DS-SyncServerUrl,CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-SyncServerUrl
ldapDisplayName: msDS-SyncServerUrl
adminDisplayName: ms-DS-SyncServerUrl
adminDescription: Use this attribute to store the sync server (Url format) which hosts the user sync folder
AttributeID: 1.2.840.113556.1.4.2276
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
SystemOnly: FALSE
searchFlags: 1
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: 0sOst3QqpE+sJeY/6LYSGA==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2276
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 66
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-
```

### Sch67.ldf

```
dn: CN=ms-DS-Device-Registration-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.2265
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Drs-Farm-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isDefunct
isDefunct: TRUE
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 67
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-
```

### Sch68.ldf

```
dn: CN=ms-DS-User-Allowed-To-Authenticate-To,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-UserAllowedToAuthenticateTo
adminDisplayName: ms-DS-User-Allowed-To-Authenticate-To
adminDescription: This attribute is used to determine if a user has permission to authenticate to a service.
attributeId: 1.2.840.113556.1.4.2277
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: f6oM3k5yhkKxeRkmce/GZA==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4

dn: CN=ms-DS-User-Allowed-To-Authenticate-From,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-UserAllowedToAuthenticateFrom
adminDisplayName: ms-DS-User-Allowed-To-Authenticate-From
adminDescription: This attribute is used to determine if a user has permission to authenticate from a computer.
attributeId: 1.2.840.113556.1.4.2278
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: AJZMLOGwfUSN2nSQIle9tQ==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4

dn: CN=ms-DS-User-TGT-Lifetime,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-UserTGTLifetime
adminDisplayName: User TGT Lifetime
adminDescription: This attribute specifies the maximum age of a Kerberos TGT issued to a user in units of 10^(-7) seconds.
attributeId: 1.2.840.113556.1.4.2279
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: g8khhZn1D0K5q7EiK9+VwQ==
systemFlags: 16
instanceType: 4

dn: CN=ms-DS-Computer-Allowed-To-Authenticate-To,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ComputerAllowedToAuthenticateTo
adminDisplayName: ms-DS-Computer-Allowed-To-Authenticate-To
adminDescription: This attribute is used to determine if a computer has permission to authenticate to a service.
attributeId: 1.2.840.113556.1.4.2280
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6atbEH4Hk0e5dO8EELYlcw==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4

dn: CN=ms-DS-Computer-TGT-Lifetime,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ComputerTGTLifetime
adminDisplayName: Computer TGT Lifetime
adminDescription: This attribute specifies the maximum age of a Kerberos TGT issued to a computer in units of 10^(-7) seconds.
attributeId: 1.2.840.113556.1.4.2281
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JHWTLrnfrEykNqW32mT9Zg==
systemFlags: 16
instanceType: 4

dn: CN=ms-DS-Service-Allowed-To-Authenticate-To,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ServiceAllowedToAuthenticateTo
adminDisplayName: ms-DS-Service-Allowed-To-Authenticate-To
adminDescription: This attribute is used to determine if a service has permission to authenticate to a service.
attributeId: 1.2.840.113556.1.4.2282
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MTGX8k2bIEi03gR07zuEnw==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4

dn: CN=ms-DS-Service-Allowed-To-Authenticate-From,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ServiceAllowedToAuthenticateFrom
adminDisplayName: ms-DS-Service-Allowed-To-Authenticate-From
adminDescription: This attribute is used to determine if a service has permission to authenticate from a computer.
attributeId: 1.2.840.113556.1.4.2283
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mnDalxY3Zkmx0YOLpTw9iQ==
systemFlags: 16
RangeLower: 0
RangeUpper: 132096
instanceType: 4

dn: CN=ms-DS-Service-TGT-Lifetime,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ServiceTGTLifetime
adminDisplayName: Service TGT Lifetime
adminDescription: This attribute specifies the maximum age of a Kerberos TGT issued to a service in units of 10^(-7) seconds.
attributeId: 1.2.840.113556.1.4.2284
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IDz+XSnKfUCbq4Qh5V63XA==
systemFlags: 16
instanceType: 4

dn: CN=ms-DS-Assigned-AuthN-Policy-Silo,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AssignedAuthNPolicySilo
adminDisplayName: Assigned Authentication Policy Silo
adminDescription: This attribute specifies which AuthNPolicySilo a principal is assigned to.
attributeId: 1.2.840.113556.1.4.2285
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QcE/svUN6kqzPWz0kwd7Pw==
systemFlags: 16
instanceType: 4
linkID: 2202

dn: CN=ms-DS-Assigned-AuthN-Policy-Silo-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AssignedAuthNPolicySiloBL
adminDisplayName: Assigned Authentication Policy Silo Backlink
adminDescription: This attribute is the backlink for msDS-AssignedAuthNPolicySilo.
attributeId: 1.2.840.113556.1.4.2286
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: FAUUM3r10keOxATEZmYAxw==
systemFlags: 16
instanceType: 4
linkID: 2203

dn: CN=ms-DS-AuthN-Policy-Silo-Members,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AuthNPolicySiloMembers
adminDisplayName: Authentication Policy Silo Members
adminDescription: This attribute specifies which principals are assigned to the AuthNPolicySilo.
attributeId: 1.2.840.113556.1.4.2287
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BR5NFqZIhkio6XeiAG48dw==
systemFlags: 16
instanceType: 4
linkID: 2204

dn: CN=ms-DS-AuthN-Policy-Silo-Members-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AuthNPolicySiloMembersBL
adminDisplayName: Authentication Policy Silo Members Backlink
adminDescription: This attribute is the backlink for msDS-AuthNPolicySiloMembers.
attributeId: 1.2.840.113556.1.4.2288
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: x8v8EeT7UUm0t63fb579RA==
systemFlags: 16
instanceType: 4
linkID: 2205

dn: CN=ms-DS-User-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-UserAuthNPolicy
adminDisplayName: User Authentication Policy
adminDescription: This attribute specifies which AuthNPolicy should be applied to users assigned to this silo object.
attributeId: 1.2.840.113556.1.4.2289
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 87kmzRXUKkSPeHxhUj7pWw==
systemFlags: 16
instanceType: 4
linkID: 2206

dn: CN=ms-DS-User-AuthN-Policy-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-UserAuthNPolicyBL
adminDisplayName: User Authentication Policy Backlink
adminDescription: This attribute is the backlink for msDS-UserAuthNPolicy.
attributeId: 1.2.840.113556.1.4.2290
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: qfoXL0ddH0uXfqpS+r5lyA==
systemFlags: 16
instanceType: 4
linkID: 2207

dn: CN=ms-DS-Computer-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ComputerAuthNPolicy
adminDisplayName: Computer Authentication Policy
adminDescription: This attribute specifies which AuthNPolicy should be applied to computers assigned to this silo object.
attributeId: 1.2.840.113556.1.4.2291
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: yWO4r6O+D0Sp82FTzGaJKQ==
systemFlags: 16
instanceType: 4
linkID: 2208

dn: CN=ms-DS-Computer-AuthN-Policy-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ComputerAuthNPolicyBL
adminDisplayName: Computer Authentication Policy Backlink
adminDescription: This attribute is the backlink for msDS-ComputerAuthNPolicy.
attributeId: 1.2.840.113556.1.4.2292
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: MmLvK6EwfkWGBHr22/ExuA==
systemFlags: 16
instanceType: 4
linkID: 2209

dn: CN=ms-DS-Service-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ServiceAuthNPolicy
adminDisplayName: Service Authentication Policy
adminDescription: This attribute specifies which AuthNPolicy should be applied to services assigned to this silo object.
attributeId: 1.2.840.113556.1.4.2293
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lW1qKs4o7km7JG0fwB4xEQ==
systemFlags: 16
instanceType: 4
linkID: 2210

dn: CN=ms-DS-Service-AuthN-Policy-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ServiceAuthNPolicyBL
adminDisplayName: Service Authentication Policy Backlink
adminDescription: This attribute is the backlink for msDS-ServiceAuthNPolicy.
attributeId: 1.2.840.113556.1.4.2294
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: 7CgRLKJao0KzLfCXnKn80g==
systemFlags: 16
instanceType: 4
linkID: 2211

dn: CN=ms-DS-Assigned-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AssignedAuthNPolicy
adminDisplayName: Assigned Authentication Policy
adminDescription: This attribute specifies which AuthNPolicy should be applied to this principal.
attributeId: 1.2.840.113556.1.4.2295
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2Ap6uPdUwUmEoOZNEoU1iA==
systemFlags: 16
instanceType: 4
linkID: 2212

dn: CN=ms-DS-Assigned-AuthN-Policy-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AssignedAuthNPolicyBL
adminDisplayName: Assigned Authentication Policy Backlink
adminDescription: This attribute is the backlink for msDS-AssignedAuthNPolicy.
attributeId: 1.2.840.113556.1.4.2296
attributeSyntax: 2.5.5.1
omObjectClass:: KwwCh3McAIVK
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: PBsTLZ/T7kqBXo20vBznrA==
systemFlags: 16
instanceType: 4
linkID: 2213

dn: CN=ms-DS-AuthN-Policy-Enforced,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AuthNPolicyEnforced
adminDisplayName: Authentication Policy Enforced
adminDescription: This attribute specifies whether the authentication policy is enforced.
attributeId: 1.2.840.113556.1.4.2297
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wgxWekXsukSy1yEjatWf1Q==
instanceType: 4
systemFlags: 16

dn: CN=ms-DS-AuthN-Policy-Silo-Enforced,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AuthNPolicySiloEnforced
adminDisplayName: Authentication Policy Silo Enforced
adminDescription: This attribute specifies whether the authentication policy silo is enforced.
attributeId: 1.2.840.113556.1.4.2298
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: AhH18uBrPUmHJhVGzbyHcQ==
instanceType: 4
systemFlags: 16

dn: CN=ms-DS-AuthN-Policy-Silos,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-AuthNPolicySilos
adminDisplayName: Authentication Policy Silos
adminDescription: A container of this class can contain authentication policy silo objects.
governsId: 1.2.840.113556.1.5.291
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: Ckex0oSPHkmnUrQB7gD+XA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-AuthN-Policy-Silos,CN=Schema,CN=Configuration,DC=X
instanceType: 4
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.3.23

dn: CN=ms-DS-AuthN-Policies,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-AuthNPolicies
adminDisplayName: Authentication Policies
adminDescription: A container of this class can contain authentication policy objects.
governsId: 1.2.840.113556.1.5.293
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: Xd+aOpd7fk+rtOW1XBwGtA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-AuthN-Policies,CN=Schema,CN=Configuration,DC=X
instanceType: 4
systemFlags: 16
subClassOf: top
systemPossSuperiors: 1.2.840.113556.1.3.23

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-AuthN-Policy-Silo,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-AuthNPolicySilo
adminDisplayName: Authentication Policy Silo
adminDescription: An instance of this class defines authentication policies and related behaviors for assigned users, computers, and services.
governsId: 1.2.840.113556.1.5.292
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: Hkbw+X1piUaSmTfmHWF7DQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-AuthN-Policy-Silo,CN=Schema,CN=Configuration,DC=X
systemFlags: 16
instanceType: 4
systemmaycontain: msDS-AuthNPolicySiloMembers
systemmaycontain: msDS-UserAuthNPolicy
systemmaycontain: msDS-ComputerAuthNPolicy
systemmaycontain: msDS-ServiceAuthNPolicy
systemmaycontain: msDS-AssignedAuthNPolicySiloBL
systemmaycontain: msDS-AuthNPolicySiloEnforced
subClassOf: top
systemPossSuperiors: msDS-AuthNPolicySilos

dn: CN=ms-DS-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-AuthNPolicy
adminDisplayName: Authentication Policy
adminDescription: An instance of this class defines authentication policy behaviors for assigned principals.
governsId: 1.2.840.113556.1.5.294
objectClassCategory: 1
rdnAttId: cn
schemaIdGuid:: VhFqq8dN9UCRgI5M5C/lzQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
systemFlags: 16
instanceType: 4
systemmaycontain: msDS-UserAllowedToAuthenticateTo
systemmaycontain: msDS-UserAllowedToAuthenticateFrom
systemmaycontain: msDS-UserTGTLifetime
systemmaycontain: msDS-ComputerAllowedToAuthenticateTo
systemmaycontain: msDS-ComputerTGTLifetime
systemmaycontain: msDS-ServiceAllowedToAuthenticateTo
systemmaycontain: msDS-ServiceAllowedToAuthenticateFrom
systemmaycontain: msDS-ServiceTGTLifetime
systemmaycontain: msDS-UserAuthNPolicyBL
systemmaycontain: msDS-ComputerAuthNPolicyBL
systemmaycontain: msDS-ServiceAuthNPolicyBL
systemmaycontain: msDS-AssignedAuthNPolicyBL
systemmaycontain: msDS-AuthNPolicyEnforced
subClassOf: top
systemPossSuperiors: msDS-AuthNPolicies

dn: CN=user,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add:systemmaycontain
systemmaycontain: msDS-AssignedAuthNPolicy
systemmaycontain: msDS-AssignedAuthNPolicySilo
systemmaycontain: msDS-AuthNPolicySiloMembersBL
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 68
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-
```

### Sch69.ldf

```
dn: CN=ms-DS-AuthN-Policy-Silo,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: defaultHidingValue
defaultHidingValue: FALSE
-

dn: CN=ms-DS-AuthN-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: defaultHidingValue
defaultHidingValue: FALSE
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 69
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-
```

## Schema Updates in Windows Server 2012

Sch48.ldf through Sch56.ldf are introduced with Windows Server 2012.

### Sch48.ldf

```
dn: CN=ms-DS-Members-Of-Resource-Property-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-MembersOfResourcePropertyList
adminDisplayName: ms-DS-Members-Of-Resource-Property-List
adminDescription: For a resource property list object, this multi-valued link attribute points to one or more resource property objects.
attributeId: 1.2.840.113556.1.4.2103
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: ERw3Ta1MQUyK0rGAqyvRPA==
linkID: 2180
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Members-Of-Resource-Property-List-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-MembersOfResourcePropertyListBL
adminDisplayName: ms-DS-Members-Of-Resource-Property-List-BL
adminDescription: Backlink for ms-DS-Members-Of-Resource-Property-List. For a resource property object, this attribute references the resource property list object that it is a member of.
attributeId: 1.2.840.113556.1.4.2104
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: BLdpdLDtaEWlpVn0hix1pw==
linkID: 2181
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Claim-Value-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimValueType
adminDisplayName: ms-DS-Claim-Value-Type
adminDescription: For a claim type object, specifies the value type of the claims issued.
attributeId: 1.2.840.113556.1.4.2098
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: uRdixo7k90e31WVSuK/WGQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Possible-Values,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimPossibleValues
adminDisplayName: ms-DS-Claim-Possible-Values
adminDescription: For a claim type or resource property object, this attribute describes the values suggested to a user when the he/she use the claim type or resource property in applications.
attributeId: 1.2.840.113556.1.4.2097
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 1048576
schemaIdGuid:: 7u0oLnztP0Wv5JO9hvIXTw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Attribute-Source,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimAttributeSource
adminDisplayName: ms-DS-Claim-Attribute-Source
adminDescription: For a claim type object, this attribute points to the attribute that will be used as the source for the claim type.
attributeId: 1.2.840.113556.1.4.2099
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: PhK87ua6ZkGeWymISot2sA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Type-Applies-To-Class,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimTypeAppliesToClass
adminDisplayName: ms-DS-Claim-Type-Applies-To-Class
adminDescription: For a claim type object, this linked attribute points to the AD security principal classes that for which claims should be issued. (For example, a link to the user class).
attributeId: 1.2.840.113556.1.4.2100
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: TA77anbYfEOutsPkFFTCcg==
linkID: 2176
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Shares-Possible-Values-With,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimSharesPossibleValuesWith
adminDisplayName: ms-DS-Claim-Shares-Possible-Values-With
adminDescription: For a resource property object, this attribute indicates that the suggested values of the claims issued are defined on the object that this linked attribute points to. Overrides ms-DS-Claim-Possible-Values on itself, if populated.
attributeId: 1.2.840.113556.1.4.2101
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: OtHIUgvOV0+JKxj1pDokAA==
linkID: 2178
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Shares-Possible-Values-With-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimSharesPossibleValuesWithBL
adminDisplayName: ms-DS-Claim-Shares-Possible-Values-With-BL
adminDescription: For a claim type object, this attribute indicates that the possible values described in ms-DS-Claim-Possible-Values are being referenced by other claim type objects.
attributeId: 1.2.840.113556.1.4.2102
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 2yLVVJXs9UibvRiA67shgA==
linkID: 2179
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Is-Used-As-Resource-Security-Attribute,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-IsUsedAsResourceSecurityAttribute
adminDisplayName: ms-DS-Is-Used-As-Resource-Security-Attribute
adminDescription: For a resource property, this attribute indicates whether it is being used as a secure attribute.
attributeId: 1.2.840.113556.1.4.2095
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: nfjJUTBHjUaitR1JMhLRfg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-KMS-Ids,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-KMSIds
adminDisplayName: ms-SPP-KMS-Ids
adminDescription: KMS IDs enabled by the Activation Object
attributeId: 1.2.840.113556.1.4.2082
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
rangeLower: 16
rangeUpper: 16
schemaIdGuid:: 2j5mm0I11kad8DFAJa8rrA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-CSVLK-Pid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-CSVLKPid
adminDisplayName: ms-SPP-CSVLK-Pid
adminDescription: ID of CSVLK product-key used to create the Activation Object
attributeId: 1.2.840.113556.1.4.2105
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 512
schemaIdGuid:: DVF/tFBr4Ue1VncseeT/xA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-CSVLK-Sku-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-CSVLKSkuId
adminDisplayName: ms-SPP-CSVLK-Sku-Id
adminDescription: SKU ID of CSVLK product-key used to create the Activation Object
attributeId: 1.2.840.113556.1.4.2081
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 16
rangeUpper: 16
schemaIdGuid:: OfeElnh7bUeNdDGtdpLu9A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-Phone-License,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-PhoneLicense
adminDisplayName: ms-SPP-Phone-License
adminDescription: License used during phone activation of the Active Directory forest
attributeId: 1.2.840.113556.1.4.2086
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 5242880
schemaIdGuid:: EtnkZ2LzUkCMeUL0W6eyIQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-Config-License,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-ConfigLicense
adminDisplayName: ms-SPP-Config-License
adminDescription: Product-key configuration license used during online/phone activation of the Active Directory forest
attributeId: 1.2.840.113556.1.4.2087
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 5242880
schemaIdGuid:: tcRTA5nRsECzxd6zL9nsBg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-Online-License,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-OnlineLicense
adminDisplayName: ms-SPP-Online-License
adminDescription: License used during online activation of the Active Directory forest
attributeId: 1.2.840.113556.1.4.2085
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 5242880
schemaIdGuid:: jjaPCRJIzUivt6E2uWgH7Q==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-Confirmation-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-ConfirmationId
adminDisplayName: ms-SPP-Confirmation-Id
adminDescription: Confirmation ID (CID) used for phone activation of the Active Directory forest
attributeId: 1.2.840.113556.1.4.2084
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 512
schemaIdGuid:: xJeHbtqsSUqHQLC9Bam4MQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-Installation-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-InstallationId
adminDisplayName: ms-SPP-Installation-Id
adminDescription: Installation ID (IID) used for phone activation of the Active Directory forest
attributeId: 1.2.840.113556.1.4.2083
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 512
schemaIdGuid:: FLG/aXtAOUeiE8ZjgCs+Nw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-Issuance-License,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-IssuanceLicense
adminDisplayName: ms-SPP-Issuance-License
adminDescription: Issuance license used during online/phone activation of the Active Directory forest
attributeId: 1.2.840.113556.1.4.2088
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 5242880
schemaIdGuid:: obN1EK+70kmujcTyXIIzAw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-SPP-CSVLK-Partial-Product-Key,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msSPP-CSVLKPartialProductKey
adminDisplayName: ms-SPP-CSVLK-Partial-Product-Key
adminDescription: Last 5 characters of CSVLK product-key used to create the Activation Object
attributeId: 1.2.840.113556.1.4.2106
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 5
rangeUpper: 5
schemaIdGuid:: kbABplKGOkWzhoetI5t8CA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TPM-Srk-Pub-Thumbprint,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTPM-SrkPubThumbprint
adminDisplayName: TPM-SrkPubThumbprint
adminDescription: This attribute contains the thumbprint of the SrkPub corresponding to a particular TPM. This helps to index the TPM devices in the directory.
attributeId: 1.2.840.113556.1.4.2107
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 11
rangeUpper: 20
schemaIdGuid:: 6wbXGXZNokSF1hw0K+O+Nw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TPM-Owner-Information-Temp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTPM-OwnerInformationTemp
adminDisplayName: TPM-OwnerInformationTemp
adminDescription: This attribute contains temporary owner information for a particular TPM.
attributeId: 1.2.840.113556.1.4.2108
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
rangeUpper: 128
schemaIdGuid:: nYCUyBO1+E+IEfT0P1rHvA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TPM-Tpm-Information-For-Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTPM-TpmInformationForComputer
adminDisplayName: TPM-TpmInformationForComputer
adminDescription: This attribute links a Computer object to a TPM object.
attributeId: 1.2.840.113556.1.4.2109
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 16
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: k3sb6khe1Ua8bE30/aeKNQ==
linkID: 2182
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TPM-Tpm-Information-For-Computer-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTPM-TpmInformationForComputerBL
adminDisplayName: TPM-TpmInformationForComputerBL
adminDescription: This attribute links a TPM object to the Computer objects associated with it.
attributeId: 1.2.840.113556.1.4.2110
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: yYT6FM2OSEO8kW087Ucqtw==
linkID: 2183
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Claim-Types,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ClaimTypes
adminDisplayName: ms-DS-Claim-Types
adminDescription: A container of this class can contain claim type objects.
governsId: 1.2.840.113556.1.5.270
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: NTIJNhXHIUirarVvsoBaWA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Claim-Types,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Resource-Property-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ResourcePropertyList
adminDisplayName: ms-DS-Resource-Property-List
adminDescription: An object of this class contains a list of resource properties.
governsId: 1.2.840.113556.1.5.274
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.2103
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: etTjckKzRU2PVrr/gDyr+Q==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Resource-Property-List,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Resource-Properties,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ResourceProperties
adminDisplayName: ms-DS-Resource-Properties
adminDescription: A container of this class can contain resource properties.
governsId: 1.2.840.113556.1.5.271
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: hEVKelCzj0es1rS4UtgswA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Resource-Properties,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Claim-Type-Property-Base,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ClaimTypePropertyBase
adminDisplayName: ms-DS-Claim-Type-Property-Base
adminDescription: An abstract class that defines the base class for claim type or resource property classes.
governsId: 1.2.840.113556.1.5.269
objectClassCategory: 2
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.2101
systemMayContain: 1.2.840.113556.1.2.557
systemMayContain: 1.2.840.113556.1.4.2097
schemaIdGuid:: WC9EuJDEh0SKndgLiDJxrQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Claim-Type-Property-Base,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Resource-Property,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ResourceProperty
adminDisplayName: ms-DS-Resource-Property
adminDescription: An instance of this class holds the definition of a property on resources.
governsId: 1.2.840.113556.1.5.273
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.269
systemMayContain: 1.2.840.113556.1.4.2095
systemPossSuperiors: 1.2.840.113556.1.5.271
schemaIdGuid:: Xj0oWwSElUGTOYRQGIxQGg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Resource-Property,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Claim-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ClaimType
adminDisplayName: ms-DS-Claim-Type
adminDescription: An instance of this class holds the definition of a claim type that can be defined on security principals.
governsId: 1.2.840.113556.1.5.272
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.269
systemMayContain: 1.2.840.113556.1.4.2100
systemMayContain: 1.2.840.113556.1.4.2099
systemPossSuperiors: 1.2.840.113556.1.5.270
schemaIdGuid:: fIWjgWlUj02q5sJ2mXYmBA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Claim-Type,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-SPP-Activation-Objects-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msSPP-ActivationObjectsContainer
adminDisplayName: ms-SPP-Activation-Objects-Container
adminDescription: Container for Activation Objects used by Active Directory based activation
governsId: 1.2.840.113556.1.5.266
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: K4YvtyW7XU2qUWLFm9+Qrg==
defaultSecurityDescriptor: O:BAG:BAD: (A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: FALSE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-SPP-Activation-Objects-Container,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-SPP-Activation-Object,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msSPP-ActivationObject
adminDisplayName: ms-SPP-Activation-Object
adminDescription: Activation Object used in Active Directory based activation
governsId: 1.2.840.113556.1.5.267
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.2082
systemMustContain: 1.2.840.113556.1.4.2081
systemMustContain: 1.2.840.113556.1.4.2106
systemMustContain: 1.2.840.113556.1.4.2105
systemMayContain: 1.2.840.113556.1.4.2088
systemMayContain: 1.2.840.113556.1.4.2087
systemMayContain: 1.2.840.113556.1.4.2086
systemMayContain: 1.2.840.113556.1.4.2085
systemMayContain: 1.2.840.113556.1.4.2084
systemMayContain: 1.2.840.113556.1.4.2083
systemPossSuperiors: 1.2.840.113556.1.5.266
schemaIdGuid:: jOagUcUNykOTXcHJEb8u5Q==
defaultSecurityDescriptor: O:BAG:BAD: (A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: FALSE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-SPP-Activation-Object,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-TPM-Information-Objects-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msTPM-InformationObjectsContainer
adminDisplayName: TPM-InformationObjectsContainer
adminDescription: Container for TPM objects.
governsId: 1.2.840.113556.1.5.276
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemPossSuperiors: 1.2.840.113556.1.5.67
systemPossSuperiors: 1.2.840.113556.1.5.66
schemaIdGuid:: vagn4FZk3kWQozhZOHfudA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;LOLCCCRP;;;DC)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-TPM-Information-Objects-Container,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-TPM-Information-Object,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msTPM-InformationObject
adminDisplayName: TPM-InformationObject
adminDescription: This class contains recovery information for a Trusted Platform Module (TPM) device.
governsId: 1.2.840.113556.1.5.275
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1966
systemMayContain: 1.2.840.113556.1.4.2108
systemMayContain: 1.2.840.113556.1.4.2107
systemPossSuperiors: 1.2.840.113556.1.5.276
schemaIdGuid:: alsEhaZHQ0KnzGiQcB9mLA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLO;;;DC)(A;;WP;;;CO)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-TPM-Information-Object,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2102
systemMayContain: 1.2.840.113556.1.4.2104
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2109
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 48
-
```

### Sch49.ldf

```
dn: CN=ms-DNS-Is-Signed,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-IsSigned
adminDisplayName: ms-DNS-Is-Signed
adminDescription: An attribute used to define whether or not the DNS zone is signed.
attributeId: 1.2.840.113556.1.4.2130
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: TIUSqvzYXk2RyjaLjYKb7g==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-NSEC3-OptOut,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-NSEC3OptOut
adminDisplayName: ms-DNS-NSEC3-OptOut
adminDescription: An attribute used to define whether or not the DNS zone should be signed using NSEC opt-out.
attributeId: 1.2.840.113556.1.4.2132
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: iCDqe+KMPEKxkWbsUGsVlQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Signing-Keys,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-SigningKeys
adminDisplayName: ms-DNS-Signing-Keys
adminDescription: An attribute that contains the set of encrypted DNSSEC signing keys used by the DNS server to sign the DNS zone.
attributeId: 1.2.840.113556.1.4.2144
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 8
rangeUpper: 10000
schemaIdGuid:: bT5nt9nKnk6zGmPoCY/dYw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Sign-With-NSEC3,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-SignWithNSEC3
adminDisplayName: ms-DNS-Sign-With-NSEC3
adminDescription: An attribute used to define whether or not the DNS zone is signed with NSEC3.
attributeId: 1.2.840.113556.1.4.2131
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: mSGfx6Ft/0aSPB8/gAxyHg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-NSEC3-User-Salt,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-NSEC3UserSalt
adminDisplayName: ms-DNS-NSEC3-User-Salt
adminDescription: An attribute that defines a user-specified NSEC3 salt string to use when signing the DNS zone. If empty, random salt will be used.
attributeId: 1.2.840.113556.1.4.2148
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 510
schemaIdGuid:: cGfxryKWvE+hKDCId3YFuQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-DNSKEY-Records,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-DNSKEYRecords
adminDisplayName: ms-DNS-DNSKEY-Records
adminDescription: An attribute that contains the DNSKEY record set for the root of the DNS zone and the root key signing key signature records.
attributeId: 1.2.840.113556.1.4.2145
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 8
rangeUpper: 10000
schemaIdGuid:: 9VjEKC1gyUqnfLPxvlA6fg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-DS-Record-Set-TTL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-DSRecordSetTTL
adminDisplayName: ms-DNS-DS-Record-Set-TTL
adminDescription: An attribute that defines the time-to-live (TTL) value assigned to DS records when signing the DNS zone.
attributeId: 1.2.840.113556.1.4.2140
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 2592000
schemaIdGuid:: fJuGKcRk/kKX1fvC+hJBYA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Keymaster-Zones,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-KeymasterZones
adminDisplayName: ms-DNS-Keymaster-Zones
adminDescription: A list of Active Directory-integrated zones for which the DNS server is the keymaster.
attributeId: 1.2.840.113556.1.4.2128
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: O93gCxoEjEGs6S8X0j6dQg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-NSEC3-Iterations,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-NSEC3Iterations
adminDisplayName: ms-DNS-NSEC3-Iterations
adminDescription: An attribute that defines how many NSEC3 hash iterations to perform when signing the DNS zone.
attributeId: 1.2.840.113556.1.4.2138
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 10000
schemaIdGuid:: qwq3gFmJwE6OkxJudt86yg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Propagation-Time,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-PropagationTime
adminDisplayName: ms-DNS-Propagation-Time
adminDescription: An attribute used to define in seconds the expected time required to propagate zone changes through Active Directory.
attributeId: 1.2.840.113556.1.4.2147
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: Rw00uoEhoEyi9vrkR52rKg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-NSEC3-Current-Salt,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-NSEC3CurrentSalt
adminDisplayName: ms-DNS-NSEC3-Current-Salt
adminDescription: An attribute that defines the current NSEC3 salt string being used to sign the DNS zone.
attributeId: 1.2.840.113556.1.4.2149
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 510
schemaIdGuid:: MpR9ONGmdESCzQqJquCErg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-RFC5011-Key-Rollovers,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-RFC5011KeyRollovers
adminDisplayName: ms-DNS-RFC5011-Key-Rollovers
adminDescription: An attribute that defines whether or not the DNS zone should be maintained using key rollover procedures defined in RFC 5011.
attributeId: 1.2.840.113556.1.4.2135
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: QDzZJ1oGwEO92M3yx9Egqg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-NSEC3-Hash-Algorithm,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-NSEC3HashAlgorithm
adminDisplayName: ms-DNS-NSEC3-Hash-Algorithm
adminDescription: An attribute that defines the NSEC3 hash algorithm to use when signing the DNS zone.
attributeId: 1.2.840.113556.1.4.2136
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: UlWe/7d9OEGIiAXOMgoDIw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-DS-Record-Algorithms,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-DSRecordAlgorithms
adminDisplayName: ms-DNS-DS-Record-Algorithms
adminDescription: An attribute used to define the algorithms used when writing the dsset file during zone signing.
attributeId: 1.2.840.113556.1.4.2134
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: 0npbXPogu0S+szS5wPZVeQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-DNSKEY-Record-Set-TTL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-DNSKEYRecordSetTTL
adminDisplayName: ms-DNS-DNSKEY-Record-Set-TTL
adminDescription: An attribute that defines the time-to-live (TTL) value assigned to DNSKEY records when signing the DNS zone.
attributeId: 1.2.840.113556.1.4.2139
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 2592000
schemaIdGuid:: fzFOj9coLESm3x9JH5ezJg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Maintain-Trust-Anchor,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-MaintainTrustAnchor
adminDisplayName: ms-DNS-Maintain-Trust-Anchor
adminDescription: An attribute used to define the type of trust anchor to automatically publish in the forest-wide trust anchor store when the DNS zone is signed.
attributeId: 1.2.840.113556.1.4.2133
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: wWPADdlSVkSeFZwkNKr9lA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-NSEC3-Random-Salt-Length,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-NSEC3RandomSaltLength
adminDisplayName: ms-DNS-NSEC3-Random-Salt-Length
adminDescription: An attribute that defines the length in bytes of the random salt used when signing the DNS zone.
attributeId: 1.2.840.113556.1.4.2137
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 255
schemaIdGuid:: ZRY2E2yR502lnbHrvQ3hKQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Signing-Key-Descriptors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-SigningKeyDescriptors
adminDisplayName: ms-DNS-Signing-Key-Descriptors
adminDescription: An attribute that contains the set of DNSSEC Signing Key Descriptors (SKDs) used by the DNS server to generate keys and sign the DNS zone.
attributeId: 1.2.840.113556.1.4.2143
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 8
rangeUpper: 10000
schemaIdGuid:: zdhDNLblO0+wmGWaAhSgeQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Signature-Inception-Offset,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-SignatureInceptionOffset
adminDisplayName: ms-DNS-Signature-Inception-Offset
adminDescription: An attribute that defines in seconds how far in the past DNSSEC signature validity periods should begin when signing the DNS zone.
attributeId: 1.2.840.113556.1.4.2141
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 2592000
schemaIdGuid:: LsPUAxfiYUqWmXu8RymgJg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Parent-Has-Secure-Delegation,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-ParentHasSecureDelegation
adminDisplayName: ms-DNS-Parent-Has-Secure-Delegation
adminDescription: An attribute used to define whether the parental delegation to the DNS zone is secure.
attributeId: 1.2.840.113556.1.4.2146
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
schemaIdGuid:: ZGlcKBrBnkmW2L98daIjxg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DNS-Secure-Delegation-Polling-Period,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDNS-SecureDelegationPollingPeriod
adminDisplayName: ms-DNS-Secure-Delegation-Polling-Period
adminDescription: An attribute that defines in seconds the time between polling attempts for child zone key rollovers.
attributeId: 1.2.840.113556.1.4.2142
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 8
rangeLower: 0
rangeUpper: 2592000
schemaIdGuid:: vvCw9uSoaESP2cPEe4ci+Q==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Member-Rules-In-Central-Access-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-MemberRulesInCentralAccessPolicy
adminDisplayName: ms-Authz-Member-Rules-In-Central-Access-Policy
adminDescription: For a central access policy, this attribute identifies the central access rules that comprise the policy.
attributeId: 1.2.840.113556.1.4.2155
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: ei/yV343w0KYcs7G8h0uPg==
linkID: 2184
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Member-Rules-In-Central-Access-Policy-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-MemberRulesInCentralAccessPolicyBL
adminDisplayName: ms-Authz-Member-Rules-In-Central-Access-Policy-BL
adminDescription: Backlink for ms-Authz-Member-Rules-In-Central-Access-Policy. For a central access rule object, this attribute references one or more central access policies that point to it.
attributeId: 1.2.840.113556.1.4.2156
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: z2duUd3+lES7OrxQapSIkQ==
linkID: 2185
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Claim-Source,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimSource
adminDisplayName: ms-DS-Claim-Source
adminDescription: For a claim type, this attribute indicates the source of the claim type. For example, the source can be certificate.
attributeId: 1.2.840.113556.1.4.2157
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pvIy+ovy0Ee/kWY+j5EKcg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Proposed-Security-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-ProposedSecurityPolicy
adminDisplayName: ms-Authz-Proposed-Security-Policy
adminDescription: For a Central Access Policy Entry, defines the proposed security policy of the objects the CAPE is applied to.
attributeId: 1.2.840.113556.1.4.2151
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: zr5GubUJakuyWktjozDoDg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Source-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimSourceType
adminDisplayName: ms-DS-Claim-Source-Type
adminDescription: For a security principal claim type, lists the type of store the issued claim is sourced from
attributeId: 1.2.840.113556.1.4.2158
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BZzxkvqNIkK70SxPAUh3VA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Effective-Security-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-EffectiveSecurityPolicy
adminDisplayName: ms-Authz-Security-Policy
adminDescription: For a central access rule, this attribute defines the permission that is applying to the target resources on the central access rule.
attributeId: 1.2.840.113556.1.4.2150
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: GRmDB5SPtk+KQpFUXcza0w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Is-Single-Valued,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimIsSingleValued
adminDisplayName: ms-DS-Claim-Is-Single-Valued
adminDescription: For a claim type object, this attribute identifies if the claim type or resource property can only contain single value.
attributeId: 1.2.840.113556.1.4.2160
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: uZ94zbSWSEaCGco3gWGvOA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Last-Effective-Security-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-LastEffectiveSecurityPolicy
adminDisplayName: ms-Authz-Last-Effective-Security-Policy
adminDescription: For a Central Access Policy Entry, defines the security policy that was last applied to the objects the CAPE is applied to.
attributeId: 1.2.840.113556.1.4.2152
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xoUWji8+okiljVrw6nifoA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Resource-Condition,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-ResourceCondition
adminDisplayName: ms-Authz-Resource-Condition
adminDescription: For a central access rule, this attribute is an expression that identifies the scope of the target resource to which the policy applies.
attributeId: 1.2.840.113556.1.4.2153
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: d3iZgHT4aEyGTW5QioO9vQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Claim-Is-Value-Space-Restricted,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ClaimIsValueSpaceRestricted
adminDisplayName: ms-DS-Claim-Is-Value-Space-Restricted
adminDescription: For a claim type, this attribute identifies whether a user can input values other than those described in the msDS-ClaimPossibleValues in applications.
attributeId: 1.2.840.113556.1.4.2159
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: x+QsDMPxgkSFeMYNS7dEIg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Authz-Central-Access-Policy-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msAuthz-CentralAccessPolicyID
adminDisplayName: ms-Authz-Central-Access-Policy-ID
adminDescription: For a Central Access Policy, this attribute defines a GUID that can be used to identify the set of policies when applied to a resource.
attributeId: 1.2.840.113556.1.4.2154
attributeSyntax: 2.5.5.17
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YJvyYnS+MEaUVi9mkZk6hg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Generation-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-GenerationId
adminDisplayName: ms-DS-Generation-Id
adminDescription: For virtual machine snapshot resuming detection. This attribute represents the VM Generation ID.
attributeId: 1.2.840.113556.1.4.2166
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
rangeLower: 16
rangeUpper: 16
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: PTldHreMT0uECpc7NswJww==
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Claim-Shares-Possible-Values-With,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDescription
adminDescription: For a claim type object, indicates that the possible values of the claims issued are defined on the object this linked attribute points to; overrides msDS-ClaimPossibleValues, msDS-ClaimValueType, and msDS-ClaimIsValueSpaceRestricted, if populated.
-
replace: isSingleValued
isSingleValued: TRUE
-

dn: CN=ms-DNS-Server-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDNS-ServerSettings
adminDisplayName: ms-DNS-Server-Settings
adminDescription: A container for storing DNS server settings.
governsId: 1.2.840.113556.1.4.2129
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.2128
systemPossSuperiors: 1.2.840.113556.1.5.17
schemaIdGuid:: 7cMv7xhuW0GZ5DEUqMsSSw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DNS-Server-Settings,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-Authz-Central-Access-Policies,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msAuthz-CentralAccessPolicies
adminDisplayName: ms-Authz-Central-Access-Policies
adminDescription: A container of this class can contain Central Access Policy objects.
governsId: 1.2.840.113556.1.4.2161
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: wyFcVTahWkWTl3lrvTWOJQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-Authz-Central-Access-Policies,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-Authz-Central-Access-Rules,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msAuthz-CentralAccessRules
adminDisplayName: ms-Authz-Central-Access-Rules
adminDescription: A container of this class can contain Central Access Policy Entry objects.
governsId: 1.2.840.113556.1.4.2162
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: ehu7mW1gi0+ADuFb5VTKjQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-Authz-Central-Access-Rules,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-Authz-Central-Access-Rule,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msAuthz-CentralAccessRule
adminDisplayName: ms-Authz-Central-Access-Rule
adminDescription: A class that defines Central Access Rules used to construct a central access policy.
governsId: 1.2.840.113556.1.4.2163
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.2153
systemMayContain: 1.2.840.113556.1.4.2152
systemMayContain: 1.2.840.113556.1.4.2151
systemMayContain: 1.2.840.113556.1.4.2150
systemMayContain: 1.2.840.113556.1.2.557
systemPossSuperiors: 1.2.840.113556.1.4.2162
schemaIdGuid:: 3AZKWxwl206IEwvdcTJyJg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-Authz-Central-Access-Rule,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-Authz-Central-Access-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msAuthz-CentralAccessPolicy
adminDisplayName: ms-Authz-Central-Access-Policy
adminDescription: A class that defines Central Access Policy objects.
governsId: 1.2.840.113556.1.4.2164
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.2155
systemMayContain: 1.2.840.113556.1.4.2154
systemPossSuperiors: 1.2.840.113556.1.4.2161
schemaIdGuid:: sJxnpZ1vLEOLdR4+g08Cqg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-Authz-Central-Access-Policy,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Claim-Types,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=ms-DS-Resource-Properties,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=ms-DS-List-Of-Claim-Types,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=ms-DS-Claim-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2157
systemMayContain: 1.2.840.113556.1.4.2158
systemMayContain: 1.2.840.113556.1.4.2098
systemMayContain: 1.2.840.113556.1.4.2159
systemMayContain: 1.2.840.113556.1.4.2160
-

dn: CN=Dns-Zone,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2130
systemMayContain: 1.2.840.113556.1.4.2131
systemMayContain: 1.2.840.113556.1.4.2132
systemMayContain: 1.2.840.113556.1.4.2133
systemMayContain: 1.2.840.113556.1.4.2134
systemMayContain: 1.2.840.113556.1.4.2135
systemMayContain: 1.2.840.113556.1.4.2136
systemMayContain: 1.2.840.113556.1.4.2137
systemMayContain: 1.2.840.113556.1.4.2138
systemMayContain: 1.2.840.113556.1.4.2139
systemMayContain: 1.2.840.113556.1.4.2140
systemMayContain: 1.2.840.113556.1.4.2141
systemMayContain: 1.2.840.113556.1.4.2142
systemMayContain: 1.2.840.113556.1.4.2143
systemMayContain: 1.2.840.113556.1.4.2144
systemMayContain: 1.2.840.113556.1.4.2145
systemMayContain: 1.2.840.113556.1.4.2146
systemMayContain: 1.2.840.113556.1.4.2147
systemMayContain: 1.2.840.113556.1.4.2148
systemMayContain: 1.2.840.113556.1.4.2149
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2166
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=DS-Clone-Domain-Controller,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
displayName: Allow a DC to create a clone of itself
rightsGuid: 3e0f7e18-2c7a-4c10-ba82-4d926db99a3e
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
validAccesses: 256
localizationDisplayId: 80

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 49
-
```

### Sch50.ldf

```
dn: CN=ms-DS-Allowed-To-Act-On-Behalf-Of-Other-Identity,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AllowedToActOnBehalfOfOtherIdentity
adminDisplayName: ms-DS-Allowed-To-Act-On-Behalf-Of-Other-Identity
adminDescription: This attribute is used for access checks to determine if a requester has permission to act on the behalf of other identities to services running as this account.
attributeId: 1.2.840.113556.1.4.2182
attributeSyntax: 2.5.5.15
omSyntax: 66
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
rangeLower: 0
rangeUpper: 132096
schemaIdGuid:: 5cN4P5r3vUaguJ0YEW3ceQ==
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-Version
adminDisplayName: ms-Kds-Version
adminDescription: Version number of this root key.
attributeId: 1.2.840.113556.1.4.2176
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
schemaIdGuid:: QHPw1bDmSh6Xvg0zGL2dsQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-DomainID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-DomainID
adminDisplayName: ms-Kds-DomainID
adminDescription: Distinguished name of the Domain Controller which generated this root key.
attributeId: 1.2.840.113556.1.4.2177
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: ggRAlgfPTOmQ6PLvxPBJXg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-KDF-Param,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-KDFParam
adminDisplayName: ms-Kds-KDF-Param
adminDescription: Parameters for the key derivation algorithm.
attributeId: 1.2.840.113556.1.4.2170
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
rangeUpper: 2000
schemaIdGuid:: cgeAirj0TxW0HC5Cce/3pw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-CreateTime,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-CreateTime
adminDisplayName: ms-Kds-CreateTime
adminDescription: The time when this root key was created.
attributeId: 1.2.840.113556.1.4.2179
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
schemaIdGuid:: nxEYrpBjRQCzLZfbxwGu9w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-RootKeyData,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-RootKeyData
adminDisplayName: ms-Kds-RootKeyData
adminDescription: Root key.
attributeId: 1.2.840.113556.1.4.2175
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
rangeUpper: 128
schemaIdGuid:: J3xiJqIIQAqhsY3OhbQpkw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Primary-Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-PrimaryComputer
adminDisplayName: ms-DS-Primary-Computer
adminDescription: For a user or group object, identifies the primary computers.
attributeId: 1.2.840.113556.1.4.2167
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 4vQ9obDb60yCi4suFD6egQ==
linkID: 2186
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 16

dn: CN=ms-Kds-UseStartTime,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-UseStartTime
adminDisplayName: ms-Kds-UseStartTime
adminDescription: The time after which this root key may be used.
attributeId: 1.2.840.113556.1.4.2178
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
schemaIdGuid:: fwTcbCL1SreanNlayM39og==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Imaging-Hash-Algorithm,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msImaging-HashAlgorithm
adminDisplayName: ms-Imaging-Hash-Algorithm
adminDescription: Contains the name of the hash algorithm used to create the Thumbprint Hash for the Scan Repository/Secure Print Device.
attributeId: 1.2.840.113556.1.4.2181
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 64
schemaIdGuid:: tQ3nigZklkGS/vO7VXUgpw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-KDF-AlgorithmID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-KDFAlgorithmID
adminDisplayName: ms-Kds-KDF-AlgorithmID
adminDescription: The algorithm name of the key derivation function used to compute keys.
attributeId: 1.2.840.113556.1.4.2169
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
rangeUpper: 200
schemaIdGuid:: skgs203RTuyfWK1XnYtEDg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Imaging-Thumbprint-Hash,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msImaging-ThumbprintHash
adminDisplayName: ms-Imaging-Thumbprint-Hash
adminDescription: Contains a hash of the security certificate for the Scan Repository/Secure Print Device.
attributeId: 1.2.840.113556.1.4.2180
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 1024
schemaIdGuid:: xdvfnAQDaUWV9sT2Y/5a5g==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-PublicKey-Length,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-PublicKeyLength
adminDisplayName: ms-Kds-PublicKey-Length
adminDescription: The length of the secret agreement public key.
attributeId: 1.2.840.113556.1.4.2173
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
schemaIdGuid:: cPQ44805SUWrW/afnlg/4A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-PrivateKey-Length,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-PrivateKeyLength
adminDisplayName: ms-Kds-PrivateKey-Length
adminDescription: The length of the secret agreement private key.
attributeId: 1.2.840.113556.1.4.2174
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
schemaIdGuid:: oUJfYec3SBGg3TAH4Jz8gQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Is-Primary-Computer-For,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-IsPrimaryComputerFor
adminDisplayName: ms-DS-Is-Primary-Computer-For
adminDescription: Backlink attribute for msDS-IsPrimaryComputer.
attributeId: 1.2.840.113556.1.4.2168
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: rAaMmYc/TkSl3xGwPcilDA==
linkID: 2187
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-Kds-SecretAgreement-Param,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-SecretAgreementParam
adminDisplayName: ms-Kds-SecretAgreement-Param
adminDescription: The parameters for the secret agreement algorithm.
attributeId: 1.2.840.113556.1.4.2172
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
rangeUpper: 2000
schemaIdGuid:: MLCZ2e3+dUm4B+ukRNp56Q==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Kds-SecretAgreement-AlgorithmID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msKds-SecretAgreementAlgorithmID
adminDisplayName: ms-Kds-SecretAgreement-AlgorithmID
adminDescription: The name of the secret agreement algorithm to be used with public keys.
attributeId: 1.2.840.113556.1.4.2171
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 640
rangeUpper: 200
schemaIdGuid:: XZcCF14iSsuxXQ2uqLXpkA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Value-Type-Reference,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ValueTypeReference
adminDisplayName: ms-DS-Value-Type-Reference
adminDescription: This attribute is used to link a resource property object to its value type.
attributeId: 1.2.840.113556.1.4.2187
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: hF38eNzBSDGJhFj3ktQdPg==
linkID: 2188
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Value-Type-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ValueTypeReferenceBL
adminDisplayName: ms-DS-Value-Type-Reference-BL
adminDescription: This is the back link for ms-DS-Value-Type-Reference. It links a value type object back to resource properties.
attributeId: 1.2.840.113556.1.4.2188
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: rUNVq6EjRTu5N5sxPVR0qA==
linkID: 2189
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Is-Possible-Values-Present,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-IsPossibleValuesPresent
adminDisplayName: ms-DS-Is-Possible-Values-Present
adminDescription: This attribute identifies if ms-DS-Claim-Possible-Values on linked resource property must have value or must not have value.
attributeId: 1.2.840.113556.1.4.2186
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: 2tyrb1OMTyCxpJ3wxnwetA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-Kds-Prov-RootKey,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msKds-ProvRootKey
adminDisplayName: ms-Kds-Prov-RootKey
adminDescription: Root keys for the Group Key Distribution Service.
governsId: 1.2.840.113556.1.5.278
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.2179
systemMustContain: 1.2.840.113556.1.4.2175
systemMustContain: 1.2.840.113556.1.4.2174
systemMustContain: 1.2.840.113556.1.4.2173
systemMustContain: 1.2.840.113556.1.4.2171
systemMustContain: 1.2.840.113556.1.4.2169
systemMustContain: 1.2.840.113556.1.4.2178
systemMustContain: 1.2.840.113556.1.4.2177
systemMustContain: 1.2.840.113556.1.4.2176
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.4.2172
systemMayContain: 1.2.840.113556.1.4.2170
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: Qf0CquAXGE+Gh7Ijlklzaw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-Kds-Prov-RootKey,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-Kds-Prov-ServerConfiguration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msKds-ProvServerConfiguration
adminDisplayName: ms-Kds-Prov-ServerConfiguration
adminDescription: Configuration for the Group Key Distribution Service.
governsId: 1.2.840.113556.1.5.277
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.2176
systemMayContain: 1.2.840.113556.1.4.2174
systemMayContain: 1.2.840.113556.1.4.2173
systemMayContain: 1.2.840.113556.1.4.2172
systemMayContain: 1.2.840.113556.1.4.2171
systemMayContain: 1.2.840.113556.1.4.2170
systemMayContain: 1.2.840.113556.1.4.2169
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: qEPyXiUqpkWLcwinGuZ3zg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-Kds-Prov-ServerConfiguration,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2168
systemMayContain: 1.2.840.113556.1.4.2188
-

dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2167
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2167
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2180
systemMayContain: 1.2.840.113556.1.4.2181
-

dn: CN=Organizational-Person,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2182
-

dn: CN=ms-DS-Resource-Property,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.2187
-

dn: CN=ms-DS-Value-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ValueType
adminDisplayName: ms-DS-Value-Type
adminDescription: An value type object holds value type information for a resource property.
governsId: 1.2.840.113556.1.5.279
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.2186
systemMustContain: 1.2.840.113556.1.4.2160
systemMustContain: 1.2.840.113556.1.4.2159
systemMustContain: 1.2.840.113556.1.4.2098
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 33/C4x2wTk+H5wVu7w65Ig==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Value-Type,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Validated-MS-DS-Behavior-Version,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
rightsGuid: d31a8757-2447-4545-8081-3bb610cacbf2
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Validated write to MS DS behavior version
localizationDisplayId: 81
validAccesses: 8
showInAdvancedViewOnly: TRUE

dn: CN=Validated-MS-DS-Additional-DNS-Host-Name,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
rightsGuid: 80863791-dbe9-4eb8-837e-7f0ab55d9ac7
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
displayName: Validated write to MS DS Additional DNS Host Name
localizationDisplayId: 82
validAccesses: 8
showInAdvancedViewOnly: TRUE

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 50
-
```

### Sch51.ldf

```
dn: CN=ms-DS-Transformation-Rules,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-TransformationRules
adminDisplayName: ms-DS-Transformation-Rules
adminDescription: Specifies the Transformation Rules for Across-Forest Claims Transformation.
attributeId: 1.2.840.113556.1.4.2189
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: cSuHVbLESDuuUUCV+R7GAA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Applies-To-Resource-Types,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-AppliesToResourceTypes
adminDisplayName: ms-DS-Applies-To-Resource-Types
adminDescription: For a resource property, this attribute indicates what resource types this resource property applies to.
attributeId: 1.2.840.113556.1.4.2195
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BiA/aWRXSj2EOVjwSqtLWQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Transformation-Rules-Compiled,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-TransformationRulesCompiled
adminDisplayName: ms-DS-Transformation-Rules-Compiled
adminDescription: Blob containing compiled transformation rules.
attributeId: 1.2.840.113556.1.4.2190
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 128
schemaIdGuid:: EJq0C2tTTbyicwurDdS9EA==
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Egress-Claims-Transformation-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-EgressClaimsTransformationPolicy
adminDisplayName: ms-DS-Egress-Claims-Transformation-Policy
adminDescription: This is a link to a Claims Transformation Policy Object for the egress claims (claims leaving this forest) to the Trusted Domain. This is applicable only for an incoming or bidirectional Across-Forest Trust. When this link is not present, all claims are allowed to egress as-is.
attributeId: 1.2.840.113556.1.4.2192
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: fkI3wXOaQLCRkBsJW7QyiA==
linkID: 2192
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Ingress-Claims-Transformation-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-IngressClaimsTransformationPolicy
adminDisplayName: ms-DS-Ingress-Claims-Transformation-Policy
adminDescription: This is a link to a Claims Transformation Policy Object for the ingress claims (claims entering this forest) from the Trusted Domain. This is applicable only for an outgoing or bidirectional Across-Forest Trust. If this link is absent, all the ingress claims are dropped.
attributeId: 1.2.840.113556.1.4.2191
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: CEwohm4MQBWLFXUUfSPSDQ==
linkID: 2190
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-TDO-Egress-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-TDOEgressBL
adminDisplayName: ms-DS-TDO-Egress-BL
adminDescription: Backlink to TDO Egress rules link on object.
attributeId: 1.2.840.113556.1.4.2194
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: KWIA1ROZQiKLF4N2HR4OWw==
linkID: 2193
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-TDO-Ingress-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-TDOIngressBL
adminDisplayName: ms-DS-TDO-Ingress-BL
adminDescription: Backlink to TDO Ingress rules link on object.
attributeId: 1.2.840.113556.1.4.2193
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: oWFWWsaXS1SAVuQw/nvFVA==
linkID: 2191
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-ManagedPassword,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ManagedPassword
adminDisplayName: msDS-ManagedPassword
adminDescription: This attribute is the managed password data for a group MSA.
attributeId: 1.2.840.113556.1.4.2196
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hu1i4yi3QgiyfS3qep3yGA==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-ManagedPasswordId,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ManagedPasswordId
adminDisplayName: msDS-ManagedPasswordId
adminDescription: This attribute is the identifier for the current managed password data for a group MSA.
attributeId: 1.2.840.113556.1.4.2197
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
rangeUpper: 1024
schemaIdGuid:: Wil4DtPGQAq0kdYiUf+gpg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-GroupMSAMembership,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-GroupMSAMembership
adminDisplayName: msDS-GroupMSAMembership
adminDescription: This attribute is used for access checks to determine if a requester has permission to retrieve the password for a group MSA.
attributeId: 1.2.840.113556.1.4.2200
attributeSyntax: 2.5.5.15
omSyntax: 66
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 132096
schemaIdGuid:: 1u2OiATOQN+0YrilDkG6OA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-GeoCoordinates-Altitude,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-GeoCoordinatesAltitude
adminDisplayName: ms-DS-GeoCoordinates-Altitude
adminDescription: ms-DS-GeoCoordinates-Altitude
attributeId: 1.2.840.113556.1.4.2183
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
searchFlags: 1
schemaIdGuid:: twMXoUFWnE2GPl+zMl504A==
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-GeoCoordinates-Latitude,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-GeoCoordinatesLatitude
adminDisplayName: ms-DS-GeoCoordinates-Latitude
adminDescription: ms-DS-GeoCoordinates-Latitude
attributeId: 1.2.840.113556.1.4.2184
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
searchFlags: 1
schemaIdGuid:: TtRm3EM99UCFxTwS4WmSfg==
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-GeoCoordinates-Longitude,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-GeoCoordinatesLongitude
adminDisplayName: ms-DS-GeoCoordinates-Longitude
adminDescription: ms-DS-GeoCoordinates-Longitude
attributeId: 1.2.840.113556.1.4.2185
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
searchFlags: 1
schemaIdGuid:: ECHElOS66kyFd6+BOvXaJQ==
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-ManagedPasswordInterval,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ManagedPasswordInterval
adminDisplayName: msDS-ManagedPasswordInterval
adminDescription: This attribute is used to retrieve the number of days before a managed password is automatically changed for a group MSA.
attributeId: 1.2.840.113556.1.4.2199
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: 9451+HasQ4ii7qJrTcr0CQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-ManagedPasswordPreviousId,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ManagedPasswordPreviousId
adminDisplayName: msDS-ManagedPasswordPreviousId
adminDescription: This attribute is the identifier for the previous managed password data for a group MSA.
attributeId: 1.2.840.113556.1.4.2198
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
rangeUpper: 1024
schemaIdGuid:: MSHW0EotT9CZ2RxjZGIppA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-DS-Claims-Transformation-Policies,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ClaimsTransformationPolicies
adminDisplayName: ms-DS-Claims-Transformation-Policies
adminDescription: An object of this class holds the one set of Claims Transformation Policy for Across-Forest Claims Transformation.
governsId: 1.2.840.113556.1.5.281
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: san8yIh9T7uCekSJJ3EHYg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Claims-Transformation-Policies,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-DS-Claims-Transformation-Policy-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-ClaimsTransformationPolicyType
adminDisplayName: ms-DS-Claims-Transformation-Policy-Type
adminDescription: An object of this class holds the one set of Claims Transformation Policy for Across-Forest Claims Transformation.
governsId: 1.2.840.113556.1.5.280
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.2190
systemMayContain: 1.2.840.113556.1.4.2189
systemPossSuperiors: 1.2.840.113556.1.5.281
schemaIdGuid:: s2LrLnMTRf6BATh/Fnbtxw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Claims-Transformation-Policy-Type,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2193
systemMayContain: 1.2.840.113556.1.4.2194
-

dn: CN=Trusted-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2191
systemMayContain: 1.2.840.113556.1.4.2192
-

dn: CN=ms-DS-Resource-Property,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2195
-

dn: CN=Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mayContain
mayContain: 1.2.840.113556.1.4.2183
mayContain: 1.2.840.113556.1.4.2184
mayContain: 1.2.840.113556.1.4.2185
-

dn: CN=ms-DS-Group-Managed-Service-Account,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-GroupManagedServiceAccount
adminDisplayName: msDS-Group-Managed-Service-Account
adminDescription: The group managed service account class is used to create an account which can be shared by different computers to run Windows services.
governsId: 1.2.840.113556.1.5.282
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.30
systemMustContain: 1.2.840.113556.1.4.2199
systemMayContain: 1.2.840.113556.1.4.2200
systemMayContain: 1.2.840.113556.1.4.2198
systemMayContain: 1.2.840.113556.1.4.2197
systemMayContain: 1.2.840.113556.1.4.2196
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.3.23
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.5.67
schemaIdGuid:: ilWLe6WT90qtysAX5n8QVw==
defaultSecurityDescriptor: D:(OD;;CR;00299570-246d-11d0-a768-00aa006e0529;;WD)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCRLCLORCSDDT;;;CO)(OA;;WP;4c164200-20c0-11d0-a768-00aa006e0529;;CO)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;CO)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;CO)(OA;;WP;3e0abfd0-126a-11d0-a060-00aa006c33ed;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;WP;5f202010-79a5-11d0-9020-00c04fc2d4cf;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;WP;bf967950-0de6-11d0-a285-00aa003049e2;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;WP;bf967953-0de6-11d0-a285-00aa003049e2;bf967a86-0de6-11d0-a285-00aa003049e2;CO)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;PS)(OA;;RPWP;77B5B886-944A-11d1-AEBD-0000F80367C1;;PS)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;PS)(A;;RPLCLORC;;;AU)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)(OA;;RP;46a9b11d-60ae-405a-b7e8-ff8a58d456d2;;S-1-5-32-560)(OA;;RP;e362ed86-b728-0842-b27d-2dea7a9df218;;WD)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Group-Managed-Service-Account,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 51
-
```

### Sch52.ldf

```
dn: CN=ms-DS-RID-Pool-Allocation-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-RIDPoolAllocationEnabled
adminDisplayName: ms-DS-RID-Pool-Allocation-Enabled
adminDescription: This attribute indicates whether RID pool allocation is enabled or not.
attributeId: 1.2.840.113556.1.4.2213
attributeSyntax: 2.5.5.8
omSyntax: 1
instanceType: 4
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaFlagsEx: 1
schemaIdGuid:: jHyXJLfBQDO09is3XrcR1w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=RID-Set-References,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Netboot-DUID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: Netboot-DUID
ldapDisplayName: netbootDUID
adminDisplayName: Netboot-DUID
adminDescription: This attribute is used to store DHCPv6 DUID device ID.
attributeId: 1.2.840.113556.1.4.2234
attributeSyntax: 2.5.5.10
omSyntax: 4
instanceType: 4
isSingleValued: TRUE
searchFlags: 1
systemFlags: 16
isMemberOfPartialAttributeSet: TRUE
systemOnly: FALSE
rangeLower: 2
rangeUpper: 128
schemaIdGuid:: vXAlU3c9T0KCLw1jbcbarQ==
showInAdvancedViewOnly: TRUE

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=RID-Manager,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2213
-

dn: CN=domainDNS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminContextMenu
adminContextMenu: 3,{2fb1b669-59ea-4f64-b728-05309f2c11c8}
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 13,{2fb1b669-59ea-4f64-b728-05309f2c11c8}
-

dn: CN=Certificate-AutoEnrollment,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
appliesTo: e5209ca2-3bba-11d2-90cc-00c04fd91ab1
displayname: AutoEnrollment
localizationDisplayId: 83
rightsGuid: a05b8cc2-17bc-4802-a710-e7c15ab866a2
validAccesses: 256

# Update element: computer
dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mayContain
mayContain: 1.2.840.113556.1.4.2234
-

dn: CN=ms-DS-cloudExtensionAttribute1,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute1
lDAPDisplayName: msDS-cloudExtensionAttribute1
adminDisplayName: ms-DS-cloudExtensionAttribute1
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2214
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: r+oJl9pJsk2QigRG5eq4RA==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute2,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute2
lDAPDisplayName: msDS-cloudExtensionAttribute2
adminDisplayName: ms-DS-cloudExtensionAttribute2
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2215
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: rOBO88HAqUuCyRqQdS8WpQ==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute3,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute3
lDAPDisplayName: msDS-cloudExtensionAttribute3
adminDisplayName: ms-DS-cloudExtensionAttribute3
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2216
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: Gsj2gtr6DUqw93BtRoOOtQ==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute4,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute4
lDAPDisplayName: msDS-cloudExtensionAttribute4
adminDisplayName: ms-DS-cloudExtensionAttribute4
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2217
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: NzS/nG5OW0iykSKwJVQnPw==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute5,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute5
lDAPDisplayName: msDS-cloudExtensionAttribute5
adminDisplayName: ms-DS-cloudExtensionAttribute5
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2218
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: W+gVKUfjUkiquyLlplHIZA==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute6,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute6
lDAPDisplayName: msDS-cloudExtensionAttribute6
adminDisplayName: ms-DS-cloudExtensionAttribute6
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2219
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: eSZFYOEo7Eus43EoMzYUVg==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute7,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute7
lDAPDisplayName: msDS-cloudExtensionAttribute7
adminDisplayName: ms-DS-cloudExtensionAttribute7
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2220
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: GRN8Sk7jwkCdAGD/eJDyBw==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute8,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute8
lDAPDisplayName: msDS-cloudExtensionAttribute8
adminDisplayName: ms-DS-cloudExtensionAttribute8
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2221
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: FMXRPEmEykSBwAIXgYANKg==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute9,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute9
lDAPDisplayName: msDS-cloudExtensionAttribute9
adminDisplayName: ms-DS-cloudExtensionAttribute9
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2222
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: LOFjCkAwQUSuJs2Vrw0kfg==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute10,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute10
lDAPDisplayName: msDS-cloudExtensionAttribute10
adminDisplayName: ms-DS-cloudExtensionAttribute10
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2223
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: s/wKZ70T/EeQswpSftgatw==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute11,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute11
lDAPDisplayName: msDS-cloudExtensionAttribute11
adminDisplayName: ms-DS-cloudExtensionAttribute11
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2224
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: yLuenqV9pkKJJSROEqVuJA==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute12,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute12
lDAPDisplayName: msDS-cloudExtensionAttribute12
adminDisplayName: ms-DS-cloudExtensionAttribute12
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2225
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: PcQBPAvhyk+Sskz2FdWwmg==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute13,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute13
lDAPDisplayName: msDS-cloudExtensionAttribute13
adminDisplayName: ms-DS-cloudExtensionAttribute13
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2226
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: S0a+KJCreUumsN9DdDHQNg==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute14,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute14
lDAPDisplayName: msDS-cloudExtensionAttribute14
adminDisplayName: ms-DS-cloudExtensionAttribute14
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2227
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: ura8zoBuJ0mFYJj+yghqnw==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute15,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute15
lDAPDisplayName: msDS-cloudExtensionAttribute15
adminDisplayName: ms-DS-cloudExtensionAttribute15
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2228
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: N9XkqvCKqk2cxmLq24T/Aw==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute16,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute16
lDAPDisplayName: msDS-cloudExtensionAttribute16
adminDisplayName: ms-DS-cloudExtensionAttribute16
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2229
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: WyGBlZZRU0ChHm/8r8YsTQ==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute17,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute17
lDAPDisplayName: msDS-cloudExtensionAttribute17
adminDisplayName: ms-DS-cloudExtensionAttribute17
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2230
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: 2m08PehrKUKWfi/1u5O0zg==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute18,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute18
lDAPDisplayName: msDS-cloudExtensionAttribute18
adminDisplayName: ms-DS-cloudExtensionAttribute18
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2231
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: NDvniKYKaUSYQm6wGzKltQ==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute19,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute19
lDAPDisplayName: msDS-cloudExtensionAttribute19
adminDisplayName: ms-DS-cloudExtensionAttribute19
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2232
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: mf51CQeWikaOGMgA0zhzlQ==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-cloudExtensionAttribute20,CN=Schema,CN=Configuration,dc=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
cn: ms-DS-cloudExtensionAttribute20
lDAPDisplayName: msDS-cloudExtensionAttribute20
adminDisplayName: ms-DS-cloudExtensionAttribute20
adminDescription: An attribute used to house an arbitrary cloud-relevant string
attributeID: 1.2.840.113556.1.4.2233
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
isMemberOfPartialAttributeSet: TRUE
schemaIDGUID:: KGNE9W6LjUmVqCEXSNWs3A==
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Cloud-Extensions,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-CloudExtensions
adminDisplayName: ms-DS-Cloud-Extensions
adminDescription: A collection of attributes used to house arbitrary cloud-relevant strings.
governsId: 1.2.840.113556.1.5.283
objectClassCategory: 3
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
MayContain: 1.2.840.113556.1.4.2214
MayContain: 1.2.840.113556.1.4.2215
MayContain: 1.2.840.113556.1.4.2216
MayContain: 1.2.840.113556.1.4.2217
MayContain: 1.2.840.113556.1.4.2218
MayContain: 1.2.840.113556.1.4.2219
MayContain: 1.2.840.113556.1.4.2220
MayContain: 1.2.840.113556.1.4.2221
MayContain: 1.2.840.113556.1.4.2222
MayContain: 1.2.840.113556.1.4.2223
MayContain: 1.2.840.113556.1.4.2224
MayContain: 1.2.840.113556.1.4.2225
MayContain: 1.2.840.113556.1.4.2226
MayContain: 1.2.840.113556.1.4.2227
MayContain: 1.2.840.113556.1.4.2228
MayContain: 1.2.840.113556.1.4.2229
MayContain: 1.2.840.113556.1.4.2230
MayContain: 1.2.840.113556.1.4.2231
MayContain: 1.2.840.113556.1.4.2232
MayContain: 1.2.840.113556.1.4.2233
schemaIdGuid:: pIceZCaDcUe6LccG3zXjWg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-Cloud-Extensions,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemAuxiliaryClass
systemAuxiliaryClass: 1.2.840.113556.1.5.283
-

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: 641E87A4-8326-4771-BA2D-C706DF35E35A
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 52
-
```

### Sch53.ldf

```
dn: CN=ms-Authz-Central-Access-Rule,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2156
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 53
-
```

### Sch54.ldf

```
dn: CN=User-Account-Restrictions,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=ms-DS-Allowed-To-Act-On-Behalf-Of-Other-Identity,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: attributeSecurityGuid
attributeSecurityGuid:: AEIWTMAg0BGnaACqAG4FKQ==
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 54
-
```

### Sch55.ldf

```
dn: CN=DNS-Host-Name-Attributes,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Validated-DNS-Host-Name,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: 7b8b558a-93a5-4af7-adca-c017e67f1057
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 55
-
```

### Sch56.ldf

```
# Update element: computer. Remove netboot-DUID from mayContain
dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mayContain
mayContain: 1.2.840.113556.1.4.2234
-

# Update element: computer. Add netboot-DUID to SystemMayContain
dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.2234
-

dn: CN=Schema,CN=Configuration,DC=X
changeType: ntdsSchemaModify
replace: objectVersion
objectVersion: 56
-
```

## Schema Updates in previous versions of Windows Server

Sch0.ldf through Sch47.ldf are introduced with Windows Server 2000 to Windows Server 2008 R2.

### Sch0.ldf

```
# Make a system-only mod first. If  they haven't got the binary
# support necessary, it will fail right here, and the tool can
# later be rerun.

dn: CN=User-Principal-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 2
-

# Add these two objects first. If the DC is running a 1717.IDS schema,
# these were deleted just before this. So add them first so that
# the system does not run without them for long
# They are not dependent on any schema changes

dn: CN=container-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
shellPropertyPages: 1,{f2c3faae-c8ac-11d0-bcdb-00c04fd8d5b6}
contextMenu: 0,{62AE1F9A-126A-11D0-A14B-0800361B1103}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{6BA3F852-23C6-11D1-B91F-00A0C9A06D2D}
classDisplayName: Container
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description

dn: CN=default-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
shellPropertyPages: 1,{f2c3faae-c8ac-11d0-bcdb-00c04fd8d5b6}
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description


# Attribute Adds

dn: CN=Pek-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: pekList
adminDisplayName: Pek-List
adminDescription: Pek-List
attributeId: 1.2.840.113556.1.4.865
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gzA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE
systemFlags: 1

dn: CN=FRS-Flags,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSFlags
adminDisplayName: FRS-Flags
adminDescription: FRS-Flags
attributeId: 1.2.840.113556.1.4.874
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fSUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Site-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: siteList
adminDisplayName: Site-List
adminDescription: Site-List
attributeId: 1.2.840.113556.1.4.821
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3CwM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Msi-Script,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msiScript
adminDisplayName: Msi-Script
adminDescription: Msi-Script
attributeId: 1.2.840.113556.1.4.814
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: E4Ph2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSVersion
adminDisplayName: FRS-Version
adminDescription: FRS-Version
attributeId: 1.2.840.113556.1.4.882
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: hSUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Treat-As-Leaf,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: treatAsLeaf
adminDisplayName: Treat-As-Leaf
adminDescription: Treat-As-Leaf
attributeId: 1.2.840.113556.1.4.806
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 40TQjx930RGurgAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Product-Code,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: productCode
adminDisplayName: Product-Code
adminDescription: Product-Code
attributeId: 1.2.840.113556.1.4.818
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 16
schemaIdGuid:: F4Ph2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=DNS-Host-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: dNSHostName
adminDisplayName: DNS-Host-Name
adminDescription: DNS-Host-Name
attributeId: 1.2.840.113556.1.4.619
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2048
schemaIdGuid:: R5Xjchh70RGt7wDAT9jVzQ==
hideFromAB: TRUE


dn: CN=Create-Dialog,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: createDialog
adminDisplayName: Create-Dialog
adminDescription: Create-Dialog
attributeId: 1.2.840.113556.1.4.810
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ipUJKzGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-SCP-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootSCPBL
adminDisplayName: netboot-SCP-BL
adminDescription: netboot-SCP-BL
attributeId: 1.2.840.113556.1.4.864
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gjA4B9+R0RGuvAAA+ANnwQ==
linkID: 101
hideFromAB: TRUE
systemFlags: 1

dn: CN=Site-Link-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: siteLinkList
adminDisplayName: Site-Link-List
adminDescription: Site-Link-List
attributeId: 1.2.840.113556.1.4.822
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3SwM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Tools,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootTools
adminDisplayName: netboot-Tools
adminDescription: netboot-Tools
attributeId: 1.2.840.113556.1.4.858
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fzA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=Msi-Script-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msiScriptName
adminDisplayName: Msi-Script-Name
adminDescription: Msi-Script-Name
attributeId: 1.2.840.113556.1.4.845
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Yt2nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootServer
adminDisplayName: netboot-Server
adminDescription: netboot-Server
attributeId: 1.2.840.113556.1.4.860
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gTA4B9+R0RGuvAAA+ANnwQ==
linkID: 100
hideFromAB: TRUE

dn: CN=Msi-Script-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msiScriptSize
adminDisplayName: Msi-Script-Size
adminDescription: Msi-Script-Size
attributeId: 1.2.840.113556.1.4.846
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Y92nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=LDAP-IPDeny-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: lDAPIPDenyList
adminDisplayName: LDAP-IPDeny-List
adminDescription: LDAP-IPDeny-List
attributeId: 1.2.840.113556.1.4.844
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: U6NZc/eQ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Install-Ui-Level,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: installUiLevel
adminDisplayName: Install-Ui-Level
adminDescription: Install-Ui-Level
attributeId: 1.2.840.113556.1.4.847
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ZN2nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Terminal-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: terminalServer
adminDisplayName: Terminal-Server
adminDescription: Terminal-Server
attributeId: 1.2.840.113556.1.4.885
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HJq2bSKU0RGuvQAA+ANnwQ==
hideFromAB: TRUE

dn: CN=LDAP-Admin-Limits,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: lDAPAdminLimits
adminDisplayName: LDAP-Admin-Limits
adminDescription: LDAP-Admin-Limits
attributeId: 1.2.840.113556.1.4.843
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UqNZc/eQ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Create-Wizard-Ext,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: createWizardExt
adminDisplayName: Create-Wizard-Ext
adminDescription: Create-Wizard-Ext
attributeId: 1.2.840.113556.1.4.812
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: i5UJKzGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Purported-Search,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: purportedSearch
adminDisplayName: Purported-Search
adminDescription: Purported-Search
attributeId: 1.2.840.113556.1.4.886
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2048
schemaIdGuid:: UE61tDqU0RGuvQAA+ANnwQ==
hideFromAB: TRUE


dn: CN=ms-RRAS-Attribute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRRASAttribute
adminDisplayName: ms-RRAS-Attribute
adminDescription: ms-RRAS-Attribute
attributeId: 1.2.840.113556.1.4.884
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rZib842T0RGuvQAA+ANnwQ==
hideFromAB: TRUE

dn: CN=File-Ext-Priority,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fileExtPriority
adminDisplayName: File-Ext-Priority
adminDescription: File-Ext-Priority
attributeId: 1.2.840.113556.1.4.816
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: FYPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=Can-Upgrade-Script,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: canUpgradeScript
adminDisplayName: Can-Upgrade-Script
adminDescription: Can-Upgrade-Script
attributeId: 1.2.840.113556.1.4.815
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FIPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=App-Schema-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: appSchemaVersion
adminDisplayName: App-Schema-Version
adminDescription: App-Schema-Version
attributeId: 1.2.840.113556.1.4.848
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Zd2nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Primary-Member,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSPrimaryMember
adminDisplayName: FRS-Primary-Member
adminDescription: FRS-Primary-Member
attributeId: 1.2.840.113556.1.4.878
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
linkId: 106
schemaIdGuid:: gSUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=Remote-Storage-GUID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: remoteStorageGUID
adminDisplayName: Remote-Storage-GUID
adminDescription: Remote-Storage-GUID
attributeId: 1.2.840.113556.1.4.809
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: sMU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=netboot-Max-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootMaxClients
adminDisplayName: netboot-Max-Clients
adminDescription: netboot-Max-Clients
attributeId: 1.2.840.113556.1.4.851
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=FRS-Member-Reference,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSMemberReference
adminDisplayName: FRS-Member-Reference
adminDescription: FRS-Member-Reference
attributeId: 1.2.840.113556.1.4.875
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fiUTKnOT0RGuvAAA+ANnwQ==
linkID: 104
hideFromAB: TRUE
systemFlags: 2

dn: CN=Upgrade-Product-Code,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: upgradeProductCode
adminDisplayName: Upgrade-Product-Code
adminDescription: Upgrade-Product-Code
attributeId: 1.2.840.113556.1.4.813
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 16
schemaIdGuid:: EoPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Time-Last-Command,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSTimeLastCommand
adminDisplayName: FRS-Time-Last-Command
adminDescription: FRS-Time-Last-Command
attributeId: 1.2.840.113556.1.4.880
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gyUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=netboot-New-Machine-OU,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootNewMachineOU
adminDisplayName: netboot-New-Machine-OU
adminDescription: netboot-New-Machine-OU
attributeId: 1.2.840.113556.1.4.856
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Limit-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootLimitClients
adminDisplayName: netboot-Limit-Clients
adminDescription: netboot-Limit-Clients
attributeId: 1.2.840.113556.1.4.850
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dzA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Signature-Algorithms,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: signatureAlgorithms
adminDisplayName: Signature-Algorithms
adminDescription: Signature-Algorithms
attributeId: 1.2.840.113556.1.4.824
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ssU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Partner-Auth-Level,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSPartnerAuthLevel
adminDisplayName: FRS-Partner-Auth-Level
adminDescription: FRS-Partner-Auth-Level
attributeId: 1.2.840.113556.1.4.877
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Enrollment-Providers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: enrollmentProviders
adminDisplayName: Enrollment-Providers
adminDescription: Enrollment-Providers
attributeId: 1.2.840.113556.1.4.825
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: s8U5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Member-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSMemberReferenceBL
adminDisplayName: FRS-Member-Reference-BL
adminDescription: FRS-Member-Reference-BL
attributeId: 1.2.840.113556.1.4.876
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fyUTKnOT0RGuvAAA+ANnwQ==
linkID: 105
hideFromAB: TRUE
systemFlags: 1

dn: CN=Certificate-Templates,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: certificateTemplates
adminDisplayName: Certificate-Templates
adminDescription: Certificate-Templates
attributeId: 1.2.840.113556.1.4.823
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: scU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Pek-Key-Change-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: pekKeyChangeInterval
adminDisplayName: Pek-Key-Change-Interval
adminDescription: Pek-Key-Change-Interval
attributeId: 1.2.840.113556.1.4.866
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Localized-Description,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: localizedDescription
adminDisplayName: Localized-Description
adminDescription: Localized-Description
attributeId: 1.2.840.113556.1.4.817
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FoPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Frs-Computer-Reference,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: frsComputerReference
adminDisplayName: Frs-Computer-Reference
adminDescription: Frs-Computer-Reference
attributeId: 1.2.840.113556.1.4.869
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eCUTKnOT0RGuvAAA+ANnwQ==
linkID: 102
systemFlags: 2
hideFromAB: TRUE

dn: CN=Alt-Security-Identities,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: altSecurityIdentities
adminDisplayName: Alt-Security-Identities
adminDescription: Alt-Security-Identities
attributeId: 1.2.840.113556.1.4.867
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: DPP7AP6R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Answer-Requests,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootAnswerRequests
adminDisplayName: netboot-Answer-Requests
adminDescription: netboot-Answer-Requests
attributeId: 1.2.840.113556.1.4.853
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ejA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Bridgehead-Server-List-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: bridgeheadServerListBL
adminDisplayName: Bridgehead-Server-List-BL
adminDescription: Bridgehead-Server-List-BL
attributeId: 1.2.840.113556.1.4.820
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2ywM1VGJ0RGuvAAA+ANnwQ==
linkID: 99
hideFromAB: TRUE
systemFlags: 1

dn: CN=Frs-Computer-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: frsComputerReferenceBL
adminDisplayName: Frs-Computer-Reference-BL
adminDescription: Frs-Computer-Reference-BL
attributeId: 1.2.840.113556.1.4.870
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eSUTKnOT0RGuvAAA+ANnwQ==
linkID: 103
hideFromAB: TRUE
systemFlags: 1

dn: CN=FRS-Control-Data-Creation,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSControlDataCreation
adminDisplayName: FRS-Control-Data-Creation
adminDescription: FRS-Control-Data-Creation
attributeId: 1.2.840.113556.1.4.871
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: eiUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Is-Critical-System-Object,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: isCriticalSystemObject
adminDisplayName: Is-Critical-System-Object
adminDescription: Is-Critical-System-Object
attributeId: 1.2.840.113556.1.4.868
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: DfP7AP6R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Allow-New-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootAllowNewClients
adminDisplayName: netboot-Allow-New-Clients
adminDescription: netboot-Allow-New-Clients
attributeId: 1.2.840.113556.1.4.849
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: djA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Time-Last-Config-Change,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSTimeLastConfigChange
adminDisplayName: FRS-Time-Last-Config-Change
adminDescription: FRS-Time-Last-Config-Change
attributeId: 1.2.840.113556.1.4.881
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Bridgehead-Transport-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: bridgeheadTransportList
adminDisplayName: Bridgehead-Transport-List
adminDescription: Bridgehead-Transport-List
attributeId: 1.2.840.113556.1.4.819
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2iwM1VGJ0RGuvAAA+ANnwQ==
linkID: 98
hideFromAB: TRUE

dn: CN=FRS-Service-Command-Status,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSServiceCommandStatus
adminDisplayName: FRS-Service-Command-Status
adminDescription: FRS-Service-Command-Status
attributeId: 1.2.840.113556.1.4.879
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 512
schemaIdGuid:: giUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Control-Inbound-Backlog,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSControlInboundBacklog
adminDisplayName: FRS-Control-Inbound-Backlog
adminDescription: FRS-Control-Inbound-Backlog
attributeId: 1.2.840.113556.1.4.872
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: eyUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-IntelliMirror-OSes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootIntelliMirrorOSes
adminDisplayName: netboot-IntelliMirror-OSes
adminDescription: netboot-IntelliMirror-OSes
attributeId: 1.2.840.113556.1.4.857
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fjA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Control-Outbound-Backlog,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSControlOutboundBacklog
adminDisplayName: FRS-Control-Outbound-Backlog
adminDescription: FRS-Control-Outbound-Backlog
attributeId: 1.2.840.113556.1.4.873
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: fCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Current-Client-Count,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootCurrentClientCount
adminDisplayName: netboot-Current-Client-Count
adminDescription: netboot-Current-Client-Count
attributeId: 1.2.840.113556.1.4.852
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=IPSEC-Negotiation-Policy-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: iPSECNegotiationPolicyType
adminDisplayName: IPSEC-Negotiation-Policy-Type
adminDescription: IPSEC-Negotiation-Policy-Type
attributeId: 1.2.840.113556.1.4.887
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=ms-RRAS-Vendor-Attribute-Entry,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRRASVendorAttributeEntry
adminDisplayName: ms-RRAS-Vendor-Attribute-Entry
adminDescription: ms-RRAS-Vendor-Attribute-Entry
attributeId: 1.2.840.113556.1.4.883
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rJib842T0RGuvQAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Locally-Installed-OSes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootLocallyInstalledOSes
adminDisplayName: netboot-Locally-Installed-OSes
adminDescription: netboot-Locally-Installed-OSes
attributeId: 1.2.840.113556.1.4.859
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=IPSEC-Negotiation-Policy-Action,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: iPSECNegotiationPolicyAction
adminDisplayName: IPSEC-Negotiation-Policy-Action
adminDescription: IPSEC-Negotiation-Policy-Action
attributeId: 1.2.840.113556.1.4.888
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-New-Machine-Naming-Policy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootNewMachineNamingPolicy
adminDisplayName: netboot-New-Machine-Naming-Policy
adminDescription: netboot-New-Machine-Naming-Policy
attributeId: 1.2.840.113556.1.4.855
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Answer-Only-Valid-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootAnswerOnlyValidClients
adminDisplayName: netboot-Answer-Only-Valid-Clients
adminDescription: netboot-Answer-Only-Valid-Clients
attributeId: 1.2.840.113556.1.4.854
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ezA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=UPN-Suffixes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
lDAPDisplayName: uPNSuffixes
adminDescription: UPN-Suffixes
adminDisplayName: UPN-Suffixes
attributeID: 1.2.840.113556.1.4.890
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: FALSE
schemaIDGUID:: v2AhAySY0RGuwAAA+ANnwQ==
searchFlags: 0
systemOnly: FALSE
hideFromAB: TRUE

dn: CN=Additional-Trusted-Service-Names,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
lDAPDisplayName: additionalTrustedServiceNames
adminDescription: Additional-Trusted-Service-Names
adminDisplayName: Additional-Trusted-Service-Names
attributeID: 1.2.840.113556.1.4.889
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: FALSE
schemaIDGUID:: vmAhAySY0RGuwAAA+ANnwQ==
searchFlags: 0
systemOnly: FALSE
hideFromAB: TRUE


# Here because OID got reused with different syntax
# We will delete Replica-Set-Type, and add FRS-Replica-Set-Type
# with a new OID.

dn: CN=NTFRS-Replica-Set,CN=schema,CN=configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.30
-

dn: CN=Replica-Set-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=FRS-Replica-Set-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSReplicaSetType
adminDisplayName: FRS-Replica-Set-Type
adminDescription: FRS-Replica-Set-Type
attributeId: 1.2.840.113556.1.4.31
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: a3PZJnBg0RGpxgAA+ANnwQ==
hideFromAB: TRUE

# Attribute Renames, plus some modifies in some cases

dn: CN=Replication-DS-Poll,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-DS-Poll
deleteoldrdn: 1

dn: CN=FRS-DS-Poll,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSDSPoll
-
replace: adminDisplayName
adminDisplayName: FRS-DS-Poll
-
replace: adminDescription
adminDescription: FRS-DS-Poll
-


dn: CN=Com-Unique-Cat-Id,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: Category-Id
deleteoldrdn: 1

dn: CN=Category-Id,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: categoryId
-
replace: adminDisplayName
adminDisplayName: Category-Id
-
replace: adminDescription
adminDescription: Category-Id
-


dn: CN=Replication-Root-Path,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Root-Path
deleteoldrdn: 1

dn: CN=FRS-Root-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSRootPath
-
replace: adminDisplayName
adminDisplayName: FRS-Root-Path
-
replace: adminDescription
adminDescription: FRS-Root-Path
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Replication-File-Filter,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-File-Filter
deleteoldrdn: 1

dn: CN=FRS-File-Filter,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSFileFilter
-
replace: adminDisplayName
adminDisplayName: FRS-File-Filter
-
replace: adminDescription
adminDescription: FRS-File-Filter
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Replication-Level-Limit,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Level-Limit
deleteoldrdn: 1

dn: CN=FRS-Level-Limit,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSLevelLimit
-
replace: adminDisplayName
adminDisplayName: FRS-Level-Limit
-
replace: adminDescription
adminDescription: FRS-Level-Limit
-


dn: CN=Replication-Extensions,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Extensions
deleteoldrdn: 1

dn: CN=FRS-Extensions,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSExtensions
-
replace: adminDisplayName
adminDisplayName: FRS-Extensions
-
replace: adminDescription
adminDescription: FRS-Extensions
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 65536
-

dn: CN=Replication-Staging-Path,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Staging-Path
deleteoldrdn: 1

dn: CN=FRS-Staging-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSStagingPath
-
replace: adminDisplayName
adminDisplayName: FRS-Staging-Path
-
replace: adminDescription
adminDescription: FRS-Staging-Path
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Code-Package,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: Msi-Script-Path
deleteoldrdn: 1

dn: CN=Msi-Script-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: msiScriptPath
-
replace: adminDisplayName
adminDisplayName: Msi-Script-Path
-
replace: adminDescription
adminDescription: Msi-Script-Path
-


dn: CN=Replication-DB-Path,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Working-Path
deleteoldrdn: 1

dn: CN=FRS-Working-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSWorkingPath
-
replace: adminDisplayName
adminDisplayName: FRS-Working-Path
-
replace: adminDescription
adminDescription: FRS-Working-Path
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Replica-Version-GUID,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Version-GUID
deleteoldrdn: 1

dn: CN=FRS-Version-GUID,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSVersionGuid
-
replace: adminDisplayName
adminDisplayName: FRS-Version-GUID
-
replace: adminDescription
adminDescription: FRS-Version-GUID
-
add: rangeLower
rangeLower: 16
-
add: rangeUpper
rangeUpper: 16
-


dn: CN=Replication-Root-Security,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Root-Security
deleteoldrdn: 1

dn: CN=FRS-Root-Security,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSRootSecurity
-
replace: adminDisplayName
adminDisplayName: FRS-Root-Security
-
replace: adminDescription
adminDescription: FRS-Root-Security
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 65535
-


dn: CN=Replication-Update-Timeout,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Update-Timeout
deleteoldrdn: 1

dn: CN=FRS-Update-Timeout,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSUpdateTimeout
-
replace: adminDisplayName
adminDisplayName: FRS-Update-Timeout
-
replace: adminDescription
adminDescription: FRS-Update-Timeout
-


dn: CN=Replication-Service-Command,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Service-Command
deleteoldrdn: 1

dn: CN=FRS-Service-Command,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSServiceCommand
-
replace: adminDisplayName
adminDisplayName: FRS-Service-Command
-
replace: adminDescription
adminDescription: FRS-Service-Command
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 512
-


dn: CN=Replica-Set-GUID,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Replica-Set-GUID
deleteoldrdn: 1

dn: CN=FRS-Replica-Set-GUID,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSReplicaSetGuid
-
replace: adminDisplayName
adminDisplayName: FRS-Replica-Set-GUID
-
replace: adminDescription
adminDescription: FRS-Replica-Set-GUID
-


dn: CN=Replication-Status,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Fault-Condition
deleteoldrdn: 1

dn: CN=FRS-Fault-Condition,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSFaultCondition
-
replace: adminDisplayName
adminDisplayName: FRS-Fault-Condition
-
replace: adminDescription
adminDescription: FRS-Fault-Condition
-
add: rangeLower
rangeLower: 1
-
add: rangeUpper
rangeUpper: 16
-


dn: CN=Replication-Directory-Filter,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Directory-Filter
deleteoldrdn: 1

dn: CN=FRS-Directory-Filter,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSDirectoryFilter
-
replace: adminDisplayName
adminDisplayName: FRS-Directory-Filter
-
replace: adminDescription
adminDescription: FRS-Directory-Filter
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-

dn: CN=Created-Entry,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: rpc-Ns-Entry-Flags
deleteoldrdn: 1

dn: CN=rpc-Ns-Entry-Flags,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: rpcNsEntryFlags
-
replace: adminDisplayName
adminDisplayName: rpc-Ns-Entry-Flags
-
replace: adminDescription
adminDescription: rpc-Ns-Entry-Flags
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Class Adds

dn: CN=NTFRS-Member,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: nTFRSMember
adminDisplayName: NTFRS-Member
adminDescription: NTFRS-Member
governsId: 1.2.840.113556.1.5.153
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.515
systemMayContain: 1.2.840.113556.1.4.485
systemMayContain: 1.2.840.113556.1.4.500
systemMayContain: 1.2.840.113556.1.4.535
systemMayContain: 1.2.840.113556.1.4.877
systemMayContain: 1.2.840.113556.1.4.874
systemMayContain: 1.2.840.113556.1.4.536
systemMayContain: 1.2.840.113556.1.4.873
systemMayContain: 1.2.840.113556.1.4.872
systemMayContain: 1.2.840.113556.1.4.871
systemMayContain: 1.2.840.113556.1.4.869
systemPossSuperiors: 1.2.840.113556.1.5.102
schemaIdGuid:: hiUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NTFRS-Member,CN=Schema,CN=Configuration,DC=X

dn: CN=Site-Link-Bridge,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: siteLinkBridge
adminDisplayName: Site-Link-Bridge
adminDescription: Site-Link-Bridge
governsId: 1.2.840.113556.1.5.148
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.822
systemPossSuperiors: 1.2.840.113556.1.5.141
schemaIdGuid:: 3ywM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Site-Link-Bridge,CN=Schema,CN=Configuration,DC=X

dn: CN=RRAS-Administration-Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rRASAdministrationConnectionPoint
adminDisplayName: RRAS-Administration-Connection-Point
adminDescription: RRAS-Administration-Connection-Point
governsId: 1.2.840.113556.1.5.150
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.94
systemMayContain: 1.2.840.113556.1.4.884
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: vsU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RRAS-Administration-Connection-Point,CN=Schema,CN=Configuration,DC=X

dn: CN=NTFRS-Subscriptions,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
lDAPDisplayName: nTFRSSubscriptions
adminDescription: NTFRS-Subscriptions
adminDisplayName: NTFRS-Subscriptions
governsID: 1.2.840.113556.1.5.154
objectClassCategory: 1
rDNAttID: 2.5.4.3
subClassOf: 2.5.6.0
schemaIDGUID:: hyUTKnOT0RGuvAAA+ANnwQ==
systemMayContain: 1.2.840.113556.1.4.486
systemMayContain: 1.2.840.113556.1.4.882
systemMayContain: 1.2.840.113556.1.4.536
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.5.154
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NTFRS-Subscriptions,CN=Schema,CN=Configuration,DC=X

dn: CN=Remote-Storage-Service-Point,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: remoteStorageServicePoint
adminDisplayName: Remote-Storage-Service-Point
adminDescription: Remote-Storage-Service-Point
governsId: 1.2.840.113556.1.5.146
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.94
systemMayContain: 1.2.840.113556.1.4.809
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: vcU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Remote-Storage-Service-Point,CN=Schema,CN=Configuration,DC=X


dn: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
lDAPDisplayName: intellimirrorGroup
adminDescription: Intellimirror-Group
adminDisplayName: Intellimirror-Group
governsID: 1.2.840.113556.1.5.152
objectClassCategory: 1
rDNAttID: 2.5.4.3
schemaIDGUID:: hjA4B9+R0RGuvAAA+ANnwQ==
subClassOf: 2.5.6.0
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.3.23
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X

dn: CN=Site-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: siteLink
adminDisplayName: Site-Link
adminDescription: Site-Link
governsId: 1.2.840.113556.1.5.147
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.821
systemMayContain: 1.2.840.113556.1.4.211
systemMayContain: 1.2.840.113556.1.2.135
systemPossSuperiors: 1.2.840.113556.1.5.141
schemaIdGuid:: 3iwM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Site-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=Intellimirror-SCP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: intellimirrorSCP
adminDisplayName: Intellimirror-SCP
adminDescription: Intellimirror-SCP
governsId: 1.2.840.113556.1.5.151
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.94
systemMayContain: 1.2.840.113556.1.4.858
systemMayContain: 1.2.840.113556.1.4.860
systemMayContain: 1.2.840.113556.1.4.856
systemMayContain: 1.2.840.113556.1.4.855
systemMayContain: 1.2.840.113556.1.4.851
systemMayContain: 1.2.840.113556.1.4.361
systemMayContain: 1.2.840.113556.1.4.859
systemMayContain: 1.2.840.113556.1.4.850
systemMayContain: 1.2.840.113556.1.4.857
systemMayContain: 1.2.840.113556.1.4.358
systemMayContain: 1.2.840.113556.1.4.359
systemMayContain: 1.2.840.113556.1.4.852
systemMayContain: 1.2.840.113556.1.4.853
systemMayContain: 1.2.840.113556.1.4.854
systemMayContain: 1.2.840.113556.1.4.849
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.5.152
schemaIdGuid:: hTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Intellimirror-SCP,CN=Schema,CN=Configuration,DC=X

dn: CN=NTFRS-Subscriber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: nTFRSSubscriber
adminDisplayName: NTFRS-Subscriber
adminDescription: NTFRS-Subscriber
governsId: 1.2.840.113556.1.5.155
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.488
systemMustContain: 1.2.840.113556.1.4.487
systemMayContain: 1.2.840.113556.1.4.211
systemMayContain: 1.2.840.113556.1.4.485
systemMayContain: 1.2.840.113556.1.4.881
systemMayContain: 1.2.840.113556.1.4.880
systemMayContain: 1.2.840.113556.1.4.879
systemMayContain: 1.2.840.113556.1.4.500
systemMayContain: 1.2.840.113556.1.4.875
systemMayContain: 1.2.840.113556.1.4.874
systemMayContain: 1.2.840.113556.1.4.491
systemMayContain: 1.2.840.113556.1.4.536
systemPossSuperiors: 1.2.840.113556.1.5.154
schemaIdGuid:: iCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NTFRS-Subscriber,CN=Schema,CN=Configuration,DC=X

dn: CN=RRAS-Administration-Dictionary,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rRASAdministrationDictionary
adminDisplayName: RRAS-Administration-Dictionary
adminDescription: RRAS-Administration-Dictionary
governsId: 1.2.840.113556.1.5.156
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.883
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: rpib842T0RGuvQAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RRAS-Administration-Dictionary,CN=Schema,CN=Configuration,DC=X


# Syntax in two attributes got modified. USN-Source and
# Transport-Address-Type. We don't propagate the changes.
# We will delete both and add new attributes
# to replace them.

# Attribute and Class Modifications

dn: CN=Object-Class,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 0
-

dn: CN=Surname,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=State-Or-Province-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Street-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Title,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Postal-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Postal-Code,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Office-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Post-Office-Box,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Physical-Delivery-Office-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Home-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Telex-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Teletex-Terminal-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Facsimile-Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=X121-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=International-ISDN-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Registered-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Preferred-Delivery-Method,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Picture,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Mobile-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Pager-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Initials,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Password,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Recorded-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Greetings,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Flags,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Volume,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Speed,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Recording-Length,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Forwarding-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Personal-Title,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Address-Home,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Pager-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Fax-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Mobile-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Telex-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-ISDN-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Assistant,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-


dn: CN=Categories,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: rangeLower
rangeLower: 36
-
add: rangeUpper
rangeUpper: 36
-

dn: CN=Creator,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 0
-

dn: CN=Phone-Ip-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Ip-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=WWW-Page-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: s5VX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Group-Type,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 1
-
add: systemFlags
systemFlags: 2
-

dn: CN=User-Shared-Folder,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=User-Shared-Folder-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Service-Principal-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 2
-

dn: CN=Phone-Home-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-


dn: CN=AutoReply,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=AutoReply-Message,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Package-Flags,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 1
-

dn: CN=AutoReply-Subject,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=WWW-Home-Page,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: s5VX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Cross-Ref-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.890
-

dn: CN=Trusted-Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.889
-

dn: CN=Inter-Site-Transport,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.789
-
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.789
-

dn: CN=Group-Of-Names,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: objectClassCategory
objectClassCategory: 2
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.820
systemMayContain: 1.2.840.113556.1.4.864
systemMayContain: 1.2.840.113556.1.4.868
systemMayContain: 1.2.840.113556.1.4.870
systemMayContain: 1.2.840.113556.1.4.876
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.290
systemMayContain: 1.2.840.113556.1.2.291
systemMayContain: 1.2.840.113556.1.2.292
systemMayContain: 1.2.840.113556.1.2.293
systemMayContain: 1.2.840.113556.1.2.339
systemMayContain: 1.2.840.113556.1.2.340
systemMayContain: 1.2.840.113556.1.2.341
systemMayContain: 1.2.840.113556.1.2.342
systemMayContain: 1.2.840.113556.1.2.469
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.865
systemMayContain: 1.2.840.113556.1.4.866
-

dn: CN=Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultObjectCategory
defaultObjectCategory: CN=Domain-DNS,CN=Schema,CN=Configuration,DC=X
-

dn: CN=Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.867
-

dn: CN=ACS-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.765
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.885
systemMayContain: 1.2.840.113556.1.4.771
-

dn: CN=ACS-Subnet,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Class-Registration,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.252
-

dn: CN=Inter-Site-Transport-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.107
-
delete: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.142
-

dn: CN=Inter-Site-Transport,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.790
-

dn: CN=Certification-Authority,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.619
systemMayContain: 1.2.840.113556.1.4.823
systemMayContain: 1.2.840.113556.1.4.824
systemMayContain: 1.2.840.113556.1.4.825
-

dn: CN=Server,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.619
systemMayContain: 1.2.840.113556.1.4.786
systemMayContain: 1.2.840.113556.1.4.819
-

dn: CN=Print-Queue,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.631
-

dn: CN=Remote-Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.619
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.360
systemMayContain: 1.2.840.113556.1.4.486
-

dn: CN=Storage,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Class-Store,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.848
-
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.18
-

dn: CN=Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.47
systemMayContain: 1.2.840.113556.1.2.129
systemMayContain: 1.2.840.113556.1.2.144
systemMayContain: 1.2.840.113556.1.2.221
-

dn: CN=NTDS-DSA,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.786
systemMayContain: 0.9.2342.19200300.100.1.3
-

dn: CN=Package-Registration,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.20
systemMayContain: 1.2.840.113556.1.4.813
systemMayContain: 1.2.840.113556.1.4.814
systemMayContain: 1.2.840.113556.1.4.815
systemMayContain: 1.2.840.113556.1.4.816
systemMayContain: 1.2.840.113556.1.4.818
systemMayContain: 1.2.840.113556.1.4.845
systemMayContain: 1.2.840.113556.1.4.846
systemMayContain: 1.2.840.113556.1.4.847
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.17
-

dn: CN=NTDS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.607
-

dn: CN=NTDS-Connection,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.791
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.785
-
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.153
-

dn: CN=Category-Registration,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.817
-

dn: CN=Display-Specifier,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.806
systemMayContain: 1.2.840.113556.1.4.810
systemMayContain: 1.2.840.113556.1.4.812
-

dn: CN=NTFRS-Settings,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.653
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.459
systemMayContain: 1.2.840.113556.1.4.211
systemMayContain: 1.2.840.113556.1.4.486
systemMayContain: 1.2.840.113556.1.4.487
systemMayContain: 1.2.840.113556.1.4.488
systemMayContain: 1.2.840.113556.1.4.489
systemMayContain: 1.2.840.113556.1.4.490
systemMayContain: 1.2.840.113556.1.4.491
systemMayContain: 1.2.840.113556.1.4.500
systemMayContain: 1.2.840.113556.1.4.535
systemMayContain: 1.2.840.113556.1.4.564
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.43
-
add: systemPossSuperiors
systemPossSuperiors: 2.5.6.4
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.3.23
-
delete: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.17
-

dn: CN=NTFRS-Replica-Set,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.43
systemMayContain: 1.2.840.113556.1.4.31
systemMayContain: 1.2.840.113556.1.4.653
systemMayContain: 1.2.840.113556.1.4.874
systemMayContain: 1.2.840.113556.1.4.877
systemMayContain: 1.2.840.113556.1.4.878
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.459
systemMayContain: 1.2.840.113556.1.4.485
systemMayContain: 1.2.840.113556.1.4.486
systemMayContain: 1.2.840.113556.1.4.487
systemMayContain: 1.2.840.113556.1.4.488
systemMayContain: 1.2.840.113556.1.4.489
systemMayContain: 1.2.840.113556.1.4.491
systemMayContain: 1.2.840.113556.1.4.564
-

dn: CN=Query-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.844
systemMayContain: 1.2.840.113556.1.4.843
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.604
systemMustContain: 1.2.840.113556.1.4.603
systemMustContain: 1.2.840.113556.1.4.602
systemMustContain: 1.2.840.113556.1.4.599
systemMustContain: 1.2.840.113556.1.4.601
systemMustContain: 1.2.840.113556.1.4.600
-

dn: CN=Ipsec-Negotiation-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.887
systemMayContain: 1.2.840.113556.1.4.888
-

dn: CN=Address-Book-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.886
-
add: systemMustContain
systemMustContain: 1.2.840.113556.1.2.13
-

dn: CN=Service-Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.658
-

# Attribute and Class deletes

# First delete some objects in Config NC before deleting their classes

dn: CN=RPC,CN=Inter-Site Transports,CN=Site Connectors,CN=sites,CN=configuration,DC=X
changetype: delete

dn: CN=Inter-Site Transports,CN=Site Connectors,CN=sites,CN=configuration,DC=X
changetype: delete

dn: CN=Site Connectors,CN=sites,CN=configuration,DC=X
changetype: delete



dn: CN=RAS-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Information-Store-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Link-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=LocalGroup,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Exchange-Admin-Service,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Eicon-X25-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-POP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DX-Requestor,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-LDAP-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-LDAP-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Interface,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Mailbox-Agent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Eicon-X25-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Directory-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=NNTP-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Connector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encryption-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Container,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Site-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Application-Registration,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-IMAP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Server-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Addressing,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Admin-Extension,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-HTTP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Public-Store,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Add-In,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transport-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-LDAP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Message-Store,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-Shared-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MTA-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Mail-Gateway,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Distribution-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-Shared-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-DXA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=NTFRS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MTA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Addr-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Root,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-DXA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-Shared,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=ADMD,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=PRMD,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Run-As,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Req-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=To-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Runs-On,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enabled,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-App-Id,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=App-Flags,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Form-Data,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=INSAdmin,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=N-Address,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Send-TNEF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Line-Wrap,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Auth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=From-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Types,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-DN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Flags,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Imp-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Req-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Assistant-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=P-Selector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Rid-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=S-Selector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=T-Selector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=HTTP-Pub-PF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=OWA-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Svr-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Domain-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-ReqName,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Conf-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Auth-Orig-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-PS-CLSID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Netboot-NIC,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=HTTP-Pub-GAL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Account,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Port-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Require-SSL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Target-MTAs,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Trust-Level,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Can-Create-PF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Log-Filename,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Contact-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Host,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Content-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Routing-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=HTTP-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Package-Id,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=MTA-Local-Cred,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-1,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-2,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-3,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-4,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Character-Set,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Delegate-User,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Member-Rule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Admin-Copy,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Do-OAB-Version,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Unique-IID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Computer-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Newsfeed-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitor-Clock,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=N-Address-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Sites,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Referral-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Imp-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Employee-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Req-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Role-Occupant,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Affinity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Unauth-Orig-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Import-Now,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=USN-Intersite,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Host,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Export-Now,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Svr-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=LDAP-Search-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Create-PF-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Create-PF-DL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Local-Admin,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MTA-Local-Desig,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Imp-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Req-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Conf-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Svr-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Property-Pages,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Sites,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Use-Site-Values,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Newsgroup-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Report-To-Owner,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RTS-Window-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Unauth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Admin-Update,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Domain-Replicas,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Append-ReqCN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Recipient-CP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MDB-Unread-Limit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Style,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Conf-Req-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Preserve-DNs,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Employee-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Connection-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Phone-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Authorized-User,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Folder-GUID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Proxy-Space,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-List-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-Bridge-Head,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Monitor-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Definition,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Trans-Retry-Mins,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Create-PF-DL-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Logging-Level,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Maximum-Object-ID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=House-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Remote-Client,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=HTTP-Pub-GAL-Limit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Anonymous-Access,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Import-Container,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitor-Services,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Supporting-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Control-Msg-Rules,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Bridge-Head,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Send-EMail-Message,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Accept-All,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF-DL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Connected-Domains,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Gateway-Local-Cred,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Alert-Repair,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Alert-Offset,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-In-Template-Map,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Folders-Container,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Reject-Perms,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Character-Set-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Expand-DLs-Locally,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Authorized-Domain,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-Initial-Turn,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Home-Public-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-List-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Incoming-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Submit-Perms,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=P-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Anonymous-Account,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Num-Of-Open-Retries,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Export-Containers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitored-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Replica-Set-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Realm-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Aliased-Object-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Folder-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=S-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Host-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Trans-Timeout-Mins,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=T-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Callback-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Leased-Line-Port,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Remote-MTA-Phone,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X400-Attachment-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Bridgehead-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Gateway-Local-Desig,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=GWART-Last-Modified,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X400-Selector-Syntax,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Admin-Extension-DLL,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=List-Public-Folders,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Lockout-Disconnect,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Display-Name-Suffix,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Certificate-Chain-V3,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Out-Template-Map,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-List-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Space-Last-Computed,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Over-Site-Connector,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=RAS-Remote-SRVR-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RTS-Checkpoint-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Proxy-Generator-DLL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Out-BH-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Open-Retry-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=XMIT-Timeout-Normal,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=NNTP-Distributions,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=XMIT-Timeout-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MDB-Backoff-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Import-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-Selected-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF-DL-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enabled-Protocol-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Reject-Perms-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Warning-Repair,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Replication-Stagger,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Warning-Offset,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Leased-or-Switched,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Exchange-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Control-Msg-Folder-ID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Action-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Action-First,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Submit-Perms-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Temp-Assoc-Threshold,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Template-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Gateway-Routing-Tree,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Authorized-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-Value-DN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Return-Exact-Msg-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Client-Access-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Report-To-Originator,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RTS-Recovery-Timeout,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Containers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enable-Compatibility,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Association-Lifetime,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Action-Second,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Cross-Certificate-CRL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Responsible-Local-DXA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encapsulation-Method,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Newsfeed-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MDB-Msg-Time-Out-Period,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Restart-Delay,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Authentication-To-Use,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=HTTP-Pub-AB-Attributes,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-List-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-Value-Str,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Hide-DL-Membership,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Filter-Local-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-Selected-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Default-Message-Format,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Conf-Container-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Translation-Table-Used,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Disabled-Gateway-Proxy,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Native-Address-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Template-TimeStamp,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Alert-Delay,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Replication-Boot-State,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Connection-List-Filter,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Assoc-Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Recipients,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Remote-Entries,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Num-Of-Transfer-Retries,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Exchange-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outgoing-Msg-Size-Limit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Alert-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=OOF-Reply-To-Originator,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Disable-Deferred-Commit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Turn-Request-Threshold,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=XMIT-Timeout-Non-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-Selected-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Restart-Message,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Auto-Convert-Class-Id,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Phonebook-Entry-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=NNTP-Distributions-Flag,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-Bridge-Head-Address,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Timeout-Normal,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Retry-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Timeout-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Message-Tracking-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Signature-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Bidirectional-Connector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Call-User-Data-Incoming,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Available-Distributions,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Replication-Mail-Msg-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Call-User-Data-Outgoing,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transport-Expedited-Data,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-UnConf-Container-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Exchange-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Warning-Delay,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Session-Disconnect-Timer,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Template-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Quota-Notification-Style,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Root-Newsgroups-Folder-ID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Warning-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Bridge-Head-Address,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Export-Custom-Recipients,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Support-SMIME-Signatures,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-Selected-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Container-Administrators,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Recipients-NDR,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Two-Way-Alternate-Facility,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Preserve-Internet-Content,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Prev-Export-Native-Only,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Facilities-Data-Incoming,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Facilities-Data-Outgoing,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Default-Intra-Site-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Default-Inter-Site-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Connection-List-Filter-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Timeout-Non-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Quota-Notification-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Exchange-Certificate-Chain,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Authorized-Password-Confirm,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Normal-Poll-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Signature-Certificate-Chain,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Certificate-Revocation-List-V1,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Certificate-Revocation-List-V3,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Hotsite-Poll-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enabled-Authorization-Packages,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-In-Exchange-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Normal-Poll-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Escalation-Procedure,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Replication-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Hotsite-Poll-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Available-Authorization-Packages,CN=Schema,CN=Configuration,DC=X
changetype: delete

# Changes for earlier schemas

dn: CN=Application-Entity,CN=schema,CN=configuration,DC=X
changetype: modify
delete: systemMustContain
systemMustContain: presentationAddress
-

dn: CN=DMD,CN=schema,CN=configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: foreignDSAs
-

dn: CN=NTDS-DSA,CN=schema,CN=configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: presentationAddress
-

dn: CN=Top,CN=schema,CN=configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: masterDSA
-


dn: CN=Foreign-DSAs,CN=schema,CN=configuration,dc=X
changetype: delete


dn: CN=Presentation-Address,CN=schema,CN=configuration,dc=X
changetype: delete

dn: CN=Ref-Full-Replicas,CN=schema,CN=configuration,dc=X
changetype: delete

dn: CN=Ref-Master-DSA,CN=schema,CN=configuration,dc=X
changetype: delete

# End of changes for earlier schemas


dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Config NC changes

# Extended rights

dn: CN=Open-Address-Book,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 3e74f60f-3e73-11d1-a9c0-0000f80367c1
displayName: Open Address Book
rightsGuid: a1990816-4298-11d1-ade2-00c04fd8d5cd

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Modify Personal Information
rightsGuid: 77B5B886-944A-11d1-AEBD-0000F80367C1

dn: CN=Email-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Modify Email Information
rightsGuid: E45795B2-9455-11d1-AEBD-0000F80367C1

dn: CN=Web-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Modify Web Information
rightsGuid: E45795B3-9455-11d1-AEBD-0000F80367C1


# Display-Specifiers

dn: CN=localGroup-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: delete

dn: CN=nTFRSSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd68-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextmenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
classDisplayName: NTFRS Settings

dn: CN=nTFRSReplicaSet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd69-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
classDisplayName: NTFRS Replica Set

dn: CN=mSFTFRS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd6a-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
classDisplayName: Microsoft FRS


dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: treatAsLeaf
treatAsLeaf: TRUE
-
delete: adminPropertyPages
adminPropertyPages: 5,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 6,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
add: adminPropertyPages
adminPropertyPages: 5,{FD57D295-4FD9-11D1-854E-00C04FC31FD3}
adminPropertyPages: 6,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 7,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
delete: attributeDisplayNames
attributeDisplayNames: comment,Comment
attributeDisplayNames: company,Company
attributeDisplayNames: distinguishedName,X500 DN
attributeDisplayNames: facsimileTelephoneNumber, Facsimile Telephone Numbers
attributeDisplayNames: generationQualifier, Generation Qualifier
attributeDisplayNames: internationalISDNNumber, International ISDN Number
attributeDisplayNames: mobile,Cellular Phone Number
attributeDisplayNames: personalTitle,Personal Title
attributeDisplayNames: physicalDeliveryOfficeName,Delivery Office
attributeDisplayNames: postalCode,ZIP Code
attributeDisplayNames: primaryGroupID,Primary Group SID
attributeDisplayNames: streetAddress,Address
attributeDisplayNames: telephoneNumber,Telephone Number
attributeDisplayNames: title,Title
attributeDisplayNames: url,Web Page Address
attributeDisplayNames: userAccountControl,User Account Control Flags
-
add: attributeDisplayNames
attributeDisplayNames: assistant,Assistant
attributeDisplayNames: comment,User Account Comment
attributeDisplayNames: co,Company
attributeDisplayNames: distinguishedName,X500 Distinguished Name
attributeDisplayNames: facsimileTelephoneNumber,Facsimile Telephone Number
attributeDisplayNames: generationQualifier,Name Suffix
attributeDisplayNames: internationalISDNNumber, International ISDN Number (Others)
attributeDisplayNames: ipPhone,IP Phone Number
attributeDisplayNames: mobile,Primary Mobile Phone Number
attributeDisplayNames: otherFacsimileTelephoneNumber,Facsimile Telephone Number (Others)
attributeDisplayNames: otherHomePhone,Home Phone (Others)
attributeDisplayNames: otherIpPhone,IP Phone Number (Others)
attributeDisplayNames: otherMailbox,E-Mail Address (Others)
attributeDisplayNames: otherMobile,Mobile Phone Number (Others)
attributeDisplayNames: otherPager,Pager Number (Others)
attributeDisplayNames: otherTelephone,Office Telephone Number (Others)
attributeDisplayNames: personalTitle,Title
attributeDisplayNames: physicalDeliveryOfficeName,Office Location
attributeDisplayNames: postalCode,ZIP/Postal Code
attributeDisplayNames: primaryInternationalISDNNumber,International ISDN Number
attributeDisplayNames: primaryTelexNumber,Telex Number
attributeDisplayNames: streetAddress,Other Address
attributeDisplayNames: telephoneNumber,Primary Phone
attributeDisplayNames: telexNumber,Telex Number (Others)
attributeDisplayNames: url,Web Page Address (Others)
attributeDisplayNames: userPrincipalName,Logon Name
attributeDisplayNames: wWWHomePage,Web Page Address
-

dn: CN=group-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: attributeDisplayNames
attributeDisplayNames: desctription,Description
attributeDisplayNames: contactName,Contact Name
attributeDisplayNames: distinguishedName,X500 DN
attributeDisplayNames: groupAttributes,Group Attribute Flags
-
add: attributeDisplayNames
attributeDisplayNames: description,Description
attributeDisplayNames: distinguishedName,X500 Distinguished Name
attributeDisplayNames: managedBy,Managed By
-

dn: CN=domainDNS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: classDisplayName
classDisplayName: Domain (DNS)
-
add: classDisplayName
classDisplayName: Domain
-
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: assistant,Assistant
attributeDisplayNames: cn,Name
attributeDisplayNames: comment,Comment
attributeDisplayNames: co,Company
attributeDisplayNames: department,Department
attributeDisplayNames: description,Description
attributeDisplayNames: directReports,Direct Reports
attributeDisplayNames: distinguishedName,X500 Distinguished Name
attributeDisplayNames: division,Division
attributeDisplayNames: employeeID,Employee ID
attributeDisplayNames: facsimileTelephoneNumber,Facsimile Telephone Number
attributeDisplayNames: generationQualifier,Name Suffix
attributeDisplayNames: givenName,First Name
attributeDisplayNames: homePhone,Home Phone
attributeDisplayNames: homePostalAddress,Home Address
attributeDisplayNames: info,Notes
attributeDisplayNames: initials,Initials
attributeDisplayNames: internationalISDNNumber,International ISDN Number (Others)
attributeDisplayNames: ipPhone,IP Phone Number
attributeDisplayNames: l,City
attributeDisplayNames: mail,E-Mail Address
attributeDisplayNames: manager,Manager
attributeDisplayNames: memberOf,Group Membership
attributeDisplayNames: middleName,Middle Name
attributeDisplayNames: mobile,Primary Mobile Phone Number
attributeDisplayNames: otherHomePhone,Home Phone Number (Others)
attributeDisplayNames: otherIpPhone,IP Phone Number (Others)
attributeDisplayNames: otherMailbox,E-Mail Address (Others)
attributeDisplayNames: otherMobile,Mobile Phone Number (Others)
attributeDisplayNames: otherPager,Pager Number (Others)
attributeDisplayNames: otherTelephone,Telephone Number (Others)
attributeDisplayNames: personalTitle,Personal Title
attributeDisplayNames: physicalDeliveryOfficeName,Office Location
attributeDisplayNames: postalCode,ZIP/Postal Code
attributeDisplayNames: postOfficeBox,Post Office Box
attributeDisplayNames: primaryInternationalISDNNumber,International ISDN Number
attributeDisplayNames: primaryTelexNumber,Telex Number
attributeDisplayNames: sn,Last Name
attributeDisplayNames: st,State
attributeDisplayNames: streetAddress,Other Address
attributeDisplayNames: telephoneNumber,Primary Phone
attributeDisplayNames: telexNumber,Telex Number (Others)
attributeDisplayNames: url,Web Page Address (Others)
attributeDisplayNames: wWWHomePage,Web Page Address
-

dn: CN=domainPolicy-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: adminPropertyPages
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 4,{AAD30A04-E1D0-11d0-B859-00A024CDD4DE}
-
add: adminPropertyPages
adminPropertyPages: 2,{AAD30A04-E1D0-11d0-B859-00A024CDD4DE}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-

dn: CN=serviceAdministrationPoint-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: classDisplayName
classDisplayName: Service Administration Point
-
add: classDisplayName
classDisplayName: Service
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
attributeDisplayNames: operatingSystem,Operating System
attributeDisplayNames: operatingSystemVersion,Operating System Version
attributeDisplayNames: type,Type
-

dn: CN=printQueue-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Directory Service Name
attributeDisplayNames: uNCName,Network Name
attributeDisplayNames: assetNumber,Asset Number
attributeDisplayNames: bytesPerMinute,Bytes per Minute
attributeDisplayNames: contactName,Contact
attributeDisplayNames: description,Comment
attributeDisplayNames: driverName,Model
attributeDisplayNames: driverVersion,Driver Version
attributeDisplayNames: location,Location
attributeDisplayNames: portName,Port
attributeDisplayNames: printBinNames,Input Trays
attributeDisplayNames: printCollate,Supports Collation
attributeDisplayNames: printColor,Supports Color Printing
attributeDisplayNames: printDuplexSupported,Supports Double-sided Printing
attributeDisplayNames: printerName,Name
attributeDisplayNames: printFormName,Form Name
attributeDisplayNames: printLanguage,Data Format
attributeDisplayNames: printMACAddress,Physical Network Address
attributeDisplayNames: printMaxCopies,Maximum Number of Copies
attributeDisplayNames: printMaxResolutionSupported,Maximum Resolution
attributeDisplayNames: printMaxXExtent,Maximum Printable Width
attributeDisplayNames: printMaxYExtent,Maximum Printable Height
attributeDisplayNames: printMediaReady,Paper Available
attributeDisplayNames: printMediaSupported,Paper Types Supported
attributeDisplayNames: printMemory,Installed Memory
attributeDisplayNames: printMinXExtent,Minimum Printable Width
attributeDisplayNames: printMinYExtent,Minimum Printable Height
attributeDisplayNames: printNetworkAddress,Network Address
attributeDisplayNames: printNumberUp,Supports N-Up Printing
attributeDisplayNames: operatingSystem,Operating System
attributeDisplayNames: operatingSystemVersion,Operating System Version
attributeDisplayNames: printOrientationsSupported,Orientations Supported
attributeDisplayNames: printOwner,Owner Name
attributeDisplayNames: printRate,Speed
attributeDisplayNames: printRateUnit,Speed Units
attributeDisplayNames: printPagesPerMinute,Pages per Minute
attributeDisplayNames: printShareName,Share Name
attributeDisplayNames: printStaplingSupported,Supports Stapling
attributeDisplayNames: printStatus,State
attributeDisplayNames: priority,Print Job Priority
attributeDisplayNames: serverName,Server Name
attributeDisplayNames: url,Web Page Address
attributeDisplayNames: versionNumber,Object Version
attributeDisplayNames: whenChanged,Date Modified
attributeDisplayNames: whenCreated,Date Created
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
-

dn: CN=trustedDomain-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
-

dn: CN=volume-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
attributeDisplayNames: uNCName,Network Path
-
delete: classDisplayName
classDisplayName: Volume
-
add: classDisplayName
classDisplayName: Shared Folder
-

dn: CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: add
objectClass: interSiteTransportContainer
hideFromAB: TRUE

dn: CN=IP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: add
objectClass: interSiteTransport
transportDllName: ismip.dll
hideFromAB: TRUE

dn: CN=SMTP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: add
objectClass: interSiteTransport
transportDllName: ismsmtp.dll
hideFromAB: TRUE

dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: delete

dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: queryPolicy
lDAPAdminLimits: MaxConnections=1000
lDAPAdminLimits: InitRecvTimeout=120
lDAPAdminLimits: AllowDeepNonIndexSearch=False
lDAPAdminLimits: MaxConnIdleTime=900
lDAPAdminLimits: MaxActiveQueries=20
lDAPAdminLimits: MaxNotificationPerConn=5
lDAPAdminLimits: MaxPageSize=1000
lDAPAdminLimits: MaxQueryDuration=120
lDAPAdminLimits: MaxTempTableSize=10000
lDAPAdminLimits: MaxResultSetSize=262144
lDAPAdminLimits: MaxPoolThreads=4
lDAPAdminLimits: MaxDatagramRecv=4096
hideFromAB: TRUE

# Used to decide if earlier changes are present,
# so delete this last

dn: CN=Master-DSA,CN=schema,CN=configuration,dc=X
changetype: delete

# Object-Version on schema container

dn: CN=schema,CN=configuration,DC=X
changetype: modify
add: objectVersion
objectVersion: 1
-

```

### Sch00.ldf

```

dn: CN=container-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: delete

dn: CN=default-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: delete

```

### Sch1.ldf

```

dn: CN=container-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
shellPropertyPages: 1,{f2c3faae-c8ac-11d0-bcdb-00c04fd8d5b6}
contextMenu: 0,{62AE1F9A-126A-11D0-A14B-0800361B1103}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{6BA3F852-23C6-11D1-B91F-00A0C9A06D2D}
classDisplayName: Container
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description

dn: CN=default-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
shellPropertyPages: 1,{f2c3faae-c8ac-11d0-bcdb-00c04fd8d5b6}
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description


# Attribute Adds

dn: CN=Pek-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: pekList
adminDisplayName: Pek-List
adminDescription: Pek-List
attributeId: 1.2.840.113556.1.4.865
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gzA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE
systemFlags: 1

dn: CN=FRS-Flags,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSFlags
adminDisplayName: FRS-Flags
adminDescription: FRS-Flags
attributeId: 1.2.840.113556.1.4.874
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fSUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Site-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: siteList
adminDisplayName: Site-List
adminDescription: Site-List
attributeId: 1.2.840.113556.1.4.821
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3CwM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Msi-Script,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msiScript
adminDisplayName: Msi-Script
adminDescription: Msi-Script
attributeId: 1.2.840.113556.1.4.814
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: E4Ph2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSVersion
adminDisplayName: FRS-Version
adminDescription: FRS-Version
attributeId: 1.2.840.113556.1.4.882
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: hSUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Treat-As-Leaf,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: treatAsLeaf
adminDisplayName: Treat-As-Leaf
adminDescription: Treat-As-Leaf
attributeId: 1.2.840.113556.1.4.806
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 40TQjx930RGurgAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Product-Code,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: productCode
adminDisplayName: Product-Code
adminDescription: Product-Code
attributeId: 1.2.840.113556.1.4.818
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 16
schemaIdGuid:: F4Ph2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=DNS-Host-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: dNSHostName
adminDisplayName: DNS-Host-Name
adminDescription: DNS-Host-Name
attributeId: 1.2.840.113556.1.4.619
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2048
schemaIdGuid:: R5Xjchh70RGt7wDAT9jVzQ==
hideFromAB: TRUE


dn: CN=Create-Dialog,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: createDialog
adminDisplayName: Create-Dialog
adminDescription: Create-Dialog
attributeId: 1.2.840.113556.1.4.810
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ipUJKzGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-SCP-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootSCPBL
adminDisplayName: netboot-SCP-BL
adminDescription: netboot-SCP-BL
attributeId: 1.2.840.113556.1.4.864
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gjA4B9+R0RGuvAAA+ANnwQ==
linkID: 101
hideFromAB: TRUE
systemFlags: 1

dn: CN=Site-Link-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: siteLinkList
adminDisplayName: Site-Link-List
adminDescription: Site-Link-List
attributeId: 1.2.840.113556.1.4.822
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3SwM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Tools,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootTools
adminDisplayName: netboot-Tools
adminDescription: netboot-Tools
attributeId: 1.2.840.113556.1.4.858
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fzA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=Msi-Script-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msiScriptName
adminDisplayName: Msi-Script-Name
adminDescription: Msi-Script-Name
attributeId: 1.2.840.113556.1.4.845
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Yt2nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootServer
adminDisplayName: netboot-Server
adminDescription: netboot-Server
attributeId: 1.2.840.113556.1.4.860
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gTA4B9+R0RGuvAAA+ANnwQ==
linkID: 100
hideFromAB: TRUE

dn: CN=Msi-Script-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msiScriptSize
adminDisplayName: Msi-Script-Size
adminDescription: Msi-Script-Size
attributeId: 1.2.840.113556.1.4.846
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Y92nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=LDAP-IPDeny-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: lDAPIPDenyList
adminDisplayName: LDAP-IPDeny-List
adminDescription: LDAP-IPDeny-List
attributeId: 1.2.840.113556.1.4.844
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: U6NZc/eQ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Install-Ui-Level,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: installUiLevel
adminDisplayName: Install-Ui-Level
adminDescription: Install-Ui-Level
attributeId: 1.2.840.113556.1.4.847
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ZN2nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Terminal-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: terminalServer
adminDisplayName: Terminal-Server
adminDescription: Terminal-Server
attributeId: 1.2.840.113556.1.4.885
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HJq2bSKU0RGuvQAA+ANnwQ==
hideFromAB: TRUE

dn: CN=LDAP-Admin-Limits,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: lDAPAdminLimits
adminDisplayName: LDAP-Admin-Limits
adminDescription: LDAP-Admin-Limits
attributeId: 1.2.840.113556.1.4.843
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UqNZc/eQ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Create-Wizard-Ext,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: createWizardExt
adminDisplayName: Create-Wizard-Ext
adminDescription: Create-Wizard-Ext
attributeId: 1.2.840.113556.1.4.812
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: i5UJKzGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Purported-Search,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: purportedSearch
adminDisplayName: Purported-Search
adminDescription: Purported-Search
attributeId: 1.2.840.113556.1.4.886
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2048
schemaIdGuid:: UE61tDqU0RGuvQAA+ANnwQ==
hideFromAB: TRUE


dn: CN=ms-RRAS-Attribute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRRASAttribute
adminDisplayName: ms-RRAS-Attribute
adminDescription: ms-RRAS-Attribute
attributeId: 1.2.840.113556.1.4.884
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rZib842T0RGuvQAA+ANnwQ==
hideFromAB: TRUE

dn: CN=File-Ext-Priority,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fileExtPriority
adminDisplayName: File-Ext-Priority
adminDescription: File-Ext-Priority
attributeId: 1.2.840.113556.1.4.816
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: FYPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=Can-Upgrade-Script,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: canUpgradeScript
adminDisplayName: Can-Upgrade-Script
adminDescription: Can-Upgrade-Script
attributeId: 1.2.840.113556.1.4.815
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FIPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=App-Schema-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: appSchemaVersion
adminDisplayName: App-Schema-Version
adminDescription: App-Schema-Version
attributeId: 1.2.840.113556.1.4.848
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Zd2nlhiR0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Primary-Member,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSPrimaryMember
adminDisplayName: FRS-Primary-Member
adminDescription: FRS-Primary-Member
attributeId: 1.2.840.113556.1.4.878
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
linkId: 106
schemaIdGuid:: gSUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=Remote-Storage-GUID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: remoteStorageGUID
adminDisplayName: Remote-Storage-GUID
adminDescription: Remote-Storage-GUID
attributeId: 1.2.840.113556.1.4.809
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: sMU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=netboot-Max-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootMaxClients
adminDisplayName: netboot-Max-Clients
adminDescription: netboot-Max-Clients
attributeId: 1.2.840.113556.1.4.851
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=FRS-Member-Reference,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSMemberReference
adminDisplayName: FRS-Member-Reference
adminDescription: FRS-Member-Reference
attributeId: 1.2.840.113556.1.4.875
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fiUTKnOT0RGuvAAA+ANnwQ==
linkID: 104
hideFromAB: TRUE
systemFlags: 2

dn: CN=Upgrade-Product-Code,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: upgradeProductCode
adminDisplayName: Upgrade-Product-Code
adminDescription: Upgrade-Product-Code
attributeId: 1.2.840.113556.1.4.813
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 16
schemaIdGuid:: EoPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Time-Last-Command,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSTimeLastCommand
adminDisplayName: FRS-Time-Last-Command
adminDescription: FRS-Time-Last-Command
attributeId: 1.2.840.113556.1.4.880
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gyUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE


dn: CN=netboot-New-Machine-OU,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootNewMachineOU
adminDisplayName: netboot-New-Machine-OU
adminDescription: netboot-New-Machine-OU
attributeId: 1.2.840.113556.1.4.856
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Limit-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootLimitClients
adminDisplayName: netboot-Limit-Clients
adminDescription: netboot-Limit-Clients
attributeId: 1.2.840.113556.1.4.850
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dzA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Signature-Algorithms,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: signatureAlgorithms
adminDisplayName: Signature-Algorithms
adminDescription: Signature-Algorithms
attributeId: 1.2.840.113556.1.4.824
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ssU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Partner-Auth-Level,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSPartnerAuthLevel
adminDisplayName: FRS-Partner-Auth-Level
adminDescription: FRS-Partner-Auth-Level
attributeId: 1.2.840.113556.1.4.877
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Enrollment-Providers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: enrollmentProviders
adminDisplayName: Enrollment-Providers
adminDescription: Enrollment-Providers
attributeId: 1.2.840.113556.1.4.825
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: s8U5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Member-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSMemberReferenceBL
adminDisplayName: FRS-Member-Reference-BL
adminDescription: FRS-Member-Reference-BL
attributeId: 1.2.840.113556.1.4.876
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fyUTKnOT0RGuvAAA+ANnwQ==
linkID: 105
hideFromAB: TRUE
systemFlags: 1

dn: CN=Certificate-Templates,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: certificateTemplates
adminDisplayName: Certificate-Templates
adminDescription: Certificate-Templates
attributeId: 1.2.840.113556.1.4.823
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: scU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Pek-Key-Change-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: pekKeyChangeInterval
adminDisplayName: Pek-Key-Change-Interval
adminDescription: Pek-Key-Change-Interval
attributeId: 1.2.840.113556.1.4.866
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Localized-Description,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: localizedDescription
adminDisplayName: Localized-Description
adminDescription: Localized-Description
attributeId: 1.2.840.113556.1.4.817
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FoPh2TmJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Frs-Computer-Reference,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: frsComputerReference
adminDisplayName: Frs-Computer-Reference
adminDescription: Frs-Computer-Reference
attributeId: 1.2.840.113556.1.4.869
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eCUTKnOT0RGuvAAA+ANnwQ==
linkID: 102
systemFlags: 2
hideFromAB: TRUE

dn: CN=Alt-Security-Identities,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: altSecurityIdentities
adminDisplayName: Alt-Security-Identities
adminDescription: Alt-Security-Identities
attributeId: 1.2.840.113556.1.4.867
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: DPP7AP6R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Answer-Requests,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootAnswerRequests
adminDisplayName: netboot-Answer-Requests
adminDescription: netboot-Answer-Requests
attributeId: 1.2.840.113556.1.4.853
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ejA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Bridgehead-Server-List-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: bridgeheadServerListBL
adminDisplayName: Bridgehead-Server-List-BL
adminDescription: Bridgehead-Server-List-BL
attributeId: 1.2.840.113556.1.4.820
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2ywM1VGJ0RGuvAAA+ANnwQ==
linkID: 99
hideFromAB: TRUE
systemFlags: 1

dn: CN=Frs-Computer-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: frsComputerReferenceBL
adminDisplayName: Frs-Computer-Reference-BL
adminDescription: Frs-Computer-Reference-BL
attributeId: 1.2.840.113556.1.4.870
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eSUTKnOT0RGuvAAA+ANnwQ==
linkID: 103
hideFromAB: TRUE
systemFlags: 1

dn: CN=FRS-Control-Data-Creation,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSControlDataCreation
adminDisplayName: FRS-Control-Data-Creation
adminDescription: FRS-Control-Data-Creation
attributeId: 1.2.840.113556.1.4.871
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: eiUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Is-Critical-System-Object,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: isCriticalSystemObject
adminDisplayName: Is-Critical-System-Object
adminDescription: Is-Critical-System-Object
attributeId: 1.2.840.113556.1.4.868
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: DfP7AP6R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Allow-New-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootAllowNewClients
adminDisplayName: netboot-Allow-New-Clients
adminDescription: netboot-Allow-New-Clients
attributeId: 1.2.840.113556.1.4.849
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: djA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Time-Last-Config-Change,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSTimeLastConfigChange
adminDisplayName: FRS-Time-Last-Config-Change
adminDescription: FRS-Time-Last-Config-Change
attributeId: 1.2.840.113556.1.4.881
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Bridgehead-Transport-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: bridgeheadTransportList
adminDisplayName: Bridgehead-Transport-List
adminDescription: Bridgehead-Transport-List
attributeId: 1.2.840.113556.1.4.819
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2iwM1VGJ0RGuvAAA+ANnwQ==
linkID: 98
hideFromAB: TRUE

dn: CN=FRS-Service-Command-Status,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSServiceCommandStatus
adminDisplayName: FRS-Service-Command-Status
adminDescription: FRS-Service-Command-Status
attributeId: 1.2.840.113556.1.4.879
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 512
schemaIdGuid:: giUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Control-Inbound-Backlog,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSControlInboundBacklog
adminDisplayName: FRS-Control-Inbound-Backlog
adminDescription: FRS-Control-Inbound-Backlog
attributeId: 1.2.840.113556.1.4.872
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: eyUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-IntelliMirror-OSes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootIntelliMirrorOSes
adminDisplayName: netboot-IntelliMirror-OSes
adminDescription: netboot-IntelliMirror-OSes
attributeId: 1.2.840.113556.1.4.857
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fjA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=FRS-Control-Outbound-Backlog,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSControlOutboundBacklog
adminDisplayName: FRS-Control-Outbound-Backlog
adminDescription: FRS-Control-Outbound-Backlog
attributeId: 1.2.840.113556.1.4.873
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32
schemaIdGuid:: fCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Current-Client-Count,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootCurrentClientCount
adminDisplayName: netboot-Current-Client-Count
adminDescription: netboot-Current-Client-Count
attributeId: 1.2.840.113556.1.4.852
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=IPSEC-Negotiation-Policy-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: iPSECNegotiationPolicyType
adminDisplayName: IPSEC-Negotiation-Policy-Type
adminDescription: IPSEC-Negotiation-Policy-Type
attributeId: 1.2.840.113556.1.4.887
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=ms-RRAS-Vendor-Attribute-Entry,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRRASVendorAttributeEntry
adminDisplayName: ms-RRAS-Vendor-Attribute-Entry
adminDescription: ms-RRAS-Vendor-Attribute-Entry
attributeId: 1.2.840.113556.1.4.883
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rJib842T0RGuvQAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Locally-Installed-OSes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootLocallyInstalledOSes
adminDisplayName: netboot-Locally-Installed-OSes
adminDescription: netboot-Locally-Installed-OSes
attributeId: 1.2.840.113556.1.4.859
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=IPSEC-Negotiation-Policy-Action,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: iPSECNegotiationPolicyAction
adminDisplayName: IPSEC-Negotiation-Policy-Action
adminDescription: IPSEC-Negotiation-Policy-Action
attributeId: 1.2.840.113556.1.4.888
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-New-Machine-Naming-Policy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootNewMachineNamingPolicy
adminDisplayName: netboot-New-Machine-Naming-Policy
adminDescription: netboot-New-Machine-Naming-Policy
attributeId: 1.2.840.113556.1.4.855
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fDA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=netboot-Answer-Only-Valid-Clients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: netbootAnswerOnlyValidClients
adminDisplayName: netboot-Answer-Only-Valid-Clients
adminDescription: netboot-Answer-Only-Valid-Clients
attributeId: 1.2.840.113556.1.4.854
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ezA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE

dn: CN=UPN-Suffixes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
lDAPDisplayName: uPNSuffixes
adminDescription: UPN-Suffixes
adminDisplayName: UPN-Suffixes
attributeID: 1.2.840.113556.1.4.890
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: FALSE
schemaIDGUID:: v2AhAySY0RGuwAAA+ANnwQ==
searchFlags: 0
systemOnly: FALSE
hideFromAB: TRUE

dn: CN=Additional-Trusted-Service-Names,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
lDAPDisplayName: additionalTrustedServiceNames
adminDescription: Additional-Trusted-Service-Names
adminDisplayName: Additional-Trusted-Service-Names
attributeID: 1.2.840.113556.1.4.889
attributeSyntax: 2.5.5.12
oMSyntax: 64
isSingleValued: FALSE
schemaIDGUID:: vmAhAySY0RGuwAAA+ANnwQ==
searchFlags: 0
systemOnly: FALSE
hideFromAB: TRUE


# Change because OID got reused with different syntax.
# We will delete Replica-Set-Type, and add FRS-Replica-Set-Type
# with a new OID.

dn: CN=NTFRS-Replica-Set,CN=schema,CN=configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.30
-

dn: CN=Replica-Set-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=FRS-Replica-Set-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fRSReplicaSetType
adminDisplayName: FRS-Replica-Set-Type
adminDescription: FRS-Replica-Set-Type
attributeId: 1.2.840.113556.1.4.31
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: a3PZJnBg0RGpxgAA+ANnwQ==
hideFromAB: TRUE

# End of change

# Attribute Renames, plus some modifies in some cases

dn: CN=Replication-DS-Poll,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-DS-Poll
deleteoldrdn: 1

dn: CN=FRS-DS-Poll,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSDSPoll
-
replace: adminDisplayName
adminDisplayName: FRS-DS-Poll
-
replace: adminDescription
adminDescription: FRS-DS-Poll
-


dn: CN=Com-Unique-Cat-Id,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: Category-Id
deleteoldrdn: 1

dn: CN=Category-Id,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: categoryId
-
replace: adminDisplayName
adminDisplayName: Category-Id
-
replace: adminDescription
adminDescription: Category-Id
-


dn: CN=Replication-Root-Path,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Root-Path
deleteoldrdn: 1

dn: CN=FRS-Root-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSRootPath
-
replace: adminDisplayName
adminDisplayName: FRS-Root-Path
-
replace: adminDescription
adminDescription: FRS-Root-Path
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Replication-File-Filter,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-File-Filter
deleteoldrdn: 1

dn: CN=FRS-File-Filter,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSFileFilter
-
replace: adminDisplayName
adminDisplayName: FRS-File-Filter
-
replace: adminDescription
adminDescription: FRS-File-Filter
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Replication-Level-Limit,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Level-Limit
deleteoldrdn: 1

dn: CN=FRS-Level-Limit,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSLevelLimit
-
replace: adminDisplayName
adminDisplayName: FRS-Level-Limit
-
replace: adminDescription
adminDescription: FRS-Level-Limit
-


dn: CN=Replication-Extensions,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Extensions
deleteoldrdn: 1

dn: CN=FRS-Extensions,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSExtensions
-
replace: adminDisplayName
adminDisplayName: FRS-Extensions
-
replace: adminDescription
adminDescription: FRS-Extensions
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 65536
-

dn: CN=Replication-Staging-Path,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Staging-Path
deleteoldrdn: 1

dn: CN=FRS-Staging-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSStagingPath
-
replace: adminDisplayName
adminDisplayName: FRS-Staging-Path
-
replace: adminDescription
adminDescription: FRS-Staging-Path
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Code-Package,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: Msi-Script-Path
deleteoldrdn: 1

dn: CN=Msi-Script-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: msiScriptPath
-
replace: adminDisplayName
adminDisplayName: Msi-Script-Path
-
replace: adminDescription
adminDescription: Msi-Script-Path
-


dn: CN=Replication-DB-Path,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Working-Path
deleteoldrdn: 1

dn: CN=FRS-Working-Path,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSWorkingPath
-
replace: adminDisplayName
adminDisplayName: FRS-Working-Path
-
replace: adminDescription
adminDescription: FRS-Working-Path
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-


dn: CN=Replica-Version-GUID,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Version-GUID
deleteoldrdn: 1

dn: CN=FRS-Version-GUID,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSVersionGuid
-
replace: adminDisplayName
adminDisplayName: FRS-Version-GUID
-
replace: adminDescription
adminDescription: FRS-Version-GUID
-
add: rangeLower
rangeLower: 16
-
add: rangeUpper
rangeUpper: 16
-


dn: CN=Replication-Root-Security,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Root-Security
deleteoldrdn: 1

dn: CN=FRS-Root-Security,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSRootSecurity
-
replace: adminDisplayName
adminDisplayName: FRS-Root-Security
-
replace: adminDescription
adminDescription: FRS-Root-Security
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 65535
-


dn: CN=Replication-Update-Timeout,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Update-Timeout
deleteoldrdn: 1

dn: CN=FRS-Update-Timeout,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSUpdateTimeout
-
replace: adminDisplayName
adminDisplayName: FRS-Update-Timeout
-
replace: adminDescription
adminDescription: FRS-Update-Timeout
-


dn: CN=Replication-Service-Command,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Service-Command
deleteoldrdn: 1

dn: CN=FRS-Service-Command,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSServiceCommand
-
replace: adminDisplayName
adminDisplayName: FRS-Service-Command
-
replace: adminDescription
adminDescription: FRS-Service-Command
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 512
-


dn: CN=Replica-Set-GUID,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Replica-Set-GUID
deleteoldrdn: 1

dn: CN=FRS-Replica-Set-GUID,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSReplicaSetGuid
-
replace: adminDisplayName
adminDisplayName: FRS-Replica-Set-GUID
-
replace: adminDescription
adminDescription: FRS-Replica-Set-GUID
-


dn: CN=Replication-Status,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Fault-Condition
deleteoldrdn: 1

dn: CN=FRS-Fault-Condition,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSFaultCondition
-
replace: adminDisplayName
adminDisplayName: FRS-Fault-Condition
-
replace: adminDescription
adminDescription: FRS-Fault-Condition
-
add: rangeLower
rangeLower: 1
-
add: rangeUpper
rangeUpper: 16
-


dn: CN=Replication-Directory-Filter,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: FRS-Directory-Filter
deleteoldrdn: 1

dn: CN=FRS-Directory-Filter,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: fRSDirectoryFilter
-
replace: adminDisplayName
adminDisplayName: FRS-Directory-Filter
-
replace: adminDescription
adminDescription: FRS-Directory-Filter
-
add: rangeLower
rangeLower: 0
-
add: rangeUpper
rangeUpper: 2048
-

dn: CN=Created-Entry,CN=schema,CN=configuration,DC=X
changetype: modrdn
newrdn: rpc-Ns-Entry-Flags
deleteoldrdn: 1

dn: CN=rpc-Ns-Entry-Flags,CN=schema,CN=configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: rpcNsEntryFlags
-
replace: adminDisplayName
adminDisplayName: rpc-Ns-Entry-Flags
-
replace: adminDescription
adminDescription: rpc-Ns-Entry-Flags
-


# Class Adds

dn: CN=NTFRS-Member,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: nTFRSMember
adminDisplayName: NTFRS-Member
adminDescription: NTFRS-Member
governsId: 1.2.840.113556.1.5.153
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.515
systemMayContain: 1.2.840.113556.1.4.485
systemMayContain: 1.2.840.113556.1.4.500
systemMayContain: 1.2.840.113556.1.4.535
systemMayContain: 1.2.840.113556.1.4.877
systemMayContain: 1.2.840.113556.1.4.874
systemMayContain: 1.2.840.113556.1.4.536
systemMayContain: 1.2.840.113556.1.4.873
systemMayContain: 1.2.840.113556.1.4.872
systemMayContain: 1.2.840.113556.1.4.871
systemMayContain: 1.2.840.113556.1.4.869
systemPossSuperiors: 1.2.840.113556.1.5.102
schemaIdGuid:: hiUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NTFRS-Member,CN=Schema,CN=Configuration,DC=X

dn: CN=Site-Link-Bridge,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: siteLinkBridge
adminDisplayName: Site-Link-Bridge
adminDescription: Site-Link-Bridge
governsId: 1.2.840.113556.1.5.148
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.822
systemPossSuperiors: 1.2.840.113556.1.5.141
schemaIdGuid:: 3ywM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Site-Link-Bridge,CN=Schema,CN=Configuration,DC=X

dn: CN=RRAS-Administration-Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rRASAdministrationConnectionPoint
adminDisplayName: RRAS-Administration-Connection-Point
adminDescription: RRAS-Administration-Connection-Point
governsId: 1.2.840.113556.1.5.150
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.94
systemMayContain: 1.2.840.113556.1.4.884
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: vsU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RRAS-Administration-Connection-Point,CN=Schema,CN=Configuration,DC=X

dn: CN=NTFRS-Subscriptions,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
lDAPDisplayName: nTFRSSubscriptions
adminDescription: NTFRS-Subscriptions
adminDisplayName: NTFRS-Subscriptions
governsID: 1.2.840.113556.1.5.154
objectClassCategory: 1
rDNAttID: 2.5.4.3
subClassOf: 2.5.6.0
schemaIDGUID:: hyUTKnOT0RGuvAAA+ANnwQ==
systemMayContain: 1.2.840.113556.1.4.486
systemMayContain: 1.2.840.113556.1.4.882
systemMayContain: 1.2.840.113556.1.4.536
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.5.154
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NTFRS-Subscriptions,CN=Schema,CN=Configuration,DC=X

dn: CN=Remote-Storage-Service-Point,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: remoteStorageServicePoint
adminDisplayName: Remote-Storage-Service-Point
adminDescription: Remote-Storage-Service-Point
governsId: 1.2.840.113556.1.5.146
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.94
systemMayContain: 1.2.840.113556.1.4.809
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: vcU5KmCJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Remote-Storage-Service-Point,CN=Schema,CN=Configuration,DC=X


dn: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
lDAPDisplayName: intellimirrorGroup
adminDescription: Intellimirror-Group
adminDisplayName: Intellimirror-Group
governsID: 1.2.840.113556.1.5.152
objectClassCategory: 1
rDNAttID: 2.5.4.3
schemaIDGUID:: hjA4B9+R0RGuvAAA+ANnwQ==
subClassOf: 2.5.6.0
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.3.23
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X

dn: CN=Site-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: siteLink
adminDisplayName: Site-Link
adminDescription: Site-Link
governsId: 1.2.840.113556.1.5.147
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.821
systemMayContain: 1.2.840.113556.1.4.211
systemMayContain: 1.2.840.113556.1.2.135
systemPossSuperiors: 1.2.840.113556.1.5.141
schemaIdGuid:: 3iwM1VGJ0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Site-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=Intellimirror-SCP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: intellimirrorSCP
adminDisplayName: Intellimirror-SCP
adminDescription: Intellimirror-SCP
governsId: 1.2.840.113556.1.5.151
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.94
systemMayContain: 1.2.840.113556.1.4.858
systemMayContain: 1.2.840.113556.1.4.860
systemMayContain: 1.2.840.113556.1.4.856
systemMayContain: 1.2.840.113556.1.4.855
systemMayContain: 1.2.840.113556.1.4.851
systemMayContain: 1.2.840.113556.1.4.361
systemMayContain: 1.2.840.113556.1.4.859
systemMayContain: 1.2.840.113556.1.4.850
systemMayContain: 1.2.840.113556.1.4.857
systemMayContain: 1.2.840.113556.1.4.358
systemMayContain: 1.2.840.113556.1.4.359
systemMayContain: 1.2.840.113556.1.4.852
systemMayContain: 1.2.840.113556.1.4.853
systemMayContain: 1.2.840.113556.1.4.854
systemMayContain: 1.2.840.113556.1.4.849
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.5.152
schemaIdGuid:: hTA4B9+R0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Intellimirror-SCP,CN=Schema,CN=Configuration,DC=X

dn: CN=NTFRS-Subscriber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: nTFRSSubscriber
adminDisplayName: NTFRS-Subscriber
adminDescription: NTFRS-Subscriber
governsId: 1.2.840.113556.1.5.155
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.488
systemMustContain: 1.2.840.113556.1.4.487
systemMayContain: 1.2.840.113556.1.4.211
systemMayContain: 1.2.840.113556.1.4.485
systemMayContain: 1.2.840.113556.1.4.881
systemMayContain: 1.2.840.113556.1.4.880
systemMayContain: 1.2.840.113556.1.4.879
systemMayContain: 1.2.840.113556.1.4.500
systemMayContain: 1.2.840.113556.1.4.875
systemMayContain: 1.2.840.113556.1.4.874
systemMayContain: 1.2.840.113556.1.4.491
systemMayContain: 1.2.840.113556.1.4.536
systemPossSuperiors: 1.2.840.113556.1.5.154
schemaIdGuid:: iCUTKnOT0RGuvAAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NTFRS-Subscriber,CN=Schema,CN=Configuration,DC=X

dn: CN=RRAS-Administration-Dictionary,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rRASAdministrationDictionary
adminDisplayName: RRAS-Administration-Dictionary
adminDescription: RRAS-Administration-Dictionary
governsId: 1.2.840.113556.1.5.156
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.883
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: rpib842T0RGuvQAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RRAS-Administration-Dictionary,CN=Schema,CN=Configuration,DC=X


# Syntax in two attributes have been modified. USN-Source and
# Transport-Address-Type. We don't propagate the changes.
# We will delete both and add new attributes
# to replace them.

# Attribute and Class Modifications

dn: CN=Object-Class,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 0
-

dn: CN=Surname,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=State-Or-Province-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Street-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Title,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Postal-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Postal-Code,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Office-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Post-Office-Box,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Physical-Delivery-Office-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Home-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Telex-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Teletex-Terminal-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Facsimile-Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=X121-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=International-ISDN-Number,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Registered-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Preferred-Delivery-Method,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Picture,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Mobile-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Pager-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Initials,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Password,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Recorded-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Greetings,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Flags,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Volume,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Speed,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Voice-Mail-Recording-Length,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Forwarding-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Personal-Title,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Address-Home,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Pager-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Fax-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Mobile-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Telex-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-ISDN-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Assistant,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=User-Principal-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 2
-

dn: CN=Categories,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: rangeLower
rangeLower: 36
-
add: rangeUpper
rangeUpper: 36
-

dn: CN=Creator,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 0
-

dn: CN=Phone-Ip-Primary,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Phone-Ip-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=WWW-Page-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: s5VX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Group-Type,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 1
-
add: systemFlags
systemFlags: 2
-

dn: CN=User-Shared-Folder,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=User-Shared-Folder-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Service-Principal-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 2
-

dn: CN=Phone-Home-Other,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-


dn: CN=AutoReply,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=AutoReply-Message,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Package-Flags,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 1
-

dn: CN=AutoReply-Subject,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: spVX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=WWW-Home-Page,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: s5VX5FWU0RGuvQAA+ANnwQ==
-

dn: CN=Cross-Ref-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.890
-

dn: CN=Trusted-Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.889
-

dn: CN=Inter-Site-Transport,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.789
-
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.789
-

dn: CN=Group-Of-Names,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: objectClassCategory
objectClassCategory: 2
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.820
systemMayContain: 1.2.840.113556.1.4.864
systemMayContain: 1.2.840.113556.1.4.868
systemMayContain: 1.2.840.113556.1.4.870
systemMayContain: 1.2.840.113556.1.4.876
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.290
systemMayContain: 1.2.840.113556.1.2.291
systemMayContain: 1.2.840.113556.1.2.292
systemMayContain: 1.2.840.113556.1.2.293
systemMayContain: 1.2.840.113556.1.2.339
systemMayContain: 1.2.840.113556.1.2.340
systemMayContain: 1.2.840.113556.1.2.341
systemMayContain: 1.2.840.113556.1.2.342
systemMayContain: 1.2.840.113556.1.2.469
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.865
systemMayContain: 1.2.840.113556.1.4.866
-

dn: CN=Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultObjectCategory
defaultObjectCategory: CN=Domain-DNS,CN=Schema,CN=Configuration,DC=X
-

dn: CN=Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.867
-

dn: CN=ACS-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.765
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.885
systemMayContain: 1.2.840.113556.1.4.771
-

dn: CN=ACS-Subnet,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Class-Registration,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.252
-

dn: CN=Inter-Site-Transport-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.107
-
delete: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.142
-

dn: CN=Inter-Site-Transport,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.790
-

dn: CN=Certification-Authority,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.619
systemMayContain: 1.2.840.113556.1.4.823
systemMayContain: 1.2.840.113556.1.4.824
systemMayContain: 1.2.840.113556.1.4.825
-

dn: CN=Server,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.619
systemMayContain: 1.2.840.113556.1.4.786
systemMayContain: 1.2.840.113556.1.4.819
-

dn: CN=Print-Queue,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.631
-

dn: CN=Remote-Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.619
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.360
systemMayContain: 1.2.840.113556.1.4.486
-

dn: CN=Storage,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Class-Store,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.848
-
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.18
-

dn: CN=Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.47
systemMayContain: 1.2.840.113556.1.2.129
systemMayContain: 1.2.840.113556.1.2.144
systemMayContain: 1.2.840.113556.1.2.221
-

dn: CN=NTDS-DSA,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.786
systemMayContain: 0.9.2342.19200300.100.1.3
-

dn: CN=Package-Registration,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.20
systemMayContain: 1.2.840.113556.1.4.813
systemMayContain: 1.2.840.113556.1.4.814
systemMayContain: 1.2.840.113556.1.4.815
systemMayContain: 1.2.840.113556.1.4.816
systemMayContain: 1.2.840.113556.1.4.818
systemMayContain: 1.2.840.113556.1.4.845
systemMayContain: 1.2.840.113556.1.4.846
systemMayContain: 1.2.840.113556.1.4.847
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.17
-

dn: CN=NTDS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.607
-

dn: CN=NTDS-Connection,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.791
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.785
-
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.153
-

dn: CN=Category-Registration,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.817
-

dn: CN=Display-Specifier,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.806
systemMayContain: 1.2.840.113556.1.4.810
systemMayContain: 1.2.840.113556.1.4.812
-

dn: CN=NTFRS-Settings,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.653
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.459
systemMayContain: 1.2.840.113556.1.4.211
systemMayContain: 1.2.840.113556.1.4.486
systemMayContain: 1.2.840.113556.1.4.487
systemMayContain: 1.2.840.113556.1.4.488
systemMayContain: 1.2.840.113556.1.4.489
systemMayContain: 1.2.840.113556.1.4.490
systemMayContain: 1.2.840.113556.1.4.491
systemMayContain: 1.2.840.113556.1.4.500
systemMayContain: 1.2.840.113556.1.4.535
systemMayContain: 1.2.840.113556.1.4.564
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.43
-
add: systemPossSuperiors
systemPossSuperiors: 2.5.6.4
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.3.23
-
delete: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.17
-

dn: CN=NTFRS-Replica-Set,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.43
systemMayContain: 1.2.840.113556.1.4.31
systemMayContain: 1.2.840.113556.1.4.653
systemMayContain: 1.2.840.113556.1.4.874
systemMayContain: 1.2.840.113556.1.4.877
systemMayContain: 1.2.840.113556.1.4.878
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.459
systemMayContain: 1.2.840.113556.1.4.485
systemMayContain: 1.2.840.113556.1.4.486
systemMayContain: 1.2.840.113556.1.4.487
systemMayContain: 1.2.840.113556.1.4.488
systemMayContain: 1.2.840.113556.1.4.489
systemMayContain: 1.2.840.113556.1.4.491
systemMayContain: 1.2.840.113556.1.4.564
-

dn: CN=Query-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.844
systemMayContain: 1.2.840.113556.1.4.843
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.604
systemMustContain: 1.2.840.113556.1.4.603
systemMustContain: 1.2.840.113556.1.4.602
systemMustContain: 1.2.840.113556.1.4.599
systemMustContain: 1.2.840.113556.1.4.601
systemMustContain: 1.2.840.113556.1.4.600
-

dn: CN=Ipsec-Negotiation-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.887
systemMayContain: 1.2.840.113556.1.4.888
-

dn: CN=Address-Book-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.886
-
add: systemMustContain
systemMustContain: 1.2.840.113556.1.2.13
-

dn: CN=Service-Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.658
-

# Attribute and Class deletes

# First delete some objects in Config NC before deleting their classes

dn: CN=RPC,CN=Inter-Site Transports,CN=Site Connectors,CN=sites,CN=configuration,DC=X
changetype: delete

dn: CN=Inter-Site Transports,CN=Site Connectors,CN=sites,CN=configuration,DC=X
changetype: delete

dn: CN=Site Connectors,CN=sites,CN=configuration,DC=X
changetype: delete



dn: CN=RAS-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Information-Store-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Link-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=LocalGroup,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Exchange-Admin-Service,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Eicon-X25-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-POP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DX-Requestor,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-LDAP-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-LDAP-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Interface,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Mailbox-Agent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Eicon-X25-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Directory-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=NNTP-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Connector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encryption-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Container,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Site-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Application-Registration,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-IMAP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Server-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Addressing,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Admin-Extension,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-HTTP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Public-Store,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Add-In,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transport-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-LDAP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Message-Store,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-Shared-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MTA-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MHS-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Mail-Gateway,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Distribution-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-Shared-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-DXA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=NTFRS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MTA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Addr-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Root,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-DXA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Protocol-Cfg-Shared,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=ADMD,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=PRMD,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Run-As,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Req-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=To-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Runs-On,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enabled,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-App-Id,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=App-Flags,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Form-Data,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=INSAdmin,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=N-Address,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Send-TNEF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Line-Wrap,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Auth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=From-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Types,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-DN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Flags,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Imp-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Req-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Assistant-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=P-Selector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Rid-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=S-Selector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=T-Selector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=HTTP-Pub-PF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=OWA-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Svr-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Domain-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-ReqName,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Conf-Seq,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Auth-Orig-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-PS-CLSID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Netboot-NIC,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=HTTP-Pub-GAL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Account,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Site,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Port-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Require-SSL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Target-MTAs,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Trust-Level,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Can-Create-PF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Log-Filename,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Contact-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Host,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Content-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Routing-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=HTTP-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Package-Id,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=MTA-Local-Cred,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-1,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-2,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-3,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-4,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Character-Set,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Delegate-User,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Member-Rule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Admin-Copy,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Do-OAB-Version,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Unique-IID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Computer-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Newsfeed-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitor-Clock,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=N-Address-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Sites,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Referral-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Imp-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Employee-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Req-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Role-Occupant,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Affinity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Unauth-Orig-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Import-Now,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=USN-Intersite,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Host,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Export-Now,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Svr-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=LDAP-Search-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Create-PF-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Create-PF-DL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Local-Admin,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MTA-Local-Desig,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Imp-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Req-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Conf-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Svr-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Property-Pages,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Sites,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Use-Site-Values,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Newsgroup-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Report-To-Owner,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RTS-Window-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Unauth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Admin-Update,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Domain-Replicas,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Append-ReqCN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Recipient-CP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MDB-Unread-Limit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Style,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Conf-Req-Time,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Preserve-DNs,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Employee-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Connection-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Phone-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Authorized-User,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Folder-GUID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Proxy-Space,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-List-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-Bridge-Head,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Monitor-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=View-Definition,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Trans-Retry-Mins,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Create-PF-DL-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Logging-Level,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Maximum-Object-ID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=House-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Remote-Client,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=HTTP-Pub-GAL-Limit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Anonymous-Access,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Import-Container,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitor-Services,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Supporting-Stack,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Control-Msg-Rules,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Bridge-Head,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Send-EMail-Message,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Accept-All,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF-DL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Connected-Domains,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Gateway-Local-Cred,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Alert-Repair,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Alert-Offset,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-In-Template-Map,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Folders-Container,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Reject-Perms,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Character-Set-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Expand-DLs-Locally,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Authorized-Domain,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-Initial-Turn,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Home-Public-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-List-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Incoming-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Submit-Perms,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=P-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Anonymous-Account,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Num-Of-Open-Retries,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Export-Containers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitored-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Replica-Set-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Realm-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Aliased-Object-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Site-Folder-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=S-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outbound-Host-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Trans-Timeout-Mins,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=T-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Callback-Number,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Leased-Line-Port,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Remote-MTA-Phone,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X400-Attachment-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Bridgehead-Servers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Gateway-Local-Desig,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=GWART-Last-Modified,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X400-Selector-Syntax,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Admin-Extension-DLL,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=List-Public-Folders,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Lockout-Disconnect,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Display-Name-Suffix,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Certificate-Chain-V3,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Out-Template-Map,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-List-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Space-Last-Computed,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Over-Site-Connector,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=RAS-Remote-SRVR-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RTS-Checkpoint-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Proxy-Generator-DLL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Out-BH-Server,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Open-Retry-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=XMIT-Timeout-Normal,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=NNTP-Distributions,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=XMIT-Timeout-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MDB-Backoff-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Import-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-Selected-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Can-Not-Create-PF-DL-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enabled-Protocol-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Reject-Perms-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Warning-Repair,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Replication-Stagger,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Clock-Warning-Offset,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Leased-or-Switched,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Exchange-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Control-Msg-Folder-ID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Action-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Action-First,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DL-Mem-Submit-Perms-BL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Temp-Assoc-Threshold,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Template-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Gateway-Routing-Tree,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Authorized-Password,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-Value-DN,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Return-Exact-Msg-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Client-Access-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Report-To-Originator,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RTS-Recovery-Timeout,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Off-Line-AB-Containers,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enable-Compatibility,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Association-Lifetime,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Action-Second,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Cross-Certificate-CRL,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Responsible-Local-DXA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encapsulation-Method,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Inbound-Newsfeed-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=MDB-Msg-Time-Out-Period,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Restart-Delay,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Authentication-To-Use,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=HTTP-Pub-AB-Attributes,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-List-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Group-By-Attr-Value-Str,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Hide-DL-Membership,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Filter-Local-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-Selected-NA,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Default-Message-Format,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Conf-Container-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Translation-Table-Used,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Disabled-Gateway-Proxy,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Native-Address-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Template-TimeStamp,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Alert-Delay,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Replication-Boot-State,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Connection-List-Filter,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Assoc-Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Recipients,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Remote-Entries,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Num-Of-Transfer-Retries,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Exchange-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Outgoing-Msg-Size-Limit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Alert-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=OOF-Reply-To-Originator,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Disable-Deferred-Commit,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Turn-Request-Threshold,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=XMIT-Timeout-Non-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=SMIME-Alg-Selected-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Service-Restart-Message,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=COM-Auto-Convert-Class-Id,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=RAS-Phonebook-Entry-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=NNTP-Distributions-Flag,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Local-Bridge-Head-Address,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Timeout-Normal,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Retry-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Timeout-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Message-Tracking-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Signature-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Bidirectional-Connector,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Call-User-Data-Incoming,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Available-Distributions,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Replication-Mail-Msg-Size,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Call-User-Data-Outgoing,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transport-Expedited-Data,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-UnConf-Container-List,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Exchange-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Warning-Delay,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Session-Disconnect-Timer,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Template-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Quota-Notification-Style,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Root-Newsgroups-Folder-ID,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Warning-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Remote-Bridge-Head-Address,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Export-Custom-Recipients,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Support-SMIME-Signatures,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Encrypt-Alg-Selected-Other,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Container-Administrators,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Recipients-NDR,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Two-Way-Alternate-Facility,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Preserve-Internet-Content,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=DXA-Prev-Export-Native-Only,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Facilities-Data-Incoming,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=X25-Facilities-Data-Outgoing,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Default-Intra-Site-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Default-Inter-Site-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Connection-List-Filter-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Transfer-Timeout-Non-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: delete


dn: CN=Quota-Notification-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Exchange-Certificate-Chain,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Authorized-Password-Confirm,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Normal-Poll-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=CA-Signature-Certificate-Chain,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Certificate-Revocation-List-V1,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Certificate-Revocation-List-V3,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Hotsite-Poll-Units,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Enabled-Authorization-Packages,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-In-Exchange-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Normal-Poll-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Escalation-Procedure,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=DXA-Prev-Replication-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Monitoring-Hotsite-Poll-Interval,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Available-Authorization-Packages,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Config NC changes

# Extended rights

dn: CN=Open-Address-Book,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 3e74f60f-3e73-11d1-a9c0-0000f80367c1
displayName: Open Address Book
rightsGuid: a1990816-4298-11d1-ade2-00c04fd8d5cd

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Modify Personal Information
rightsGuid: 77B5B886-944A-11d1-AEBD-0000F80367C1

dn: CN=Email-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Modify Email Information
rightsGuid: E45795B2-9455-11d1-AEBD-0000F80367C1

dn: CN=Web-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Modify Web Information
rightsGuid: E45795B3-9455-11d1-AEBD-0000F80367C1


# Display-Specifiers

dn: CN=localGroup-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: delete

dn: CN=nTFRSSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd68-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextmenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
classDisplayName: NTFRS Settings

dn: CN=nTFRSReplicaSet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd69-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
classDisplayName: NTFRS Replica Set

dn: CN=mSFTFRS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd6a-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
classDisplayName: Microsoft FRS


dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: treatAsLeaf
treatAsLeaf: TRUE
-
delete: adminPropertyPages
adminPropertyPages: 5,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 6,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
add: adminPropertyPages
adminPropertyPages: 5,{FD57D295-4FD9-11D1-854E-00C04FC31FD3}
adminPropertyPages: 6,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 7,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
delete: attributeDisplayNames
attributeDisplayNames: comment,Comment
attributeDisplayNames: company,Company
attributeDisplayNames: distinguishedName,X500 DN
attributeDisplayNames: facsimileTelephoneNumber, Facsimile Telephone Numbers
attributeDisplayNames: generationQualifier, Generation Qualifier
attributeDisplayNames: internationalISDNNumber, International ISDN Number
attributeDisplayNames: mobile,Cellular Phone Number
attributeDisplayNames: personalTitle,Personal Title
attributeDisplayNames: physicalDeliveryOfficeName,Delivery Office
attributeDisplayNames: postalCode,ZIP Code
attributeDisplayNames: primaryGroupID,Primary Group SID
attributeDisplayNames: streetAddress,Address
attributeDisplayNames: telephoneNumber,Telephone Number
attributeDisplayNames: title,Title
attributeDisplayNames: url,Web Page Address
attributeDisplayNames: userAccountControl,User Account Control Flags
-
add: attributeDisplayNames
attributeDisplayNames: assistant,Assistant
attributeDisplayNames: comment,User Account Comment
attributeDisplayNames: co,Company
attributeDisplayNames: distinguishedName,X500 Distinguished Name
attributeDisplayNames: facsimileTelephoneNumber,Facsimile Telephone Number
attributeDisplayNames: generationQualifier,Name Suffix
attributeDisplayNames: internationalISDNNumber, International ISDN Number (Others)
attributeDisplayNames: ipPhone,IP Phone Number
attributeDisplayNames: mobile,Primary Mobile Phone Number
attributeDisplayNames: otherFacsimileTelephoneNumber,Facsimile Telephone Number (Others)
attributeDisplayNames: otherHomePhone,Home Phone (Others)
attributeDisplayNames: otherIpPhone,IP Phone Number (Others)
attributeDisplayNames: otherMailbox,E-Mail Address (Others)
attributeDisplayNames: otherMobile,Mobile Phone Number (Others)
attributeDisplayNames: otherPager,Pager Number (Others)
attributeDisplayNames: otherTelephone,Office Telephone Number (Others)
attributeDisplayNames: personalTitle,Title
attributeDisplayNames: physicalDeliveryOfficeName,Office Location
attributeDisplayNames: postalCode,ZIP/Postal Code
attributeDisplayNames: primaryInternationalISDNNumber,International ISDN Number
attributeDisplayNames: primaryTelexNumber,Telex Number
attributeDisplayNames: streetAddress,Other Address
attributeDisplayNames: telephoneNumber,Primary Phone
attributeDisplayNames: telexNumber,Telex Number (Others)
attributeDisplayNames: url,Web Page Address (Others)
attributeDisplayNames: userPrincipalName,Logon Name
attributeDisplayNames: wWWHomePage,Web Page Address
-

dn: CN=group-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: attributeDisplayNames
attributeDisplayNames: desctription,Description
attributeDisplayNames: contactName,Contact Name
attributeDisplayNames: distinguishedName,X500 DN
attributeDisplayNames: groupAttributes,Group Attribute Flags
-
add: attributeDisplayNames
attributeDisplayNames: description,Description
attributeDisplayNames: distinguishedName,X500 Distinguished Name
attributeDisplayNames: managedBy,Managed By
-

dn: CN=domainDNS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: classDisplayName
classDisplayName: Domain (DNS)
-
add: classDisplayName
classDisplayName: Domain
-
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: assistant,Assistant
attributeDisplayNames: cn,Name
attributeDisplayNames: comment,Comment
attributeDisplayNames: co,Company
attributeDisplayNames: department,Department
attributeDisplayNames: description,Description
attributeDisplayNames: directReports,Direct Reports
attributeDisplayNames: distinguishedName,X500 Distinguished Name
attributeDisplayNames: division,Division
attributeDisplayNames: employeeID,Employee ID
attributeDisplayNames: facsimileTelephoneNumber,Facsimile Telephone Number
attributeDisplayNames: generationQualifier,Name Suffix
attributeDisplayNames: givenName,First Name
attributeDisplayNames: homePhone,Home Phone
attributeDisplayNames: homePostalAddress,Home Address
attributeDisplayNames: info,Notes
attributeDisplayNames: initials,Initials
attributeDisplayNames: internationalISDNNumber,International ISDN Number (Others)
attributeDisplayNames: ipPhone,IP Phone Number
attributeDisplayNames: l,City
attributeDisplayNames: mail,E-Mail Address
attributeDisplayNames: manager,Manager
attributeDisplayNames: memberOf,Group Membership
attributeDisplayNames: middleName,Middle Name
attributeDisplayNames: mobile,Primary Mobile Phone Number
attributeDisplayNames: otherHomePhone,Home Phone Number (Others)
attributeDisplayNames: otherIpPhone,IP Phone Number (Others)
attributeDisplayNames: otherMailbox,E-Mail Address (Others)
attributeDisplayNames: otherMobile,Mobile Phone Number (Others)
attributeDisplayNames: otherPager,Pager Number (Others)
attributeDisplayNames: otherTelephone,Telephone Number (Others)
attributeDisplayNames: personalTitle,Personal Title
attributeDisplayNames: physicalDeliveryOfficeName,Office Location
attributeDisplayNames: postalCode,ZIP/Postal Code
attributeDisplayNames: postOfficeBox,Post Office Box
attributeDisplayNames: primaryInternationalISDNNumber,International ISDN Number
attributeDisplayNames: primaryTelexNumber,Telex Number
attributeDisplayNames: sn,Last Name
attributeDisplayNames: st,State
attributeDisplayNames: streetAddress,Other Address
attributeDisplayNames: telephoneNumber,Primary Phone
attributeDisplayNames: telexNumber,Telex Number (Others)
attributeDisplayNames: url,Web Page Address (Others)
attributeDisplayNames: wWWHomePage,Web Page Address
-

dn: CN=domainPolicy-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: adminPropertyPages
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 4,{AAD30A04-E1D0-11d0-B859-00A024CDD4DE}
-
add: adminPropertyPages
adminPropertyPages: 2,{AAD30A04-E1D0-11d0-B859-00A024CDD4DE}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-

dn: CN=serviceAdministrationPoint-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: classDisplayName
classDisplayName: Service Administration Point
-
add: classDisplayName
classDisplayName: Service
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
attributeDisplayNames: operatingSystem,Operating System
attributeDisplayNames: operatingSystemVersion,Operating System Version
attributeDisplayNames: type,Type
-

dn: CN=printQueue-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Directory Service Name
attributeDisplayNames: uNCName,Network Name
attributeDisplayNames: assetNumber,Asset Number
attributeDisplayNames: bytesPerMinute,Bytes per Minute
attributeDisplayNames: contactName,Contact
attributeDisplayNames: description,Comment
attributeDisplayNames: driverName,Model
attributeDisplayNames: driverVersion,Driver Version
attributeDisplayNames: location,Location
attributeDisplayNames: portName,Port
attributeDisplayNames: printBinNames,Input Trays
attributeDisplayNames: printCollate,Supports Collation
attributeDisplayNames: printColor,Supports Color Printing
attributeDisplayNames: printDuplexSupported,Supports Double-sided Printing
attributeDisplayNames: printerName,Name
attributeDisplayNames: printFormName,Form Name
attributeDisplayNames: printLanguage,Data Format
attributeDisplayNames: printMACAddress,Physical Network Address
attributeDisplayNames: printMaxCopies,Maximum Number of Copies
attributeDisplayNames: printMaxResolutionSupported,Maximum Resolution
attributeDisplayNames: printMaxXExtent,Maximum Printable Width
attributeDisplayNames: printMaxYExtent,Maximum Printable Height
attributeDisplayNames: printMediaReady,Paper Available
attributeDisplayNames: printMediaSupported,Paper Types Supported
attributeDisplayNames: printMemory,Installed Memory
attributeDisplayNames: printMinXExtent,Minimum Printable Width
attributeDisplayNames: printMinYExtent,Minimum Printable Height
attributeDisplayNames: printNetworkAddress,Network Address
attributeDisplayNames: printNumberUp,Supports N-Up Printing
attributeDisplayNames: operatingSystem,Operating System
attributeDisplayNames: operatingSystemVersion,Operating System Version
attributeDisplayNames: printOrientationsSupported,Orientations Supported
attributeDisplayNames: printOwner,Owner Name
attributeDisplayNames: printRate,Speed
attributeDisplayNames: printRateUnit,Speed Units
attributeDisplayNames: printPagesPerMinute,Pages per Minute
attributeDisplayNames: printShareName,Share Name
attributeDisplayNames: printStaplingSupported,Supports Stapling
attributeDisplayNames: printStatus,State
attributeDisplayNames: priority,Print Job Priority
attributeDisplayNames: serverName,Server Name
attributeDisplayNames: url,Web Page Address
attributeDisplayNames: versionNumber,Object Version
attributeDisplayNames: whenChanged,Date Modified
attributeDisplayNames: whenCreated,Date Created
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
-

dn: CN=trustedDomain-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
-

dn: CN=volume-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: attributeDisplayNames
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
attributeDisplayNames: uNCName,Network Path
-
delete: classDisplayName
classDisplayName: Volume
-
add: classDisplayName
classDisplayName: Shared Folder
-

dn: CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: add
objectClass: interSiteTransportContainer
hideFromAB: TRUE

dn: CN=IP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: add
objectClass: interSiteTransport
transportDllName: ismip.dll
hideFromAB: TRUE

dn: CN=SMTP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: add
objectClass: interSiteTransport
transportDllName: ismsmtp.dll
hideFromAB: TRUE


dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: delete

dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: queryPolicy
lDAPAdminLimits: MaxConnections=1000
lDAPAdminLimits: InitRecvTimeout=120
lDAPAdminLimits: AllowDeepNonIndexSearch=False
lDAPAdminLimits: MaxConnIdleTime=900
lDAPAdminLimits: MaxActiveQueries=20
lDAPAdminLimits: MaxNotificationPerConn=5
lDAPAdminLimits: MaxPageSize=1000
lDAPAdminLimits: MaxQueryDuration=120
lDAPAdminLimits: MaxTempTableSize=10000
lDAPAdminLimits: MaxResultSetSize=262144
lDAPAdminLimits: MaxPoolThreads=4
lDAPAdminLimits: MaxDatagramRecv=4096
hideFromAB: TRUE


# Object-Version on schema container

dn: CN=schema,CN=configuration,DC=X
changetype: modify
add: objectVersion
objectVersion: 1
-

```

### Sch2.ldf

```
dn: CN=GP-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: gPLink
adminDisplayName: GP-Link
adminDescription: GP-Link
attributeId: 1.2.840.113556.1.4.891
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vjsO8/Cf0RG2AwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=GP-Options,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: gPOptions
adminDisplayName: GP-Options
adminDescription: GP-Options
attributeId: 1.2.840.113556.1.4.892
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vzsO8/Cf0RG2AwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=GPC-File-Sys-Path,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: gPCFileSysPath
adminDisplayName: GPC-File-Sys-Path
adminDescription: GPC-File-Sys-Path
attributeId: 1.2.840.113556.1.4.894
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wTsO8/Cf0RG2AwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=GPC-Functionality-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: gPCFunctionalityVersion
adminDisplayName: GPC-Functionality-Version
adminDescription: GPC-Functionality-Version
attributeId: 1.2.840.113556.1.4.893
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wDsO8/Cf0RG2AwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Transport-Address-Attribute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: transportAddressAttribute
adminDisplayName: Transport-Address-Attribute
adminDescription: Transport-Address-Attribute
attributeId: 1.2.840.113556.1.4.895
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fIbcwWGi0RG2BgAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: groupPolicyContainer
adminDisplayName: Group-Policy-Container
adminDescription: Group-Policy-Container
governsId: 1.2.840.113556.1.5.157
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.23
systemMayContain: 1.2.840.113556.1.4.141
systemMayContain: 1.2.840.113556.1.4.893
systemMayContain: 1.2.840.113556.1.4.894
systemMayContain: 1.2.840.113556.1.4.38
systemMayContain: 1.2.840.113556.1.2.13
schemaIdGuid:: wjsO8/Cf0RG2AwAA+ANnwQ==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X

# To take care of change of OID for USN-Source

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.374
-

dn: CN=USN-Source,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=USN-Source,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
lDAPDisplayName: uSNSource
adminDescription: USN-Source
adminDisplayName: USN-Source
attributeID: 1.2.840.113556.1.4.896
attributeSyntax: 2.5.5.16
isSingleValued: TRUE
mAPIID: 33111
oMSyntax: 65
schemaIDGUID:: rVh3FvNH0RGpwwAA+ANnwQ==
searchFlags: 0
systemOnly: FALSE
hideFromAB: TRUE


dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.896
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.891
systemMayContain: 1.2.840.113556.1.4.892
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.342
systemMayContain: 1.2.840.113556.1.4.678
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.891
systemMayContain: 1.2.840.113556.1.4.892
systemMayContain: 2.5.4.6
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.342
systemMayContain: 1.2.840.113556.1.4.678
-

dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.342
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.891
systemMayContain: 1.2.840.113556.1.4.892
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.342
systemMayContain: 1.2.840.113556.1.4.343
-

dn: CN=Inter-Site-Transport,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.895
-

dn: CN=Domain-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.418
-

dn: CN=Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.213
-

dn: CN=Intellimirror-SCP,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.358
systemMayContain: 1.2.840.113556.1.4.359
-

dn: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.67
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.342
systemMayContain: 1.2.840.113556.1.4.343
systemMayContain: 1.2.840.113556.1.4.515
-

dn: CN=NTDS-DSA,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.515
-

dn: CN=Site,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.891
systemMayContain: 1.2.840.113556.1.4.892
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.342
systemMayContain: 1.2.840.113556.1.4.678
-

dn: CN=Object-Category,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 2
-

# Change of OID of FRS-Replica-Set-Type
# Delete by name, not by OID.

dn: CN=NTFRS-Replica-Set,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: fRSReplicaSetType
-

dn: CN=FRS-Replica-Set-Type,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=FRS-Replica-Set-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
lDAPDisplayName: fRSReplicaSetType
adminDescription: FRS-Replica-Set-Type
adminDisplayName: FRS-Replica-Set-Type
attributeID: 1.2.840.113556.1.4.31
attributeSyntax: 2.5.5.9
hideFromAB: TRUE
isSingleValued: TRUE
oMSyntax: 2
schemaIDGUID:: a3PZJnBg0RGpxgAA+ANnwQ==
searchFlags: 0
systemOnly: FALSE


dn: CN=NTFRS-Replica-Set,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.31
-

dn: CN=Builtin-Sync,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Policy-Name,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Policy-Link,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Policy-Options,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn: CN=Change-Pwd-Logon-Required,CN=Schema,CN=Configuration,DC=X
changetype: delete

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=DS-Replication-Get-Changes,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
appliesTo: bf967a87-0de6-11d0-a285-00aa003049e2
appliesTo: bf967a8f-0de6-11d0-a285-00aa003049e2
displayName: Replicating Directory Changes
rightsGUID: 1131f6aa-9c07-11d1-f79f-00c04fc2dcd2

dn: CN=DS-Replication-Synchronize,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
appliesTo: bf967a87-0de6-11d0-a285-00aa003049e2
appliesTo: bf967a8f-0de6-11d0-a285-00aa003049e2
displayName: Replication Synchronization
rightsGUID: 1131f6ab-9c07-11d1-f79f-00c04fc2dcd2

dn: CN=DS-Replication-Manage-Topology,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
appliesTo: bf967a87-0de6-11d0-a285-00aa003049e2
appliesTo: bf967a8f-0de6-11d0-a285-00aa003049e2
displayName: Manage Replication Topology
rightsGUID: 1131f6ac-9c07-11d1-f79f-00c04fc2dcd2

dn: CN=IntellimirrorGroup-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{C641CF88-892F-11d1-BBEB-0060081692B3}
classDisplayName: IntelliMirror-Group
shellPropertyPages: 1,{C641CF88-892F-11d1-BBEB-0060081692B3}

dn: CN=IntellimirrorSCP-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{AC409538-741C-11d1-BBE6-0060081692B3}
classDisplayName: IntelliMirror-Service
shellPropertyPages: 1,{AC409538-741C-11d1-BBE6-0060081692B3}

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminPropertyPages
adminPropertyPages: 10,{0F65B1BF-740F-11d1-BBE6-0060081692B3}
-


dn: CN=IP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: modify
add: transportAddressAttribute
transportAddressAttribute: dnsHostName
-

dn: CN=SMTP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: modify
add: transportAddressAttribute
transportAddressAttribute: mailAddress
-

dn: CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: objectVersion
objectVersion: 2
-

```

### Sch3.ldf

```
# Existing Extended-Rights Mod

dn: CN=User-Force-Change-Password,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
replace: displayName
displayName: Reset Password
-
add: appliesTo
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
-


# New Display-Specifier adds

dn: CN=server-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{6dfe6494-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: Server

dn: CN=siteLink-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{50d30561-9911-11d1-b9af-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: Site Link

dn: CN=siteLinkBridge-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{50d30562-9911-11d1-b9af-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: Site Link Bridge

dn: CN=interSiteTransport-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{6DFE6491-AC8D-11D0-B945-00C04FD8D5B0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: Inter-Site Transport

dn: CN=licensingSiteSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{717ef500-ac8d-11d0-b945-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: Licensing Site Settings

dn: CN=nTDSSiteSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{2f280288-bb6d-11d0-b948-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: NTDS Site Settings

dn: CN=nTFRSMember-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{9da6fd6a-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: NTFRS Member


dn: CN=nTFRSSubscriber-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{50d3055f-9911-11d1-b9af-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: NTFRS Subscriber

dn: CN=nTFRSSubscriptions-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{50d30560-9911-11d1-b9af-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: NTFRS Subscriptions

dn: CN=rpcContainer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: add
objectClass: displaySpecifier
hideFromAB: TRUE
adminPropertyPages: 1,{50d30572-9911-11d1-b9af-00c04fd8d5b0}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
contextMenu: 0,{62AE1F9A-126A-11D0-A14B-0800361B1103}
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: RPC Services
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description


# Existing display-specifier mods


dn: CN=mSFTFRS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: delete


dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: adminPropertyPages
adminPropertyPages: 3,{6dfe648a-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{B52C1E50-1DD2-11D1-BC43-00C04FC31FD3}
adminPropertyPages: 5,{FD57D295-4FD9-11D1-854E-00C04FC31FD3}
adminPropertyPages: 6,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 7,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
add: adminPropertyPages
adminPropertyPages: 3,{B52C1E50-1DD2-11D1-BC43-00C04FC31FD3}
adminPropertyPages: 4,{FD57D295-4FD9-11D1-854E-00C04FC31FD3}
adminPropertyPages: 5,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 6,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
add: attributeDisplayNames
attributeDisplayNames: userWorkstations,Logon Workstations
-


dn: CN=group-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
delete: adminPropertyPages
adminPropertyPages: 2,{6dfe648a-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{6dfe648b-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 5,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
add: adminPropertyPages
adminPropertyPages: 2,{6dfe648b-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=domainDNS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 2,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=domainPolicy-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=localPolicy-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=serviceAdministrationPoint-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=printQueue-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=site-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
adminContextMenu: 2,{6BA3F852-23C6-11D1-B91F-00A0C9A06D2D}
-

dn: CN=nTDSSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=nTDSDSA-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=nTDSConnection-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=nTFRSSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=nTFRSReplicaSet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-


dn: CN=subnet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 2,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=container-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 2,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=trustedDomain-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=volume-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-

dn: CN=default-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: modify
add: adminContextMenu
adminContextMenu: 0,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
-


# New Extended-Rights adds


dn: CN=Change-Schema-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: bf967a8f-0de6-11d0-a285-00aa003049e2
displayName: Change Schema Master
rightsGUID: e12b56b6-0a95-11d1-adbb-00c04fd8d5cd

dn: CN=Change-Rid-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 6617188d-8f3c-11d0-afda-00c04fd930c9
displayName: Change Rid Master
rightsGUID: d58d5f36-0a98-11d1-adbb-00c04fd8d5cd

dn: CN=Abandon-Replication,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Abandon Replication
rightsGUID: ee914b82-0a98-11d1-adbb-00c04fd8d5cd

dn: CN=Do-Garbage-Collection,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Do Garbage Collection
rightsGUID: fec364e0-0a98-11d1-adbb-00c04fd8d5cd


dn: CN=Recalculate-Hierarchy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Recalculate Hierarchy
rightsGUID: 0bc1554e-0a99-11d1-adbb-00c04fd8d5cd

dn: CN=Allocate-Rids,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Allocate Rids
rightsGUID: 1abd7cf8-0a99-11d1-adbb-00c04fd8d5cd

dn: CN=Change-PDC,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
displayName: Change PDC
rightsGUID: bae50096-4752-11d1-9052-00c04fc2d4cf

dn: CN=Add-GUID,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
displayName: Add GUID
rightsGUID: 440820ad-65b4-11d1-a3da-0000f875ae0d

dn: CN=Change-Domain-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
hideFromAB: TRUE
appliesTo: ef9e60e0-56f7-11d1-a9c6-0000f80367c1
displayName: Change Domain Master
rightsGUID: 014bf69c-7b3b-11d1-85f6-08002be74fab



# Bump up the schema version
dn: CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: objectVersion
objectVersion: 3
-

```

### Sch4.ldf

```
# Renames.

dn: CN=DXA-Flags,CN=Schema,CN=Configuration,DC=X
changetype: modrdn
newrdn: Deleted-Item-Flags
deleteoldrdn: 1

dn: CN=Deleted-Item-Flags,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: deletedItemFlags
-
replace: adminDisplayName
adminDisplayName: Deleted-Item-Flags
-
replace: adminDescription
adminsDescription: Deleted-Item-Flags
-

dn: CN=DXA-Task,CN=Schema,CN=Configuration,DC=X
changetype: modrdn
newrdn: Message-Size-Limit
deleteoldrdn: 1

dn: CN=Message-Size-Limit,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: messageSizeLimit
-
replace: adminDisplayName
adminDisplayName: Message-Size-Limit
-
replace: adminDescription
adminsDescription: Message-Size-Limit
-

dn: CN=Assoc-NT-Account,CN=Schema,CN=Configuration,DC=X
changetype: modrdn
newrdn: Assoc-NT-Account-Unused
deleteoldrdn: 1

dn: CN=Assoc-NT-Account-Unused,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: assocNTAccountUnused
-
replace: adminDisplayName
adminDisplayName: Assoc-NT-Account-Unused
-
replace: adminDescription
adminsDescription: Assoc-NT-Account-Unused
-

dn: CN=Assoc-NT-Account,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: assocNTAccount
adminDisplayName: Assoc-NT-Account
adminDescription: Assoc-NT-Account
attributeId: 1.2.840.113556.1.4.1213
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
hideFromAB: TRUE




dn: CN=ANR,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aNR
adminDisplayName: ANR
adminDescription: ANR
attributeId: 1.2.840.113556.1.4.1208
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ABWwRRnE0RG7yQCAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=ADMD,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ADMD
adminDisplayName: ADMD
adminDescription: ADMD
attributeId: 1.2.840.113556.1.2.232
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 16
schemaIdGuid:: kHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32841
hideFromAB: TRUE

dn: CN=PRMD,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: PRMD
adminDisplayName: PRMD
adminDescription: PRMD
attributeId: 1.2.840.113556.1.2.224
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 16
schemaIdGuid:: TXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33038
hideFromAB: TRUE

dn: CN=Req-Seq,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReqSeq
adminDisplayName: Req-Seq
adminDescription: Req-Seq
attributeId: 1.2.840.113556.1.2.173
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33058
hideFromAB: TRUE

dn: CN=Runs-On,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RunsOn
adminDisplayName: Runs-On
adminDescription: Runs-On
attributeId: 1.2.840.113556.1.2.185
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: a3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33066
hideFromAB: TRUE

dn: CN=Enabled,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: Enabled
adminDisplayName: Enabled
adminDescription: Enabled
attributeId: 1.2.840.113556.1.2.557
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 8nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35873
hideFromAB: TRUE

dn: CN=Telephone-Home-Fax,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: homeFax
adminDisplayName: Telephone-Home-Fax
adminDescription: Telephone-Home-Fax
attributeId: 1.2.840.113556.1.2.609
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: hXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 14885
hideFromAB: TRUE

dn: CN=Encrypt,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: Encrypt
adminDisplayName: Encrypt
adminDescription: Encrypt
attributeId: 1.2.840.113556.1.2.236
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32931
hideFromAB: TRUE

dn: CN=Form-Data,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: FormData
adminDisplayName: Form-Data
adminDescription: Form-Data
attributeId: 1.2.840.113556.1.2.607
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: AHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35941
hideFromAB: TRUE

dn: CN=INSAdmin,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: INSAdmin
adminDisplayName: INSAdmin
adminDescription: INSAdmin
attributeId: 1.2.840.113556.1.2.543
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: FnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33221
hideFromAB: TRUE

dn: CN=N-Address,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NAddress
adminDisplayName: N-Address
adminDescription: N-Address
attributeId: 1.2.840.113556.1.2.282
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 50
schemaIdGuid:: NHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33009
hideFromAB: TRUE

dn: CN=Send-TNEF,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SendTNEF
adminDisplayName: Send-TNEF
adminDescription: Send-TNEF
attributeId: 1.2.840.113556.1.2.492
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: b3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33169
hideFromAB: TRUE

dn: CN=Line-Wrap,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: LineWrap
adminDisplayName: Line-Wrap
adminDescription: Line-Wrap
attributeId: 1.2.840.113556.1.2.449
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: GHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32964
hideFromAB: TRUE

dn: CN=Auth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthOrig
adminDisplayName: Auth-Orig
adminDescription: Auth-Orig
attributeId: 1.2.840.113556.1.2.129
attributeSyntax: 2.5.5.7
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: VgYBAgULHQ==
schemaIdGuid:: l3PfqOrF0RG7ywCAx2ZwwA==
linkID: 110
hideFromAB: TRUE

dn: CN=MSMQ-QM-ID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQQMID
adminDisplayName: MSMQ-QM-ID
adminDescription: MSMQ-QM-ID
attributeId: 1.2.840.113556.1.4.951
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Types,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXATypes
adminDisplayName: DXA-Types
adminDescription: DXA-Types
attributeId: 1.2.840.113556.1.2.119
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 7XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32928
hideFromAB: TRUE

dn: CN=MSMQ-Cost,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQCost
adminDisplayName: MSMQ-Cost
adminDescription: MSMQ-Cost
attributeId: 1.2.840.113556.1.4.946
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Site-1,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSite1
adminDisplayName: MSMQ-Site-1
adminDescription: MSMQ-Site-1
attributeId: 1.2.840.113556.1.4.943
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: N8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Site-2,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSite2
adminDisplayName: MSMQ-Site-2
adminDescription: MSMQ-Site-2
attributeId: 1.2.840.113556.1.4.944
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Label,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQLabel
adminDisplayName: MSMQ-Label
adminDescription: MSMQ-Label
attributeId: 1.2.840.113556.1.4.922
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: JcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Inbound-DN,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: InboundDN
adminDisplayName: Inbound-DN
adminDescription: Inbound-DN
attributeId: 1.2.840.113556.1.2.553
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: EHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35870
hideFromAB: TRUE

dn: CN=View-Flags,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ViewFlags
adminDisplayName: View-Flags
adminDescription: View-Flags
attributeId: 1.2.840.113556.1.2.546
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35864
hideFromAB: TRUE

dn: CN=DXA-Imp-Seq,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAImpSeq
adminDisplayName: DXA-Imp-Seq
adminDescription: DXA-Imp-Seq
attributeId: 1.2.840.113556.1.2.116
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: 0nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32899
hideFromAB: TRUE

dn: CN=DXA-Req-Seq,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAReqSeq
adminDisplayName: DXA-Req-Seq
adminDescription: DXA-Req-Seq
attributeId: 1.2.840.113556.1.2.101
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: 5HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32918
hideFromAB: TRUE

dn: CN=Assistant-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: secretary
adminDisplayName: Assistant-Name
adminDescription: Assistant-Name
attributeId: 1.2.840.113556.1.2.444
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: lHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 14896
hideFromAB: TRUE

dn: CN=P-Selector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: PSelector
adminDisplayName: P-Selector
adminDescription: P-Selector
attributeId: 1.2.840.113556.1.2.285
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 16
schemaIdGuid:: SHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33030
hideFromAB: TRUE

dn: CN=Rid-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RidServer
adminDisplayName: Rid-Server
adminDescription: Rid-Server
attributeId: 1.2.840.113556.1.2.346
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: ZHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33060
hideFromAB: TRUE

dn: CN=S-Selector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SSelector
adminDisplayName: S-Selector
adminDescription: S-Selector
attributeId: 1.2.840.113556.1.2.284
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 16
schemaIdGuid:: bHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33067
hideFromAB: TRUE

dn: CN=T-Selector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TSelector
adminDisplayName: T-Selector
adminDescription: T-Selector
attributeId: 1.2.840.113556.1.2.283
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: gXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33088
hideFromAB: TRUE

dn: CN=HTTP-Pub-PF,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HTTPPubPF
adminDisplayName: HTTP-Pub-PF
adminDescription: HTTP-Pub-PF
attributeId: 1.2.840.113556.1.2.505
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1024
schemaIdGuid:: C3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33182
hideFromAB: TRUE

dn: CN=OWA-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OWAServer
adminDisplayName: OWA-Server
adminDescription: OWA-Server
attributeId: 1.2.840.113556.1.2.608
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 128
schemaIdGuid:: R3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35942
hideFromAB: TRUE

dn: CN=DXA-Svr-Seq,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXASvrSeq
adminDisplayName: DXA-Svr-Seq
adminDescription: DXA-Svr-Seq
attributeId: 1.2.840.113556.1.2.360
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: 6HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32922
hideFromAB: TRUE

dn: CN=From-Entry,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: fromEntry
adminDisplayName: From-Entry
adminDescription: From-Entry
attributeId: 1.2.840.113556.1.4.910
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Sdl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=MSMQ-Sites,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSites
adminDisplayName: MSMQ-Sites
adminDescription: MSMQ-Sites
attributeId: 1.2.840.113556.1.4.927
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=MSMQ-Quota,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQQuota
adminDisplayName: MSMQ-Quota
adminDescription: MSMQ-Quota
attributeId: 1.2.840.113556.1.4.919
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Domain-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DomainName
adminDisplayName: Domain-Name
adminDescription: Domain-Name
attributeId: 1.2.840.113556.1.2.147
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 362
schemaIdGuid:: yHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32886
hideFromAB: TRUE

dn: CN=DXA-ReqName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAReqName
adminDisplayName: DXA-ReqName
adminDescription: DXA-ReqName
attributeId: 1.2.840.113556.1.2.446
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: 53PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32921
hideFromAB: TRUE

dn: CN=DXA-Conf-Seq,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAConfSeq
adminDisplayName: DXA-Conf-Seq
adminDescription: DXA-Conf-Seq
attributeId: 1.2.840.113556.1.2.184
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: znPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32894
hideFromAB: TRUE

dn: CN=Auth-Orig-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthOrigBL
adminDisplayName: Auth-Orig-BL
adminDescription: Auth-Orig-BL
attributeId: 1.2.840.113556.1.2.290
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: mHPfqOrF0RG7ywCAx2ZwwA==
linkID: 111
mapiID: 32851
hideFromAB: TRUE
systemFlags: 1

dn: CN=HTTP-Pub-GAL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HTTPPubGAL
adminDisplayName: HTTP-Pub-GAL
adminDescription: HTTP-Pub-GAL
attributeId: 1.2.840.113556.1.2.502
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: CXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33179
hideFromAB: TRUE

dn: CN=MSMQ-Site-ID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSiteID
adminDisplayName: MSMQ-Site-ID
adminDescription: MSMQ-Site-ID
attributeId: 1.2.840.113556.1.4.953
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=RAS-Account,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RASAccount
adminDisplayName: RAS-Account
adminDescription: RAS-Account
attributeId: 1.2.840.113556.1.2.519
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33197
hideFromAB: TRUE

dn: CN=Remote-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RemoteSite
adminDisplayName: Remote-Site
adminDescription: Remote-Site
attributeId: 1.2.840.113556.1.2.27
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: W3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33053
hideFromAB: TRUE

dn: CN=Port-Number,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: PortNumber
adminDisplayName: Port-Number
adminDescription: Port-Number
attributeId: 1.2.840.113556.1.2.527
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 65535
schemaIdGuid:: SnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33205
hideFromAB: TRUE

dn: CN=Require-SSL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RequireSSL
adminDisplayName: Require-SSL
adminDescription: Require-SSL
attributeId: 1.2.840.113556.1.2.560
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35877
hideFromAB: TRUE

dn: CN=Target-MTAs,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TargetMTAs
adminDisplayName: Target-MTAs
adminDescription: Target-MTAs
attributeId: 1.2.840.113556.1.2.259
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 36
schemaIdGuid:: g3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33090
hideFromAB: TRUE

dn: CN=Trust-Level,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TrustLevel
adminDisplayName: Trust-Level
adminDescription: Trust-Level
attributeId: 1.2.840.113556.1.2.70
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 100
schemaIdGuid:: knTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33103
hideFromAB: TRUE

dn: CN=Unauth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: UnauthOrig
adminDisplayName: Unauth-Orig
adminDescription: Unauth-Orig
attributeId: 1.2.840.113556.1.2.221
attributeSyntax: 2.5.5.7
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: VgYBAgULHQ==
schemaIdGuid:: lXTfqOrF0RG7ywCAx2ZwwA==
linkID: 114
hideFromAB: TRUE

dn: CN=MSMQ-OS-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQOSType
adminDisplayName: MSMQ-OS-Type
adminDescription: MSMQ-OS-Type
attributeId: 1.2.840.113556.1.4.935
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Can-Create-PF,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanCreatePF
adminDisplayName: Can-Create-PF
adminDescription: Can-Create-PF
attributeId: 1.2.840.113556.1.2.11
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: oXPfqOrF0RG7ywCAx2ZwwA==
linkID: 124
mapiID: 32856
hideFromAB: TRUE

dn: CN=Log-Filename,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: LogFilename
adminDisplayName: Log-Filename
adminDescription: Log-Filename
attributeId: 1.2.840.113556.1.2.192
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: HXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32970
hideFromAB: TRUE

dn: CN=Is-Ephemeral,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: isEphemeral
adminDisplayName: Is-Ephemeral
adminDescription: Is-Ephemeral
attributeId: 1.2.840.113556.1.4.1212
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: 8FPE9PHF0RG7ywCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Inbound-Host,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: InboundHost
adminDisplayName: Inbound-Host
adminDescription: Inbound-Host
attributeId: 1.2.840.113556.1.2.489
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: EXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33166
hideFromAB: TRUE

dn: CN=MSMQ-CSP-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQCSPName
adminDisplayName: MSMQ-CSP-Name
adminDescription: MSMQ-CSP-Name
attributeId: 1.2.840.113556.1.4.940
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Password,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPassword
adminDisplayName: DXA-Password
adminDescription: DXA-Password
attributeId: 1.2.840.113556.1.2.305
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 12
schemaIdGuid:: 23PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32908
hideFromAB: TRUE

dn: CN=MSMQ-Digests,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQDigests
adminDisplayName: MSMQ-Digests
adminDescription: MSMQ-Digests
attributeId: 1.2.840.113556.1.4.948
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: PMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=MSMQ-Foreign,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQForeign
adminDisplayName: MSMQ-Foreign
adminDescription: MSMQ-Foreign
attributeId: 1.2.840.113556.1.4.934
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: L8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=MSMQ-Owner-ID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQOwnerID
adminDisplayName: MSMQ-Owner-ID
adminDescription: MSMQ-Owner-ID
attributeId: 1.2.840.113556.1.4.925
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: KMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=MSMQ-Sign-Key,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSignKey
adminDisplayName: MSMQ-Sign-Key
adminDescription: MSMQ-Sign-Key
attributeId: 1.2.840.113556.1.4.937
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Journal,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQJournal
adminDisplayName: MSMQ-Journal
adminDescription: MSMQ-Journal
attributeId: 1.2.840.113556.1.4.918
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Content-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ContentType
adminDisplayName: Content-Type
adminDescription: Content-Type
attributeId: 1.2.840.113556.1.2.481
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 4
schemaIdGuid:: uXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33158
hideFromAB: TRUE

dn: CN=RAS-Password,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RASPassword
adminDisplayName: RAS-Password
adminDescription: RAS-Password
attributeId: 1.2.840.113556.1.2.520
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: U3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33198
hideFromAB: TRUE

dn: CN=MSMQ-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQVersion
adminDisplayName: MSMQ-Version
adminDescription: MSMQ-Version
attributeId: 1.2.840.113556.1.4.942
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPVersion,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPVersion
adminDisplayName: msNPVersion
adminDescription: msNPVersion
attributeId: 1.2.840.113556.1.4.1135
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: k5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Routing-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RoutingList
adminDisplayName: Routing-List
adminDescription: Routing-List
attributeId: 1.2.840.113556.1.2.354
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 2243
schemaIdGuid:: Z3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33062
hideFromAB: TRUE

dn: CN=HTTP-Servers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HTTPServers
adminDisplayName: HTTP-Servers
adminDescription: HTTP-Servers
attributeId: 1.2.840.113556.1.2.517
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: DHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33195
hideFromAB: TRUE

dn: CN=MTA-Local-Cred,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MTALocalCred
adminDisplayName: MTA-Local-Cred
adminDescription: MTA-Local-Cred
attributeId: 1.2.840.113556.1.2.270
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: MnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33007
hideFromAB: TRUE

dn: CN=Character-Set,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CharacterSet
adminDisplayName: Character-Set
adminDescription: Character-Set
attributeId: 1.2.840.113556.1.2.480
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: rXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33157
hideFromAB: TRUE

dn: CN=Delegate-User,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DelegateUser
adminDisplayName: Delegate-User
adminDescription: Delegate-User
attributeId: 1.2.840.113556.1.2.591
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35913
hideFromAB: TRUE

dn: CN=DL-Member-Rule,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DLMemberRule
adminDisplayName: DL-Member-Rule
adminDescription: DL-Member-Rule
attributeId: 1.2.840.113556.1.2.330
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 4096
schemaIdGuid:: xnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32884
hideFromAB: TRUE

dn: CN=DXA-Admin-Copy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAAdminCopy
adminDisplayName: DXA-Admin-Copy
adminDescription: DXA-Admin-Copy
attributeId: 1.2.840.113556.1.2.378
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: yXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32888
hideFromAB: TRUE

dn: CN=Do-OAB-Version,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DoOABVersion
adminDisplayName: Do-OAB-Version
adminDescription: Do-OAB-Version
attributeId: 1.2.840.113556.1.2.575
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: x3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 35898
hideFromAB: TRUE

dn: CN=MSMQ-Migrated,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQMigrated
adminDisplayName: MSMQ-Migrated
adminDescription: MSMQ-Migrated
attributeId: 1.2.840.113556.1.4.952
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: P8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Computer-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ComputerName
adminDisplayName: Computer-Name
adminDescription: Computer-Name
attributeId: 1.2.840.113556.1.2.20
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: tHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32869
hideFromAB: TRUE

dn: CN=Monitor-Clock,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitorClock
adminDisplayName: Monitor-Clock
adminDescription: Monitor-Clock
attributeId: 1.2.840.113556.1.2.163
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: I3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 32982
hideFromAB: TRUE

dn: CN=N-Address-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NAddressType
adminDisplayName: N-Address-Type
adminDescription: N-Address-Type
attributeId: 1.2.840.113556.1.2.222
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33010
hideFromAB: TRUE

dn: CN=Inbound-Sites,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: InboundSites
adminDisplayName: Inbound-Sites
adminDescription: Inbound-Sites
attributeId: 1.2.840.113556.1.2.71
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: FHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32956
hideFromAB: TRUE

dn: CN=msNPSequence,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPSequence
adminDisplayName: msNPSequence
adminDescription: msNPSequence
attributeId: 1.2.840.113556.1.4.1131
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: j5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPVendorID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPVendorID
adminDisplayName: msNPVendorID
adminDescription: msNPVendorID
attributeId: 1.2.840.113556.1.4.1134
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: kpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Newsfeed-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NewsfeedType
adminDisplayName: Newsfeed-Type
adminDescription: Newsfeed-Type
attributeId: 1.2.840.113556.1.2.495
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: NnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33172
hideFromAB: TRUE

dn: CN=DXA-Imp-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAImpSeqUSN
adminDisplayName: DXA-Imp-Seq-USN
adminDescription: DXA-Imp-Seq-USN
attributeId: 1.2.840.113556.1.2.86
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 1HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32901
hideFromAB: TRUE

dn: CN=Employee-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: employeeType
adminDisplayName: Employee-Type
adminDescription: Employee-Type
attributeId: 1.2.840.113556.1.2.613
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: 8HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35945
hideFromAB: TRUE

dn: CN=DXA-Req-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAReqSeqUSN
adminDisplayName: DXA-Req-Seq-USN
adminDescription: DXA-Req-Seq-USN
attributeId: 1.2.840.113556.1.2.182
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 5nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32920
hideFromAB: TRUE

dn: CN=MSMQ-Services,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQServices
adminDisplayName: MSMQ-Services
adminDescription: MSMQ-Services
attributeId: 1.2.840.113556.1.4.950
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Referral-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReferralList
adminDisplayName: Referral-List
adminDescription: Referral-List
attributeId: 1.2.840.113556.1.2.510
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1024
schemaIdGuid:: V3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33187
hideFromAB: TRUE

dn: CN=Role-Occupant,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: roleOccupant
adminDisplayName: Role-Occupant
adminDescription: Role-Occupant
attributeId: 2.5.4.33
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: ZXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33061
hideFromAB: TRUE

dn: CN=DXA-Import-Now,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAImportNow
adminDisplayName: DXA-Import-Now
adminDescription: DXA-Import-Now
attributeId: 1.2.840.113556.1.2.376
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 1XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32902
hideFromAB: TRUE

dn: CN=Outbound-Host,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OutboundHost
adminDisplayName: Outbound-Host
adminDescription: Outbound-Host
attributeId: 1.2.840.113556.1.2.488
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1024
schemaIdGuid:: QnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33165
hideFromAB: TRUE

dn: CN=Site-Affinity,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SiteAffinity
adminDisplayName: Site-Affinity
adminDescription: Site-Affinity
attributeId: 1.2.840.113556.1.2.434
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33079
hideFromAB: TRUE

dn: CN=msAscendFRN391,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRN391
adminDisplayName: msAscendFRN391
adminDescription: msAscendFRN391
attributeId: 1.2.840.113556.1.4.1035
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Export-Now,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAExportNow
adminDisplayName: DXA-Export-Now
adminDescription: DXA-Export-Now
attributeId: 1.2.840.113556.1.2.377
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 0XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32897
hideFromAB: TRUE

dn: CN=Unauth-Orig-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: UnauthOrigBL
adminDisplayName: Unauth-Orig-BL
adminDescription: Unauth-Orig-BL
attributeId: 1.2.840.113556.1.2.292
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: lnTfqOrF0RG7ywCAx2ZwwA==
linkID: 115
mapiID: 33106
hideFromAB: TRUE
systemFlags: 1

dn: CN=DXA-Svr-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXASvrSeqUSN
adminDisplayName: DXA-Svr-Seq-USN
adminDescription: DXA-Svr-Seq-USN
attributeId: 1.2.840.113556.1.2.124
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32924
hideFromAB: TRUE

dn: CN=msAscendFRT391,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRT391
adminDisplayName: msAscendFRT391
adminDescription: msAscendFRT391
attributeId: 1.2.840.113556.1.4.1038
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRT392,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRT392
adminDisplayName: msAscendFRT392
adminDescription: msAscendFRT392
attributeId: 1.2.840.113556.1.4.1039
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=USN-Intersite,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: USNIntersite
adminDisplayName: USN-Intersite
adminDescription: USN-Intersite
attributeId: 1.2.840.113556.1.2.469
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: mHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33146
hideFromAB: TRUE

dn: CN=LDAP-Search-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: LDAPSearchCfg
adminDisplayName: LDAP-Search-Cfg
adminDescription: LDAP-Search-Cfg
attributeId: 1.2.840.113556.1.2.552
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: F3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35869
hideFromAB: TRUE

dn: CN=Canonical-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: canonicalName
adminDisplayName: Canonical-Name
adminDescription: Canonical-Name
attributeId: 1.2.840.113556.1.4.916
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Rdl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=Can-Create-PF-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanCreatePFBL
adminDisplayName: Can-Create-PF-BL
adminDescription: Can-Create-PF-BL
attributeId: 1.2.840.113556.1.2.339
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: onPfqOrF0RG7ywCAx2ZwwA==
linkID: 125
mapiID: 32857
hideFromAB: TRUE
systemFlags: 1

dn: CN=Can-Create-PF-DL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanCreatePFDL
adminDisplayName: Can-Create-PF-DL
adminDescription: Can-Create-PF-DL
attributeId: 1.2.840.113556.1.2.62
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: o3PfqOrF0RG7ywCAx2ZwwA==
linkID: 126
mapiID: 32858
hideFromAB: TRUE

dn: CN=DXA-Local-Admin,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXALocalAdmin
adminDisplayName: DXA-Local-Admin
adminDescription: DXA-Local-Admin
attributeId: 1.2.840.113556.1.2.113
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 13PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32904
hideFromAB: TRUE

dn: CN=MTA-Local-Desig,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MTALocalDesig
adminDisplayName: MTA-Local-Desig
adminDescription: MTA-Local-Desig
attributeId: 1.2.840.113556.1.2.271
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: M3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33008
hideFromAB: TRUE

dn: CN=Object-Classes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: objectClasses
adminDisplayName: Object-Classes
adminDescription: Object-Classes
attributeId: 2.5.21.6
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: S9l6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=DXA-Imp-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAImpSeqTime
adminDisplayName: DXA-Imp-Seq-Time
adminDescription: DXA-Imp-Seq-Time
attributeId: 1.2.840.113556.1.2.117
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 03PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32900
hideFromAB: TRUE

dn: CN=msAscendGroup,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendGroup
adminDisplayName: msAscendGroup
adminDescription: msAscendGroup
attributeId: 1.2.840.113556.1.4.1042
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Req-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAReqSeqTime
adminDisplayName: DXA-Req-Seq-Time
adminDescription: DXA-Req-Seq-Time
attributeId: 1.2.840.113556.1.2.114
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 5XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32919
hideFromAB: TRUE

dn: CN=DXA-Conf-Seq-USN,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAConfSeqUSN
adminDisplayName: DXA-Conf-Seq-USN
adminDescription: DXA-Conf-Seq-USN
attributeId: 1.2.840.113556.1.2.45
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: z3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32895
hideFromAB: TRUE

dn: CN=MSMQ-Long-Lived,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQLongLived
adminDisplayName: MSMQ-Long-Lived
adminDescription: MSMQ-Long-Lived
attributeId: 1.2.840.113556.1.4.941
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Site-Gates,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSiteGates
adminDisplayName: MSMQ-Site-Gates
adminDescription: MSMQ-Site-Gates
attributeId: 1.2.840.113556.1.4.945
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPTimeOfDay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPTimeOfDay
adminDisplayName: msNPTimeOfDay
adminDescription: msNPTimeOfDay
attributeId: 1.2.840.113556.1.4.1133
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: kZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSClass,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSClass
adminDisplayName: msRADIUSClass
adminDescription: msRADIUSClass
attributeId: 1.2.840.113556.1.4.1146
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: nZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Svr-Seq-Time,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXASvrSeqTime
adminDisplayName: DXA-Svr-Seq-Time
adminDescription: DXA-Svr-Seq-Time
attributeId: 1.2.840.113556.1.2.361
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32923
hideFromAB: TRUE

dn: CN=MSMQ-Name-Style,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQNameStyle
adminDisplayName: MSMQ-Name-Style
adminDescription: MSMQ-Name-Style
attributeId: 1.2.840.113556.1.4.939
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: M8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Outbound-Sites,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OutboundSites
adminDisplayName: Outbound-Sites
adminDescription: Outbound-Sites
attributeId: 1.2.840.113556.1.2.0
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: RXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33029
hideFromAB: TRUE

dn: CN=MSMQ-Queue-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQQueueType
adminDisplayName: MSMQ-Queue-Type
adminDescription: MSMQ-Queue-Type
attributeId: 1.2.840.113556.1.4.917
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: IMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Newsgroup-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NewsgroupList
adminDisplayName: Newsgroup-List
adminDescription: Newsgroup-List
attributeId: 1.2.840.113556.1.2.497
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: N3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33174
hideFromAB: TRUE

dn: CN=Report-To-Owner,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReportToOwner
adminDisplayName: Report-To-Owner
adminDescription: Report-To-Owner
attributeId: 1.2.840.113556.1.2.207
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: X3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33057
hideFromAB: TRUE

dn: CN=Telephone-Personal-Pager,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: personalPager
adminDisplayName: Telephone-Personal-Pager
adminDescription: Telephone-Personal-Pager
attributeId: 1.2.840.113556.1.2.612
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: h3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35944
hideFromAB: TRUE

dn: CN=RTS-Window-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RTSWindowSize
adminDisplayName: RTS-Window-Size
adminDescription: RTS-Window-Size
attributeId: 1.2.840.113556.1.2.153
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 10
schemaIdGuid:: anTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33065
hideFromAB: TRUE

dn: CN=Use-Site-Values,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: UseSiteValues
adminDisplayName: Use-Site-Values
adminDescription: Use-Site-Values
attributeId: 1.2.840.113556.1.2.478
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: l3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33155
hideFromAB: TRUE

dn: CN=msAscendBridge,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendBridge
adminDisplayName: msAscendBridge
adminDescription: msAscendBridge
attributeId: 1.2.840.113556.1.4.989
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: A5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRDLCI,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDLCI
adminDisplayName: msAscendFRDLCI
adminDescription: msAscendFRDLCI
attributeId: 1.2.840.113556.1.4.1030
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendBackup,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendBackup
adminDisplayName: msAscendBackup
adminDescription: msAscendBackup
attributeId: 1.2.840.113556.1.4.985
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /48M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendForce56,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendForce56
adminDisplayName: msAscendForce56
adminDescription: msAscendForce56
attributeId: 1.2.840.113556.1.4.1023
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Admin-Update,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAAdminUpdate
adminDisplayName: DXA-Admin-Update
adminDescription: DXA-Admin-Update
attributeId: 1.2.840.113556.1.2.381
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ynPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32890
hideFromAB: TRUE

dn: CN=Can-Not-Create-PF,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanNotCreatePF
adminDisplayName: Can-Not-Create-PF
adminDescription: Can-Not-Create-PF
attributeId: 1.2.840.113556.1.2.63
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: pXPfqOrF0RG7ywCAx2ZwwA==
linkID: 128
mapiID: 32860
hideFromAB: TRUE

dn: CN=DXA-Append-ReqCN,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAAppendReqCN
adminDisplayName: DXA-Append-ReqCN
adminDescription: DXA-Append-ReqCN
attributeId: 1.2.840.113556.1.2.174
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: y3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32891
hideFromAB: TRUE

dn: CN=DXA-Recipient-CP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXARecipientCP
adminDisplayName: DXA-Recipient-CP
adminDescription: DXA-Recipient-CP
attributeId: 1.2.840.113556.1.2.384
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 24
schemaIdGuid:: 4nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32916
hideFromAB: TRUE

dn: CN=MDB-Unread-Limit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MDBUnreadLimit
adminDisplayName: MDB-Unread-Limit
adminDescription: MDB-Unread-Limit
attributeId: 1.2.840.113556.1.2.69
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32979
hideFromAB: TRUE

dn: CN=msAscendMetric,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMetric
adminDisplayName: msAscendMetric
adminDescription: msAscendMetric
attributeId: 1.2.840.113556.1.4.1065
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: T5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Off-Line-AB-Style,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OffLineABStyle
adminDisplayName: Off-Line-AB-Style
adminDescription: Off-Line-AB-Style
attributeId: 1.2.840.113556.1.2.390
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: P3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33019
hideFromAB: TRUE

dn: CN=DXA-Conf-Req-Time,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAConfReqTime
adminDisplayName: DXA-Conf-Req-Time
adminDescription: DXA-Conf-Req-Time
attributeId: 1.2.840.113556.1.2.122
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: zXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32893
hideFromAB: TRUE

dn: CN=Can-Preserve-DNs,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanPreserveDNs
adminDisplayName: Can-Preserve-DNs
adminDescription: Can-Preserve-DNs
attributeId: 1.2.840.113556.1.2.455
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32864
hideFromAB: TRUE

dn: CN=Employee-Number,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: employeeNumber
adminDisplayName: Employee-Number
adminDescription: Employee-Number
attributeId: 1.2.840.113556.1.2.610
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: 73PfqOrF0RG7ywCAx2ZwwA==
mapiID: 35943
hideFromAB: TRUE

dn: CN=Connection-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ConnectionType
adminDisplayName: Connection-Type
adminDescription: Connection-Type
attributeId: 1.2.840.113556.1.2.525
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: uHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33203
hideFromAB: TRUE

dn: CN=msAscendFRType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRType
adminDisplayName: msAscendFRType
adminDescription: msAscendFRType
attributeId: 1.2.840.113556.1.4.1040
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPIPPoolName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPIPPoolName
adminDisplayName: msNPIPPoolName
adminDescription: msNPIPPoolName
attributeId: 1.2.840.113556.1.4.1128
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: jJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSAnyVSA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSAnyVSA
adminDisplayName: msRADIUSAnyVSA
adminDescription: msRADIUSAnyVSA
attributeId: 1.2.840.113556.1.4.1137
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRASUseRADIUS,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRASUseRADIUS
adminDisplayName: msRASUseRADIUS
adminDescription: msRASUseRADIUS
attributeId: 1.2.840.113556.1.4.1192
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: yJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Authorized-User,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthorizedUser
adminDisplayName: Authorized-User
adminDescription: Authorized-User
attributeId: 1.2.840.113556.1.2.276
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: nXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32854
hideFromAB: TRUE

dn: CN=msNPConstraint,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPConstraint
adminDisplayName: msNPConstraint
adminDescription: msNPConstraint
attributeId: 1.2.840.113556.1.4.1126
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: i5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Attribute-Types,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: attributeTypes
adminDisplayName: Attribute-Types
adminDescription: Attribute-Types
attributeId: 2.5.21.5
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: RNl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=Local-Bridge-Head,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: LocalBridgeHead
adminDisplayName: Local-Bridge-Head
adminDescription: Local-Bridge-Head
attributeId: 1.2.840.113556.1.2.311
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: GnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32966
hideFromAB: TRUE

dn: CN=msRADIUSPrompt,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSPrompt
adminDisplayName: msRADIUSPrompt
adminDescription: msRADIUSPrompt
attributeId: 1.2.840.113556.1.4.1170
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: tZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Encrypt-Key,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQEncryptKey
adminDisplayName: MSMQ-Encrypt-Key
adminDescription: MSMQ-Encrypt-Key
attributeId: 1.2.840.113556.1.4.936
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: McMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=RAS-Phone-Number,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RASPhoneNumber
adminDisplayName: RAS-Phone-Number
adminDescription: RAS-Phone-Number
attributeId: 1.2.840.113556.1.2.314
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: VHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33046
hideFromAB: TRUE

dn: CN=Monitor-Servers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitorServers
adminDisplayName: Monitor-Servers
adminDescription: Monitor-Servers
attributeId: 1.2.840.113556.1.2.156
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32983
hideFromAB: TRUE

dn: CN=Site-Folder-GUID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SiteFolderGUID
adminDisplayName: Site-Folder-GUID
adminDescription: Site-Folder-GUID
attributeId: 1.2.840.113556.1.2.456
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: d3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33126
hideFromAB: TRUE

dn: CN=Site-Proxy-Space,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SiteProxySpace
adminDisplayName: Site-Proxy-Space
adminDescription: Site-Proxy-Space
attributeId: 1.2.840.113556.1.2.385
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1123
schemaIdGuid:: eXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33080
hideFromAB: TRUE

dn: CN=SMIME-Alg-List-NA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SMIMEAlgListNA
adminDisplayName: SMIME-Alg-List-NA
adminDescription: SMIME-Alg-List-NA
attributeId: 1.2.840.113556.1.2.568
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: enTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35891
hideFromAB: TRUE

dn: CN=Can-Create-PF-DL-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanCreatePFDLBL
adminDisplayName: Can-Create-PF-DL-BL
adminDescription: Can-Create-PF-DL-BL
attributeId: 1.2.840.113556.1.2.340
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: pHPfqOrF0RG7ywCAx2ZwwA==
linkID: 127
mapiID: 32859
hideFromAB: TRUE
systemFlags: 1

dn: CN=Telephone-Personal-Mobile,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: personalMobile
adminDisplayName: Telephone-Personal-Mobile
adminDescription: Telephone-Personal-Mobile
attributeId: 1.2.840.113556.1.2.611
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: hnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 14877
hideFromAB: TRUE

dn: CN=Trans-Retry-Mins,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransRetryMins
adminDisplayName: Trans-Retry-Mins
adminDescription: Trans-Retry-Mins
attributeId: 1.2.840.113556.1.2.219
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: inTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33095
hideFromAB: TRUE

dn: CN=View-Definition,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ViewDefinition
adminDisplayName: View-Definition
adminDescription: View-Definition
attributeId: 1.2.840.113556.1.2.549
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 2048
schemaIdGuid:: mXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35867
hideFromAB: TRUE

dn: CN=msAscendDataSvc,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDataSvc
adminDisplayName: msAscendDataSvc
adminDescription: msAscendDataSvc
attributeId: 1.2.840.113556.1.4.1009
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: F5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Logging-Level,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXALoggingLevel
adminDisplayName: DXA-Logging-Level
adminDescription: DXA-Logging-Level
attributeId: 1.2.840.113556.1.2.382
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 1
schemaIdGuid:: 2HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32905
hideFromAB: TRUE

dn: CN=Off-Line-AB-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OffLineABServer
adminDisplayName: Off-Line-AB-Server
adminDescription: Off-Line-AB-Server
attributeId: 1.2.840.113556.1.2.392
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: PnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33018
hideFromAB: TRUE

dn: CN=Inbound-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: InboundNewsfeed
adminDisplayName: Inbound-Newsfeed
adminDescription: Inbound-Newsfeed
attributeId: 1.2.840.113556.1.2.494
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: EnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33171
hideFromAB: TRUE

dn: CN=Maximum-Object-ID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MaximumObjectID
adminDisplayName: Maximum-Object-ID
adminDescription: Maximum-Object-ID
attributeId: 1.2.840.113556.1.2.458
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 22
schemaIdGuid:: HnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33129
hideFromAB: TRUE

dn: CN=House-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: houseIdentifier
adminDisplayName: House-Identifier
adminDescription: House-Identifier
attributeId: 1.2.840.113556.1.2.596
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: B3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35924
hideFromAB: TRUE

dn: CN=DXA-Remote-Client,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXARemoteClient
adminDisplayName: DXA-Remote-Client
adminDescription: DXA-Remote-Client
attributeId: 1.2.840.113556.1.2.112
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 43PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32917
hideFromAB: TRUE

dn: CN=msAscendPPPVJ1172,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPPPVJ1172
adminDisplayName: msAscendPPPVJ1172
adminDescription: msAscendPPPVJ1172
attributeId: 1.2.840.113556.1.4.1080
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: XpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPAllowDialin,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPAllowDialin
adminDisplayName: msNPAllowDialin
adminDescription: msNPAllowDialin
attributeId: 1.2.840.113556.1.4.1119
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRouteIP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRouteIP
adminDisplayName: msAscendRouteIP
adminDescription: msAscendRouteIP
attributeId: 1.2.840.113556.1.4.1096
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=HTTP-Pub-GAL-Limit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HTTPPubGALLimit
adminDisplayName: HTTP-Pub-GAL-Limit
adminDescription: HTTP-Pub-GAL-Limit
attributeId: 1.2.840.113556.1.2.503
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: CnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33180
hideFromAB: TRUE

dn: CN=Anonymous-Access,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AnonymousAccess
adminDisplayName: Anonymous-Access
adminDescription: Anonymous-Access
attributeId: 1.2.840.113556.1.2.482
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: knPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33159
hideFromAB: TRUE

dn: CN=Import-Container,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ImportContainer
adminDisplayName: Import-Container
adminDescription: Import-Container
attributeId: 1.2.840.113556.1.2.110
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: DXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32954
hideFromAB: TRUE

dn: CN=Modify-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: modifyTimeStamp
adminDisplayName: Modify-Time-Stamp
adminDescription: Modify-Time-Stamp
attributeId: 2.5.18.2
attributeSyntax: 2.5.5.11
omSyntax: 24
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Stl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=msAscendFRDCEN392,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDCEN392
adminDisplayName: msAscendFRDCEN392
adminDescription: msAscendFRDCEN392
attributeId: 1.2.840.113556.1.4.1025
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: J5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRDCEN393,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDCEN393
adminDisplayName: msAscendFRDCEN393
adminDescription: msAscendFRDCEN393
attributeId: 1.2.840.113556.1.4.1026
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DIT-Content-Rules,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: dITContentRules
adminDisplayName: DIT-Content-Rules
adminDescription: DIT-Content-Rules
attributeId: 2.5.21.2
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Rtl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=Monitor-Services,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitorServices
adminDisplayName: Monitor-Services
adminDescription: Monitor-Services
attributeId: 1.2.840.113556.1.2.160
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32984
hideFromAB: TRUE

dn: CN=msAscendFRDTEN392,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDTEN392
adminDisplayName: msAscendFRDTEN392
adminDescription: msAscendFRDTEN392
attributeId: 1.2.840.113556.1.4.1031
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRDTEN393,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDTEN393
adminDisplayName: msAscendFRDTEN393
adminDescription: msAscendFRDTEN393
attributeId: 1.2.840.113556.1.4.1032
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Service-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQServiceType
adminDisplayName: MSMQ-Service-Type
adminDescription: MSMQ-Service-Type
attributeId: 1.2.840.113556.1.4.930
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Control-Msg-Rules,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ControlMsgRules
adminDisplayName: Control-Msg-Rules
adminDescription: Control-Msg-Rules
attributeId: 1.2.840.113556.1.2.485
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32767
schemaIdGuid:: u3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 33162
hideFromAB: TRUE

dn: CN=Short-Server-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: shortServerName
adminDisplayName: Short-Server-Name
adminDescription: Short-Server-Name
attributeId: 1.2.840.113556.1.4.1209
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ARWwRRnE0RG7yQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Supporting-Stack,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SupportingStack
adminDisplayName: Supporting-Stack
adminDescription: Supporting-Stack
attributeId: 1.2.840.113556.1.2.28
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: gHTfqOrF0RG7ywCAx2ZwwA==
linkID: 132
mapiID: 33086
hideFromAB: TRUE

dn: CN=msAscendCallback,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallback
adminDisplayName: msAscendCallback
adminDescription: msAscendCallback
attributeId: 1.2.840.113556.1.4.992
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendCBCPMode,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCBCPMode
adminDisplayName: msAscendCBCPMode
adminDescription: msAscendCBCPMode
attributeId: 1.2.840.113556.1.4.1000
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Remote-Bridge-Head,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RemoteBridgeHead
adminDisplayName: Remote-Bridge-Head
adminDescription: Remote-Bridge-Head
attributeId: 1.2.840.113556.1.2.191
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: WHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33050
hideFromAB: TRUE


dn: CN=msAscendDataRate,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDataRate
adminDisplayName: msAscendDataRate
adminDescription: msAscendDataRate
attributeId: 1.2.840.113556.1.4.1008
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Hide-DL-Membership,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HideDLMembership
adminDisplayName: Hide-DL-Membership
adminDescription: Hide-DL-Membership
attributeId: 1.2.840.113556.1.2.297
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32952
hideFromAB: TRUE

dn: CN=Send-EMail-Message,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SendEMailMessage
adminDisplayName: Send-EMail-Message
adminDescription: Send-EMail-Message
attributeId: 1.2.840.113556.1.2.566
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35889
hideFromAB: TRUE

dn: CN=Inbound-Accept-All,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: InboundAcceptAll
adminDisplayName: Inbound-Accept-All
adminDescription: Inbound-Accept-All
attributeId: 1.2.840.113556.1.2.555
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: D3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35872
hideFromAB: TRUE

dn: CN=Can-Not-Create-PF-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanNotCreatePFBL
adminDisplayName: Can-Not-Create-PF-BL
adminDescription: Can-Not-Create-PF-BL
attributeId: 1.2.840.113556.1.2.341
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: pnPfqOrF0RG7ywCAx2ZwwA==
linkID: 129
mapiID: 32861
hideFromAB: TRUE
systemFlags: 1

dn: CN=Can-Not-Create-PF-DL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanNotCreatePFDL
adminDisplayName: Can-Not-Create-PF-DL
adminDescription: Can-Not-Create-PF-DL
attributeId: 1.2.840.113556.1.2.300
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: p3PfqOrF0RG7ywCAx2ZwwA==
linkID: 130
mapiID: 32862
hideFromAB: TRUE

dn: CN=Connected-Domains,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ConnectedDomains
adminDisplayName: Connected-Domains
adminDescription: Connected-Domains
attributeId: 1.2.840.113556.1.2.211
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1243
schemaIdGuid:: tXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32870
hideFromAB: TRUE

dn: CN=Gateway-Local-Cred,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: GatewayLocalCred
adminDisplayName: Gateway-Local-Cred
adminDescription: Gateway-Local-Cred
attributeId: 1.2.840.113556.1.2.37
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: AXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32944
hideFromAB: TRUE

dn: CN=msAscendFRDirect,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDirect
adminDisplayName: msAscendFRDirect
adminDescription: msAscendFRDirect
attributeId: 1.2.840.113556.1.4.1027
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIPDirect,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIPDirect
adminDisplayName: msAscendIPDirect
adminDescription: msAscendIPDirect
attributeId: 1.2.840.113556.1.4.1053
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Q5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Clock-Alert-Repair,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ClockAlertRepair
adminDisplayName: Clock-Alert-Repair
adminDescription: Clock-Alert-Repair
attributeId: 1.2.840.113556.1.2.164
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: sXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32866
hideFromAB: TRUE

dn: CN=msAscendIPXAlias,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIPXAlias
adminDisplayName: msAscendIPXAlias
adminDescription: msAscendIPXAlias
attributeId: 1.2.840.113556.1.4.1055
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Clock-Alert-Offset,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ClockAlertOffset
adminDisplayName: Clock-Alert-Offset
adminDescription: Clock-Alert-Offset
attributeId: 1.2.840.113556.1.2.165
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: sHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32865
hideFromAB: TRUE

dn: CN=DXA-In-Template-Map,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAInTemplateMap
adminDisplayName: DXA-In-Template-Map
adminDescription: DXA-In-Template-Map
attributeId: 1.2.840.113556.1.2.363
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: 1nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32903
hideFromAB: TRUE

dn: CN=DL-Mem-Reject-Perms,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DLMemRejectPerms
adminDisplayName: DL-Mem-Reject-Perms
adminDescription: DL-Mem-Reject-Perms
attributeId: 1.2.840.113556.1.2.47
attributeSyntax: 2.5.5.7
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: VgYBAgULHQ==
schemaIdGuid:: wnPfqOrF0RG7ywCAx2ZwwA==
linkID: 116
hideFromAB: TRUE

dn: CN=Character-Set-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CharacterSetList
adminDisplayName: Character-Set-List
adminDescription: Character-Set-List
attributeId: 1.2.840.113556.1.2.477
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: rnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33154
hideFromAB: TRUE

dn: CN=Expand-DLs-Locally,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ExpandDLsLocally
adminDisplayName: Expand-DLs-Locally
adminDescription: Expand-DLs-Locally
attributeId: 1.2.840.113556.1.2.201
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32932
hideFromAB: TRUE

dn: CN=Authorized-Domain,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthorizedDomain
adminDisplayName: Authorized-Domain
adminDescription: Authorized-Domain
attributeId: 1.2.840.113556.1.2.202
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 15
schemaIdGuid:: mnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32852
hideFromAB: TRUE

dn: CN=Folders-Container,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: FoldersContainer
adminDisplayName: Folders-Container
adminDescription: Folders-Container
attributeId: 1.2.840.113556.1.2.235
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: /3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32942
hideFromAB: TRUE

dn: CN=msAscendCallType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallType
adminDisplayName: msAscendCallType
adminDescription: msAscendCallType
attributeId: 1.2.840.113556.1.4.997
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: C5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRLinkUp,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRLinkUp
adminDisplayName: msAscendFRLinkUp
adminDescription: msAscendFRLinkUp
attributeId: 1.2.840.113556.1.4.1034
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendHostInfo,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHostInfo
adminDisplayName: msAscendHostInfo
adminDescription: msAscendHostInfo
attributeId: 1.2.840.113556.1.4.1049
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: P5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Local-Initial-Turn,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: LocalInitialTurn
adminDisplayName: Local-Initial-Turn
adminDescription: Local-Initial-Turn
attributeId: 1.2.840.113556.1.2.39
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32968
hideFromAB: TRUE

dn: CN=Home-Public-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HomePublicServer
adminDisplayName: Home-Public-Server
adminDescription: Home-Public-Server
attributeId: 1.2.840.113556.1.2.441
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: BnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32831
hideFromAB: TRUE


dn: CN=msAscendMenuItem,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMenuItem
adminDisplayName: msAscendMenuItem
adminDescription: msAscendMenuItem
attributeId: 1.2.840.113556.1.4.1063
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: TZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRemoteFW,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRemoteFW
adminDisplayName: msAscendRemoteFW
adminDescription: msAscendRemoteFW
attributeId: 1.2.840.113556.1.4.1092
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: apAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Encrypt-Alg-List-NA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EncryptAlgListNA
adminDisplayName: Encrypt-Alg-List-NA
adminDescription: Encrypt-Alg-List-NA
attributeId: 1.2.840.113556.1.2.130
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: 93PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32832
hideFromAB: TRUE

dn: CN=Incoming-Password,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: IncomingPassword
adminDisplayName: Incoming-Password
adminDescription: Incoming-Password
attributeId: 1.2.840.113556.1.2.521
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33199
hideFromAB: TRUE

dn: CN=msAscendSendAuth,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSendAuth
adminDisplayName: msAscendSendAuth
adminDescription: msAscendSendAuth
attributeId: 1.2.840.113556.1.4.1101
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: c5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DL-Mem-Submit-Perms,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DLMemSubmitPerms
adminDisplayName: DL-Mem-Submit-Perms
adminDescription: DL-Mem-Submit-Perms
attributeId: 1.2.840.113556.1.2.144
attributeSyntax: 2.5.5.7
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: VgYBAgULHQ==
schemaIdGuid:: xHPfqOrF0RG7ywCAx2ZwwA==
linkID: 112
hideFromAB: TRUE

dn: CN=msAscendFT1Caller,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFT1Caller
adminDisplayName: msAscendFT1Caller
adminDescription: msAscendFT1Caller
attributeId: 1.2.840.113556.1.4.1041
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: N5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIPXRoute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIPXRoute
adminDisplayName: msAscendIPXRoute
adminDescription: msAscendIPXRoute
attributeId: 1.2.840.113556.1.4.1058
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: SJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRouteIPX,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRouteIPX
adminDisplayName: msAscendRouteIPX
adminDescription: msAscendRouteIPX
attributeId: 1.2.840.113556.1.4.1097
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: b5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendXmitRate,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendXmitRate
adminDisplayName: msAscendXmitRate
adminDescription: msAscendXmitRate
attributeId: 1.2.840.113556.1.4.1118
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Authenticate,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQAuthenticate
adminDisplayName: MSMQ-Authenticate
adminDescription: MSMQ-Authenticate
attributeId: 1.2.840.113556.1.4.923
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=msRADIUSFilterId,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFilterId
adminDisplayName: msRADIUSFilterId
adminDescription: msRADIUSFilterId
attributeId: 1.2.840.113556.1.4.1148
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: n5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Anonymous-Account,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AnonymousAccount
adminDisplayName: Anonymous-Account
adminDescription: Anonymous-Account
attributeId: 1.2.840.113556.1.2.561
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: k3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 35878
hideFromAB: TRUE

dn: CN=Export-Containers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ExportContainers
adminDisplayName: Export-Containers
adminDescription: Export-Containers
attributeId: 1.2.840.113556.1.2.111
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: /HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32933
hideFromAB: TRUE

dn: CN=Monitored-Servers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoredServers
adminDisplayName: Monitored-Servers
adminDescription: Monitored-Servers
attributeId: 1.2.840.113556.1.2.179
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: JnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32986
hideFromAB: TRUE

dn: CN=MSMQ-Base-Priority,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQBasePriority
adminDisplayName: MSMQ-Base-Priority
adminDescription: MSMQ-Base-Priority
attributeId: 1.2.840.113556.1.4.920
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: I8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Num-Of-Open-Retries,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NumOfOpenRetries
adminDisplayName: Num-Of-Open-Retries
adminDescription: Num-Of-Open-Retries
attributeId: 1.2.840.113556.1.2.148
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: OnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33012
hideFromAB: TRUE

dn: CN=Outbound-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OutboundNewsfeed
adminDisplayName: Outbound-Newsfeed
adminDescription: Outbound-Newsfeed
attributeId: 1.2.840.113556.1.2.496
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33173
hideFromAB: TRUE

dn: CN=MSMQ-Journal-Quota,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQJournalQuota
adminDisplayName: MSMQ-Journal-Quota
adminDescription: MSMQ-Journal-Quota
attributeId: 1.2.840.113556.1.4.921
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=P-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: PSelectorInbound
adminDisplayName: P-Selector-Inbound
adminDescription: P-Selector-Inbound
attributeId: 1.2.840.113556.1.2.52
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 16
schemaIdGuid:: SXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33031
hideFromAB: TRUE

dn: CN=MSMQ-Computer-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQComputerType
adminDisplayName: MSMQ-Computer-Type
adminDescription: MSMQ-Computer-Type
attributeId: 1.2.840.113556.1.4.933
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Outbound-Host-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OutboundHostType
adminDisplayName: Outbound-Host-Type
adminDescription: Outbound-Host-Type
attributeId: 1.2.840.113556.1.2.522
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Q3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33200
hideFromAB: TRUE

dn: CN=S-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SSelectorInbound
adminDisplayName: S-Selector-Inbound
adminDescription: S-Selector-Inbound
attributeId: 1.2.840.113556.1.2.46
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 16
schemaIdGuid:: bXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33068
hideFromAB: TRUE

dn: CN=Off-Line-AB-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OffLineABSchedule
adminDisplayName: Off-Line-AB-Schedule
adminDescription: Off-Line-AB-Schedule
attributeId: 1.2.840.113556.1.2.389
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 84
rangeUpper: 84
schemaIdGuid:: PXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33017
hideFromAB: TRUE

dn: CN=msAscendCBCPDelay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCBCPDelay
adminDisplayName: msAscendCBCPDelay
adminDescription: msAscendCBCPDelay
attributeId: 1.2.840.113556.1.4.998
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=RAS-Callback-Number,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RASCallbackNumber
adminDisplayName: RAS-Callback-Number
adminDescription: RAS-Callback-Number
attributeId: 1.2.840.113556.1.2.315
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 48
schemaIdGuid:: UnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33045
hideFromAB: TRUE

dn: CN=Site-Folder-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SiteFolderServer
adminDisplayName: Site-Folder-Server
adminDescription: Site-Folder-Server
attributeId: 1.2.840.113556.1.2.457
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: eHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33127
hideFromAB: TRUE

dn: CN=T-Selector-Inbound,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TSelectorInbound
adminDisplayName: T-Selector-Inbound
adminDescription: T-Selector-Inbound
attributeId: 1.2.840.113556.1.2.5
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: gnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33089
hideFromAB: TRUE

dn: CN=Trans-Timeout-Mins,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransTimeoutMins
adminDisplayName: Trans-Timeout-Mins
adminDescription: Trans-Timeout-Mins
attributeId: 1.2.840.113556.1.2.220
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: i3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33096
hideFromAB: TRUE

dn: CN=Bridgehead-Servers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: BridgeheadServers
adminDisplayName: Bridgehead-Servers
adminDescription: Bridgehead-Servers
attributeId: 1.2.840.113556.1.2.463
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: oHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33140
hideFromAB: TRUE

dn: CN=Gateway-Local-Desig,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: GatewayLocalDesig
adminDisplayName: Gateway-Local-Desig
adminDescription: Gateway-Local-Desig
attributeId: 1.2.840.113556.1.2.29
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: AnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32945
hideFromAB: TRUE

dn: CN=msAscendHandleIPX,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHandleIPX
adminDisplayName: msAscendHandleIPX
adminDescription: msAscendHandleIPX
attributeId: 1.2.840.113556.1.4.1043
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIdleLimit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIdleLimit
adminDisplayName: msAscendIdleLimit
adminDescription: msAscendIdleLimit
attributeId: 1.2.840.113556.1.4.1050
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIFNetmask,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIFNetmask
adminDisplayName: msAscendIFNetmask
adminDescription: msAscendIFNetmask
attributeId: 1.2.840.113556.1.4.1051
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Extended-Class-Info,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: extendedClassInfo
adminDisplayName: Extended-Class-Info
adminDescription: Extended-Class-Info
attributeId: 1.2.840.113556.1.4.908
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: SNl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=msAscendDHCPReply,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDHCPReply
adminDisplayName: msAscendDHCPReply
adminDescription: msAscendDHCPReply
attributeId: 1.2.840.113556.1.4.1014
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRLinkMgt,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRLinkMgt
adminDisplayName: msAscendFRLinkMgt
adminDescription: msAscendFRLinkMgt
attributeId: 1.2.840.113556.1.4.1033
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: L5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Admin-Extension-DLL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AdminExtensionDLL
adminDisplayName: Admin-Extension-DLL
adminDescription: Admin-Extension-DLL
attributeId: 1.2.840.113556.1.2.95
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 255
schemaIdGuid:: kXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32844
hideFromAB: TRUE

dn: CN=msAscendFirstDest,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFirstDest
adminDisplayName: msAscendFirstDest
adminDescription: msAscendFirstDest
attributeId: 1.2.840.113556.1.4.1022
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=List-Public-Folders,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ListPublicFolders
adminDisplayName: List-Public-Folders
adminDescription: List-Public-Folders
attributeId: 1.2.840.113556.1.2.592
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: GXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35920
hideFromAB: TRUE

dn: CN=Display-Name-Suffix,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DisplayNameSuffix
adminDisplayName: Display-Name-Suffix
adminDescription: Display-Name-Suffix
attributeId: 1.2.840.113556.1.2.586
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: wXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35908
hideFromAB: TRUE

dn: CN=msRADIUSEapTypeID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSEapTypeID
adminDisplayName: msRADIUSEapTypeID
adminDescription: msRADIUSEapTypeID
attributeId: 1.2.840.113556.1.4.1210
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 4I3dYZnF0RG7ywCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Allowed-Attributes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: allowedAttributes
adminDisplayName: Allowed-Attributes
adminDescription: Allowed-Attributes
attributeId: 1.2.840.113556.1.4.913
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: QNl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=Certificate-Chain-V3,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CertificateChainV3
adminDisplayName: Certificate-Chain-V3
adminDescription: Certificate-Chain-V3
attributeId: 1.2.840.113556.1.2.562
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35879
hideFromAB: TRUE

dn: CN=DXA-Out-Template-Map,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAOutTemplateMap
adminDisplayName: DXA-Out-Template-Map
adminDescription: DXA-Out-Template-Map
attributeId: 1.2.840.113556.1.2.364
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: 2nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32907
hideFromAB: TRUE

dn: CN=msAscendEventType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendEventType
adminDisplayName: msAscendEventType
adminDescription: msAscendEventType
attributeId: 1.2.840.113556.1.4.1019
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Transactional,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQTransactional
adminDisplayName: MSMQ-Transactional
adminDescription: MSMQ-Transactional
attributeId: 1.2.840.113556.1.4.926
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=msRADIUSFramedMTU,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedMTU
adminDisplayName: msRADIUSFramedMTU
adminDescription: msRADIUSFramedMTU
attributeId: 1.2.840.113556.1.4.1156
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: p5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Possible-Inferiors,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: possibleInferiors
adminDisplayName: Possible-Inferiors
adminDescription: Possible-Inferiors
attributeId: 1.2.840.113556.1.4.915
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: TNl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=MSMQ-Privacy-Levell,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQPrivacyLevell
adminDisplayName: MSMQ-Privacy-Levell
adminDescription: MSMQ-Privacy-Levell
attributeId: 1.2.840.113556.1.4.924
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: J8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=RAS-Remote-SRVR-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RASRemoteSRVRName
adminDisplayName: RAS-Remote-SRVR-Name
adminDescription: RAS-Remote-SRVR-Name
attributeId: 1.2.840.113556.1.2.78
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 15
schemaIdGuid:: VnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33048
hideFromAB: TRUE

dn: CN=Proxy-Generator-DLL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ProxyGeneratorDLL
adminDisplayName: Proxy-Generator-DLL
adminDescription: Proxy-Generator-DLL
attributeId: 1.2.840.113556.1.2.328
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 255
schemaIdGuid:: TnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33039
hideFromAB: TRUE

dn: CN=Remote-Out-BH-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RemoteOutBHServer
adminDisplayName: Remote-Out-BH-Server
adminDescription: Remote-Out-BH-Server
attributeId: 1.2.840.113556.1.2.310
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: WnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33052
hideFromAB: TRUE

dn: CN=RTS-Checkpoint-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RTSCheckpointSize
adminDisplayName: RTS-Checkpoint-Size
adminDescription: RTS-Checkpoint-Size
attributeId: 1.2.840.113556.1.2.152
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 100
schemaIdGuid:: aHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33063
hideFromAB: TRUE

dn: CN=msAscendBACPEnable,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendBACPEnable
adminDisplayName: msAscendBACPEnable
adminDescription: msAscendBACPEnable
attributeId: 1.2.840.113556.1.4.986
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: AJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendCBCPEnable,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCBCPEnable
adminDisplayName: msAscendCBCPEnable
adminDescription: msAscendCBCPEnable
attributeId: 1.2.840.113556.1.4.999
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSPortLimit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSPortLimit
adminDisplayName: msRADIUSPortLimit
adminDescription: msRADIUSPortLimit
attributeId: 1.2.840.113556.1.4.1169
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: tJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Open-Retry-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OpenRetryInterval
adminDisplayName: Open-Retry-Interval
adminDescription: Open-Retry-Interval
attributeId: 1.2.840.113556.1.2.143
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33024
hideFromAB: TRUE

dn: CN=NNTP-Distributions,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NNTPDistributions
adminDisplayName: NNTP-Distributions
adminDescription: NNTP-Distributions
attributeId: 1.2.840.113556.1.2.498
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 4096
schemaIdGuid:: OHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33175
hideFromAB: TRUE

dn: CN=SMIME-Alg-List-Other,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SMIMEAlgListOther
adminDisplayName: SMIME-Alg-List-Other
adminDescription: SMIME-Alg-List-Other
attributeId: 1.2.840.113556.1.2.569
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: e3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35892
hideFromAB: TRUE

dn: CN=SubSchemaSubEntry,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: subSchemaSubEntry
adminDisplayName: SubSchemaSubEntry
adminDescription: SubSchemaSubEntry
attributeId: 2.5.18.10
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIDGUID:: Tdl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=Well-Known-Objects,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: wellKnownObjects
adminDisplayName: Well-Known-Objects
adminDescription: Well-Known-Objects
attributeId: 1.2.840.113556.1.4.618
attributeSyntax: 2.5.5.7
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
oMObjectClass:: KoZIhvcUAQEBCw==
schemaIdGuid:: g4kwBYh20RGt7QDAT9jVzQ==
hideFromAB: TRUE

dn: CN=X25-Leased-Line-Port,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25LeasedLinePort
adminDisplayName: X25-Leased-Line-Port
adminDescription: X25-Leased-Line-Port
attributeId: 1.2.840.113556.1.2.321
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 3
schemaIdGuid:: n3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33117
hideFromAB: TRUE

dn: CN=msAscendCallByCall,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallByCall
adminDisplayName: msAscendCallByCall
adminDescription: msAscendCallByCall
attributeId: 1.2.840.113556.1.4.995
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: CZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSCallbackId,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSCallbackId
adminDisplayName: msRADIUSCallbackId
adminDescription: msRADIUSCallbackId
attributeId: 1.2.840.113556.1.4.1144
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: m5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=X25-Remote-MTA-Phone,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25RemoteMTAPhone
adminDisplayName: X25-Remote-MTA-Phone
adminDescription: X25-Remote-MTA-Phone
attributeId: 1.2.840.113556.1.2.373
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 55
schemaIdGuid:: oXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33119
hideFromAB: TRUE

dn: CN=MDB-Backoff-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MDBBackoffInterval
adminDisplayName: MDB-Backoff-Interval
adminDescription: MDB-Backoff-Interval
attributeId: 1.2.840.113556.1.2.72
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: H3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 32975
hideFromAB: TRUE

dn: CN=X400-Attachment-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X400AttachmentType
adminDisplayName: X400-Attachment-Type
adminDescription: X400-Attachment-Type
attributeId: 1.2.840.113556.1.2.99
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: onTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33120
hideFromAB: TRUE

dn: CN=Import-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ImportSensitivity
adminDisplayName: Import-Sensitivity
adminDescription: Import-Sensitivity
attributeId: 1.2.840.113556.1.2.383
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32955
hideFromAB: TRUE

dn: CN=msAscendAddSeconds,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAddSeconds
adminDisplayName: msAscendAddSeconds
adminDescription: msAscendAddSeconds
attributeId: 1.2.840.113556.1.4.978
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +I8M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=SMIME-Alg-Selected-NA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SMIMEAlgSelectedNA
adminDisplayName: SMIME-Alg-Selected-NA
adminDescription: SMIME-Alg-Selected-NA
attributeId: 1.2.840.113556.1.2.570
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: fHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35893
hideFromAB: TRUE

dn: CN=X400-Selector-Syntax,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X400SelectorSyntax
adminDisplayName: X400-Selector-Syntax
adminDescription: X400-Selector-Syntax
attributeId: 1.2.840.113556.1.2.443
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 1
schemaIdGuid:: o3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33121
hideFromAB: TRUE

dn: CN=Can-Not-Create-PF-DL-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CanNotCreatePFDLBL
adminDisplayName: Can-Not-Create-PF-DL-BL
adminDescription: Can-Not-Create-PF-DL-BL
attributeId: 1.2.840.113556.1.2.342
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: qHPfqOrF0RG7ywCAx2ZwwA==
linkID: 131
mapiID: 32863
hideFromAB: TRUE
systemFlags: 1

dn: CN=XMIT-Timeout-Normal,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: XMITTimeoutNormal
adminDisplayName: XMIT-Timeout-Normal
adminDescription: XMIT-Timeout-Normal
attributeId: 1.2.840.113556.1.2.67
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: pXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33124
hideFromAB: TRUE

dn: CN=Enabled-Protocol-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EnabledProtocolCfg
adminDisplayName: Enabled-Protocol-Cfg
adminDescription: Enabled-Protocol-Cfg
attributeId: 1.2.840.113556.1.2.515
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33192
hideFromAB: TRUE

dn: CN=msAscendDataFilter,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDataFilter
adminDisplayName: msAscendDataFilter
adminDescription: msAscendDataFilter
attributeId: 1.2.840.113556.1.4.1007
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendCallFilter,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallFilter
adminDisplayName: msAscendCallFilter
adminDescription: msAscendCallFilter
attributeId: 1.2.840.113556.1.4.996
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: CpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendDialNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDialNumber
adminDisplayName: msAscendDialNumber
adminDescription: msAscendDialNumber
attributeId: 1.2.840.113556.1.4.1015
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=XMIT-Timeout-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: XMITTimeoutUrgent
adminDisplayName: XMIT-Timeout-Urgent
adminDescription: XMIT-Timeout-Urgent
attributeId: 1.2.840.113556.1.2.53
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: pnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33125
hideFromAB: TRUE

dn: CN=msAscendRemoteAddr,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRemoteAddr
adminDisplayName: msAscendRemoteAddr
adminDescription: msAscendRemoteAddr
attributeId: 1.2.840.113556.1.4.1091
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: aZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendTSIdleMode,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendTSIdleMode
adminDisplayName: msAscendTSIdleMode
adminDescription: msAscendTSIdleMode
attributeId: 1.2.840.113556.1.4.1110
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DL-Mem-Reject-Perms-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DLMemRejectPermsBL
adminDisplayName: DL-Mem-Reject-Perms-BL
adminDescription: DL-Mem-Reject-Perms-BL
attributeId: 1.2.840.113556.1.2.293
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: w3PfqOrF0RG7ywCAx2ZwwA==
linkID: 117
mapiID: 32882
hideFromAB: TRUE
systemFlags: 1

dn: CN=msAscendDBAMonitor,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDBAMonitor
adminDisplayName: msAscendDBAMonitor
adminDescription: msAscendDBAMonitor
attributeId: 1.2.840.113556.1.4.1010
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: GJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Clock-Warning-Repair,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ClockWarningRepair
adminDisplayName: Clock-Warning-Repair
adminDescription: Clock-Warning-Repair
attributeId: 1.2.840.113556.1.2.166
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: s3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32868
hideFromAB: TRUE

dn: CN=msAscendPPPAddress,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPPPAddress
adminDisplayName: msAscendPPPAddress
adminDescription: msAscendPPPAddress
attributeId: 1.2.840.113556.1.4.1078
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: XJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendSendSecret,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSendSecret
adminDisplayName: msAscendSendSecret
adminDescription: msAscendSendSecret
attributeId: 1.2.840.113556.1.4.1103
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSEapKeyFlag,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSEapKeyFlag
adminDisplayName: msRADIUSEapKeyFlag
adminDescription: msRADIUSEapKeyFlag
attributeId: 1.2.840.113556.1.4.1211
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 4Y3dYZnF0RG7ywCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Clock-Warning-Offset,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ClockWarningOffset
adminDisplayName: Clock-Warning-Offset
adminDescription: Clock-Warning-Offset
attributeId: 1.2.840.113556.1.2.177
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: snPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32867
hideFromAB: TRUE

dn: CN=msAscendSendPasswd,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSendPasswd
adminDisplayName: msAscendSendPasswd
adminDescription: msAscendSendPasswd
attributeId: 1.2.840.113556.1.4.1102
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Exchange-Options,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAExchangeOptions
adminDisplayName: DXA-Exchange-Options
adminDescription: DXA-Exchange-Options
attributeId: 1.2.840.113556.1.2.359
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 3
schemaIdGuid:: 0HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32896
hideFromAB: TRUE

dn: CN=Control-Msg-Folder-ID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ControlMsgFolderID
adminDisplayName: Control-Msg-Folder-ID
adminDescription: Control-Msg-Folder-ID
attributeId: 1.2.840.113556.1.2.483
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1024
schemaIdGuid:: unPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33160
hideFromAB: TRUE

dn: CN=msAscendTargetUtil,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendTargetUtil
adminDisplayName: msAscendTargetUtil
adminDescription: msAscendTargetUtil
attributeId: 1.2.840.113556.1.4.1106
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Replication-Stagger,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReplicationStagger
adminDisplayName: Replication-Stagger
adminDescription: Replication-Stagger
attributeId: 1.2.840.113556.1.2.349
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: XXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33055
hideFromAB: TRUE

dn: CN=msRADIUSVendorName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSVendorName
adminDisplayName: msRADIUSVendorName
adminDescription: msRADIUSVendorName
attributeId: 1.2.840.113556.1.4.1182
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DL-Mem-Submit-Perms-BL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DLMemSubmitPermsBL
adminDisplayName: DL-Mem-Submit-Perms-BL
adminDescription: DL-Mem-Submit-Perms-BL
attributeId: 1.2.840.113556.1.2.291
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: xXPfqOrF0RG7ywCAx2ZwwA==
linkID: 113
mapiID: 32883
hideFromAB: TRUE
systemFlags: 1

dn: CN=Service-Action-First,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ServiceActionFirst
adminDisplayName: Service-Action-First
adminDescription: Service-Action-First
attributeId: 1.2.840.113556.1.2.161
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: cHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33073
hideFromAB: TRUE

dn: CN=msNPAllowedEapType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPAllowedEapType
adminDisplayName: msNPAllowedEapType
adminDescription: msNPAllowedEapType
attributeId: 1.2.840.113556.1.4.1120
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Service-Action-Other,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ServiceActionOther
adminDisplayName: Service-Action-Other
adminDescription: Service-Action-Other
attributeId: 1.2.840.113556.1.2.59
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: cXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33074
hideFromAB: TRUE

dn: CN=Telephone-Assistant,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TelephoneAssistant
adminDisplayName: Telephone-Assistant
adminDescription: Telephone-Assistant
attributeId: 1.2.840.113556.1.2.79
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: hHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 14894
hideFromAB: TRUE

dn: CN=Temp-Assoc-Threshold,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TempAssocThreshold
adminDisplayName: Temp-Assoc-Threshold
adminDescription: Temp-Assoc-Threshold
attributeId: 1.2.840.113556.1.2.329
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32767
schemaIdGuid:: iHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33092
hideFromAB: TRUE

dn: CN=DXA-Template-Options,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXATemplateOptions
adminDisplayName: DXA-Template-Options
adminDescription: DXA-Template-Options
attributeId: 1.2.840.113556.1.2.358
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 3
schemaIdGuid:: 63PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32926
hideFromAB: TRUE

dn: CN=Gateway-Routing-Tree,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: GatewayRoutingTree
adminDisplayName: Gateway-Routing-Tree
adminDescription: Gateway-Routing-Tree
attributeId: 1.2.840.113556.1.2.167
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: A3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 32947
hideFromAB: TRUE

dn: CN=X25-Leased-or-Switched,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25LeasedorSwitched
adminDisplayName: X25-Leased-or-Switched
adminDescription: X25-Leased-or-Switched
attributeId: 1.2.840.113556.1.2.372
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: oHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33118
hideFromAB: TRUE

dn: CN=Authorized-Password,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthorizedPassword
adminDisplayName: Authorized-Password
adminDescription: Authorized-Password
attributeId: 1.2.840.113556.1.2.193
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: m3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32853
hideFromAB: TRUE

dn: CN=Return-Exact-Msg-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReturnExactMsgSize
adminDisplayName: Return-Exact-Msg-Size
adminDescription: Return-Exact-Msg-Size
attributeId: 1.2.840.113556.1.2.594
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Y3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35922
hideFromAB: TRUE

dn: CN=Client-Access-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ClientAccessEnabled
adminDisplayName: Client-Access-Enabled
adminDescription: Client-Access-Enabled
attributeId: 1.2.840.113556.1.2.559
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: r3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 35876
hideFromAB: TRUE

dn: CN=Report-To-Originator,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReportToOriginator
adminDisplayName: Report-To-Originator
adminDescription: Report-To-Originator
attributeId: 1.2.840.113556.1.2.206
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: XnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33056
hideFromAB: TRUE

dn: CN=msRADIUSTunnelType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelType
adminDisplayName: msRADIUSTunnelType
adminDescription: msRADIUSTunnelType
attributeId: 1.2.840.113556.1.4.1181
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=RTS-Recovery-Timeout,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RTSRecoveryTimeout
adminDisplayName: RTS-Recovery-Timeout
adminDescription: RTS-Recovery-Timeout
attributeId: 1.2.840.113556.1.2.151
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: aXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33064
hideFromAB: TRUE

dn: CN=Allowed-Child-Classes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: allowedChildClasses
adminDisplayName: Allowed-Child-Classes
adminDescription: Allowed-Child-Classes
attributeId: 1.2.840.113556.1.4.911
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Qtl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=msAscendFRNailedGrp,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRNailedGrp
adminDisplayName: msAscendFRNailedGrp
adminDescription: msAscendFRNailedGrp
attributeId: 1.2.840.113556.1.4.1036
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendAuthenAlias,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAuthenAlias
adminDisplayName: msAscendAuthenAlias
adminDescription: msAscendAuthenAlias
attributeId: 1.2.840.113556.1.4.984
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /o8M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIPXNodeAddr,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIPXNodeAddr
adminDisplayName: msAscendIPXNodeAddr
adminDescription: msAscendIPXNodeAddr
attributeId: 1.2.840.113556.1.4.1056
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Enable-Compatibility,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EnableCompatibility
adminDisplayName: Enable-Compatibility
adminDescription: Enable-Compatibility
attributeId: 1.2.840.113556.1.2.567
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 8XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35890
hideFromAB: TRUE


dn: CN=Association-Lifetime,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AssociationLifetime
adminDisplayName: Association-Lifetime
adminDescription: Association-Lifetime
attributeId: 1.2.840.113556.1.2.149
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: lnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32850
hideFromAB: TRUE

dn: CN=Off-Line-AB-Containers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OffLineABContainers
adminDisplayName: Off-Line-AB-Containers
adminDescription: Off-Line-AB-Containers
attributeId: 1.2.840.113556.1.2.391
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: PHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33016
hideFromAB: TRUE

dn: CN=Cross-Certificate-CRL,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CrossCertificateCRL
adminDisplayName: Cross-Certificate-CRL
adminDescription: Cross-Certificate-CRL
attributeId: 1.2.840.113556.1.2.565
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35888
hideFromAB: TRUE

dn: CN=msAscendIPXPeerMode,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIPXPeerMode
adminDisplayName: msAscendIPXPeerMode
adminDescription: msAscendIPXPeerMode
attributeId: 1.2.840.113556.1.4.1057
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: R5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendTSIdleLimit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendTSIdleLimit
adminDisplayName: msAscendTSIdleLimit
adminDescription: msAscendTSIdleLimit
attributeId: 1.2.840.113556.1.4.1109
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: e5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendMultilinkID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMultilinkID
adminDisplayName: msAscendMultilinkID
adminDescription: msAscendMultilinkID
attributeId: 1.2.840.113556.1.4.1074
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: WJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendUserAcctKey,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendUserAcctKey
adminDisplayName: msAscendUserAcctKey
adminDescription: msAscendUserAcctKey
attributeId: 1.2.840.113556.1.4.1114
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPCalledStationID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPCalledStationID
adminDisplayName: msNPCalledStationID
adminDescription: msNPCalledStationID
attributeId: 1.2.840.113556.1.4.1123
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: iZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Encapsulation-Method,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EncapsulationMethod
adminDisplayName: Encapsulation-Method
adminDescription: Encapsulation-Method
attributeId: 1.2.840.113556.1.2.448
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32930
hideFromAB: TRUE

dn: CN=msAscendPPPAsyncMap,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPPPAsyncMap
adminDisplayName: msAscendPPPAsyncMap
adminDescription: msAscendPPPAsyncMap
attributeId: 1.2.840.113556.1.4.1079
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: XZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendMaximumTime,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMaximumTime
adminDisplayName: msAscendMaximumTime
adminDescription: msAscendMaximumTime
attributeId: 1.2.840.113556.1.4.1062
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: TJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRequireAuth,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRequireAuth
adminDisplayName: msAscendRequireAuth
adminDescription: msAscendRequireAuth
attributeId: 1.2.840.113556.1.4.1094
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendModemSlotNo,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendModemSlotNo
adminDisplayName: msAscendModemSlotNo
adminDescription: msAscendModemSlotNo
attributeId: 1.2.840.113556.1.4.1069
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: U5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Responsible-Local-DXA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ResponsibleLocalDXA
adminDisplayName: Responsible-Local-DXA
adminDescription: Responsible-Local-DXA
attributeId: 1.2.840.113556.1.2.298
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: YnTfqOrF0RG7ywCAx2ZwwA==
linkID: 122
mapiID: 33059
hideFromAB: TRUE

dn: CN=Inbound-Newsfeed-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: InboundNewsfeedType
adminDisplayName: Inbound-Newsfeed-Type
adminDescription: Inbound-Newsfeed-Type
attributeId: 1.2.840.113556.1.2.554
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: E3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35871
hideFromAB: TRUE

dn: CN=msAscendModemPortNo,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendModemPortNo
adminDisplayName: msAscendModemPortNo
adminDescription: msAscendModemPortNo
attributeId: 1.2.840.113556.1.4.1067
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MDB-Msg-Time-Out-Period,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MDBMsgTimeOutPeriod
adminDisplayName: MDB-Msg-Time-Out-Period
adminDescription: MDB-Msg-Time-Out-Period
attributeId: 1.2.840.113556.1.2.64
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32976
hideFromAB: TRUE

dn: CN=msRADIUSFramedRoute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedRoute
adminDisplayName: msRADIUSFramedRoute
adminDescription: msRADIUSFramedRoute
attributeId: 1.2.840.113556.1.4.1158
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Presentation-Address,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: presentationAddress
adminDisplayName: Presentation-Address
adminDescription: Presentation-Address
attributeId: 2.5.4.29
attributeSyntax: 2.5.5.13
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVc
schemaIdGuid:: S3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendThirdPrompt,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendThirdPrompt
adminDisplayName: msAscendThirdPrompt
adminDescription: msAscendThirdPrompt
attributeId: 1.2.840.113556.1.4.1107
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSIdleTimeout,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSIdleTimeout
adminDisplayName: msRADIUSIdleTimeout
adminDescription: msRADIUSIdleTimeout
attributeId: 1.2.840.113556.1.4.1160
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: q5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Authentication-To-Use,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthenticationToUse
adminDisplayName: Authentication-To-Use
adminDescription: Authentication-To-Use
attributeId: 1.2.840.113556.1.2.501
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: mXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33178
hideFromAB: TRUE


dn: CN=Encrypt-Alg-List-Other,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EncryptAlgListOther
adminDisplayName: Encrypt-Alg-List-Other
adminDescription: Encrypt-Alg-List-Other
attributeId: 1.2.840.113556.1.2.399
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: +HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32833
hideFromAB: TRUE

dn: CN=HTTP-Pub-AB-Attributes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: HTTPPubABAttributes
adminDisplayName: HTTP-Pub-AB-Attributes
adminDescription: HTTP-Pub-AB-Attributes
attributeId: 1.2.840.113556.1.2.516
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: CHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33193
hideFromAB: TRUE

dn: CN=msRADIUSLoginIPHost,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginIPHost
adminDisplayName: msRADIUSLoginIPHost
adminDescription: msRADIUSLoginIPHost
attributeId: 1.2.840.113556.1.4.1161
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSServiceType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSServiceType
adminDisplayName: msRADIUSServiceType
adminDescription: msRADIUSServiceType
attributeId: 1.2.840.113556.1.4.1171
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: tpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPSessionsAllowed,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPSessionsAllowed
adminDisplayName: msNPSessionsAllowed
adminDescription: msNPSessionsAllowed
attributeId: 1.2.840.113556.1.4.1132
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: kJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Service-Action-Second,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ServiceActionSecond
adminDisplayName: Service-Action-Second
adminDescription: Service-Action-Second
attributeId: 1.2.840.113556.1.2.60
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: cnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33075
hideFromAB: TRUE

dn: CN=Service-Restart-Delay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ServiceRestartDelay
adminDisplayName: Service-Restart-Delay
adminDescription: Service-Restart-Delay
attributeId: 1.2.840.113556.1.2.162
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: c3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33076
hideFromAB: TRUE

dn: CN=msAscendFRDirectDLCI,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDirectDLCI
adminDisplayName: msAscendFRDirectDLCI
adminDescription: msAscendFRDirectDLCI
attributeId: 1.2.840.113556.1.4.1028
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendUserAcctBase,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendUserAcctBase
adminDisplayName: msAscendUserAcctBase
adminDescription: msAscendUserAcctBase
attributeId: 1.2.840.113556.1.4.1112
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFCPParameter,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFCPParameter
adminDisplayName: msAscendFCPParameter
adminDescription: msAscendFCPParameter
attributeId: 1.2.840.113556.1.4.1021
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: I5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Filter-Local-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: FilterLocalAddresses
adminDisplayName: Filter-Local-Addresses
adminDescription: Filter-Local-Addresses
attributeId: 1.2.840.113556.1.2.44
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32941
hideFromAB: TRUE

dn: CN=msAscendModemShelfNo,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendModemShelfNo
adminDisplayName: msAscendModemShelfNo
adminDescription: msAscendModemShelfNo
attributeId: 1.2.840.113556.1.4.1068
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Encrypt-Alg-Selected-NA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EncryptAlgSelectedNA
adminDisplayName: Encrypt-Alg-Selected-NA
adminDescription: Encrypt-Alg-Selected-NA
attributeId: 1.2.840.113556.1.2.401
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: +XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32835
hideFromAB: TRUE

dn: CN=Default-Message-Format,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DefaultMessageFormat
adminDisplayName: Default-Message-Format
adminDescription: Default-Message-Format
attributeId: 1.2.840.113556.1.2.572
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vXPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35895
hideFromAB: TRUE

dn: CN=msAscendEndpointDisc,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendEndpointDisc
adminDisplayName: msAscendEndpointDisc
adminDescription: msAscendEndpointDisc
attributeId: 1.2.840.113556.1.4.1018
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendUserAcctTime,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendUserAcctTime
adminDisplayName: msAscendUserAcctTime
adminDescription: msAscendUserAcctTime
attributeId: 1.2.840.113556.1.4.1116
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Conf-Container-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAConfContainerList
adminDisplayName: DXA-Conf-Container-List
adminDescription: DXA-Conf-Container-List
attributeId: 1.2.840.113556.1.2.180
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: zHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32892
hideFromAB: TRUE

dn: CN=msAscendMenuSelector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMenuSelector
adminDisplayName: msAscendMenuSelector
adminDescription: msAscendMenuSelector
attributeId: 1.2.840.113556.1.4.1064
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: TpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Sign-Certificates,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQSignCertificates
adminDisplayName: MSMQ-Sign-Certificates
adminDescription: MSMQ-Sign-Certificates
attributeId: 1.2.840.113556.1.4.947
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: O8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=msAscendAssignIPPool,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAssignIPPool
adminDisplayName: msAscendAssignIPPool
adminDescription: msAscendAssignIPPool
attributeId: 1.2.840.113556.1.4.982
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /I8M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendUserAcctHost,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendUserAcctHost
adminDisplayName: msAscendUserAcctHost
adminDescription: msAscendUserAcctHost
attributeId: 1.2.840.113556.1.4.1113
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: f5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendPreemptLimit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPreemptLimit
adminDisplayName: msAscendPreemptLimit
adminDescription: msAscendPreemptLimit
attributeId: 1.2.840.113556.1.4.1082
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendUserAcctType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendUserAcctType
adminDisplayName: msAscendUserAcctType
adminDescription: msAscendUserAcctType
attributeId: 1.2.840.113556.1.4.1117
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: g5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Disabled-Gateway-Proxy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DisabledGatewayProxy
adminDisplayName: Disabled-Gateway-Proxy
adminDescription: Disabled-Gateway-Proxy
attributeId: 1.2.840.113556.1.2.541
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 1024
schemaIdGuid:: wHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33219
hideFromAB: TRUE

dn: CN=DXA-Native-Address-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXANativeAddressType
adminDisplayName: DXA-Native-Address-Type
adminDescription: DXA-Native-Address-Type
attributeId: 1.2.840.113556.1.2.331
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: 2XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32906
hideFromAB: TRUE

dn: CN=DXA-Template-TimeStamp,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXATemplateTimeStamp
adminDisplayName: DXA-Template-TimeStamp
adminDescription: DXA-Template-TimeStamp
attributeId: 1.2.840.113556.1.2.365
attributeSyntax: 2.5.5.11
omSyntax: 23
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 7HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32927
hideFromAB: TRUE

dn: CN=Monitoring-Alert-Delay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringAlertDelay
adminDisplayName: Monitoring-Alert-Delay
adminDescription: Monitoring-Alert-Delay
attributeId: 1.2.840.113556.1.2.158
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: J3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 32988
hideFromAB: TRUE

dn: CN=msAscendUserAcctPort,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendUserAcctPort
adminDisplayName: msAscendUserAcctPort
adminDescription: msAscendUserAcctPort
attributeId: 1.2.840.113556.1.4.1115
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Connection-List-Filter,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ConnectionListFilter
adminDisplayName: Connection-List-Filter
adminDescription: Connection-List-Filter
attributeId: 1.2.840.113556.1.2.475
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 10240
schemaIdGuid:: tnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33152
hideFromAB: TRUE

dn: CN=msNPCallingStationID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPCallingStationID
adminDisplayName: msNPCallingStationID
adminDescription: msNPCallingStationID
attributeId: 1.2.840.113556.1.4.1124
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ipAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSArapFeatures,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSArapFeatures
adminDisplayName: msRADIUSArapFeatures
adminDescription: msRADIUSArapFeatures
attributeId: 1.2.840.113556.1.4.1138
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSLoginLATNode,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginLATNode
adminDisplayName: msRADIUSLoginLATNode
adminDescription: msRADIUSLoginLATNode
attributeId: 1.2.840.113556.1.4.1163
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSLoginService,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginService
adminDisplayName: msRADIUSLoginService
adminDescription: msRADIUSLoginService
attributeId: 1.2.840.113556.1.4.1166
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: sZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Assoc-Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AssocProtocolCfgNNTP
adminDisplayName: Assoc-Protocol-Cfg-NNTP
adminDescription: Assoc-Protocol-Cfg-NNTP
attributeId: 1.2.840.113556.1.2.512
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: lXPfqOrF0RG7ywCAx2ZwwA==
linkID: 140
mapiID: 33189
hideFromAB: TRUE

dn: CN=Monitoring-Recipients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringRecipients
adminDisplayName: Monitoring-Recipients
adminDescription: Monitoring-Recipients
attributeId: 1.2.840.113556.1.2.159
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: LnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33001
hideFromAB: TRUE

dn: CN=DXA-Prev-Remote-Entries,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPrevRemoteEntries
adminDisplayName: DXA-Prev-Remote-Entries
adminDescription: DXA-Prev-Remote-Entries
attributeId: 1.2.840.113556.1.2.265
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 33PfqOrF0RG7ywCAx2ZwwA==
mapiID: 32912
hideFromAB: TRUE

dn: CN=msRADIUSArapSecurity,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSArapSecurity
adminDisplayName: msRADIUSArapSecurity
adminDescription: msRADIUSArapSecurity
attributeId: 1.2.840.113556.1.4.1139
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Text-Encoded-OR-Address,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: textEncodedORAddress
adminDisplayName: Text-Encoded-OR-Address
adminDescription: Text-Encoded-OR-Address
attributeId: 0.9.2342.19200300.100.1.2
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1024
schemaIdGuid:: iXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35949
hideFromAB: TRUE

dn: CN=msRADIUSLoginLATPort,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginLATPort
adminDisplayName: msRADIUSLoginLATPort
adminDescription: msRADIUSLoginLATPort
attributeId: 1.2.840.113556.1.4.1164
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: r5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Num-Of-Transfer-Retries,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NumOfTransferRetries
adminDisplayName: Num-Of-Transfer-Retries
adminDescription: Num-Of-Transfer-Retries
attributeId: 1.2.840.113556.1.2.134
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: O3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33013
hideFromAB: TRUE

dn: CN=ACS-Non-Reserved-Tx-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aCSNonReservedTxSize
adminDisplayName: ACS-Non-Reserved-Tx-Size
adminDescription: ACS-Non-Reserved-Tx-Size
attributeId: 1.2.840.113556.1.4.898
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DSNy8PWu0RG9zwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=msAscendCallbackDelay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallbackDelay
adminDisplayName: msAscendCallbackDelay
adminDescription: msAscendCallbackDelay
attributeId: 1.2.840.113556.1.4.993
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: B5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Translation-Table-Used,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TranslationTableUsed
adminDisplayName: Translation-Table-Used
adminDescription: Translation-Table-Used
attributeId: 1.2.840.113556.1.2.396
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: kHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33101
hideFromAB: TRUE

dn: CN=msRADIUSLoginTCPPort,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginTCPPort
adminDisplayName: msRADIUSLoginTCPPort
adminDescription: msRADIUSLoginTCPPort
attributeId: 1.2.840.113556.1.4.1167
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: spAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Outgoing-Msg-Size-Limit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OutgoingMsgSizeLimit
adminDisplayName: Outgoing-Msg-Size-Limit
adminDescription: Outgoing-Msg-Size-Limit
attributeId: 1.2.840.113556.1.2.490
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33167
hideFromAB: TRUE

dn: CN=Monitoring-Alert-Units,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringAlertUnits
adminDisplayName: Monitoring-Alert-Units
adminDescription: Monitoring-Alert-Units
attributeId: 1.2.840.113556.1.2.57
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: KHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32989
hideFromAB: TRUE

dn: CN=OOF-Reply-To-Originator,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: OOFReplyToOriginator
adminDisplayName: OOF-Reply-To-Originator
adminDescription: OOF-Reply-To-Originator
attributeId: 1.2.840.113556.1.2.438
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33023
hideFromAB: TRUE

dn: CN=Disable-Deferred-Commit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DisableDeferredCommit
adminDisplayName: Disable-Deferred-Commit
adminDescription: Disable-Deferred-Commit
attributeId: 1.2.840.113556.1.2.558
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: v3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 35875
hideFromAB: TRUE

dn: CN=msNPAllowedPortTypes,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPAllowedPortTypes
adminDisplayName: msNPAllowedPortTypes
adminDescription: msNPAllowedPortTypes
attributeId: 1.2.840.113556.1.4.1121
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: h5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendBridgeAddress,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendBridgeAddress
adminDisplayName: msAscendBridgeAddress
adminDescription: msAscendBridgeAddress
attributeId: 1.2.840.113556.1.4.990
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Turn-Request-Threshold,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TurnRequestThreshold
adminDisplayName: Turn-Request-Threshold
adminDescription: Turn-Request-Threshold
attributeId: 1.2.840.113556.1.2.38
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: k3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33104
hideFromAB: TRUE

dn: CN=MSMQ-In-Routing-Servers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQInRoutingServers
adminDisplayName: MSMQ-In-Routing-Servers
adminDescription: MSMQ-In-Routing-Servers
attributeId: 1.2.840.113556.1.4.929
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=XMIT-Timeout-Non-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: XMITTimeoutNonUrgent
adminDisplayName: XMIT-Timeout-Non-Urgent
adminDescription: XMIT-Timeout-Non-Urgent
attributeId: 1.2.840.113556.1.2.84
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: pHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33123
hideFromAB: TRUE

dn: CN=msAscendBillingNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendBillingNumber
adminDisplayName: msAscendBillingNumber
adminDescription: msAscendBillingNumber
attributeId: 1.2.840.113556.1.4.988
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ApAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRProfileName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRProfileName
adminDisplayName: msAscendFRProfileName
adminDescription: msAscendFRProfileName
attributeId: 1.2.840.113556.1.4.1037
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: M5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRCircuitName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRCircuitName
adminDisplayName: msAscendFRCircuitName
adminDescription: msAscendFRCircuitName
attributeId: 1.2.840.113556.1.4.1024
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: JpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendReceiveSecret,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendReceiveSecret
adminDisplayName: msAscendReceiveSecret
adminDescription: msAscendReceiveSecret
attributeId: 1.2.840.113556.1.4.1090
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: aJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=SMIME-Alg-Selected-Other,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SMIMEAlgSelectedOther
adminDisplayName: SMIME-Alg-Selected-Other
adminDescription: SMIME-Alg-Selected-Other
attributeId: 1.2.840.113556.1.2.571
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: fXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35894
hideFromAB: TRUE

dn: CN=msAscendClientGateway,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendClientGateway
adminDisplayName: msAscendClientGateway
adminDescription: msAscendClientGateway
attributeId: 1.2.840.113556.1.4.1003
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: EZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRemoveSeconds,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRemoveSeconds
adminDisplayName: msAscendRemoveSeconds
adminDescription: msAscendRemoveSeconds
attributeId: 1.2.840.113556.1.4.1093
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: a5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Extended-Attribute-Info,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: extendedAttributeInfo
adminDisplayName: Extended-Attribute-Info
adminDescription: Extended-Attribute-Info
attributeId: 1.2.840.113556.1.4.909
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: R9l6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=msRASSavedFramedRoute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRASSavedFramedRoute
adminDisplayName: msRASSavedFramedRoute
adminDescription: msRASSavedFramedRoute
attributeId: 1.2.840.113556.1.4.1191
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: x5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPRADIUSProfileName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPRADIUSProfileName
adminDisplayName: msNPRADIUSProfileName
adminDescription: msNPRADIUSProfileName
attributeId: 1.2.840.113556.1.4.1129
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: jZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Service-Restart-Message,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ServiceRestartMessage
adminDisplayName: Service-Restart-Message
adminDescription: Service-Restart-Message
attributeId: 1.2.840.113556.1.2.58
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 120
schemaIdGuid:: dHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33077
hideFromAB: TRUE

dn: CN=msAscendTransitNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendTransitNumber
adminDisplayName: msAscendTransitNumber
adminDescription: msAscendTransitNumber
attributeId: 1.2.840.113556.1.4.1108
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: epAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSFramedRouting,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedRouting
adminDisplayName: msRADIUSFramedRouting
adminDescription: msRADIUSFramedRouting
attributeId: 1.2.840.113556.1.4.1159
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=RAS-Phonebook-Entry-Name,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RASPhonebookEntryName
adminDisplayName: RAS-Phonebook-Entry-Name
adminDescription: RAS-Phonebook-Entry-Name
attributeId: 1.2.840.113556.1.2.313
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 256
schemaIdGuid:: VXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33047
hideFromAB: TRUE

dn: CN=msAscendPRINumberType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPRINumberType
adminDisplayName: msAscendPRINumberType
adminDescription: msAscendPRINumberType
attributeId: 1.2.840.113556.1.4.1089
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Z5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=NNTP-Distributions-Flag,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: NNTPDistributionsFlag
adminDisplayName: NNTP-Distributions-Flag
adminDescription: NNTP-Distributions-Flag
attributeId: 1.2.840.113556.1.2.511
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33188
hideFromAB: TRUE

dn: CN=msAscendPPPVJSlotComp,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPPPVJSlotComp
adminDisplayName: msAscendPPPVJSlotComp
adminDescription: msAscendPPPVJSlotComp
attributeId: 1.2.840.113556.1.4.1081
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: X5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Local-Bridge-Head-Address,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: LocalBridgeHeadAddress
adminDisplayName: Local-Bridge-Head-Address
adminDescription: Local-Bridge-Head-Address
attributeId: 1.2.840.113556.1.2.225
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 1118
schemaIdGuid:: G3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 32967
hideFromAB: TRUE

dn: CN=msRADIUSLoginLATGroup,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginLATGroup
adminDisplayName: msRADIUSLoginLATGroup
adminDescription: msRADIUSLoginLATGroup
attributeId: 1.2.840.113556.1.4.1162
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendSessionSvrKey,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSessionSvrKey
adminDisplayName: msAscendSessionSvrKey
adminDescription: msAscendSessionSvrKey
attributeId: 1.2.840.113556.1.4.1104
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Transfer-Timeout-Normal,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransferTimeoutNormal
adminDisplayName: Transfer-Timeout-Normal
adminDescription: Transfer-Timeout-Normal
attributeId: 1.2.840.113556.1.2.137
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: jnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33099
hideFromAB: TRUE

dn: CN=msRADIUSAttributeType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSAttributeType
adminDisplayName: msRADIUSAttributeType
adminDescription: msRADIUSAttributeType
attributeId: 1.2.840.113556.1.4.1142
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Transfer-Retry-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransferRetryInterval
adminDisplayName: Transfer-Retry-Interval
adminDescription: Transfer-Retry-Interval
attributeId: 1.2.840.113556.1.2.133
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: jHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33097
hideFromAB: TRUE

dn: CN=Transfer-Timeout-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransferTimeoutUrgent
adminDisplayName: Transfer-Timeout-Urgent
adminDescription: Transfer-Timeout-Urgent
attributeId: 1.2.840.113556.1.2.142
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: j3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33100
hideFromAB: TRUE

dn: CN=Message-Tracking-Enabled,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MessageTrackingEnabled
adminDisplayName: Message-Tracking-Enabled
adminDescription: Message-Tracking-Enabled
attributeId: 1.2.840.113556.1.2.453
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: InTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32981
hideFromAB: TRUE

dn: CN=msAscendExpectCallback,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendExpectCallback
adminDisplayName: msAscendExpectCallback
adminDescription: msAscendExpectCallback
attributeId: 1.2.840.113556.1.4.1020
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: IpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSPasswordRetry,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSPasswordRetry
adminDisplayName: msRADIUSPasswordRetry
adminDescription: msRADIUSPasswordRetry
attributeId: 1.2.840.113556.1.4.1168
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: s5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSCallbackNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSCallbackNumber
adminDisplayName: msRADIUSCallbackNumber
adminDescription: msRADIUSCallbackNumber
attributeId: 1.2.840.113556.1.4.1145
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: nJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendDialoutAllowed,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDialoutAllowed
adminDisplayName: msAscendDialoutAllowed
adminDescription: msAscendDialoutAllowed
attributeId: 1.2.840.113556.1.4.1016
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=MSMQ-Out-Routing-Servers,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMQOutRoutingServers
adminDisplayName: MSMQ-Out-Routing-Servers
adminDescription: MSMQ-Out-Routing-Servers
attributeId: 1.2.840.113556.1.4.928
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: K8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=msAscendMPPIdlePercent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMPPIdlePercent
adminDisplayName: msAscendMPPIdlePercent
adminDescription: msAscendMPPIdlePercent
attributeId: 1.2.840.113556.1.4.1070
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: VJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendAssignIPClient,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAssignIPClient
adminDisplayName: msAscendAssignIPClient
adminDescription: msAscendAssignIPClient
attributeId: 1.2.840.113556.1.4.981
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +48M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=X25-Call-User-Data-Incoming,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25CallUserDataIncoming
adminDisplayName: X25-Call-User-Data-Incoming
adminDescription: X25-Call-User-Data-Incoming
attributeId: 1.2.840.113556.1.2.316
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: m3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33113
hideFromAB: TRUE

dn: CN=ACS-Max-No-Of-Account-Files,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aCSMaxNoOfAccountFiles
adminDisplayName: ACS-Max-No-Of-Account-Files
adminDescription: ACS-Max-No-Of-Account-Files
attributeId: 1.2.840.113556.1.4.901
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ECNy8PWu0RG9zwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=msAscendDHCPPoolNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDHCPPoolNumber
adminDisplayName: msAscendDHCPPoolNumber
adminDescription: msAscendDHCPPoolNumber
attributeId: 1.2.840.113556.1.4.1013
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: G5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Available-Distributions,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AvailableDistributions
adminDisplayName: Available-Distributions
adminDescription: Available-Distributions
attributeId: 1.2.840.113556.1.2.486
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 10240
schemaIdGuid:: n3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 33163
hideFromAB: TRUE

dn: CN=msAscendAppletalkRoute,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAppletalkRoute
adminDisplayName: msAscendAppletalkRoute
adminDescription: msAscendAppletalkRoute
attributeId: 1.2.840.113556.1.4.980
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +o8M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRouteAppletalk,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRouteAppletalk
adminDisplayName: msAscendRouteAppletalk
adminDescription: msAscendRouteAppletalk
attributeId: 1.2.840.113556.1.4.1095
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSArapZoneAccess,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSArapZoneAccess
adminDisplayName: msRADIUSArapZoneAccess
adminDescription: msRADIUSArapZoneAccess
attributeId: 1.2.840.113556.1.4.1140
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: l5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendAssignIPServer,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAssignIPServer
adminDisplayName: msAscendAssignIPServer
adminDescription: msAscendAssignIPServer
attributeId: 1.2.840.113556.1.4.983
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /Y8M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-UnConf-Container-List,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAUnConfContainerList
adminDisplayName: DXA-UnConf-Container-List
adminDescription: DXA-UnConf-Container-List
attributeId: 1.2.840.113556.1.2.181
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 7nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32929
hideFromAB: TRUE

dn: CN=Replication-Mail-Msg-Size,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ReplicationMailMsgSize
adminDisplayName: Replication-Mail-Msg-Size
adminDescription: Replication-Mail-Msg-Size
attributeId: 1.2.840.113556.1.2.103
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: XHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33128
hideFromAB: TRUE

dn: CN=msAscendCBCPTrunkGroup,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCBCPTrunkGroup
adminDisplayName: msAscendCBCPTrunkGroup
adminDescription: msAscendCBCPTrunkGroup
attributeId: 1.2.840.113556.1.4.1001
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: D5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendPreSessionTime,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPreSessionTime
adminDisplayName: msAscendPreSessionTime
adminDescription: msAscendPreSessionTime
attributeId: 1.2.840.113556.1.4.1087
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ZZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Prev-Exchange-Options,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPrevExchangeOptions
adminDisplayName: DXA-Prev-Exchange-Options
adminDescription: DXA-Prev-Exchange-Options
attributeId: 1.2.840.113556.1.2.216
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 3
schemaIdGuid:: 3HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32909
hideFromAB: TRUE

dn: CN=Monitoring-Warning-Delay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringWarningDelay
adminDisplayName: Monitoring-Warning-Delay
adminDescription: Monitoring-Warning-Delay
attributeId: 1.2.840.113556.1.2.157
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33005
hideFromAB: TRUE

dn: CN=msAscendNetwaretimeout,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendNetwaretimeout
adminDisplayName: msAscendNetwaretimeout
adminDescription: msAscendNetwaretimeout
attributeId: 1.2.840.113556.1.4.1075
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: WZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSFramedProtocol,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedProtocol
adminDisplayName: msRADIUSFramedProtocol
adminDescription: msRADIUSFramedProtocol
attributeId: 1.2.840.113556.1.4.1157
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendNumberSessions,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendNumberSessions
adminDisplayName: msAscendNumberSessions
adminDescription: msAscendNumberSessions
attributeId: 1.2.840.113556.1.4.1076
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: WpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendNumInMultilink,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendNumInMultilink
adminDisplayName: msAscendNumInMultilink
adminDescription: msAscendNumInMultilink
attributeId: 1.2.840.113556.1.4.1077
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: W5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Session-Disconnect-Timer,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SessionDisconnectTimer
adminDisplayName: Session-Disconnect-Timer
adminDescription: Session-Disconnect-Timer
attributeId: 1.2.840.113556.1.2.154
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: dXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33078
hideFromAB: TRUE

dn: CN=Transport-Expedited-Data,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransportExpeditedData
adminDisplayName: Transport-Expedited-Data
adminDescription: Transport-Expedited-Data
attributeId: 1.2.840.113556.1.2.150
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: kXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33102
hideFromAB: TRUE

dn: CN=X25-Call-User-Data-Outgoing,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25CallUserDataOutgoing
adminDisplayName: X25-Call-User-Data-Outgoing
adminDescription: X25-Call-User-Data-Outgoing
attributeId: 1.2.840.113556.1.2.317
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: nHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33114
hideFromAB: TRUE

dn: CN=msAscendPreInputOctets,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPreInputOctets
adminDisplayName: msAscendPreInputOctets
adminDescription: msAscendPreInputOctets
attributeId: 1.2.840.113556.1.4.1083
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPAuthenticationType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPAuthenticationType
adminDisplayName: msNPAuthenticationType
adminDescription: msNPAuthenticationType
attributeId: 1.2.840.113556.1.4.1122
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: iJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Prev-Template-Options,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPrevTemplateOptions
adminDisplayName: DXA-Prev-Template-Options
adminDescription: DXA-Prev-Template-Options
attributeId: 1.2.840.113556.1.2.395
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 3
schemaIdGuid:: 4XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32914
hideFromAB: TRUE

dn: CN=Quota-Notification-Style,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: QuotaNotificationStyle
adminDisplayName: Quota-Notification-Style
adminDescription: Quota-Notification-Style
attributeId: 1.2.840.113556.1.2.388
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: UHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33042
hideFromAB: TRUE

dn: CN=Root-Newsgroups-Folder-ID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RootNewsgroupsFolderID
adminDisplayName: Root-Newsgroups-Folder-ID
adminDescription: Root-Newsgroups-Folder-ID
attributeId: 1.2.840.113556.1.2.524
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1024
schemaIdGuid:: ZnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33202
hideFromAB: TRUE

dn: CN=MS-MPPE-Encryption-Policy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: mSMPPEEncryptionPolicy
adminDisplayName: MS-MPPE-Encryption-Policy
adminDescription: MS-MPPE-Encryption-Policy
attributeId: 1.2.840.113556.1.4.977
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 948M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Monitoring-Warning-Units,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringWarningUnits
adminDisplayName: Monitoring-Warning-Units
adminDescription: Monitoring-Warning-Units
attributeId: 1.2.840.113556.1.2.56
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: MXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33006
hideFromAB: TRUE

dn: CN=msRADIUSTunnelPassword,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelPassword
adminDisplayName: msRADIUSTunnelPassword
adminDescription: msRADIUSTunnelPassword
attributeId: 1.2.840.113556.1.4.1177
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Remote-Bridge-Head-Address,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: RemoteBridgeHeadAddress
adminDisplayName: Remote-Bridge-Head-Address
adminDescription: Remote-Bridge-Head-Address
attributeId: 1.2.840.113556.1.2.94
attributeSyntax: 2.5.5.4
omSyntax: 20
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 1118
schemaIdGuid:: WXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33051
hideFromAB: TRUE

dn: CN=Export-Custom-Recipients,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ExportCustomRecipients
adminDisplayName: Export-Custom-Recipients
adminDescription: Export-Custom-Recipients
attributeId: 1.2.840.113556.1.2.307
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32934
hideFromAB: TRUE

dn: CN=msRADIUSSessionTimeout,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSSessionTimeout
adminDisplayName: msRADIUSSessionTimeout
adminDescription: msRADIUSSessionTimeout
attributeId: 1.2.840.113556.1.4.1172
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: t5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendHomeAgentIPAddr,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHomeAgentIPAddr
adminDisplayName: msAscendHomeAgentIPAddr
adminDescription: msAscendHomeAgentIPAddr
attributeId: 1.2.840.113556.1.4.1045
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: O5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendDecChannelCount,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDecChannelCount
adminDisplayName: msAscendDecChannelCount
adminDescription: msAscendDecChannelCount
attributeId: 1.2.840.113556.1.4.1011
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: GZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Support-SMIME-Signatures,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: SupportSMIMESignatures
adminDisplayName: Support-SMIME-Signatures
adminDescription: Support-SMIME-Signatures
attributeId: 1.2.840.113556.1.2.590
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: f3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 35912
hideFromAB: TRUE

dn: CN=msAscendDisconnectCause,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDisconnectCause
adminDisplayName: msAscendDisconnectCause
adminDescription: msAscendDisconnectCause
attributeId: 1.2.840.113556.1.4.1017
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: H5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIncChannelCount,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIncChannelCount
adminDisplayName: msAscendIncChannelCount
adminDescription: msAscendIncChannelCount
attributeId: 1.2.840.113556.1.4.1052
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendFRDirectProfile,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendFRDirectProfile
adminDisplayName: msAscendFRDirectProfile
adminDescription: msAscendFRDirectProfile
attributeId: 1.2.840.113556.1.4.1029
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: K5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=ACS-Enable-RSVP-Accounting,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aCSEnableRSVPAccounting
adminDisplayName: ACS-Enable-RSVP-Accounting
adminDescription: ACS-Enable-RSVP-Accounting
attributeId: 1.2.840.113556.1.4.899
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DiNy8PWu0RG9zwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=msAscendMinimumChannels,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMinimumChannels
adminDisplayName: msAscendMinimumChannels
adminDescription: msAscendMinimumChannels
attributeId: 1.2.840.113556.1.4.1066
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendClientAssignDNS,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendClientAssignDNS
adminDisplayName: msAscendClientAssignDNS
adminDescription: msAscendClientAssignDNS
attributeId: 1.2.840.113556.1.4.1002
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: EJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendMaximumChannels,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMaximumChannels
adminDisplayName: msAscendMaximumChannels
adminDescription: msAscendMaximumChannels
attributeId: 1.2.840.113556.1.4.1061
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: S5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSFramedIPAddress,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedIPAddress
adminDisplayName: msRADIUSFramedIPAddress
adminDescription: msRADIUSFramedIPAddress
attributeId: 1.2.840.113556.1.4.1153
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendRoutePreference,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendRoutePreference
adminDisplayName: msAscendRoutePreference
adminDescription: msAscendRoutePreference
attributeId: 1.2.840.113556.1.4.1098
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: cJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendHomeNetworkName,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHomeNetworkName
adminDisplayName: msAscendHomeNetworkName
adminDescription: msAscendHomeNetworkName
attributeId: 1.2.840.113556.1.4.1048
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendMulticastClient,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMulticastClient
adminDisplayName: msAscendMulticastClient
adminDescription: msAscendMulticastClient
attributeId: 1.2.840.113556.1.4.1071
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: VZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Encrypt-Alg-Selected-Other,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EncryptAlgSelectedOther
adminDisplayName: Encrypt-Alg-Selected-Other
adminDescription: Encrypt-Alg-Selected-Other
attributeId: 1.2.840.113556.1.2.397
attributeSyntax: 2.5.5.5
omSyntax: 19
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 32
schemaIdGuid:: +nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32829
hideFromAB: TRUE

dn: CN=msRADIUSFramedIPNetmask,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedIPNetmask
adminDisplayName: msRADIUSFramedIPNetmask
adminDescription: msRADIUSFramedIPNetmask
attributeId: 1.2.840.113556.1.4.1154
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendConnectProgress,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendConnectProgress
adminDisplayName: msAscendConnectProgress
adminDescription: msAscendConnectProgress
attributeId: 1.2.840.113556.1.4.1006
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendLinkCompression,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendLinkCompression
adminDisplayName: msAscendLinkCompression
adminDescription: msAscendLinkCompression
attributeId: 1.2.840.113556.1.4.1059
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: SZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendPreInputPackets,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPreInputPackets
adminDisplayName: msAscendPreInputPackets
adminDescription: msAscendPreInputPackets
attributeId: 1.2.840.113556.1.4.1084
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSLoginLATService,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSLoginLATService
adminDisplayName: msRADIUSLoginLATService
adminDescription: msRADIUSLoginLATService
attributeId: 1.2.840.113556.1.4.1165
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: sJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Monitoring-Recipients-NDR,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringRecipientsNDR
adminDisplayName: Monitoring-Recipients-NDR
adminDescription: Monitoring-Recipients-NDR
attributeId: 1.2.840.113556.1.2.387
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: L3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33002
hideFromAB: TRUE

dn: CN=Two-Way-Alternate-Facility,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TwoWayAlternateFacility
adminDisplayName: Two-Way-Alternate-Facility
adminDescription: Two-Way-Alternate-Facility
attributeId: 1.2.840.113556.1.2.40
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33105
hideFromAB: TRUE

dn: CN=msRADIUSAttributeNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSAttributeNumber
adminDisplayName: msRADIUSAttributeNumber
adminDescription: msRADIUSAttributeNumber
attributeId: 1.2.840.113556.1.4.1141
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSAttributeVendor,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSAttributeVendor
adminDisplayName: msRADIUSAttributeVendor
adminDescription: msRADIUSAttributeVendor
attributeId: 1.2.840.113556.1.4.1143
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: mpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Preserve-Internet-Content,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: PreserveInternetContent
adminDisplayName: Preserve-Internet-Content
adminDescription: Preserve-Internet-Content
attributeId: 1.2.840.113556.1.2.556
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: THTfqOrF0RG7ywCAx2ZwwA==
mapiID: 35874
hideFromAB: TRUE

dn: CN=msAscendPreOutputOctets,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPreOutputOctets
adminDisplayName: msAscendPreOutputOctets
adminDescription: msAscendPreOutputOctets
attributeId: 1.2.840.113556.1.4.1085
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Y5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Prev-Export-Native-Only,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPrevExportNativeOnly
adminDisplayName: DXA-Prev-Export-Native-Only
adminDescription: DXA-Prev-Export-Native-Only
attributeId: 1.2.840.113556.1.2.203
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3XPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32910
hideFromAB: TRUE

dn: CN=msRASMPPEEncryptionType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRASMPPEEncryptionType
adminDisplayName: msRASMPPEEncryptionType
adminDescription: msRASMPPEEncryptionType
attributeId: 1.2.840.113556.1.4.1188
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=X25-Facilities-Data-Incoming,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25FacilitiesDataIncoming
adminDisplayName: X25-Facilities-Data-Incoming
adminDescription: X25-Facilities-Data-Incoming
attributeId: 1.2.840.113556.1.2.318
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 109
schemaIdGuid:: nXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33115
hideFromAB: TRUE

dn: CN=msAscendBaseChannelCount,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendBaseChannelCount
adminDisplayName: msAscendBaseChannelCount
adminDescription: msAscendBaseChannelCount
attributeId: 1.2.840.113556.1.4.987
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: AZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRASSavedCallbackNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRASSavedCallbackNumber
adminDisplayName: msRASSavedCallbackNumber
adminDescription: msRASSavedCallbackNumber
attributeId: 1.2.840.113556.1.4.1189
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=X25-Facilities-Data-Outgoing,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: X25FacilitiesDataOutgoing
adminDisplayName: X25-Facilities-Data-Outgoing
adminDescription: X25-Facilities-Data-Outgoing
attributeId: 1.2.840.113556.1.2.319
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 109
schemaIdGuid:: nnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33116
hideFromAB: TRUE

dn: CN=msAscendCallAttemptLimit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallAttemptLimit
adminDisplayName: msAscendCallAttemptLimit
adminDescription: msAscendCallAttemptLimit
attributeId: 1.2.840.113556.1.4.991
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendIPPoolDefinition,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendIPPoolDefinition
adminDisplayName: msAscendIPPoolDefinition
adminDescription: msAscendIPPoolDefinition
attributeId: 1.2.840.113556.1.4.1054
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendPrimaryHomeAgent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPrimaryHomeAgent
adminDisplayName: msAscendPrimaryHomeAgent
adminDescription: msAscendPrimaryHomeAgent
attributeId: 1.2.840.113556.1.4.1088
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ZpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendHomeAgentUDPPort,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHomeAgentUDPPort
adminDisplayName: msAscendHomeAgentUDPPort
adminDescription: msAscendHomeAgentUDPPort
attributeId: 1.2.840.113556.1.4.1047
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendClientPrimaryDNS,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendClientPrimaryDNS
adminDisplayName: msAscendClientPrimaryDNS
adminDescription: msAscendClientPrimaryDNS
attributeId: 1.2.840.113556.1.4.1004
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: EpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSTunnelPreference,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelPreference
adminDisplayName: msRADIUSTunnelPreference
adminDescription: msRADIUSTunnelPreference
attributeId: 1.2.840.113556.1.4.1178
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendSecondsOfHistory,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSecondsOfHistory
adminDisplayName: msAscendSecondsOfHistory
adminDescription: msAscendSecondsOfHistory
attributeId: 1.2.840.113556.1.4.1100
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: cpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendPreOutputPackets,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendPreOutputPackets
adminDisplayName: msAscendPreOutputPackets
adminDescription: msAscendPreOutputPackets
attributeId: 1.2.840.113556.1.4.1086
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ZJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSFramedIPXNetwork,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedIPXNetwork
adminDisplayName: msRADIUSFramedIPXNetwork
adminDescription: msRADIUSFramedIPXNetwork
attributeId: 1.2.840.113556.1.4.1155
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ppAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Connection-List-Filter-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: ConnectionListFilterType
adminDisplayName: Connection-List-Filter-Type
adminDescription: Connection-List-Filter-Type
attributeId: 1.2.840.113556.1.2.526
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: t3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 33204
hideFromAB: TRUE

dn: CN=msAscendHistoryWeighType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHistoryWeighType
adminDisplayName: msAscendHistoryWeighType
adminDescription: msAscendHistoryWeighType
attributeId: 1.2.840.113556.1.4.1044
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSTunnelMediumType,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelMediumType
adminDisplayName: msRADIUSTunnelMediumType
adminDescription: msRADIUSTunnelMediumType
attributeId: 1.2.840.113556.1.4.1176
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: u5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Transfer-Timeout-Non-Urgent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: TransferTimeoutNonUrgent
adminDisplayName: Transfer-Timeout-Non-Urgent
adminDescription: Transfer-Timeout-Non-Urgent
attributeId: 1.2.840.113556.1.2.136
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 32767
schemaIdGuid:: jXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33098
hideFromAB: TRUE

dn: CN=msAscendCallBlockDuration,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendCallBlockDuration
adminDisplayName: msAscendCallBlockDuration
adminDescription: msAscendCallBlockDuration
attributeId: 1.2.840.113556.1.4.994
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: CJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendAppletalkPeerMode,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendAppletalkPeerMode
adminDisplayName: msAscendAppletalkPeerMode
adminDescription: msAscendAppletalkPeerMode
attributeId: 1.2.840.113556.1.4.979
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +Y8M2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRASSavedFramedIPAddress,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRASSavedFramedIPAddress
adminDisplayName: msRASSavedFramedIPAddress
adminDescription: msRASSavedFramedIPAddress
attributeId: 1.2.840.113556.1.4.1190
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendDHCPMaximumLeases,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendDHCPMaximumLeases
adminDisplayName: msAscendDHCPMaximumLeases
adminDescription: msAscendDHCPMaximumLeases
attributeId: 1.2.840.113556.1.4.1012
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: GpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendHomeAgentPassword,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendHomeAgentPassword
adminDisplayName: msAscendHomeAgentPassword
adminDescription: msAscendHomeAgentPassword
attributeId: 1.2.840.113556.1.4.1046
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msNPSavedCallingStationID,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msNPSavedCallingStationID
adminDisplayName: msNPSavedCallingStationID
adminDescription: msNPSavedCallingStationID
attributeId: 1.2.840.113556.1.4.1130
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: jpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Quota-Notification-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: QuotaNotificationSchedule
adminDisplayName: Quota-Notification-Schedule
adminDescription: Quota-Notification-Schedule
attributeId: 1.2.840.113556.1.2.98
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 84
rangeUpper: 84
schemaIdGuid:: T3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 33041
hideFromAB: TRUE

dn: CN=msRADIUSFramedCompression,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedCompression
adminDisplayName: msRADIUSFramedCompression
adminDescription: msRADIUSFramedCompression
attributeId: 1.2.840.113556.1.4.1152
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: o5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSTerminationAction,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTerminationAction
adminDisplayName: msRADIUSTerminationAction
adminDescription: msRADIUSTerminationAction
attributeId: 1.2.840.113556.1.4.1173
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: uJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendTunnelingProtocol,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendTunnelingProtocol
adminDisplayName: msAscendTunnelingProtocol
adminDescription: msAscendTunnelingProtocol
attributeId: 1.2.840.113556.1.4.1111
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Authorized-Password-Confirm,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AuthorizedPasswordConfirm
adminDisplayName: Authorized-Password-Confirm
adminDescription: Authorized-Password-Confirm
attributeId: 1.2.840.113556.1.2.493
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: nHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33170
hideFromAB: TRUE

dn: CN=msRASMPPEEncryptionPolicy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRASMPPEEncryptionPolicy
adminDisplayName: msRASMPPEEncryptionPolicy
adminDescription: msRASMPPEEncryptionPolicy
attributeId: 1.2.840.113556.1.4.1187
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: w5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Monitoring-Normal-Poll-Units,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringNormalPollUnits
adminDisplayName: Monitoring-Normal-Poll-Units
adminDescription: Monitoring-Normal-Poll-Units
attributeId: 1.2.840.113556.1.2.88
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: LXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 33000
hideFromAB: TRUE

dn: CN=msAscendSecondaryHomeAgent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSecondaryHomeAgent
adminDisplayName: msAscendSecondaryHomeAgent
adminDescription: msAscendSecondaryHomeAgent
attributeId: 1.2.840.113556.1.4.1099
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: cZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendClientSecondaryDNS,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendClientSecondaryDNS
adminDisplayName: msAscendClientSecondaryDNS
adminDescription: msAscendClientSecondaryDNS
attributeId: 1.2.840.113556.1.4.1005
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: E5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Allowed-Attributes-Effective,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: allowedAttributesEffective
adminDisplayName: Allowed-Attributes-Effective
adminDescription: Allowed-Attributes-Effective
attributeId: 1.2.840.113556.1.4.914
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Qdl6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=msAscendMulticastRateLimit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMulticastRateLimit
adminDisplayName: msAscendMulticastRateLimit
adminDescription: msAscendMulticastRateLimit
attributeId: 1.2.840.113556.1.4.1073
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: V5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSTunnelAssignmentId,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelAssignmentId
adminDisplayName: msRADIUSTunnelAssignmentId
adminDescription: msRADIUSTunnelAssignmentId
attributeId: 1.2.840.113556.1.4.1174
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: uZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSVSAAttributeNumber,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSVSAAttributeNumber
adminDisplayName: msRADIUSVSAAttributeNumber
adminDescription: msRADIUSVSAAttributeNumber
attributeId: 1.2.840.113556.1.4.1183
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendSharedProfileEnable,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendSharedProfileEnable
adminDisplayName: msAscendSharedProfileEnable
adminDescription: msAscendSharedProfileEnable
attributeId: 1.2.840.113556.1.4.1105
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: d5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Certificate-Revocation-List-V1,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CertificateRevocationListV1
adminDisplayName: Certificate-Revocation-List-V1
adminDescription: Certificate-Revocation-List-V1
attributeId: 1.2.840.113556.1.2.564
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: q3PfqOrF0RG7ywCAx2ZwwA==
mapiID: 35881
hideFromAB: TRUE

dn: CN=Certificate-Revocation-List-V3,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: CertificateRevocationListV3
adminDisplayName: Certificate-Revocation-List-V3
adminDescription: Certificate-Revocation-List-V3
attributeId: 1.2.840.113556.1.2.563
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rHPfqOrF0RG7ywCAx2ZwwA==
mapiID: 35880
hideFromAB: TRUE

dn: CN=Monitoring-Hotsite-Poll-Units,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringHotsitePollUnits
adminDisplayName: Monitoring-Hotsite-Poll-Units
adminDescription: Monitoring-Hotsite-Poll-Units
attributeId: 1.2.840.113556.1.2.87
attributeSyntax: 2.5.5.9
omSyntax: 10
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 2
schemaIdGuid:: K3TfqOrF0RG7ywCAx2ZwwA==
mapiID: 32996
hideFromAB: TRUE

dn: CN=msRADIUSFramedAppleTalkLink,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedAppleTalkLink
adminDisplayName: msRADIUSFramedAppleTalkLink
adminDescription: msRADIUSFramedAppleTalkLink
attributeId: 1.2.840.113556.1.4.1149
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: oJAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msAscendMaximumCallDuration,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMaximumCallDuration
adminDisplayName: msAscendMaximumCallDuration
adminDescription: msAscendMaximumCallDuration
attributeId: 1.2.840.113556.1.4.1060
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: SpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSFramedAppleTalkZone,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedAppleTalkZone
adminDisplayName: msRADIUSFramedAppleTalkZone
adminDescription: msRADIUSFramedAppleTalkZone
attributeId: 1.2.840.113556.1.4.1151
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: opAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=ACS-RSVP-Account-Files-Location,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aCSRSVPAccountFilesLocation
adminDisplayName: ACS-RSVP-Account-Files-Location
adminDescription: ACS-RSVP-Account-Files-Location
attributeId: 1.2.840.113556.1.4.900
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DyNy8PWu0RG9zwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=ACS-Max-Size-Of-RSVP-Account-File,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aCSMaxSizeOfRSVPAccountFile
adminDisplayName: ACS-Max-Size-Of-RSVP-Account-File
adminDescription: ACS-Max-Size-Of-RSVP-Account-File
attributeId: 1.2.840.113556.1.4.902
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ESNy8PWu0RG9zwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=Allowed-Child-Classes-Effective,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: allowedChildClassesEffective
adminDisplayName: Allowed-Child-Classes-Effective
adminDescription: Allowed-Child-Classes-Effective
attributeId: 1.2.840.113556.1.4.912
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: Q9l6mlPK0RG70ACAx2ZwwA==
hideFromAB: TRUE
systemFlags: 8000004

dn: CN=Enabled-Authorization-Packages,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: EnabledAuthorizationPackages
adminDisplayName: Enabled-Authorization-Packages
adminDescription: Enabled-Authorization-Packages
attributeId: 1.2.840.113556.1.2.479
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 128
schemaIdGuid:: 83PfqOrF0RG7ywCAx2ZwwA==
mapiID: 33156
hideFromAB: TRUE

dn: CN=msAscendMulticastGLeaveDelay,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msAscendMulticastGLeaveDelay
adminDisplayName: msAscendMulticastGLeaveDelay
adminDescription: msAscendMulticastGLeaveDelay
attributeId: 1.2.840.113556.1.4.1072
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: VpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSTunnelClientEndpoint,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelClientEndpoint
adminDisplayName: msRADIUSTunnelClientEndpoint
adminDescription: msRADIUSTunnelClientEndpoint
attributeId: 1.2.840.113556.1.4.1175
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: upAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=DXA-Prev-In-Exchange-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPrevInExchangeSensitivity
adminDisplayName: DXA-Prev-In-Exchange-Sensitivity
adminDescription: DXA-Prev-In-Exchange-Sensitivity
attributeId: 1.2.840.113556.1.2.90
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3nPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32911
hideFromAB: TRUE

dn: CN=Monitoring-Normal-Poll-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringNormalPollInterval
adminDisplayName: Monitoring-Normal-Poll-Interval
adminDescription: Monitoring-Normal-Poll-Interval
attributeId: 1.2.840.113556.1.2.187
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LHTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32999
hideFromAB: TRUE

dn: CN=msRADIUSTunnelPrivateGroupId,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelPrivateGroupId
adminDisplayName: msRADIUSTunnelPrivateGroupId
adminDescription: msRADIUSTunnelPrivateGroupId
attributeId: 1.2.840.113556.1.4.1179
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vpAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=msRADIUSTunnelServerEndpoint,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSTunnelServerEndpoint
adminDisplayName: msRADIUSTunnelServerEndpoint
adminDescription: msRADIUSTunnelServerEndpoint
attributeId: 1.2.840.113556.1.4.1180
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: v5AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Monitoring-Escalation-Procedure,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringEscalationProcedure
adminDisplayName: Monitoring-Escalation-Procedure
adminDescription: Monitoring-Escalation-Procedure
attributeId: 1.2.840.113556.1.2.188
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 1064
schemaIdGuid:: KXTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32994
hideFromAB: TRUE

dn: CN=DXA-Prev-Replication-Sensitivity,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: DXAPrevReplicationSensitivity
adminDisplayName: DXA-Prev-Replication-Sensitivity
adminDescription: DXA-Prev-Replication-Sensitivity
attributeId: 1.2.840.113556.1.2.215
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 4HPfqOrF0RG7ywCAx2ZwwA==
mapiID: 32913
hideFromAB: TRUE

dn: CN=Monitoring-Hotsite-Poll-Interval,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: MonitoringHotsitePollInterval
adminDisplayName: Monitoring-Hotsite-Poll-Interval
adminDescription: Monitoring-Hotsite-Poll-Interval
attributeId: 1.2.840.113556.1.2.186
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: KnTfqOrF0RG7ywCAx2ZwwA==
mapiID: 32995
hideFromAB: TRUE

dn: CN=Available-Authorization-Packages,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: AvailableAuthorizationPackages
adminDisplayName: Available-Authorization-Packages
adminDescription: Available-Authorization-Packages
attributeId: 1.2.840.113556.1.2.476
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 512
schemaIdGuid:: nnPfqOrF0RG7ywCAx2ZwwA==
mapiID: 33153
hideFromAB: TRUE

dn: CN=ACS-Max-Aggregate-Peak-Rate-Per-User,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: aCSMaxAggregatePeakRatePerUser
adminDisplayName: ACS-Max-Aggregate-Peak-Rate-Per-User
adminDescription: ACS-Max-Aggregate-Peak-Rate-Per-User
attributeId: 1.2.840.113556.1.4.897
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DCNy8PWu0RG9zwAA+ANnwQ==
hideFromAB: TRUE

dn: CN=msRADIUSFramedAppleTalkNetwork,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: attributeSchema
ldapDisplayName: msRADIUSFramedAppleTalkNetwork
adminDisplayName: msRADIUSFramedAppleTalkNetwork
adminDescription: msRADIUSFramedAppleTalkNetwork
attributeId: 1.2.840.113556.1.4.1150
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: oZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE

dn: CN=Mail-Gateway,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mailGateway
adminDisplayName: Mail-Gateway
adminDescription: Mail-Gateway
governsId: 1.2.840.113556.1.3.51
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.171
systemMustContain: 1.2.840.113556.1.2.241
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.221
systemMayContain: 1.2.840.113556.1.2.396
systemMayContain: 1.2.840.113556.1.2.142
systemMayContain: 1.2.840.113556.1.2.137
systemMayContain: 1.2.840.113556.1.2.136
systemMayContain: 1.2.840.113556.1.2.133
systemMayContain: 2.5.4.30
systemMayContain: 1.2.840.113556.1.2.354
systemMayContain: 1.2.840.113556.1.2.223
systemMayContain: 1.2.840.113556.1.2.224
systemMayContain: 1.2.840.113556.1.2.69
systemMayContain: 1.2.840.113556.1.2.266
systemMayContain: 1.2.840.113556.1.2.64
systemMayContain: 1.2.840.113556.1.2.72
systemMayContain: 1.2.840.113556.1.2.449
systemMayContain: 1.2.840.113556.1.2.383
systemMayContain: 1.2.840.113556.1.2.110
systemMayContain: 1.2.840.113556.1.2.244
systemMayContain: 1.2.840.113556.1.2.307
systemMayContain: 1.2.840.113556.1.2.111
systemMayContain: 1.2.840.113556.1.2.448
systemMayContain: 1.2.840.113556.1.2.144
systemMayContain: 1.2.840.113556.1.2.47
systemMayContain: 1.2.840.113556.1.2.189
systemMayContain: 1.2.840.113556.1.2.140
systemMayContain: 1.2.840.113556.1.2.139
systemMayContain: 1.2.840.113556.1.2.138
systemMayContain: 2.5.4.6
systemMayContain: 1.2.840.113556.1.2.211
systemMayContain: 1.2.840.113556.1.2.20
systemMayContain: 1.2.840.113556.1.2.455
systemMayContain: 1.2.840.113556.1.2.129
systemMayContain: 1.2.840.113556.1.2.232
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: t3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Mail-Gateway,CN=Schema,CN=Configuration,DC=X

dn: CN=X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: x400Link
adminDisplayName: X400-Link
adminDescription: X400-Link
governsId: 1.2.840.113556.1.3.29
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.51
systemMayContain: 1.2.840.113556.1.2.443
systemMayContain: 1.2.840.113556.1.2.99
systemMayContain: 1.2.840.113556.1.2.40
systemMayContain: 1.2.840.113556.1.2.38
systemMayContain: 1.2.840.113556.1.2.150
systemMayContain: 1.2.840.113556.1.2.329
systemMayContain: 1.2.840.113556.1.2.5
systemMayContain: 1.2.840.113556.1.2.283
systemMayContain: 1.2.840.113556.1.2.28
systemMayContain: 1.2.840.113556.1.2.154
systemMayContain: 1.2.840.113556.1.2.46
systemMayContain: 1.2.840.113556.1.2.284
systemMayContain: 1.2.840.113556.1.2.153
systemMayContain: 1.2.840.113556.1.2.151
systemMayContain: 1.2.840.113556.1.2.152
systemMayContain: 1.2.840.113556.1.2.52
systemMayContain: 1.2.840.113556.1.2.285
systemMayContain: 1.2.840.113556.1.2.143
systemMayContain: 1.2.840.113556.1.2.134
systemMayContain: 1.2.840.113556.1.2.148
systemMayContain: 1.2.840.113556.1.2.222
systemMayContain: 1.2.840.113556.1.2.282
systemMayContain: 1.2.840.113556.1.2.271
systemMayContain: 1.2.840.113556.1.2.270
systemMayContain: 1.2.840.113556.1.2.39
systemMayContain: 1.2.840.113556.1.2.29
systemMayContain: 1.2.840.113556.1.2.37
systemMayContain: 1.2.840.113556.1.2.149
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 4HTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=X400-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=Information-Store-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: informationStoreCfg
adminDisplayName: Information-Store-Cfg
adminDescription: Information-Store-Cfg
governsId: 1.2.840.113556.1.3.5
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.457
systemMayContain: 1.2.840.113556.1.2.456
systemMayContain: 1.2.840.113556.1.2.434
systemMayContain: 1.2.840.113556.1.2.388
systemMayContain: 1.2.840.113556.1.2.98
systemMayContain: 1.2.840.113556.1.2.453
systemMayContain: 1.2.840.113556.1.2.266
systemMayContain: 1.2.840.113556.1.2.272
systemMayContain: 1.2.840.113556.1.2.235
systemMayContain: 1.2.840.113556.1.2.586
systemMayContain: 1.2.840.113556.1.2.13
systemMayContain: 1.2.840.113556.1.2.300
systemMayContain: 1.2.840.113556.1.2.63
systemMayContain: 1.2.840.113556.1.2.62
systemMayContain: 1.2.840.113556.1.2.11
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: tHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Information-Store-Cfg,CN=Schema,CN=Configuration,DC=X

dn: CN=MHS-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mHSMonitoringConfig
adminDisplayName: MHS-Monitoring-Config
adminDescription: MHS-Monitoring-Config
governsId: 1.2.840.113556.1.3.6
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.185
systemMayContain: 1.2.840.113556.1.2.88
systemMayContain: 1.2.840.113556.1.2.187
systemMayContain: 1.2.840.113556.1.2.87
systemMayContain: 1.2.840.113556.1.2.186
systemMayContain: 1.2.840.113556.1.2.188
systemMayContain: 1.2.840.113556.1.2.200
systemMayContain: 1.2.840.113556.1.2.450
systemMayContain: 1.2.840.113556.1.2.179
systemMayContain: 1.2.840.113556.1.2.192
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: u3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MHS-Monitoring-Config,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-Shared,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgShared
adminDisplayName: Protocol-Cfg-Shared
adminDescription: Protocol-Cfg-Shared
governsId: 1.2.840.113556.1.3.65
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.478
systemMayContain: 1.2.840.113556.1.2.608
systemMayContain: 1.2.840.113556.1.4.216
systemMayContain: 1.2.840.113556.1.2.9
systemMayContain: 1.2.840.113556.1.2.607
systemMayContain: 1.2.840.113556.1.2.337
systemMayContain: 1.2.840.113556.1.2.526
systemMayContain: 1.2.840.113556.1.2.475
systemMayContain: 1.2.840.113556.1.2.477
systemMayContain: 1.2.840.113556.1.2.476
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 0HTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-Shared,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-Shared-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgSharedSite
adminDisplayName: Protocol-Cfg-Shared-Site
adminDescription: Protocol-Cfg-Shared-Site
governsId: 1.2.840.113556.1.3.66
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.65
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 0nTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-Shared-Site,CN=Schema,CN=Configuration,DC=X

dn: CN=MTA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mTA
adminDisplayName: MTA
adminDescription: MTA
governsId: 1.2.840.113556.1.3.49
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.220
systemMustContain: 1.2.840.113556.1.2.219
systemMustContain: 1.2.840.113556.1.2.271
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.270
systemMayContain: 1.2.840.113556.1.2.201
systemMayContain: 1.2.840.113556.1.2.189
systemMayContain: 1.2.840.113556.1.2.140
systemMayContain: 1.2.840.113556.1.2.139
systemMayContain: 1.2.840.113556.1.2.138
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: p3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MTA,CN=Schema,CN=Configuration,DC=X

dn: CN=Exchange-Admin-Service,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: exchangeAdminService
adminDisplayName: Exchange-Admin-Service
adminDescription: Exchange-Admin-Service
governsId: 1.2.840.113556.1.3.62
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemAuxiliaryClass: 1.2.840.113556.1.3.46
systemMustContain: 1.2.840.113556.1.2.241
systemMayContain: 1.2.840.113556.1.2.189
systemPossSuperiors: 1.2.840.113556.1.3.23
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: snTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Exchange-Admin-Service,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-Shared-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgSharedServer
adminDisplayName: Protocol-Cfg-Shared-Server
adminDescription: Protocol-Cfg-Shared-Server
governsId: 1.2.840.113556.1.3.67
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.65
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: 0XTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-Shared-Server,CN=Schema,CN=Configuration,DC=X


dn: CN=Protocol-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfg
adminDisplayName: Protocol-Cfg
adminDescription: Protocol-Cfg
governsId: 1.2.840.113556.1.3.68
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.478
systemMayContain: 1.2.840.113556.1.2.492
systemMayContain: 1.2.840.113556.1.2.560
systemMayContain: 1.2.840.113556.1.2.556
systemMayContain: 1.2.840.113556.1.2.527
systemMayContain: 1.2.840.113556.1.2.491
systemMayContain: 1.2.840.113556.1.2.515
systemMayContain: 1.2.840.113556.1.2.479
systemMayContain: 1.2.840.113556.1.2.189
systemMayContain: 1.2.840.113556.1.2.481
systemMayContain: 1.2.840.113556.1.2.559
systemMayContain: 1.2.840.113556.1.2.480
systemMayContain: 1.2.840.113556.1.2.149
systemMayContain: 1.2.840.113556.1.2.482
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: wHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg,CN=Schema,CN=Configuration,DC=X

dn: CN=RFC1006-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rFC1006X400Link
adminDisplayName: RFC1006-X400-Link
adminDescription: RFC1006-X400-Link
governsId: 1.2.840.113556.1.3.32
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.29
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 2HTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RFC1006-X400-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=Remote-DXA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: remoteDXA
adminDisplayName: Remote-DXA
adminDescription: Remote-DXA
governsId: 1.2.840.113556.1.3.2
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.307
systemMustContain: 1.2.840.113556.1.2.112
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.298
systemMayContain: 1.2.840.113556.1.2.173
systemMayContain: 1.2.840.113556.1.2.223
systemMayContain: 1.2.840.113556.1.2.100
systemMayContain: 1.2.840.113556.1.2.383
systemMayContain: 1.2.840.113556.1.2.110
systemMayContain: 1.2.840.113556.1.2.111
systemMayContain: 1.2.840.113556.1.2.181
systemMayContain: 1.2.840.113556.1.2.119
systemMayContain: 1.2.840.113556.1.2.358
systemMayContain: 1.2.840.113556.1.2.124
systemMayContain: 1.2.840.113556.1.2.361
systemMayContain: 1.2.840.113556.1.2.360
systemMayContain: 1.2.840.113556.1.2.446
systemMayContain: 1.2.840.113556.1.2.182
systemMayContain: 1.2.840.113556.1.2.114
systemMayContain: 1.2.840.113556.1.2.101
systemMayContain: 1.2.840.113556.1.2.384
systemMayContain: 1.2.840.113556.1.2.217
systemMayContain: 1.2.840.113556.1.2.395
systemMayContain: 1.2.840.113556.1.2.215
systemMayContain: 1.2.840.113556.1.2.265
systemMayContain: 1.2.840.113556.1.2.90
systemMayContain: 1.2.840.113556.1.2.203
systemMayContain: 1.2.840.113556.1.2.216
systemMayContain: 1.2.840.113556.1.2.305
systemMayContain: 1.2.840.113556.1.2.331
systemMayContain: 1.2.840.113556.1.2.113
systemMayContain: 1.2.840.113556.1.2.376
systemMayContain: 1.2.840.113556.1.2.86
systemMayContain: 1.2.840.113556.1.2.117
systemMayContain: 1.2.840.113556.1.2.116
systemMayContain: 1.2.840.113556.1.2.377
systemMayContain: 1.2.840.113556.1.2.359
systemMayContain: 1.2.840.113556.1.2.45
systemMayContain: 1.2.840.113556.1.2.184
systemMayContain: 1.2.840.113556.1.2.122
systemMayContain: 1.2.840.113556.1.2.180
systemMayContain: 1.2.840.113556.1.2.174
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 1XTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Remote-DXA,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-HTTP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgHTTP
adminDisplayName: Protocol-Cfg-HTTP
adminDescription: Protocol-Cfg-HTTP
governsId: 1.2.840.113556.1.3.79
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.68
systemMustContain: 1.2.840.113556.1.2.502
systemMayContain: 1.2.840.113556.1.2.517
systemMayContain: 1.2.840.113556.1.2.505
systemMayContain: 1.2.840.113556.1.2.503
systemMayContain: 1.2.840.113556.1.2.516
systemPossSuperiors: 1.2.840.113556.1.3.67
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: wXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-HTTP,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-LDAP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgLDAP
adminDisplayName: Protocol-Cfg-LDAP
adminDescription: Protocol-Cfg-LDAP
governsId: 1.2.840.113556.1.3.75
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.68
systemMayContain: 1.2.840.113556.1.2.490
systemMayContain: 1.2.840.113556.1.2.552
systemPossSuperiors: 1.2.840.113556.1.3.67
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: x3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-LDAP,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-IMAP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgIMAP
adminDisplayName: Protocol-Cfg-IMAP
adminDescription: Protocol-Cfg-IMAP
governsId: 1.2.840.113556.1.3.84
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.68
systemMayContain: 1.2.840.113556.1.2.594
systemMayContain: 1.2.840.113556.1.2.608
systemMayContain: 1.2.840.113556.1.2.592
systemMayContain: 1.2.840.113556.1.2.9
systemMayContain: 1.2.840.113556.1.2.607
systemMayContain: 1.2.840.113556.1.2.337
systemMayContain: 1.2.840.113556.1.2.591
systemMayContain: 1.2.840.113556.1.2.561
systemPossSuperiors: 1.2.840.113556.1.3.67
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: xHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-IMAP,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-HTTP-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgHTTPServer
adminDisplayName: Protocol-Cfg-HTTP-Server
adminDescription: Protocol-Cfg-HTTP-Server
governsId: 1.2.840.113556.1.3.80
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.79
systemPossSuperiors: 1.2.840.113556.1.3.67
schemaIdGuid:: wnTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-HTTP-Server,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgNNTP
adminDisplayName: Protocol-Cfg-NNTP
adminDescription: Protocol-Cfg-NNTP
governsId: 1.2.840.113556.1.3.72
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.68
systemMayContain: 1.2.840.113556.1.2.484
systemMayContain: 1.2.840.113556.1.2.590
systemMayContain: 1.2.840.113556.1.2.524
systemMayContain: 1.2.840.113556.1.2.543
systemMayContain: 1.2.840.113556.1.2.485
systemMayContain: 1.2.840.113556.1.2.483
systemMayContain: 1.2.840.113556.1.2.486
systemPossSuperiors: 1.2.840.113556.1.3.67
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: ynTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-NNTP,CN=Schema,CN=Configuration,DC=X

dn: CN=Mailbox-Agent,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mailboxAgent
adminDisplayName: Mailbox-Agent
adminDescription: Mailbox-Agent
governsId: 1.2.840.113556.1.3.17
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.22
systemMayContain: 2.5.4.32
systemMayContain: 1.2.840.113556.1.2.20
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: uHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Mailbox-Agent,CN=Schema,CN=Configuration,DC=X

dn: CN=Directory-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: directoryCfg
adminDisplayName: Directory-Cfg
adminDescription: Directory-Cfg
governsId: 1.2.840.113556.1.3.4
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.509
systemMayContain: 1.2.840.113556.1.2.54
systemMayContain: 1.2.840.113556.1.2.385
systemMayContain: 1.2.840.113556.1.2.520
systemMayContain: 1.2.840.113556.1.2.519
systemMayContain: 1.2.840.113556.1.2.390
systemMayContain: 1.2.840.113556.1.2.392
systemMayContain: 1.2.840.113556.1.2.389
systemMayContain: 1.2.840.113556.1.2.391
systemMayContain: 1.2.840.113556.1.2.301
systemMayContain: 1.2.840.113556.1.2.575
systemMayContain: 1.2.840.113556.1.2.212
systemMayContain: 1.2.840.113556.1.4.1213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: rXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Directory-Cfg,CN=Schema,CN=Configuration,DC=X

dn: CN=NNTP-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: nNTPNewsfeed
adminDisplayName: NNTP-Newsfeed
adminDescription: NNTP-Newsfeed
governsId: 1.2.840.113556.1.3.78
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.495
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.484
systemMayContain: 1.2.840.113556.1.2.492
systemMayContain: 1.2.840.113556.1.2.560
systemMayContain: 1.2.840.113556.1.2.313
systemMayContain: 1.2.840.113556.1.2.520
systemMayContain: 1.2.840.113556.1.2.519
systemMayContain: 1.2.840.113556.1.2.527
systemMayContain: 1.2.840.113556.1.2.490
systemMayContain: 1.2.840.113556.1.2.496
systemMayContain: 1.2.840.113556.1.2.522
systemMayContain: 1.2.840.113556.1.2.488
systemMayContain: 1.2.840.113556.1.2.511
systemMayContain: 1.2.840.113556.1.2.498
systemMayContain: 1.2.840.113556.1.2.497
systemMayContain: 1.2.840.113556.1.2.543
systemMayContain: 1.2.840.113556.1.2.521
systemMayContain: 1.2.840.113556.1.2.491
systemMayContain: 1.2.840.113556.1.2.554
systemMayContain: 1.2.840.113556.1.2.494
systemMayContain: 1.2.840.113556.1.2.489
systemMayContain: 1.2.840.113556.1.2.553
systemMayContain: 1.2.840.113556.1.2.555
systemMayContain: 1.2.840.113556.1.2.557
systemMayContain: 1.2.840.113556.1.2.558
systemMayContain: 1.2.840.113556.1.2.525
systemMayContain: 1.2.840.113556.1.2.276
systemMayContain: 1.2.840.113556.1.2.493
systemMayContain: 1.2.840.113556.1.2.193
systemMayContain: 1.2.840.113556.1.2.501
systemMayContain: 1.2.840.113556.1.2.512
systemMayContain: 1.2.840.113556.1.2.212
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemMayContain: 1.2.840.113556.1.4.1213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: qXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=NNTP-Newsfeed,CN=Schema,CN=Configuration,DC=X

dn: CN=DXA-Site-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: dXASiteServer
adminDisplayName: DXA-Site-Server
adminDescription: DXA-Site-Server
governsId: 1.2.840.113556.1.3.60
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.298
systemMayContain: 1.2.840.113556.1.2.113
systemMayContain: 1.2.840.113556.1.2.379
systemMayContain: 1.2.840.113556.1.2.378
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: sHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=DXA-Site-Server,CN=Schema,CN=Configuration,DC=X

dn: CN=MSMQ-Site-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mSMQSiteLink
adminDisplayName: MSMQ-Site-Link
adminDescription: MSMQ-Site-Link
governsId: 1.2.840.113556.1.5.164
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.945
systemMayContain: 1.2.840.113556.1.4.944
systemMayContain: 1.2.840.113556.1.4.943
systemMayContain: 1.2.840.113556.1.4.946
systemPossSuperiors: 1.2.840.113556.1.5.31
schemaIdGuid:: RsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Site-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=MSMQ-Settings,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mSMQSettings
adminDisplayName: MSMQ-Settings
adminDescription: MSMQ-Settings
governsId: 1.2.840.113556.1.5.165
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.950
systemMayContain: 1.2.840.113556.1.4.951
systemMayContain: 1.2.840.113556.1.4.925
systemMayContain: 1.2.840.113556.1.4.952
systemPossSuperiors: 1.2.840.113556.1.5.17
schemaIdGuid:: R8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Settings,CN=Schema,CN=Configuration,DC=X

dn: CN=EAP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: eAP
adminDisplayName: EAP
adminDescription: EAP
governsId: 1.2.840.113556.1.5.167
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1210
systemMayContain: 1.2.840.113556.1.4.1211
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 2ZAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=EAP,CN=Schema,CN=Configuration,DC=X

dn: CN=Transport-Stack,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: transportStack
adminDisplayName: Transport-Stack
adminDescription: Transport-Stack
governsId: 1.2.840.113556.1.3.18
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.443
systemMayContain: 1.2.840.113556.1.2.283
systemMayContain: 1.2.840.113556.1.2.284
systemMayContain: 1.2.840.113556.1.2.285
systemMayContain: 1.2.840.113556.1.2.222
systemMayContain: 1.2.840.113556.1.2.282
systemPossSuperiors: 1.2.840.113556.1.3.49
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: 3XTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Transport-Stack,CN=Schema,CN=Configuration,DC=X


dn: CN=Mail-Connector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mailConnector
adminDisplayName: Mail-Connector
adminDescription: Mail-Connector
governsId: 1.2.840.113556.1.3.61
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.51
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: tnTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Mail-Connector,CN=Schema,CN=Configuration,DC=X

dn: CN=MSMQ-Enterprise-Settings,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mSMQEnterpriseSettings
adminDisplayName: MSMQ-Enterprise-Settings
adminDescription: MSMQ-Enterprise-Settings
governsId: 1.2.840.113556.1.5.163
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.942
systemMayContain: 1.2.840.113556.1.4.939
systemMayContain: 1.2.840.113556.1.4.941
systemMayContain: 1.2.840.113556.1.4.940
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: RcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Enterprise-Settings,CN=Schema,CN=Configuration,DC=X

dn: CN=Encryption-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: encryptionCfg
adminDisplayName: Encryption-Cfg
adminDescription: Encryption-Cfg
governsId: 1.2.840.113556.1.3.16
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.571
systemMayContain: 1.2.840.113556.1.2.570
systemMayContain: 1.2.840.113556.1.2.569
systemMayContain: 1.2.840.113556.1.2.568
systemMayContain: 1.2.840.113556.1.2.440
systemMayContain: 1.2.840.113556.1.2.397
systemMayContain: 1.2.840.113556.1.2.401
systemMayContain: 1.2.840.113556.1.2.399
systemMayContain: 1.2.840.113556.1.2.130
systemMayContain: 1.2.840.113556.1.2.572
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: sXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Encryption-Cfg,CN=Schema,CN=Configuration,DC=X

dn: CN=Site-Connector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: siteConnector
adminDisplayName: Site-Connector
adminDescription: Site-Connector
governsId: 1.2.840.113556.1.3.50
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.259
systemMayContain: 1.2.840.113556.1.2.354
systemMayContain: 1.2.840.113556.1.2.171
systemMayContain: 1.2.840.113556.1.2.147
systemMayContain: 1.2.840.113556.1.2.135
systemMayContain: 1.2.840.113556.1.2.463
systemMayContain: 1.2.840.113556.1.2.276
systemMayContain: 1.2.840.113556.1.2.193
systemMayContain: 1.2.840.113556.1.2.202
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 2nTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Site-Connector,CN=Schema,CN=Configuration,DC=X

dn: CN=DX-Server-Conn,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: dXServerConn
adminDisplayName: DX-Server-Conn
adminDescription: DX-Server-Conn
governsId: 1.2.840.113556.1.3.20
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.2
systemPossSuperiors: 1.2.840.113556.1.3.60
schemaIdGuid:: r3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=DX-Server-Conn,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-POP,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgPOP
adminDisplayName: Protocol-Cfg-POP
adminDescription: Protocol-Cfg-POP
governsId: 1.2.840.113556.1.3.69
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.68
systemMayContain: 1.2.840.113556.1.2.608
systemMayContain: 1.2.840.113556.1.2.9
systemMayContain: 1.2.840.113556.1.2.607
systemMayContain: 1.2.840.113556.1.2.337
systemPossSuperiors: 1.2.840.113556.1.3.67
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: zXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-POP,CN=Schema,CN=Configuration,DC=X

dn: CN=MHS-Link-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mHSLinkMonitoringConfig
adminDisplayName: MHS-Link-Monitoring-Config
adminDescription: MHS-Link-Monitoring-Config
governsId: 1.2.840.113556.1.3.12
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.6
systemMayContain: 1.2.840.113556.1.2.56
systemMayContain: 1.2.840.113556.1.2.157
systemMayContain: 1.2.840.113556.1.2.387
systemMayContain: 1.2.840.113556.1.2.159
systemMayContain: 1.2.840.113556.1.2.57
systemMayContain: 1.2.840.113556.1.2.158
systemMayContain: 1.2.840.113556.1.2.156
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: uXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MHS-Link-Monitoring-Config,CN=Schema,CN=Configuration,DC=X

dn: CN=Site-Addressing,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: siteAddressing
adminDisplayName: Site-Addressing
adminDescription: Site-Addressing
governsId: 1.2.840.113556.1.3.0
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.385
systemMayContain: 1.2.840.113556.1.2.354
systemMayContain: 1.2.840.113556.1.2.346
systemMayContain: 1.2.840.113556.1.2.167
systemMayContain: 1.2.840.113556.1.2.302
systemMayContain: 1.2.840.113556.1.2.44
systemMayContain: 1.2.840.113556.1.2.541
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 2XTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Site-Addressing,CN=Schema,CN=Configuration,DC=X

dn: CN=Admin-Extension,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: adminExtension
adminDisplayName: Admin-Extension
adminDescription: Admin-Extension
governsId: 1.2.840.113556.1.3.21
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.178
systemMustContain: 2.5.4.3
systemMustContain: 1.2.840.113556.1.2.95
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: rHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Admin-Extension,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-POP-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgPOPServer
adminDisplayName: Protocol-Cfg-POP-Server
adminDescription: Protocol-Cfg-POP-Server
governsId: 1.2.840.113556.1.3.71
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.69
systemPossSuperiors: 1.2.840.113556.1.3.67
schemaIdGuid:: znTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-POP-Server,CN=Schema,CN=Configuration,DC=X

dn: CN=MHS-Public-Store,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mHSPublicStore
adminDisplayName: MHS-Public-Store
adminDescription: MHS-Public-Store
governsId: 1.2.840.113556.1.3.28
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemAuxiliaryClass: 1.2.840.113556.1.3.46
systemMustContain: 1.2.840.113556.1.2.241
systemMayContain: 1.2.840.113556.1.2.266
systemMayContain: 1.2.840.113556.1.2.272
systemMayContain: 1.2.840.113556.1.2.458
systemMayContain: 1.2.840.113556.1.2.189
systemMayContain: 1.2.840.113556.1.2.106
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: vHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MHS-Public-Store,CN=Schema,CN=Configuration,DC=X

dn: CN=Add-In,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: addIn
adminDisplayName: Add-In
adminDescription: Add-In
governsId: 1.2.840.113556.1.3.36
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.20
systemMustContain: 2.5.4.3
systemMayContain: 2.5.4.32
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: qnTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Add-In,CN=Schema,CN=Configuration,DC=X

dn: CN=RFC1006-Stack,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rFC1006Stack
adminDisplayName: RFC1006-Stack
adminDescription: RFC1006-Stack
governsId: 1.2.840.113556.1.3.24
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.18
systemPossSuperiors: 1.2.840.113556.1.3.49
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: 13TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RFC1006-Stack,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-LDAP-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgLDAPServer
adminDisplayName: Protocol-Cfg-LDAP-Server
adminDescription: Protocol-Cfg-LDAP-Server
governsId: 1.2.840.113556.1.3.77
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.75
systemMayContain: 1.2.840.113556.1.2.510
systemPossSuperiors: 1.2.840.113556.1.3.67
schemaIdGuid:: yHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-LDAP-Server,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-IMAP-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgIMAPServer
adminDisplayName: Protocol-Cfg-IMAP-Server
adminDescription: Protocol-Cfg-IMAP-Server
governsId: 1.2.840.113556.1.3.85
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.84
systemPossSuperiors: 1.2.840.113556.1.3.67
schemaIdGuid:: xXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-IMAP-Server,CN=Schema,CN=Configuration,DC=X

dn: CN=MS-Mail-Connector,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mSMailConnector
adminDisplayName: MS-Mail-Connector
adminDescription: MS-Mail-Connector
governsId: 1.2.840.113556.1.3.31
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.51
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: vnTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-Mail-Connector,CN=Schema,CN=Configuration,DC=X

dn: CN=msRADIUSProfile,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: msRADIUSProfile
adminDisplayName: msRADIUSProfile
adminDescription: msRADIUSProfile
governsId: 1.2.840.113556.1.5.166
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1188
systemMayContain: 1.2.840.113556.1.4.1187
systemMayContain: 1.2.840.113556.1.4.739
systemMayContain: 1.2.840.113556.1.4.738
systemMayContain: 1.2.840.113556.1.4.737
systemMayContain: 1.2.840.113556.1.4.1181
systemMayContain: 1.2.840.113556.1.4.1180
systemMayContain: 1.2.840.113556.1.4.1179
systemMayContain: 1.2.840.113556.1.4.1178
systemMayContain: 1.2.840.113556.1.4.1177
systemMayContain: 1.2.840.113556.1.4.1176
systemMayContain: 1.2.840.113556.1.4.1175
systemMayContain: 1.2.840.113556.1.4.1174
systemMayContain: 1.2.840.113556.1.4.1173
systemMayContain: 1.2.840.113556.1.4.1172
systemMayContain: 1.2.840.113556.1.4.1171
systemMayContain: 1.2.840.113556.1.4.1170
systemMayContain: 1.2.840.113556.1.4.1169
systemMayContain: 1.2.840.113556.1.4.1168
systemMayContain: 1.2.840.113556.1.4.1167
systemMayContain: 1.2.840.113556.1.4.1166
systemMayContain: 1.2.840.113556.1.4.1165
systemMayContain: 1.2.840.113556.1.4.1164
systemMayContain: 1.2.840.113556.1.4.1163
systemMayContain: 1.2.840.113556.1.4.1162
systemMayContain: 1.2.840.113556.1.4.1161
systemMayContain: 1.2.840.113556.1.4.1160
systemMayContain: 1.2.840.113556.1.4.1159
systemMayContain: 1.2.840.113556.1.4.1158
systemMayContain: 1.2.840.113556.1.4.1157
systemMayContain: 1.2.840.113556.1.4.1156
systemMayContain: 1.2.840.113556.1.4.1155
systemMayContain: 1.2.840.113556.1.4.1154
systemMayContain: 1.2.840.113556.1.4.1153
systemMayContain: 1.2.840.113556.1.4.1152
systemMayContain: 1.2.840.113556.1.4.1151
systemMayContain: 1.2.840.113556.1.4.1150
systemMayContain: 1.2.840.113556.1.4.1149
systemMayContain: 1.2.840.113556.1.4.1148
systemMayContain: 1.2.840.113556.1.4.1146
systemMayContain: 1.2.840.113556.1.4.1145
systemMayContain: 1.2.840.113556.1.4.1144
systemMayContain: 1.2.840.113556.1.4.1140
systemMayContain: 1.2.840.113556.1.4.1139
systemMayContain: 1.2.840.113556.1.4.1138
systemMayContain: 1.2.840.113556.1.4.1137
systemMayContain: 1.2.840.113556.1.4.1135
systemMayContain: 1.2.840.113556.1.4.1134
systemMayContain: 1.2.840.113556.1.4.1133
systemMayContain: 1.2.840.113556.1.4.1132
systemMayContain: 1.2.840.113556.1.4.1128
systemMayContain: 1.2.840.113556.1.4.1126
systemMayContain: 1.2.840.113556.1.4.1124
systemMayContain: 1.2.840.113556.1.4.1123
systemMayContain: 1.2.840.113556.1.4.1122
systemMayContain: 1.2.840.113556.1.4.1121
systemMayContain: 1.2.840.113556.1.4.1120
systemMayContain: 1.2.840.113556.1.4.1119
systemMayContain: 1.2.840.113556.1.4.1118
systemMayContain: 1.2.840.113556.1.4.1117
systemMayContain: 1.2.840.113556.1.4.1116
systemMayContain: 1.2.840.113556.1.4.1115
systemMayContain: 1.2.840.113556.1.4.1114
systemMayContain: 1.2.840.113556.1.4.1113
systemMayContain: 1.2.840.113556.1.4.1112
systemMayContain: 1.2.840.113556.1.4.1111
systemMayContain: 1.2.840.113556.1.4.1110
systemMayContain: 1.2.840.113556.1.4.1109
systemMayContain: 1.2.840.113556.1.4.1108
systemMayContain: 1.2.840.113556.1.4.1107
systemMayContain: 1.2.840.113556.1.4.1106
systemMayContain: 1.2.840.113556.1.4.1105
systemMayContain: 1.2.840.113556.1.4.1104
systemMayContain: 1.2.840.113556.1.4.1103
systemMayContain: 1.2.840.113556.1.4.1102
systemMayContain: 1.2.840.113556.1.4.1101
systemMayContain: 1.2.840.113556.1.4.1100
systemMayContain: 1.2.840.113556.1.4.1099
systemMayContain: 1.2.840.113556.1.4.1098
systemMayContain: 1.2.840.113556.1.4.1097
systemMayContain: 1.2.840.113556.1.4.1096
systemMayContain: 1.2.840.113556.1.4.1095
systemMayContain: 1.2.840.113556.1.4.1094
systemMayContain: 1.2.840.113556.1.4.1093
systemMayContain: 1.2.840.113556.1.4.1092
systemMayContain: 1.2.840.113556.1.4.1091
systemMayContain: 1.2.840.113556.1.4.1090
systemMayContain: 1.2.840.113556.1.4.1089
systemMayContain: 1.2.840.113556.1.4.1088
systemMayContain: 1.2.840.113556.1.4.1087
systemMayContain: 1.2.840.113556.1.4.1086
systemMayContain: 1.2.840.113556.1.4.1085
systemMayContain: 1.2.840.113556.1.4.1084
systemMayContain: 1.2.840.113556.1.4.1083
systemMayContain: 1.2.840.113556.1.4.1082
systemMayContain: 1.2.840.113556.1.4.1081
systemMayContain: 1.2.840.113556.1.4.1080
systemMayContain: 1.2.840.113556.1.4.1079
systemMayContain: 1.2.840.113556.1.4.1078
systemMayContain: 1.2.840.113556.1.4.1077
systemMayContain: 1.2.840.113556.1.4.1076
systemMayContain: 1.2.840.113556.1.4.1075
systemMayContain: 1.2.840.113556.1.4.1074
systemMayContain: 1.2.840.113556.1.4.1073
systemMayContain: 1.2.840.113556.1.4.1072
systemMayContain: 1.2.840.113556.1.4.1071
systemMayContain: 1.2.840.113556.1.4.1070
systemMayContain: 1.2.840.113556.1.4.1069
systemMayContain: 1.2.840.113556.1.4.1068
systemMayContain: 1.2.840.113556.1.4.1067
systemMayContain: 1.2.840.113556.1.4.1066
systemMayContain: 1.2.840.113556.1.4.1065
systemMayContain: 1.2.840.113556.1.4.1064
systemMayContain: 1.2.840.113556.1.4.1063
systemMayContain: 1.2.840.113556.1.4.1062
systemMayContain: 1.2.840.113556.1.4.1061
systemMayContain: 1.2.840.113556.1.4.1060
systemMayContain: 1.2.840.113556.1.4.1059
systemMayContain: 1.2.840.113556.1.4.1058
systemMayContain: 1.2.840.113556.1.4.1057
systemMayContain: 1.2.840.113556.1.4.1056
systemMayContain: 1.2.840.113556.1.4.1055
systemMayContain: 1.2.840.113556.1.4.1054
systemMayContain: 1.2.840.113556.1.4.1053
systemMayContain: 1.2.840.113556.1.4.1052
systemMayContain: 1.2.840.113556.1.4.1051
systemMayContain: 1.2.840.113556.1.4.1050
systemMayContain: 1.2.840.113556.1.4.1049
systemMayContain: 1.2.840.113556.1.4.1048
systemMayContain: 1.2.840.113556.1.4.1047
systemMayContain: 1.2.840.113556.1.4.1046
systemMayContain: 1.2.840.113556.1.4.1045
systemMayContain: 1.2.840.113556.1.4.1044
systemMayContain: 1.2.840.113556.1.4.1043
systemMayContain: 1.2.840.113556.1.4.1042
systemMayContain: 1.2.840.113556.1.4.1041
systemMayContain: 1.2.840.113556.1.4.1040
systemMayContain: 1.2.840.113556.1.4.1039
systemMayContain: 1.2.840.113556.1.4.1038
systemMayContain: 1.2.840.113556.1.4.1037
systemMayContain: 1.2.840.113556.1.4.1036
systemMayContain: 1.2.840.113556.1.4.1035
systemMayContain: 1.2.840.113556.1.4.1034
systemMayContain: 1.2.840.113556.1.4.1033
systemMayContain: 1.2.840.113556.1.4.1032
systemMayContain: 1.2.840.113556.1.4.1031
systemMayContain: 1.2.840.113556.1.4.1030
systemMayContain: 1.2.840.113556.1.4.1029
systemMayContain: 1.2.840.113556.1.4.1028
systemMayContain: 1.2.840.113556.1.4.1027
systemMayContain: 1.2.840.113556.1.4.1026
systemMayContain: 1.2.840.113556.1.4.1025
systemMayContain: 1.2.840.113556.1.4.1024
systemMayContain: 1.2.840.113556.1.4.1023
systemMayContain: 1.2.840.113556.1.4.1022
systemMayContain: 1.2.840.113556.1.4.1021
systemMayContain: 1.2.840.113556.1.4.1020
systemMayContain: 1.2.840.113556.1.4.1019
systemMayContain: 1.2.840.113556.1.4.1018
systemMayContain: 1.2.840.113556.1.4.1017
systemMayContain: 1.2.840.113556.1.4.1016
systemMayContain: 1.2.840.113556.1.4.1015
systemMayContain: 1.2.840.113556.1.4.1014
systemMayContain: 1.2.840.113556.1.4.1013
systemMayContain: 1.2.840.113556.1.4.1012
systemMayContain: 1.2.840.113556.1.4.1011
systemMayContain: 1.2.840.113556.1.4.1010
systemMayContain: 1.2.840.113556.1.4.1009
systemMayContain: 1.2.840.113556.1.4.1008
systemMayContain: 1.2.840.113556.1.4.1007
systemMayContain: 1.2.840.113556.1.4.1006
systemMayContain: 1.2.840.113556.1.4.1005
systemMayContain: 1.2.840.113556.1.4.1004
systemMayContain: 1.2.840.113556.1.4.1003
systemMayContain: 1.2.840.113556.1.4.1002
systemMayContain: 1.2.840.113556.1.4.1001
systemMayContain: 1.2.840.113556.1.4.1000
systemMayContain: 1.2.840.113556.1.4.999
systemMayContain: 1.2.840.113556.1.4.998
systemMayContain: 1.2.840.113556.1.4.997
systemMayContain: 1.2.840.113556.1.4.996
systemMayContain: 1.2.840.113556.1.4.995
systemMayContain: 1.2.840.113556.1.4.994
systemMayContain: 1.2.840.113556.1.4.993
systemMayContain: 1.2.840.113556.1.4.992
systemMayContain: 1.2.840.113556.1.4.991
systemMayContain: 1.2.840.113556.1.4.990
systemMayContain: 1.2.840.113556.1.4.989
systemMayContain: 1.2.840.113556.1.4.988
systemMayContain: 1.2.840.113556.1.4.987
systemMayContain: 1.2.840.113556.1.4.986
systemMayContain: 1.2.840.113556.1.4.985
systemMayContain: 1.2.840.113556.1.4.984
systemMayContain: 1.2.840.113556.1.4.983
systemMayContain: 1.2.840.113556.1.4.982
systemMayContain: 1.2.840.113556.1.4.981
systemMayContain: 1.2.840.113556.1.4.980
systemMayContain: 1.2.840.113556.1.4.979
systemMayContain: 1.2.840.113556.1.4.978
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 2JAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=msRADIUSProfile,CN=Schema,CN=Configuration,DC=X

dn: CN=MHS-Message-Store,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mHSMessageStore
adminDisplayName: MHS-Message-Store
adminDescription: MHS-Message-Store
governsId: 1.2.840.113556.1.3.56
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemAuxiliaryClass: 1.2.840.113556.1.3.46
systemMustContain: 1.2.840.113556.1.2.241
systemMayContain: 1.2.840.113556.1.2.266
systemMayContain: 1.2.840.113556.1.2.272
systemMayContain: 1.2.840.113556.1.2.458
systemMayContain: 1.2.840.113556.1.2.441
systemMayContain: 1.2.840.113556.1.2.189
systemMayContain: 1.2.840.113556.1.2.106
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: unTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MHS-Message-Store,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-HTTP-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgHTTPSite
adminDisplayName: Protocol-Cfg-HTTP-Site
adminDescription: Protocol-Cfg-HTTP-Site
governsId: 1.2.840.113556.1.3.81
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.79
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: w3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-HTTP-Site,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-NNTP-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgNNTPSite
adminDisplayName: Protocol-Cfg-NNTP-Site
adminDescription: Protocol-Cfg-NNTP-Site
governsId: 1.2.840.113556.1.3.73
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.72
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: zHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-NNTP-Site,CN=Schema,CN=Configuration,DC=X

dn: CN=msRADIUSVendors,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: msRADIUSVendors
adminDisplayName: msRADIUSVendors
adminDescription: msRADIUSVendors
governsId: 1.2.840.113556.1.5.170
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1182
systemMayContain: 1.2.840.113556.1.4.1192
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 3JAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=msRADIUSVendors,CN=Schema,CN=Configuration,DC=X

dn: CN=MTA-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mTACfg
adminDisplayName: MTA-Cfg
adminDescription: MTA-Cfg
governsId: 1.2.840.113556.1.3.3
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.53
systemMayContain: 1.2.840.113556.1.2.67
systemMayContain: 1.2.840.113556.1.2.84
systemMayContain: 1.2.840.113556.1.2.150
systemMayContain: 1.2.840.113556.1.2.142
systemMayContain: 1.2.840.113556.1.2.137
systemMayContain: 1.2.840.113556.1.2.136
systemMayContain: 1.2.840.113556.1.2.133
systemMayContain: 1.2.840.113556.1.2.329
systemMayContain: 1.2.840.113556.1.2.154
systemMayContain: 1.2.840.113556.1.2.153
systemMayContain: 1.2.840.113556.1.2.151
systemMayContain: 1.2.840.113556.1.2.152
systemMayContain: 1.2.840.113556.1.2.143
systemMayContain: 1.2.840.113556.1.2.134
systemMayContain: 1.2.840.113556.1.2.148
systemMayContain: 1.2.840.113556.1.2.453
systemMayContain: 1.2.840.113556.1.2.145
systemMayContain: 1.2.840.113556.1.2.149
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: qHTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MTA-Cfg,CN=Schema,CN=Configuration,DC=X

dn: CN=Virtual-Computer,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: virtualComputer
adminDisplayName: Virtual-Computer
adminDescription: Virtual-Computer
governsId: 1.2.840.113556.1.5.160
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.30
schemaIdGuid:: QsMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Computer,CN=Schema,CN=Configuration,DC=X

dn: CN=msNetworkPolicy,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: msNetworkPolicy
adminDisplayName: msNetworkPolicy
adminDescription: msNetworkPolicy
governsId: 1.2.840.113556.1.5.168
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1131
systemMayContain: 1.2.840.113556.1.4.1135
systemMayContain: 1.2.840.113556.1.4.1134
systemMayContain: 1.2.840.113556.1.4.1129
systemMayContain: 1.2.840.113556.1.4.1126
systemMayContain: 1.2.840.113556.1.4.977
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 2pAM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=msNetworkPolicy,CN=Schema,CN=Configuration,DC=X

dn: CN=MHS-Server-Monitoring-Config,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mHSServerMonitoringConfig
adminDisplayName: MHS-Server-Monitoring-Config
adminDescription: MHS-Server-Monitoring-Config
governsId: 1.2.840.113556.1.3.7
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.6
systemMayContain: 1.2.840.113556.1.2.58
systemMayContain: 1.2.840.113556.1.2.162
systemMayContain: 1.2.840.113556.1.2.60
systemMayContain: 1.2.840.113556.1.2.59
systemMayContain: 1.2.840.113556.1.2.161
systemMayContain: 1.2.840.113556.1.2.160
systemMayContain: 1.2.840.113556.1.2.163
systemMayContain: 1.2.840.113556.1.2.166
systemMayContain: 1.2.840.113556.1.2.177
systemMayContain: 1.2.840.113556.1.2.164
systemMayContain: 1.2.840.113556.1.2.165
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: vXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MHS-Server-Monitoring-Config,CN=Schema,CN=Configuration,DC=X

dn: CN=Cluster-Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: clusterOrganizationalUnit
adminDisplayName: Cluster-Organizational-Unit
adminDescription: Cluster-Organizational-Unit
governsId: 1.2.840.113556.1.5.159
objectClassCategory: 1
rdnAttId: 2.5.4.11
subClassOf: 2.5.6.5
schemaIdGuid:: QcMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Cluster-Organizational-Unit,CN=Schema,CN=Configuration,DC=X

dn: CN=RAS-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rASX400Link
adminDisplayName: RAS-X400-Link
adminDescription: RAS-X400-Link
governsId: 1.2.840.113556.1.3.34
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.29
systemMayContain: 1.2.840.113556.1.2.78
systemMayContain: 1.2.840.113556.1.2.313
systemMayContain: 1.2.840.113556.1.2.314
systemMayContain: 1.2.840.113556.1.2.315
systemMayContain: 1.2.840.113556.1.2.276
systemMayContain: 1.2.840.113556.1.2.193
systemMayContain: 1.2.840.113556.1.2.202
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 1HTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RAS-X400-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=X25-Stack,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: x25Stack
adminDisplayName: X25-Stack
adminDescription: X25-Stack
governsId: 1.2.840.113556.1.3.27
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.18
systemMustContain: 1.2.840.113556.1.2.321
systemMayContain: 1.2.840.113556.1.2.372
systemMayContain: 1.2.840.113556.1.2.318
systemMayContain: 1.2.840.113556.1.2.316
systemPossSuperiors: 1.2.840.113556.1.3.49
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: 3nTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=X25-Stack,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-NNTP-Server,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgNNTPServer
adminDisplayName: Protocol-Cfg-NNTP-Server
adminDescription: Protocol-Cfg-NNTP-Server
governsId: 1.2.840.113556.1.3.74
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.72
systemPossSuperiors: 1.2.840.113556.1.3.67
schemaIdGuid:: y3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-NNTP-Server,CN=Schema,CN=Configuration,DC=X

dn: CN=Residential-Person,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: residentialPerson
adminDisplayName: Residential-Person
adminDescription: Residential-Person
governsId: 2.5.6.10
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.6
systemMayContain: 2.5.4.24
systemMayContain: 2.5.4.12
systemMayContain: 2.5.4.21
systemMayContain: 2.5.4.22
systemMayContain: 2.5.4.9
systemMayContain: 2.5.4.8
systemMayContain: 2.5.4.26
systemMayContain: 2.5.4.28
systemMayContain: 2.5.4.17
systemMayContain: 2.5.4.16
systemMayContain: 2.5.4.18
systemMayContain: 2.5.4.19
systemMayContain: 2.5.4.11
systemMayContain: 2.5.4.7
systemMayContain: 2.5.4.25
systemMayContain: 2.5.4.23
systemMayContain: 2.5.4.27
systemMayContain: 2.5.4.15
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 1nTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Residential-Person,CN=Schema,CN=Configuration,DC=X

dn: CN=TP4-Stack,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: tP4Stack
adminDisplayName: TP4-Stack
adminDescription: TP4-Stack
governsId: 1.2.840.113556.1.3.25
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.18
systemPossSuperiors: 1.2.840.113556.1.3.49
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: 23TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=TP4-Stack,CN=Schema,CN=Configuration,DC=X

dn: CN=MSMQ-Configuration,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mSMQConfiguration
adminDisplayName: MSMQ-Configuration
adminDescription: MSMQ-Configuration
governsId: 1.2.840.113556.1.5.162
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.927
systemMayContain: 1.2.840.113556.1.4.937
systemMayContain: 1.2.840.113556.1.4.930
systemMayContain: 1.2.840.113556.1.4.919
systemMayContain: 1.2.840.113556.1.4.925
systemMayContain: 1.2.840.113556.1.4.928
systemMayContain: 1.2.840.113556.1.4.935
systemMayContain: 1.2.840.113556.1.4.921
systemMayContain: 1.2.840.113556.1.4.929
systemMayContain: 1.2.840.113556.1.4.934
systemMayContain: 1.2.840.113556.1.4.936
systemMayContain: 1.2.840.113556.1.4.933
systemPossSuperiors: 1.2.840.113556.1.3.30
schemaIdGuid:: RMMNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Configuration,CN=Schema,CN=Configuration,DC=X

dn: CN=Local-DXA,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: localDXA
adminDisplayName: Local-DXA
adminDescription: Local-DXA
governsId: 1.2.840.113556.1.3.1
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemAuxiliaryClass: 1.2.840.113556.1.3.46
systemMustContain: 1.2.840.113556.1.2.241
systemMayContain: 1.2.840.113556.1.2.365
systemMayContain: 1.2.840.113556.1.2.364
systemMayContain: 1.2.840.113556.1.2.363
systemMayContain: 1.2.840.113556.1.2.381
systemMayContain: 1.2.840.113556.1.2.189
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: tXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Local-DXA,CN=Schema,CN=Configuration,DC=X

dn: CN=RAS-Stack,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: rASStack
adminDisplayName: RAS-Stack
adminDescription: RAS-Stack
governsId: 1.2.840.113556.1.3.26
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.18
systemMayContain: 1.2.840.113556.1.2.315
systemMayContain: 1.2.840.113556.1.2.236
systemPossSuperiors: 1.2.840.113556.1.3.49
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: container
schemaIdGuid:: 03TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=RAS-Stack,CN=Schema,CN=Configuration,DC=X

dn: CN=Addr-Type,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: addrType
adminDisplayName: Addr-Type
adminDescription: Addr-Type
governsId: 1.2.840.113556.1.3.57
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.2.328
systemMustContain: 1.2.840.113556.1.2.178
systemMustContain: 2.5.4.3
systemMayContain: 1.2.840.113556.1.2.523
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: q3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Addr-Type,CN=Schema,CN=Configuration,DC=X

dn: CN=Organizational-Role,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: organizationalRole
adminDisplayName: Organizational-Role
adminDescription: Organizational-Role
governsId: 2.5.6.8
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.3
systemMayContain: 2.5.4.24
systemMayContain: 2.5.4.21
systemMayContain: 2.5.4.22
systemMayContain: 2.5.4.20
systemMayContain: 2.5.4.9
systemMayContain: 2.5.4.8
systemMayContain: 2.5.4.34
systemMayContain: 2.5.4.33
systemMayContain: 2.5.4.26
systemMayContain: 2.5.4.28
systemMayContain: 2.5.4.17
systemMayContain: 2.5.4.16
systemMayContain: 2.5.4.18
systemMayContain: 2.5.4.19
systemMayContain: 2.5.4.11
systemMayContain: 2.5.4.7
systemMayContain: 2.5.4.25
systemMayContain: 2.5.4.23
systemMayContain: 2.5.4.27
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: v3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Organizational-Role,CN=Schema,CN=Configuration,DC=X

dn: CN=X25-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: x25X400Link
adminDisplayName: X25-X400-Link
adminDescription: X25-X400-Link
governsId: 1.2.840.113556.1.3.35
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.29
systemMayContain: 1.2.840.113556.1.2.373
systemMayContain: 1.2.840.113556.1.2.319
systemMayContain: 1.2.840.113556.1.2.318
systemMayContain: 1.2.840.113556.1.2.317
systemMayContain: 1.2.840.113556.1.2.316
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 33TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=X25-X400-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=msRADIUSDictionary,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: msRADIUSDictionary
adminDisplayName: msRADIUSDictionary
adminDescription: msRADIUSDictionary
governsId: 1.2.840.113556.1.5.169
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1142
systemMustContain: 1.2.840.113556.1.4.1141
systemMayContain: 1.2.840.113556.1.4.1183
systemMayContain: 1.2.840.113556.1.4.1143
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 25AM2/LB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=msRADIUSDictionary,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-POP-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgPOPSite
adminDisplayName: Protocol-Cfg-POP-Site
adminDescription: Protocol-Cfg-POP-Site
governsId: 1.2.840.113556.1.3.70
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.69
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: z3TfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-POP-Site,CN=Schema,CN=Configuration,DC=X


# Make the may-contains of subschema class non-constructed.

dn: CN=Attribute-Types,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemFlags
systemFlags: 8000004
-

dn: CN=DIT-Content-Rules,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemFlags
systemFlags: 8000004
-

dn: CN=Extended-Attribute-Info,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemFlags
systemFlags: 8000004
-

dn: CN=Extended-Class-Info,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemFlags
systemFlags: 8000004
-

dn: CN=Modify-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemFlags
systemFlags: 8000004
-

dn: CN=Object-Classes,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemFlags
systemFlags: 8000004
-

dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=SubSchema,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: subSchema
adminDisplayName: SubSchema
adminDescription: SubSchema
governsId: 2.5.20.1
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 2.5.21.6
systemMayContain: 2.5.18.2
systemMayContain: 1.2.840.113556.1.4.908
systemMayContain: 1.2.840.113556.1.4.909
systemMayContain: 2.5.21.2
systemMayContain: 2.5.21.5
systemPossSuperiors: 1.2.840.113556.1.3.9
schemaIdGuid:: YTKLWo3D0RG7yQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=SubSchema,CN=Schema,CN=Configuration,DC=X

dn: CN=Attribute-Types,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 8000004
-

dn: CN=DIT-Content-Rules,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 8000004
-

dn: CN=Extended-Attribute-Info,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 8000004
-

dn: CN=Extended-Class-Info,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 8000004
-

dn: CN=Modify-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 8000004
-

dn: CN=Object-Classes,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 8000004
-

dn: CN=DX-Requestor,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: dXRequestor
adminDisplayName: DX-Requestor
adminDescription: DX-Requestor
governsId: 1.2.840.113556.1.3.19
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.2
systemMayContain: 1.2.840.113556.1.2.73
systemMayContain: 1.2.840.113556.1.2.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: rnTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=DX-Requestor,CN=Schema,CN=Configuration,DC=X

dn: CN=TP4-X400-Link,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: tP4X400Link
adminDisplayName: TP4-X400-Link
adminDescription: TP4-X400-Link
governsId: 1.2.840.113556.1.3.33
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.29
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 3HTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=TP4-X400-Link,CN=Schema,CN=Configuration,DC=X

dn: CN=MSMQ-Queue,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: mSMQQueue
adminDisplayName: MSMQ-Queue
adminDescription: MSMQ-Queue
governsId: 1.2.840.113556.1.5.161
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.926
systemMayContain: 1.2.840.113556.1.4.919
systemMayContain: 1.2.840.113556.1.4.917
systemMayContain: 1.2.840.113556.1.4.924
systemMayContain: 1.2.840.113556.1.4.925
systemMayContain: 1.2.840.113556.1.4.922
systemMayContain: 1.2.840.113556.1.4.921
systemMayContain: 1.2.840.113556.1.4.918
systemMayContain: 1.2.840.113556.1.4.920
systemMayContain: 1.2.840.113556.1.4.923
systemPossSuperiors: 1.2.840.113556.1.5.162
schemaIdGuid:: Q8MNmgDB0RG7xQCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Queue,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-LDAP-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgLDAPSite
adminDisplayName: Protocol-Cfg-LDAP-Site
adminDescription: Protocol-Cfg-LDAP-Site
governsId: 1.2.840.113556.1.3.76
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.75
systemMayContain: 1.2.840.113556.1.2.510
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: yXTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-LDAP-Site,CN=Schema,CN=Configuration,DC=X

dn: CN=Protocol-Cfg-IMAP-Site,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: classSchema
ldapDisplayName: protocolCfgIMAPSite
adminDisplayName: Protocol-Cfg-IMAP-Site
adminDescription: Protocol-Cfg-IMAP-Site
governsId: 1.2.840.113556.1.3.86
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.84
systemPossSuperiors: 1.2.840.113556.1.3.66
schemaIdGuid:: xnTfqOrF0RG7ywCAx2ZwwA==
hideFromAB: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Protocol-Cfg-IMAP-Site,CN=Schema,CN=Configuration,DC=X

# Modifies

dn: CN=Class-Schema,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 134217728
-

dn: CN=Attribute-Schema,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 134217728
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1212
-

dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: mail
-

dn: CN=Contact,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: c
-


dn: CN=RID-Available-Pool,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: systemOnly
systemOnly: FALSE
-

dn: CN=Activation-Schedule,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: rangeUpper
rangeUpper: 84
-
add: rangeLower
rangeLower: 84
-


dn: CN=Extension-Attribute-1,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute1
-

dn: CN=Extension-Attribute-2,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute2
-

dn: CN=Extension-Attribute-3,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute3
-

dn: CN=Extension-Attribute-4,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute4
-

dn: CN=Extension-Attribute-5,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute5
-

dn: CN=Extension-Attribute-6,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute6
-

dn: CN=Extension-Attribute-7,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute7
-

dn: CN=Extension-Attribute-8,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute8
-

dn: CN=Extension-Attribute-9,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute9
-

dn: CN=Extension-Attribute-10,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: ldapDisplayName
ldapDisplayName: extensionAttribute10
-

dn: CN=Common-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=E-mail-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Manager,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Description,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Display-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Attribute-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Comment,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Proxied-Object-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemFlags
systemFlags: 2
-

dn: CN=Trust-Partner,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 1
-

dn: CN=User-Cert,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=User-SMIME-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Department,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=User-Principal-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Company,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Alternate-Security-Identities,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Division,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Display-Name-Printable,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Alt-Security-Identities,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Reports,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Flat-Name,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: searchFlags
searchFlags: 1
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.290
systemMayContain: 1.2.840.113556.1.2.291
systemMayContain: 1.2.840.113556.1.2.292
systemMayContain: 1.2.840.113556.1.2.293
systemMayContain: 1.2.840.113556.1.2.339
systemMayContain: 1.2.840.113556.1.2.340
systemMayContain: 1.2.840.113556.1.2.341
systemMayContain: 1.2.840.113556.1.2.342
systemMayContain: 1.2.840.113556.1.2.469
systemMayContain: 1.2.840.113556.1.4.618
-

dn: CN=Organizational-Person,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.25
-

dn: CN=ACS-Policy,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.897
-

dn: CN=Group-Of-Names,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.206
systemMayContain: 1.2.840.113556.1.2.207
systemMayContain: 1.2.840.113556.1.2.297
systemMayContain: 1.2.840.113556.1.2.330
systemMayContain: 1.2.840.113556.1.2.438
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.947
systemMayContain: 1.2.840.113556.1.4.948
systemMayContain: 1.2.840.113556.1.4.1119
systemMayContain: 1.2.840.113556.1.4.1124
systemMayContain: 1.2.840.113556.1.4.1130
systemMayContain: 1.2.840.113556.1.4.1145
systemMayContain: 1.2.840.113556.1.4.1153
systemMayContain: 1.2.840.113556.1.4.1158
systemMayContain: 1.2.840.113556.1.4.1189
systemMayContain: 1.2.840.113556.1.4.1190
systemMayContain: 1.2.840.113556.1.4.1191
-

dn: CN=ACS-Subnet,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.898
systemMayContain: 1.2.840.113556.1.4.899
systemMayContain: 1.2.840.113556.1.4.900
systemMayContain: 1.2.840.113556.1.4.901
systemMayContain: 1.2.840.113556.1.4.902
-

dn: CN=Application-Entity,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMustContain
systemMustContain: 2.5.4.29
-

dn: CN=Certification-Authority,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.562
systemMayContain: 1.2.840.113556.1.2.563
systemMayContain: 1.2.840.113556.1.2.564
systemMayContain: 1.2.840.113556.1.2.565
systemMayContain: 1.2.840.113556.1.2.566
systemMayContain: 1.2.840.113556.1.2.567
-

dn: CN=Server,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.452
systemMayContain: 1.2.840.113556.1.4.515
systemMayContain: 2.5.4.5
-

dn: CN=Mailbox,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.79
systemMayContain: 1.2.840.113556.1.2.444
systemMayContain: 1.2.840.113556.1.2.596
systemMayContain: 1.2.840.113556.1.2.607
systemMayContain: 1.2.840.113556.1.2.608
systemMayContain: 1.2.840.113556.1.2.609
systemMayContain: 1.2.840.113556.1.2.610
systemMayContain: 1.2.840.113556.1.2.611
systemMayContain: 1.2.840.113556.1.2.612
systemMayContain: 1.2.840.113556.1.2.613
systemMayContain: 1.2.840.113556.1.4.1213
-

dn: CN=Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.17
systemPossSuperiors: 1.2.840.113556.1.5.161
-

dn: CN=Print-Queue,CN=Schema,CN=Configuration,DC=X
changetype: modify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.141
systemMayContain: 1.2.840.113556.1.4.223
systemMayContain: 1.2.840.113556.1.4.300
-
add: systemMustContain
systemMustContain: 1.2.840.113556.1.4.141
systemMustContain: 1.2.840.113556.1.4.223
systemMustContain: 1.2.840.113556.1.4.300
systemMustContain: 1.2.840.113556.1.4.1209
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Site,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.953
-

dn: CN=Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.47
systemMayContain: 1.2.840.113556.1.2.144
systemMayContain: 1.2.840.113556.1.2.221
systemMayContain: 0.9.2342.19200300.100.1.2
systemMayContain: 1.2.840.113556.1.2.129
-

dn: CN=Remote-Address,CN=Schema,CN=Configuration,DC=X
changetype: modify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.79
systemMayContain: 1.2.840.113556.1.2.444
systemMayContain: 1.2.840.113556.1.2.596
systemMayContain: 1.2.840.113556.1.2.609
systemMayContain: 1.2.840.113556.1.2.610
systemMayContain: 1.2.840.113556.1.2.611
systemMayContain: 1.2.840.113556.1.2.612
systemMayContain: 1.2.840.113556.1.2.613
systemMayContain: 1.2.840.113556.1.4.1213
-

dn: CN=When-Created,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: omSyntax
omSyntax: 24
-

dn: CN=When-Changed,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: omSyntax
omSyntax: 24
-

dn: CN=Schema-Update,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: omSyntax
omSyntax: 24
-

dn: CN=Schema-Update-Now,CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: omSyntax
omSyntax: 24
-




dn:
changetype: modify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Aggregate,CN=Schema,CN=Configuration,DC=X
changetype: add
objectClass: subschema


dn: CN=User-Change-Password,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
-
replace: displayName
displayName: Change Password
-

dn: CN=Send-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
-

dn: CN=Receive-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
-

dn: CN=Email-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: bf967a9c-0de6-11d0-a285-00aa003049e2
-

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 5cb41ed0-0e4c-11d0-a286-00aa003049e2
-

dn: CN=Web-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: modify
add: appliesTo
appliesTo: 5cb41ed0-0e4c-11d0-a286-00aa003049e2
-

dn: CN=Public-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: add
objectClass: controlAccessRight
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
displayName: Public Information
rightsGUID: e48d0154-bcf8-11d1-8702-00c04fb96050
hideFromAB: TRUE

dn: CN=RRAS,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAb: TRUE

dn: CN=Radius,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAb: TRUE

dn: CN=EAPEntries,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAb: TRUE

dn: CN=IdentityDictionary,CN=RRAS,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: rRASAdministrationDictionary
hideFromAb: TRUE
msRRASVendorAttributeEntry: 311:0:8:RIP (version 1 or 2)
msRRASVendorAttributeEntry: 311:0:13:OSPF
msRRASVendorAttributeEntry: 311:1:10:IGMP Only
msRRASVendorAttributeEntry: 311::5:1:IPX RIP
msRRASVendorAttributeEntry: 311:5:2:IPX SAP
msRRASVendorAttributeEntry: 311:6:501:IP Forwarding Enabled
msRRASVendorAttributeEntry: 311:6:502:IPX Forwarding Enabled
msRRASVendorAttributeEntry: 311:6:503:AppleTalk Forwarding Enabled
msRRASVendorAttributeEntry: 311:6:601:LAN-to- LAN Router
msRRASVendorAttributeEntry: 311:6:602:Remote Access Server
msRRASVendorAttributeEntry: 311:6:603:Demand Dial Router
msRRASVendorAttributeEntry: 311:6:604:Network Address and Port Translation
msRRASVendorAttributeEntry: 311:6:701:Point-to-Point Tunneling Protocol
msRRASVendorAttributeEntry: 311:6:702:Layer 2 Tunneling Protocol
msRRASVendorAttributeEntry: 311:6:703:Frame Relay
msRRASVendorAttributeEntry: 311:6:704:ATM
msRRASVendorAttributeEntry: 311:6:705:ISDN
msRRASVendorAttributeEntry: 311:6:706:Modem
msRRASVendorAttributeEntry: 311:6:707:SONET
msRRASVendorAttributeEntry: 311:6:708:Switched 56
msRRASVendorAttributeEntry: 311:6:709:IrDA
msRRASVendorAttributeEntry: 311:6:710:X.25
msRRASVendorAttributeEntry: 311:6:711:Generic WAN
msRRASVendorAttributeEntry: 311:6:712:Generic LAN
msRRASVendorAttributeEntry: 311:6:713:Point to point serial connection
msRRASVendorAttributeEntry: 311:6:714:Point to point parallel connection
msRRASVendorAttributeEntry: 311:6:801:NT Domain Authentication
msRRASVendorAttributeEntry: 311:6:802:RADIUS Authentication
msRRASVendorAttributeEntry: 311:6:803:RADIUS Accouting

dn: CN=RadiusProfiles,CN=Radius,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAB: TRUE

dn: CN=NetworkPolicy,CN=Radius,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAB: TRUE

dn: CN=Dictionary,CN=Radius,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAB: TRUE

dn: CN=Vendors,CN=Radius,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: container
hideFromAB: TRUE

dn: CN=MD5 Challenge,CN=EAPEntries,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: EAP
msRADIUSEapTypeID: 4
msRADIUSEapKeyFlag: TRUE
hideFromAB: TRUE

dn: CN=Transport Layer Security,CN=EAPEntries,CN=Services,CN=Configuration,DC=X
changetype: add
objectClass: EAP
msRADIUSEapTypeID: 13
msRADIUSEapKeyFlag: TRUE
hideFromAB: TRUE

dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: modify
delete: lDAPAdminLimits
lDAPAdminLimits: MaxDatagramRecv=4096
-
add: lDAPAdminLimits
lDAPAdminLimits: MaxDatagramRecv=1024
-

dn: CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: objectVersion
objectVersion: 4
-

```

### Sch5.ldf

```
Does not exist
```

### Sch6.ldf

```
dn: CN=Hide-From-Address-Book,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Show-In-Advanced-View-Only
deleteoldrdn: 1

dn: CN=Show-In-Advanced-View-Only,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDisplayName
adminDisplayName: Show-In-Advanced-View-Only
-
replace: adminDescription
adminDescription: Show-In-Advanced-View-Only
-
replace: ldapDisplayName
ldapDisplayName: showInAdvancedViewOnly
-

dn: CN=Creation-Time,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: ldapDisplayName
ldapDisplayName: creationTime
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=Create-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: createTimeStamp
adminDescription: Create-Time-Stamp
adminDisplayName: Create-Time-Stamp
attributeID: 2.5.18.1
attributeSyntax: 2.5.5.11
oMSyntax: 24
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIDGUID:: cw35LZ8A0hGqTADAT9fYOg==
systemFlags: 134217732
showInAdvancedViewOnly: TRUE



dn: CN=msCiscoAV,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCiscoAV
adminDisplayName: msCiscoAV
adminDescription: msCiscoAV
attributeId: 1.2.840.113556.1.4.1230
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eg35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=Parent-GUID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: parentGUID
adminDisplayName: Parent-GUID
adminDescription: Parent-GUID
attributeId: 1.2.840.113556.1.4.1224
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: dA35LZ8A0hGqTADAT9fYOg==
systemFlags: 134217732
showInAdvancedViewOnly: TRUE

dn: CN=msNPAction,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msNPAction
adminDisplayName: msNPAction
adminDescription: msNPAction
attributeId: 1.2.840.113556.1.4.1234
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fg35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=msRASFilter,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msRASFilter
adminDisplayName: msRASFilter
adminDescription: msRASFilter
attributeId: 1.2.840.113556.1.4.1229
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eQ35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Ds-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQDsService
adminDisplayName: MSMQ-Ds-Service
adminDescription: MSMQ-Ds-Service
attributeId: 1.2.840.113556.1.4.1238
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gg35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=Netboot-SIF-File,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: netbootSIFFile
adminDisplayName: Netboot-SIF-File
adminDescription: Netboot-SIF-File
attributeId: 1.2.840.113556.1.4.1240
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hA35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Ds-Services,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQDsServices
adminDisplayName: MSMQ-Ds-Services
adminDescription: MSMQ-Ds-Services
attributeId: 1.2.840.113556.1.4.1228
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eA35LZ8A0hGqTADAT9fYOg==
isMemberOfPartialAttributeSet: TRUE
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Queue-Name-Ext,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQQueueNameExt
adminDisplayName: MSMQ-Queue-Name-Ext
adminDescription: MSMQ-Queue-Name-Ext
attributeId: 1.2.840.113556.1.4.1243
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 92
schemaIdGuid:: hw35LZ8A0hGqTADAT9fYOg==
isMemberOfPartialAttributeSet: TRUE
showInAdvancedViewOnly: TRUE

dn: CN=DN-Reference-Update,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: dNReferenceUpdate
adminDisplayName: DN-Reference-Update
adminDescription: DN-Reference-Update
attributeId: 1.2.840.113556.1.4.1242
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: hg35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Prev-Site-Gates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQPrevSiteGates
adminDisplayName: MSMQ-Prev-Site-Gates
adminDescription: MSMQ-Prev-Site-Gates
attributeId: 1.2.840.113556.1.4.1225
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: dQ35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Routing-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQRoutingService
adminDisplayName: MSMQ-Routing-Service
adminDescription: MSMQ-Routing-Service
attributeId: 1.2.840.113556.1.4.1237
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gQ35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Routing-Services,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQRoutingServices
adminDisplayName: MSMQ-Routing-Services
adminDescription: MSMQ-Routing-Services
attributeId: 1.2.840.113556.1.4.1227
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dw35LZ8A0hGqTADAT9fYOg==
isMemberOfPartialAttributeSet: TRUE
showInAdvancedViewOnly: TRUE

dn: CN=msRADIUSReplyMessage,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msRADIUSReplyMessage
adminDisplayName: msRADIUSReplyMessage
adminDescription: msRADIUSReplyMessage
attributeId: 1.2.840.113556.1.4.1235
attributeSyntax: 2.5.5.5
omSyntax: 22
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fw35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=Netboot-Mirror-Data-File,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: netbootMirrorDataFile
adminDisplayName: Netboot-Mirror-Data-File
adminDescription: Netboot-Mirror-Data-File
attributeId: 1.2.840.113556.1.4.1241
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hQ35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=msNPOverrideUserDialin,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msNPOverrideUserDialin
adminDisplayName: msNPOverrideUserDialin
adminDescription: msNPOverrideUserDialin
attributeId: 1.2.840.113556.1.4.1233
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fQ35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE


dn: CN=msNPAuthenticationType2,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msNPAuthenticationType2
adminDisplayName: msNPAuthenticationType2
adminDescription: msNPAuthenticationType2
attributeId: 1.2.840.113556.1.4.1236
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gA35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Dependent-Client-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQDependentClientService
adminDisplayName: MSMQ-Dependent-Client-Service
adminDescription: MSMQ-Dependent-Client-Service
attributeId: 1.2.840.113556.1.4.1239
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gw35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=msRADIUSRasServerGroupGUID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msRADIUSRasServerGroupGUID
adminDisplayName: msRADIUSRasServerGroupGUID
adminDescription: msRADIUSRasServerGroupGUID
attributeId: 1.2.840.113556.1.4.1231
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ew35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Dependent-Client-Services,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQDependentClientServices
adminDisplayName: MSMQ-Dependent-Client-Services
adminDescription: MSMQ-Dependent-Client-Services
attributeId: 1.2.840.113556.1.4.1226
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: dg35LZ8A0hGqTADAT9fYOg==
isMemberOfPartialAttributeSet: TRUE
showInAdvancedViewOnly: TRUE

dn: CN=msRADIUSRasServerSetupFlags,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msRADIUSRasServerSetupFlags
adminDisplayName: msRADIUSRasServerSetupFlags
adminDescription: msRADIUSRasServerSetupFlags
attributeId: 1.2.840.113556.1.4.1232
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fA35LZ8A0hGqTADAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=Address-Book-Roots,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: addressBookRoots
adminDisplayName: Address-Book-Roots
adminDescription: Address-Book-Roots
attributeId: 1.2.840.113556.1.4.1244
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: SG4L9/QG0hGqUwDAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=Global-Address-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: globalAddressList
adminDisplayName: Global-Address-List
adminDescription: Global-Address-List
attributeId: 1.2.840.113556.1.4.1245
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: SMdU9/QG0hGqUwDAT9fYOg==
showInAdvancedViewOnly: TRUE

dn: CN=Infrastructure-Update,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: infrastructureUpdate
adminDisplayName: Infrastructure-Update
adminDescription: Infrastructure-Update
governsId: 1.2.840.113556.1.5.175
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1242
systemPossSuperiors: 1.2.840.113556.1.5.175
systemPossSuperiors: 1.2.840.113556.1.5.66
schemaIdGuid:: iQ35LZ8A0hGqTADAT9fYOg==
defaultHidingValue: TRUE
systemOnly: TRUE
defaultObjectCategory: CN=Infrastructure-Update,CN=Schema,CN=Configuration,DC=X
showInAdvancedViewOnly: TRUE

dn: CN=msRADIUSConfigSettings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msRADIUSConfigSettings
adminDisplayName: msRADIUSConfigSettings
adminDescription: msRADIUSConfigSettings
governsId: 1.2.840.113556.1.5.174
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1232
systemMayContain: 1.2.840.113556.1.4.1231
systemMayContain: 1.2.840.113556.1.4.1233
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: iA35LZ8A0hGqTADAT9fYOg==
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=msRADIUSConfigSettings,CN=Schema,CN=Configuration,DC=X
showInAdvancedViewOnly: TRUE

dn: CN=msExch-Configuration-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msExchConfigurationContainer
adminDisplayName: msExch-Configuration-Container
adminDescription: msExch-Configuration-Container
governsId: 1.2.840.113556.1.5.176
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.3.23
systemMayContain: 1.2.840.113556.1.4.1244
systemMayContain: 1.2.840.113556.1.4.1245
schemaIdGuid:: WGg90PQG0hGqUwDAT9fYOg==
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=msExch-Configuration-Container,CN=Schema,CN=Configuration,DC=X


dn: CN=Display-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeLower
rangeLower: 0
-
replace: attributeSecurityGUID
attributeSecurityGUID:: Qi+6WaJ50BGQIADAT8LTzw==
-

dn: CN=MSMQ-Site-Gates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: oMObjectClass
oMObjectClass:: KwwCh3McAIVK
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCRCWOWDSDSW;;;DA)(A;;RPWPCRCCDCLCRCWOWDSDSW;;;SY)(A;;RPLCRC;;;AU)(OA;;CR;edacfd8f-ffb3-11d1-b41d-00a0c968f939;;AU)S:(AU;SAFA;WDWOSDWPCRCCDCSW;;;WD)
-

dn: CN=Dns-Zone,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;ED)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;CC;;;AU)(A;;RPLCLORC;;;WD)S:(AU;SAFA;WDWOSDDTWPCRCCDCSW;;;WD)
-

dn: CN=Dns-Node,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;ED)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)(A;;RPLCLORC;;;WD)S:(AU;SAFA;WDWOSDDTWPCRCCDCSW;;;WD)
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RP;;;WD)(OA;;RPWPCR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RPWPCR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RPWPCR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RPWPCR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;RPWPCR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;RPWPCR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(A;;RPLCRC;;;AU)(A;;RPWPCRLCLOCCRCWDWOSW;;;DA)(A;CIOI;RPWPCRLCLOCCRCWDWOSDSW;;;BA)(A;;RPWPCRLCLOCCDCRCWDWOSDSW;;;SY)S:(AU;SAFA;WDWOSDWPCRCCDCSW;;;WD)
-

dn: CN=Domain-DNS,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RP;;;WD)(OA;;RPWPCR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RPWPCR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RPWPCR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RPWPCR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;RPWPCR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;RPWPCR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(A;;RPLCRC;;;AU)(A;;RPWPCRLCLOCCDCRCWDWOSW;;;DA)(A;CIOI;RPWPCRLCLOCCRCWDWOSDSW;;;BA)(A;;RPWPCRLCLOCCDCRCWDWOSDSW;;;SY)S:(AU;SAFA;WDWOSDWPCRCCDCSW;;;WD)
-


dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 2.5.18.1
systemMayContain: 2.5.18.2
-

dn: CN=RID-Set,CN=Schema,CN=configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: User
-

dn: CN=NTFRS-Subscriptions,CN=Schema,CN=configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: User
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1171
-

dn: CN=Contact,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemAuxiliaryClass
systemAuxiliaryClass: 1.2.840.113556.1.3.46
-

dn: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: FALSE
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1240
systemMayContain: 1.2.840.113556.1.4.1241
-

dn: CN=MSMQ-Queue,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1243
-

dn: CN=MSMQ-Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1226
systemMayContain: 1.2.840.113556.1.4.1227
systemMayContain: 1.2.840.113556.1.4.1228
-

dn: CN=MSMQ-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1237
systemMayContain: 1.2.840.113556.1.4.1238
systemMayContain: 1.2.840.113556.1.4.1239
-

dn: CN=msRADIUSProfile,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1229
systemMayContain: 1.2.840.113556.1.4.1230
systemMayContain: 1.2.840.113556.1.4.1233
systemMayContain: 1.2.840.113556.1.4.1235
systemMayContain: 1.2.840.113556.1.4.1236
-

dn: CN=msNetworkPolicy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1234
-

dn: CN=Postal-Address,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: mAPIID
mAPIID: 33036
-

dn: CN=Company,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: mAPIID
mAPIID: 14870
-

dn: CN=Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: mAPIID
mAPIID: 14856
-

dn: CN=Phone-Pager-Other,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: mAPIID
mAPIID: 35950
-

# Delete Owner's and owner-BL's mapiid before adding the same
# to Managed-By and Managed-Objects.

dn: CN=Owner,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Owner-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Managed-By,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mAPIID
mAPIID: 32780
-

dn: CN=Managed-Objects,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mAPIID
mAPIID: 32804
-

dn: CN=Auth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Unauth-Orig,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=DL-Mem-Submit-Perms,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=DL-Mem-Reject-Perms,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Presentation-Address,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Additional-Information,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Tagged-X509-Cert,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mAPIID
-

dn: CN=Show-In-Address-Book,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Legacy-Exchange-DN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=msNPAllowDialin,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=msNPCallingStationId,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=msNPConstraint,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=msRADIUSCallbackNumber,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=msRADIUSFramedIPAddress,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=msRADIUSFramedRoute,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=msRADIUSServiceType,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: +IhwA+EK0hG0IgCgyWj5OQ==
-

dn: CN=Obj-Dist-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Object-Guid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=System-Flags,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Allowed-Attributes,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Allowed-Attributes-Effective,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Allowed-Child-Classes,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Allowed-Child-Classes-Effective,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=COM-ClassID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: rangeLower
-
delete: rangeUpper
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-


# New Extended right add

dn: CN=Apply-Group-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
rightsGUID: edacfd8f-ffb3-11d1-b41d-00a0c968f939
displayName: Apply Group Policy
appliesTo: f30e3bc2-9ff0-11d1-b603-0000f80367c1

dn: CN=RAS-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
displayName: Remote Access Information
rightsGUID: 037088f8-0ae1-11d2-b422-00a0c968f939

# Modify exisiting Extended right

# Modrdns in config container require FLAG_CONFIG_ALLOW_RENAME
# For all such renames, we will set the flag, rename, and then
# delete the flag. Currently, none of the objects modified here
# has the flag set. The flag is 0x40000000, we set the decimal

dn: CN=msmq-Open-Conector,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=msmq-Open-Conector,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: msmq-Open-Connector
deleteoldrdn: 1

dn: CN=msmq-Open-Connector,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

# Display Specifier Changes

dn: CN=user-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: userFullName,User Full Name
-
add: attributeDisplayNames
attributeDisplayNames: displayName,Display Name
-

dn: CN=user-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-
delete: adminContextMenu
adminContextMenu: 2,{8c5b1b50-d46e-11d1-8091-00a024c48131}
-
delete: adminPropertyPages
adminPropertyPages: 7,{8c5b1b50-d46e-11d1-8091-00a024c48131}
-

dn: CN=group-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=domainDNS-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=contact-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=domainPolicy-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=localPolicy-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=serviceAdministrationPoint-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=computer-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=printQueue-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=site-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=server-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTDSSettings-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTDSDSA-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTDSConnection-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTFRSSettings-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTFRSReplicaSet-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=subnet-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=siteLink-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=siteLinkBridge-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=interSiteTransport-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=licensingSiteSettings-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTDSSiteSettings-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTFRSMember-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTFRSSubscriber-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTFRSSubscriptions-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=organizationalUnit-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=container-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=rpcContainer-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=trustedDomain-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=volume-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=sitesContainer-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=interSiteTransportContainer-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=subnetContainer-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=serversContainer-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=nTDSService-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=queryPolicy-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminContextMenu
adminContextMenu: 0,{6971d64e-f335-11d0-b0bc-00c04fd8dca6}
-

dn: CN=mSMQQueue-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: creationWizard
creationWizard: {E62F8206-B71C-11D1-808D-00A024C48131}
-

dn: CN=mSMQSiteLink-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: creationWizard
creationWizard: {87b31390-d46d-11d1-8091-00a024c48131}
-

dn: CN=remoteStorageServicePoint-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Remote Storage Service
-
delete: adminContextMenu
adminContextMenu: 0,&Manage ...,RsAdmin.msc
-
add: adminContextMenu
adminContextMenu: 0,&Manage...,RsAdmin.msc
-

dn: CN=foreignSecurityPrincipal-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: displaySpecifier
adminPropertyPages: 1,{6dfe6486-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminContextMenu: 1,{08eb4fa6-6ffd-11d1-b0e0-00c04fd8dca6}
classDisplayName: Foreign Security Principal
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
showInAdvancedViewOnly: TRUE

dn: CN=Settings,CN=Radius,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: container
showInAdvancedViewOnly: TRUE


# name change for well-known-security-principals

dn: CN=CreatorOwner,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=CreatorOwner,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Creator Owner
deleteoldrdn: 1

dn: CN=Creator Owner,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=CreatorGroup,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=CreatorGroup,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Creator Group
deleteoldrdn: 1

dn: CN=Creator Group,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=PrincipalSelf,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=PrincipalSelf,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Principal Self
deleteoldrdn: 1

dn: CN=Principal Self,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=AuthenticatedUser,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=AuthenticatedUser,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Authenticated User
deleteoldrdn: 1

dn: CN=Authenticated User,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-


# Update schema version

dn: CN=Schema,CN=Configuration,DC=X
changetype: modify
replace: objectVersion
objectVersion: 6
-

```

### Sch7.ldf

```
dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.606
-

dn: CN=Proxied-Object-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Proxied-Object-Name-Unused
deleteoldrdn: 1

dn: CN=Proxied-Object-Name-Unused,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDisplayName
adminDisplayName: Proxied-Object-Name-Unused
-
replace: adminDescription
adminDescription: Proxied-Object-Name-Unused
-
replace: ldapDisplayName
ldapDisplayName: proxiedObjectNameUnused
-
replace: schemaIdGuid
schemaIdGuid:: X55550su0hG6vZjY/cfjDw==
-

dn: CN=Proxied-Object-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: proxiedObjectName
adminDisplayName: Proxied-Object-Name
adminDescription: Proxied-Object-Name
attributeId: 1.2.840.113556.1.4.1249
attributeSyntax: 2.5.5.7
omSyntax: 127
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: AqSu4VvN0BGv/wAA+ANnwQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 2

dn: CN=Proxied-Object-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: omObjectClass
omObjectClass:: KoZIhvcUAQEBCw==
-

dn: CN=Inter-Site-Topology-Renew,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: interSiteTopologyRenew
adminDisplayName: Inter-Site-Topology-Renew
adminDescription: Inter-Site-Topology-Renew
attributeId: 1.2.840.113556.1.4.1247
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: X57Gt8cs0hGFTgCgyYP2CA==
showInAdvancedViewOnly: TRUE

dn: CN=Inter-Site-Topology-Failover,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: interSiteTopologyFailover
adminDisplayName: Inter-Site-Topology-Failover
adminDescription: Inter-Site-Topology-Failover
attributeId: 1.2.840.113556.1.4.1248
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: YJ7Gt8cs0hGFTgCgyYP2CA==
showInAdvancedViewOnly: TRUE

dn: CN=Inter-Site-Topology-Generator,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: interSiteTopologyGenerator
adminDisplayName: Inter-Site-Topology-Generator
adminDescription: Inter-Site-Topology-Generator
attributeId: 1.2.840.113556.1.4.1246
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: Xp7Gt8cs0hGFTgCgyYP2CA==
showInAdvancedViewOnly: TRUE

dn: CN=Token-Groups,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: tokenGroups
adminDisplayName: Token-Groups
adminDescription: Token-Groups
attributeId: 1.2.840.113556.1.4.1301
attributeSyntax: 2.5.5.17
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bZ7Gt8cs0hGFTgCgyYP2CA==
attributeSecurityGuid:: ksMPBN8z0hGYsgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 134217732

dn: CN=Token-Groups-No-GC-Acceptable,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: tokenGroupsNoGCAcceptable
adminDisplayName: Token-Groups-No-GC-Acceptable
adminDescription: Token-Groups-No-GC-Acceptable
attributeId: 1.2.840.113556.1.4.1303
attributeSyntax: 2.5.5.17
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ksMPBN8z0hGYsgAA+HpX1A==
attributeSecurityGuid:: ksMPBN8z0hGYsgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 134217732

dn: CN=SD-Rights-Effective,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: sDRightsEffective
adminDisplayName: SD-Rights-Effective
adminDescription: SD-Rights-Effective
attributeId: 1.2.840.113556.1.4.1304
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pq/bw98z0hGYsgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 134217732

dn: CN=Parent-GUID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 134217732
-

dn: CN=DN-Reference-Update,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Sub-Class-Of,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Object-Class,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Instance-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=RDN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=Object-Guid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=Repl-Property-Meta-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=User-Account-Control,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=NC-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=USN-Created,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=Governs-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Attribute-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Attribute-Syntax,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Obj-Dist-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=USN-Changed,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=Legacy-Exchange-DN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 13
-

dn: CN=Object-Sid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=SAM-Account-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 13
-

dn: CN=OM-Syntax,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=Group-Type,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=NT-Security-Descriptor,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=System-Flags,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 8
-

dn: CN=MSMQ-Owner-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=LDAP-Display-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1249
systemMayContain: 1.2.840.113556.1.4.1304
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.549
systemMayContain: 1.2.840.113556.1.4.550
systemMayContain: 1.2.840.113556.1.4.551
systemMayContain: 1.2.840.113556.1.4.552
systemMayContain: 1.2.840.113556.1.4.553
systemMayContain: 1.2.840.113556.1.4.554
systemMayContain: 1.2.840.113556.1.4.555
systemMayContain: 1.2.840.113556.1.4.556
-

dn: CN=DHCP-Class,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=Sam-Server,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.145
systemMayContain: 1.2.840.113556.1.2.281
-

dn: CN=Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1301
systemMayContain: 1.2.840.113556.1.4.1303
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.194
systemMayContain: 1.2.840.113556.1.2.226
systemMayContain: 1.2.840.113556.1.4.112
systemMayContain: 1.2.840.113556.1.4.145
systemMayContain: 1.2.840.113556.1.4.201
-

dn: CN=Organizational-Person,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.4
systemMayContain: 2.5.4.20
-

dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=DMD,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.482
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.25
-

dn: CN=Cross-Ref,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.557
-

dn: CN=Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=Certification-Authority,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.69
-

dn: CN=Server,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.452
systemMayContain: 1.2.840.113556.1.4.69
-

dn: CN=Domain-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.13
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.69
systemMayContain: 1.2.840.113556.1.4.344
systemMayContain: 1.2.840.113556.1.4.345
systemMayContain: 1.2.840.113556.1.4.771
systemMayContain: 2.5.4.13
systemMayContain: 2.5.4.36
-

dn: CN=Site,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.211
-

dn: CN=MSMQ-Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=MSMQ-Enterprise-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=MSMQ-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Mail-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.13
systemMayContain: 1.2.840.113556.1.2.169
systemMayContain: 1.2.840.113556.1.2.210
systemMayContain: 1.2.840.113556.1.2.353
systemMayContain: 1.2.840.113556.1.2.464
-

dn: CN=NTDS-DSA,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.211
-

dn: CN=Application-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=Application-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 2.5.4.13
-

dn: CN=NTDS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1246
systemMayContain: 1.2.840.113556.1.4.1247
systemMayContain: 1.2.840.113556.1.4.1248
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.211
-

dn: CN=Foreign-Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.13
-

dn: CN=Control-Access-Right,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.13
-

dn: CN=Assoc-Remote-DXA,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: LinkID
LinkID: 123
-

dn: CN=NNTP-Newsfeeds,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: LinkID
LinkID: 141
-

dn: CN=Supporting-Stack-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: LinkID
LinkID: 133
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-


# name change for MSMQ objects

dn: CN=msmq-Peak-Dead-Letter,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=msmq-Peak-Dead-Letter,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: msmq-Peek-Dead-Letter
deleteoldrdn: 1

dn: CN=msmq-Peek-Dead-Letter,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=msmq-Receive-machine-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=msmq-Receive-machine-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: msmq-Receive-computer-Journal
deleteoldrdn: 1

dn: CN=msmq-Receive-computer-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=msmq-Peak-machine-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=msmq-Peak-machine-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: msmq-Peek-computer-Journal
deleteoldrdn: 1

dn: CN=msmq-Peek-computer-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=msmq-Peak,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=msmq-Peak,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: msmq-Peek
deleteoldrdn: 1

dn: CN=msmq-Peek,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=msmq-Peek-Dead-Letter,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Peek Dead Letter
-

dn: CN=msmq-Receive-computer-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Receive Computer Journal
-

dn: CN=msmq-Peek-computer-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Peek Computer Journal
-

dn: CN=msmq-Peek,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Peek Message
-

dn: CN=mSMQQueue-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: MSMQ Queue
-
add: treatAsLeaf
treatAsLeaf: TRUE
-

dn: CN=mSMQConfiguration-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: MSMQ Configuration
-

dn: CN=mSMQEnterpriseSettings-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: MSMQ Enterprise
-

dn: CN=mSMQSiteLink-display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: MSMQ Site Link
-

dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 7
-

```

### Sch8.ldf

```
dn: CN=Print-Duplex-Supported,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Print-Duplex-Supported-Unused
deleteoldrdn: 1

dn: CN=Print-Duplex-Supported-Unused,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDisplayName
adminDisplayName: Print-Duplex-Supported-Unused
-
replace: adminDescription
adminDescription: Print-Duplex-Supported-Unused
-
replace: ldapDisplayName
ldapDisplayName: printDuplexSupportedUnused
-
replace: schemaIdGuid
schemaIdGuid:: AsPDrFY80hGf8LYGeY0bDw==
-

dn: CN=Assoc-NT-Account-Unused,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: DS-Heuristics
deleteoldrdn: 1

dn: CN=DS-Heuristics,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDisplayName
adminDisplayName: DS-Heuristics
-
replace: adminDescription
adminDescription: DS-Heuristics
-
replace: ldapDisplayName
ldapDisplayName: dSHeuristics
-
delete: mapiID
-


dn: cn=print-duplex-supported,cn=schema,cn=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: printDuplexSupported
adminDescription: Print-Duplex-Supported
adminDisplayName: Print-Duplex-Supported
attributeID: 1.2.840.113556.1.4.1311
attributeSyntax: 2.5.5.8
oMSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: zBYUKGgZ0BGijwCqADBJ4g==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Move-Tree-State,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: moveTreeState
adminDisplayName: Move-Tree-State
adminDescription: Move-Tree-State
attributeId: 1.2.840.113556.1.4.1305
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: yMIqH3E70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=PKI-Key-Usage,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIKeyUsage
adminDisplayName: PKI-Key-Usage
adminDescription: PKI-Key-Usage
attributeId: 1.2.840.113556.1.4.1328
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fqiw6Z070hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=DNS-Property,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: dNSProperty
adminDisplayName: DNS-Property
adminDescription: DNS-Property
attributeId: 1.2.840.113556.1.4.1306
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /hVaZ3A70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=DS-Heuristics,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: dSHeuristics
adminDisplayName: DS-Heuristics
adminDescription: DS-Heuristics
attributeId: 1.2.840.113556.1.2.212
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hv/48JER0BGgYACqAGwz7Q==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Interval1,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQInterval1
adminDisplayName: MSMQ-Interval1
adminDescription: MSMQ-Interval1
attributeId: 1.2.840.113556.1.4.1308
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qiWojns70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-Interval2,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQInterval2
adminDisplayName: MSMQ-Interval2
adminDescription: MSMQ-Interval2
attributeId: 1.2.840.113556.1.4.1309
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Uo+4mXs70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Server-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSServerList
adminDisplayName: ACS-Server-List
adminDescription: ACS-Server-List
attributeId: 1.2.840.113556.1.4.1312
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pVm9fJA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=PKI-Default-CSPs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIDefaultCSPs
adminDisplayName: PKI-Default-CSPs
adminDescription: PKI-Default-CSPs
attributeId: 1.2.840.113556.1.4.1334
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bjP2Hp470hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=MSMQ-Site-Gates-Mig,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQSiteGatesMig
adminDisplayName: MSMQ-Site-Gates-Mig
adminDescription: MSMQ-Site-Gates-Mig
attributeId: 1.2.840.113556.1.4.1310
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: Ukhw4ns70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=PKI-Overlap-Period,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIOverlapPeriod
adminDisplayName: PKI-Overlap-Period
adminDescription: PKI-Overlap-Period
attributeId: 1.2.840.113556.1.4.1332
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 7KMZEp470hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=PKI-Default-Key-Spec,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIDefaultKeySpec
adminDisplayName: PKI-Default-Key-Spec
adminDescription: PKI-Default-Key-Spec
attributeId: 1.2.840.113556.1.4.1327
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bq5sQp070hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=ACS-Minimum-Latency,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSMinimumLatency
adminDisplayName: ACS-Minimum-Latency
adminDescription: ACS-Minimum-Latency
attributeId: 1.2.840.113556.1.4.1316
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +/4XlZA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Maximum-SDU-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSMaximumSDUSize
adminDisplayName: ACS-Maximum-SDU-Size
adminDescription: ACS-Maximum-SDU-Size
attributeId: 1.2.840.113556.1.4.1314
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +diih5A70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=Account-Name-History,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: accountNameHistory
adminDisplayName: Account-Name-History
adminDescription: Account-Name-History
attributeId: 1.2.840.113556.1.4.1307
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 7FIZA3I70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=PKI-Max-Issuing-Depth,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIMaxIssuingDepth
adminDisplayName: PKI-Max-Issuing-Depth
adminDescription: PKI-Max-Issuing-Depth
attributeId: 1.2.840.113556.1.4.1329
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +t6/8J070hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=PKI-Extended-Key-Usage,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIExtendedKeyUsage
adminDisplayName: PKI-Extended-Key-Usage
adminDescription: PKI-Extended-Key-Usage
attributeId: 1.2.840.113556.1.4.1333
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9mqXGJ470hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=PKI-Expiration-Period,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIExpirationPeriod
adminDisplayName: PKI-Expiration-Period
adminDescription: PKI-Expiration-Period
attributeId: 1.2.840.113556.1.4.1331
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 0nAVBJ470hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=ACS-Minimum-Policed-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSMinimumPolicedSize
adminDisplayName: ACS-Minimum-Policed-Size
adminDescription: ACS-Minimum-Policed-Size
attributeId: 1.2.840.113556.1.4.1315
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lXEOjZA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=PKI-Critical-Extensions,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKICriticalExtensions
adminDisplayName: PKI-Critical-Extensions
adminDescription: PKI-Critical-Extensions
attributeId: 1.2.840.113556.1.4.1330
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BpFa/J070hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=ACS-Non-Reserved-Peak-Rate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSNonReservedPeakRate
adminDisplayName: ACS-Non-Reserved-Peak-Rate
adminDescription: ACS-Non-Reserved-Peak-Rate
attributeId: 1.2.840.113556.1.4.1318
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: P6cxo5A70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Non-Reserved-Token-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSNonReservedTokenSize
adminDisplayName: ACS-Non-Reserved-Token-Size
adminDescription: ACS-Non-Reserved-Token-Size
attributeId: 1.2.840.113556.1.4.1319
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ydcWqZA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Minimum-Delay-Variation,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSMinimumDelayVariation
adminDisplayName: ACS-Minimum-Delay-Variation
adminDescription: ACS-Minimum-Delay-Variation
attributeId: 1.2.840.113556.1.4.1317
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mzJlnJA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Max-Token-Bucket-Per-Flow,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSMaxTokenBucketPerFlow
adminDisplayName: ACS-Max-Token-Bucket-Per-Flow
adminDescription: ACS-Max-Token-Bucket-Per-Flow
attributeId: 1.2.840.113556.1.4.1313
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 3+D2gZA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Non-Reserved-Max-SDU-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSNonReservedMaxSDUSize
adminDisplayName: ACS-Non-Reserved-Max-SDU-Size
adminDescription: ACS-Non-Reserved-Max-SDU-Size
attributeId: 1.2.840.113556.1.4.1320
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 48/CrpA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=ACS-Non-Reserved-Min-Policed-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: aCSNonReservedMinPolicedSize
adminDisplayName: ACS-Non-Reserved-Min-Policed-Size
adminDescription: ACS-Non-Reserved-Min-Policed-Size
attributeId: 1.2.840.113556.1.4.1321
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: FzmHtpA70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=MSMQ-User-Sid,CN=Schema,CN=Configuration,DC=arobindg15,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQUserSid
adminDisplayName: MSMQ-User-Sid
adminDescription: MSMQ-User-Sid
attributeId: 1.2.840.113556.1.4.1337
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
rangeLower: 0
rangeUpper: 128
schemaIdGuid:: Mq6KxflW0hGQ0ADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=Repl-Interval,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: replInterval
adminDisplayName: Repl-Interval
adminDescription: Repl-Interval
attributeId: 1.2.840.113556.1.4.1336
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Gp26RfpW0hGQ0ADAT9kasQ==
showInAdvancedViewOnly: TRUE

dn: CN=PKI-Enrollment-Access,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: pKIEnrollmentAccess
adminDisplayName: PKI-Enrollment-Access
adminDescription: PKI-Enrollment-Access
attributeId: 1.2.840.113556.1.4.1335
attributeSyntax: 2.5.5.15
omSyntax: 66
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: eOJrkvlW0hGQ0ADAT9kasQ==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE

dn: CN=SPN-Mappings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: sPNMappings
adminDisplayName: SPN-Mappings
adminDescription: SPN-Mappings
attributeId: 1.2.840.113556.1.4.1347
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bOewKkFw0hGZBQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Template-Roots,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: templateRoots
adminDisplayName: Template-Roots
adminDescription: Template-Roots
attributeId: 1.2.840.113556.1.4.1346
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: oOmd7UFw0hGZBQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=DS-UI-Admin-Maximum,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: dSUIAdminMaximum
adminDisplayName: DS-UI-Admin-Maximum
adminDescription: DS-UI-Admin-Maximum
attributeId: 1.2.840.113556.1.4.1344
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 4AqN7pFv0hGZBQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=DS-UI-Shell-Maximum,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: dSUIShellMaximum
adminDisplayName: DS-UI-Shell-Maximum
adminDescription: DS-UI-Shell-Maximum
attributeId: 1.2.840.113556.1.4.1345
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: anbK/JFv0hGZBQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=DS-UI-Admin-Notification,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: dSUIAdminNotification
adminDisplayName: DS-UI-Admin-Notification
adminDescription: DS-UI-Admin-Notification
attributeId: 1.2.840.113556.1.4.1343
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lArq9pFv0hGZBQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16


dn: CN=Localization-Display-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: localizationDisplayId
adminDisplayName: Localization-Display-Id
adminDescription: Localization-Display-Id
attributeId: 1.2.840.113556.1.4.1353
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 0fBGp9B40hGZFgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=GPC-User-Extension-Names,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: gPCUserExtensionNames
adminDisplayName: GPC-User-Extension-Names
adminDescription: GPC-User-Extension-Names
attributeId: 1.2.840.113556.1.4.1349
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xl+nQj940hGZFgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16


dn: CN=GPC-Machine-Extension-Names,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: gPCMachineExtensionNames
adminDisplayName: GPC-Machine-Extension-Names
adminDescription: GPC-Machine-Extension-Names
attributeId: 1.2.840.113556.1.4.1348
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: zI7/Mj940hGZFgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Scope-Flags,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: scopeFlags
adminDisplayName: Scope-Flags
adminDescription: Scope-Flags
attributeId: 1.2.840.113556.1.4.1354
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wqTzFnl+0hGZIQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Query-Filter,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: queryFilter
adminDisplayName: Query-Filter
adminDescription: Query-Filter
attributeId: 1.2.840.113556.1.4.1355
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Jgr3y3h+0hGZIQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Valid-Accesses,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: validAccesses
adminDisplayName: Valid-Accesses
adminDescription: Valid-Accesses
attributeId: 1.2.840.113556.1.4.1356
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gKMvTVR/0hGZKgAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=DS-Core-Propagation-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: dSCorePropagationData
adminDescription: DS-Core-Propagation-Data
adminDisplayName: DS-Core-Propagation-Data
attributeID: 1.2.840.113556.1.4.1357
attributeSyntax: 2.5.5.11
oMSyntax: 24
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIDGUID:: S6pn0QiL0hGZOQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=Schema-Info,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: schemaInfo
adminDescription: Schema-Info
adminDisplayName: Schema-Info
attributeID: 1.2.840.113556.1.4.1358
attributeSyntax: 2.5.5.10
oMSyntax: 4
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIDGUID:: rmT7+bST0hGZRQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16


dn: CN=DS-UI-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: dSUISettings
adminDisplayName: DS-UI-Settings
adminDescription: DS-UI-Settings
governsId: 1.2.840.113556.1.5.183
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1345
systemMayContain: 1.2.840.113556.1.4.1343
systemMayContain: 1.2.840.113556.1.4.1344
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: FA+xCZNv0hGZBQAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=DS-UI-Settings,CN=Schema,CN=Configuration,DC=X



dn: CN=PKI-Enrollment-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: pKIEnrollmentService
adminDisplayName: PKI-Enrollment-Service
adminDescription: PKI-Enrollment-Service
governsId: 1.2.840.113556.1.5.178
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.824
systemMayContain: 1.2.840.113556.1.4.825
systemMayContain: 1.2.840.113556.1.4.619
systemMayContain: 1.2.840.113556.1.4.823
systemMayContain: 1.2.840.113556.1.4.697
systemMayContain: 2.5.4.37
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: kqZK7ro70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=PKI-Enrollment-Service,CN=Schema,CN=Configuration,DC=X

dn: CN=PKI-Certificate-Template,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: pKICertificateTemplate
adminDisplayName: PKI-Certificate-Template
adminDescription: PKI-Certificate-Template
governsId: 1.2.840.113556.1.5.177
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1332
systemMayContain: 1.2.840.113556.1.4.1329
systemMayContain: 1.2.840.113556.1.4.1328
systemMayContain: 1.2.840.113556.1.4.1333
systemMayContain: 1.2.840.113556.1.4.1331
systemMayContain: 1.2.840.113556.1.4.1334
systemMayContain: 1.2.840.113556.1.4.1327
systemMayContain: 1.2.840.113556.1.4.1330
systemMayContain: 1.2.840.113556.1.4.38
systemMayContain: 1.2.840.113556.1.2.13
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: opwg5bo70hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=PKI-Certificate-Template,CN=Schema,CN=Configuration,DC=X

dn: CN=MSMQ-Migrated-User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mSMQMigratedUser
adminDisplayName: MSMQ-Migrated-User
adminDescription: MSMQ-Migrated-User
governsId: 1.2.840.113556.1.5.179
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.967
systemMayContain: 1.2.840.113556.1.4.947
systemMayContain: 1.2.840.113556.1.4.966
systemMayContain: 1.2.840.113556.1.4.948
systemMayContain: 1.2.840.113556.1.4.146
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.5.67
systemPossSuperiors: 1.2.840.113556.1.5.4
schemaIdGuid:: l2l3UD080hGQzADAT9kasQ==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Migrated-User,CN=Schema,CN=Configuration,DC=X

dn: CN=DMD,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1358
-

dn: CN=Display-Specifier,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1354
systemMayContain: 1.2.840.113556.1.4.1355
-

dn: CN=Control-Access-Right,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1356
-

dn: CN=msExch-Configuration-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1346
-

dn: CN=NTDS-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1347
-

dn: CN=NTDS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.211
-

dn: CN=NTFRS-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.89
-

dn: CN=Inter-Site-Transport,CN=Schema,CN=Configuration,DC=arobindg15,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1336
systemMayContain: 1.2.840.113556.1.4.307
-

dn: CN=Site-Link,CN=Schema,CN=Configuration,DC=arobindg15,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.307
systemMayContain: 1.2.840.113556.1.4.1336
-

dn: CN=PKI-Certificate-Template,CN=Schema,CN=Configuration,DC=arobindg15,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1335
-

dn: CN=MSMQ-Migrated-User,CN=Schema,CN=Configuration,DC=arobindg15,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1337
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1348
systemMayContain: 1.2.840.113556.1.4.1349
-

dn: CN=Control-Access-Right,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1353
-

dn: CN=E-Mail-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mapiID
mapiID: 14846
-

dn: CN=Assoc-NT-Account,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mapiID
mapiID: 32807
-

dn: CN=Assoc-NT-Account,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mapiID
-

dn: CN=Object-Sid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mapiID
mapiID: 32807
-

dn: CN=Keywords,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 1
-
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Netboot-Machine-File-Path,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Netboot-GUID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=MSMQ-Digests-Mig,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=MSMQ-Sign-Certificates-Mig,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Manager,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Service-Binding-Information,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Global-Address-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isSingleValued
isSingleValued: FALSE
-

dn: CN=Site-Server,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isSingleValued
isSingleValued: FALSE
-

dn: CN=Directory-Cfg,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.212
-

dn: CN=Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1307
-

dn: CN=ACS-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1313
systemMayContain: 1.2.840.113556.1.4.1314
systemMayContain: 1.2.840.113556.1.4.1315
systemMayContain: 1.2.840.113556.1.4.1316
systemMayContain: 1.2.840.113556.1.4.1317
-

dn: CN=ACS-Subnet,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1312
systemMayContain: 1.2.840.113556.1.4.1318
systemMayContain: 1.2.840.113556.1.4.1319
systemMayContain: 1.2.840.113556.1.4.1320
systemMayContain: 1.2.840.113556.1.4.1321
-

dn: CN=Lost-And-Found,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: FALSE
-

dn: CN=Lost-And-Found,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1305
-

dn: CN=Mailbox,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.212
-

dn: CN=Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.5.96
-

dn: CN=Print-Queue,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1311
-
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.4.236
-

dn: CN=Intellimirror-Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.222
-

dn: CN=Site,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.222
systemMayContain: 1.2.840.113556.1.4.1308
systemMayContain: 1.2.840.113556.1.4.1309
-

dn: CN=MSMQ-Enterprise-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1308
systemMayContain: 1.2.840.113556.1.4.1309
-

dn: CN=MSMQ-Site-Link,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1310
-


dn: CN=Remote-Address,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.212
-

dn: CN=NTDS-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.212
-

dn: CN=NNTP-Newsfeed,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: 1.2.840.113556.1.2.212
-

dn: CN=Dns-Zone,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1306
-

dn: CN=Dns-Node,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1306
-

dn: CN=Subnet,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.222
-

dn: CN=rpc-Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.114
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.114
-

dn: CN=rpc-Profile-Element,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.118
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.118
-

dn: CN=Company,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: ldapDisplayName
ldapDisplayName: company
-

dn: CN=Text-Country,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: ldapDisplayName
ldapDisplayName: co
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: container
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPLCLORC;;;PS)(OA;;RPWPCR;ab721a53-1e2f-11d0-9819-00aa0040529b;;PS)(OA;;RPWPCR;ab721a54-1e2f-11d0-9819-00aa0040529b;;PS)(OA;;RPWPCR;ab721a56-1e2f-11d0-9819-00aa0040529b;;PS)(OA;;RPWPCR;77B5B886-944A-11d1-AEBD-0000F80367C1;;PS)(OA;;RPWPCR;E45795B2-9455-11d1-AEBD-0000F80367C1;;PS)(OA;;RPWPCR;E45795B3-9455-11d1-AEBD-0000F80367C1;;PS)(OA;;RP;037088f8-0ae1-11d2-b422-00a0c968f939;;RS)(OA;;RP;4c164200-20c0-11d0-a768-00aa006e0529;;RS)(OA;;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;;RS)(A;;RC;;;AU)(OA;;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;;AU)(OA;;RP;77B5B886-944A-11d1-AEBD-0000F80367C1;;AU)(OA;;RP;E45795B3-9455-11d1-AEBD-0000F80367C1;;AU)(OA;;RP;e48d0154-bcf8-11d1-8702-00c04fb96050;;AU)(OA;;RPWPCR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;;RS)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)(A;;RPLCLORC;;;AU)(OA;;RPWPCR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;CCDC;;;PS)(OA;;CCDC;bf967aa8-0de6-11d0-a285-00aa003049e2;;PO)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:P(A;;RPWPCCDCLCLOLORCWOWDSDDTSW;;;DA)(A;CIOI;RPWPCCDCLCLOLORCWOWDSDDTSW;;;EA)(A;;RPWPCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)(OA;;CR;edacfd8f-ffb3-11d1-b41d-00a0c968f939;;AU)
-

dn: CN=X509-Cert,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: attributeSecurityGuid
attributeSecurityGUID:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Country,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.131
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.131
-

dn: CN=Organizational-Person,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.131
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1357
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Config NC changes

dn: CN=nTDSSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Settings
-

dn: CN=nTDSDSA-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Domain Controller Settings
-

dn: CN=nTDSConnection-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Connection
-

dn: CN=nTFRSSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: FRS Settings
-

dn: CN=nTFRSReplicaSet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: FRS Replica Set
-

dn: CN=nTDSSiteSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Site Settings
-

dn: CN=nTFRSMember-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: FRS Member
-

dn: CN=nTFRSSubscriber-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: FRS Subscriber
-

dn: CN=nTFRSSubscriptions-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: FRS Subscriptions
-

dn: CN=nTDSService-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Service
-

dn: CN=mSMQSiteLink-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: MSMQ Routing Link
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 7,{8c5b1b50-d46e-11d1-8091-00a024c48131}
-

dn: CN=printQueue-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: whenCreated,Date Published
-

dn: CN=MsmqServices,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: mSMQEnterpriseSettings
mSmQVersion: 200
showInAdvancedViewOnly: TRUE

dn: CN=DS-Install-Replica,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
displayName: Add/Remove Replica In Domain
rightsGUID: 9923a32a-3607-11d2-b9be-0000f87a36b2
showInAdvancedViewOnly: TRUE

dn: CN=Change-Infrastructure-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
appliesTo: 2df90d89-009f-11d2-aa4c-00c04fd7d83a
displayName: Change Infrastructure Master
rightsGUID: cc17b1fb-33d9-11d2-97d4-00c04fd8d5cd
showInAdvancedViewOnly: TRUE

dn: CN=sitesContainer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
-

dn: CN=interSiteTransportContainer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
-

dn: CN=interSiteTransport-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6dfe6491-a212-11d0-bcd5-00c04fd8d5b6}
-
delete: adminPropertyPages
adminPropertyPages: 1,{6DFE6491-AC8D-11D0-B945-00C04FD8D5B0}
-

dn: CN=subnetContainer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
-

dn: CN=serversContainer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
-

dn: CN=nTDSService-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
-

dn: CN=queryPolicy-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6384e23e-736d-11d1-bd0d-00c04fd8d5b6}
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: countryCode,Country Code
attributeDisplayNames: comment,User Account Comment
-
add: attributeDisplayNames
attributeDisplayNames: comment,Comment
attributeDisplayNames: samAccountName,Downlevel Logon Name
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: co,Company
-
add: attributeDisplayNames
attributeDisplayNames: company,Company
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: co,Company
-
add: attributeDisplayNames
attributeDisplayNames: company,Company
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: type,Type
-
add: attributeDisplayNames
attributeDisplayNames: managedBy,Managed By
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{6dfe6492-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 2,{9da6fd64-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 3,{77597368-7b15-11d0-a0c2-080036af3f03}
adminPropertyPages: 4,{6dfe648b-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 5,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 6,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 10,{0F65B1BF-740F-11d1-BBE6-0060081692B3}
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: createWizardExt
createWizardExt: 1,{D6D8C25A-4E83-11d2-8424-00C04FA372D4}
-

dn: CN=site-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
-

dn: CN=site-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{717EF4FA-AC8D-11D0-B945-00C04FD8D5B0}
adminPropertyPages: 2,{77597368-7b15-11d0-a0c2-080036af3f03}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 5,{bc019ba0-d46d-11d1-8091-00a024c48131}
-

dn: CN=subnet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
-

dn: CN=subnet-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 1,{9da6fd62-c63b-11d0-b94d-00c04fd8d5b0}
adminPropertyPages: 2,{77597368-7b15-11d0-a0c2-080036af3f03}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 4,{4E40F770-369C-11d0-8922-00A024AB2DBB}
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: managedBy,Managed By
-

dn: CN=volume-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: managedBy,Managed By
attributeDisplayNames: keywords,Keywords
-

dn: CN=pKICertificateTemplate-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: displaySpecifier
adminPropertyPages: 1,{9bff616c-3e02-11d2-a4ca-00c04fb93209}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4e40f770-369c-11d0-8922-00a024ab2dbb}
shellPropertyPages: 1,{9bff616c-3e02-11d2-a4ca-00c04fb93209}
contextMenu: 0,{9bff616c-3e02-11d2-a4ca-00c04fb93209}
adminContextMenu: 0,{9bff616c-3e02-11d2-a4ca-00c04fb93209}
classDisplayName: Certificate Template
attributeDisplayNames: cn,Name
attributeDisplayNames: description,Description
iconPath: 0,capesnpn.dll,-227
showInAdvancedViewOnly: TRUE

dn: CN=DS-UI-Default-Settings,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: dSUISettings
showInAdvancedViewOnly: TRUE

dn: CN=RAS-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Modify Remote Access Information
-

dn: CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: sPNMappings
spnMappings: host=alerter,appmgmt,cisvc,clipsrv,browser,dhcp,dnscache,replicator,eventlog,eventsystem,policyagent,oakley,dmserver,ldp,ldap,dns,mcsvc,fax,msiserver,ias,messenger,netlogon,netman,netdde,netddedsm,nmagent,plugplay,protectedstorage,rasman,rpclocator,rpc,rpcss,remoteaccess,rsvp,samss,scardsvr,scesrv,seclogon,scm,dcom,cifs,spooler,snmp,schedule,tapisrv,trksvr,trkwks,ups,time,wins,www,http,w3svc,iisadmin
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd66-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd66-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=serviceAdministrationPoint-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd64-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd64-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=volume-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd64-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=domainDNS-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd65-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{9da6fd65-c63b-11d0-b94d-00c04fd8d5b0}
-

dn: CN=mSMQQueue-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-

dn: CN=mSMQConfiguration-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-

dn: CN=mSMQEnterpriseSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-
add: adminPropertyPages
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-

dn: CN=mSMQSettings-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-
add: adminPropertyPages
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-

dn: CN=mSMQSiteLink-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: adminPropertyPages
adminPropertyPages: 2,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 3,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-
add: adminPropertyPages
adminPropertyPages: 3,{4E40F770-369C-11d0-8922-00A024AB2DBB}
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
-


dn: CN=Domain-Administer-Server,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 1
-
add: validAccesses
validAccesses: 256
-

dn: CN=User-Change-Password,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 2
-
add: validAccesses
validAccesses: 256
-

dn: CN=User-Force-Change-Password,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 3
-
add: validAccesses
validAccesses: 256
-

dn: CN=Send-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 4
-
add: validAccesses
validAccesses: 256
-

dn: CN=Receive-As,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 5
-
add: validAccesses
validAccesses: 256
-

dn: CN=Send-To,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 6
-
add: validAccesses
validAccesses: 256
-

dn: CN=Domain-Password,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 7
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Domain Password & Lockout Policie
-

dn: CN=General-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 8
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: General Information
-

dn: CN=User-Account-Restrictions,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 9
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Account Restrictions
-

dn: CN=User-Logon,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 10
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Logon Information
-

dn: CN=Membership,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 11
-
add: validAccesses
validAccesses: 256
-

dn: CN=Lockout-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 12
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Lockout Policy
-

dn: CN=Password-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 13
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Password Policy
-

dn: CN=Domain-Configuration,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 14
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Domain Policy Configuration
-

dn: CN=Domain-Policy-Ref,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 15
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Domain Policy Reference
-

dn: CN=Privileges,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 16
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Privileges
-

dn: CN=Administrative-Access,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 17
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Logon Rights
-

dn: CN=Local-Policy-Ref,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 18
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Local Policy Reference
-

dn: CN=Audit-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 19
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Audit Policy
-

dn: CN=Builtin-Local-Groups,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 20
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Administrative Roles
-

dn: CN=Open-Address-Book,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 21
-
add: validAccesses
validAccesses: 256
-

dn: CN=Email-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 22
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Phone and Mail Options
-

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 23
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Personal Information
-

dn: CN=Web-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 24
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Web Information
-

dn: CN=DS-Replication-Get-Changes,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 25
-
add: validAccesses
validAccesses: 256
-

dn: CN=DS-Replication-Synchronize,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 26
-
add: validAccesses
validAccesses: 256
-

dn: CN=DS-Replication-Manage-Topology,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 27
-
add: validAccesses
validAccesses: 256
-

dn: CN=Change-Schema-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 28
-
add: validAccesses
validAccesses: 256
-

dn: CN=Change-Rid-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 29
-
add: validAccesses
validAccesses: 256
-

dn: CN=Abandon-Replication,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 30
-
add: validAccesses
validAccesses: 256
-

dn: CN=Do-Garbage-Collection,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 31
-
add: validAccesses
validAccesses: 256
-

dn: CN=Recalculate-Hierarchy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 32
-
add: validAccesses
validAccesses: 256
-

dn: CN=Allocate-Rids,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 33
-
add: validAccesses
validAccesses: 256
-

dn: CN=Change-PDC,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 34
-
add: validAccesses
validAccesses: 256
-

dn: CN=Add-GUID,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 35
-
add: validAccesses
validAccesses: 256
-

dn: CN=Change-Domain-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 36
-
add: validAccesses
validAccesses: 256
-

dn: CN=Public-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 37
-
add: validAccesses
validAccesses: 48
-
replace: displayName
displayName: Public Information
-

dn: CN=msmq-Receive-Dead-Letter,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 38
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Peek-Dead-Letter,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 39
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Receive-computer-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 40
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Peek-computer-Journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 41
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Receive,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 42
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Peek,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 43
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Send,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 44
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Receive-journal,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 45
-
add: validAccesses
validAccesses: 256
-

dn: CN=msmq-Open-Connector,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 46
-
add: validAccesses
validAccesses: 256
-

dn: CN=Apply-Group-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 47
-
add: validAccesses
validAccesses: 256
-

dn: CN=RAS-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 48
-
add: validAccesses
validAccesses: 256
-

dn: CN=DS-Install-Replica,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 49
-
add: validAccesses
validAccesses: 256
-

dn: CN=Change-Infrastructure-Master,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: localizationDisplayId
localizationDisplayId: 50
-
add: validAccesses
validAccesses: 256
-

dn: CN=Update-Schema-Cache,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
appliesTo: bf967a8f-0de6-11d0-a285-00aa003049e2
displayName: Update Schema Cache
localizationDisplayId: 51
rightsGUID: be2bb760-7f46-11d2-b9ad-00c04f79f805
validAccesses: 256

dn: CN=Recalculate-Security-Inheritance,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Recalculate Security Inheritance
localizationDisplayId: 52
rightsGUID: 62dd28a8-7f46-11d2-b9ad-00c04f79f805
validAccesses: 256

dn: CN=DS-Check-Stale-Phantoms,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Check Stale Phantoms
localizationDisplayId: 53
rightsGUID: 69ae6200-7f46-11d2-b9ad-00c04f79f805
validAccesses: 256

dn: CN=Certificate-Enrollment,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
showInAdvancedViewOnly: TRUE
appliesTo:  e5209ca2-3bba-11d2-90cc-00c04fd91ab1
displayname: Enroll
localizationDisplayId: 54
rightsGuid: 0e10c968-78fb-11d2-90d4-00c04f79dc55
validAccesses: 256

dn: CN=DEFAULTIPSITELINK,CN=IP,CN=Inter-Site Transports,CN=Sites,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: cost
cost: 100
-
add: replInterval
replInterval: 180
-

dn: CN=IntellimirrorGroup-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Intellimirror Group
-

dn: CN=IntellimirrorSCP-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Intellimirror Service
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: cn,Name
-
add: attributeDisplayNames
attributeDisplayNames: cn,Common Name
-

dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 8
-

```

### Sch9.ldf

```
dn: CN=msExch-Configuration-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: ms-Exch-Configuration-Container
deleteoldrdn: 1

dn: CN=ms-Exch-Configuration-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDisplayName
adminDisplayName: ms-Exch-Configuration-Container
-
replace: adminDescription
adminDescription: ms-Exch-Configuration-Container
-

dn: CN=Mime-Types,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Mime-Types-Unused
deleteoldrdn: 1

dn: CN=Mime-Types-Unused,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: adminDisplayName
adminDisplayName: Mime-Types-Unused
-
replace: adminDescription
adminDescription: Mime-Types-Unused
-
replace: ldapDisplayName
ldapDisplayName: mimeTypesUnused
-


dn: CN=DS-Core-Propagation-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: dSCorePropagationData
adminDescription: DS-Core-Propagation-Data
adminDisplayName: DS-Core-Propagation-Data
attributeID: 1.2.840.113556.1.4.1357
attributeSyntax: 2.5.5.11
oMSyntax: 24
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIDGUID:: S6pn0QiL0hGZOQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=Schema-Info,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: schemaInfo
adminDescription: Schema-Info
adminDisplayName: Schema-Info
attributeID: 1.2.840.113556.1.4.1358
attributeSyntax: 2.5.5.10
oMSyntax: 4
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIDGUID:: rmT7+bST0hGZRQAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Other-Well-Known-Objects,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: otherWellKnownObjects
adminDescription: Other-Well-Known-Objects
adminDisplayName: Other-Well-Known-Objects
attributeID: 1.2.840.113556.1.4.1359
attributeSyntax: 2.5.5.7
oMSyntax: 127
oMObjectClass:: KoZIhvcUAQEBCw==
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: XU6mHg+s0hGQ3wDAT9kasQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-DS-Consistency-Child-Count,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: mS-DS-ConsistencyChildCount
adminDescription: MS-DS-Consistency-Child-Count
adminDisplayName: MS-DS-Consistency-Child-Count
attributeID: 1.2.840.113556.1.4.1361
attributeSyntax: 2.5.5.9
oMSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: wnuLFzq20hGQ4QDAT9kasQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16


dn: CN=MS-DS-Consistency-Guid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: mS-DS-ConsistencyGuid
adminDescription: MS-DS-Consistency-Guid
adminDisplayName: MS-DS-Consistency-Guid
attributeID: 1.2.840.113556.1.4.1360
attributeSyntax: 2.5.5.10
oMSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIDGUID:: wj13Izq20hGQ4QDAT9kasQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-SPX,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-SPX
adminDisplayName: MS-SQL-SPX
adminDescription: MS-SQL-SPX
attributeId: 1.2.840.113556.1.4.1376
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BICwhu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Name,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Name
adminDisplayName: MS-SQL-Name
adminDescription: MS-SQL-Name
attributeId: 1.2.840.113556.1.4.1363
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: 2N8yNe7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 16

dn: CN=MS-SQL-Size,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Size
adminDisplayName: MS-SQL-Size
adminDescription: MS-SQL-Size
attributeId: 1.2.840.113556.1.4.1396
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hIAJ6e7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Type,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Type
adminDisplayName: MS-SQL-Type
adminDescription: MS-SQL-Type
attributeId: 1.2.840.113556.1.4.1391
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qOtIyu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Alias,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Alias
adminDisplayName: MS-SQL-Alias
adminDescription: MS-SQL-Alias
attributeId: 1.2.840.113556.1.4.1395
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: rrrG4O7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 16

dn: CN=MS-SQL-Build,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Build
adminDisplayName: MS-SQL-Build
adminDescription: MS-SQL-Build
attributeId: 1.2.840.113556.1.4.1368
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xJQ+YO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-TCPIP,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-TCPIP
adminDisplayName: MS-SQL-TCPIP
adminDescription: MS-SQL-TCPIP
attributeId: 1.2.840.113556.1.4.1377
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pmPCiu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Vines,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Vines
adminDisplayName: MS-SQL-Vines
adminDescription: MS-SQL-Vines
attributeId: 1.2.840.113556.1.4.1379
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lGPFlO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Memory,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Memory
adminDisplayName: MS-SQL-Memory
adminDescription: MS-SQL-Memory
attributeId: 1.2.840.113556.1.4.1367
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: jERdW+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Status,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Status
adminDisplayName: MS-SQL-Status
adminDescription: MS-SQL-Status
attributeId: 1.2.840.113556.1.4.1380
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: cEd9mu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Contact,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Contact
adminDisplayName: MS-SQL-Contact
adminDescription: MS-SQL-Contact
attributeId: 1.2.840.113556.1.4.1365
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2L1sT+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Version,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Version
adminDisplayName: MS-SQL-Version
adminDescription: MS-SQL-Version
attributeId: 1.2.840.113556.1.4.1388
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: 0MF8wO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 16

dn: CN=MS-SQL-Database,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Database
adminDisplayName: MS-SQL-Database
adminDescription: MS-SQL-Database
attributeId: 1.2.840.113556.1.4.1393
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: 3Nug1e7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 16

dn: CN=MS-SQL-Language,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Language
adminDisplayName: MS-SQL-Language
adminDescription: MS-SQL-Language
attributeId: 1.2.840.113556.1.4.1389
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9HJ/xe7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Location,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Location
adminDisplayName: MS-SQL-Location
adminDescription: MS-SQL-Location
attributeId: 1.2.840.113556.1.4.1366
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RJYcVu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Keywords,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Keywords
adminDisplayName: MS-SQL-Keywords
adminDescription: MS-SQL-Keywords
attributeId: 1.2.840.113556.1.4.1401
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: iqnpAe/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-NamedPipe,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-NamedPipe
adminDisplayName: MS-SQL-NamedPipe
adminDescription: MS-SQL-NamedPipe
attributeId: 1.2.840.113556.1.4.1374
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QMiRe+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-AppleTalk,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-AppleTalk
adminDisplayName: MS-SQL-AppleTalk
adminDescription: MS-SQL-AppleTalk
attributeId: 1.2.840.113556.1.4.1378
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9Inaj+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-GPSHeight,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-GPSHeight
adminDisplayName: MS-SQL-GPSHeight
adminDescription: MS-SQL-GPSHeight
attributeId: 1.2.840.113556.1.4.1387
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Dk/dvO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Clustered,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Clustered
adminDisplayName: MS-SQL-Clustered
adminDescription: MS-SQL-Clustered
attributeId: 1.2.840.113556.1.4.1373
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: kL14d+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-SortOrder,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-SortOrder
adminDisplayName: MS-SQL-SortOrder
adminDescription: MS-SQL-SortOrder
attributeId: 1.2.840.113556.1.4.1371
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wELcbe7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Description,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Description
adminDisplayName: MS-SQL-Description
adminDescription: MS-SQL-Description
attributeId: 1.2.840.113556.1.4.1390
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PGCGg+/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-GPSLatitude,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-GPSLatitude
adminDisplayName: MS-SQL-GPSLatitude
adminDescription: MS-SQL-GPSLatitude
attributeId: 1.2.840.113556.1.4.1385
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Droisu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-CreationDate,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-CreationDate
adminDisplayName: MS-SQL-CreationDate
adminDescription: MS-SQL-CreationDate
attributeId: 1.2.840.113556.1.4.1397
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: VEfh7e7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-CharacterSet,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-CharacterSet
adminDisplayName: MS-SQL-CharacterSet
adminDescription: MS-SQL-CharacterSet
attributeId: 1.2.840.113556.1.4.1370
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pndhae7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-Applications,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-Applications
adminDisplayName: MS-SQL-Applications
adminDescription: MS-SQL-Applications
attributeId: 1.2.840.113556.1.4.1400
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6qLN++7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-GPSLongitude,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-GPSLongitude
adminDisplayName: MS-SQL-GPSLongitude
adminDescription: MS-SQL-GPSLongitude
attributeId: 1.2.840.113556.1.4.1386
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: lHxXt+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-ConnectionURL,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-ConnectionURL
adminDisplayName: MS-SQL-ConnectionURL
adminDescription: MS-SQL-ConnectionURL
attributeId: 1.2.840.113556.1.4.1383
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2iMtqe7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-MultiProtocol,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-MultiProtocol
adminDisplayName: MS-SQL-MultiProtocol
adminDescription: MS-SQL-MultiProtocol
attributeId: 1.2.840.113556.1.4.1375
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OPpXge7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-LastBackupDate,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-LastBackupDate
adminDisplayName: MS-SQL-LastBackupDate
adminDescription: MS-SQL-LastBackupDate
attributeId: 1.2.840.113556.1.4.1398
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: yqu28u7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-ServiceAccount,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-ServiceAccount
adminDisplayName: MS-SQL-ServiceAccount
adminDescription: MS-SQL-ServiceAccount
attributeId: 1.2.840.113556.1.4.1369
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: PjqTZO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-PublicationURL,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-PublicationURL
adminDisplayName: MS-SQL-PublicationURL
adminDescription: MS-SQL-PublicationURL
attributeId: 1.2.840.113556.1.4.1384
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: uBEMru7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-InformationURL,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-InformationURL
adminDisplayName: MS-SQL-InformationURL
adminDescription: MS-SQL-InformationURL
attributeId: 1.2.840.113556.1.4.1382
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ENUspO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-LastUpdatedDate,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-LastUpdatedDate
adminDisplayName: MS-SQL-LastUpdatedDate
adminDescription: MS-SQL-LastUpdatedDate
attributeId: 1.2.840.113556.1.4.1381
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 1EPMn+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-RegisteredOwner,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-RegisteredOwner
adminDisplayName: MS-SQL-RegisteredOwner
adminDescription: MS-SQL-RegisteredOwner
attributeId: 1.2.840.113556.1.4.1364
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6kT9SO7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-UnicodeSortOrder,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-UnicodeSortOrder
adminDisplayName: MS-SQL-UnicodeSortOrder
adminDescription: MS-SQL-UnicodeSortOrder
attributeId: 1.2.840.113556.1.4.1372
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: ipHccu7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-LastDiagnosticDate,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-LastDiagnosticDate
adminDisplayName: MS-SQL-LastDiagnosticDate
adminDescription: MS-SQL-LastDiagnosticDate
attributeId: 1.2.840.113556.1.4.1399
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: iN3W9u7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-InformationDirectory,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-InformationDirectory
adminDisplayName: MS-SQL-InformationDirectory
adminDescription: MS-SQL-InformationDirectory
attributeId: 1.2.840.113556.1.4.1392
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Ltuu0O7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-AllowAnonymousSubscription,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mS-SQL-AllowAnonymousSubscription
adminDisplayName: MS-SQL-AllowAnonymousSubscription
adminDescription: MS-SQL-AllowAnonymousSubscription
attributeId: 1.2.840.113556.1.4.1394
attributeSyntax: 2.5.5.8
omSyntax: 1
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Sr532+7M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-SQL-SQLServer,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-SQLServer
adminDisplayName: MS-SQL-SQLServer
adminDescription: MS-SQL-SQLServer
governsId: 1.2.840.113556.1.5.184
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.126
systemMayContain: 1.2.840.113556.1.4.1401
systemMayContain: 1.2.840.113556.1.4.1387
systemMayContain: 1.2.840.113556.1.4.1386
systemMayContain: 1.2.840.113556.1.4.1385
systemMayContain: 1.2.840.113556.1.4.1382
systemMayContain: 1.2.840.113556.1.4.1381
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1379
systemMayContain: 1.2.840.113556.1.4.1378
systemMayContain: 1.2.840.113556.1.4.1377
systemMayContain: 1.2.840.113556.1.4.1376
systemMayContain: 1.2.840.113556.1.4.1375
systemMayContain: 1.2.840.113556.1.4.1374
systemMayContain: 1.2.840.113556.1.4.1373
systemMayContain: 1.2.840.113556.1.4.1372
systemMayContain: 1.2.840.113556.1.4.1371
systemMayContain: 1.2.840.113556.1.4.1370
systemMayContain: 1.2.840.113556.1.4.1369
systemMayContain: 1.2.840.113556.1.4.1368
systemMayContain: 1.2.840.113556.1.4.1367
systemMayContain: 1.2.840.113556.1.4.1366
systemMayContain: 1.2.840.113556.1.4.1365
systemMayContain: 1.2.840.113556.1.4.1364
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.126
schemaIdGuid:: eMj2Be/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-SQLServer,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com

dn: CN=MS-SQL-OLAPServer,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-OLAPServer
adminDisplayName: MS-SQL-OLAPServer
adminDescription: MS-SQL-OLAPServer
governsId: 1.2.840.113556.1.5.185
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.126
systemMayContain: 1.2.840.113556.1.4.1401
systemMayContain: 1.2.840.113556.1.4.1384
systemMayContain: 1.2.840.113556.1.4.1382
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1389
systemMayContain: 1.2.840.113556.1.4.1369
systemMayContain: 1.2.840.113556.1.4.1365
systemMayContain: 1.2.840.113556.1.4.1364
systemMayContain: 1.2.840.113556.1.4.1368
systemMayContain: 1.2.840.113556.1.4.1388
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.126
schemaIdGuid:: 6hh+DO/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-OLAPServer,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com

dn: CN=MS-SQL-SQLPublication,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-SQLPublication
adminDisplayName: MS-SQL-SQLPublication
adminDescription: MS-SQL-SQLPublication
governsId: 1.2.840.113556.1.5.187
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1394
systemMayContain: 1.2.840.113556.1.4.1393
systemMayContain: 1.2.840.113556.1.4.1391
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1390
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.184
schemaIdGuid:: TvbCF+/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-SQLPublication,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com

dn: CN=MS-SQL-OLAPDatabase,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-OLAPDatabase
adminDisplayName: MS-SQL-OLAPDatabase
adminDescription: MS-SQL-OLAPDatabase
governsId: 1.2.840.113556.1.5.189
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1401
systemMayContain: 1.2.840.113556.1.4.1384
systemMayContain: 1.2.840.113556.1.4.1383
systemMayContain: 1.2.840.113556.1.4.1382
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1400
systemMayContain: 1.2.840.113556.1.4.1398
systemMayContain: 1.2.840.113556.1.4.1381
systemMayContain: 1.2.840.113556.1.4.1396
systemMayContain: 1.2.840.113556.1.4.1391
systemMayContain: 1.2.840.113556.1.4.1390
systemMayContain: 1.2.840.113556.1.4.1365
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.185
schemaIdGuid:: GgOvIO/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-OLAPDatabase,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com

dn: CN=MS-SQL-SQLRepository,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-SQLRepository
adminDisplayName: MS-SQL-SQLRepository
adminDescription: MS-SQL-SQLRepository
governsId: 1.2.840.113556.1.5.186
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1392
systemMayContain: 1.2.840.113556.1.4.1388
systemMayContain: 1.2.840.113556.1.4.1390
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1368
systemMayContain: 1.2.840.113556.1.4.1365
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.184
schemaIdGuid:: XDzUEe/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-SQLRepository,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com


dn: CN=MS-SQL-SQLDatabase,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-SQLDatabase
adminDisplayName: MS-SQL-SQLDatabase
adminDescription: MS-SQL-SQLDatabase
governsId: 1.2.840.113556.1.5.188
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1401
systemMayContain: 1.2.840.113556.1.4.1382
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1400
systemMayContain: 1.2.840.113556.1.4.1399
systemMayContain: 1.2.840.113556.1.4.1398
systemMayContain: 1.2.840.113556.1.4.1397
systemMayContain: 1.2.840.113556.1.4.1396
systemMayContain: 1.2.840.113556.1.4.1365
systemMayContain: 1.2.840.113556.1.4.1395
systemMayContain: 1.2.840.113556.1.4.1390
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.184
schemaIdGuid:: SmkIHe/M0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-SQLDatabase,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com

dn: CN=MS-SQL-OLAPCube,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: mS-SQL-OLAPCube
adminDisplayName: MS-SQL-OLAPCube
adminDescription: MS-SQL-OLAPCube
governsId: 1.2.840.113556.1.5.190
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1401
systemMayContain: 1.2.840.113556.1.4.1384
systemMayContain: 1.2.840.113556.1.4.1382
systemMayContain: 1.2.840.113556.1.4.1380
systemMayContain: 1.2.840.113556.1.4.1381
systemMayContain: 1.2.840.113556.1.4.1396
systemMayContain: 1.2.840.113556.1.4.1390
systemMayContain: 1.2.840.113556.1.4.1365
systemMayContain: 1.2.840.113556.1.4.1363
systemPossSuperiors: 1.2.840.113556.1.5.189
schemaIdGuid:: alDwCSjN0hGZkwAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MS-SQL-OLAPCube,CN=Schema,CN=Configuration,DC=arobindg1,DC=nttest,DC=microsoft,DC=com



dn: CN=DMD,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1358
-

dn: CN=NTDS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.211
-

dn: CN=E-Mail-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: mapiID
mapiID: 14846
-

dn: CN=Address-Home,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 16
-

dn: CN=Extension-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 16
-

dn: CN=Text-Country,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 16
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPLCLORC;;;PS)(OA;;CR;ab721a53-1e2f-11d0-9819-00aa0040529b;;PS)(OA;;CR;ab721a54-1e2f-11d0-9819-00aa0040529b;;PS)(OA;;CR;ab721a56-1e2f-11d0-9819-00aa0040529b;;PS)(OA;;RPWP;77B5B886-944A-11d1-AEBD-0000F80367C1;;PS)(OA;;RPWP;E45795B2-9455-11d1-AEBD-0000F80367C1;;PS)(OA;;RPWP;E45795B3-9455-11d1-AEBD-0000F80367C1;;PS)(OA;;RP;037088f8-0ae1-11d2-b422-00a0c968f939;;RS)(OA;;RP;4c164200-20c0-11d0-a768-00aa006e0529;;RS)(OA;;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;;RS)(A;;RC;;;AU)(OA;;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;;AU)(OA;;RP;77B5B886-944A-11d1-AEBD-0000F80367C1;;AU)(OA;;RP;E45795B3-9455-11d1-AEBD-0000F80367C1;;AU)(OA;;RP;e48d0154-bcf8-11d1-8702-00c04fb96050;;AU)(OA;;CR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;;RS)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)(A;;RPLCLORC;;;AU)(OA;;CR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;CCDC;;;PS)(OA;;CCDC;bf967aa8-0de6-11d0-a285-00aa003049e2;;PO)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:P(A;;RPWPCCDCLCLOLORCWOWDSDDTSW;;;DA)(A;CIOI;RPWPCCDCLCLOLORCWOWDSDDTSW;;;EA)(A;;RPWPCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)(OA;;CR;edacfd8f-ffb3-11d1-b41d-00a0c968f939;;AU)
-

dn: CN=Service-Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
-

dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPLCLORC;;;PS)(OA;;CR;ab721a55-1e2f-11d0-9819-00aa0040529b;;AU)
-

dn: CN=Servers-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;BA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RP;;;WD)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCRCWDWOSW;;;DA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;BA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)(A;CIOI;RPWPCRLCLOCCRCWDWOSDDTSW;;;EA)S:(AU;CIOISAFA;WDWOSDDTWPCRCCDCSW;;;WD)
-

dn: CN=Country,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.131
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)(A;;RPLCLORC;;;AU)(OA;;CR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;CCDC;;;PS)(OA;;CCDC;bf967aa8-0de6-11d0-a285-00aa003049e2;;PO)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;PS)
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(OA;;CCDC;bf967a86-0de6-11d0-a285-00aa003049e2;;AO)(OA;;CCDC;bf967aba-0de6-11d0-a285-00aa003049e2;;AO)(OA;;CCDC;bf967a9c-0de6-11d0-a285-00aa003049e2;;AO)(OA;;CCDC;bf967aa8-0de6-11d0-a285-00aa003049e2;;PO)(A;;RPLCLORC;;;AU)
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.131
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.3.23
-

dn: CN=Organizational-Person,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.131
-

dn: CN=Service-Principal-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Well-Known-Objects,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=RDN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 13
-

dn: CN=PKI-Certificate-Template,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingVale: TRUE
-

dn: CN=PKI-Enrollment-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingVale: TRUE
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1357
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1359
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1360
systemMayContain: 1.2.840.113556.1.4.1361
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.25
-

dn: CN=GP-Link,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Sid-History,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 1
-

dn: CN=Sid-History,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: Qi+6WaJ50BGQIADAT8LTzw==
-

dn: CN=MSMQ-Digests,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=MSMQ-Sign-Certificates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=E-Mail-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Given-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Surname,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-


dn: CN=Show-In-Advanced-View-Only,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: mapiID
-

# Need to swap the ldapDisplayName of Comment and Additional-Information,
# so first give a temp name so that we won't fail with dup ldapDisplayName

dn: CN=Additional-Information,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: ldapDisplayName
ldapDisplayName: ms-info
-

dn: CN=Comment,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: ldapDisplayName
ldapDisplayName: info
-

dn: CN=Additional-Information,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: ldapDisplayName
ldapDisplayName: notes
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: gPLink
systemMayContain: gPOptions
-

dn: CN=Object-Guid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Obj-Dist-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Common-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Country-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Domain-Component,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Organization-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Organizational-Unit-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=State-Or-Province-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Street-Address,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Locality-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=DS-Core-Propagation-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Partial-Attribute-Deletion-List,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Partial-Attribute-Set,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Sub-Refs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=USN-Last-Obj-Rem,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Repl-Property-Meta-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Repl-UpToDate-Vector,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Reps-From,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Reps-To,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=USN-Changed,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=USN-Created,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=When-Changed,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 19
-

dn: CN=Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Legacy-Exchange-DN,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=IntellimirrorGroup-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Intellimirror Group
-

dn: CN=IntellimirrorSCP-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: classDisplayName
classDisplayName: Intellimirror Service
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: cn,Name
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: cn,Common Name
-

dn: CN=organizationalUnit-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: ou,Name
-

dn: CN=DS-UI-Default-Settings,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: dSUIAdminNotification
dSUIAdminNotification: 1,{E62F8206-B71C-11D1-808D-00A024C48131}
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: notes,Notes
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: info,Notes
-

dn: CN=group-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: notes,Notes
-

dn: CN=group-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: info,Notes
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: info,Notes
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: notes,Notes
-


dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: ldapAdminLimits
ldapAdminLimits: AllowDeepNonIndexSearch=False
-

dn: CN=Default Query Policy,CN=Query-Policies,CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: ldapAdminLimits
ldapAdminLimits: MaxConnections=1000
-
add: ldapAdminLimits
ldapAdminLimits: MaxConnections=5000
-

dn: CN=Principal Self,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=Principal Self,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Self
deleteoldrdn: 1

dn: CN=Self,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=Authenticated User,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=Authenticated User,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Authenticated Users
deleteoldrdn: 1

dn: CN=Authenticated Users,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=Restricted Code,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=Restricted Code,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: Restricted
deleteoldrdn: 1

dn: CN=Restricted,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=Local System,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemFlags
systemFlags: 1073741824
-

dn: CN=Local System,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModRdn
newrdn: System
deleteoldrdn: 1

dn: CN=System,CN=WellKnown Security Principals,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemFlags
-

dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 9
-

```

### Sch10.ldf

```
Does not exist
```

### Sch11.ldf

```
dn: CN=MS-DS-Replicates-NC-Reason,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
adminDescription: MS-DS-Replicates-NC-Reason
adminDisplayName: MS-DS-Replicates-NC-Reason
attributeID: 1.2.840.113556.1.4.1408
attributeSyntax: 2.5.5.7
oMSyntax: 127
oMObjectClass:: KoZIhvcUAQEBCw==
lDAPDisplayName: mS-DS-ReplicatesNCReason
isSingleValued: FALSE
systemOnly: FALSE
schemaIDGUID:: hCuhDrMI0xGRvAAA+HpX1A==
searchFlags: 0
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Mastered-By,CN=schema,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
adminDescription: Mastered-By
adminDisplayName: Mastered-By
attributeID: 1.2.840.113556.1.4.1409
attributeSyntax: 2.5.5.1
oMSyntax: 127
oMObjectClass:: KwwCh3McAIVK
lDAPDisplayName: masteredBy
isSingleValued: FALSE
systemOnly: TRUE
schemaIDGUID:: 4GSO5MkS0xGRAgDAT9kasQ==
searchFlags: 0
linkID: 77
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=MS-DS-Machine-Account-Quota,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
adminDescription: MS-DS-Machine-Account-Quota
adminDisplayName: MS-DS-Machine-Account-Quota
attributeID: 1.2.840.113556.1.4.1411
attributeSyntax: 2.5.5.9
oMSyntax: 2
lDAPDisplayName: mS-DS-MachineAccountQuota
isSingleValued: TRUE
schemaIDGUID:: aPtk0IAU0xGRwQAA+HpX1A==
systemOnly: FALSE
searchFlags: 0
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MS-DS-Creator-Sid,CN=Schema,CN=Configuration,DC=arobindg6,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
adminDescription: MS-DS-Creator-SID
adminDisplayName: MS-DS-Creator-SID
attributeID: 1.2.840.113556.1.4.1410
attributeSyntax: 2.5.5.17
oMSyntax: 4
lDAPDisplayName: mS-DS-CreatorSID
isSingleValued: TRUE
schemaIDGUID:: MgHmxYAU0xGRwQAA+HpX1A==
systemOnly: TRUE
searchFlags: 1
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Display-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 5
-

dn: CN=Surname,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 5
-

dn: CN=Facsimile-Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 64
-

dn: CN=Telephone-Number,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 64
-

dn: CN=Poss-Superiors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=System-Poss-Superiors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Range-Upper,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Range-Lower,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Ldap-Display-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=ms-RRAS-Attribute,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=When-Created,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=User-Cert,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=X509-Cert,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=User-SMIME-Certificate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Proxy-Addresses,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Text-Country,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Member,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGUID:: QMIKvKl50BGQIADAT8LUzw==
-

dn: CN=Bridgehead-Server-List-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Frs-Computer-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=FRS-Member-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Is-Privilege-Holder,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Managed-Objects,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=netboot-SCP-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Non-Security-Member-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Query-Policy-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Server-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=Site-Object-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=NTDS-Connection,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1408
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1409
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: uPNSuffixes
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1410
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1411
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCRLCLORCSDDT;;;CO)(OA;;WP;4c164200-20c0-11d0-a768-00aa006e0529;;CO)(A;;RPLCLORC;;;AU)(OA;;CR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;CCDC;;;PS)(OA;;CCDC;bf967aa8-0de6-11d0-a285-00aa003049e2;;PO)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;PS)(OA;;RPWP;77B5B886-944A-11d1-AEBD-0000F80367C1;;PS)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;PS)
-

dn: CN=FT-Dfs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;CO)(A;;RPLCLORC;;;AU)
-


dn: CN=Manager,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Assistant,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Show-In-Address-Book,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Division,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Account-Expires,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Profile-Path,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Primary-Group-ID,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 17
-

dn: CN=Preferred-OU,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Other-Login-Workstations,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=User-Workstations,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Max-Storage,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Logon-Workstation,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Logon-Hours,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Script-Path,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Locale-Id,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Home-Drive,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Home-Directory,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Country-Code,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Code-Page,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=User-Account-Control,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 25
-

dn: CN=Employee-Type,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Show-In-Advanced-View-Only,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 17
-

dn: CN=Company,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Department,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Text-Country,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Is-Member-Of-DL,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Post-Office-Box,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Postal-Code,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Postal-Address,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Street-Address,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=State-Or-Province-Name,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Locality-Name,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 17
-

dn: CN=Country-Name,CN=schema,CN=configuration,DC=x
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 16
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RP;;;WD)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCRCWDWOSW;;;DA)(A;CI;RPWPCRLCLOCCRCWDWOSDSW;;;BA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)(A;CI;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;EA)S:(AU;CISAFA;WDWOSDDTWPCRCCDCSW;;;WD)
-

dn: CN=Servers-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;CI;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;BA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:P(A;CI;RPWPCCDCLCLOLORCWOWDSDDTSW;;;DA)(A;CI;RPWPCCDCLCLOLORCWOWDSDDTSW;;;EA)(A;CI;RPWPCCDCLCLOLORCWOWDSDDTSW;;;CO)(A;CI;RPWPCCDCLCLORCWOWDSDDTSW;;;SY)(A;CI;RPLCLORC;;;AU)(OA;CI;CR;edacfd8f-ffb3-11d1-b41d-00a0c968f939;;AU)
-

dn: CN=Alt-Security-Identities,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=NT-Security-Descriptor,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 132096
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-



# Config NC changes

dn: CN=Lockout-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Password-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Domain-Configuration,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Domain-Policy-Ref,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Privileges,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Administrative-Access,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Local-Policy-Ref,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Audit-Policy,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete

dn: CN=Builtin-Local-Groups,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaDelete


dn: CN=RAS-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: validAccesses
validAccesses: 48
-

dn: CN=Membership,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: validAccesses
validAccesses: 48
-

dn: CN=RAS-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Remote Access Information
-

dn: CN=Membership,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Group Membership
-

dn: CN=Open-Address-Book,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: displayName
displayName: Open Address List
-

dn: CN=Self-Membership,CN=extended-rights,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
rightsGuid: bf9679c0-0de6-11d0-a285-00aa003049e2
appliesTo: bf967a9c-0de6-11d0-a285-00aa003049e2
displayName: Add/Remove self as member
localizationDisplayId: 12
validAccesses: 8
showInAdvancedViewOnly: TRUE

dn: CN=Validated-DNS-Host-Name,CN=extended-rights,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
rightsGuid: 72e39547-7b18-11d1-adef-00c04fd8d5cd
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
displayName: Validated write to DNS host name
localizationDisplayId: 13
validAccesses: 8
showInAdvancedViewOnly: TRUE

dn: CN=Validated-SPN,CN=extended-rights,CN=configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
rightsGuid: f3a64788-5306-11d1-a9c5-0000f80367c1
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
displayName: Validated write to service principal name
localizationDisplayId: 14
validAccesses: 8
showInAdvancedViewOnly: TRUE

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: facsimileTelephoneNumber,Facsimile Telephone Number
attributeDisplayNames: otherFacsimileTelephoneNumber,Facsimile Telephone Number (Others)
attributeDisplayNames: otherTelephone,Office Telephone Number (Others)
attributeDisplayNames: mobile,Primary Mobile Phone Number
attributeDisplayNames: otherMobile,Mobile Phone Number (Others)
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: facsimileTelephoneNumber,Fax Number
attributeDisplayNames: otherFacsimileTelephoneNumber,Fax Number (Others)
attributeDisplayNames: otherTelephone,Phone Number (Others)
attributeDisplayNames: mobile,Mobile Number
attributeDisplayNames: otherMobile,Mobile Number (Others)
-

# The following add is preceded by a delete separately since some DCs may have it.
# If not, this is just skipped

dn: CN=Contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: otherFacsimileTelephoneNumber,Facsimile Telephone Number (Others)
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: facsimileTelephoneNumber,Facsimile Telephone Number
attributeDisplayNames: otherTelephone,Telephone Number (Others)
attributeDisplayNames: mobile,Primary Mobile Phone Number
attributeDisplayNames: otherMobile,Mobile Phone Number (Others)
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: facsimileTelephoneNumber,Fax Number
attributeDisplayNames: otherFacsimileTelephoneNumber,Fax Number (Others)
attributeDisplayNames: otherTelephone,Phone Number (Others)
attributeDisplayNames: mobile,Mobile Number
attributeDisplayNames: otherMobile,Mobile Number (Others)
-

dn: CN=mSMQMigratedUser-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: displaySpecifier
classDisplayName: MSMQ Upgraded User
adminPropertyPages: 1,{fc5bf656-0b7f-11d3-883f-006094eb6406}
adminContextMenu: 1,{fc5bf656-0b7f-11d3-883f-006094eb6406}
showInAdvancedViewOnly: TRUE


dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 11
-

```

### Sch12.ldf

```
dn: CN=DNS-Tombstoned,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: dNSTombstoned
adminDescription: DNS-Tombstoned
adminDisplayName: DNS-Tombstoned
attributeID: 1.2.840.113556.1.4.1414
attributeSyntax: 2.5.5.8
oMSyntax: 1
isSingleValued: TRUE
searchFlags: 1
systemOnly: FALSE
schemaIDGUID:: ty7r1U6+O0aiFGNKRNc5Lg==
showInAdvancedViewOnly: TRUE
systemFlags: 16


dn: CN=Primary-Group-Token,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: primaryGroupToken
adminDescription: Primary-Group-Token
adminDisplayName: Primary-Group-Token
attributeID: 1.2.840.113556.1.4.1412
attributeSyntax: 2.5.5.9
oMSyntax: 2
isSingleValued: TRUE
searchFlags: 0
systemOnly: TRUE
schemaIDGUID:: OIftwP1+gUSE2WbS24vjaQ==
showInAdvancedViewOnly: TRUE
systemFlags: 20


dn: CN=ACS-Resource-Limits,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
lDAPDisplayName: aCSResourceLimits
adminDescription: ACS-Resource-Limits
adminDisplayName: ACS-Resource-Limits
governsID: 1.2.840.113556.1.5.191
objectClassCategory: 1
rDNAttID: cn
subClassOf: top
systemMayContain: aCSMaxTokenRatePerFlow
systemMayContain: aCSServiceType
systemMayContain: aCSMaxPeakBandwidthPerFlow
systemMayContain: aCSMaxPeakBandwidth
systemMayContain: aCSAllocableRSVPBandwidth
systemPossSuperiors: container
schemaIDGUID:: BJuJLjQo0xGR1AAA+HpX1A==
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
systemFlags: 16
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)

dn: CN=Street-Address,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 1024
-

dn: CN=Phone-Home-Primary,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: isMemberOfPartialAttributeSet
isMemberOfPartialAttributeSet: TRUE
-

dn: CN=Computer,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;AO)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCRLCLORCSDDT;;;CO)(OA;;WP;4c164200-20c0-11d0-a768-00aa006e0529;;CO)(A;;RPLCLORC;;;AU)(OA;;CR;ab721a53-1e2f-11d0-9819-00aa0040529b;;WD)(OA;;CCDC;;;PS)(OA;;CCDC;bf967aa8-0de6-11d0-a285-00aa003049e2;;PO)(OA;;RPWP;bf967a7f-0de6-11d0-a285-00aa003049e2;;CA)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;PS)(OA;;RPWP;77B5B886-944A-11d1-AEBD-0000F80367C1;;PS)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;PS)(OA;;SW;72e39547-7b18-11d1-adef-00c04fd8d5cd;;CO)(OA;;SW;f3a64788-5306-11d1-a9c5-0000f80367c1;;CO)
-


dn: CN=Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1412
-

dn: CN=Sam-Account-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 256
-

dn: CN=Foreign-Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMustContain
systemMustContain: objectSid
-

dn: CN=Foreign-Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: systemMayContain
systemMayContain: objectSid
-

dn: CN=Dns-Node,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1414
-

dn: CN=Link-Track-Vol-Entry,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)
-

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-


# Config NC changes

dn: CN=Personal-Information,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
-

dn: CN=User-Account-Restrictions,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: bf967a86-0de6-11d0-a285-00aa003049e2
-

dn: CN=Validated-SPN,CN=extended-rights,CN=configuration,DC=X
changetype: ntdsSchemaModify
delete: appliesTo
appliesTo: bf967aba-0de6-11d0-a285-00aa003049e2
-

dn: CN=IntellimirrorSCP-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 2,{6dfe6488-a212-11d0-bcd5-00c04fd8d5b6}
adminPropertyPages: 3,{4e40f770-369c-11d0-8922-00a024ab2dbb}
-

dn: cn=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: spnMappings
sPNMappings: host=alerter,appmgmt,cisvc,clipsrv,browser,dhcp,dnscache,replicator,eventlog,eventsystem,policyagent,oakley,dmserver,dns,mcsvc,fax,msiserver,ias,messenger,netlogon,netman,netdde,netddedsm,nmagent,plugplay,protectedstorage,rasman,rpclocator,rpc,rpcss,remoteaccess,rsvp,samss,scardsvr,scesrv,seclogon,scm,dcom,cifs,spooler,snmp,schedule,tapisrv,trksvr,trkwks,ups,time,wins,www,http,w3svc,iisadmin
-


dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 12
-

```

### Sch13.ldf

```

# Schema NC changes

dn: CN=Initials,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: attributeSecurityGuid
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
-

dn: CN=Comment,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: attributeSecurityGuid
attributeSecurityGuid:: hri1d0qU0RGuvQAA+ANnwQ==
-

dn: CN=Sam-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RP;;;WD)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCRCWDWOSW;;;DA)(A;CI;RPWPCRLCLOCCRCWDWOSDSW;;;BA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)(A;CI;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;EA)(A;CI;LC;;;RU)(OA;CIIO;RP;037088f8-0ae1-11d2-b422-00a0c968f939;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;4c164200-20c0-11d0-a768-00aa006e0529;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RPLCLORC;;bf967a9c-0de6-11d0-a285-00aa003049e2;RU)(A;;RC;;;RU)(OA;CIIO;RPLCLORC;;bf967aba-0de6-11d0-a285-00aa003049e2;RU)S:(AU;CISAFA;WDWOSDDTWPCRCCDCSW;;;WD)
-

dn: CN=Domain-DNS,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RP;;;WD)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCRCWDWOSW;;;DA)(A;CI;RPWPCRLCLOCCRCWDWOSDSW;;;BA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)(A;CI;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;EA)(A;CI;LC;;;RU)(OA;CIIO;RP;037088f8-0ae1-11d2-b422-00a0c968f939;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;4c164200-20c0-11d0-a768-00aa006e0529;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;CIIO;RPLCLORC;;bf967a9c-0de6-11d0-a285-00aa003049e2;RU)(A;;RC;;;RU)(OA;CIIO;RPLCLORC;;bf967aba-0de6-11d0-a285-00aa003049e2;RU)S:(AU;CISAFA;WDWOSDDTWPCRCCDCSW;;;WD)
-

dn: CN=SD-Rights-Effective,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: Qi+6WaJ50BGQIADAT8LTzw==
-

dn: CN=MSMQ-Label-Ex,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQLabelEx
adminDisplayName: MSMQ-Label-Ex
adminDescription: MSMQ-Label-Ex
attributeId: 1.2.840.113556.1.4.1415
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
rangeLower: 0
rangeUpper: 124
schemaIdGuid:: Ja2ARQfU0kitJEPm5WeT1w==
showInAdvancedViewOnly: TRUE
isMemberOfPartialAttributeSet: TRUE
systemFlags: 16

dn: CN=MSMQ-Site-Name-Ex,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQSiteNameEx
adminDisplayName: MSMQ-Site-Name-Ex
adminDescription: MSMQ-Site-Name-Ex
attributeId: 1.2.840.113556.1.4.1416
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +kQhQn/BSUaU1pcx7SeE7Q==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MSMQ-Computer-Type-Ex,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: mSMQComputerTypeEx
adminDisplayName: MSMQ-Computer-Type-Ex
adminDescription: MSMQ-Computer-Type-Ex
attributeId: 1.2.840.113556.1.4.1417
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6A0SGMT0QUO9lTLrW898gA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Token-Groups-Global-And-Universal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: tokenGroupsGlobalAndUniversal
adminDisplayName: Token-Groups-Global-And-Universal
adminDescription: Token-Groups-Global-And-Universal
attributeId: 1.2.840.113556.1.4.1418
attributeSyntax: 2.5.5.17
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HbGpRq5gWkC36P+KWNRW0g==
attributeSecurityGuid:: +IhwA+EK0hG0IgCgyWj5OQ==
showInAdvancedViewOnly: TRUE
systemFlags: 134217748

# pick up the new attributes so they can be a may-contain below

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=MSMQ-Queue,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1415
-

dn: CN=MSMQ-Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1417
-

dn: CN=MSMQ-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1416
-

dn: CN=Security-Principal,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1418
-

dn: CN=Server,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;CI;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
-

dn: CN=Site,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
-

dn: CN=Servers-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;CC;;;BA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
-

# Enable iff schema changes are added above.

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Config NC changes

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: adminPropertyPages
adminPropertyPages: 8,{0910dd01-df8c-11d1-ae27-00c04fa35813}
-

dn: CN=user-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: generationQualifier,Name Suffix
attributeDisplayNames: homeDirectory,Home Directory
attributeDisplayNames: samAccountName,Downlevel Logon Name
attributeDisplayNames: st,State
attributeDisplayNames: streetAddress,Other Address
attributeDisplayNames: telephoneNumber,Primary Phone
-
add: attributeDisplayNames
attributeDisplayNames: co,Country
attributeDisplayNames: generationQualifier,Generational Suffix
attributeDisplayNames: homeDirectory,Home Folder
attributeDisplayNames: samAccountName,Logon Name (pre-Windows 2000)
attributeDisplayNames: st,State/Province
attributeDisplayNames: streetAddress,Street Address
attributeDisplayNames: telephoneNumber,Telephone Number
attributeDisplayNames: title,Job Title
-

dn: CN=group-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: physicalDeliveryOfficeName,Delivery Office
attributeDisplayNames: url,Web Page Address
-
add: attributeDisplayNames
attributeDisplayNames: physicalDeliveryOfficeName,Office Location
attributeDisplayNames: samAccountName,Group name (pre-Windows 2000)
attributeDisplayNames: url,Web Page Address (Others)
attributeDisplayNames: wWWHomePage,Web Page Address
-

dn: CN=contact-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
delete: attributeDisplayNames
attributeDisplayNames: generationQualifier,Name Suffix
attributeDisplayNames: notes,Notes
attributeDisplayNames: personalTitle,Personal Title
attributeDisplayNames: st,State
attributeDisplayNames: streetAddress,Other Address
attributeDisplayNames: telephoneNumber,Primary Phone
-
add: attributeDisplayNames
attributeDisplayNames: c,Country Abbreviation
attributeDisplayNames: co,Country
attributeDisplayNames: displayName,Display Name
attributeDisplayNames: generationQualifier,Generational Suffix
attributeDisplayNames: info,Notes
attributeDisplayNames: pager,Pager Number
attributeDisplayNames: personalTitle,Title
attributeDisplayNames: st,State/Province
attributeDisplayNames: streetAddress,Street Address
attributeDisplayNames: telephoneNumber,Telephone Number
attributeDisplayNames: title,Job Title
-

dn: CN=computer-Display,CN=409,CN=DisplaySpecifiers,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeDisplayNames
attributeDisplayNames: samAccountName,Computer name (pre-Windows 2000)
-

# Increase object version

dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 13
-

```

### Sch14.ldf

```

# Schema NC changes

dn: CN=When-Created,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=Server-Reference-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isSingleValued
isSingleValued: FALSE
-

dn: CN=SID-History,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: FALSE
-

dn: CN=Object-Sid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemOnly
systemOnly: TRUE
-

dn: CN=System-Poss-Superiors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=MSMQ-User-Sid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: systemFlags
systemFlags: 18
-

dn: CN=netboot-SCP-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: isSingleValued
isSingleValued: FALSE
-

dn: CN=ms-PKI-RA-Policies,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-RA-Policies
adminDisplayName: ms-PKI-RA-Policies
adminDescription: ms-PKI-RA-Policies
attributeId: 1.2.840.113556.1.4.1438
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Iq5G1VEJR02BfhyflvqtRg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-RA-Signature,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-RA-Signature
adminDisplayName: ms-PKI-RA-Signature
adminDescription: MS PKI Number Of RA Signature Required In Request
attributeId: 1.2.840.113556.1.4.1429
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: S+AX/n2Tfk+ODpKSyNVoPg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Enrollment-Flag,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Enrollment-Flag
adminDisplayName: ms-PKI-Enrollment-Flag
adminDescription: ms-PKI-Enrollment-Flag
attributeId: 1.2.840.113556.1.4.1430
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 2Pde0Sby20auebNOVgvRLA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Private-Key-Flag,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Private-Key-Flag
adminDisplayName: ms-PKI-Private-Key-Flag
adminDescription: ms-PKI-Private-Key-Flag
attributeId: 1.2.840.113556.1.4.1431
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wkqwujUECUeTByg4DnxwAQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Minimal-Key-Size,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Minimal-Key-Size
adminDisplayName: ms-PKI-Minimal-Key-Size
adminDescription: ms-PKI-Minimal-Key-Size
attributeId: 1.2.840.113556.1.4.1433
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9WNq6X9B00a+Utt3A8UD3w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Cert-Template-OID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Cert-Template-OID
adminDisplayName: ms-PKI-Cert-Template-OID
adminDescription: ms-PKI-Cert-Template-OID
attributeId: 1.2.840.113556.1.4.1436
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: asNkMSa6jEaL2sHlzCVnKA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Certificate-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Certificate-Policy
adminDisplayName: ms-PKI-Certificate-Policy
adminDescription: ms-PKI-Certificate-Policy
attributeId: 1.2.840.113556.1.4.1439
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RiOUOFvMS0Kn2G/9EgKcXw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Supersede-Templates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Supersede-Templates
adminDisplayName: ms-PKI-Supersede-Templates
adminDescription: ms-PKI-Supersede-Templates
attributeId: 1.2.840.113556.1.4.1437
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fa7onVt6HUK15AYfed/V1w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Certificate-Name-Flag,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Certificate-Name-Flag
adminDisplayName: ms-PKI-Certificate-Name-Flag
adminDescription: ms-PKI-Certificate-Name-Flag
attributeId: 1.2.840.113556.1.4.1432
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: xN0d6v9gbkGMwBfO5TS85w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Template-Schema-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Template-Schema-Version
adminDisplayName: ms-PKI-Template-Schema-Version
adminDescription: ms-PKI-Template-Schema-Version
attributeId: 1.2.840.113556.1.4.1434
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9ekVDB1JlEWRjzKBOgkdqQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Template-Minor-Revision,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Template-Minor-Revision
adminDisplayName: ms-PKI-Template-Minor-Revision
adminDescription: ms-PKI-Template-Minor-Revision
attributeId: 1.2.840.113556.1.4.1435
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bCP1E4QYsUa10EhOOJkNWA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Key-Recovery-Agent,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msPKI-Key-Recovery-Agent
adminDisplayName: ms-PKI-Key-Recovery-Agent
adminDescription: ms-PKI-Key-Recovery-Agent
governsId: 1.2.840.113556.1.5.195
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.9
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: OPLMJo6ghkuagqjJrH7lyw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-PKI-Key-Recovery-Agent,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-ds-Schema-Extensions,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDs-Schema-Extensions
adminDisplayName: ms-ds-Schema-Extensions
adminDescription: ms-ds-Schema-Extensions
attributeId: 1.2.840.113556.1.4.1440
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: vmGaswftq0yaSklj7QFB4Q==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Entry-TTL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: entryTTL
adminDisplayName: Entry-TTL
adminDescription: Entry-TTL
attributeId: 1.3.6.1.4.1.1466.101.119.3
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 0
rangeUpper: 31557600
schemaIdGuid:: zN4T0hrYhEOqwtz8/WMc+A==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-Other-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Other-Settings
adminDisplayName: ms-DS-Other-Settings
adminDescription: ms-DS-Other-Settings
attributeId: 1.2.840.113556.1.4.1621
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: TPPSeX2du0KDj4ZrPkQA4g==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Entry-Time-To-Die,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Entry-Time-To-Die
adminDisplayName: ms-DS-Entry-Time-To-Die
adminDescription: ms-DS-Entry-Time-To-Die
attributeId: 1.2.840.113556.1.4.1622
attributeSyntax: 2.5.5.11
omSyntax: 24
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 9
schemaIdGuid:: 17rp4d3GAUGoQ3lM7IWwOA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Site-Affinity,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Site-Affinity
adminDisplayName: ms-DS-Site-Affinity
adminDescription: ms-DS-Site-Affinity
attributeId: 1.2.840.113556.1.4.1443
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: AlZ8wbe88EaWVmNwyohLcg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Preferred-GC-Site,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Preferred-GC-Site
adminDisplayName: ms-DS-Preferred-GC-Site
adminDescription: ms-DS-Prefered-GC-Site
attributeId: 1.2.840.113556.1.4.1444
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: CrUh2bIKzUKH9gnPg6kYVA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Cached-Membership,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Cached-Membership
adminDisplayName: ms-DS-Cached-Membership
adminDescription: ms-DS-Cached-Membership
attributeId: 1.2.840.113556.1.4.1441
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: CLDKadTNyUu6uA/zfv4bIA==
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Cached-Membership-Time-Stamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Cached-Membership-Time-Stamp
adminDisplayName: ms-DS-Cached-Membership-Time-Stamp
adminDescription: ms-DS-Cached-Membership-Time-Stamp
attributeId: 1.2.840.113556.1.4.1442
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 1
schemaIdGuid:: H79mNe6+y02Kvu+J/P7GwQ==
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-DS-Auxiliary-Classes,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Auxiliary-Classes
adminDisplayName: ms-DS-Auxiliary-Classes
adminDescription: ms-DS-Auxiliary-Classes
attributeId: 1.2.840.113556.1.4.1458
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 8
schemaIdGuid:: cxCvxFDu4Eu4wImkH+mavg==
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=Structural-Object-Class,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: structuralObjectClass
adminDisplayName: Structural-Object-Class
adminDescription: The class hierarchy without auxiliary classes
attributeId: 2.5.21.9
attributeSyntax: 2.5.5.2
omSyntax: 6
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: n5RgOKj2OEuZUIHstrwpgg==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-Replication-Notify-Subsequent-DSA-Delay,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Replication-Notify-Subsequent-DSA-Delay
adminDisplayName: ms-DS-Replication-Notify-Subsequent-DSA-Delay
adminDescription: This attribute controls the delay between notification of each subsequent replica partner for an NC.
attributeId: 1.2.840.113556.1.4.1664
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hbM91pLdUkux2A0+zA6Gtg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-ID,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-ID
adminDisplayName: ms-WMI-ID
adminDescription: ms-WMI-ID
attributeId: 1.2.840.113556.1.4.1627
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: A6g5k7iU90eRI6hTuf9+RQ==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-Mof,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Mof
adminDisplayName: ms-WMI-Mof
adminDescription: ms-WMI-Mof
attributeId: 1.2.840.113556.1.4.1638
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: n4A2Z2QgPkShRYEmKx8TZg==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-Name,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Name
adminDisplayName: ms-WMI-Name
adminDescription: ms-WMI-Name
attributeId: 1.2.840.113556.1.4.1639
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 5azIxoF+r0KtcndBLFlBxA==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-Query,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Query
adminDisplayName: ms-WMI-Query
adminDescription: ms-WMI-Query
attributeId: 1.2.840.113556.1.4.1642
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Pvn/ZeM1o0WFrodsZxgpfw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-intMin,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-IntMin
adminDisplayName: ms-WMI-intMin
adminDescription: ms-WMI-intMin
attributeId: 1.2.840.113556.1.4.1630
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: uuPCaDeYcEyY4PDDNpXQIw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-intMax,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-IntMax
adminDisplayName: ms-WMI-intMax
adminDescription: ms-WMI-intMax
attributeId: 1.2.840.113556.1.4.1629
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LAyS+5TyJkSKwdJLQqorzg==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-Author,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Author
adminDisplayName: ms-WMI-Author
adminDescription: ms-WMI-Author
attributeId: 1.2.840.113556.1.4.1623
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: wcBmY3JpZk6zpR1SrQwFRw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-int8Min,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Int8Min
adminDisplayName: ms-WMI-int8Min
adminDescription: ms-WMI-int8Min
attributeId: 1.2.840.113556.1.4.1634
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 0YkU7cxUZkCzaKANqiZk8Q==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-int8Max,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Int8Max
adminDisplayName: ms-WMI-int8Max
adminDescription: ms-WMI-int8Max
attributeId: 1.2.840.113556.1.4.1633
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: R7XY4z0ARkmjK9x87clrdA==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-COM-ObjectId,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCOM-ObjectId
adminDisplayName: ms-COM-ObjectId
adminDescription: Object ID that COM+ uses. Default = adminDisplayName
attributeId: 1.2.840.113556.1.4.1428
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: i2cPQ5+I8kGYQyA7WmVXLw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-COM-UserPartitionSetLink,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCOM-UserPartitionSetLink
adminDisplayName: ms-COM-UserPartitionSetLink
adminDescription: Link from a User to a PartitionSet. Default = adminDisplayName
attributeId: 1.2.840.113556.1.4.1426
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: igyUjnfkZ0Owjf8v+ULc1w==
linkID: 1048
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-COM-UserLink,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCOM-UserLink
adminDisplayName: ms-COM-UserLink
adminDescription: Link from a PartitionSet to a User. Default = adminDisplayName
attributeId: 1.2.840.113556.1.4.1425
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: TTpvniwkN0+waDa1f5/IUg==
linkID: 1049
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-WMI-ChangeDate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-ChangeDate
adminDisplayName: ms-WMI-ChangeDate
adminDescription: ms-WMI-ChangeDate
attributeId: 1.2.840.113556.1.4.1624
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: oPfN+UTsN0mnm82RUis6qA==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-intDefault,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-IntDefault
adminDisplayName: ms-WMI-intDefault
adminDescription: ms-WMI-intDefault
attributeId: 1.2.840.113556.1.4.1628
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: +AcMG912YECh4XAIRhnckA==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-TargetPath,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-TargetPath
adminDisplayName: ms-WMI-TargetPath
adminDescription: ms-WMI-TargetPath
attributeId: 1.2.840.113556.1.4.1648
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mqcGUP5rYUWfUhPPTdPlYA==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-TargetType,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-TargetType
adminDisplayName: ms-WMI-TargetType
adminDescription: ms-WMI-TargetType
attributeId: 1.2.840.113556.1.4.1649
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Higqyism90+0GbwSM1Kk6Q==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-int8Default,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Int8Default
adminDisplayName: ms-WMI-int8Default
adminDescription: ms-WMI-int8Default
attributeId: 1.2.840.113556.1.4.1632
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: WgjY9FuMhUeVm9xYVWbkRQ==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-TargetClass,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-TargetClass
adminDisplayName: ms-WMI-TargetClass
adminDescription: ms-WMI-TargetClass
attributeId: 1.2.840.113556.1.4.1645
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 1ti2lejJYUaivGpcq8BMYg==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-CreationDate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-CreationDate
adminDisplayName: ms-WMI-CreationDate
adminDescription: ms-WMI-CreationDate
attributeId: 1.2.840.113556.1.4.1626
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: LgqLdFEzP0uxcS8XQU6neQ==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-TargetObject,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-TargetObject
adminDisplayName: ms-WMI-TargetObject
adminDescription: ms-WMI-TargetObject
attributeId: 1.2.840.113556.1.4.1647
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: pWdPxOV9H0qS2WYrVzZLdw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-PropertyName,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-PropertyName
adminDisplayName: ms-WMI-PropertyName
adminDescription: ms-WMI-PropertyName
attributeId: 1.2.840.113556.1.4.1641
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: gwiSq/jnck20oMBEmJdQnQ==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-COM-PartitionLink,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCOM-PartitionLink
adminDisplayName: ms-COM-PartitionLink
adminDescription: Link from a PartitionSet to a Partition. Default = adminDisplayName
attributeId: 1.2.840.113556.1.4.1423
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: YqyrCT8EAkesK2yhXu5XVA==
linkID: 1040
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-QueryLanguage,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-QueryLanguage
adminDisplayName: ms-WMI-QueryLanguage
adminDescription: ms-WMI-QueryLanguage
attributeId: 1.2.840.113556.1.4.1643
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: mPo8fXvBVEKL103puTKjRQ==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-stringDefault,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-StringDefault
adminDisplayName: ms-WMI-stringDefault
adminDescription: ms-WMI-stringDefault
attributeId: 1.2.840.113556.1.4.1636
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: tkIuFcU3VU+rSBYGOEqa6g==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-intValidValues,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-IntValidValues
adminDisplayName: ms-WMI-intValidValues
adminDescription: ms-WMI-intValidValues
attributeId: 1.2.840.113556.1.4.1631
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9mX1akmnckuWNDxdR+a04A==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-DS-Behavior-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Behavior-Version
adminDisplayName: ms-DS-Behavior-Version
adminDescription: ms-DS-Behavior-Version
attributeId: 1.2.840.113556.1.4.1459
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
rangeLower: 0
schemaIdGuid:: V4ca00ckRUWAgTu2EMrL8g==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-int8ValidValues,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Int8ValidValues
adminDisplayName: ms-WMI-int8ValidValues
adminDescription: ms-WMI-int8ValidValues
attributeId: 1.2.840.113556.1.4.1635
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: qRk1EALAG0SYGrCz4BLIAw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-TargetNameSpace,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-TargetNameSpace
adminDisplayName: ms-WMI-TargetNameSpace
adminDescription: ms-WMI-TargetNameSpace
attributeId: 1.2.840.113556.1.4.1646
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: H7ZKHCA05USEnYtdv2D+tw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-ClassDefinition,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-ClassDefinition
adminDisplayName: ms-WMI-ClassDefinition
adminDescription: ms-WMI-ClassDefinition
attributeId: 1.2.840.113556.1.4.1625
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: vA6cK3LCy0WZ0k0OaRYy4A==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-WMI-NormalizedClass,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-NormalizedClass
adminDisplayName: ms-WMI-NormalizedClass
adminDescription: ms-WMI-NormalizedClass
attributeId: 1.2.840.113556.1.4.1640
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: j2K66o7r6U+D/Gk75pVVmw==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-COM-PartitionSetLink,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCOM-PartitionSetLink
adminDisplayName: ms-COM-PartitionSetLink
adminDescription: Link from a Partition to a PartitionSet. Default = adminDisplayName
attributeId: 1.2.840.113556.1.4.1424
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 3CHxZwJ9fUyC9ZrUyVCsNA==
linkID: 1041
showInAdvancedViewOnly: TRUE
systemFlags: 17

dn: CN=ms-WMI-stringValidValues,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-StringValidValues
adminDisplayName: ms-WMI-stringValidValues
adminDescription: ms-WMI-stringValidValues
attributeId: 1.2.840.113556.1.4.1637
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: MZ1gN7+iWEuPUytk5XoHbQ==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-DS-NC-Replica-Locations,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-NC-Replica-Locations
adminDisplayName: ms-DS-NC-Replica-Locations
adminDescription: This is a list of servers that are the replica set for the corresponding Non-Domain Naming Context.
attributeId: 1.2.840.113556.1.4.1661
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: FZbelze1vEasDxByDzkJ8w==
linkID: 1044
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-SourceOrganization,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-SourceOrganization
adminDisplayName: ms-WMI-SourceOrganization
adminDescription: ms-WMI-SourceOrganization
attributeId: 1.2.840.113556.1.4.1644
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bO33NF1hjUGqAFSafXvgPg==
showInAdvancedViewOnly: FALSE
systemFlags: 16

dn: CN=ms-COM-DefaultPartitionLink,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msCOM-DefaultPartitionLink
adminDisplayName: ms-COM-DefaultPartitionLink
adminDescription: Link to a the default Partition for the PartitionSet. Default = adminDisplayName
attributeId: 1.2.840.113556.1.4.1427
attributeSyntax: 2.5.5.1
omSyntax: 127
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
omObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 9xCLmRqqZEO4Z3U9GX/mcA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-User-Account-Control-Computed,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-User-Account-Control-Computed
adminDisplayName: ms-DS-User-Account-Control-Computed
adminDescription: ms-DS-User-Account-Control-Computed
attributeId: 1.2.840.113556.1.4.1460
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: NrjELD+2QEmNI+p6zwavVg==
attributeSecurityGuid:: AEIWTMAg0BGnaACqAG4FKQ==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-Replication-Notify-First-DSA-Delay,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Replication-Notify-First-DSA-Delay
adminDisplayName: ms-DS-Replication-Notify-First-DSA-Delay
adminDescription: This attribute controls the delay between changes to the DS, and notification of the first replica partner for an NC.
attributeId: 1.2.840.113556.1.4.1663
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9NSrhYkKSU697G81uyViug==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Approx-Immed-Subordinates,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Approx-Immed-Subordinates
adminDisplayName: ms-DS-Approx-Immed-Subordinates
adminDescription: ms-DS-Approx-Immed-Subordinates
attributeId: 1.2.840.113556.1.4.1669
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: TRUE
searchFlags: 0
schemaIdGuid:: Q9KF4c7220q0lrDABdeCPA==
attributeSecurityGuid:: VAGN5Pi80RGHAgDAT7lgUA==
showInAdvancedViewOnly: TRUE
systemFlags: 20

# Load new attributes into the schema cache for inclusion below

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=PKI-Certificate-Template,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1429
systemMayContain: 1.2.840.113556.1.4.1430
systemMayContain: 1.2.840.113556.1.4.1431
systemMayContain: 1.2.840.113556.1.4.1432
systemMayContain: 1.2.840.113556.1.4.1433
systemMayContain: 1.2.840.113556.1.4.1434
systemMayContain: 1.2.840.113556.1.4.1435
systemMayContain: 1.2.840.113556.1.4.1436
systemMayContain: 1.2.840.113556.1.4.1437
systemMayContain: 1.2.840.113556.1.4.1438
systemMayContain: 1.2.840.113556.1.4.1439
-

dn: CN=ms-PKI-Enterprise-Oid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msPKI-Enterprise-Oid
adminDisplayName: ms-PKI-Enterprise-Oid
adminDescription: ms-PKI-Enterprise-Oid
governsId: 1.2.840.113556.1.5.196
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1436
systemPossSuperiors: 1.2.840.113556.1.5.196
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: XNjPNxln2EqPnoZ4umJ1Yw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-PKI-Enterprise-Oid,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Class-Schema,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1440
-

dn: CN=Attribute-Schema,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1440
-

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1441
systemMayContain: 1.2.840.113556.1.4.1442
systemMayContain: 1.2.840.113556.1.4.1443
-

dn: CN=NTDS-Site-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1444
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 2.5.21.9
-

dn: CN=ms-WMI-Som,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-Som
adminDisplayName: ms-WMI-Som
adminDescription: ms-WMI-Som
governsId: 1.2.840.113556.1.5.213
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1639
systemMustContain: 1.2.840.113556.1.4.1644
systemMustContain: 1.2.840.113556.1.4.1623
systemMustContain: 1.2.840.113556.1.4.1624
systemMustContain: 1.2.840.113556.1.4.1626
systemMustContain: 1.2.840.113556.1.4.1627
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: eHCFq0IBBkSUWzTJtrEzcg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-Som,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-PolicyTemplate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-PolicyTemplate
adminDisplayName: ms-WMI-PolicyTemplate
adminDescription: ms-WMI-PolicyTemplate
governsId: 1.2.840.113556.1.5.200
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1626
systemMustContain: 1.2.840.113556.1.4.1624
systemMustContain: 1.2.840.113556.1.4.1623
systemMustContain: 1.2.840.113556.1.4.1644
systemMustContain: 1.2.840.113556.1.4.1640
systemMustContain: 1.2.840.113556.1.4.1648
systemMustContain: 1.2.840.113556.1.4.1645
systemMustContain: 1.2.840.113556.1.4.1646
systemMustContain: 1.2.840.113556.1.4.1639
systemMustContain: 1.2.840.113556.1.4.1627
systemMayContain: 1.2.840.113556.1.4.1649
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: 8YC84kokWU2sxspcT4Lm4Q==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-PolicyTemplate,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-WMIGPO,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-WMIGPO
adminDisplayName: ms-WMI-WMIGPO
adminDescription: ms-WMI-WMIGPO
governsId: 1.2.840.113556.1.5.215
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1645
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: AABjBSc53k6/J8qR8nXCbw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-WMIGPO,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-COM-Partition,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msCOM-Partition
adminDisplayName: ms-COM-Partition
adminDescription: Partition class. Default = adminDisplayName
governsId: 1.2.840.113556.1.5.193
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1428
systemPossSuperiors: 1.2.840.113556.1.5.67
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: dA4ByVhO90mKiV4+I0D8+A==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-COM-Partition,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-PolicyType,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-PolicyType
adminDisplayName: ms-WMI-PolicyType
adminDescription: ms-WMI-PolicyType
governsId: 1.2.840.113556.1.5.211
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1626
systemMustContain: 1.2.840.113556.1.4.1624
systemMustContain: 1.2.840.113556.1.4.1623
systemMustContain: 1.2.840.113556.1.4.1644
systemMustContain: 1.2.840.113556.1.4.1647
systemMustContain: 1.2.840.113556.1.4.1627
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: EyZbWQlBd06QE6O7TvJ3xw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-PolicyType,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-ShadowObject,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-ShadowObject
adminDisplayName: ms-WMI-ShadowObject
adminDescription: ms-WMI-ShadowObject
governsId: 1.2.840.113556.1.5.212
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1647
systemPossSuperiors: 1.2.840.113556.1.5.211
schemaIdGuid:: 30vk8dONNUKchvkfMfW1aQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-ShadowObject,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-COM-PartitionSet,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msCOM-PartitionSet
adminDisplayName: ms-COM-PartitionSet
adminDescription: PartitionSet class. Default = adminDisplayName
governsId: 1.2.840.113556.1.5.194
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1423
systemMayContain: 1.2.840.113556.1.4.1427
systemMayContain: 1.2.840.113556.1.4.1428
systemPossSuperiors: 1.2.840.113556.1.5.67
systemPossSuperiors: 2.5.6.5
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: q2QEJRfEekmXWp4NRZp8oQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-COM-PartitionSet,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-Rule,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-Rule
adminDisplayName: ms-WMI-Rule
adminDescription: ms-WMI-Rule
governsId: 1.2.840.113556.1.5.214
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1643
systemMustContain: 1.2.840.113556.1.4.1646
systemMustContain: 1.2.840.113556.1.4.1642
systemPossSuperiors: 1.2.840.113556.1.5.213
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: g29+PA7dG0igwnTNlu8qZg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-Rule,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1426
systemMayContain: 1.2.840.113556.1.4.1460
-

dn: CN=Cross-Ref,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1661
systemMayContain: 1.2.840.113556.1.4.1663
systemMayContain: 1.2.840.113556.1.4.1664
-

dn: CN=NTDS-DSA,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1459
-

dn: CN=Cross-Ref-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1459
-

dn: CN=Domain-DNS,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1459
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1669
-

dn: CN=Dynamic-Object,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: dynamicObject
adminDisplayName: Dynamic-Object
adminDescription: Dynamic-Object
governsId: 1.3.6.1.4.1.1466.101.119.2
objectClassCategory: 3
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1622
systemMayContain: 1.3.6.1.4.1.1466.101.119.3
schemaIdGuid:: SRLVZlUzH0yyToHyUqyiOw==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=Dynamic-Object,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=NTDS-Service,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1621
-

# Reload new schema cache to pick up classes used in subclassof

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-WMI-MergeablePolicyTemplate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-MergeablePolicyTemplate
adminDisplayName: ms-WMI-MergeablePolicyTemplate
adminDescription: ms-WMI-MergeablePolicyTemplate
governsId: 1.2.840.113556.1.5.202
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.200
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: FCRQB8r9UUiwShNkWxHSJg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-MergeablePolicyTemplate,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

# Reload new schema cache to pick up classes used in possSuperiors

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-WMI-RangeParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-RangeParam
adminDisplayName: ms-WMI-RangeParam
adminDescription: ms-WMI-RangeParam
governsId: 1.2.840.113556.1.5.203
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1649
systemMustContain: 1.2.840.113556.1.4.1645
systemMustContain: 1.2.840.113556.1.4.1641
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: V1r7RRhQD02QVpl8jJEi2Q==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-RangeParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

# Reload new schema cache to pick up classes used in possSuperiors

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-WMI-StringSetParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-StringSetParam
adminDisplayName: ms-WMI-StringSetParam
adminDescription: ms-WMI-StringSetParam
governsId: 1.2.840.113556.1.5.210
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1636
systemMayContain: 1.2.840.113556.1.4.1637
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: onnFC6cd6ky2mYB/O51jpA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-StringSetParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-UnknownRangeParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-UnknownRangeParam
adminDisplayName: ms-WMI-UnknownRangeParam
adminDescription: ms-WMI-UnknownRangeParam
governsId: 1.2.840.113556.1.5.204
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1647
systemMustContain: 1.2.840.113556.1.4.1640
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: a8IquNvGmECSxknBijM24Q==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-UnknownRangeParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-RealRangeParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-RealRangeParam
adminDisplayName: ms-WMI-RealRangeParam
adminDescription: ms-WMI-RealRangeParam
governsId: 1.2.840.113556.1.5.209
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1632
systemMayContain: 1.2.840.113556.1.4.1633
systemMayContain: 1.2.840.113556.1.4.1634
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: 4o/+arxwzkyxZqlvc1nFFA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-RealRangeParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-SimplePolicyTemplate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-SimplePolicyTemplate
adminDisplayName: ms-WMI-SimplePolicyTemplate
adminDescription: ms-WMI-SimplePolicyTemplate
governsId: 1.2.840.113556.1.5.201
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.200
systemMustContain: 1.2.840.113556.1.4.1647
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: tbLIbN8S9kSDB+dPXN7jaQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-SimplePolicyTemplate,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-IntSetParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-IntSetParam
adminDisplayName: ms-WMI-IntSetParam
adminDescription: ms-WMI-IntSetParam
governsId: 1.2.840.113556.1.5.206
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1628
systemMayContain: 1.2.840.113556.1.4.1631
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: mg0vKXbPsEKEH7ZQ8zHfYg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-IntSetParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-UintSetParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-UintSetParam
adminDisplayName: ms-WMI-UintSetParam
adminDescription: ms-WMI-UintSetParam
governsId: 1.2.840.113556.1.5.208
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1628
systemMayContain: 1.2.840.113556.1.4.1631
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: MetLjxlO9UaTLl+gPDObHQ==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPCCDCLCLODTRC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-UintSetParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-IntRangeParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-IntRangeParam
adminDisplayName: ms-WMI-IntRangeParam
adminDescription: ms-WMI-IntRangeParam
governsId: 1.2.840.113556.1.5.205
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1628
systemMayContain: 1.2.840.113556.1.4.1629
systemMayContain: 1.2.840.113556.1.4.1630
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: fV3KUItc806531tm1JHlJg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-IntRangeParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-WMI-UintRangeParam,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-UintRangeParam
adminDisplayName: ms-WMI-UintRangeParam
adminDescription: ms-WMI-UintRangeParam
governsId: 1.2.840.113556.1.5.207
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.203
systemMustContain: 1.2.840.113556.1.4.1628
systemMayContain: 1.2.840.113556.1.4.1629
systemMayContain: 1.2.840.113556.1.4.1630
systemPossSuperiors: 1.2.840.113556.1.5.202
schemaIdGuid:: spmn2fPOs0i1rfuF+N0yFA==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-UintRangeParam,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

# Reload new schema cache

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Config NC changes

dn: CN=KRA,CN=Public Key Services,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: Container
ShowInAdvancedViewOnly: TRUE

dn: CN=OID,CN=Public Key Services,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: msPKI-Enterprise-Oid
ShowInAdvancedViewOnly: TRUE

dn: CN=Generate-RSoP,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
ShowInAdvancedViewOnly: TRUE
appliesTo: bf967aa5-0de6-11d0-a285-00aa003049e2
appliesTo: 19195a5b-6da0-11d0-afd3-00c04fd930c9
displayName: Generate Resultant Set of Policy
localizationDisplayId: 55
rightsGUID: b7b1b3dd-ab09-4242-9e30-9980e5d322f7
validAccesses: 256

dn: CN=Directory Service,CN=Windows NT,CN=Services,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: msDS-Other-Settings
msDS-Other-Settings: DynamicObjectDefaultTTL=86400
msDS-Other-Settings: DynamicObjectMinTTL=900
-

# Increase object version

dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 14
-

```

### Sch15.ldf

```

# Schema NC changes

dn: CN=ms-WMI-Parm1,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Parm1
adminDisplayName: ms-WMI-Parm1
adminDescription: ms-WMI-Parm1
attributeId: 1.2.840.113556.1.4.1682
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: hRToJ7Cxi0q+3c4ZqDfibg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-Parm2,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Parm2
adminDisplayName: ms-WMI-Parm2
adminDescription: ms-WMI-Parm2
attributeId: 1.2.840.113556.1.4.1683
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: jlADAEKcdkqo9Di/ZLqw3g==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-Parm3,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Parm3
adminDisplayName: ms-WMI-Parm3
adminDescription: ms-WMI-Parm3
attributeId: 1.2.840.113556.1.4.1684
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: to+VRb1Szkifn8JxLZ8r/A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-Parm4,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Parm4
adminDisplayName: ms-WMI-Parm4
adminDescription: ms-WMI-Parm4
attributeId: 1.2.840.113556.1.4.1685
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: o9UAOM7xgkulmhUo6nlfWQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-Class,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Class
adminDisplayName: ms-WMI-Class
adminDescription: ms-WMI-Class
attributeId: 1.2.840.113556.1.4.1676
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: X5LBkCRKB0uyAr4y6zyLdA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-Genus,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-Genus
adminDisplayName: ms-WMI-Genus
adminDescription: ms-WMI-Genus
attributeId: 1.2.840.113556.1.4.1677
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: OmfIUFaPFEaTCJ4TQPua8w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-OID-CPS,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-OID-CPS
adminDisplayName: ms-PKI-OID-CPS
adminDescription: ms-PKI-OID-CPS
attributeId: 1.2.840.113556.1.4.1672
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: DpRJX5+nUUq7bz1EalTcaw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=GPC-WQL-Filter,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: gPCWQLFilter
adminDisplayName: GPC-WQL-Filter
adminDescription: GPC-WQL-Filter
attributeId: 1.2.840.113556.1.4.1694
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: psfUe90aNkSMBDmZqIAVTA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Extra-Columns,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: extraColumns
adminDisplayName: Extra-Columns
adminDescription: Extra-Columns
attributeId: 1.2.840.113556.1.4.1687
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RihO0tkdz0uZ16YifMhtpw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-intFlags1,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-intFlags1
adminDisplayName: ms-WMI-intFlags1
adminDescription: ms-WMI-intFlags1
attributeId: 1.2.840.113556.1.4.1678
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: uQbgGEVk40idz7Xs+8Tfjg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-intFlags2,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-intFlags2
adminDisplayName: ms-WMI-intFlags2
adminDescription: ms-WMI-intFlags2
attributeId: 1.2.840.113556.1.4.1679
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: yUJaB1rFsUWsk+sIazH2EA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-intFlags3,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-intFlags3
adminDisplayName: ms-WMI-intFlags3
adminDescription: ms-WMI-intFlags3
attributeId: 1.2.840.113556.1.4.1680
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Nqef8gne5EuyOuc0wSS6zA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-intFlags4,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-intFlags4
adminDisplayName: ms-WMI-intFlags4
adminDescription: ms-WMI-intFlags4
attributeId: 1.2.840.113556.1.4.1681
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: rKd0vZPEnEy9+lx7EZymsg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-WMI-ScopeGuid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msWMI-ScopeGuid
adminDisplayName: ms-WMI-ScopeGuid
adminDescription: ms-WMI-ScopeGuid
attributeId: 1.2.840.113556.1.4.1686
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: UY23h19Af0uA7SvSh4b0jQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-FRS-Hub-Member,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msFRS-Hub-Member
adminDisplayName: ms-FRS-Hub-Member
adminDescription: ms-FRS-Hub-Member
attributeId: 1.2.840.113556.1.4.1693
attributeSyntax: 2.5.5.1
omSyntax: 127
omObjectClass:: KwwCh3McAIVK
linkID: 1046
isSingleValued: TRUE
searchFlags: 0
schemaIdGuid:: gf9DVrY1qUyVErrwvQoncg==
showInAdvancedViewOnly: TRUE

dn: CN=ms-PKI-OID-Attribute,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-OID-Attribute
adminDisplayName: ms-PKI-OID-Attribute
adminDescription: ms-PKI-OID-Attribute
attributeId: 1.2.840.113556.1.4.1671
attributeSyntax: 2.5.5.9
omSyntax: 2
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: iBKejChQT0+nBHbQJvJG7w==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-FRS-Topology-Pref,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msFRS-Topology-Pref
adminDisplayName: ms-FRS-Topology-Pref
adminDescription: ms-FRS-Topology-Pref
attributeId: 1.2.840.113556.1.4.1692
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
searchFlags: 0
schemaIdGuid:: 4CeqklBcLUCewe6Efe+XiA==
showInAdvancedViewOnly: TRUE

dn: CN=ms-PKI-OID-User-Notice,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-OID-User-Notice
adminDisplayName: ms-PKI-OID-User-Notice
adminDescription: ms-PKI-OID-User-Notice
attributeId: 1.2.840.113556.1.4.1673
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: etrEBBThaU6I3uKT8tOzlQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-RA-Application-Policies,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-RA-Application-Policies
adminDisplayName: ms-PKI-RA-Application-Policies
adminDescription: ms-PKI-RA-Application-Policies
attributeId: 1.2.840.113556.1.4.1675
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: v/uRPHNHzUyoe4XVPnvPag==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Admin-Multiselect-Property-Pages,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: adminMultiselectPropertyPages
adminDisplayName: Admin-Multiselect-Property-Pages
adminDescription: Admin-Multiselect-Property-Pages
attributeId: 1.2.840.113556.1.4.1690
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: fbb5GMZaO0uX29CkBq+3ug==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Security-Group-Extra-Classes,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Security-Group-Extra-Classes
adminDisplayName: ms-DS-Security-Group-Extra-Classes
adminDescription: ms-DS-Security-Group-Extra-Classes
attributeId: 1.2.840.113556.1.4.1688
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 6GoUT/6kAUinMfUYSKT05A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-PKI-Certificate-Application-Policy,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msPKI-Certificate-Application-Policy
adminDisplayName: ms-PKI-Certificate-Application-Policy
adminDescription: ms-PKI-Certificate-Application-Policy
attributeId: 1.2.840.113556.1.4.1674
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: SAXZ2zeqAkKZZoxTe6XOMg==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Non-Security-Group-Extra-Classes,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Non-Security-Group-Extra-Classes
adminDisplayName: Non-Security-Group-Extra-Classes
adminDescription: ms-DS-Non-Security-Group-Extra-Classes
attributeId: 1.2.840.113556.1.4.1689
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: /EThLVIfb0i99Bb8wwhOVA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=MSMQ-Recipient-FormatName,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msMQ-Recipient-FormatName
adminDisplayName: MSMQ-Recipient-FormatName
adminDescription: MSMQ-Recipient-FormatName
attributeId: 1.2.840.113556.1.4.1695
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 255
schemaIdGuid:: SGf+O0S1WkiwZxsxDEM0vw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Last-Logon-Timestamp,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: lastLogonTimestamp
adminDisplayName: Last-Logon-Timestamp
adminDescription: Last-Logon-Timestamp
attributeId: 1.2.840.113556.1.4.1696
attributeSyntax: 2.5.5.16
omSyntax: 65
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: BAriwFoO80+Ugl7+rs1wYA==
attributeSecurityGuid:: ECAgX6V50BGQIADAT8LUzw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-Settings
adminDisplayName: ms-DS-Settings
adminDescription: ms-DS-Settings
attributeId: 1.2.840.113556.1.4.1697
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 10cbDqNASEuNG0ysDBzfIQ==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TAPI-Unique-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTAPI-uid
adminDisplayName: msTAPI-uid
adminDescription: msTAPI-uid
attributeId: 1.2.840.113556.1.4.1698
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
rangeUpper: 120
schemaIdGuid:: 6uekcLmzQ0aJGObdJHG/1A==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TAPI-Ip-Address,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTAPI-IpAddress
adminDisplayName: msTAPI-IpAddress
adminDescription: msTAPI-IpAddress
attributeId: 1.2.840.113556.1.4.1701
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 99fX744XZ0eH+viha4QFRA==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TAPI-Protocol-Id,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTAPI-ProtocolId
adminDisplayName: msTAPI-ProtocolId
adminDescription: msTAPI-ProtocolId
attributeId: 1.2.840.113556.1.4.1699
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: z+vBiV96/UGZyskAsyKZqw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-TAPI-Conference-Blob,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msTAPI-ConferenceBlob
adminDisplayName: msTAPI-ConferenceBlob
adminDescription: msTAPI-ConferenceBlob
attributeId: 1.2.840.113556.1.4.1700
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: HmDETAFyQUGryD5SmuiIYw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=Is-Member-Of-DL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: attributeSecurityGuid
attributeSecurityGuid:: QMIKvKl50BGQIADAT8LUzw==
-

dn: CN=ms-DS-Entry-Time-To-Die,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: searchFlags
searchFlags: 9
-

dn: CN=ms-DS-Trust-Forest-Trust-Info,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-TrustForestTrustInfo
adminDisplayName: ms-DS-Trust-Forest-Trust-Info
adminDescription: ms-DS-Trust-Forest-Trust-Info
attributeId: 1.2.840.113556.1.4.1702
attributeSyntax: 2.5.5.10
omSyntax: 4
isSingleValued: TRUE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: bobMKdNJaUmULh28CSXRgw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-Exch-Owner-BL,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
lDAPDisplayName: ownerBL
adminDescription: ms-Exch-Owner-BL
adminDisplayName: ms-Exch-Owner-BL
attributeID: 1.2.840.113556.1.2.104
attributeSyntax: 2.5.5.1
oMSyntax: 127
isSingleValued: FALSE
systemOnly: TRUE
searchFlags: 0
oMObjectClass:: KwwCh3McAIVK
schemaIdGuid:: 9HmWv+YN0BGihQCqADBJ4g==
linkID: 45
showInAdvancedViewOnly: TRUE
systemFlags: 17

# Load the schema cache to pick up new attributes

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

dn: CN=ms-WMI-ObjectEncoding,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msWMI-ObjectEncoding
adminDisplayName: ms-WMI-ObjectEncoding
adminDescription: ms-WMI-ObjectEncoding
governsId: 1.2.840.113556.1.5.217
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1676
systemMustContain: 1.2.840.113556.1.4.1686
systemMustContain: 1.2.840.113556.1.4.1682
systemMustContain: 1.2.840.113556.1.4.1683
systemMustContain: 1.2.840.113556.1.4.1684
systemMustContain: 1.2.840.113556.1.4.1685
systemMustContain: 1.2.840.113556.1.4.1677
systemMustContain: 1.2.840.113556.1.4.1678
systemMustContain: 1.2.840.113556.1.4.1679
systemMustContain: 1.2.840.113556.1.4.1680
systemMustContain: 1.2.840.113556.1.4.1681
systemMustContain: 1.2.840.113556.1.4.1627
systemMustContain: 1.2.840.113556.1.4.1647
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: yYHdVRLD+UGoTcatvfHo4Q==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-WMI-ObjectEncoding,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Application-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: applicationVersion
adminDisplayName: Application-Version
adminDescription: Stores versioning information for an application and its schema.
governsId: 1.2.840.113556.1.5.216
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.7000.49
systemMayContain: 1.2.840.113556.1.4.329
systemMayContain: 1.2.840.113556.1.4.328
systemMayContain: 1.2.840.113556.1.4.141
systemMayContain: 1.2.840.113556.1.4.255
systemMayContain: 1.2.840.113556.1.4.848
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: rJDH3U2vKkSPD6HUyqfdkg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=Application-Version,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1424
systemMayContain: 1.2.840.113556.1.4.1425
-

dn: CN=Top,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.2.104
-

dn: CN=Organizational-Unit,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1426
-

dn: CN=Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.892
systemMayContain: 1.2.840.113556.1.4.891
-

dn: CN=Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemPossSuperiors
systemPossSuperiors: 1.2.840.113556.1.3.30
-

dn: CN=Group-Policy-Container,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1694
-

dn: CN=FT-Dfs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.137
-

dn: CN=PKI-Certificate-Template,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1674
systemMayContain: 1.2.840.113556.1.4.1675
-

dn: CN=ms-PKI-Enterprise-Oid,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1671
systemMayContain: 1.2.840.113556.1.4.1672
systemMayContain: 1.2.840.113556.1.4.1673
-

dn: CN=ms-WMI-PolicyTemplate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCDCRCWDWOSW;;;DA)(A;;CC;;;PA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1678
systemMayContain: 1.2.840.113556.1.4.1679
systemMayContain: 1.2.840.113556.1.4.1680
systemMayContain: 1.2.840.113556.1.4.1681
systemMayContain: 1.2.840.113556.1.4.1682
systemMayContain: 1.2.840.113556.1.4.1683
systemMayContain: 1.2.840.113556.1.4.1684
systemMayContain: 1.2.840.113556.1.4.1685
-

dn: CN=ms-WMI-PolicyType,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCDCRCWDWOSW;;;DA)(A;;CC;;;PA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1685
systemMayContain: 1.2.840.113556.1.4.1684
systemMayContain: 1.2.840.113556.1.4.1683
systemMayContain: 1.2.840.113556.1.4.1682
systemMayContain: 1.2.840.113556.1.4.1681
systemMayContain: 1.2.840.113556.1.4.1680
systemMayContain: 1.2.840.113556.1.4.1679
systemMayContain: 1.2.840.113556.1.4.1678
-

dn: CN=Display-Specifier,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1687
systemMayContain: 1.2.840.113556.1.4.1690
-

dn: CN=DS-UI-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1688
systemMayContain: 1.2.840.113556.1.4.1689
-

dn: CN=ms-WMI-Som,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCDCRCWDWOSW;;;DA)(A;;CC;;;PA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1685
systemMayContain: 1.2.840.113556.1.4.1684
systemMayContain: 1.2.840.113556.1.4.1683
systemMayContain: 1.2.840.113556.1.4.1682
systemMayContain: 1.2.840.113556.1.4.1681
systemMayContain: 1.2.840.113556.1.4.1680
systemMayContain: 1.2.840.113556.1.4.1679
systemMayContain: 1.2.840.113556.1.4.1678
-

dn: CN=ms-WMI-WMIGPO,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultSecurityDescriptor
defaultSecurityDescriptor: D:(A;;RPLCLORC;;;AU)(A;;RPWPCRLCLOCCDCRCWDWOSW;;;DA)(A;;CC;;;PA)(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)
-
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1685
systemMayContain: 1.2.840.113556.1.4.1684
systemMayContain: 1.2.840.113556.1.4.1683
systemMayContain: 1.2.840.113556.1.4.1682
systemMayContain: 1.2.840.113556.1.4.1681
systemMayContain: 1.2.840.113556.1.4.1680
systemMayContain: 1.2.840.113556.1.4.1679
systemMayContain: 1.2.840.113556.1.4.1678
-

dn: CN=NTFRS-Replica-Set,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1692
systemMayContain: 1.2.840.113556.1.4.1693
-

dn: CN=Service-Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.141
systemMayContain: 1.2.840.113556.1.4.255
systemMayContain: 1.2.840.113556.1.4.328
systemMayContain: 1.2.840.113556.1.4.329
systemMayContain: 1.2.840.113556.1.4.848
-

dn: CN=MSMQ-Group,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msMQ-Group
adminDisplayName: MSMQ-Group
adminDescription: MSMQ-Group
governsId: 1.2.840.113556.1.5.219
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 2.5.4.31
systemPossSuperiors: 2.5.6.5
schemaIdGuid:: rHqyRvqq+0+3c+W/Yh7oew==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Group,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=MSMQ-Custom-Recipient,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msMQ-Custom-Recipient
adminDisplayName: MSMQ-Custom-Recipient
adminDescription: MSMQ-Custom-Recipient
governsId: 1.2.840.113556.1.5.218
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1695
systemPossSuperiors: 2.5.6.5
schemaIdGuid:: F2hth8w1bEOs6l73F03Zvg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=MSMQ-Custom-Recipient,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=User,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1696
-

dn: CN=FT-Dfs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.48
systemMayContain: 1.2.840.113556.1.4.653
-

dn: CN=ms-DS-App-Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msDS-App-Configuration
adminDisplayName: ms-DS-App-Configuration
adminDescription: Stores configuration parameters for an application.
governsId: 1.2.840.113556.1.5.220
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 1.2.840.113556.1.5.7000.49
systemPossSuperiors: 1.2.840.113556.1.3.30
systemPossSuperiors: 1.2.840.113556.1.3.23
schemaIdGuid:: PjzfkFQYVUSl18rUDVZleg==
defaultSecurityDescriptor: D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)(A;;RPLCLORC;;;AU)
showInAdvancedViewOnly: TRUE
defaultHidingValue: FALSE
systemOnly: FALSE
defaultObjectCategory: CN=ms-DS-App-Configuration,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Connection-Point,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1697
-

dn: CN=Application-Settings,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1697
-

dn: CN=ms-TAPI-Rt-Person,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msTAPI-RtPerson
adminDisplayName: msTAPI-RtPerson
adminDescription: msTAPI-RtPerson
governsId: 1.2.840.113556.1.5.222
objectClassCategory: 1
rdnAttId: 2.5.4.3
subClassOf: 2.5.6.0
systemMayContain: 1.2.840.113556.1.4.1701
systemPossSuperiors: 2.5.6.4
systemPossSuperiors: 2.5.6.5
schemaIdGuid:: tRzqUwS3+U2Bj1y07IbKwQ==
defaultSecurityDescriptor: D:(A;;GA;;;WD)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-TAPI-Rt-Person,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=ms-TAPI-Rt-Conference,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: classSchema
ldapDisplayName: msTAPI-RtConference
adminDisplayName: msTAPI-RtConference
adminDescription: msTAPI-RtConference
governsId: 1.2.840.113556.1.5.221
objectClassCategory: 1
rdnAttId: 1.2.840.113556.1.4.1698
subClassOf: 2.5.6.0
systemMustContain: 1.2.840.113556.1.4.1698
systemMayContain: 1.2.840.113556.1.4.1700
systemMayContain: 1.2.840.113556.1.4.1699
systemPossSuperiors: 2.5.6.5
schemaIdGuid:: NZd7yipLSU6Jw5kCUzTclA==
defaultSecurityDescriptor: D:(A;;GA;;;WD)
showInAdvancedViewOnly: TRUE
defaultHidingValue: TRUE
systemOnly: FALSE
defaultObjectCategory: CN=ms-TAPI-Rt-Conference,CN=Schema,CN=Configuration,DC=X
systemFlags: 16

dn: CN=Trusted-Domain,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1702
-

# Reload the schema cache to pick up altered classes and attributes

dn:
changetype: ntdsSchemaModify
add: schemaUpdateNow
schemaUpdateNow: 1
-

# Config NC changes

dn: CN=msmq-Send,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: appliesTo
appliesTo: 46b27aac-aafa-4ffb-b773-e5bf621ee87b
-

dn: CN=Refresh-Group-Cache,CN=Extended-Rights,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: controlAccessRight
ShowInAdvancedViewOnly: TRUE
appliesTo: f0f8ffab-1191-11d0-a060-00aa006c33ed
displayName: Refresh Group Cache for Logons
localizationDisplayId: 56
rightsGUID: 9432c620-033c-4db7-8b58-14ef6d0bf477
validAccesses: 256

# Increase object version

dn: CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: objectVersion
objectVersion: 15
-

```

### Sch16.ldf

```

# Schema NC changes

dn: CN=Well-Known-Objects,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: rangeLower
rangeLower: 16
-
add: rangeUpper
rangeUpper: 16
-

dn: CN=Other-Well-Known-Objects,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: rangeLower
rangeLower: 16
-
add: rangeUpper
rangeUpper: 16
-

dn: CN=ms-WMI-PolicyTemplate,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1623
systemMayContain: 1.2.840.113556.1.4.1624
systemMayContain: 1.2.840.113556.1.4.1626
systemMayContain: 1.2.840.113556.1.4.1644
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.1623
systemMustContain: 1.2.840.113556.1.4.1624
systemMustContain: 1.2.840.113556.1.4.1626
systemMustContain: 1.2.840.113556.1.4.1644
-

dn: CN=ms-WMI-PolicyType,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1623
systemMayContain: 1.2.840.113556.1.4.1624
systemMayContain: 1.2.840.113556.1.4.1626
systemMayContain: 1.2.840.113556.1.4.1644
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.1623
systemMustContain: 1.2.840.113556.1.4.1624
systemMustContain: 1.2.840.113556.1.4.1626
systemMustContain: 1.2.840.113556.1.4.1644
-

dn: CN=ms-WMI-Som,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1623
systemMayContain: 1.2.840.113556.1.4.1624
systemMayContain: 1.2.840.113556.1.4.1626
systemMayContain: 1.2.840.113556.1.4.1644
-
delete: systemMustContain
systemMustContain: 1.2.840.113556.1.4.1623
systemMustContain: 1.2.840.113556.1.4.1624
systemMustContain: 1.2.840.113556.1.4.1626
systemMustContain: 1.2.840.113556.1.4.1644
-

dn: CN=Application-Version,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=ms-DS-App-Configuration,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: defaultHidingValue
defaultHidingValue: TRUE
-

dn: CN=ms-TAPI-Unique-Identifier,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
replace: rangeUpper
rangeUpper: 256
-

dn: CN=ms-TAPI-Rt-Person,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaModify
add: systemMayContain
systemMayContain: 1.2.840.113556.1.4.1698
-

dn: CN=ms-DS-NC-Repl-Cursors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-NCReplCursors
adminDisplayName: ms-DS-NC-Repl-Cursors
adminDescription: ms-DS-NC-Repl-Cursors
attributeId: 1.2.840.113556.1.4.1704
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 5HwWiuj560eNePf+gKuyzA==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-Filter-Containers,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-FilterContainers
adminDisplayName: ms-DS-Filter-Containers
adminDescription: ms-DS-Filter-Containers
attributeId: 1.2.840.113556.1.4.1703
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
rangeLower: 1
rangeUpper: 64
schemaIdGuid:: 39wA+zesOkicEqxTpmAwMw==
showInAdvancedViewOnly: TRUE
systemFlags: 16

dn: CN=ms-DS-Repl-Value-Meta-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ReplValueMetaData
adminDisplayName: ms-DS-Repl-Value-Meta-Data
adminDescription: ms-DS-Repl-Value-Meta-Data
attributeId: 1.2.840.113556.1.4.1708
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: RYFcL73hC0GJV4v6gdWs/Q==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-Repl-Attribute-Meta-Data,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-ReplAttributeMetaData
adminDisplayName: ms-DS-Repl-Attribute-Meta-Data
adminDescription: ms-DS-Repl-Attribute-Meta-Data
attributeId: 1.2.840.113556.1.4.1707
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: QjLF105yOUydTC34ydZseg==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-NC-Repl-Inbound-Neighbors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-NCReplInboundNeighbors
adminDisplayName: ms-DS-NC-Repl-Inbound-Neighbors
adminDescription: ms-DS-NC-Repl-Inbound-Neighbors
attributeId: 1.2.840.113556.1.4.1705
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: Wqjbnp4+G0ObGqW26e2nlg==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-NC-Repl-Outbound-Neighbors,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-NCReplOutboundNeighbors
adminDisplayName: ms-DS-NC-Repl-Outbound-Neighbors
adminDescription: ms-DS-NC-Repl-Outbound-Neighbors
attributeId: 1.2.840.113556.1.4.1706
attributeSyntax: 2.5.5.12
omSyntax: 64
isSingleValued: FALSE
systemOnly: FALSE
searchFlags: 0
schemaIdGuid:: 9S5fhcWhxEy6bTJSKEi2Hw==
showInAdvancedViewOnly: TRUE
systemFlags: 20

dn: CN=ms-DS-Has-Instantiated-NCs,CN=Schema,CN=Configuration,DC=X
changetype: ntdsSchemaAdd
objectClass: attributeSchema
ldapDisplayName: msDS-HasInstantiatedNCs
adminDisplayName: ms-DS-Has-Instantiated-NCs
adminDescription: DS re