/*
 * Copyright (C) 2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/test/common/test_macros/hw_test_base.h"
using namespace NEO;

namespace L0 {
namespace ult {

HWTEST_EXCLUDE_PRODUCT(CommandQueueGroupTest, givenBlitterSupportAndCCSThenThreeQueueGroupsAreReturned, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(CommandQueueGroupTest, givenBlitterSupportCCSAndLinkedBcsDisabledThenTwoQueueGroupsAreReturned, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(CommandQueueGroupTest, givenVaryingBlitterSupportAndCCSThenBCSGroupContainsCorrectNumberOfEngines, IGFX_CRI);

HWTEST_EXCLUDE_PRODUCT(CommandListAppendLaunchRayTracingKernelTest, givenKernelUsingRayTracingWhenAppendLaunchKernelIsCalledThenSuccessIsReturned_RayTracingMatcher, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(RayTracingCmdListTest, givenRayTracingKernelWhenRegularCmdListExecutedAndRegularExecutedAgainThenDispatch3dBtdCommandOnceMakeResidentTwiceAndPipeControlWithStateCacheFlushAfterWalker_RayTracingMatcher, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(RayTracingCmdListTest, givenRayTracingKernelWhenRegularCmdListExecutedAndImmediateExecutedAgainThenDispatch3dBtdCommandOnceMakeResidentTwiceAndPipeControlWithStateCacheFlushAfterWalker_RayTracingMatcher, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(RayTracingCmdListTest, givenRayTracingKernelWhenImmediateCmdListExecutedAndImmediateExecutedAgainThenDispatch3dBtdCommandOnceMakeResidentTwiceAndPipeControlWithStateCacheFlushAfterWalker_RayTracingMatcher, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(RayTracingCmdListTest, givenRayTracingKernelWhenImmediateCmdListExecutedAndRegularExecutedAgainThenDispatch3dBtdCommandOnceMakeResidentTwiceAndPipeControlWithStateCacheFlushAfterWalker_RayTracingMatcher, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(CommandListTestsReserveSize, givenCommandListWhenGetReserveSshSizeThen16slotSpaceReturned_IsHeapfulRequiredAndAtLeastXeCore, IGFX_CRI);

} // namespace ult
} // namespace L0
