// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAgentPushServerStateParams creates a new AgentPushServerStateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAgentPushServerStateParams() *AgentPushServerStateParams {
	return &AgentPushServerStateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAgentPushServerStateParamsWithTimeout creates a new AgentPushServerStateParams object
// with the ability to set a timeout on a request.
func NewAgentPushServerStateParamsWithTimeout(timeout time.Duration) *AgentPushServerStateParams {
	return &AgentPushServerStateParams{
		timeout: timeout,
	}
}

// NewAgentPushServerStateParamsWithContext creates a new AgentPushServerStateParams object
// with the ability to set a context for a request.
func NewAgentPushServerStateParamsWithContext(ctx context.Context) *AgentPushServerStateParams {
	return &AgentPushServerStateParams{
		Context: ctx,
	}
}

// NewAgentPushServerStateParamsWithHTTPClient creates a new AgentPushServerStateParams object
// with the ability to set a custom HTTPClient for a request.
func NewAgentPushServerStateParamsWithHTTPClient(client *http.Client) *AgentPushServerStateParams {
	return &AgentPushServerStateParams{
		HTTPClient: client,
	}
}

/*
AgentPushServerStateParams contains all the parameters to send to the API endpoint

	for the agent push server state operation.

	Typically these are written to a http.Request.
*/
type AgentPushServerStateParams struct {

	// Body.
	Body AgentPushServerStateBody

	/* ID.

	   id is the name of the cluster
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the agent push server state params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AgentPushServerStateParams) WithDefaults() *AgentPushServerStateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the agent push server state params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AgentPushServerStateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the agent push server state params
func (o *AgentPushServerStateParams) WithTimeout(timeout time.Duration) *AgentPushServerStateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the agent push server state params
func (o *AgentPushServerStateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the agent push server state params
func (o *AgentPushServerStateParams) WithContext(ctx context.Context) *AgentPushServerStateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the agent push server state params
func (o *AgentPushServerStateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the agent push server state params
func (o *AgentPushServerStateParams) WithHTTPClient(client *http.Client) *AgentPushServerStateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the agent push server state params
func (o *AgentPushServerStateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the agent push server state params
func (o *AgentPushServerStateParams) WithBody(body AgentPushServerStateBody) *AgentPushServerStateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the agent push server state params
func (o *AgentPushServerStateParams) SetBody(body AgentPushServerStateBody) {
	o.Body = body
}

// WithID adds the id to the agent push server state params
func (o *AgentPushServerStateParams) WithID(id string) *AgentPushServerStateParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the agent push server state params
func (o *AgentPushServerStateParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the agent push server state params
func (o *AgentPushServerStateParams) WithLocationOrganizationID(locationOrganizationID string) *AgentPushServerStateParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the agent push server state params
func (o *AgentPushServerStateParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the agent push server state params
func (o *AgentPushServerStateParams) WithLocationProjectID(locationProjectID string) *AgentPushServerStateParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the agent push server state params
func (o *AgentPushServerStateParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *AgentPushServerStateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
