//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-uniform-type-identifiers")]
use objc2_uniform_type_identifiers::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowsererrordomain?language=objc)
    pub static UIDocumentBrowserErrorDomain: &'static NSErrorDomain;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowsererrorcode?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDocumentBrowserErrorCode(pub NSInteger);
impl UIDocumentBrowserErrorCode {
    #[doc(alias = "UIDocumentBrowserErrorGeneric")]
    pub const Generic: Self = Self(1);
    #[doc(alias = "UIDocumentBrowserErrorNoLocationAvailable")]
    pub const NoLocationAvailable: Self = Self(2);
}

unsafe impl Encode for UIDocumentBrowserErrorCode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIDocumentBrowserErrorCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowserimportmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDocumentBrowserImportMode(pub NSUInteger);
impl UIDocumentBrowserImportMode {
    #[doc(alias = "UIDocumentBrowserImportModeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UIDocumentBrowserImportModeCopy")]
    pub const Copy: Self = Self(1);
    #[doc(alias = "UIDocumentBrowserImportModeMove")]
    pub const Move: Self = Self(2);
}

unsafe impl Encode for UIDocumentBrowserImportMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIDocumentBrowserImportMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowseruserinterfacestyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDocumentBrowserUserInterfaceStyle(pub NSUInteger);
impl UIDocumentBrowserUserInterfaceStyle {
    #[doc(alias = "UIDocumentBrowserUserInterfaceStyleWhite")]
    pub const White: Self = Self(0);
    #[doc(alias = "UIDocumentBrowserUserInterfaceStyleLight")]
    pub const Light: Self = Self(1);
    #[doc(alias = "UIDocumentBrowserUserInterfaceStyleDark")]
    pub const Dark: Self = Self(2);
}

unsafe impl Encode for UIDocumentBrowserUserInterfaceStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIDocumentBrowserUserInterfaceStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// UIDocumentBrowserViewController is a view controller to browse the files on the user's device or cloud services and open them directly in your application
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowserviewcontroller?language=objc)
    #[unsafe(super(UIViewController, UIResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
    pub struct UIDocumentBrowserViewController;
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl NSCoding for UIDocumentBrowserViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIDocumentBrowserViewController {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIDocumentBrowserViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl UIContentContainer for UIDocumentBrowserViewController {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIDocumentBrowserViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIDocumentBrowserViewController {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIDocumentBrowserViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UIDocumentBrowserViewController {
    extern_methods!(
        /// Parameter `allowedContentTypes`: The document types that the user should be able to open. If nil, the types specified via the CFBundleDocumentTypes key in the application plist will be used instead.
        #[deprecated]
        #[unsafe(method(initForOpeningFilesWithContentTypes:))]
        #[unsafe(method_family = init)]
        pub fn initForOpeningFilesWithContentTypes(
            this: Allocated<Self>,
            allowed_content_types: Option<&NSArray<NSString>>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        /// Parameter `contentTypes`: The content types that the user should be able to open. If nil, the types specified via the CFBundleDocumentTypes key in the application plist will be used instead.
        #[unsafe(method(initForOpeningContentTypes:))]
        #[unsafe(method_family = init)]
        pub fn initForOpeningContentTypes(
            this: Allocated<Self>,
            content_types: Option<&NSArray<UTType>>,
        ) -> Retained<Self>;

        /// Please use the designated initializers above instead.
        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name: Option<&NSString>,
            bundle: Option<&NSBundle>,
        ) -> Retained<Self>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIDocumentBrowserViewControllerDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIDocumentBrowserViewControllerDelegate>>,
        );

        /// Defaults to YES
        #[unsafe(method(allowsDocumentCreation))]
        #[unsafe(method_family = none)]
        pub fn allowsDocumentCreation(&self) -> bool;

        /// Setter for [`allowsDocumentCreation`][Self::allowsDocumentCreation].
        #[unsafe(method(setAllowsDocumentCreation:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsDocumentCreation(&self, allows_document_creation: bool);

        #[cfg(feature = "UIDocument")]
        /// The active document creation intent.
        #[unsafe(method(activeDocumentCreationIntent))]
        #[unsafe(method_family = none)]
        pub fn activeDocumentCreationIntent(&self) -> Option<Retained<UIDocumentCreationIntent>>;

        /// Defaults to NO
        #[unsafe(method(allowsPickingMultipleItems))]
        #[unsafe(method_family = none)]
        pub fn allowsPickingMultipleItems(&self) -> bool;

        /// Setter for [`allowsPickingMultipleItems`][Self::allowsPickingMultipleItems].
        #[unsafe(method(setAllowsPickingMultipleItems:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsPickingMultipleItems(&self, allows_picking_multiple_items: bool);

        #[deprecated = "allowedContentTypes is no longer supported"]
        #[unsafe(method(allowedContentTypes))]
        #[unsafe(method_family = none)]
        pub fn allowedContentTypes(&self) -> Retained<NSArray<NSString>>;

        /// Array of content types supported for Recents documents.
        /// Default is same as allowedContentTypes.
        /// Can be defined via the 'UIDocumentBrowserRecentDocumentContentTypes' key in the app Info.plist.
        /// Note that the recentDocumentsContentTypes must be a subset conforming to the types declared in allowedContentTypes.
        #[deprecated]
        #[unsafe(method(recentDocumentsContentTypes))]
        #[unsafe(method_family = none)]
        pub fn recentDocumentsContentTypes(&self) -> Retained<NSArray<NSString>>;

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        /// Array of content types supported for Recents documents.
        /// Default is same as content types passed in the designated initializer or as CFBundleDocumentTypes  in the app Info.plist.
        /// Can be defined via the 'UIDocumentBrowserRecentDocumentContentTypes' key in the app Info.plist.
        /// Note that the contentTypesForRecentDocuments must be a subset conforming to the types passed in the initializer or Info.plist.
        #[unsafe(method(contentTypesForRecentDocuments))]
        #[unsafe(method_family = none)]
        pub fn contentTypesForRecentDocuments(&self) -> Retained<NSArray<UTType>>;

        /// Force the display of file extensions (default: NO).
        #[unsafe(method(shouldShowFileExtensions))]
        #[unsafe(method_family = none)]
        pub fn shouldShowFileExtensions(&self) -> bool;

        /// Setter for [`shouldShowFileExtensions`][Self::shouldShowFileExtensions].
        #[unsafe(method(setShouldShowFileExtensions:))]
        #[unsafe(method_family = none)]
        pub fn setShouldShowFileExtensions(&self, should_show_file_extensions: bool);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// An array of buttons that will be added to the existing buttons in the UIDocumentBrowserViewController navigation bar
        #[unsafe(method(additionalLeadingNavigationBarButtonItems))]
        #[unsafe(method_family = none)]
        pub fn additionalLeadingNavigationBarButtonItems(
            &self,
        ) -> Retained<NSArray<UIBarButtonItem>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`additionalLeadingNavigationBarButtonItems`][Self::additionalLeadingNavigationBarButtonItems].
        #[unsafe(method(setAdditionalLeadingNavigationBarButtonItems:))]
        #[unsafe(method_family = none)]
        pub fn setAdditionalLeadingNavigationBarButtonItems(
            &self,
            additional_leading_navigation_bar_button_items: &NSArray<UIBarButtonItem>,
        );

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// An array of buttons that will be added to the existing buttons in the UIDocumentBrowserViewController navigation bar
        #[unsafe(method(additionalTrailingNavigationBarButtonItems))]
        #[unsafe(method_family = none)]
        pub fn additionalTrailingNavigationBarButtonItems(
            &self,
        ) -> Retained<NSArray<UIBarButtonItem>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`additionalTrailingNavigationBarButtonItems`][Self::additionalTrailingNavigationBarButtonItems].
        #[unsafe(method(setAdditionalTrailingNavigationBarButtonItems:))]
        #[unsafe(method_family = none)]
        pub fn setAdditionalTrailingNavigationBarButtonItems(
            &self,
            additional_trailing_navigation_bar_button_items: &NSArray<UIBarButtonItem>,
        );

        #[cfg(feature = "block2")]
        /// Called to reveal a document at the URL.
        /// Typically called from the application delegate method application:openURL:options:; to let the application present the document.
        #[unsafe(method(revealDocumentAtURL:importIfNeeded:completion:))]
        #[unsafe(method_family = none)]
        pub fn revealDocumentAtURL_importIfNeeded_completion(
            &self,
            url: &NSURL,
            import_if_needed: bool,
            completion: Option<&block2::DynBlock<dyn Fn(*mut NSURL, *mut NSError)>>,
        );

        #[cfg(feature = "block2")]
        /// Allow a document to be imported next to another document.
        #[unsafe(method(importDocumentAtURL:nextToDocumentAtURL:mode:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn importDocumentAtURL_nextToDocumentAtURL_mode_completionHandler(
            &self,
            document_url: &NSURL,
            neighbour_url: &NSURL,
            import_mode: UIDocumentBrowserImportMode,
            completion: &block2::DynBlock<dyn Fn(*mut NSURL, *mut NSError)>,
        );

        #[cfg(feature = "block2")]
        /// Rename a document.
        /// If the proposed name is already taken, a different name may be used after confirming with the user.
        /// The finalURL and error are available in the completion handler.
        #[unsafe(method(renameDocumentAtURL:proposedName:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn renameDocumentAtURL_proposedName_completionHandler(
            &self,
            document_url: &NSURL,
            proposed_name: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSURL, *mut NSError)>,
        );

        /// A UIDocumentBrowserTransitionController object is used to display a loading indicator, while the application is spending time on time-consuming operations (e.g., loading, parsing, …) after having finished the file download, and before presenting it. To be used together with the UIViewControllerTransitioningDelegate protocol for custom view controller transitions.
        #[unsafe(method(transitionControllerForDocumentAtURL:))]
        #[unsafe(method_family = none)]
        pub fn transitionControllerForDocumentAtURL(
            &self,
            document_url: &NSURL,
        ) -> Retained<UIDocumentBrowserTransitionController>;

        #[deprecated]
        #[unsafe(method(transitionControllerForDocumentURL:))]
        #[unsafe(method_family = none)]
        pub fn transitionControllerForDocumentURL(
            &self,
            document_url: &NSURL,
        ) -> Retained<UIDocumentBrowserTransitionController>;

        #[cfg(feature = "UIDocumentBrowserAction")]
        /// Allows clients to add custom actions in the menu and the navigation bar. These actions are contextual to the document items.
        #[unsafe(method(customActions))]
        #[unsafe(method_family = none)]
        pub fn customActions(&self) -> Retained<NSArray<UIDocumentBrowserAction>>;

        #[cfg(feature = "UIDocumentBrowserAction")]
        /// Setter for [`customActions`][Self::customActions].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCustomActions:))]
        #[unsafe(method_family = none)]
        pub fn setCustomActions(&self, custom_actions: &NSArray<UIDocumentBrowserAction>);

        /// Allows clients to customize the look of the browser. Default: UIDocumentBrowserUserInterfaceStyleWhite
        #[unsafe(method(browserUserInterfaceStyle))]
        #[unsafe(method_family = none)]
        pub fn browserUserInterfaceStyle(&self) -> UIDocumentBrowserUserInterfaceStyle;

        /// Setter for [`browserUserInterfaceStyle`][Self::browserUserInterfaceStyle].
        #[unsafe(method(setBrowserUserInterfaceStyle:))]
        #[unsafe(method_family = none)]
        pub fn setBrowserUserInterfaceStyle(
            &self,
            browser_user_interface_style: UIDocumentBrowserUserInterfaceStyle,
        );

        /// Title of the Create Document button (default: "Create Document”).
        #[unsafe(method(localizedCreateDocumentActionTitle))]
        #[unsafe(method_family = none)]
        pub fn localizedCreateDocumentActionTitle(&self) -> Retained<NSString>;

        /// Setter for [`localizedCreateDocumentActionTitle`][Self::localizedCreateDocumentActionTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLocalizedCreateDocumentActionTitle:))]
        #[unsafe(method_family = none)]
        pub fn setLocalizedCreateDocumentActionTitle(
            &self,
            localized_create_document_action_title: &NSString,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// Aspect ratio of the Create Document button defined as width / height (default: 2/3).
        #[unsafe(method(defaultDocumentAspectRatio))]
        #[unsafe(method_family = none)]
        pub fn defaultDocumentAspectRatio(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`defaultDocumentAspectRatio`][Self::defaultDocumentAspectRatio].
        #[unsafe(method(setDefaultDocumentAspectRatio:))]
        #[unsafe(method_family = none)]
        pub fn setDefaultDocumentAspectRatio(&self, default_document_aspect_ratio: CGFloat);
    );
}

/// Methods declared on superclass `UIViewController`.
#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UIDocumentBrowserViewController {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UIDocumentBrowserViewController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowserviewcontrollerdelegate?language=objc)
    pub unsafe trait UIDocumentBrowserViewControllerDelegate: NSObjectProtocol {
        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        /// Called when the user validates a selection of items to open or pick.
        /// If you have created this document manager to open files, you should then open the document, potentially using a
        /// `UIDocumentBrowserTransitionController`for the transition.
        #[deprecated]
        #[optional]
        #[unsafe(method(documentBrowser:didPickDocumentURLs:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_didPickDocumentURLs(
            &self,
            controller: &UIDocumentBrowserViewController,
            document_ur_ls: &NSArray<NSURL>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(documentBrowser:didPickDocumentsAtURLs:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_didPickDocumentsAtURLs(
            &self,
            controller: &UIDocumentBrowserViewController,
            document_ur_ls: &NSArray<NSURL>,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIViewController",
            feature = "block2"
        ))]
        /// When the user requests the creation of a new document, this method will be called. The application can then, optionally, present UI
        /// it deems appropriate to let the user configure the new document (for example, it could show a list of templates).
        /// When done, create an empty document or a copy of your template to a temporary location.
        /// Then use the importHandler to pass the document URL to be imported.
        /// If the user cancels the document creation, it's still expetected to call importHandler(nil, UIDocumentBrowserImportModeNone).
        /// The Document Browser will asynchronously move the document to its final destination and call back one of the following delegate methods:
        /// -documentBrowser:didImportDocumentURL:toDestinationURL:
        /// -documentBrowser:failedToImportDocumentAtURL:error:
        /// The app should wait for the delegate callbacks before presenting the imported document at the destination URL. Usage of UIDocument is recommended.
        /// If you do not implement this method, document creation will not be available.
        #[optional]
        #[unsafe(method(documentBrowser:didRequestDocumentCreationWithHandler:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_didRequestDocumentCreationWithHandler(
            &self,
            controller: &UIDocumentBrowserViewController,
            import_handler: &block2::DynBlock<dyn Fn(*mut NSURL, UIDocumentBrowserImportMode)>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(documentBrowser:didImportDocumentAtURL:toDestinationURL:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_didImportDocumentAtURL_toDestinationURL(
            &self,
            controller: &UIDocumentBrowserViewController,
            source_url: &NSURL,
            destination_url: &NSURL,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(documentBrowser:failedToImportDocumentAtURL:error:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_failedToImportDocumentAtURL_error(
            &self,
            controller: &UIDocumentBrowserViewController,
            document_url: &NSURL,
            error: Option<&NSError>,
        );

        #[cfg(all(
            feature = "UIActivity",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        /// Allows clients to add application specific UIActivity instances
        #[optional]
        #[unsafe(method(documentBrowser:applicationActivitiesForDocumentURLs:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_applicationActivitiesForDocumentURLs(
            &self,
            controller: &UIDocumentBrowserViewController,
            document_ur_ls: &NSArray<NSURL>,
        ) -> Retained<NSArray<UIActivity>>;

        #[cfg(all(
            feature = "UIActivityViewController",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        /// Implement this to customize the UIActivityViewController before it's presented.
        #[optional]
        #[unsafe(method(documentBrowser:willPresentActivityViewController:))]
        #[unsafe(method_family = none)]
        fn documentBrowser_willPresentActivityViewController(
            &self,
            controller: &UIDocumentBrowserViewController,
            activity_view_controller: &UIActivityViewController,
        );
    }
);

extern_class!(
    /// Class to handle the loading and animation transition when opening or closing a document.
    ///
    /// You can use this object to display a loading indicator if you need time to perform time-consuming operations (loading, parsing, …) after the document download and before presenting it. You can also get a transition controller to pass to UIKit when pushing or presenting your document view
    /// in response to
    /// `documentBrowser:didPickItem:,`or when popping or dismissing it.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uidocumentbrowsertransitioncontroller?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIDocumentBrowserTransitionController;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIDocumentBrowserTransitionController {}
);

#[cfg(feature = "UIViewControllerTransitioning")]
extern_conformance!(
    unsafe impl UIViewControllerAnimatedTransitioning for UIDocumentBrowserTransitionController {}
);

impl UIDocumentBrowserTransitionController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// An optional progress can be displayed on the document thumbnail while the document is loading (during opening).
        #[unsafe(method(loadingProgress))]
        #[unsafe(method_family = none)]
        pub fn loadingProgress(&self) -> Option<Retained<NSProgress>>;

        /// Setter for [`loadingProgress`][Self::loadingProgress].
        #[unsafe(method(setLoadingProgress:))]
        #[unsafe(method_family = none)]
        pub fn setLoadingProgress(&self, loading_progress: Option<&NSProgress>);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// This view will be used for the zoom transition from/to the document collection view.
        /// If UIDocumentBrowserViewController is being dismissed, this view should be a subview of the presented view controller's view
        /// If UIDocumentBrowserViewController is being presented, this view should be a subview of the presenting view controller's view
        #[unsafe(method(targetView))]
        #[unsafe(method_family = none)]
        pub fn targetView(&self) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Setter for [`targetView`][Self::targetView].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setTargetView:))]
        #[unsafe(method_family = none)]
        pub fn setTargetView(&self, target_view: Option<&UIView>);
    );
}

/// Methods declared on superclass `NSObject`.
impl UIDocumentBrowserTransitionController {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
