//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nstextlayoutorientation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTextLayoutOrientation(pub NSInteger);
impl NSTextLayoutOrientation {
    #[doc(alias = "NSTextLayoutOrientationHorizontal")]
    pub const Horizontal: Self = Self(0);
    #[doc(alias = "NSTextLayoutOrientationVertical")]
    pub const Vertical: Self = Self(1);
}

unsafe impl Encode for NSTextLayoutOrientation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTextLayoutOrientation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nsglyphproperty?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSGlyphProperty(pub NSInteger);
bitflags::bitflags! {
    impl NSGlyphProperty: NSInteger {
        #[doc(alias = "NSGlyphPropertyNull")]
        const Null = 1<<0;
        #[doc(alias = "NSGlyphPropertyControlCharacter")]
        const ControlCharacter = 1<<1;
        #[doc(alias = "NSGlyphPropertyElastic")]
        const Elastic = 1<<2;
        #[doc(alias = "NSGlyphPropertyNonBaseCharacter")]
        const NonBaseCharacter = 1<<3;
    }
}

unsafe impl Encode for NSGlyphProperty {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSGlyphProperty {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharacteraction?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSControlCharacterAction(pub NSInteger);
bitflags::bitflags! {
    impl NSControlCharacterAction: NSInteger {
        #[doc(alias = "NSControlCharacterActionZeroAdvancement")]
        const ZeroAdvancement = 1<<0;
        #[doc(alias = "NSControlCharacterActionWhitespace")]
        const Whitespace = 1<<1;
        #[doc(alias = "NSControlCharacterActionHorizontalTab")]
        const HorizontalTab = 1<<2;
        #[doc(alias = "NSControlCharacterActionLineBreak")]
        const LineBreak = 1<<3;
        #[doc(alias = "NSControlCharacterActionParagraphBreak")]
        const ParagraphBreak = 1<<4;
        #[doc(alias = "NSControlCharacterActionContainerBreak")]
        const ContainerBreak = 1<<5;
    }
}

unsafe impl Encode for NSControlCharacterAction {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSControlCharacterAction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nstextlayoutorientationprovider?language=objc)
    pub unsafe trait NSTextLayoutOrientationProvider {
        #[unsafe(method(layoutOrientation))]
        #[unsafe(method_family = none)]
        fn layoutOrientation(&self) -> NSTextLayoutOrientation;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nslayoutmanager?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSLayoutManager;
);

extern_conformance!(
    unsafe impl NSCoding for NSLayoutManager {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSLayoutManager {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSLayoutManager {}
);

impl NSLayoutManager {
    extern_methods!(
        /// ************************** Initialization ***************************
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSTextStorage")]
        /// ************************* Text storage **************************
        ///
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(textStorage))]
        #[unsafe(method_family = none)]
        pub unsafe fn textStorage(&self) -> Option<Retained<NSTextStorage>>;

        #[cfg(feature = "NSTextStorage")]
        /// Setter for [`textStorage`][Self::textStorage].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setTextStorage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextStorage(&self, text_storage: Option<&NSTextStorage>);

        #[cfg(feature = "NSTextContainer")]
        /// ************************** Text containers ***************************
        #[unsafe(method(textContainers))]
        #[unsafe(method_family = none)]
        pub fn textContainers(&self) -> Retained<NSArray<NSTextContainer>>;

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(addTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn addTextContainer(&self, container: &NSTextContainer);

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(insertTextContainer:atIndex:))]
        #[unsafe(method_family = none)]
        pub fn insertTextContainer_atIndex(&self, container: &NSTextContainer, index: NSUInteger);

        #[unsafe(method(removeTextContainerAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn removeTextContainerAtIndex(&self, index: NSUInteger);

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(textContainerChangedGeometry:))]
        #[unsafe(method_family = none)]
        pub fn textContainerChangedGeometry(&self, container: &NSTextContainer);

        /// ************************** Delegate ***************************
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSLayoutManagerDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSLayoutManagerDelegate>>);

        /// ********************* Global layout manager options **********************
        #[unsafe(method(showsInvisibleCharacters))]
        #[unsafe(method_family = none)]
        pub fn showsInvisibleCharacters(&self) -> bool;

        /// Setter for [`showsInvisibleCharacters`][Self::showsInvisibleCharacters].
        #[unsafe(method(setShowsInvisibleCharacters:))]
        #[unsafe(method_family = none)]
        pub fn setShowsInvisibleCharacters(&self, shows_invisible_characters: bool);

        #[unsafe(method(showsControlCharacters))]
        #[unsafe(method_family = none)]
        pub fn showsControlCharacters(&self) -> bool;

        /// Setter for [`showsControlCharacters`][Self::showsControlCharacters].
        #[unsafe(method(setShowsControlCharacters:))]
        #[unsafe(method_family = none)]
        pub fn setShowsControlCharacters(&self, shows_control_characters: bool);

        #[unsafe(method(usesFontLeading))]
        #[unsafe(method_family = none)]
        pub fn usesFontLeading(&self) -> bool;

        /// Setter for [`usesFontLeading`][Self::usesFontLeading].
        #[unsafe(method(setUsesFontLeading:))]
        #[unsafe(method_family = none)]
        pub fn setUsesFontLeading(&self, uses_font_leading: bool);

        #[unsafe(method(allowsNonContiguousLayout))]
        #[unsafe(method_family = none)]
        pub fn allowsNonContiguousLayout(&self) -> bool;

        /// Setter for [`allowsNonContiguousLayout`][Self::allowsNonContiguousLayout].
        #[unsafe(method(setAllowsNonContiguousLayout:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsNonContiguousLayout(&self, allows_non_contiguous_layout: bool);

        #[unsafe(method(hasNonContiguousLayout))]
        #[unsafe(method_family = none)]
        pub fn hasNonContiguousLayout(&self) -> bool;

        #[unsafe(method(limitsLayoutForSuspiciousContents))]
        #[unsafe(method_family = none)]
        pub fn limitsLayoutForSuspiciousContents(&self) -> bool;

        /// Setter for [`limitsLayoutForSuspiciousContents`][Self::limitsLayoutForSuspiciousContents].
        #[unsafe(method(setLimitsLayoutForSuspiciousContents:))]
        #[unsafe(method_family = none)]
        pub fn setLimitsLayoutForSuspiciousContents(
            &self,
            limits_layout_for_suspicious_contents: bool,
        );

        #[unsafe(method(usesDefaultHyphenation))]
        #[unsafe(method_family = none)]
        pub fn usesDefaultHyphenation(&self) -> bool;

        /// Setter for [`usesDefaultHyphenation`][Self::usesDefaultHyphenation].
        #[unsafe(method(setUsesDefaultHyphenation:))]
        #[unsafe(method_family = none)]
        pub fn setUsesDefaultHyphenation(&self, uses_default_hyphenation: bool);

        /// ************************ Invalidation *************************
        ///
        /// # Safety
        ///
        /// `actual_char_range` must be a valid pointer or null.
        #[unsafe(method(invalidateGlyphsForCharacterRange:changeInLength:actualCharacterRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateGlyphsForCharacterRange_changeInLength_actualCharacterRange(
            &self,
            char_range: NSRange,
            delta: NSInteger,
            actual_char_range: NSRangePointer,
        );

        /// # Safety
        ///
        /// `actual_char_range` must be a valid pointer or null.
        #[unsafe(method(invalidateLayoutForCharacterRange:actualCharacterRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateLayoutForCharacterRange_actualCharacterRange(
            &self,
            char_range: NSRange,
            actual_char_range: NSRangePointer,
        );

        #[unsafe(method(invalidateDisplayForCharacterRange:))]
        #[unsafe(method_family = none)]
        pub fn invalidateDisplayForCharacterRange(&self, char_range: NSRange);

        #[unsafe(method(invalidateDisplayForGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn invalidateDisplayForGlyphRange(&self, glyph_range: NSRange);

        #[cfg(feature = "NSTextStorage")]
        #[unsafe(method(processEditingForTextStorage:edited:range:changeInLength:invalidatedRange:))]
        #[unsafe(method_family = none)]
        pub fn processEditingForTextStorage_edited_range_changeInLength_invalidatedRange(
            &self,
            text_storage: &NSTextStorage,
            edit_mask: NSTextStorageEditActions,
            new_char_range: NSRange,
            delta: NSInteger,
            invalidated_char_range: NSRange,
        );

        /// ********************** Causing glyph generation and layout ***********************
        #[unsafe(method(ensureGlyphsForCharacterRange:))]
        #[unsafe(method_family = none)]
        pub fn ensureGlyphsForCharacterRange(&self, char_range: NSRange);

        #[unsafe(method(ensureGlyphsForGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn ensureGlyphsForGlyphRange(&self, glyph_range: NSRange);

        #[unsafe(method(ensureLayoutForCharacterRange:))]
        #[unsafe(method_family = none)]
        pub fn ensureLayoutForCharacterRange(&self, char_range: NSRange);

        #[unsafe(method(ensureLayoutForGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn ensureLayoutForGlyphRange(&self, glyph_range: NSRange);

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(ensureLayoutForTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn ensureLayoutForTextContainer(&self, container: &NSTextContainer);

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(ensureLayoutForBoundingRect:inTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn ensureLayoutForBoundingRect_inTextContainer(
            &self,
            bounds: CGRect,
            container: &NSTextContainer,
        );

        #[cfg(all(feature = "UIFont", feature = "objc2-core-graphics"))]
        /// ********************** Set glyphs and glyph properties ***********************
        ///
        /// # Safety
        ///
        /// - `glyphs` must be a valid pointer.
        /// - `props` must be a valid pointer.
        /// - `char_indexes` must be a valid pointer.
        #[unsafe(method(setGlyphs:properties:characterIndexes:font:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGlyphs_properties_characterIndexes_font_forGlyphRange(
            &self,
            glyphs: NonNull<CGGlyph>,
            props: NonNull<NSGlyphProperty>,
            char_indexes: NonNull<NSUInteger>,
            a_font: &UIFont,
            glyph_range: NSRange,
        );

        /// ********************** Get glyphs and glyph properties ***********************
        #[unsafe(method(numberOfGlyphs))]
        #[unsafe(method_family = none)]
        pub fn numberOfGlyphs(&self) -> NSUInteger;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `is_valid_index` must be a valid pointer or null.
        #[unsafe(method(CGGlyphAtIndex:isValidIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGGlyphAtIndex_isValidIndex(
            &self,
            glyph_index: NSUInteger,
            is_valid_index: *mut Bool,
        ) -> CGGlyph;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(CGGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn CGGlyphAtIndex(&self, glyph_index: NSUInteger) -> CGGlyph;

        #[unsafe(method(isValidGlyphIndex:))]
        #[unsafe(method_family = none)]
        pub fn isValidGlyphIndex(&self, glyph_index: NSUInteger) -> bool;

        #[unsafe(method(propertyForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn propertyForGlyphAtIndex(&self, glyph_index: NSUInteger) -> NSGlyphProperty;

        #[unsafe(method(characterIndexForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn characterIndexForGlyphAtIndex(&self, glyph_index: NSUInteger) -> NSUInteger;

        #[unsafe(method(glyphIndexForCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn glyphIndexForCharacterAtIndex(&self, char_index: NSUInteger) -> NSUInteger;

        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// - `glyph_buffer` must be a valid pointer or null.
        /// - `props` must be a valid pointer or null.
        /// - `char_index_buffer` must be a valid pointer or null.
        /// - `bidi_level_buffer` must be a valid pointer or null.
        #[unsafe(method(getGlyphsInRange:glyphs:properties:characterIndexes:bidiLevels:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getGlyphsInRange_glyphs_properties_characterIndexes_bidiLevels(
            &self,
            glyph_range: NSRange,
            glyph_buffer: *mut CGGlyph,
            props: *mut NSGlyphProperty,
            char_index_buffer: *mut NSUInteger,
            bidi_level_buffer: *mut c_uchar,
        ) -> NSUInteger;

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(setTextContainer:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setTextContainer_forGlyphRange(
            &self,
            container: &NSTextContainer,
            glyph_range: NSRange,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setLineFragmentRect:forGlyphRange:usedRect:))]
        #[unsafe(method_family = none)]
        pub fn setLineFragmentRect_forGlyphRange_usedRect(
            &self,
            fragment_rect: CGRect,
            glyph_range: NSRange,
            used_rect: CGRect,
        );

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(setExtraLineFragmentRect:usedRect:textContainer:))]
        #[unsafe(method_family = none)]
        pub fn setExtraLineFragmentRect_usedRect_textContainer(
            &self,
            fragment_rect: CGRect,
            used_rect: CGRect,
            container: &NSTextContainer,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setLocation:forStartOfGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setLocation_forStartOfGlyphRange(&self, location: CGPoint, glyph_range: NSRange);

        #[unsafe(method(setNotShownAttribute:forGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn setNotShownAttribute_forGlyphAtIndex(&self, flag: bool, glyph_index: NSUInteger);

        #[unsafe(method(setDrawsOutsideLineFragment:forGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn setDrawsOutsideLineFragment_forGlyphAtIndex(
            &self,
            flag: bool,
            glyph_index: NSUInteger,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setAttachmentSize:forGlyphRange:))]
        #[unsafe(method_family = none)]
        pub fn setAttachmentSize_forGlyphRange(
            &self,
            attachment_size: CGSize,
            glyph_range: NSRange,
        );

        /// ********************** Get layout information ***********************
        ///
        /// # Safety
        ///
        /// - `char_index` must be a valid pointer or null.
        /// - `glyph_index` must be a valid pointer or null.
        #[unsafe(method(getFirstUnlaidCharacterIndex:glyphIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getFirstUnlaidCharacterIndex_glyphIndex(
            &self,
            char_index: *mut NSUInteger,
            glyph_index: *mut NSUInteger,
        );

        #[unsafe(method(firstUnlaidCharacterIndex))]
        #[unsafe(method_family = none)]
        pub fn firstUnlaidCharacterIndex(&self) -> NSUInteger;

        #[unsafe(method(firstUnlaidGlyphIndex))]
        #[unsafe(method_family = none)]
        pub fn firstUnlaidGlyphIndex(&self) -> NSUInteger;

        #[cfg(feature = "NSTextContainer")]
        /// # Safety
        ///
        /// `effective_glyph_range` must be a valid pointer or null.
        #[unsafe(method(textContainerForGlyphAtIndex:effectiveRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContainerForGlyphAtIndex_effectiveRange(
            &self,
            glyph_index: NSUInteger,
            effective_glyph_range: NSRangePointer,
        ) -> Option<Retained<NSTextContainer>>;

        #[cfg(feature = "NSTextContainer")]
        /// # Safety
        ///
        /// `effective_glyph_range` must be a valid pointer or null.
        #[unsafe(method(textContainerForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn textContainerForGlyphAtIndex_effectiveRange_withoutAdditionalLayout(
            &self,
            glyph_index: NSUInteger,
            effective_glyph_range: NSRangePointer,
            flag: bool,
        ) -> Option<Retained<NSTextContainer>>;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(usedRectForTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn usedRectForTextContainer(&self, container: &NSTextContainer) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `effective_glyph_range` must be a valid pointer or null.
        #[unsafe(method(lineFragmentRectForGlyphAtIndex:effectiveRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lineFragmentRectForGlyphAtIndex_effectiveRange(
            &self,
            glyph_index: NSUInteger,
            effective_glyph_range: NSRangePointer,
        ) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `effective_glyph_range` must be a valid pointer or null.
        #[unsafe(method(lineFragmentRectForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lineFragmentRectForGlyphAtIndex_effectiveRange_withoutAdditionalLayout(
            &self,
            glyph_index: NSUInteger,
            effective_glyph_range: NSRangePointer,
            flag: bool,
        ) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `effective_glyph_range` must be a valid pointer or null.
        #[unsafe(method(lineFragmentUsedRectForGlyphAtIndex:effectiveRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lineFragmentUsedRectForGlyphAtIndex_effectiveRange(
            &self,
            glyph_index: NSUInteger,
            effective_glyph_range: NSRangePointer,
        ) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// `effective_glyph_range` must be a valid pointer or null.
        #[unsafe(method(lineFragmentUsedRectForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lineFragmentUsedRectForGlyphAtIndex_effectiveRange_withoutAdditionalLayout(
            &self,
            glyph_index: NSUInteger,
            effective_glyph_range: NSRangePointer,
            flag: bool,
        ) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(extraLineFragmentRect))]
        #[unsafe(method_family = none)]
        pub fn extraLineFragmentRect(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(extraLineFragmentUsedRect))]
        #[unsafe(method_family = none)]
        pub fn extraLineFragmentUsedRect(&self) -> CGRect;

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(extraLineFragmentTextContainer))]
        #[unsafe(method_family = none)]
        pub fn extraLineFragmentTextContainer(&self) -> Option<Retained<NSTextContainer>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(locationForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn locationForGlyphAtIndex(&self, glyph_index: NSUInteger) -> CGPoint;

        #[unsafe(method(notShownAttributeForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn notShownAttributeForGlyphAtIndex(&self, glyph_index: NSUInteger) -> bool;

        #[unsafe(method(drawsOutsideLineFragmentForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn drawsOutsideLineFragmentForGlyphAtIndex(&self, glyph_index: NSUInteger) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(attachmentSizeForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn attachmentSizeForGlyphAtIndex(&self, glyph_index: NSUInteger) -> CGSize;

        #[unsafe(method(truncatedGlyphRangeInLineFragmentForGlyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn truncatedGlyphRangeInLineFragmentForGlyphAtIndex(
            &self,
            glyph_index: NSUInteger,
        ) -> NSRange;

        /// ********************** More sophisticated queries ***********************
        ///
        /// # Safety
        ///
        /// `actual_char_range` must be a valid pointer or null.
        #[unsafe(method(glyphRangeForCharacterRange:actualCharacterRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn glyphRangeForCharacterRange_actualCharacterRange(
            &self,
            char_range: NSRange,
            actual_char_range: NSRangePointer,
        ) -> NSRange;

        /// # Safety
        ///
        /// `actual_glyph_range` must be a valid pointer or null.
        #[unsafe(method(characterRangeForGlyphRange:actualGlyphRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn characterRangeForGlyphRange_actualGlyphRange(
            &self,
            glyph_range: NSRange,
            actual_glyph_range: NSRangePointer,
        ) -> NSRange;

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(glyphRangeForTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn glyphRangeForTextContainer(&self, container: &NSTextContainer) -> NSRange;

        #[unsafe(method(rangeOfNominallySpacedGlyphsContainingIndex:))]
        #[unsafe(method_family = none)]
        pub fn rangeOfNominallySpacedGlyphsContainingIndex(
            &self,
            glyph_index: NSUInteger,
        ) -> NSRange;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(boundingRectForGlyphRange:inTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn boundingRectForGlyphRange_inTextContainer(
            &self,
            glyph_range: NSRange,
            container: &NSTextContainer,
        ) -> CGRect;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(glyphRangeForBoundingRect:inTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn glyphRangeForBoundingRect_inTextContainer(
            &self,
            bounds: CGRect,
            container: &NSTextContainer,
        ) -> NSRange;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(glyphRangeForBoundingRectWithoutAdditionalLayout:inTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn glyphRangeForBoundingRectWithoutAdditionalLayout_inTextContainer(
            &self,
            bounds: CGRect,
            container: &NSTextContainer,
        ) -> NSRange;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        /// # Safety
        ///
        /// `partial_fraction` must be a valid pointer or null.
        #[unsafe(method(glyphIndexForPoint:inTextContainer:fractionOfDistanceThroughGlyph:))]
        #[unsafe(method_family = none)]
        pub unsafe fn glyphIndexForPoint_inTextContainer_fractionOfDistanceThroughGlyph(
            &self,
            point: CGPoint,
            container: &NSTextContainer,
            partial_fraction: *mut CGFloat,
        ) -> NSUInteger;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(glyphIndexForPoint:inTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn glyphIndexForPoint_inTextContainer(
            &self,
            point: CGPoint,
            container: &NSTextContainer,
        ) -> NSUInteger;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(fractionOfDistanceThroughGlyphForPoint:inTextContainer:))]
        #[unsafe(method_family = none)]
        pub fn fractionOfDistanceThroughGlyphForPoint_inTextContainer(
            &self,
            point: CGPoint,
            container: &NSTextContainer,
        ) -> CGFloat;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        /// # Safety
        ///
        /// `partial_fraction` must be a valid pointer or null.
        #[unsafe(method(characterIndexForPoint:inTextContainer:fractionOfDistanceBetweenInsertionPoints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn characterIndexForPoint_inTextContainer_fractionOfDistanceBetweenInsertionPoints(
            &self,
            point: CGPoint,
            container: &NSTextContainer,
            partial_fraction: *mut CGFloat,
        ) -> NSUInteger;

        #[cfg(feature = "objc2-core-foundation")]
        /// # Safety
        ///
        /// - `positions` must be a valid pointer or null.
        /// - `char_indexes` must be a valid pointer or null.
        #[unsafe(method(getLineFragmentInsertionPointsForCharacterAtIndex:alternatePositions:inDisplayOrder:positions:characterIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getLineFragmentInsertionPointsForCharacterAtIndex_alternatePositions_inDisplayOrder_positions_characterIndexes(
            &self,
            char_index: NSUInteger,
            a_flag: bool,
            d_flag: bool,
            positions: *mut CGFloat,
            char_indexes: *mut NSUInteger,
        ) -> NSUInteger;

        #[cfg(all(
            feature = "NSTextContainer",
            feature = "block2",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(enumerateLineFragmentsForGlyphRange:usingBlock:))]
        #[unsafe(method_family = none)]
        pub fn enumerateLineFragmentsForGlyphRange_usingBlock(
            &self,
            glyph_range: NSRange,
            block: &block2::DynBlock<
                dyn Fn(CGRect, CGRect, NonNull<NSTextContainer>, NSRange, NonNull<Bool>),
            >,
        );

        #[cfg(all(
            feature = "NSTextContainer",
            feature = "block2",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(enumerateEnclosingRectsForGlyphRange:withinSelectedGlyphRange:inTextContainer:usingBlock:))]
        #[unsafe(method_family = none)]
        pub fn enumerateEnclosingRectsForGlyphRange_withinSelectedGlyphRange_inTextContainer_usingBlock(
            &self,
            glyph_range: NSRange,
            selected_range: NSRange,
            text_container: &NSTextContainer,
            block: &block2::DynBlock<dyn Fn(CGRect, NonNull<Bool>)>,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// ********************** Drawing support ***********************
        #[unsafe(method(drawBackgroundForGlyphRange:atPoint:))]
        #[unsafe(method_family = none)]
        pub fn drawBackgroundForGlyphRange_atPoint(&self, glyphs_to_show: NSRange, origin: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(drawGlyphsForGlyphRange:atPoint:))]
        #[unsafe(method_family = none)]
        pub fn drawGlyphsForGlyphRange_atPoint(&self, glyphs_to_show: NSRange, origin: CGPoint);

        #[cfg(all(
            feature = "UIFont",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// # Safety
        ///
        /// - `glyphs` must be a valid pointer.
        /// - `positions` must be a valid pointer.
        /// - `attributes` generic should be of the correct type.
        #[unsafe(method(showCGGlyphs:positions:count:font:textMatrix:attributes:inContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showCGGlyphs_positions_count_font_textMatrix_attributes_inContext(
            &self,
            glyphs: NonNull<CGGlyph>,
            positions: NonNull<CGPoint>,
            glyph_count: NSInteger,
            font: &UIFont,
            text_matrix: CGAffineTransform,
            attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
            cg_context: &CGContext,
        );

        #[cfg(all(feature = "UIColor", feature = "objc2-core-foundation"))]
        /// # Safety
        ///
        /// `rect_array` must be a valid pointer.
        #[unsafe(method(fillBackgroundRectArray:count:forCharacterRange:color:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fillBackgroundRectArray_count_forCharacterRange_color(
            &self,
            rect_array: NonNull<CGRect>,
            rect_count: NSUInteger,
            char_range: NSRange,
            color: &UIColor,
        );

        #[cfg(all(feature = "NSAttributedString", feature = "objc2-core-foundation"))]
        #[unsafe(method(drawUnderlineForGlyphRange:underlineType:baselineOffset:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:))]
        #[unsafe(method_family = none)]
        pub fn drawUnderlineForGlyphRange_underlineType_baselineOffset_lineFragmentRect_lineFragmentGlyphRange_containerOrigin(
            &self,
            glyph_range: NSRange,
            underline_val: NSUnderlineStyle,
            baseline_offset: CGFloat,
            line_rect: CGRect,
            line_glyph_range: NSRange,
            container_origin: CGPoint,
        );

        #[cfg(all(feature = "NSAttributedString", feature = "objc2-core-foundation"))]
        #[unsafe(method(underlineGlyphRange:underlineType:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:))]
        #[unsafe(method_family = none)]
        pub fn underlineGlyphRange_underlineType_lineFragmentRect_lineFragmentGlyphRange_containerOrigin(
            &self,
            glyph_range: NSRange,
            underline_val: NSUnderlineStyle,
            line_rect: CGRect,
            line_glyph_range: NSRange,
            container_origin: CGPoint,
        );

        #[cfg(all(feature = "NSAttributedString", feature = "objc2-core-foundation"))]
        #[unsafe(method(drawStrikethroughForGlyphRange:strikethroughType:baselineOffset:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:))]
        #[unsafe(method_family = none)]
        pub fn drawStrikethroughForGlyphRange_strikethroughType_baselineOffset_lineFragmentRect_lineFragmentGlyphRange_containerOrigin(
            &self,
            glyph_range: NSRange,
            strikethrough_val: NSUnderlineStyle,
            baseline_offset: CGFloat,
            line_rect: CGRect,
            line_glyph_range: NSRange,
            container_origin: CGPoint,
        );

        #[cfg(all(feature = "NSAttributedString", feature = "objc2-core-foundation"))]
        #[unsafe(method(strikethroughGlyphRange:strikethroughType:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:))]
        #[unsafe(method_family = none)]
        pub fn strikethroughGlyphRange_strikethroughType_lineFragmentRect_lineFragmentGlyphRange_containerOrigin(
            &self,
            glyph_range: NSRange,
            strikethrough_val: NSUnderlineStyle,
            line_rect: CGRect,
            line_glyph_range: NSRange,
            container_origin: CGPoint,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSLayoutManager {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSLayoutManager {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nslayoutmanagerdelegate?language=objc)
    pub unsafe trait NSLayoutManagerDelegate: NSObjectProtocol {
        #[cfg(all(feature = "UIFont", feature = "objc2-core-graphics"))]
        /// ********************** Glyph generation ***********************
        ///
        /// # Safety
        ///
        /// - `glyphs` must be a valid pointer.
        /// - `props` must be a valid pointer.
        /// - `char_indexes` must be a valid pointer.
        #[optional]
        #[unsafe(method(layoutManager:shouldGenerateGlyphs:properties:characterIndexes:font:forGlyphRange:))]
        #[unsafe(method_family = none)]
        unsafe fn layoutManager_shouldGenerateGlyphs_properties_characterIndexes_font_forGlyphRange(
            &self,
            layout_manager: &NSLayoutManager,
            glyphs: NonNull<CGGlyph>,
            props: NonNull<NSGlyphProperty>,
            char_indexes: NonNull<NSUInteger>,
            a_font: &UIFont,
            glyph_range: NSRange,
        ) -> NSUInteger;

        #[cfg(feature = "objc2-core-foundation")]
        /// ********************** Line layout ***********************
        #[optional]
        #[unsafe(method(layoutManager:lineSpacingAfterGlyphAtIndex:withProposedLineFragmentRect:))]
        #[unsafe(method_family = none)]
        fn layoutManager_lineSpacingAfterGlyphAtIndex_withProposedLineFragmentRect(
            &self,
            layout_manager: &NSLayoutManager,
            glyph_index: NSUInteger,
            rect: CGRect,
        ) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[optional]
        #[unsafe(method(layoutManager:paragraphSpacingBeforeGlyphAtIndex:withProposedLineFragmentRect:))]
        #[unsafe(method_family = none)]
        fn layoutManager_paragraphSpacingBeforeGlyphAtIndex_withProposedLineFragmentRect(
            &self,
            layout_manager: &NSLayoutManager,
            glyph_index: NSUInteger,
            rect: CGRect,
        ) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[optional]
        #[unsafe(method(layoutManager:paragraphSpacingAfterGlyphAtIndex:withProposedLineFragmentRect:))]
        #[unsafe(method_family = none)]
        fn layoutManager_paragraphSpacingAfterGlyphAtIndex_withProposedLineFragmentRect(
            &self,
            layout_manager: &NSLayoutManager,
            glyph_index: NSUInteger,
            rect: CGRect,
        ) -> CGFloat;

        #[optional]
        #[unsafe(method(layoutManager:shouldUseAction:forControlCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        fn layoutManager_shouldUseAction_forControlCharacterAtIndex(
            &self,
            layout_manager: &NSLayoutManager,
            action: NSControlCharacterAction,
            char_index: NSUInteger,
        ) -> NSControlCharacterAction;

        #[optional]
        #[unsafe(method(layoutManager:shouldBreakLineByWordBeforeCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        fn layoutManager_shouldBreakLineByWordBeforeCharacterAtIndex(
            &self,
            layout_manager: &NSLayoutManager,
            char_index: NSUInteger,
        ) -> bool;

        #[optional]
        #[unsafe(method(layoutManager:shouldBreakLineByHyphenatingBeforeCharacterAtIndex:))]
        #[unsafe(method_family = none)]
        fn layoutManager_shouldBreakLineByHyphenatingBeforeCharacterAtIndex(
            &self,
            layout_manager: &NSLayoutManager,
            char_index: NSUInteger,
        ) -> bool;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[optional]
        #[unsafe(method(layoutManager:boundingBoxForControlGlyphAtIndex:forTextContainer:proposedLineFragment:glyphPosition:characterIndex:))]
        #[unsafe(method_family = none)]
        fn layoutManager_boundingBoxForControlGlyphAtIndex_forTextContainer_proposedLineFragment_glyphPosition_characterIndex(
            &self,
            layout_manager: &NSLayoutManager,
            glyph_index: NSUInteger,
            text_container: &NSTextContainer,
            proposed_rect: CGRect,
            glyph_position: CGPoint,
            char_index: NSUInteger,
        ) -> CGRect;

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        /// # Safety
        ///
        /// - `line_fragment_rect` must be a valid pointer.
        /// - `line_fragment_used_rect` must be a valid pointer.
        /// - `baseline_offset` must be a valid pointer.
        #[optional]
        #[unsafe(method(layoutManager:shouldSetLineFragmentRect:lineFragmentUsedRect:baselineOffset:inTextContainer:forGlyphRange:))]
        #[unsafe(method_family = none)]
        unsafe fn layoutManager_shouldSetLineFragmentRect_lineFragmentUsedRect_baselineOffset_inTextContainer_forGlyphRange(
            &self,
            layout_manager: &NSLayoutManager,
            line_fragment_rect: NonNull<CGRect>,
            line_fragment_used_rect: NonNull<CGRect>,
            baseline_offset: NonNull<CGFloat>,
            text_container: &NSTextContainer,
            glyph_range: NSRange,
        ) -> bool;

        /// ********************** Layout processing ***********************
        #[optional]
        #[unsafe(method(layoutManagerDidInvalidateLayout:))]
        #[unsafe(method_family = none)]
        fn layoutManagerDidInvalidateLayout(&self, sender: &NSLayoutManager);

        #[cfg(feature = "NSTextContainer")]
        #[optional]
        #[unsafe(method(layoutManager:didCompleteLayoutForTextContainer:atEnd:))]
        #[unsafe(method_family = none)]
        fn layoutManager_didCompleteLayoutForTextContainer_atEnd(
            &self,
            layout_manager: &NSLayoutManager,
            text_container: Option<&NSTextContainer>,
            layout_finished_flag: bool,
        );

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[optional]
        #[unsafe(method(layoutManager:textContainer:didChangeGeometryFromSize:))]
        #[unsafe(method_family = none)]
        fn layoutManager_textContainer_didChangeGeometryFromSize(
            &self,
            layout_manager: &NSLayoutManager,
            text_container: &NSTextContainer,
            old_size: CGSize,
        );
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharacterzeroadvancementaction?language=objc)
#[deprecated]
pub const NSControlCharacterZeroAdvancementAction: NSInteger =
    NSControlCharacterAction::ZeroAdvancement.0;
/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharacterwhitespaceaction?language=objc)
#[deprecated]
pub const NSControlCharacterWhitespaceAction: NSInteger = NSControlCharacterAction::Whitespace.0;
/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharacterhorizontaltabaction?language=objc)
#[deprecated]
pub const NSControlCharacterHorizontalTabAction: NSInteger =
    NSControlCharacterAction::HorizontalTab.0;
/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharacterlinebreakaction?language=objc)
#[deprecated]
pub const NSControlCharacterLineBreakAction: NSInteger = NSControlCharacterAction::LineBreak.0;
/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharacterparagraphbreakaction?language=objc)
#[deprecated]
pub const NSControlCharacterParagraphBreakAction: NSInteger =
    NSControlCharacterAction::ParagraphBreak.0;
/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscontrolcharactercontainerbreakaction?language=objc)
#[deprecated]
pub const NSControlCharacterContainerBreakAction: NSInteger =
    NSControlCharacterAction::ContainerBreak.0;

/// NSLayoutManagerDeprecated.
impl NSLayoutManager {
    extern_methods!(
        #[cfg(feature = "objc2-core-graphics")]
        /// # Safety
        ///
        /// `is_valid_index` must be a valid pointer or null.
        #[unsafe(method(glyphAtIndex:isValidIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn glyphAtIndex_isValidIndex(
            &self,
            glyph_index: NSUInteger,
            is_valid_index: *mut Bool,
        ) -> CGGlyph;

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(glyphAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn glyphAtIndex(&self, glyph_index: NSUInteger) -> CGGlyph;

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "Please use usesDefaultHyphenation or -[NSParagraphStyle hyphenationFactor] instead."]
        #[unsafe(method(hyphenationFactor))]
        #[unsafe(method_family = none)]
        pub fn hyphenationFactor(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`hyphenationFactor`][Self::hyphenationFactor].
        #[deprecated = "Please use usesDefaultHyphenation or -[NSParagraphStyle hyphenationFactor] instead."]
        #[unsafe(method(setHyphenationFactor:))]
        #[unsafe(method_family = none)]
        pub fn setHyphenationFactor(&self, hyphenation_factor: CGFloat);

        #[cfg(all(
            feature = "UIFont",
            feature = "objc2-core-foundation",
            feature = "objc2-core-graphics"
        ))]
        /// # Safety
        ///
        /// - `glyphs` must be a valid pointer.
        /// - `positions` must be a valid pointer.
        /// - `attributes` generic should be of the correct type.
        #[deprecated]
        #[unsafe(method(showCGGlyphs:positions:count:font:matrix:attributes:inContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showCGGlyphs_positions_count_font_matrix_attributes_inContext(
            &self,
            glyphs: NonNull<CGGlyph>,
            positions: NonNull<CGPoint>,
            glyph_count: NSUInteger,
            font: &UIFont,
            text_matrix: CGAffineTransform,
            attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
            graphics_context: &CGContext,
        );
    );
}
