//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctglyphinfo?language=objc)
///
/// This is toll-free bridged with `NSGlyphInfo`.
#[doc(alias = "CTGlyphInfoRef")]
#[repr(C)]
pub struct CTGlyphInfo {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTGlyphInfo {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTGlyphInfo"> for CTGlyphInfo {}
);

unsafe impl ConcreteType for CTGlyphInfo {
    /// Returns the CFType of the glyph info object
    #[doc(alias = "CTGlyphInfoGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTGlyphInfoGetTypeID() -> CFTypeID;
        }
        unsafe { CTGlyphInfoGetTypeID() }
    }
}

/// These constants specify character collections.
///
///
/// Indicates that the character identifier is equal to the CGGlyph
/// glyph index.
///
///
/// Indicates the Adobe-CNS1 mapping.
///
///
/// Indicates the Adobe-GB1 mapping.
///
///
/// Indicates the Adobe-Japan1 mapping.
///
///
/// Indicates the Adobe-Japan2 mapping.
///
///
/// Indicates the Adobe-Korea1 mapping.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctcharactercollection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTCharacterCollection(pub u16);
impl CTCharacterCollection {
    #[doc(alias = "kCTCharacterCollectionIdentityMapping")]
    pub const IdentityMapping: Self = Self(0);
    #[doc(alias = "kCTCharacterCollectionAdobeCNS1")]
    pub const AdobeCNS1: Self = Self(1);
    #[doc(alias = "kCTCharacterCollectionAdobeGB1")]
    pub const AdobeGB1: Self = Self(2);
    #[doc(alias = "kCTCharacterCollectionAdobeJapan1")]
    pub const AdobeJapan1: Self = Self(3);
    #[doc(alias = "kCTCharacterCollectionAdobeJapan2")]
    pub const AdobeJapan2: Self = Self(4);
    #[doc(alias = "kCTCharacterCollectionAdobeKorea1")]
    pub const AdobeKorea1: Self = Self(5);
    #[deprecated = "Deprecated"]
    pub const kCTIdentityMappingCharacterCollection: Self =
        Self(CTCharacterCollection::IdentityMapping.0);
    #[deprecated = "Deprecated"]
    pub const kCTAdobeCNS1CharacterCollection: Self = Self(CTCharacterCollection::AdobeCNS1.0);
    #[deprecated = "Deprecated"]
    pub const kCTAdobeGB1CharacterCollection: Self = Self(CTCharacterCollection::AdobeGB1.0);
    #[deprecated = "Deprecated"]
    pub const kCTAdobeJapan1CharacterCollection: Self = Self(CTCharacterCollection::AdobeJapan1.0);
    #[deprecated = "Deprecated"]
    pub const kCTAdobeJapan2CharacterCollection: Self = Self(CTCharacterCollection::AdobeJapan2.0);
    #[deprecated = "Deprecated"]
    pub const kCTAdobeKorea1CharacterCollection: Self = Self(CTCharacterCollection::AdobeKorea1.0);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTCharacterCollection {
    const ENCODING: Encoding = u16::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTCharacterCollection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CTGlyphInfo {
    /// Creates an immutable glyph info object.
    ///
    ///
    /// This function creates an immutable glyph info object for a glyph
    /// name such as "copyright" and a specified font.
    ///
    ///
    /// Parameter `glyphName`: The name of the glyph.
    ///
    ///
    /// Parameter `font`: The font to be associated with the returned CTGlyphInfo object.
    ///
    ///
    /// Parameter `baseString`: The part of the string the returned object is intended
    /// to override.
    ///
    ///
    /// Returns: This function will return a reference to a CTGlyphInfo object.
    #[doc(alias = "CTGlyphInfoCreateWithGlyphName")]
    #[cfg(feature = "CTFont")]
    #[inline]
    pub unsafe fn with_glyph_name(
        glyph_name: &CFString,
        font: &CTFont,
        base_string: &CFString,
    ) -> Option<CFRetained<CTGlyphInfo>> {
        extern "C-unwind" {
            fn CTGlyphInfoCreateWithGlyphName(
                glyph_name: &CFString,
                font: &CTFont,
                base_string: &CFString,
            ) -> Option<NonNull<CTGlyphInfo>>;
        }
        let ret = unsafe { CTGlyphInfoCreateWithGlyphName(glyph_name, font, base_string) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates an immutable glyph info object.
    ///
    ///
    /// This function creates an immutable glyph info object for a glyph
    /// index and a specified font.
    ///
    ///
    /// Parameter `glyph`: The glyph identifier.
    ///
    ///
    /// Parameter `font`: The font to be associated with the returned CTGlyphInfo object.
    ///
    ///
    /// Parameter `baseString`: The part of the string the returned object is intended
    /// to override.
    ///
    ///
    /// Returns: This function will return a reference to a CTGlyphInfo object.
    #[doc(alias = "CTGlyphInfoCreateWithGlyph")]
    #[cfg(all(feature = "CTFont", feature = "objc2-core-graphics"))]
    #[inline]
    pub unsafe fn with_glyph(
        glyph: CGGlyph,
        font: &CTFont,
        base_string: &CFString,
    ) -> Option<CFRetained<CTGlyphInfo>> {
        extern "C-unwind" {
            fn CTGlyphInfoCreateWithGlyph(
                glyph: CGGlyph,
                font: &CTFont,
                base_string: &CFString,
            ) -> Option<NonNull<CTGlyphInfo>>;
        }
        let ret = unsafe { CTGlyphInfoCreateWithGlyph(glyph, font, base_string) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates an immutable glyph info object.
    ///
    ///
    /// This function creates an immutable glyph info object for a
    /// character identifier and a character collection.
    ///
    ///
    /// Parameter `cid`: A character identifier.
    ///
    ///
    /// Parameter `collection`: A character collection identifier.
    ///
    ///
    /// Parameter `baseString`: The part of the string the returned object is intended
    /// to override.
    ///
    ///
    /// Returns: This function will return a reference to a CTGlyphInfo object.
    #[doc(alias = "CTGlyphInfoCreateWithCharacterIdentifier")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn with_character_identifier(
        cid: CGFontIndex,
        collection: CTCharacterCollection,
        base_string: &CFString,
    ) -> Option<CFRetained<CTGlyphInfo>> {
        extern "C-unwind" {
            fn CTGlyphInfoCreateWithCharacterIdentifier(
                cid: CGFontIndex,
                collection: CTCharacterCollection,
                base_string: &CFString,
            ) -> Option<NonNull<CTGlyphInfo>>;
        }
        let ret = unsafe { CTGlyphInfoCreateWithCharacterIdentifier(cid, collection, base_string) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Gets the glyph name for a glyph info, if applicable.
    ///
    ///
    /// This function will return the glyph name.
    ///
    ///
    /// Parameter `glyphInfo`: The glyph info for which you would like the glyph name.
    ///
    ///
    /// Returns: If the glyph info object was created with a glyph name, it will
    /// be returned. Otherwise, this function will return NULL.
    #[doc(alias = "CTGlyphInfoGetGlyphName")]
    #[inline]
    pub unsafe fn glyph_name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CTGlyphInfoGetGlyphName(glyph_info: &CTGlyphInfo) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTGlyphInfoGetGlyphName(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Gets the glyph for a glyph info, if applicable.
    ///
    ///
    /// This function will return the glyph.
    ///
    ///
    /// Parameter `glyphInfo`: The glyph info from which you would like the glyph.
    ///
    ///
    /// Returns: If the glyph info object was created with a font, it will be
    /// returned. Otherwise, this function will return 0.
    #[doc(alias = "CTGlyphInfoGetGlyph")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn glyph(&self) -> CGGlyph {
        extern "C-unwind" {
            fn CTGlyphInfoGetGlyph(glyph_info: &CTGlyphInfo) -> CGGlyph;
        }
        unsafe { CTGlyphInfoGetGlyph(self) }
    }

    /// Gets the character identifier for a glyph info.
    ///
    ///
    /// This function will return the character identifier.
    ///
    ///
    /// Parameter `glyphInfo`: The glyph info for which you would like the character identifier.
    ///
    ///
    /// Returns: If the glyph info object was created with a character identifier,
    /// it will be returned. Otherwise, this function will return 0.
    #[doc(alias = "CTGlyphInfoGetCharacterIdentifier")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn character_identifier(&self) -> CGFontIndex {
        extern "C-unwind" {
            fn CTGlyphInfoGetCharacterIdentifier(glyph_info: &CTGlyphInfo) -> CGFontIndex;
        }
        unsafe { CTGlyphInfoGetCharacterIdentifier(self) }
    }

    /// Gets the character collection for a glyph info.
    ///
    ///
    /// This function will return the character collection. If the glyph
    /// info object was created with a glyph name or a glyph index, its
    /// character collection will be
    /// kCTIdentityMappingCharacterCollection.
    ///
    ///
    /// Parameter `glyphInfo`: The glyph info for which you would like the character collection.
    ///
    ///
    /// Returns: This function will return the character collection of the given
    /// glyph info.
    #[doc(alias = "CTGlyphInfoGetCharacterCollection")]
    #[inline]
    pub unsafe fn character_collection(&self) -> CTCharacterCollection {
        extern "C-unwind" {
            fn CTGlyphInfoGetCharacterCollection(glyph_info: &CTGlyphInfo)
                -> CTCharacterCollection;
        }
        unsafe { CTGlyphInfoGetCharacterCollection(self) }
    }
}

#[cfg(feature = "CTFont")]
#[deprecated = "renamed to `CTGlyphInfo::with_glyph_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTGlyphInfoCreateWithGlyphName(
    glyph_name: &CFString,
    font: &CTFont,
    base_string: &CFString,
) -> Option<CFRetained<CTGlyphInfo>> {
    extern "C-unwind" {
        fn CTGlyphInfoCreateWithGlyphName(
            glyph_name: &CFString,
            font: &CTFont,
            base_string: &CFString,
        ) -> Option<NonNull<CTGlyphInfo>>;
    }
    let ret = unsafe { CTGlyphInfoCreateWithGlyphName(glyph_name, font, base_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CTFont", feature = "objc2-core-graphics"))]
#[deprecated = "renamed to `CTGlyphInfo::with_glyph`"]
#[inline]
pub unsafe extern "C-unwind" fn CTGlyphInfoCreateWithGlyph(
    glyph: CGGlyph,
    font: &CTFont,
    base_string: &CFString,
) -> Option<CFRetained<CTGlyphInfo>> {
    extern "C-unwind" {
        fn CTGlyphInfoCreateWithGlyph(
            glyph: CGGlyph,
            font: &CTFont,
            base_string: &CFString,
        ) -> Option<NonNull<CTGlyphInfo>>;
    }
    let ret = unsafe { CTGlyphInfoCreateWithGlyph(glyph, font, base_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "objc2-core-graphics")]
#[deprecated = "renamed to `CTGlyphInfo::with_character_identifier`"]
#[inline]
pub unsafe extern "C-unwind" fn CTGlyphInfoCreateWithCharacterIdentifier(
    cid: CGFontIndex,
    collection: CTCharacterCollection,
    base_string: &CFString,
) -> Option<CFRetained<CTGlyphInfo>> {
    extern "C-unwind" {
        fn CTGlyphInfoCreateWithCharacterIdentifier(
            cid: CGFontIndex,
            collection: CTCharacterCollection,
            base_string: &CFString,
        ) -> Option<NonNull<CTGlyphInfo>>;
    }
    let ret = unsafe { CTGlyphInfoCreateWithCharacterIdentifier(cid, collection, base_string) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTGlyphInfo::glyph_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTGlyphInfoGetGlyphName(
    glyph_info: &CTGlyphInfo,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CTGlyphInfoGetGlyphName(glyph_info: &CTGlyphInfo) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTGlyphInfoGetGlyphName(glyph_info) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTGlyphInfo::glyph`"]
    pub fn CTGlyphInfoGetGlyph(glyph_info: &CTGlyphInfo) -> CGGlyph;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTGlyphInfo::character_identifier`"]
    pub fn CTGlyphInfoGetCharacterIdentifier(glyph_info: &CTGlyphInfo) -> CGFontIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTGlyphInfo::character_collection`"]
    pub fn CTGlyphInfoGetCharacterCollection(glyph_info: &CTGlyphInfo) -> CTCharacterCollection;
}
