//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cknotificationid?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKNotificationID;
);

extern_conformance!(
    unsafe impl NSCoding for CKNotificationID {}
);

extern_conformance!(
    unsafe impl NSCopying for CKNotificationID {}
);

unsafe impl CopyingHelper for CKNotificationID {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKNotificationID {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKNotificationID {}
);

impl CKNotificationID {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl CKNotificationID {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cknotificationtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKNotificationType(pub NSInteger);
impl CKNotificationType {
    /// Generated by ``CKQuerySubscription``s
    #[doc(alias = "CKNotificationTypeQuery")]
    pub const Query: Self = Self(1);
    /// Generated by ``CKRecordZoneSubscription``s
    #[doc(alias = "CKNotificationTypeRecordZone")]
    pub const RecordZone: Self = Self(2);
    /// Indicates a notification that a client had previously marked as read
    #[doc(alias = "CKNotificationTypeReadNotification")]
    pub const ReadNotification: Self = Self(3);
    /// Generated by ``CKDatabaseSubscription``s
    #[doc(alias = "CKNotificationTypeDatabase")]
    pub const Database: Self = Self(4);
}

unsafe impl Encode for CKNotificationType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKNotificationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// Pushes from CloudKit servers contain both CloudKit-specific and APS-specific information.
    /// APS-specific information includes elements like alerts, badges, sounds, categories, etc.
    /// When receiving a push from CloudKit servers, the push may be delivered via multiple API flows.
    /// The flow(s) chosen will depend on the type of push requested (e.g. via the ``CKSubscription``
    /// that triggered it and its configured `notificationInfo`).
    ///
    /// Pushes with UI elements (alerts, badges, sounds):
    /// These pushes are delivered via the `UserNotifications` framework, in the form of a `UNNotification`
    /// Applications should use the `UserNotifications` framework to interact with the UI elements of this push.
    /// Applications may create a ``CKNotification`` from a `UNNotification` in their `UNUserNotificationCenterDelegate`:
    ///
    /// func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification) async -> UNNotificationPresentationOptions {
    /// let ckNotification = CKNotification(fromRemoteNotificationDictionary: notification.request.content.userInfo)
    /// }
    ///
    /// Pushes with `content-available`:
    /// These pushes are delivered via an application delegate, in the form of a remote notification.
    /// For example: `UIApplicationDelegate.application(_:didReceiveRemoteNotification:) async`
    /// Applications do not need to interact with any UI element in the push payload argument, that's intended to be handled via the `UserNotifications` flow
    /// (a push with both UI elements and `content-available` will be delivered via both API flows)
    /// Applications may create a ``CKNotification`` from the remote notification in their `UIApplicationDelegate`:
    ///
    /// func application(_ application: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable : Any]) async -> UIBackgroundFetchResult {
    /// let ckNotification = CKNotification(fromRemoteNotificationDictionary: userInfo)
    /// }
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cknotification?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKNotification;
);

unsafe impl Send for CKNotification {}

unsafe impl Sync for CKNotification {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKNotification {}
);

impl CKNotification {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        /// # Safety
        ///
        /// `notification_dictionary` generic should be of the correct type.
        #[unsafe(method(notificationFromRemoteNotificationDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationFromRemoteNotificationDictionary(
            notification_dictionary: &NSDictionary,
        ) -> Option<Retained<Self>>;

        /// When you instantiate a ``CKNotification`` from a remote notification dictionary, you will get back a concrete
        /// subclass defined below.  Use `notificationType` to avoid `as?` or `-isKindOfClass:` checks.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(notificationType))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationType(&self) -> CKNotificationType;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(notificationID))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationID(&self) -> Option<Retained<CKNotificationID>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(containerIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn containerIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "CKRecordID")]
        /// The user `recordID` of the owner of the subscription for which this notification was generated
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(subscriptionOwnerUserRecordID))]
        #[unsafe(method_family = none)]
        pub unsafe fn subscriptionOwnerUserRecordID(&self) -> Option<Retained<CKRecordID>>;

        /// Whether or not the notification fully represents what the server wanted to send.
        ///
        /// Push notifications have a limited size.  In some cases, CloudKit servers may not be able to send you a full ``CKNotification``'s worth of info in one push.
        /// In those cases, `isPruned` returns `true`.
        /// The order in which properties are dropped from a push notification is defined in each ``CKNotification`` subclass below.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(isPruned))]
        #[unsafe(method_family = none)]
        pub unsafe fn isPruned(&self) -> bool;

        #[cfg(feature = "CKSubscription")]
        /// The ID of the subscription that caused this notification to fire.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(subscriptionID))]
        #[unsafe(method_family = none)]
        pub unsafe fn subscriptionID(&self) -> Option<Retained<CKSubscriptionID>>;
    );
}

/// DeprecatedAPSProperties.
#[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
impl CKNotification {
    extern_methods!(
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(alertBody))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertBody(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(alertLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(alertLocalizationArgs))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertLocalizationArgs(&self) -> Option<Retained<NSArray<NSString>>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(titleLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(titleLocalizationArgs))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleLocalizationArgs(&self) -> Option<Retained<NSArray<NSString>>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(subtitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitle(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(subtitleLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitleLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(subtitleLocalizationArgs))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitleLocalizationArgs(&self) -> Option<Retained<NSArray<NSString>>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(alertActionLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertActionLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(alertLaunchImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertLaunchImage(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(badge))]
        #[unsafe(method_family = none)]
        pub unsafe fn badge(&self) -> Option<Retained<NSNumber>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Interact with UI elements of a CloudKit-server-generated push message via UserNotifications.framework"]
        #[unsafe(method(soundName))]
        #[unsafe(method_family = none)]
        pub unsafe fn soundName(&self) -> Option<Retained<NSString>>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(category))]
        #[unsafe(method_family = none)]
        pub unsafe fn category(&self) -> Option<Retained<NSString>>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckquerynotificationreason?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKQueryNotificationReason(pub NSInteger);
impl CKQueryNotificationReason {
    #[doc(alias = "CKQueryNotificationReasonRecordCreated")]
    pub const RecordCreated: Self = Self(1);
    #[doc(alias = "CKQueryNotificationReasonRecordUpdated")]
    pub const RecordUpdated: Self = Self(2);
    #[doc(alias = "CKQueryNotificationReasonRecordDeleted")]
    pub const RecordDeleted: Self = Self(3);
}

unsafe impl Encode for CKQueryNotificationReason {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKQueryNotificationReason {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A notification generated by a ``CKQuerySubscription``
    ///
    /// `notificationType` == `.query`
    /// When properties must be dropped (see
    /// `isPruned),`here's the order of importance.  The most important properties are first, they'll be the last ones to be dropped.
    /// - notificationID
    /// - badge
    /// - alertLocalizationKey
    /// - alertLocalizationArgs
    /// - alertBody
    /// - alertActionLocalizationKey
    /// - alertLaunchImage
    /// - soundName
    /// - content-available
    /// - desiredKeys
    /// - queryNotificationReason
    /// - recordID
    /// - containerIdentifier
    /// - subscriptionOwnerUserRecordID
    /// - titleLocalizationKey
    /// - titleLocalizationArgs
    /// - title
    /// - subtitleLocalizationKey
    /// - subtitleLocalizationArgs
    /// - subtitle
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckquerynotification?language=objc)
    #[unsafe(super(CKNotification, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKQueryNotification;
);

unsafe impl Send for CKQueryNotification {}

unsafe impl Sync for CKQueryNotification {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKQueryNotification {}
);

impl CKQueryNotification {
    extern_methods!(
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(queryNotificationReason))]
        #[unsafe(method_family = none)]
        pub unsafe fn queryNotificationReason(&self) -> CKQueryNotificationReason;

        /// A set of key->value pairs for creates and updates.
        ///
        /// You request the server fill out this property via the `desiredKeys` property of `CKSubscription.NotificationInfo`
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(recordFields))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordFields(&self) -> Option<Retained<NSDictionary<NSString, AnyObject>>>;

        #[cfg(feature = "CKRecordID")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(recordID))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordID(&self) -> Option<Retained<CKRecordID>>;

        #[cfg(feature = "CKDatabase")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(databaseScope))]
        #[unsafe(method_family = none)]
        pub unsafe fn databaseScope(&self) -> CKDatabaseScope;
    );
}

/// Methods declared on superclass `CKNotification`.
impl CKQueryNotification {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        /// # Safety
        ///
        /// `notification_dictionary` generic should be of the correct type.
        #[unsafe(method(notificationFromRemoteNotificationDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationFromRemoteNotificationDictionary(
            notification_dictionary: &NSDictionary,
        ) -> Option<Retained<Self>>;
    );
}

extern_class!(
    /// A notification generated by a ``CKRecordZoneSubscription``
    ///
    /// `notificationType` == `.recordZone`
    /// When properties must be dropped (see
    /// `isPruned),`here's the order of importance.  The most important properties are first, they'll be the last ones to be dropped.
    /// - notificationID
    /// - badge
    /// - alertLocalizationKey
    /// - alertLocalizationArgs
    /// - alertBody
    /// - alertActionLocalizationKey
    /// - alertLaunchImage
    /// - soundName
    /// - content-available
    /// - recordZoneID
    /// - containerIdentifier
    /// - subscriptionOwnerUserRecordID
    /// - titleLocalizationKey
    /// - titleLocalizationArgs
    /// - title
    /// - subtitleLocalizationKey
    /// - subtitleLocalizationArgs
    /// - subtitle
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckrecordzonenotification?language=objc)
    #[unsafe(super(CKNotification, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKRecordZoneNotification;
);

unsafe impl Send for CKRecordZoneNotification {}

unsafe impl Sync for CKRecordZoneNotification {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKRecordZoneNotification {}
);

impl CKRecordZoneNotification {
    extern_methods!(
        #[cfg(feature = "CKRecordZoneID")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(recordZoneID))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneID(&self) -> Option<Retained<CKRecordZoneID>>;

        #[cfg(feature = "CKDatabase")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(databaseScope))]
        #[unsafe(method_family = none)]
        pub unsafe fn databaseScope(&self) -> CKDatabaseScope;
    );
}

/// Methods declared on superclass `CKNotification`.
impl CKRecordZoneNotification {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        /// # Safety
        ///
        /// `notification_dictionary` generic should be of the correct type.
        #[unsafe(method(notificationFromRemoteNotificationDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationFromRemoteNotificationDictionary(
            notification_dictionary: &NSDictionary,
        ) -> Option<Retained<Self>>;
    );
}

extern_class!(
    /// A notification generated by a ``CKDatabaseSubscription``
    ///
    /// `notificationType` == `.database`
    /// When properties must be dropped (see
    /// `isPruned),`here's the order of importance.  The most important properties are first, they'll be the last ones to be dropped.
    /// - notificationID
    /// - badge
    /// - alertLocalizationKey
    /// - alertLocalizationArgs
    /// - alertBody
    /// - alertActionLocalizationKey
    /// - alertLaunchImage
    /// - soundName
    /// - content-available
    /// - containerIdentifier
    /// - subscriptionOwnerUserRecordID
    /// - titleLocalizationKey
    /// - titleLocalizationArgs
    /// - title
    /// - subtitleLocalizationKey
    /// - subtitleLocalizationArgs
    /// - subtitle
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckdatabasenotification?language=objc)
    #[unsafe(super(CKNotification, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKDatabaseNotification;
);

unsafe impl Send for CKDatabaseNotification {}

unsafe impl Sync for CKDatabaseNotification {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKDatabaseNotification {}
);

impl CKDatabaseNotification {
    extern_methods!(
        #[cfg(feature = "CKDatabase")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(databaseScope))]
        #[unsafe(method_family = none)]
        pub unsafe fn databaseScope(&self) -> CKDatabaseScope;
    );
}

/// Methods declared on superclass `CKNotification`.
impl CKDatabaseNotification {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        /// # Safety
        ///
        /// `notification_dictionary` generic should be of the correct type.
        #[unsafe(method(notificationFromRemoteNotificationDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationFromRemoteNotificationDictionary(
            notification_dictionary: &NSDictionary,
        ) -> Option<Retained<Self>>;
    );
}
