/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.util.ArrayList;
import java.util.LinkedList;
import sun.java2d.jules.IdleTileCache;
import sun.java2d.jules.JulesAATileGenerator;
import sun.java2d.jules.JulesTile;
import sun.java2d.jules.TileTrapContainer;

public class TileWorker
implements Runnable {
    static final int RASTERIZED_TILE_SYNC_GRANULARITY = 8;
    final ArrayList<JulesTile> rasterizedTileConsumerCache = new ArrayList();
    final LinkedList<JulesTile> rasterizedBuffers = new LinkedList();
    IdleTileCache tileCache;
    JulesAATileGenerator tileGenerator;
    int workerStartIndex;
    volatile int consumerPos = 0;
    int mainThreadCnt = 0;
    int workerCnt = 0;
    int doubled = 0;

    public TileWorker(JulesAATileGenerator julesAATileGenerator, int n, IdleTileCache idleTileCache) {
        this.tileGenerator = julesAATileGenerator;
        this.workerStartIndex = n;
        this.tileCache = idleTileCache;
    }

    @Override
    public void run() {
        ArrayList<JulesTile> arrayList = new ArrayList<JulesTile>(16);
        for (int i = this.workerStartIndex; i < this.tileGenerator.getTileCount(); ++i) {
            TileTrapContainer tileTrapContainer = this.tileGenerator.getTrapContainer(i);
            if (tileTrapContainer != null && tileTrapContainer.getTileAlpha() == 127) {
                JulesTile julesTile = this.tileGenerator.rasterizeTile(i, this.tileCache.getIdleTileWorker(this.tileGenerator.getTileCount() - i - 1));
                arrayList.add(julesTile);
                if (arrayList.size() > 8) {
                    this.addRasterizedTiles(arrayList);
                    arrayList.clear();
                }
            }
            i = Math.max(i, this.consumerPos + 4);
        }
        this.addRasterizedTiles(arrayList);
        this.tileCache.disposeRasterizerResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JulesTile getPreRasterizedTile(int n) {
        Object object;
        Object object2 = null;
        if (this.rasterizedTileConsumerCache.size() == 0 && n >= this.workerStartIndex) {
            object = this.rasterizedBuffers;
            synchronized (object) {
                this.rasterizedTileConsumerCache.addAll(this.rasterizedBuffers);
                this.rasterizedBuffers.clear();
            }
        }
        while (object2 == null && this.rasterizedTileConsumerCache.size() > 0 && ((JulesTile)(object = this.rasterizedTileConsumerCache.get(0))).getTilePos() <= n) {
            if (((JulesTile)object).getTilePos() < n) {
                this.tileCache.releaseTile((JulesTile)object);
                ++this.doubled;
            }
            if (((JulesTile)object).getTilePos() <= n) {
                this.rasterizedTileConsumerCache.remove(0);
            }
            if (((JulesTile)object).getTilePos() != n) continue;
            object2 = object;
        }
        if (object2 == null) {
            ++this.mainThreadCnt;
            this.consumerPos = n;
        } else {
            ++this.workerCnt;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRasterizedTiles(ArrayList<JulesTile> arrayList) {
        LinkedList<JulesTile> linkedList = this.rasterizedBuffers;
        synchronized (linkedList) {
            this.rasterizedBuffers.addAll(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeConsumerResources() {
        LinkedList<JulesTile> linkedList = this.rasterizedBuffers;
        synchronized (linkedList) {
            this.tileCache.releaseTiles(this.rasterizedBuffers);
        }
        this.tileCache.releaseTiles(this.rasterizedTileConsumerCache);
    }
}

