-- C83024E0.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- OBJECTIVE:
--     CHECK THAT A DECLARATION IN THE DECLARATIVE REGION OF A GENERIC
--     PACKAGE HIDES AN OUTER DECLARATION OF A HOMOGRAPH. ALSO CHECK
--     THAT THE OUTER DECLARATION IS DIRECTLY VISIBLE IN BOTH
--     DECLARATIVE REGIONS BEFORE THE DECLARATION OF THE INNER HOMOGRAPH
--     AND THE OUTER DECLARATION IS VISIBLE BY SELECTION AFTER THE INNER
--     HOMOGRAPH DECLARATION, IF THE GENERIC PACKAGE BODY IS SEPARATELY
--     COMPILED, BUT NOT AS A SUBUNIT.

-- HISTORY:
--     BCB 08/30/88  CREATED ORIGINAL TEST.
-- PWN 11/30/94 ADDED A PROCEDURE TO KEEP PACKAGE BODIES LEGAL.

GENERIC
     TYPE T IS PRIVATE;
     X : T;
FUNCTION C83024E_GEN_FUN RETURN T;

FUNCTION C83024E_GEN_FUN RETURN T IS
BEGIN
     RETURN X;
END C83024E_GEN_FUN;

WITH REPORT; USE REPORT;
PRAGMA ELABORATE(REPORT);
PACKAGE C83024E_P1 IS
     A : INTEGER := IDENT_INT(2);
     B : INTEGER := A;

     PROCEDURE REQUIRE_BODY;

     GENERIC
          X : IN OUT INTEGER;
     PACKAGE C83024E_PACK1 IS
          C : INTEGER := A;
          A : INTEGER := IDENT_INT(3);
     END C83024E_PACK1;
END C83024E_P1;

WITH REPORT; USE REPORT;
PRAGMA ELABORATE(REPORT);
PACKAGE C83024E_P2 IS
     A : INTEGER := IDENT_INT(2);
     B : INTEGER := A;
     OBJ : INTEGER := IDENT_INT(3);

     PROCEDURE REQUIRE_BODY;

     GENERIC
          X : IN INTEGER := A;
          A : IN OUT INTEGER;
     PACKAGE C83024E_PACK2 IS
          C : INTEGER := A;
     END C83024E_PACK2;
END C83024E_P2;

WITH REPORT; USE REPORT;
PRAGMA ELABORATE(REPORT);
PACKAGE C83024E_P3 IS
     A : INTEGER := IDENT_INT(2);
     B : INTEGER := A;

     PROCEDURE REQUIRE_BODY;

     GENERIC
          X : IN OUT INTEGER;
     PACKAGE C83024E_PACK3 IS
     END C83024E_PACK3;
END C83024E_P3;

WITH REPORT; USE REPORT;
WITH C83024E_GEN_FUN;
PRAGMA ELABORATE(REPORT,C83024E_GEN_FUN);
PACKAGE C83024E_P4 IS
     OBJ : INTEGER := IDENT_INT(1);
     FLO : FLOAT := 6.25;

     PROCEDURE REQUIRE_BODY;

     FUNCTION F IS NEW C83024E_GEN_FUN (INTEGER, OBJ);
     FUNCTION F IS NEW C83024E_GEN_FUN (FLOAT, FLO);

     GENERIC
          X : IN OUT INTEGER;
          F : IN FLOAT;
     PACKAGE C83024E_PACK4 IS
     END C83024E_PACK4;
END C83024E_P4;
