/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.utils.jars;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0004J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lio/bazel/kotlin/builder/utils/jars/JarExtractor;", "", "destDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getDestDir", "()Ljava/nio/file/Path;", "setDestDir", "extract", "", "jarFile", "preWrite", "", "isDirectory", "target", "preWrite$src_main_kotlin_io_bazel_kotlin_builder_utils_jars_jars", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
public class JarExtractor {
    @NotNull
    private Path destDir;

    protected JarExtractor(@NotNull Path destDir) {
        Intrinsics.checkNotNullParameter(destDir, "destDir");
        this.destDir = destDir;
    }

    @NotNull
    protected final Path getDestDir() {
        return this.destDir;
    }

    protected final void setDestDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "<set-?>");
        this.destDir = path;
    }

    public boolean preWrite$src_main_kotlin_io_bazel_kotlin_builder_utils_jars_jars(boolean isDirectory, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void extract(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter(jarFile, "jarFile");
        Closeable closeable = new JarFile(jarFile.toFile());
        Throwable throwable = null;
        try {
            Enumeration<JarEntry> enumeration;
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> entries = enumeration = jar.entries();
            boolean bl2 = false;
            while (entries.hasMoreElements()) {
                Path path;
                JarEntry jarEntry;
                Intrinsics.checkNotNull(entries.nextElement(), "null cannot be cast to non-null type java.util.jar.JarEntry");
                JarEntry entry2 = jarEntry;
                boolean bl3 = false;
                Path target = path = this.destDir.resolve(entry2.getName());
                boolean bl4 = false;
                boolean bl5 = entry2.isDirectory();
                Intrinsics.checkNotNullExpressionValue(target, "target");
                if (!this.preWrite$src_main_kotlin_io_bazel_kotlin_builder_utils_jars_jars(bl5, target)) continue;
                if (entry2.isDirectory()) {
                    Files.createDirectories(target, new FileAttribute[0]);
                    continue;
                }
                Closeable closeable2 = jar.getInputStream(entry2);
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl6 = false;
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(it, target, copyOptionArray);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
            }
            Enumeration<JarEntry> enumeration2 = enumeration;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

