// Copyright 2019 the Resvg Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated. Do not edit it!
// See ./codegen for details.

/// An element ID.
#[allow(missing_docs)]
#[derive(Clone, Copy, PartialEq)]
pub enum EId {
    A,
    Circle,
    ClipPath,
    Defs,
    Ellipse,
    FeBlend,
    FeColorMatrix,
    FeComponentTransfer,
    FeComposite,
    FeConvolveMatrix,
    FeDiffuseLighting,
    FeDisplacementMap,
    FeDistantLight,
    FeDropShadow,
    FeFlood,
    FeFuncA,
    FeFuncB,
    FeFuncG,
    FeFuncR,
    FeGaussianBlur,
    FeImage,
    FeMerge,
    FeMergeNode,
    FeMorphology,
    FeOffset,
    FePointLight,
    FeSpecularLighting,
    FeSpotLight,
    FeTile,
    FeTurbulence,
    Filter,
    G,
    Image,
    Line,
    LinearGradient,
    Marker,
    Mask,
    Path,
    Pattern,
    Polygon,
    Polyline,
    RadialGradient,
    Rect,
    Stop,
    Style,
    Svg,
    Switch,
    Symbol,
    Text,
    TextPath,
    Tref,
    Tspan,
    Use
}

static ELEMENTS: Map<EId> = Map {
    key: 732231254413039614,
    disps: &[
        (0, 12),
        (1, 11),
        (10, 26),
        (2, 42),
        (1, 19),
        (0, 5),
        (1, 13),
        (8, 50),
        (0, 0),
        (1, 0),
        (7, 45),
    ],
    entries: &[
        ("feFlood", EId::FeFlood),
        ("radialGradient", EId::RadialGradient),
        ("feImage", EId::FeImage),
        ("stop", EId::Stop),
        ("fePointLight", EId::FePointLight),
        ("feConvolveMatrix", EId::FeConvolveMatrix),
        ("feComposite", EId::FeComposite),
        ("clipPath", EId::ClipPath),
        ("feMerge", EId::FeMerge),
        ("defs", EId::Defs),
        ("mask", EId::Mask),
        ("svg", EId::Svg),
        ("symbol", EId::Symbol),
        ("linearGradient", EId::LinearGradient),
        ("feSpecularLighting", EId::FeSpecularLighting),
        ("feFuncB", EId::FeFuncB),
        ("filter", EId::Filter),
        ("feFuncG", EId::FeFuncG),
        ("circle", EId::Circle),
        ("g", EId::G),
        ("tref", EId::Tref),
        ("feFuncA", EId::FeFuncA),
        ("image", EId::Image),
        ("text", EId::Text),
        ("line", EId::Line),
        ("pattern", EId::Pattern),
        ("use", EId::Use),
        ("feDropShadow", EId::FeDropShadow),
        ("feSpotLight", EId::FeSpotLight),
        ("marker", EId::Marker),
        ("style", EId::Style),
        ("switch", EId::Switch),
        ("tspan", EId::Tspan),
        ("feColorMatrix", EId::FeColorMatrix),
        ("feOffset", EId::FeOffset),
        ("path", EId::Path),
        ("feGaussianBlur", EId::FeGaussianBlur),
        ("feTile", EId::FeTile),
        ("feTurbulence", EId::FeTurbulence),
        ("feMergeNode", EId::FeMergeNode),
        ("feMorphology", EId::FeMorphology),
        ("a", EId::A),
        ("textPath", EId::TextPath),
        ("ellipse", EId::Ellipse),
        ("feComponentTransfer", EId::FeComponentTransfer),
        ("feDistantLight", EId::FeDistantLight),
        ("polyline", EId::Polyline),
        ("polygon", EId::Polygon),
        ("feBlend", EId::FeBlend),
        ("feDisplacementMap", EId::FeDisplacementMap),
        ("feDiffuseLighting", EId::FeDiffuseLighting),
        ("rect", EId::Rect),
        ("feFuncR", EId::FeFuncR),
    ],
};

impl EId {
    pub(crate) fn from_str(text: &str) -> Option<EId> {
        ELEMENTS.get(text).cloned()
    }

    /// Returns the original string.
    #[inline(never)]
    pub fn to_str(self) -> &'static str {
        ELEMENTS.key(&self)
    }
}

impl std::fmt::Debug for EId {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{}", self.to_str())
    }
}

impl std::fmt::Display for EId {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{:?}", self)
    }
}

/// An attribute ID.
#[allow(missing_docs)]
#[derive(Clone, Copy, PartialEq)]
pub enum AId {
    AlignmentBaseline,
    Amplitude,
    Azimuth,
    BackgroundColor,
    BaseFrequency,
    BaselineShift,
    Bias,
    Class,
    Clip,
    ClipPath,
    ClipRule,
    ClipPathUnits,
    Color,
    ColorInterpolation,
    ColorInterpolationFilters,
    ColorProfile,
    ColorRendering,
    Cx,
    Cy,
    D,
    DiffuseConstant,
    Direction,
    Display,
    Divisor,
    DominantBaseline,
    Dx,
    Dy,
    EdgeMode,
    Elevation,
    EnableBackground,
    Exponent,
    Fill,
    FillOpacity,
    FillRule,
    Filter,
    FilterUnits,
    FloodColor,
    FloodOpacity,
    Font,
    FontFamily,
    FontFeatureSettings,
    FontKerning,
    FontOpticalSizing,
    FontSize,
    FontSizeAdjust,
    FontStretch,
    FontStyle,
    FontSynthesis,
    FontVariant,
    FontVariantCaps,
    FontVariantEastAsian,
    FontVariantLigatures,
    FontVariantNumeric,
    FontVariantPosition,
    FontVariationSettings,
    FontWeight,
    Fr,
    Fx,
    Fy,
    GlyphOrientationHorizontal,
    GlyphOrientationVertical,
    GradientTransform,
    GradientUnits,
    Height,
    Href,
    Id,
    ImageRendering,
    In,
    In2,
    InlineSize,
    Intercept,
    Isolation,
    K1,
    K2,
    K3,
    K4,
    KernelMatrix,
    KernelUnitLength,
    Kerning,
    LengthAdjust,
    LetterSpacing,
    LightingColor,
    LimitingConeAngle,
    LineHeight,
    MarkerEnd,
    MarkerMid,
    MarkerStart,
    MarkerHeight,
    MarkerUnits,
    MarkerWidth,
    Mask,
    MaskBorder,
    MaskBorderMode,
    MaskBorderOutset,
    MaskBorderRepeat,
    MaskBorderSlice,
    MaskBorderSource,
    MaskBorderWidth,
    MaskClip,
    MaskComposite,
    MaskImage,
    MaskMode,
    MaskOrigin,
    MaskPosition,
    MaskSize,
    MaskType,
    MaskContentUnits,
    MaskUnits,
    MixBlendMode,
    Mode,
    NumOctaves,
    Offset,
    Opacity,
    Operator,
    Order,
    Orient,
    Overflow,
    PaintOrder,
    Path,
    PathLength,
    PatternContentUnits,
    PatternTransform,
    PatternUnits,
    Points,
    PointsAtX,
    PointsAtY,
    PointsAtZ,
    PreserveAlpha,
    PreserveAspectRatio,
    PrimitiveUnits,
    R,
    Radius,
    RefX,
    RefY,
    RequiredExtensions,
    RequiredFeatures,
    Result,
    Rotate,
    Rx,
    Ry,
    Scale,
    Seed,
    ShapeImageThreshold,
    ShapeInside,
    ShapeMargin,
    ShapePadding,
    ShapeRendering,
    ShapeSubtract,
    Side,
    Slope,
    Space,
    SpecularConstant,
    SpecularExponent,
    SpreadMethod,
    StartOffset,
    StdDeviation,
    StitchTiles,
    StopColor,
    StopOpacity,
    Stroke,
    StrokeDasharray,
    StrokeDashoffset,
    StrokeLinecap,
    StrokeLinejoin,
    StrokeMiterlimit,
    StrokeOpacity,
    StrokeWidth,
    Style,
    SurfaceScale,
    SystemLanguage,
    TableValues,
    TargetX,
    TargetY,
    TextAlign,
    TextAlignLast,
    TextAnchor,
    TextDecoration,
    TextDecorationColor,
    TextDecorationFill,
    TextDecorationLine,
    TextDecorationStroke,
    TextDecorationStyle,
    TextIndent,
    TextOrientation,
    TextOverflow,
    TextRendering,
    TextUnderlinePosition,
    TextLength,
    Transform,
    TransformBox,
    TransformOrigin,
    Type,
    UnicodeBidi,
    UnicodeRange,
    Values,
    VectorEffect,
    ViewBox,
    Visibility,
    WhiteSpace,
    Width,
    WordSpacing,
    WritingMode,
    X,
    X1,
    X2,
    XChannelSelector,
    Y,
    Y1,
    Y2,
    YChannelSelector,
    Z
}

static ATTRIBUTES: Map<AId> = Map {
    key: 3213172566270843353,
    disps: &[
        (0, 63),
        (4, 146),
        (0, 0),
        (3, 42),
        (2, 197),
        (0, 0),
        (0, 1),
        (0, 0),
        (0, 0),
        (0, 18),
        (0, 11),
        (1, 20),
        (0, 8),
        (17, 110),
        (1, 112),
        (1, 108),
        (5, 94),
        (2, 128),
        (4, 95),
        (0, 63),
        (0, 96),
        (0, 0),
        (1, 110),
        (0, 1),
        (40, 30),
        (17, 157),
        (0, 61),
        (0, 16),
        (7, 16),
        (0, 80),
        (0, 107),
        (6, 111),
        (0, 153),
        (6, 202),
        (18, 86),
        (0, 194),
        (0, 0),
        (0, 7),
        (0, 69),
        (0, 5),
        (0, 19),
        (0, 0),
        (4, 65),
    ],
    entries: &[
        ("alignment-baseline", AId::AlignmentBaseline),
        ("fx", AId::Fx),
        ("targetY", AId::TargetY),
        ("clip-path", AId::ClipPath),
        ("lengthAdjust", AId::LengthAdjust),
        ("mask-size", AId::MaskSize),
        ("unicode-bidi", AId::UnicodeBidi),
        ("z", AId::Z),
        ("font-variant-numeric", AId::FontVariantNumeric),
        ("clip-rule", AId::ClipRule),
        ("font", AId::Font),
        ("gradientUnits", AId::GradientUnits),
        ("style", AId::Style),
        ("font-stretch", AId::FontStretch),
        ("intercept", AId::Intercept),
        ("mask-border-slice", AId::MaskBorderSlice),
        ("y", AId::Y),
        ("xChannelSelector", AId::XChannelSelector),
        ("numOctaves", AId::NumOctaves),
        ("x1", AId::X1),
        ("fill-rule", AId::FillRule),
        ("image-rendering", AId::ImageRendering),
        ("surfaceScale", AId::SurfaceScale),
        ("seed", AId::Seed),
        ("mix-blend-mode", AId::MixBlendMode),
        ("path", AId::Path),
        ("mask-border-repeat", AId::MaskBorderRepeat),
        ("transform", AId::Transform),
        ("stroke", AId::Stroke),
        ("refX", AId::RefX),
        ("text-orientation", AId::TextOrientation),
        ("line-height", AId::LineHeight),
        ("display", AId::Display),
        ("kerning", AId::Kerning),
        ("transform-origin", AId::TransformOrigin),
        ("shape-subtract", AId::ShapeSubtract),
        ("width", AId::Width),
        ("stroke-miterlimit", AId::StrokeMiterlimit),
        ("dy", AId::Dy),
        ("text-decoration-color", AId::TextDecorationColor),
        ("white-space", AId::WhiteSpace),
        ("diffuseConstant", AId::DiffuseConstant),
        ("text-decoration-stroke", AId::TextDecorationStroke),
        ("values", AId::Values),
        ("font-size", AId::FontSize),
        ("shape-image-threshold", AId::ShapeImageThreshold),
        ("href", AId::Href),
        ("cy", AId::Cy),
        ("mask-image", AId::MaskImage),
        ("unicode-range", AId::UnicodeRange),
        ("specularConstant", AId::SpecularConstant),
        ("baseline-shift", AId::BaselineShift),
        ("k3", AId::K3),
        ("text-anchor", AId::TextAnchor),
        ("mask-border-mode", AId::MaskBorderMode),
        ("requiredFeatures", AId::RequiredFeatures),
        ("color-rendering", AId::ColorRendering),
        ("amplitude", AId::Amplitude),
        ("mask-border-width", AId::MaskBorderWidth),
        ("stroke-linecap", AId::StrokeLinecap),
        ("paint-order", AId::PaintOrder),
        ("lighting-color", AId::LightingColor),
        ("dx", AId::Dx),
        ("markerWidth", AId::MarkerWidth),
        ("scale", AId::Scale),
        ("id", AId::Id),
        ("color", AId::Color),
        ("in2", AId::In2),
        ("targetX", AId::TargetX),
        ("direction", AId::Direction),
        ("pointsAtX", AId::PointsAtX),
        ("stitchTiles", AId::StitchTiles),
        ("patternUnits", AId::PatternUnits),
        ("shape-padding", AId::ShapePadding),
        ("k2", AId::K2),
        ("font-optical-sizing", AId::FontOpticalSizing),
        ("k4", AId::K4),
        ("vector-effect", AId::VectorEffect),
        ("mask-composite", AId::MaskComposite),
        ("stroke-width", AId::StrokeWidth),
        ("font-variation-settings", AId::FontVariationSettings),
        ("mask-border-outset", AId::MaskBorderOutset),
        ("in", AId::In),
        ("stroke-linejoin", AId::StrokeLinejoin),
        ("stop-opacity", AId::StopOpacity),
        ("inline-size", AId::InlineSize),
        ("mask-type", AId::MaskType),
        ("filterUnits", AId::FilterUnits),
        ("color-profile", AId::ColorProfile),
        ("space", AId::Space),
        ("text-decoration-fill", AId::TextDecorationFill),
        ("font-kerning", AId::FontKerning),
        ("offset", AId::Offset),
        ("pointsAtZ", AId::PointsAtZ),
        ("text-align", AId::TextAlign),
        ("clip", AId::Clip),
        ("y1", AId::Y1),
        ("mask-origin", AId::MaskOrigin),
        ("mask-mode", AId::MaskMode),
        ("yChannelSelector", AId::YChannelSelector),
        ("font-variant-caps", AId::FontVariantCaps),
        ("marker-mid", AId::MarkerMid),
        ("shape-rendering", AId::ShapeRendering),
        ("text-rendering", AId::TextRendering),
        ("fill-opacity", AId::FillOpacity),
        ("word-spacing", AId::WordSpacing),
        ("fill", AId::Fill),
        ("mask-clip", AId::MaskClip),
        ("font-feature-settings", AId::FontFeatureSettings),
        ("radius", AId::Radius),
        ("kernelMatrix", AId::KernelMatrix),
        ("kernelUnitLength", AId::KernelUnitLength),
        ("mask-border-source", AId::MaskBorderSource),
        ("k1", AId::K1),
        ("mask", AId::Mask),
        ("opacity", AId::Opacity),
        ("markerUnits", AId::MarkerUnits),
        ("visibility", AId::Visibility),
        ("spreadMethod", AId::SpreadMethod),
        ("pointsAtY", AId::PointsAtY),
        ("d", AId::D),
        ("slope", AId::Slope),
        ("side", AId::Side),
        ("tableValues", AId::TableValues),
        ("order", AId::Order),
        ("text-align-last", AId::TextAlignLast),
        ("font-size-adjust", AId::FontSizeAdjust),
        ("rotate", AId::Rotate),
        ("shape-margin", AId::ShapeMargin),
        ("limitingConeAngle", AId::LimitingConeAngle),
        ("font-weight", AId::FontWeight),
        ("text-decoration-line", AId::TextDecorationLine),
        ("stop-color", AId::StopColor),
        ("requiredExtensions", AId::RequiredExtensions),
        ("enable-background", AId::EnableBackground),
        ("systemLanguage", AId::SystemLanguage),
        ("clipPathUnits", AId::ClipPathUnits),
        ("stroke-dashoffset", AId::StrokeDashoffset),
        ("ry", AId::Ry),
        ("overflow", AId::Overflow),
        ("class", AId::Class),
        ("mask-border", AId::MaskBorder),
        ("specularExponent", AId::SpecularExponent),
        ("text-decoration", AId::TextDecoration),
        ("startOffset", AId::StartOffset),
        ("stroke-dasharray", AId::StrokeDasharray),
        ("fr", AId::Fr),
        ("mask-position", AId::MaskPosition),
        ("writing-mode", AId::WritingMode),
        ("font-synthesis", AId::FontSynthesis),
        ("isolation", AId::Isolation),
        ("rx", AId::Rx),
        ("bias", AId::Bias),
        ("markerHeight", AId::MarkerHeight),
        ("edgeMode", AId::EdgeMode),
        ("r", AId::R),
        ("stroke-opacity", AId::StrokeOpacity),
        ("maskContentUnits", AId::MaskContentUnits),
        ("height", AId::Height),
        ("font-variant-position", AId::FontVariantPosition),
        ("operator", AId::Operator),
        ("font-family", AId::FontFamily),
        ("fy", AId::Fy),
        ("dominant-baseline", AId::DominantBaseline),
        ("y2", AId::Y2),
        ("shape-inside", AId::ShapeInside),
        ("letter-spacing", AId::LetterSpacing),
        ("azimuth", AId::Azimuth),
        ("stdDeviation", AId::StdDeviation),
        ("flood-color", AId::FloodColor),
        ("flood-opacity", AId::FloodOpacity),
        ("type", AId::Type),
        ("font-variant-east-asian", AId::FontVariantEastAsian),
        ("points", AId::Points),
        ("refY", AId::RefY),
        ("text-underline-position", AId::TextUnderlinePosition),
        ("patternContentUnits", AId::PatternContentUnits),
        ("baseFrequency", AId::BaseFrequency),
        ("color-interpolation", AId::ColorInterpolation),
        ("font-variant-ligatures", AId::FontVariantLigatures),
        ("font-style", AId::FontStyle),
        ("filter", AId::Filter),
        ("text-decoration-style", AId::TextDecorationStyle),
        ("preserveAlpha", AId::PreserveAlpha),
        ("mode", AId::Mode),
        ("divisor", AId::Divisor),
        ("cx", AId::Cx),
        ("patternTransform", AId::PatternTransform),
        ("background-color", AId::BackgroundColor),
        ("preserveAspectRatio", AId::PreserveAspectRatio),
        ("gradientTransform", AId::GradientTransform),
        ("x2", AId::X2),
        ("pathLength", AId::PathLength),
        ("marker-start", AId::MarkerStart),
        ("glyph-orientation-horizontal", AId::GlyphOrientationHorizontal),
        ("maskUnits", AId::MaskUnits),
        ("textLength", AId::TextLength),
        ("viewBox", AId::ViewBox),
        ("text-overflow", AId::TextOverflow),
        ("glyph-orientation-vertical", AId::GlyphOrientationVertical),
        ("result", AId::Result),
        ("primitiveUnits", AId::PrimitiveUnits),
        ("exponent", AId::Exponent),
        ("x", AId::X),
        ("font-variant", AId::FontVariant),
        ("elevation", AId::Elevation),
        ("color-interpolation-filters", AId::ColorInterpolationFilters),
        ("text-indent", AId::TextIndent),
        ("marker-end", AId::MarkerEnd),
        ("transform-box", AId::TransformBox),
        ("orient", AId::Orient),
    ],
};

impl AId {
    pub(crate) fn from_str(text: &str) -> Option<AId> {
        ATTRIBUTES.get(text).cloned()
    }

    /// Returns the original string.
    #[inline(never)]
    pub fn to_str(self) -> &'static str {
        ATTRIBUTES.key(&self)
    }
}

impl std::fmt::Debug for AId {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{}", self.to_str())
    }
}

impl std::fmt::Display for AId {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{:?}", self)
    }
}

// A stripped down `phf` crate fork.
//
// https://github.com/sfackler/rust-phf

struct Map<V: 'static> {
    pub key: u64,
    pub disps: &'static [(u32, u32)],
    pub entries: &'static [(&'static str, V)],
}

impl<V: PartialEq> Map<V> {
    fn get(&self, key: &str) -> Option<&V> {
        let hash = hash(key, self.key);
        let index = get_index(hash, self.disps, self.entries.len());
        let entry = &self.entries[index as usize];
        let b = entry.0;
        if b == key {
            Some(&entry.1)
        } else {
            None
        }
    }

    fn key(&self, value: &V) -> &'static str {
        self.entries.iter().find(|kv| kv.1 == *value).unwrap().0
    }
}

#[inline]
fn hash(x: &str, key: u64) -> u64 {
    use std::hash::Hasher;

    let mut hasher = siphasher::sip::SipHasher13::new_with_keys(0, key);
    hasher.write(x.as_bytes());
    hasher.finish()
}

#[inline]
fn get_index(hash: u64, disps: &[(u32, u32)], len: usize) -> u32 {
    let (g, f1, f2) = split(hash);
    let (d1, d2) = disps[(g % (disps.len() as u32)) as usize];
    displace(f1, f2, d1, d2) % (len as u32)
}

#[inline]
fn split(hash: u64) -> (u32, u32, u32) {
    const BITS: u32 = 21;
    const MASK: u64 = (1 << BITS) - 1;

    ((hash & MASK) as u32,
     ((hash >> BITS) & MASK) as u32,
     ((hash >> (2 * BITS)) & MASK) as u32)
}

#[inline]
fn displace(f1: u32, f2: u32, d1: u32, d2: u32) -> u32 {
    d2 + f1 * d1 + f2
}
