/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNodeVisitor;

public class SQLTokenEntry
extends TokenPredicateNode
implements TokenEntry {
    private final String string;
    private final SQLTokenType type;
    private final boolean isInverted;

    public SQLTokenEntry(@Nullable String string, @Nullable SQLTokenType type, boolean isInverted) {
        this.string = string;
        this.type = type;
        this.isInverted = isInverted;
    }

    @Nullable
    public String getString() {
        return this.string;
    }

    @Nullable
    public SQLTokenType getTokenType() {
        return this.type;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public boolean matches(@NotNull TokenEntry other) {
        boolean result;
        boolean stringMatches = this.getString() == null || other.getString() == null || this.string.equalsIgnoreCase(other.getString());
        boolean typeMatches = this.getTokenType() == null || other.getTokenType() == null || this.type.equals(other.getTokenType());
        boolean bl = result = stringMatches && typeMatches;
        if (this.isInverted) {
            result = !result;
        }
        return result;
    }

    public boolean equals(@NotNull TokenEntry other) {
        boolean stringEquals = this.getString() == null && other.getString() == null || this.getString() != null && other.getString() != null && this.getString().equals(other.getString());
        boolean typeEquals = this.getTokenType() == null && other.getTokenType() == null || this.getTokenType() != null && other.getTokenType() != null && this.getTokenType().equals(other.getTokenType());
        boolean invertedEquals = this.isInverted() == other.isInverted();
        return stringEquals && typeEquals && invertedEquals;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof TokenEntry && this.equals((TokenEntry)o);
    }

    public int hashCode() {
        return Objects.hash(this.getString(), this.getTokenType(), this.isInverted());
    }

    @NotNull
    public StringBuilder format(@NotNull StringBuilder sb) {
        if (this.isInverted) {
            sb.append("!");
        }
        return sb.append("<").append(this.type != null ? this.type.name() : "?").append(">").append((String)(this.string != null ? "'" + this.string + "'" : "any"));
    }

    @Override
    @NotNull
    protected <T, R> R applyImpl(@NotNull TokenPredicateNodeVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTokenEntry(this, arg);
    }
}

