/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model.data;

import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandlerConfigurable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class SQLiteValueHandler
extends JDBCAbstractValueHandler
implements DBDValueHandlerConfigurable {
    private static final Log log = Log.getLog(SQLiteValueHandler.class);
    private final DBDFormatSettings formatSettings;
    private final DBSTypedObject type;
    private DBDDataFormatter numberFormatter;
    private DBDDataFormatter timestampFormatter;

    public SQLiteValueHandler(DBSTypedObject type, DBDFormatSettings formatSettings) {
        this.formatSettings = formatSettings;
        this.type = type;
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object object = resultSet.getObject(index);
        return this.getValueFromObject(session, type, object, false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        statement.setObject(paramIndex, value);
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof String && (type.getTypeID() == 7 || type.getTypeID() == 8)) {
            switch (((String)object).toLowerCase(Locale.ROOT)) {
                case "inf": 
                case "infinity": 
                case "+inf": 
                case "+infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "-inf": 
                case "-infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
                case "nan": {
                    return Double.NaN;
                }
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Number) {
            if (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)value), (boolean)this.formatSettings.isUseScientificNumericFormat());
            }
            if (this.numberFormatter != null) return this.numberFormatter.formatValue(value);
            try {
                this.numberFormatter = this.formatSettings.getDataFormatterProfile().createFormatter("number", column);
                return this.numberFormatter.formatValue(value);
            }
            catch (Exception e) {
                log.error((Object)"Can't create numberFormatter for number value handler", (Throwable)e);
                this.numberFormatter = DefaultDataFormatter.INSTANCE;
            }
            return this.numberFormatter.formatValue(value);
        }
        if (value instanceof Date) {
            if (this.timestampFormatter != null) return this.timestampFormatter.formatValue(value);
            try {
                this.timestampFormatter = this.formatSettings.getDataFormatterProfile().createFormatter("timestamp", this.type);
                return this.timestampFormatter.formatValue(value);
            }
            catch (Exception e) {
                log.error((Object)"Can't create timestampFormatter for timestamp value handler", (Throwable)e);
                this.timestampFormatter = DefaultDataFormatter.INSTANCE;
            }
            return this.timestampFormatter.formatValue(value);
        }
        if (value instanceof String) {
            String string = (String)value;
            if (column.getDataKind() == DBPDataKind.DATETIME) {
                if (format != DBDDisplayFormat.NATIVE || string.startsWith("'") || string.endsWith("'")) return super.getValueDisplayString(column, value, format);
                return "'" + String.valueOf(value) + "'";
            }
        }
        if (!(value instanceof byte[]) || column.getDataKind() != DBPDataKind.STRING) return super.getValueDisplayString(column, value, format);
        return new String((byte[])value);
    }

    public void refreshValueHandlerConfiguration(DBSTypedObject type) {
        this.numberFormatter = null;
        this.timestampFormatter = null;
    }
}

