/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2IndexColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2IndexType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2UniqueRule;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class DB2IndexConfigurator
implements DBEObjectConfigurator<DB2Index> {
    private static final String CONS_IX_NAME = "%s_%s_IDX";
    private static final List<DBSIndexType> IX_TYPES = new ArrayList<DBSIndexType>(DB2IndexType.values().length);

    public DB2Index configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, @NotNull DB2Index index, @NotNull Map<String, Object> options) {
        return (DB2Index)UITask.run(() -> {
            DB2TableBase table = (DB2TableBase)container;
            EditIndexPage editPage = new EditIndexPage(DB2Messages.edit_db2_index_manager_dialog_title, (DBSTableIndex)index, IX_TYPES);
            if (!editPage.edit()) {
                return null;
            }
            String tableName = CommonUtils.escapeIdentifier((String)table.getName());
            String colName = CommonUtils.escapeIdentifier((String)((DBSEntityAttribute)editPage.getSelectedAttributes().iterator().next()).getName());
            String indexBaseName = String.format(CONS_IX_NAME, tableName, colName);
            String indexName = DBObjectNameCaseTransformer.transformName((DBPDataSource)table.getDataSource(), (String)indexBaseName);
            index.setName(indexName);
            index.setIndexType(editPage.getIndexType());
            index.setUniqueRule(editPage.isUnique() ? DB2UniqueRule.U : DB2UniqueRule.D);
            int colIndex = 1;
            for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                index.addColumn(new DB2IndexColumn(index, (DB2TableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty((DBSAttributeBase)tableColumn, "desc"))));
            }
            return index;
        });
    }

    static {
        for (DB2IndexType db2IndexType : DB2IndexType.values()) {
            if (!db2IndexType.isValidForCreation().booleanValue()) continue;
            IX_TYPES.add(db2IndexType.getDBSIndexType());
        }
    }
}

