/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.util.StringUtil;

public abstract class DefinitionsEndpointContextMatcher
implements EndpointContextMatcher {
    private final String sendTag;
    private final String recvTag;
    private final Definitions<Definition<?>> definitions;
    private final boolean compareHostname;

    public DefinitionsEndpointContextMatcher(Definitions<Definition<?>> definitions) {
        this(definitions, false);
    }

    public DefinitionsEndpointContextMatcher(Definitions<Definition<?>> definitions, boolean compareHostname) {
        if (definitions == null) {
            throw new NullPointerException("Definitions must not be null!");
        }
        this.sendTag = definitions.getName() + " sending";
        this.recvTag = definitions.getName() + " receiving";
        this.definitions = definitions;
        this.compareHostname = compareHostname;
    }

    @Override
    public String getName() {
        return this.definitions.getName();
    }

    @Override
    public Object getEndpointIdentity(EndpointContext context) {
        InetSocketAddress address = context.getPeerAddress();
        if (address.isUnresolved()) {
            throw new IllegalArgumentException(StringUtil.toDisplayString(address) + " must be resolved!");
        }
        return address;
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        boolean result = this.compareHostname ? DefinitionsEndpointContextMatcher.isSameVirtualHost(requestContext, responseContext) : true;
        return result && this.internalMatch(this.recvTag, requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectionContext) {
        if (null == connectionContext) {
            return !messageContext.hasCriticalEntries();
        }
        boolean result = this.compareHostname ? DefinitionsEndpointContextMatcher.isSameVirtualHost(messageContext, connectionContext) : true;
        return result && this.internalMatch(this.sendTag, messageContext, connectionContext);
    }

    private final boolean internalMatch(String tag, EndpointContext requestedContext, EndpointContext availableContext) {
        if (!requestedContext.hasCriticalEntries()) {
            return true;
        }
        return EndpointContextUtil.match(tag, this.definitions, requestedContext, availableContext);
    }

    @Override
    public String toRelevantState(EndpointContext context) {
        if (context == null) {
            return "n.a.";
        }
        return context.toString();
    }

    public static final boolean isSameVirtualHost(EndpointContext firstContext, EndpointContext secondContext) {
        String otherVirtualHost;
        if (firstContext == null) {
            throw new NullPointerException("first context must not be null");
        }
        if (secondContext == null) {
            return true;
        }
        String firstVirtualHost = firstContext.getVirtualHost();
        return firstVirtualHost == (otherVirtualHost = secondContext.getVirtualHost()) || firstVirtualHost != null && firstVirtualHost.equals(otherVirtualHost);
    }
}

