# Welcome to chumsky

Welcome to the guide for chumsky, a parser combinator library for Rust that lets you write high-performance, expressive
parsers with ease.

Here you will find useful resources for learning about both chumsky and parsing more broadly, along with many examples.
There is also a tutorial that will guide you through the implementation of a simple programming language (complete with
a simple interpreter) using chumsky for both lexing and parsing.

This guide is split up into several sections.

## Contents

- [Getting Started](./_00_getting_started/index.html): Getting started with chumsky, including creating and using parsers
- [Key Concepts](./_01_key_concepts/index.html): Some brief theory and an introduction to chumsky's core API features
- [Meet The Parsers](./_02_meet_the_parsers/index.html): An overview of the primitives and combinators provided by chumsky
- [Error and recovery](./_03_error_and_recovery/index.html): Using chumsky to generate and recover from errors
- [Recursion](./_04_recursion/index.html): How chumsky handles recursion and self-reference
- [Debugging](./_05_debugging/index.html): Tips and tricks for debugging chumsky parsers
- [Technical Notes](./_06_technical_notes/index.html): Information about chumsky for advanced users

- [Foo: A Tutorial](./_07_tutorial/index.html): Example implementation of a simple programming language using chumsky
