/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/whispersystems/signalservice/api/crypto/IncrementalMacAdditionalValidationsInputStream;", "Ljava/io/FilterInputStream;", "wrapped", "Ljava/io/InputStream;", "fileLength", "", "mac", "Ljavax/crypto/Mac;", "<init>", "(Ljava/io/InputStream;JLjavax/crypto/Mac;)V", "macLength", "", "macBuffer", "", "validated", "", "bytesRemaining", "macBufferPosition", "read", "buffer", "offset", "length", "close", "", "validate", "signal-service-java"})
public final class IncrementalMacAdditionalValidationsInputStream
extends FilterInputStream {
    @NotNull
    private final Mac mac;
    private final int macLength;
    @NotNull
    private final byte[] macBuffer;
    private boolean validated;
    private int bytesRemaining;
    private int macBufferPosition;

    public IncrementalMacAdditionalValidationsInputStream(@NotNull InputStream wrapped, long fileLength, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(wrapped);
        this.mac = mac;
        this.macLength = this.mac.getMacLength();
        this.macBuffer = new byte[this.macLength];
        this.bytesRemaining = (int)fileLength;
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int bytesRead = super.read(buffer, offset, length);
        if (bytesRead == -1) {
            this.validate();
            return bytesRead;
        }
        this.bytesRemaining -= bytesRead;
        if (this.bytesRemaining < this.macLength) {
            int bytesOfNonMacRead;
            int bytesOfMacRead = this.macLength - this.bytesRemaining;
            int newBytesOfMacRead = bytesOfMacRead - this.macBufferPosition;
            if (newBytesOfMacRead > 0) {
                System.arraycopy(buffer, offset + bytesRead - newBytesOfMacRead, this.macBuffer, this.macBufferPosition, newBytesOfMacRead);
                this.macBufferPosition += newBytesOfMacRead;
            }
            if ((bytesOfNonMacRead = Math.max(0, bytesRead - bytesOfMacRead)) > 0) {
                this.mac.update(buffer, offset, bytesOfNonMacRead);
            }
        } else {
            this.mac.update(buffer, offset, bytesRead);
        }
        if (this.bytesRemaining == 0) {
            this.validate();
        }
        return bytesRead;
    }

    @Override
    public void close() {
        if (this.bytesRemaining > this.macLength) {
            super.close();
            return;
        }
        if (this.bytesRemaining > 0) {
            Util.readFullyAsBytes(this);
        }
        super.close();
    }

    private final void validate() {
        byte[] theirMac;
        if (this.validated) {
            return;
        }
        this.validated = true;
        byte[] ourMac = this.mac.doFinal();
        if (!MessageDigest.isEqual(ourMac, theirMac = this.macBuffer)) {
            throw new InvalidMessageException("MAC doesn't match!");
        }
    }
}

