// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

package servicepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The size of the Cloud Composer environment.
type EnvironmentConfig_EnvironmentSize int32

const (
	// The size of the environment is unspecified.
	EnvironmentConfig_ENVIRONMENT_SIZE_UNSPECIFIED EnvironmentConfig_EnvironmentSize = 0
	// The environment size is small.
	EnvironmentConfig_ENVIRONMENT_SIZE_SMALL EnvironmentConfig_EnvironmentSize = 1
	// The environment size is medium.
	EnvironmentConfig_ENVIRONMENT_SIZE_MEDIUM EnvironmentConfig_EnvironmentSize = 2
	// The environment size is large.
	EnvironmentConfig_ENVIRONMENT_SIZE_LARGE EnvironmentConfig_EnvironmentSize = 3
)

// Enum value maps for EnvironmentConfig_EnvironmentSize.
var (
	EnvironmentConfig_EnvironmentSize_name = map[int32]string{
		0: "ENVIRONMENT_SIZE_UNSPECIFIED",
		1: "ENVIRONMENT_SIZE_SMALL",
		2: "ENVIRONMENT_SIZE_MEDIUM",
		3: "ENVIRONMENT_SIZE_LARGE",
	}
	EnvironmentConfig_EnvironmentSize_value = map[string]int32{
		"ENVIRONMENT_SIZE_UNSPECIFIED": 0,
		"ENVIRONMENT_SIZE_SMALL":       1,
		"ENVIRONMENT_SIZE_MEDIUM":      2,
		"ENVIRONMENT_SIZE_LARGE":       3,
	}
)

func (x EnvironmentConfig_EnvironmentSize) Enum() *EnvironmentConfig_EnvironmentSize {
	p := new(EnvironmentConfig_EnvironmentSize)
	*p = x
	return p
}

func (x EnvironmentConfig_EnvironmentSize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvironmentConfig_EnvironmentSize) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[0].Descriptor()
}

func (EnvironmentConfig_EnvironmentSize) Type() protoreflect.EnumType {
	return &file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[0]
}

func (x EnvironmentConfig_EnvironmentSize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvironmentConfig_EnvironmentSize.Descriptor instead.
func (EnvironmentConfig_EnvironmentSize) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{20, 0}
}

// Resilience mode of the Cloud Composer Environment.
type EnvironmentConfig_ResilienceMode int32

const (
	// Default mode doesn't change environment parameters.
	EnvironmentConfig_RESILIENCE_MODE_UNSPECIFIED EnvironmentConfig_ResilienceMode = 0
	// Enabled High Resilience mode, including Cloud SQL HA.
	EnvironmentConfig_HIGH_RESILIENCE EnvironmentConfig_ResilienceMode = 1
)

// Enum value maps for EnvironmentConfig_ResilienceMode.
var (
	EnvironmentConfig_ResilienceMode_name = map[int32]string{
		0: "RESILIENCE_MODE_UNSPECIFIED",
		1: "HIGH_RESILIENCE",
	}
	EnvironmentConfig_ResilienceMode_value = map[string]int32{
		"RESILIENCE_MODE_UNSPECIFIED": 0,
		"HIGH_RESILIENCE":             1,
	}
)

func (x EnvironmentConfig_ResilienceMode) Enum() *EnvironmentConfig_ResilienceMode {
	p := new(EnvironmentConfig_ResilienceMode)
	*p = x
	return p
}

func (x EnvironmentConfig_ResilienceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnvironmentConfig_ResilienceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[1].Descriptor()
}

func (EnvironmentConfig_ResilienceMode) Type() protoreflect.EnumType {
	return &file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[1]
}

func (x EnvironmentConfig_ResilienceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnvironmentConfig_ResilienceMode.Descriptor instead.
func (EnvironmentConfig_ResilienceMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{20, 1}
}

// Represents connection type between Composer environment in Customer
// Project and the corresponding Tenant project, from a predefined list
// of available connection modes.
type NetworkingConfig_ConnectionType int32

const (
	// No specific connection type was requested, so the environment uses
	// the default value corresponding to the rest of its configuration.
	NetworkingConfig_CONNECTION_TYPE_UNSPECIFIED NetworkingConfig_ConnectionType = 0
	// Requests the use of VPC peerings for connecting the Customer and Tenant
	// projects.
	NetworkingConfig_VPC_PEERING NetworkingConfig_ConnectionType = 1
	// Requests the use of Private Service Connect for connecting the Customer
	// and Tenant projects.
	NetworkingConfig_PRIVATE_SERVICE_CONNECT NetworkingConfig_ConnectionType = 2
)

// Enum value maps for NetworkingConfig_ConnectionType.
var (
	NetworkingConfig_ConnectionType_name = map[int32]string{
		0: "CONNECTION_TYPE_UNSPECIFIED",
		1: "VPC_PEERING",
		2: "PRIVATE_SERVICE_CONNECT",
	}
	NetworkingConfig_ConnectionType_value = map[string]int32{
		"CONNECTION_TYPE_UNSPECIFIED": 0,
		"VPC_PEERING":                 1,
		"PRIVATE_SERVICE_CONNECT":     2,
	}
)

func (x NetworkingConfig_ConnectionType) Enum() *NetworkingConfig_ConnectionType {
	p := new(NetworkingConfig_ConnectionType)
	*p = x
	return p
}

func (x NetworkingConfig_ConnectionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkingConfig_ConnectionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[2].Descriptor()
}

func (NetworkingConfig_ConnectionType) Type() protoreflect.EnumType {
	return &file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[2]
}

func (x NetworkingConfig_ConnectionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkingConfig_ConnectionType.Descriptor instead.
func (NetworkingConfig_ConnectionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{30, 0}
}

// State of the environment.
type Environment_State int32

const (
	// The state of the environment is unknown.
	Environment_STATE_UNSPECIFIED Environment_State = 0
	// The environment is in the process of being created.
	Environment_CREATING Environment_State = 1
	// The environment is currently running and healthy. It is ready for use.
	Environment_RUNNING Environment_State = 2
	// The environment is being updated. It remains usable but cannot receive
	// additional update requests or be deleted at this time.
	Environment_UPDATING Environment_State = 3
	// The environment is undergoing deletion. It cannot be used.
	Environment_DELETING Environment_State = 4
	// The environment has encountered an error and cannot be used.
	Environment_ERROR Environment_State = 5
)

// Enum value maps for Environment_State.
var (
	Environment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "RUNNING",
		3: "UPDATING",
		4: "DELETING",
		5: "ERROR",
	}
	Environment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"RUNNING":           2,
		"UPDATING":          3,
		"DELETING":          4,
		"ERROR":             5,
	}
)

func (x Environment_State) Enum() *Environment_State {
	p := new(Environment_State)
	*p = x
	return p
}

func (x Environment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Environment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[3].Descriptor()
}

func (Environment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[3]
}

func (x Environment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Environment_State.Descriptor instead.
func (Environment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{36, 0}
}

// Whether there were python modules conflict during image build.
type CheckUpgradeResponse_ConflictResult int32

const (
	// It is unknown whether build had conflicts or not.
	CheckUpgradeResponse_CONFLICT_RESULT_UNSPECIFIED CheckUpgradeResponse_ConflictResult = 0
	// There were python packages conflicts.
	CheckUpgradeResponse_CONFLICT CheckUpgradeResponse_ConflictResult = 1
	// There were no python packages conflicts.
	CheckUpgradeResponse_NO_CONFLICT CheckUpgradeResponse_ConflictResult = 2
)

// Enum value maps for CheckUpgradeResponse_ConflictResult.
var (
	CheckUpgradeResponse_ConflictResult_name = map[int32]string{
		0: "CONFLICT_RESULT_UNSPECIFIED",
		1: "CONFLICT",
		2: "NO_CONFLICT",
	}
	CheckUpgradeResponse_ConflictResult_value = map[string]int32{
		"CONFLICT_RESULT_UNSPECIFIED": 0,
		"CONFLICT":                    1,
		"NO_CONFLICT":                 2,
	}
)

func (x CheckUpgradeResponse_ConflictResult) Enum() *CheckUpgradeResponse_ConflictResult {
	p := new(CheckUpgradeResponse_ConflictResult)
	*p = x
	return p
}

func (x CheckUpgradeResponse_ConflictResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CheckUpgradeResponse_ConflictResult) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[4].Descriptor()
}

func (CheckUpgradeResponse_ConflictResult) Type() protoreflect.EnumType {
	return &file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes[4]
}

func (x CheckUpgradeResponse_ConflictResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CheckUpgradeResponse_ConflictResult.Descriptor instead.
func (CheckUpgradeResponse_ConflictResult) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{37, 0}
}

// Create a new environment.
type CreateEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent must be of the form
	// "projects/{projectId}/locations/{locationId}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The environment to create.
	Environment *Environment `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *CreateEnvironmentRequest) Reset() {
	*x = CreateEnvironmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEnvironmentRequest) ProtoMessage() {}

func (x *CreateEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*CreateEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{0}
}

func (x *CreateEnvironmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEnvironmentRequest) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

// Get an environment.
type GetEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the environment to get, in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEnvironmentRequest) Reset() {
	*x = GetEnvironmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnvironmentRequest) ProtoMessage() {}

func (x *GetEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*GetEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{1}
}

func (x *GetEnvironmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List environments in a project and location.
type ListEnvironmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List environments in the given project and location, in the form:
	// "projects/{projectId}/locations/{locationId}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of environments to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEnvironmentsRequest) Reset() {
	*x = ListEnvironmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEnvironmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEnvironmentsRequest) ProtoMessage() {}

func (x *ListEnvironmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEnvironmentsRequest.ProtoReflect.Descriptor instead.
func (*ListEnvironmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{2}
}

func (x *ListEnvironmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEnvironmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEnvironmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The environments in a project and location.
type ListEnvironmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of environments returned by a ListEnvironmentsRequest.
	Environments []*Environment `protobuf:"bytes,1,rep,name=environments,proto3" json:"environments,omitempty"`
	// The page token used to query for the next page if one exists.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEnvironmentsResponse) Reset() {
	*x = ListEnvironmentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEnvironmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEnvironmentsResponse) ProtoMessage() {}

func (x *ListEnvironmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEnvironmentsResponse.ProtoReflect.Descriptor instead.
func (*ListEnvironmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{3}
}

func (x *ListEnvironmentsResponse) GetEnvironments() []*Environment {
	if x != nil {
		return x.Environments
	}
	return nil
}

func (x *ListEnvironmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Delete an environment.
type DeleteEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The environment to delete, in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEnvironmentRequest) Reset() {
	*x = DeleteEnvironmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEnvironmentRequest) ProtoMessage() {}

func (x *DeleteEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteEnvironmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Update an environment.
type UpdateEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The relative resource name of the environment to update, in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// A patch environment. Fields specified by the `updateMask` will be copied
	// from the patch environment into the environment under update.
	Environment *Environment `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// Required. A comma-separated list of paths, relative to `Environment`, of
	// fields to update.
	// For example, to set the version of scikit-learn to install in the
	// environment to 0.19.0 and to remove an existing installation of
	// numpy, the `updateMask` parameter would include the following two
	// `paths` values: "config.softwareConfig.pypiPackages.scikit-learn" and
	// "config.softwareConfig.pypiPackages.numpy". The included patch
	// environment would specify the scikit-learn version as follows:
	//
	//	{
	//	  "config":{
	//	    "softwareConfig":{
	//	      "pypiPackages":{
	//	        "scikit-learn":"==0.19.0"
	//	      }
	//	    }
	//	  }
	//	}
	//
	// Note that in the above example, any existing PyPI packages
	// other than scikit-learn and numpy will be unaffected.
	//
	// Only one update type may be included in a single request's `updateMask`.
	// For example, one cannot update both the PyPI packages and
	// labels in the same request. However, it is possible to update multiple
	// members of a map field simultaneously in the same request. For example,
	// to set the labels "label1" and "label2" while clearing "label3" (assuming
	// it already exists), one can
	// provide the paths "labels.label1", "labels.label2", and "labels.label3"
	// and populate the patch environment as follows:
	//
	//	{
	//	  "labels":{
	//	    "label1":"new-label1-value"
	//	    "label2":"new-label2-value"
	//	  }
	//	}
	//
	// Note that in the above example, any existing labels that are not
	// included in the `updateMask` will be unaffected.
	//
	// It is also possible to replace an entire map field by providing the
	// map field's path in the `updateMask`. The new value of the field will
	// be that which is provided in the patch environment. For example, to
	// delete all pre-existing user-specified PyPI packages and
	// install botocore at version 1.7.14, the `updateMask` would contain
	// the path "config.softwareConfig.pypiPackages", and
	// the patch environment would be the following:
	//
	//	{
	//	  "config":{
	//	    "softwareConfig":{
	//	      "pypiPackages":{
	//	        "botocore":"==1.7.14"
	//	      }
	//	    }
	//	  }
	//	}
	//
	// **Note:** Only the following fields can be updated:
	//
	// * `config.softwareConfig.pypiPackages`
	//   - Replace all custom custom PyPI packages. If a replacement
	//     package map is not included in `environment`, all custom
	//     PyPI packages are cleared. It is an error to provide both
	//     this mask and a mask specifying an individual package.
	//
	// * `config.softwareConfig.pypiPackages.`packagename
	//   - Update the custom PyPI package *packagename*,
	//     preserving other packages. To delete the package, include it in
	//     `updateMask`, and omit the mapping for it in
	//     `environment.config.softwareConfig.pypiPackages`. It is an error
	//     to provide both a mask of this form and the
	//     `config.softwareConfig.pypiPackages` mask.
	//
	// * `labels`
	//   - Replace all environment labels. If a replacement labels map is not
	//     included in `environment`, all labels are cleared. It is an error to
	//     provide both this mask and a mask specifying one or more individual
	//     labels.
	//
	// * `labels.`labelName
	//   - Set the label named *labelName*, while preserving other
	//     labels. To delete the label, include it in `updateMask` and omit its
	//     mapping in `environment.labels`. It is an error to provide both a
	//     mask of this form and the `labels` mask.
	//
	// * `config.nodeCount`
	//   - Horizontally scale the number of nodes in the environment. An integer
	//     greater than or equal to 3 must be provided in the `config.nodeCount`
	//     field. Supported for Cloud Composer environments in versions
	//     composer-1.*.*-airflow-*.*.*.
	//
	// * `config.webServerNetworkAccessControl`
	//   - Replace the environment's current `WebServerNetworkAccessControl`.
	//
	// * `config.softwareConfig.airflowConfigOverrides`
	//   - Replace all Apache Airflow config overrides. If a replacement config
	//     overrides map is not included in `environment`, all config overrides
	//     are cleared.
	//     It is an error to provide both this mask and a mask specifying one or
	//     more individual config overrides.
	//
	// * `config.softwareConfig.airflowConfigOverrides.`section-name
	//   - Override the Apache Airflow config property *name* in the
	//     section named *section*, preserving other properties. To
	//     delete the property override, include it in `updateMask` and omit its
	//     mapping in
	//     `environment.config.softwareConfig.airflowConfigOverrides`.
	//     It is an error to provide both a mask of this form and the
	//     `config.softwareConfig.airflowConfigOverrides` mask.
	//
	// * `config.softwareConfig.envVariables`
	//   - Replace all environment variables. If a replacement environment
	//     variable map is not included in `environment`, all custom environment
	//     variables are cleared.
	//
	// * `config.softwareConfig.schedulerCount`
	//   - Horizontally scale the number of schedulers in Airflow. A positive
	//     integer not greater than the number of nodes must be provided in the
	//     `config.softwareConfig.schedulerCount` field. Supported for Cloud
	//     Composer environments in versions composer-1.*.*-airflow-2.*.*.
	//
	// * `config.databaseConfig.machineType`
	//   - Cloud SQL machine type used by Airflow database.
	//     It has to be one of: db-n1-standard-2, db-n1-standard-4,
	//     db-n1-standard-8 or db-n1-standard-16. Supported for Cloud Composer
	//     environments in versions composer-1.*.*-airflow-*.*.*.
	//
	// * `config.webServerConfig.machineType`
	//   - Machine type on which Airflow web server is running.
	//     It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4
	//     or composer-n1-webserver-8. Supported for Cloud Composer environments
	//     in versions composer-1.*.*-airflow-*.*.*.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEnvironmentRequest) Reset() {
	*x = UpdateEnvironmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEnvironmentRequest) ProtoMessage() {}

func (x *UpdateEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*UpdateEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateEnvironmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateEnvironmentRequest) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *UpdateEnvironmentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Execute Airflow Command request.
type ExecuteAirflowCommandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the environment in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// Airflow command.
	Command string `protobuf:"bytes,2,opt,name=command,proto3" json:"command,omitempty"`
	// Airflow subcommand.
	Subcommand string `protobuf:"bytes,3,opt,name=subcommand,proto3" json:"subcommand,omitempty"`
	// Parameters for the Airflow command/subcommand as an array of arguments.
	// It may contain positional arguments like `["my-dag-id"]`, key-value
	// parameters like `["--foo=bar"]` or `["--foo","bar"]`,
	// or other flags like `["-f"]`.
	Parameters []string `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *ExecuteAirflowCommandRequest) Reset() {
	*x = ExecuteAirflowCommandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteAirflowCommandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteAirflowCommandRequest) ProtoMessage() {}

func (x *ExecuteAirflowCommandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteAirflowCommandRequest.ProtoReflect.Descriptor instead.
func (*ExecuteAirflowCommandRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{6}
}

func (x *ExecuteAirflowCommandRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *ExecuteAirflowCommandRequest) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *ExecuteAirflowCommandRequest) GetSubcommand() string {
	if x != nil {
		return x.Subcommand
	}
	return ""
}

func (x *ExecuteAirflowCommandRequest) GetParameters() []string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response to ExecuteAirflowCommandRequest.
type ExecuteAirflowCommandResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID of the command execution for polling.
	ExecutionId string `protobuf:"bytes,1,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// The name of the pod where the command is executed.
	Pod string `protobuf:"bytes,2,opt,name=pod,proto3" json:"pod,omitempty"`
	// The namespace of the pod where the command is executed.
	PodNamespace string `protobuf:"bytes,3,opt,name=pod_namespace,json=podNamespace,proto3" json:"pod_namespace,omitempty"`
	// Error message. Empty if there was no error.
	Error string `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ExecuteAirflowCommandResponse) Reset() {
	*x = ExecuteAirflowCommandResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteAirflowCommandResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteAirflowCommandResponse) ProtoMessage() {}

func (x *ExecuteAirflowCommandResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteAirflowCommandResponse.ProtoReflect.Descriptor instead.
func (*ExecuteAirflowCommandResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{7}
}

func (x *ExecuteAirflowCommandResponse) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

func (x *ExecuteAirflowCommandResponse) GetPod() string {
	if x != nil {
		return x.Pod
	}
	return ""
}

func (x *ExecuteAirflowCommandResponse) GetPodNamespace() string {
	if x != nil {
		return x.PodNamespace
	}
	return ""
}

func (x *ExecuteAirflowCommandResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Stop Airflow Command request.
type StopAirflowCommandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the environment in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}".
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// The unique ID of the command execution.
	ExecutionId string `protobuf:"bytes,2,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// The name of the pod where the command is executed.
	Pod string `protobuf:"bytes,3,opt,name=pod,proto3" json:"pod,omitempty"`
	// The namespace of the pod where the command is executed.
	PodNamespace string `protobuf:"bytes,4,opt,name=pod_namespace,json=podNamespace,proto3" json:"pod_namespace,omitempty"`
	// If true, the execution is terminated forcefully (SIGKILL). If false, the
	// execution is stopped gracefully, giving it time for cleanup.
	Force bool `protobuf:"varint,5,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *StopAirflowCommandRequest) Reset() {
	*x = StopAirflowCommandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopAirflowCommandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopAirflowCommandRequest) ProtoMessage() {}

func (x *StopAirflowCommandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopAirflowCommandRequest.ProtoReflect.Descriptor instead.
func (*StopAirflowCommandRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{8}
}

func (x *StopAirflowCommandRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *StopAirflowCommandRequest) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

func (x *StopAirflowCommandRequest) GetPod() string {
	if x != nil {
		return x.Pod
	}
	return ""
}

func (x *StopAirflowCommandRequest) GetPodNamespace() string {
	if x != nil {
		return x.PodNamespace
	}
	return ""
}

func (x *StopAirflowCommandRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Response to StopAirflowCommandRequest.
type StopAirflowCommandResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the execution is still running.
	IsDone bool `protobuf:"varint,1,opt,name=is_done,json=isDone,proto3" json:"is_done,omitempty"`
	// Output message from stopping execution request.
	Output []string `protobuf:"bytes,2,rep,name=output,proto3" json:"output,omitempty"`
}

func (x *StopAirflowCommandResponse) Reset() {
	*x = StopAirflowCommandResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopAirflowCommandResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopAirflowCommandResponse) ProtoMessage() {}

func (x *StopAirflowCommandResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopAirflowCommandResponse.ProtoReflect.Descriptor instead.
func (*StopAirflowCommandResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{9}
}

func (x *StopAirflowCommandResponse) GetIsDone() bool {
	if x != nil {
		return x.IsDone
	}
	return false
}

func (x *StopAirflowCommandResponse) GetOutput() []string {
	if x != nil {
		return x.Output
	}
	return nil
}

// Poll Airflow Command request.
type PollAirflowCommandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the environment in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// The unique ID of the command execution.
	ExecutionId string `protobuf:"bytes,2,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// The name of the pod where the command is executed.
	Pod string `protobuf:"bytes,3,opt,name=pod,proto3" json:"pod,omitempty"`
	// The namespace of the pod where the command is executed.
	PodNamespace string `protobuf:"bytes,4,opt,name=pod_namespace,json=podNamespace,proto3" json:"pod_namespace,omitempty"`
	// Line number from which new logs should be fetched.
	NextLineNumber int32 `protobuf:"varint,5,opt,name=next_line_number,json=nextLineNumber,proto3" json:"next_line_number,omitempty"`
}

func (x *PollAirflowCommandRequest) Reset() {
	*x = PollAirflowCommandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollAirflowCommandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollAirflowCommandRequest) ProtoMessage() {}

func (x *PollAirflowCommandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollAirflowCommandRequest.ProtoReflect.Descriptor instead.
func (*PollAirflowCommandRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{10}
}

func (x *PollAirflowCommandRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *PollAirflowCommandRequest) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

func (x *PollAirflowCommandRequest) GetPod() string {
	if x != nil {
		return x.Pod
	}
	return ""
}

func (x *PollAirflowCommandRequest) GetPodNamespace() string {
	if x != nil {
		return x.PodNamespace
	}
	return ""
}

func (x *PollAirflowCommandRequest) GetNextLineNumber() int32 {
	if x != nil {
		return x.NextLineNumber
	}
	return 0
}

// Response to PollAirflowCommandRequest.
type PollAirflowCommandResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output from the command execution. It may not contain the full output
	// and the caller may need to poll for more lines.
	Output []*PollAirflowCommandResponse_Line `protobuf:"bytes,1,rep,name=output,proto3" json:"output,omitempty"`
	// Whether the command execution has finished and there is no more output.
	OutputEnd bool `protobuf:"varint,2,opt,name=output_end,json=outputEnd,proto3" json:"output_end,omitempty"`
	// The result exit status of the command.
	ExitInfo *PollAirflowCommandResponse_ExitInfo `protobuf:"bytes,3,opt,name=exit_info,json=exitInfo,proto3" json:"exit_info,omitempty"`
}

func (x *PollAirflowCommandResponse) Reset() {
	*x = PollAirflowCommandResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollAirflowCommandResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollAirflowCommandResponse) ProtoMessage() {}

func (x *PollAirflowCommandResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollAirflowCommandResponse.ProtoReflect.Descriptor instead.
func (*PollAirflowCommandResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{11}
}

func (x *PollAirflowCommandResponse) GetOutput() []*PollAirflowCommandResponse_Line {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *PollAirflowCommandResponse) GetOutputEnd() bool {
	if x != nil {
		return x.OutputEnd
	}
	return false
}

func (x *PollAirflowCommandResponse) GetExitInfo() *PollAirflowCommandResponse_ExitInfo {
	if x != nil {
		return x.ExitInfo
	}
	return nil
}

// Request to create a snapshot of a Cloud Composer environment.
type SaveSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the source environment in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// Location in a Cloud Storage where the snapshot is going to be stored, e.g.:
	// "gs://my-bucket/snapshots".
	SnapshotLocation string `protobuf:"bytes,2,opt,name=snapshot_location,json=snapshotLocation,proto3" json:"snapshot_location,omitempty"`
}

func (x *SaveSnapshotRequest) Reset() {
	*x = SaveSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SaveSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SaveSnapshotRequest) ProtoMessage() {}

func (x *SaveSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SaveSnapshotRequest.ProtoReflect.Descriptor instead.
func (*SaveSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{12}
}

func (x *SaveSnapshotRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *SaveSnapshotRequest) GetSnapshotLocation() string {
	if x != nil {
		return x.SnapshotLocation
	}
	return ""
}

// Response to SaveSnapshotRequest.
type SaveSnapshotResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully-resolved Cloud Storage path of the created snapshot,
	// e.g.:
	// "gs://my-bucket/snapshots/project_location_environment_timestamp".
	// This field is populated only if the snapshot creation was successful.
	SnapshotPath string `protobuf:"bytes,1,opt,name=snapshot_path,json=snapshotPath,proto3" json:"snapshot_path,omitempty"`
}

func (x *SaveSnapshotResponse) Reset() {
	*x = SaveSnapshotResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SaveSnapshotResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SaveSnapshotResponse) ProtoMessage() {}

func (x *SaveSnapshotResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SaveSnapshotResponse.ProtoReflect.Descriptor instead.
func (*SaveSnapshotResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{13}
}

func (x *SaveSnapshotResponse) GetSnapshotPath() string {
	if x != nil {
		return x.SnapshotPath
	}
	return ""
}

// Request to load a snapshot into a Cloud Composer environment.
type LoadSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the target environment in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// A Cloud Storage path to a snapshot to load, e.g.:
	// "gs://my-bucket/snapshots/project_location_environment_timestamp".
	SnapshotPath string `protobuf:"bytes,2,opt,name=snapshot_path,json=snapshotPath,proto3" json:"snapshot_path,omitempty"`
	// Whether or not to skip installing Pypi packages when loading the
	// environment's state.
	SkipPypiPackagesInstallation bool `protobuf:"varint,3,opt,name=skip_pypi_packages_installation,json=skipPypiPackagesInstallation,proto3" json:"skip_pypi_packages_installation,omitempty"`
	// Whether or not to skip setting environment variables when loading the
	// environment's state.
	SkipEnvironmentVariablesSetting bool `protobuf:"varint,4,opt,name=skip_environment_variables_setting,json=skipEnvironmentVariablesSetting,proto3" json:"skip_environment_variables_setting,omitempty"`
	// Whether or not to skip setting Airflow overrides when loading the
	// environment's state.
	SkipAirflowOverridesSetting bool `protobuf:"varint,5,opt,name=skip_airflow_overrides_setting,json=skipAirflowOverridesSetting,proto3" json:"skip_airflow_overrides_setting,omitempty"`
	// Whether or not to skip copying Cloud Storage data when loading the
	// environment's state.
	SkipGcsDataCopying bool `protobuf:"varint,6,opt,name=skip_gcs_data_copying,json=skipGcsDataCopying,proto3" json:"skip_gcs_data_copying,omitempty"`
}

func (x *LoadSnapshotRequest) Reset() {
	*x = LoadSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadSnapshotRequest) ProtoMessage() {}

func (x *LoadSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadSnapshotRequest.ProtoReflect.Descriptor instead.
func (*LoadSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{14}
}

func (x *LoadSnapshotRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *LoadSnapshotRequest) GetSnapshotPath() string {
	if x != nil {
		return x.SnapshotPath
	}
	return ""
}

func (x *LoadSnapshotRequest) GetSkipPypiPackagesInstallation() bool {
	if x != nil {
		return x.SkipPypiPackagesInstallation
	}
	return false
}

func (x *LoadSnapshotRequest) GetSkipEnvironmentVariablesSetting() bool {
	if x != nil {
		return x.SkipEnvironmentVariablesSetting
	}
	return false
}

func (x *LoadSnapshotRequest) GetSkipAirflowOverridesSetting() bool {
	if x != nil {
		return x.SkipAirflowOverridesSetting
	}
	return false
}

func (x *LoadSnapshotRequest) GetSkipGcsDataCopying() bool {
	if x != nil {
		return x.SkipGcsDataCopying
	}
	return false
}

// Response to LoadSnapshotRequest.
type LoadSnapshotResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LoadSnapshotResponse) Reset() {
	*x = LoadSnapshotResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadSnapshotResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadSnapshotResponse) ProtoMessage() {}

func (x *LoadSnapshotResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadSnapshotResponse.ProtoReflect.Descriptor instead.
func (*LoadSnapshotResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{15}
}

// Request to trigger database failover (only for highly resilient
// environments).
type DatabaseFailoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target environment:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *DatabaseFailoverRequest) Reset() {
	*x = DatabaseFailoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseFailoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseFailoverRequest) ProtoMessage() {}

func (x *DatabaseFailoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseFailoverRequest.ProtoReflect.Descriptor instead.
func (*DatabaseFailoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{16}
}

func (x *DatabaseFailoverRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

// Response for DatabaseFailoverRequest.
type DatabaseFailoverResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DatabaseFailoverResponse) Reset() {
	*x = DatabaseFailoverResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseFailoverResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseFailoverResponse) ProtoMessage() {}

func (x *DatabaseFailoverResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseFailoverResponse.ProtoReflect.Descriptor instead.
func (*DatabaseFailoverResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{17}
}

// Request to fetch properties of environment's database.
type FetchDatabasePropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the environment, in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *FetchDatabasePropertiesRequest) Reset() {
	*x = FetchDatabasePropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDatabasePropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDatabasePropertiesRequest) ProtoMessage() {}

func (x *FetchDatabasePropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDatabasePropertiesRequest.ProtoReflect.Descriptor instead.
func (*FetchDatabasePropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{18}
}

func (x *FetchDatabasePropertiesRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

// Response for FetchDatabasePropertiesRequest.
type FetchDatabasePropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Compute Engine zone that the instance is currently serving from.
	PrimaryGceZone string `protobuf:"bytes,1,opt,name=primary_gce_zone,json=primaryGceZone,proto3" json:"primary_gce_zone,omitempty"`
	// The Compute Engine zone that the failover instance is currently serving
	// from for a regional Cloud SQL instance.
	SecondaryGceZone string `protobuf:"bytes,2,opt,name=secondary_gce_zone,json=secondaryGceZone,proto3" json:"secondary_gce_zone,omitempty"`
	// The availability status of the failover replica. A false status indicates
	// that the failover replica is out of sync. The primary instance can only
	// fail over to the failover replica when the status is true.
	IsFailoverReplicaAvailable bool `protobuf:"varint,3,opt,name=is_failover_replica_available,json=isFailoverReplicaAvailable,proto3" json:"is_failover_replica_available,omitempty"`
}

func (x *FetchDatabasePropertiesResponse) Reset() {
	*x = FetchDatabasePropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDatabasePropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDatabasePropertiesResponse) ProtoMessage() {}

func (x *FetchDatabasePropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDatabasePropertiesResponse.ProtoReflect.Descriptor instead.
func (*FetchDatabasePropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{19}
}

func (x *FetchDatabasePropertiesResponse) GetPrimaryGceZone() string {
	if x != nil {
		return x.PrimaryGceZone
	}
	return ""
}

func (x *FetchDatabasePropertiesResponse) GetSecondaryGceZone() string {
	if x != nil {
		return x.SecondaryGceZone
	}
	return ""
}

func (x *FetchDatabasePropertiesResponse) GetIsFailoverReplicaAvailable() bool {
	if x != nil {
		return x.IsFailoverReplicaAvailable
	}
	return false
}

// Configuration information for an environment.
type EnvironmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Kubernetes Engine cluster used to run this environment.
	GkeCluster string `protobuf:"bytes,1,opt,name=gke_cluster,json=gkeCluster,proto3" json:"gke_cluster,omitempty"`
	// Output only. The Cloud Storage prefix of the DAGs for this environment.
	// Although Cloud Storage objects reside in a flat namespace, a hierarchical
	// file tree can be simulated using "/"-delimited object name prefixes. DAG
	// objects for this environment reside in a simulated directory with the given
	// prefix.
	DagGcsPrefix string `protobuf:"bytes,2,opt,name=dag_gcs_prefix,json=dagGcsPrefix,proto3" json:"dag_gcs_prefix,omitempty"`
	// The number of nodes in the Kubernetes Engine cluster that will be
	// used to run this environment.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	NodeCount int32 `protobuf:"varint,3,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The configuration settings for software inside the environment.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,4,opt,name=software_config,json=softwareConfig,proto3" json:"software_config,omitempty"`
	// The configuration used for the Kubernetes Engine cluster.
	NodeConfig *NodeConfig `protobuf:"bytes,5,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// The configuration used for the Private IP Cloud Composer environment.
	PrivateEnvironmentConfig *PrivateEnvironmentConfig `protobuf:"bytes,7,opt,name=private_environment_config,json=privateEnvironmentConfig,proto3" json:"private_environment_config,omitempty"`
	// Optional. The network-level access control policy for the Airflow web
	// server. If unspecified, no network-level access restrictions will be
	// applied.
	WebServerNetworkAccessControl *WebServerNetworkAccessControl `protobuf:"bytes,8,opt,name=web_server_network_access_control,json=webServerNetworkAccessControl,proto3" json:"web_server_network_access_control,omitempty"`
	// Optional. The configuration settings for Cloud SQL instance used internally
	// by Apache Airflow software.
	DatabaseConfig *DatabaseConfig `protobuf:"bytes,9,opt,name=database_config,json=databaseConfig,proto3" json:"database_config,omitempty"`
	// Optional. The configuration settings for the Airflow web server App Engine
	// instance.
	WebServerConfig *WebServerConfig `protobuf:"bytes,10,opt,name=web_server_config,json=webServerConfig,proto3" json:"web_server_config,omitempty"`
	// Optional. The encryption options for the Cloud Composer environment
	// and its dependencies. Cannot be updated.
	EncryptionConfig *EncryptionConfig `protobuf:"bytes,11,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Optional. The maintenance window is the period when Cloud Composer
	// components may undergo maintenance. It is defined so that maintenance is
	// not executed during peak hours or critical time periods.
	//
	// The system will not be under maintenance for every occurrence of this
	// window, but when maintenance is planned, it will be scheduled
	// during the window.
	//
	// The maintenance window period must encompass at least 12 hours per week.
	// This may be split into multiple chunks, each with a size of
	// at least 4 hours.
	//
	// If this value is omitted, the default value for maintenance window will be
	// applied. The default value is Saturday and Sunday 00-06 GMT.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,12,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Optional. The workloads configuration settings for the GKE cluster
	// associated with the Cloud Composer environment. The GKE cluster runs
	// Airflow scheduler, web server and workers workloads.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	WorkloadsConfig *WorkloadsConfig `protobuf:"bytes,15,opt,name=workloads_config,json=workloadsConfig,proto3" json:"workloads_config,omitempty"`
	// Optional. The size of the Cloud Composer environment.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	EnvironmentSize EnvironmentConfig_EnvironmentSize `protobuf:"varint,16,opt,name=environment_size,json=environmentSize,proto3,enum=google.cloud.orchestration.airflow.service.v1.EnvironmentConfig_EnvironmentSize" json:"environment_size,omitempty"`
	// Output only. The URI of the Apache Airflow Web UI hosted within this
	// environment (see [Airflow web
	// interface](/composer/docs/how-to/accessing/airflow-web-interface)).
	AirflowUri string `protobuf:"bytes,6,opt,name=airflow_uri,json=airflowUri,proto3" json:"airflow_uri,omitempty"`
	// Output only. The 'bring your own identity' variant of the URI of the Apache
	// Airflow Web UI hosted within this environment, to be accessed with external
	// identities using workforce identity federation (see [Access environments
	// with workforce identity
	// federation](/composer/docs/composer-2/access-environments-with-workforce-identity-federation)).
	AirflowByoidUri string `protobuf:"bytes,20,opt,name=airflow_byoid_uri,json=airflowByoidUri,proto3" json:"airflow_byoid_uri,omitempty"`
	// Optional. The configuration options for GKE cluster master authorized
	// networks. By default master authorized networks feature is:
	// - in case of private environment: enabled with no external networks
	// allowlisted.
	// - in case of public environment: disabled.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,17,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
	// Optional. The Recovery settings configuration of an environment.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	RecoveryConfig *RecoveryConfig `protobuf:"bytes,18,opt,name=recovery_config,json=recoveryConfig,proto3" json:"recovery_config,omitempty"`
	// Optional. Resilience mode of the Cloud Composer Environment.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-2.2.0-airflow-*.*.* and newer.
	ResilienceMode EnvironmentConfig_ResilienceMode `protobuf:"varint,19,opt,name=resilience_mode,json=resilienceMode,proto3,enum=google.cloud.orchestration.airflow.service.v1.EnvironmentConfig_ResilienceMode" json:"resilience_mode,omitempty"`
}

func (x *EnvironmentConfig) Reset() {
	*x = EnvironmentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvironmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentConfig) ProtoMessage() {}

func (x *EnvironmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentConfig.ProtoReflect.Descriptor instead.
func (*EnvironmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{20}
}

func (x *EnvironmentConfig) GetGkeCluster() string {
	if x != nil {
		return x.GkeCluster
	}
	return ""
}

func (x *EnvironmentConfig) GetDagGcsPrefix() string {
	if x != nil {
		return x.DagGcsPrefix
	}
	return ""
}

func (x *EnvironmentConfig) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *EnvironmentConfig) GetSoftwareConfig() *SoftwareConfig {
	if x != nil {
		return x.SoftwareConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetNodeConfig() *NodeConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetPrivateEnvironmentConfig() *PrivateEnvironmentConfig {
	if x != nil {
		return x.PrivateEnvironmentConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetWebServerNetworkAccessControl() *WebServerNetworkAccessControl {
	if x != nil {
		return x.WebServerNetworkAccessControl
	}
	return nil
}

func (x *EnvironmentConfig) GetDatabaseConfig() *DatabaseConfig {
	if x != nil {
		return x.DatabaseConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetWebServerConfig() *WebServerConfig {
	if x != nil {
		return x.WebServerConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetEncryptionConfig() *EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *EnvironmentConfig) GetWorkloadsConfig() *WorkloadsConfig {
	if x != nil {
		return x.WorkloadsConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetEnvironmentSize() EnvironmentConfig_EnvironmentSize {
	if x != nil {
		return x.EnvironmentSize
	}
	return EnvironmentConfig_ENVIRONMENT_SIZE_UNSPECIFIED
}

func (x *EnvironmentConfig) GetAirflowUri() string {
	if x != nil {
		return x.AirflowUri
	}
	return ""
}

func (x *EnvironmentConfig) GetAirflowByoidUri() string {
	if x != nil {
		return x.AirflowByoidUri
	}
	return ""
}

func (x *EnvironmentConfig) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.MasterAuthorizedNetworksConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetRecoveryConfig() *RecoveryConfig {
	if x != nil {
		return x.RecoveryConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetResilienceMode() EnvironmentConfig_ResilienceMode {
	if x != nil {
		return x.ResilienceMode
	}
	return EnvironmentConfig_RESILIENCE_MODE_UNSPECIFIED
}

// Network-level access control policy for the Airflow web server.
type WebServerNetworkAccessControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of allowed IP ranges with descriptions.
	AllowedIpRanges []*WebServerNetworkAccessControl_AllowedIpRange `protobuf:"bytes,1,rep,name=allowed_ip_ranges,json=allowedIpRanges,proto3" json:"allowed_ip_ranges,omitempty"`
}

func (x *WebServerNetworkAccessControl) Reset() {
	*x = WebServerNetworkAccessControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebServerNetworkAccessControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebServerNetworkAccessControl) ProtoMessage() {}

func (x *WebServerNetworkAccessControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebServerNetworkAccessControl.ProtoReflect.Descriptor instead.
func (*WebServerNetworkAccessControl) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{21}
}

func (x *WebServerNetworkAccessControl) GetAllowedIpRanges() []*WebServerNetworkAccessControl_AllowedIpRange {
	if x != nil {
		return x.AllowedIpRanges
	}
	return nil
}

// The configuration of Cloud SQL instance that is used by the Apache Airflow
// software.
type DatabaseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Cloud SQL machine type used by Airflow database.
	// It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8
	// or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
	// Supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
}

func (x *DatabaseConfig) Reset() {
	*x = DatabaseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseConfig) ProtoMessage() {}

func (x *DatabaseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseConfig.ProtoReflect.Descriptor instead.
func (*DatabaseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{22}
}

func (x *DatabaseConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

// The configuration settings for the Airflow web server App Engine instance.
// Supported for Cloud Composer environments in versions
// composer-1.*.*-airflow-*.*.*
type WebServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Machine type on which Airflow web server is running.
	// It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or
	// composer-n1-webserver-8.
	// If not specified, composer-n1-webserver-2 will be used.
	// Value custom is returned only in response, if Airflow web server parameters
	// were manually changed to a non-standard values.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
}

func (x *WebServerConfig) Reset() {
	*x = WebServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebServerConfig) ProtoMessage() {}

func (x *WebServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebServerConfig.ProtoReflect.Descriptor instead.
func (*WebServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{23}
}

func (x *WebServerConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

// The encryption options for the Cloud Composer environment
// and its dependencies.Supported for Cloud Composer environments in versions
// composer-1.*.*-airflow-*.*.*.
type EncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Customer-managed Encryption Key available through Google's Key
	// Management Service. Cannot be updated. If not specified, Google-managed key
	// will be used.
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *EncryptionConfig) Reset() {
	*x = EncryptionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionConfig) ProtoMessage() {}

func (x *EncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionConfig.ProtoReflect.Descriptor instead.
func (*EncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{24}
}

func (x *EncryptionConfig) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// The configuration settings for Cloud Composer maintenance window.
// The following example:
//
// ```
//
//	{
//	  "startTime":"2019-08-01T01:00:00Z"
//	  "endTime":"2019-08-01T07:00:00Z"
//	  "recurrence":"FREQ=WEEKLY;BYDAY=TU,WE"
//	}
//
// ```
//
// would define a maintenance window between 01 and 07 hours UTC during
// each Tuesday and Wednesday.
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Start time of the first recurrence of the maintenance window.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Required. Maintenance window end time. It is used only to calculate the
	// duration of the maintenance window. The value for end-time must be in the
	// future, relative to `start_time`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Required. Maintenance window recurrence. Format is a subset of
	// [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed
	// values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...`
	// Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
	Recurrence string `protobuf:"bytes,3,opt,name=recurrence,proto3" json:"recurrence,omitempty"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{25}
}

func (x *MaintenanceWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *MaintenanceWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *MaintenanceWindow) GetRecurrence() string {
	if x != nil {
		return x.Recurrence
	}
	return ""
}

// Specifies the selection and configuration of software inside the environment.
type SoftwareConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of the software running in the environment.
	// This encapsulates both the version of Cloud Composer functionality and the
	// version of Apache Airflow. It must match the regular expression
	// `composer-([0-9]+(\.[0-9]+\.[0-9]+(-preview\.[0-9]+)?)?|latest)-airflow-([0-9]+(\.[0-9]+(\.[0-9]+)?)?)`.
	// When used as input, the server also checks if the provided version is
	// supported and denies the request for an unsupported version.
	//
	// The Cloud Composer portion of the image version is a full
	// [semantic version](https://semver.org), or an alias in the form of major
	// version number or `latest`. When an alias is provided, the server replaces
	// it with the current Cloud Composer version that satisfies the alias.
	//
	// The Apache Airflow portion of the image version is a full semantic version
	// that points to one of the supported Apache Airflow versions, or an alias in
	// the form of only major or major.minor versions specified. When an alias is
	// provided, the server replaces it with the latest Apache Airflow version
	// that satisfies the alias and is supported in the given Cloud Composer
	// version.
	//
	// In all cases, the resolved image version is stored in the same field.
	//
	// See also [version
	// list](/composer/docs/concepts/versioning/composer-versions) and [versioning
	// overview](/composer/docs/concepts/versioning/composer-versioning-overview).
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Optional. Apache Airflow configuration properties to override.
	//
	// Property keys contain the section and property names, separated by a
	// hyphen, for example "core-dags_are_paused_at_creation". Section names must
	// not contain hyphens ("-"), opening square brackets ("["),  or closing
	// square brackets ("]"). The property name must not be empty and must not
	// contain an equals sign ("=") or semicolon (";"). Section and property names
	// must not contain a period ("."). Apache Airflow configuration property
	// names must be written in
	// [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can
	// contain any character, and can be written in any lower/upper case format.
	//
	// Certain Apache Airflow configuration property values are
	// [blocked](/composer/docs/concepts/airflow-configurations),
	// and cannot be overridden.
	AirflowConfigOverrides map[string]string `protobuf:"bytes,2,rep,name=airflow_config_overrides,json=airflowConfigOverrides,proto3" json:"airflow_config_overrides,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Custom Python Package Index (PyPI) packages to be installed in
	// the environment.
	//
	// Keys refer to the lowercase package name such as "numpy"
	// and values are the lowercase extras and version specifier such as
	// "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a
	// package without pinning it to a version specifier, use the empty string as
	// the value.
	PypiPackages map[string]string `protobuf:"bytes,3,rep,name=pypi_packages,json=pypiPackages,proto3" json:"pypi_packages,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Additional environment variables to provide to the Apache Airflow
	// scheduler, worker, and webserver processes.
	//
	// Environment variable names must match the regular expression
	// `[a-zA-Z_][a-zA-Z0-9_]*`. They cannot specify Apache Airflow
	// software configuration overrides (they cannot match the regular expression
	// `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the
	// following reserved names:
	//
	// * `AIRFLOW_HOME`
	// * `C_FORCE_ROOT`
	// * `CONTAINER_NAME`
	// * `DAGS_FOLDER`
	// * `GCP_PROJECT`
	// * `GCS_BUCKET`
	// * `GKE_CLUSTER_NAME`
	// * `SQL_DATABASE`
	// * `SQL_INSTANCE`
	// * `SQL_PASSWORD`
	// * `SQL_PROJECT`
	// * `SQL_REGION`
	// * `SQL_USER`
	EnvVariables map[string]string `protobuf:"bytes,4,rep,name=env_variables,json=envVariables,proto3" json:"env_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The major version of Python used to run the Apache Airflow
	// scheduler, worker, and webserver processes.
	//
	// Can be set to '2' or '3'. If not specified, the default is '3'. Cannot be
	// updated.
	//
	// This field is only supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
	// Python major version 3.
	PythonVersion string `protobuf:"bytes,6,opt,name=python_version,json=pythonVersion,proto3" json:"python_version,omitempty"`
	// Optional. The number of schedulers for Airflow.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-2.*.*.
	SchedulerCount int32 `protobuf:"varint,7,opt,name=scheduler_count,json=schedulerCount,proto3" json:"scheduler_count,omitempty"`
}

func (x *SoftwareConfig) Reset() {
	*x = SoftwareConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoftwareConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoftwareConfig) ProtoMessage() {}

func (x *SoftwareConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoftwareConfig.ProtoReflect.Descriptor instead.
func (*SoftwareConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{26}
}

func (x *SoftwareConfig) GetImageVersion() string {
	if x != nil {
		return x.ImageVersion
	}
	return ""
}

func (x *SoftwareConfig) GetAirflowConfigOverrides() map[string]string {
	if x != nil {
		return x.AirflowConfigOverrides
	}
	return nil
}

func (x *SoftwareConfig) GetPypiPackages() map[string]string {
	if x != nil {
		return x.PypiPackages
	}
	return nil
}

func (x *SoftwareConfig) GetEnvVariables() map[string]string {
	if x != nil {
		return x.EnvVariables
	}
	return nil
}

func (x *SoftwareConfig) GetPythonVersion() string {
	if x != nil {
		return x.PythonVersion
	}
	return ""
}

func (x *SoftwareConfig) GetSchedulerCount() int32 {
	if x != nil {
		return x.SchedulerCount
	}
	return 0
}

// Configuration for controlling how IPs are allocated in the
// GKE cluster running the Apache Airflow software.
type IPAllocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether or not to enable Alias IPs in the GKE cluster.
	// If `true`, a VPC-native cluster is created.
	//
	// This field is only supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*. Environments in newer versions always use
	// VPC-native GKE clusters.
	UseIpAliases bool `protobuf:"varint,1,opt,name=use_ip_aliases,json=useIpAliases,proto3" json:"use_ip_aliases,omitempty"`
	// Configuration of allocating IP addresses for pods in the GKE cluster.
	//
	// Types that are assignable to ClusterIpAllocation:
	//
	//	*IPAllocationPolicy_ClusterSecondaryRangeName
	//	*IPAllocationPolicy_ClusterIpv4CidrBlock
	ClusterIpAllocation isIPAllocationPolicy_ClusterIpAllocation `protobuf_oneof:"cluster_ip_allocation"`
	// Configuration of allocating IP addresses for services in the GKE cluster.
	//
	// Types that are assignable to ServicesIpAllocation:
	//
	//	*IPAllocationPolicy_ServicesSecondaryRangeName
	//	*IPAllocationPolicy_ServicesIpv4CidrBlock
	ServicesIpAllocation isIPAllocationPolicy_ServicesIpAllocation `protobuf_oneof:"services_ip_allocation"`
}

func (x *IPAllocationPolicy) Reset() {
	*x = IPAllocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IPAllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPAllocationPolicy) ProtoMessage() {}

func (x *IPAllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPAllocationPolicy.ProtoReflect.Descriptor instead.
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{27}
}

func (x *IPAllocationPolicy) GetUseIpAliases() bool {
	if x != nil {
		return x.UseIpAliases
	}
	return false
}

func (m *IPAllocationPolicy) GetClusterIpAllocation() isIPAllocationPolicy_ClusterIpAllocation {
	if m != nil {
		return m.ClusterIpAllocation
	}
	return nil
}

func (x *IPAllocationPolicy) GetClusterSecondaryRangeName() string {
	if x, ok := x.GetClusterIpAllocation().(*IPAllocationPolicy_ClusterSecondaryRangeName); ok {
		return x.ClusterSecondaryRangeName
	}
	return ""
}

func (x *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if x, ok := x.GetClusterIpAllocation().(*IPAllocationPolicy_ClusterIpv4CidrBlock); ok {
		return x.ClusterIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetServicesIpAllocation() isIPAllocationPolicy_ServicesIpAllocation {
	if m != nil {
		return m.ServicesIpAllocation
	}
	return nil
}

func (x *IPAllocationPolicy) GetServicesSecondaryRangeName() string {
	if x, ok := x.GetServicesIpAllocation().(*IPAllocationPolicy_ServicesSecondaryRangeName); ok {
		return x.ServicesSecondaryRangeName
	}
	return ""
}

func (x *IPAllocationPolicy) GetServicesIpv4CidrBlock() string {
	if x, ok := x.GetServicesIpAllocation().(*IPAllocationPolicy_ServicesIpv4CidrBlock); ok {
		return x.ServicesIpv4CidrBlock
	}
	return ""
}

type isIPAllocationPolicy_ClusterIpAllocation interface {
	isIPAllocationPolicy_ClusterIpAllocation()
}

type IPAllocationPolicy_ClusterSecondaryRangeName struct {
	// Optional. The name of the GKE cluster's secondary range used to allocate
	// IP addresses to pods.
	//
	// For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
	// this field is applicable only when `use_ip_aliases` is true.
	ClusterSecondaryRangeName string `protobuf:"bytes,2,opt,name=cluster_secondary_range_name,json=clusterSecondaryRangeName,proto3,oneof"`
}

type IPAllocationPolicy_ClusterIpv4CidrBlock struct {
	// Optional. The IP address range used to allocate IP addresses to pods in
	// the GKE cluster.
	//
	// For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
	// this field is applicable only when `use_ip_aliases` is true.
	//
	// Set to blank to have GKE choose a range with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ClusterIpv4CidrBlock string `protobuf:"bytes,4,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock,proto3,oneof"`
}

func (*IPAllocationPolicy_ClusterSecondaryRangeName) isIPAllocationPolicy_ClusterIpAllocation() {}

func (*IPAllocationPolicy_ClusterIpv4CidrBlock) isIPAllocationPolicy_ClusterIpAllocation() {}

type isIPAllocationPolicy_ServicesIpAllocation interface {
	isIPAllocationPolicy_ServicesIpAllocation()
}

type IPAllocationPolicy_ServicesSecondaryRangeName struct {
	// Optional. The name of the services' secondary range used to allocate
	// IP addresses to the GKE cluster.
	//
	// For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
	// this field is applicable only when `use_ip_aliases` is true.
	ServicesSecondaryRangeName string `protobuf:"bytes,3,opt,name=services_secondary_range_name,json=servicesSecondaryRangeName,proto3,oneof"`
}

type IPAllocationPolicy_ServicesIpv4CidrBlock struct {
	// Optional. The IP address range of the services IP addresses in this
	// GKE cluster.
	//
	// For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*,
	// this field is applicable only when `use_ip_aliases` is true.
	//
	// Set to blank to have GKE choose a range with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ServicesIpv4CidrBlock string `protobuf:"bytes,5,opt,name=services_ipv4_cidr_block,json=servicesIpv4CidrBlock,proto3,oneof"`
}

func (*IPAllocationPolicy_ServicesSecondaryRangeName) isIPAllocationPolicy_ServicesIpAllocation() {}

func (*IPAllocationPolicy_ServicesIpv4CidrBlock) isIPAllocationPolicy_ServicesIpAllocation() {}

// The configuration information for the Kubernetes Engine nodes running
// the Apache Airflow software.
type NodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which
	// to deploy the VMs used to run the Apache Airflow software, specified as a
	// [relative resource
	// name](/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/zones/{zoneId}".
	//
	// This `location` must belong to the enclosing environment's project and
	// location. If both this field and `nodeConfig.machineType` are specified,
	// `nodeConfig.machineType` must belong to this `location`; if both are
	// unspecified, the service will pick a zone in the Compute Engine region
	// corresponding to the Cloud Composer location, and propagate that choice to
	// both fields. If only one field (`location` or `nodeConfig.machineType`) is
	// specified, the location information from the specified field will be
	// propagated to the unspecified field.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Optional. The Compute Engine
	// [machine type](/compute/docs/machine-types) used for cluster instances,
	// specified as a
	// [relative resource
	// name](/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}".
	//
	// The `machineType` must belong to the enclosing environment's project and
	// location. If both this field and `nodeConfig.location` are specified,
	// this `machineType` must belong to the `nodeConfig.location`; if both are
	// unspecified, the service will pick a zone in the Compute Engine region
	// corresponding to the Cloud Composer location, and propagate that choice to
	// both fields. If exactly one of this field and `nodeConfig.location` is
	// specified, the location information from the specified field will be
	// propagated to the unspecified field.
	//
	// The `machineTypeId` must not be a [shared-core machine
	// type](/compute/docs/machine-types#sharedcore).
	//
	// If this field is unspecified, the `machineTypeId` defaults
	// to "n1-standard-1".
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	MachineType string `protobuf:"bytes,2,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Optional. The Compute Engine network to be used for machine
	// communications, specified as a
	// [relative resource
	// name](/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/global/networks/{networkId}".
	//
	// If unspecified, the "default" network ID in the environment's project is
	// used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets)
	// is provided, `nodeConfig.subnetwork` must also be provided. For
	// [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see
	// `nodeConfig.subnetwork`.
	Network string `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The Compute Engine subnetwork to be used for machine
	// communications, specified as a
	// [relative resource
	// name](/apis/design/resource_names#relative_resource_name). For example:
	// "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}"
	//
	// If a subnetwork is provided, `nodeConfig.network` must also be provided,
	// and the subnetwork must belong to the enclosing environment's project and
	// location.
	Subnetwork string `protobuf:"bytes,4,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Optional. The disk size in GB used for node VMs. Minimum size is 30GB.
	// If unspecified, defaults to 100GB. Cannot be updated.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	DiskSizeGb int32 `protobuf:"varint,5,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Optional. The set of Google API scopes to be made available on all
	// node VMs. If `oauth_scopes` is empty, defaults to
	// ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	OauthScopes []string `protobuf:"bytes,6,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// Optional. The Google Cloud Platform Service Account to be used by the node
	// VMs. If a service account is not specified, the "default" Compute Engine
	// service account is used. Cannot be updated.
	ServiceAccount string `protobuf:"bytes,7,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. The list of instance tags applied to all node VMs. Tags are used
	// to identify valid sources or targets for network firewalls. Each tag within
	// the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Cannot be updated.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Optional. The configuration for controlling how IPs are allocated in the
	// GKE cluster.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,9,opt,name=ip_allocation_policy,json=ipAllocationPolicy,proto3" json:"ip_allocation_policy,omitempty"`
	// Optional. Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines
	// nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for
	// all destination addresses, except between pods traffic.
	//
	// See:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
	EnableIpMasqAgent bool `protobuf:"varint,11,opt,name=enable_ip_masq_agent,json=enableIpMasqAgent,proto3" json:"enable_ip_masq_agent,omitempty"`
}

func (x *NodeConfig) Reset() {
	*x = NodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeConfig) ProtoMessage() {}

func (x *NodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeConfig.ProtoReflect.Descriptor instead.
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{28}
}

func (x *NodeConfig) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *NodeConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *NodeConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NodeConfig) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *NodeConfig) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *NodeConfig) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *NodeConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *NodeConfig) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *NodeConfig) GetIpAllocationPolicy() *IPAllocationPolicy {
	if x != nil {
		return x.IpAllocationPolicy
	}
	return nil
}

func (x *NodeConfig) GetEnableIpMasqAgent() bool {
	if x != nil {
		return x.EnableIpMasqAgent
	}
	return false
}

// Configuration options for the private GKE cluster in a Cloud Composer
// environment.
type PrivateClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If `true`, access to the public endpoint of the GKE cluster is
	// denied.
	EnablePrivateEndpoint bool `protobuf:"varint,1,opt,name=enable_private_endpoint,json=enablePrivateEndpoint,proto3" json:"enable_private_endpoint,omitempty"`
	// Optional. The CIDR block from which IPv4 range for GKE master will be
	// reserved. If left blank, the default value of '172.16.0.0/23' is used.
	MasterIpv4CidrBlock string `protobuf:"bytes,2,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Output only. The IP range in CIDR notation to use for the hosted master
	// network. This range is used for assigning internal IP addresses to the GKE
	// cluster master or set of masters and to the internal load balancer virtual
	// IP. This range must not overlap with any other ranges in use within the
	// cluster's network.
	MasterIpv4ReservedRange string `protobuf:"bytes,3,opt,name=master_ipv4_reserved_range,json=masterIpv4ReservedRange,proto3" json:"master_ipv4_reserved_range,omitempty"`
}

func (x *PrivateClusterConfig) Reset() {
	*x = PrivateClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateClusterConfig) ProtoMessage() {}

func (x *PrivateClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateClusterConfig.ProtoReflect.Descriptor instead.
func (*PrivateClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{29}
}

func (x *PrivateClusterConfig) GetEnablePrivateEndpoint() bool {
	if x != nil {
		return x.EnablePrivateEndpoint
	}
	return false
}

func (x *PrivateClusterConfig) GetMasterIpv4CidrBlock() string {
	if x != nil {
		return x.MasterIpv4CidrBlock
	}
	return ""
}

func (x *PrivateClusterConfig) GetMasterIpv4ReservedRange() string {
	if x != nil {
		return x.MasterIpv4ReservedRange
	}
	return ""
}

// Configuration options for networking connections in the Composer 2
// environment.
type NetworkingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indicates the user requested specifc connection type between
	// Tenant and Customer projects. You cannot set networking connection type in
	// public IP environment.
	ConnectionType NetworkingConfig_ConnectionType `protobuf:"varint,1,opt,name=connection_type,json=connectionType,proto3,enum=google.cloud.orchestration.airflow.service.v1.NetworkingConfig_ConnectionType" json:"connection_type,omitempty"`
}

func (x *NetworkingConfig) Reset() {
	*x = NetworkingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkingConfig) ProtoMessage() {}

func (x *NetworkingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkingConfig.ProtoReflect.Descriptor instead.
func (*NetworkingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{30}
}

func (x *NetworkingConfig) GetConnectionType() NetworkingConfig_ConnectionType {
	if x != nil {
		return x.ConnectionType
	}
	return NetworkingConfig_CONNECTION_TYPE_UNSPECIFIED
}

// The configuration information for configuring a Private IP Cloud Composer
// environment.
type PrivateEnvironmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If `true`, a Private IP Cloud Composer environment is created.
	// If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be
	// set to true for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	EnablePrivateEnvironment bool `protobuf:"varint,1,opt,name=enable_private_environment,json=enablePrivateEnvironment,proto3" json:"enable_private_environment,omitempty"`
	// Optional. Configuration for the private GKE cluster for a Private IP
	// Cloud Composer environment.
	PrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,2,opt,name=private_cluster_config,json=privateClusterConfig,proto3" json:"private_cluster_config,omitempty"`
	// Optional. The CIDR block from which IP range for web server will be
	// reserved. Needs to be disjoint from
	// `private_cluster_config.master_ipv4_cidr_block` and
	// `cloud_sql_ipv4_cidr_block`.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	WebServerIpv4CidrBlock string `protobuf:"bytes,3,opt,name=web_server_ipv4_cidr_block,json=webServerIpv4CidrBlock,proto3" json:"web_server_ipv4_cidr_block,omitempty"`
	// Optional. The CIDR block from which IP range in tenant project will be
	// reserved for Cloud SQL. Needs to be disjoint from
	// `web_server_ipv4_cidr_block`.
	CloudSqlIpv4CidrBlock string `protobuf:"bytes,4,opt,name=cloud_sql_ipv4_cidr_block,json=cloudSqlIpv4CidrBlock,proto3" json:"cloud_sql_ipv4_cidr_block,omitempty"`
	// Output only. The IP range reserved for the tenant project's App Engine VMs.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-1.*.*-airflow-*.*.*.
	WebServerIpv4ReservedRange string `protobuf:"bytes,5,opt,name=web_server_ipv4_reserved_range,json=webServerIpv4ReservedRange,proto3" json:"web_server_ipv4_reserved_range,omitempty"`
	// Optional. The CIDR block from which IP range for Cloud Composer Network in
	// tenant project will be reserved. Needs to be disjoint from
	// private_cluster_config.master_ipv4_cidr_block and
	// cloud_sql_ipv4_cidr_block.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	CloudComposerNetworkIpv4CidrBlock string `protobuf:"bytes,7,opt,name=cloud_composer_network_ipv4_cidr_block,json=cloudComposerNetworkIpv4CidrBlock,proto3" json:"cloud_composer_network_ipv4_cidr_block,omitempty"`
	// Output only. The IP range reserved for the tenant project's Cloud Composer
	// network.
	//
	// This field is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	CloudComposerNetworkIpv4ReservedRange string `protobuf:"bytes,8,opt,name=cloud_composer_network_ipv4_reserved_range,json=cloudComposerNetworkIpv4ReservedRange,proto3" json:"cloud_composer_network_ipv4_reserved_range,omitempty"`
	// Optional. When enabled, IPs from public (non-RFC1918) ranges can be used
	// for `IPAllocationPolicy.cluster_ipv4_cidr_block` and
	// `IPAllocationPolicy.service_ipv4_cidr_block`.
	EnablePrivatelyUsedPublicIps bool `protobuf:"varint,6,opt,name=enable_privately_used_public_ips,json=enablePrivatelyUsedPublicIps,proto3" json:"enable_privately_used_public_ips,omitempty"`
	// Optional. When specified, the environment will use Private Service Connect
	// instead of VPC peerings to connect to Cloud SQL in the Tenant Project,
	// and the PSC endpoint in the Customer Project will use an IP address from
	// this subnetwork.
	CloudComposerConnectionSubnetwork string `protobuf:"bytes,9,opt,name=cloud_composer_connection_subnetwork,json=cloudComposerConnectionSubnetwork,proto3" json:"cloud_composer_connection_subnetwork,omitempty"`
	// Optional. Configuration for the network connections configuration in the
	// environment.
	NetworkingConfig *NetworkingConfig `protobuf:"bytes,10,opt,name=networking_config,json=networkingConfig,proto3" json:"networking_config,omitempty"`
}

func (x *PrivateEnvironmentConfig) Reset() {
	*x = PrivateEnvironmentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateEnvironmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateEnvironmentConfig) ProtoMessage() {}

func (x *PrivateEnvironmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateEnvironmentConfig.ProtoReflect.Descriptor instead.
func (*PrivateEnvironmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{31}
}

func (x *PrivateEnvironmentConfig) GetEnablePrivateEnvironment() bool {
	if x != nil {
		return x.EnablePrivateEnvironment
	}
	return false
}

func (x *PrivateEnvironmentConfig) GetPrivateClusterConfig() *PrivateClusterConfig {
	if x != nil {
		return x.PrivateClusterConfig
	}
	return nil
}

func (x *PrivateEnvironmentConfig) GetWebServerIpv4CidrBlock() string {
	if x != nil {
		return x.WebServerIpv4CidrBlock
	}
	return ""
}

func (x *PrivateEnvironmentConfig) GetCloudSqlIpv4CidrBlock() string {
	if x != nil {
		return x.CloudSqlIpv4CidrBlock
	}
	return ""
}

func (x *PrivateEnvironmentConfig) GetWebServerIpv4ReservedRange() string {
	if x != nil {
		return x.WebServerIpv4ReservedRange
	}
	return ""
}

func (x *PrivateEnvironmentConfig) GetCloudComposerNetworkIpv4CidrBlock() string {
	if x != nil {
		return x.CloudComposerNetworkIpv4CidrBlock
	}
	return ""
}

func (x *PrivateEnvironmentConfig) GetCloudComposerNetworkIpv4ReservedRange() string {
	if x != nil {
		return x.CloudComposerNetworkIpv4ReservedRange
	}
	return ""
}

func (x *PrivateEnvironmentConfig) GetEnablePrivatelyUsedPublicIps() bool {
	if x != nil {
		return x.EnablePrivatelyUsedPublicIps
	}
	return false
}

func (x *PrivateEnvironmentConfig) GetCloudComposerConnectionSubnetwork() string {
	if x != nil {
		return x.CloudComposerConnectionSubnetwork
	}
	return ""
}

func (x *PrivateEnvironmentConfig) GetNetworkingConfig() *NetworkingConfig {
	if x != nil {
		return x.NetworkingConfig
	}
	return nil
}

// The Kubernetes workloads configuration for GKE cluster associated with the
// Cloud Composer environment. Supported for Cloud Composer environments in
// versions composer-2.*.*-airflow-*.*.* and newer.
type WorkloadsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resources used by Airflow schedulers.
	Scheduler *WorkloadsConfig_SchedulerResource `protobuf:"bytes,1,opt,name=scheduler,proto3" json:"scheduler,omitempty"`
	// Optional. Resources used by Airflow web server.
	WebServer *WorkloadsConfig_WebServerResource `protobuf:"bytes,2,opt,name=web_server,json=webServer,proto3" json:"web_server,omitempty"`
	// Optional. Resources used by Airflow workers.
	Worker *WorkloadsConfig_WorkerResource `protobuf:"bytes,3,opt,name=worker,proto3" json:"worker,omitempty"`
}

func (x *WorkloadsConfig) Reset() {
	*x = WorkloadsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadsConfig) ProtoMessage() {}

func (x *WorkloadsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadsConfig.ProtoReflect.Descriptor instead.
func (*WorkloadsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{32}
}

func (x *WorkloadsConfig) GetScheduler() *WorkloadsConfig_SchedulerResource {
	if x != nil {
		return x.Scheduler
	}
	return nil
}

func (x *WorkloadsConfig) GetWebServer() *WorkloadsConfig_WebServerResource {
	if x != nil {
		return x.WebServer
	}
	return nil
}

func (x *WorkloadsConfig) GetWorker() *WorkloadsConfig_WorkerResource {
	if x != nil {
		return x.Worker
	}
	return nil
}

// The Recovery settings of an environment.
type RecoveryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The configuration for scheduled snapshot creation mechanism.
	ScheduledSnapshotsConfig *ScheduledSnapshotsConfig `protobuf:"bytes,1,opt,name=scheduled_snapshots_config,json=scheduledSnapshotsConfig,proto3" json:"scheduled_snapshots_config,omitempty"`
}

func (x *RecoveryConfig) Reset() {
	*x = RecoveryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecoveryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoveryConfig) ProtoMessage() {}

func (x *RecoveryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoveryConfig.ProtoReflect.Descriptor instead.
func (*RecoveryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{33}
}

func (x *RecoveryConfig) GetScheduledSnapshotsConfig() *ScheduledSnapshotsConfig {
	if x != nil {
		return x.ScheduledSnapshotsConfig
	}
	return nil
}

// The configuration for scheduled snapshot creation mechanism.
type ScheduledSnapshotsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether scheduled snapshots creation is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. The Cloud Storage location for storing automatically created
	// snapshots.
	SnapshotLocation string `protobuf:"bytes,6,opt,name=snapshot_location,json=snapshotLocation,proto3" json:"snapshot_location,omitempty"`
	// Optional. The cron expression representing the time when snapshots creation
	// mechanism runs. This field is subject to additional validation around
	// frequency of execution.
	SnapshotCreationSchedule string `protobuf:"bytes,3,opt,name=snapshot_creation_schedule,json=snapshotCreationSchedule,proto3" json:"snapshot_creation_schedule,omitempty"`
	// Optional. Time zone that sets the context to interpret
	// snapshot_creation_schedule.
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
}

func (x *ScheduledSnapshotsConfig) Reset() {
	*x = ScheduledSnapshotsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScheduledSnapshotsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduledSnapshotsConfig) ProtoMessage() {}

func (x *ScheduledSnapshotsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduledSnapshotsConfig.ProtoReflect.Descriptor instead.
func (*ScheduledSnapshotsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{34}
}

func (x *ScheduledSnapshotsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ScheduledSnapshotsConfig) GetSnapshotLocation() string {
	if x != nil {
		return x.SnapshotLocation
	}
	return ""
}

func (x *ScheduledSnapshotsConfig) GetSnapshotCreationSchedule() string {
	if x != nil {
		return x.SnapshotCreationSchedule
	}
	return ""
}

func (x *ScheduledSnapshotsConfig) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

// Configuration options for the master authorized networks feature. Enabled
// master authorized networks will disallow all external traffic to access
// Kubernetes master through HTTPS except traffic from the given CIDR blocks,
// Google Compute Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not master authorized networks feature is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Up to 50 external networks that could access Kubernetes master through
	// HTTPS.
	CidrBlocks []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,2,rep,name=cidr_blocks,json=cidrBlocks,proto3" json:"cidr_blocks,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig) Reset() {
	*x = MasterAuthorizedNetworksConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterAuthorizedNetworksConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{35}
}

func (x *MasterAuthorizedNetworksConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if x != nil {
		return x.CidrBlocks
	}
	return nil
}

// An environment for running orchestration tasks.
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the environment, in the form:
	// "projects/{projectId}/locations/{locationId}/environments/{environmentId}"
	//
	// EnvironmentId must start with a lowercase letter followed by up to 63
	// lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Configuration parameters for this environment.
	Config *EnvironmentConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Output only. The UUID (Universally Unique IDentifier) associated with this
	// environment. This value is generated when the environment is created.
	Uuid string `protobuf:"bytes,3,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// The current state of the environment.
	State Environment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.orchestration.airflow.service.v1.Environment_State" json:"state,omitempty"`
	// Output only. The time at which this environment was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this environment was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User-defined labels for this environment.
	// The labels map can contain no more than 64 entries. Entries of the labels
	// map are UTF8 strings that comply with the following restrictions:
	//
	// * Keys must conform to regexp: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	// * Values must conform to regexp:  [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	// * Both keys and values are additionally constrained to be <= 128 bytes in
	// size.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{36}
}

func (x *Environment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Environment) GetConfig() *EnvironmentConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Environment) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *Environment) GetState() Environment_State {
	if x != nil {
		return x.State
	}
	return Environment_STATE_UNSPECIFIED
}

func (x *Environment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Environment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Environment) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Message containing information about the result of an upgrade check
// operation.
type CheckUpgradeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Url for a docker build log of an upgraded image.
	BuildLogUri string `protobuf:"bytes,1,opt,name=build_log_uri,json=buildLogUri,proto3" json:"build_log_uri,omitempty"`
	// Output only. Whether build has succeeded or failed on modules conflicts.
	ContainsPypiModulesConflict CheckUpgradeResponse_ConflictResult `protobuf:"varint,4,opt,name=contains_pypi_modules_conflict,json=containsPypiModulesConflict,proto3,enum=google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse_ConflictResult" json:"contains_pypi_modules_conflict,omitempty"`
	// Output only. Extract from a docker image build log containing information
	// about pypi modules conflicts.
	PypiConflictBuildLogExtract string `protobuf:"bytes,3,opt,name=pypi_conflict_build_log_extract,json=pypiConflictBuildLogExtract,proto3" json:"pypi_conflict_build_log_extract,omitempty"`
	// Composer image for which the build was happening.
	ImageVersion string `protobuf:"bytes,5,opt,name=image_version,json=imageVersion,proto3" json:"image_version,omitempty"`
	// Pypi dependencies specified in the environment configuration, at the time
	// when the build was triggered.
	PypiDependencies map[string]string `protobuf:"bytes,6,rep,name=pypi_dependencies,json=pypiDependencies,proto3" json:"pypi_dependencies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CheckUpgradeResponse) Reset() {
	*x = CheckUpgradeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckUpgradeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckUpgradeResponse) ProtoMessage() {}

func (x *CheckUpgradeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckUpgradeResponse.ProtoReflect.Descriptor instead.
func (*CheckUpgradeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{37}
}

func (x *CheckUpgradeResponse) GetBuildLogUri() string {
	if x != nil {
		return x.BuildLogUri
	}
	return ""
}

func (x *CheckUpgradeResponse) GetContainsPypiModulesConflict() CheckUpgradeResponse_ConflictResult {
	if x != nil {
		return x.ContainsPypiModulesConflict
	}
	return CheckUpgradeResponse_CONFLICT_RESULT_UNSPECIFIED
}

func (x *CheckUpgradeResponse) GetPypiConflictBuildLogExtract() string {
	if x != nil {
		return x.PypiConflictBuildLogExtract
	}
	return ""
}

func (x *CheckUpgradeResponse) GetImageVersion() string {
	if x != nil {
		return x.ImageVersion
	}
	return ""
}

func (x *CheckUpgradeResponse) GetPypiDependencies() map[string]string {
	if x != nil {
		return x.PypiDependencies
	}
	return nil
}

// Contains information about a single line from logs.
type PollAirflowCommandResponse_Line struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of the line.
	LineNumber int32 `protobuf:"varint,1,opt,name=line_number,json=lineNumber,proto3" json:"line_number,omitempty"`
	// Text content of the log line.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *PollAirflowCommandResponse_Line) Reset() {
	*x = PollAirflowCommandResponse_Line{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollAirflowCommandResponse_Line) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollAirflowCommandResponse_Line) ProtoMessage() {}

func (x *PollAirflowCommandResponse_Line) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollAirflowCommandResponse_Line.ProtoReflect.Descriptor instead.
func (*PollAirflowCommandResponse_Line) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{11, 0}
}

func (x *PollAirflowCommandResponse_Line) GetLineNumber() int32 {
	if x != nil {
		return x.LineNumber
	}
	return 0
}

func (x *PollAirflowCommandResponse_Line) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

// Information about how a command ended.
type PollAirflowCommandResponse_ExitInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exit code from the command execution.
	ExitCode int32 `protobuf:"varint,1,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Error message. Empty if there was no error.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *PollAirflowCommandResponse_ExitInfo) Reset() {
	*x = PollAirflowCommandResponse_ExitInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollAirflowCommandResponse_ExitInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollAirflowCommandResponse_ExitInfo) ProtoMessage() {}

func (x *PollAirflowCommandResponse_ExitInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollAirflowCommandResponse_ExitInfo.ProtoReflect.Descriptor instead.
func (*PollAirflowCommandResponse_ExitInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{11, 1}
}

func (x *PollAirflowCommandResponse_ExitInfo) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *PollAirflowCommandResponse_ExitInfo) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Allowed IP range with user-provided description.
type WebServerNetworkAccessControl_AllowedIpRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IP address or range, defined using CIDR notation, of requests that this
	// rule applies to.
	// Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32`
	//
	//	or `2001:0db8:0000:0042:0000:8a2e:0370:7334`.
	//
	// IP range prefixes should be properly truncated. For example,
	// `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6,
	// `2001:db8::1/32` should be truncated to `2001:db8::/32`.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. User-provided description. It must contain at most 300
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *WebServerNetworkAccessControl_AllowedIpRange) Reset() {
	*x = WebServerNetworkAccessControl_AllowedIpRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebServerNetworkAccessControl_AllowedIpRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebServerNetworkAccessControl_AllowedIpRange) ProtoMessage() {}

func (x *WebServerNetworkAccessControl_AllowedIpRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebServerNetworkAccessControl_AllowedIpRange.ProtoReflect.Descriptor instead.
func (*WebServerNetworkAccessControl_AllowedIpRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{21, 0}
}

func (x *WebServerNetworkAccessControl_AllowedIpRange) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *WebServerNetworkAccessControl_AllowedIpRange) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Configuration for resources used by Airflow schedulers.
type WorkloadsConfig_SchedulerResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. CPU request and limit for a single Airflow scheduler replica.
	Cpu float32 `protobuf:"fixed32,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Optional. Memory (GB) request and limit for a single Airflow scheduler
	// replica.
	MemoryGb float32 `protobuf:"fixed32,2,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// Optional. Storage (GB) request and limit for a single Airflow scheduler
	// replica.
	StorageGb float32 `protobuf:"fixed32,3,opt,name=storage_gb,json=storageGb,proto3" json:"storage_gb,omitempty"`
	// Optional. The number of schedulers.
	Count int32 `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *WorkloadsConfig_SchedulerResource) Reset() {
	*x = WorkloadsConfig_SchedulerResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadsConfig_SchedulerResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadsConfig_SchedulerResource) ProtoMessage() {}

func (x *WorkloadsConfig_SchedulerResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadsConfig_SchedulerResource.ProtoReflect.Descriptor instead.
func (*WorkloadsConfig_SchedulerResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{32, 0}
}

func (x *WorkloadsConfig_SchedulerResource) GetCpu() float32 {
	if x != nil {
		return x.Cpu
	}
	return 0
}

func (x *WorkloadsConfig_SchedulerResource) GetMemoryGb() float32 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *WorkloadsConfig_SchedulerResource) GetStorageGb() float32 {
	if x != nil {
		return x.StorageGb
	}
	return 0
}

func (x *WorkloadsConfig_SchedulerResource) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Configuration for resources used by Airflow web server.
type WorkloadsConfig_WebServerResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. CPU request and limit for Airflow web server.
	Cpu float32 `protobuf:"fixed32,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Optional. Memory (GB) request and limit for Airflow web server.
	MemoryGb float32 `protobuf:"fixed32,2,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// Optional. Storage (GB) request and limit for Airflow web server.
	StorageGb float32 `protobuf:"fixed32,3,opt,name=storage_gb,json=storageGb,proto3" json:"storage_gb,omitempty"`
}

func (x *WorkloadsConfig_WebServerResource) Reset() {
	*x = WorkloadsConfig_WebServerResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadsConfig_WebServerResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadsConfig_WebServerResource) ProtoMessage() {}

func (x *WorkloadsConfig_WebServerResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadsConfig_WebServerResource.ProtoReflect.Descriptor instead.
func (*WorkloadsConfig_WebServerResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{32, 1}
}

func (x *WorkloadsConfig_WebServerResource) GetCpu() float32 {
	if x != nil {
		return x.Cpu
	}
	return 0
}

func (x *WorkloadsConfig_WebServerResource) GetMemoryGb() float32 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *WorkloadsConfig_WebServerResource) GetStorageGb() float32 {
	if x != nil {
		return x.StorageGb
	}
	return 0
}

// Configuration for resources used by Airflow workers.
type WorkloadsConfig_WorkerResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. CPU request and limit for a single Airflow worker replica.
	Cpu float32 `protobuf:"fixed32,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Optional. Memory (GB) request and limit for a single Airflow worker
	// replica.
	MemoryGb float32 `protobuf:"fixed32,2,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// Optional. Storage (GB) request and limit for a single Airflow worker
	// replica.
	StorageGb float32 `protobuf:"fixed32,3,opt,name=storage_gb,json=storageGb,proto3" json:"storage_gb,omitempty"`
	// Optional. Minimum number of workers for autoscaling.
	MinCount int32 `protobuf:"varint,4,opt,name=min_count,json=minCount,proto3" json:"min_count,omitempty"`
	// Optional. Maximum number of workers for autoscaling.
	MaxCount int32 `protobuf:"varint,5,opt,name=max_count,json=maxCount,proto3" json:"max_count,omitempty"`
}

func (x *WorkloadsConfig_WorkerResource) Reset() {
	*x = WorkloadsConfig_WorkerResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadsConfig_WorkerResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadsConfig_WorkerResource) ProtoMessage() {}

func (x *WorkloadsConfig_WorkerResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadsConfig_WorkerResource.ProtoReflect.Descriptor instead.
func (*WorkloadsConfig_WorkerResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{32, 2}
}

func (x *WorkloadsConfig_WorkerResource) GetCpu() float32 {
	if x != nil {
		return x.Cpu
	}
	return 0
}

func (x *WorkloadsConfig_WorkerResource) GetMemoryGb() float32 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *WorkloadsConfig_WorkerResource) GetStorageGb() float32 {
	if x != nil {
		return x.StorageGb
	}
	return 0
}

func (x *WorkloadsConfig_WorkerResource) GetMinCount() int32 {
	if x != nil {
		return x.MinCount
	}
	return 0
}

func (x *WorkloadsConfig_WorkerResource) GetMaxCount() int32 {
	if x != nil {
		return x.MaxCount
	}
	return 0
}

// CIDR block with an optional name.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User-defined name that identifies the CIDR block.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// CIDR block that must be specified in CIDR notation.
	CidrBlock string `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*x = MasterAuthorizedNetworksConfig_CidrBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig_CidrBlock.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP(), []int{35, 0}
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if x != nil {
		return x.CidrBlock
	}
	return ""
}

var File_google_cloud_orchestration_airflow_service_v1_environments_proto protoreflect.FileDescriptor

var file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x69, 0x72,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c,
	0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x2b, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6d, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x2e, 0x0a,
	0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc9, 0x01,
	0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c,
	0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9a, 0x01, 0x0a, 0x1c, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x8f, 0x01, 0x0a, 0x1d, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x70,
	0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x6f, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x70, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xad, 0x01, 0x0a, 0x19, 0x53, 0x74, 0x6f,
	0x70, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x70,
	0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x6f, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x70, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x4d, 0x0a, 0x1a, 0x53, 0x74, 0x6f, 0x70,
	0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x64, 0x6f, 0x6e,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x44, 0x6f, 0x6e, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0xc1, 0x01, 0x0a, 0x19, 0x50, 0x6f, 0x6c, 0x6c,
	0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x6f,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x6f, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x70, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6e, 0x65, 0x78,
	0x74, 0x4c, 0x69, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x96, 0x03, 0x0a, 0x1a,
	0x50, 0x6f, 0x6c, 0x6c, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x41,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x45, 0x6e,
	0x64, 0x12, 0x6f, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x45, 0x78, 0x69, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x1a, 0x41, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x6c, 0x69, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x3d, 0x0a, 0x08, 0x45, 0x78, 0x69, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x22, 0x64, 0x0a, 0x13, 0x53, 0x61, 0x76, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a,
	0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3b, 0x0a, 0x14, 0x53, 0x61,
	0x76, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0xe8, 0x02, 0x0a, 0x13, 0x4c, 0x6f, 0x61, 0x64,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x45, 0x0a, 0x1f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70,
	0x79, 0x70, 0x69, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1c, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x79, 0x70, 0x69, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a,
	0x22, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1f, 0x73, 0x6b, 0x69, 0x70, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x43, 0x0a, 0x1e, 0x73, 0x6b,
	0x69, 0x70, 0x5f, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x1b, 0x73, 0x6b, 0x69, 0x70, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x31, 0x0a, 0x15, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x63, 0x6f, 0x70, 0x79, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x73, 0x6b, 0x69, 0x70, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x70, 0x79, 0x69,
	0x6e, 0x67, 0x22, 0x16, 0x0a, 0x14, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x0a, 0x17, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x1a, 0x0a, 0x18, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x6f, 0x0a, 0x1e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x22, 0xbc, 0x01, 0x0a, 0x1f, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x5f, 0x67, 0x63, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x47, 0x63, 0x65, 0x5a, 0x6f,
	0x6e, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x67, 0x63, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x47, 0x63, 0x65, 0x5a, 0x6f, 0x6e, 0x65,
	0x12, 0x41, 0x0a, 0x1d, 0x69, 0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x69, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0xce, 0x0f, 0x0a, 0x11, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x6b, 0x65,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x67, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x61,
	0x67, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x64, 0x61, 0x67, 0x47, 0x63, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x66, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x1a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x18, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x9b, 0x01, 0x0a, 0x21,
	0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x77, 0x65, 0x62, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x6b, 0x0a, 0x0f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x11, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x12, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x12, 0x6e, 0x0a, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x80, 0x01, 0x0a, 0x10, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x55, 0x72, 0x69, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x5f,
	0x62, 0x79, 0x6f, 0x69, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x79, 0x6f,
	0x69, 0x64, 0x55, 0x72, 0x69, 0x12, 0x9d, 0x01, 0x0a, 0x21, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x7d, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x69, 0x6c, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65,
	0x73, 0x69, 0x6c, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x69, 0x6c, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x22, 0x88, 0x01, 0x0a, 0x0f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x56, 0x49, 0x52,
	0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x53, 0x4d, 0x41, 0x4c,
	0x4c, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02,
	0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x53, 0x49, 0x5a, 0x45, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x03, 0x22, 0x46, 0x0a, 0x0e,
	0x52, 0x65, 0x73, 0x69, 0x6c, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1f,
	0x0a, 0x1b, 0x52, 0x45, 0x53, 0x49, 0x4c, 0x49, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x48, 0x49, 0x47, 0x48, 0x5f, 0x52, 0x45, 0x53, 0x49, 0x4c, 0x49, 0x45, 0x4e,
	0x43, 0x45, 0x10, 0x01, 0x22, 0xf8, 0x01, 0x0a, 0x1d, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x87, 0x01, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x1a, 0x4d, 0x0a, 0x0e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x38, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x39, 0x0a, 0x0f, 0x57, 0x65, 0x62,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x22, 0x39, 0x0a, 0x10, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0xb4, 0x01, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xd9, 0x05, 0x0a, 0x0e, 0x53, 0x6f, 0x66, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x93,
	0x01, 0x0a, 0x18, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x16, 0x61, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x0d, 0x70, 0x79, 0x70, 0x69, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x79, 0x70, 0x69, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x70, 0x79,
	0x70, 0x69, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x0d, 0x65, 0x6e,
	0x76, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0c, 0x65, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x49, 0x0a, 0x1b, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x3f, 0x0a, 0x11, 0x50, 0x79, 0x70, 0x69, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x3f, 0x0a, 0x11, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x82, 0x03, 0x0a, 0x12, 0x49, 0x50, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x29, 0x0a, 0x0e, 0x75, 0x73, 0x65,
	0x5f, 0x69, 0x70, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x49, 0x70, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x1c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x19, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x17,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64,
	0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x14, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76,
	0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x48, 0x0a, 0x1d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x1a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x15, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x42, 0x17, 0x0a, 0x15, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x70, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x18, 0x0a,
	0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x03, 0x0a, 0x0a, 0x4e, 0x6f, 0x64, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47,
	0x62, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x12, 0x78, 0x0a, 0x14, 0x69, 0x70, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x50, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x70, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x34, 0x0a, 0x14, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x6d, 0x61, 0x73, 0x71, 0x5f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x70, 0x4d, 0x61, 0x73, 0x71, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x22, 0xcf, 0x01, 0x0a, 0x14, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x17, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x40, 0x0a, 0x1a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34,
	0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x22, 0xf1, 0x01, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x5f, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x4e,
	0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x50, 0x43,
	0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52,
	0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x02, 0x22, 0xf4, 0x06, 0x0a, 0x18, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x0a, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x7e, 0x0a, 0x16, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x14, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x1a, 0x77, 0x65, 0x62, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x16, 0x77, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43,
	0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x3d, 0x0a, 0x19, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69,
	0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x47, 0x0a, 0x1e, 0x77, 0x65, 0x62, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x77, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49,
	0x70, 0x76, 0x34, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x56, 0x0a, 0x26, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73,
	0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f,
	0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x70, 0x76, 0x34, 0x43,
	0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x5e, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x70, 0x76, 0x34, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x4b, 0x0a, 0x20, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x5f, 0x75, 0x73, 0x65,
	0x64, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x55, 0x73, 0x65, 0x64, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x49, 0x70, 0x73, 0x12, 0x54, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x71, 0x0a, 0x11, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9c,
	0x06, 0x0a, 0x0f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x73, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x12, 0x74, 0x0a, 0x0a, 0x77, 0x65, 0x62, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x57, 0x65, 0x62, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x77, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x6a, 0x0a,
	0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x1a, 0x8b, 0x01, 0x0a, 0x11, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x47, 0x62, 0x12, 0x19, 0x0a, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x70, 0x0a, 0x11, 0x57, 0x65, 0x62, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03,
	0x63, 0x70, 0x75, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x67, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x47, 0x62, 0x1a, 0xb1, 0x01, 0x0a, 0x0e, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03,
	0x63, 0x70, 0x75, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x67, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x47, 0x62, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d,
	0x61, 0x78, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x9d, 0x01,
	0x0a, 0x0e, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x8a, 0x01, 0x0a, 0x1a, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd0, 0x01,
	0x0a, 0x18, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x11, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x1a, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x20,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65,
	0x22, 0x83, 0x02, 0x0a, 0x1e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x78, 0x0a,
	0x0b, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x63, 0x69, 0x64,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x1a, 0x4d, 0x0a, 0x09, 0x43, 0x69, 0x64, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x69, 0x64,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0xcc, 0x05, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x56, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x23, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xee, 0x04, 0x0a, 0x14, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27,
	0x0a, 0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x4c, 0x6f, 0x67, 0x55, 0x72, 0x69, 0x12, 0x9c, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x73, 0x5f, 0x70, 0x79, 0x70, 0x69, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x73, 0x50, 0x79, 0x70, 0x69, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x1f, 0x70, 0x79, 0x70, 0x69, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x70, 0x79, 0x70, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69,
	0x63, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4c, 0x6f, 0x67, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x86, 0x01, 0x0a, 0x11, 0x70, 0x79, 0x70, 0x69, 0x5f,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x79, 0x70, 0x69, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x70,
	0x79, 0x70, 0x69, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a,
	0x43, 0x0a, 0x15, 0x50, 0x79, 0x70, 0x69, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x50, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49,
	0x43, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x46, 0x4c,
	0x49, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x46,
	0x4c, 0x49, 0x43, 0x54, 0x10, 0x02, 0x32, 0xbd, 0x1b, 0x0a, 0x0c, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xa9, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xab, 0x01, 0xca, 0x41, 0x4e, 0x0a, 0x0b, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0xb3, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xb5, 0x01, 0xca, 0x41, 0x4e, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1c, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x02, 0x0a, 0x11, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x01, 0xca, 0x41, 0x58, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x8c, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x41,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x4b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52,
	0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x65, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x12, 0x80, 0x02, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x70, 0x41, 0x69, 0x72, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x41, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x80, 0x02, 0x0a, 0x12, 0x50, 0x6f, 0x6c, 0x6c, 0x41, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x48, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x6c, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x41, 0x69, 0x72, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x6f, 0x6c, 0x6c, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0xcc, 0x02, 0x0a, 0x0c, 0x53, 0x61, 0x76,
	0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd8, 0x01, 0xca,
	0x41, 0x85, 0x01, 0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x01,
	0x2a, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x61, 0x76, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0xcc, 0x02, 0x0a, 0x0c, 0x4c, 0x6f, 0x61, 0x64,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd8, 0x01, 0xca, 0x41,
	0x85, 0x01, 0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x01, 0x2a,
	0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0xdc, 0x02, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xe0, 0x01, 0xca, 0x41, 0x89, 0x01, 0x0a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x91, 0x02, 0x0a, 0x17, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x82, 0x01, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x4b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x70,
	0x62, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescOnce sync.Once
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescData = file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDesc
)

func file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescGZIP() []byte {
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescOnce.Do(func() {
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescData)
	})
	return file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDescData
}

var file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_cloud_orchestration_airflow_service_v1_environments_proto_goTypes = []interface{}{
	(EnvironmentConfig_EnvironmentSize)(0),               // 0: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.EnvironmentSize
	(EnvironmentConfig_ResilienceMode)(0),                // 1: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.ResilienceMode
	(NetworkingConfig_ConnectionType)(0),                 // 2: google.cloud.orchestration.airflow.service.v1.NetworkingConfig.ConnectionType
	(Environment_State)(0),                               // 3: google.cloud.orchestration.airflow.service.v1.Environment.State
	(CheckUpgradeResponse_ConflictResult)(0),             // 4: google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse.ConflictResult
	(*CreateEnvironmentRequest)(nil),                     // 5: google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest
	(*GetEnvironmentRequest)(nil),                        // 6: google.cloud.orchestration.airflow.service.v1.GetEnvironmentRequest
	(*ListEnvironmentsRequest)(nil),                      // 7: google.cloud.orchestration.airflow.service.v1.ListEnvironmentsRequest
	(*ListEnvironmentsResponse)(nil),                     // 8: google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse
	(*DeleteEnvironmentRequest)(nil),                     // 9: google.cloud.orchestration.airflow.service.v1.DeleteEnvironmentRequest
	(*UpdateEnvironmentRequest)(nil),                     // 10: google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest
	(*ExecuteAirflowCommandRequest)(nil),                 // 11: google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandRequest
	(*ExecuteAirflowCommandResponse)(nil),                // 12: google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandResponse
	(*StopAirflowCommandRequest)(nil),                    // 13: google.cloud.orchestration.airflow.service.v1.StopAirflowCommandRequest
	(*StopAirflowCommandResponse)(nil),                   // 14: google.cloud.orchestration.airflow.service.v1.StopAirflowCommandResponse
	(*PollAirflowCommandRequest)(nil),                    // 15: google.cloud.orchestration.airflow.service.v1.PollAirflowCommandRequest
	(*PollAirflowCommandResponse)(nil),                   // 16: google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse
	(*SaveSnapshotRequest)(nil),                          // 17: google.cloud.orchestration.airflow.service.v1.SaveSnapshotRequest
	(*SaveSnapshotResponse)(nil),                         // 18: google.cloud.orchestration.airflow.service.v1.SaveSnapshotResponse
	(*LoadSnapshotRequest)(nil),                          // 19: google.cloud.orchestration.airflow.service.v1.LoadSnapshotRequest
	(*LoadSnapshotResponse)(nil),                         // 20: google.cloud.orchestration.airflow.service.v1.LoadSnapshotResponse
	(*DatabaseFailoverRequest)(nil),                      // 21: google.cloud.orchestration.airflow.service.v1.DatabaseFailoverRequest
	(*DatabaseFailoverResponse)(nil),                     // 22: google.cloud.orchestration.airflow.service.v1.DatabaseFailoverResponse
	(*FetchDatabasePropertiesRequest)(nil),               // 23: google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesRequest
	(*FetchDatabasePropertiesResponse)(nil),              // 24: google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesResponse
	(*EnvironmentConfig)(nil),                            // 25: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig
	(*WebServerNetworkAccessControl)(nil),                // 26: google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
	(*DatabaseConfig)(nil),                               // 27: google.cloud.orchestration.airflow.service.v1.DatabaseConfig
	(*WebServerConfig)(nil),                              // 28: google.cloud.orchestration.airflow.service.v1.WebServerConfig
	(*EncryptionConfig)(nil),                             // 29: google.cloud.orchestration.airflow.service.v1.EncryptionConfig
	(*MaintenanceWindow)(nil),                            // 30: google.cloud.orchestration.airflow.service.v1.MaintenanceWindow
	(*SoftwareConfig)(nil),                               // 31: google.cloud.orchestration.airflow.service.v1.SoftwareConfig
	(*IPAllocationPolicy)(nil),                           // 32: google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
	(*NodeConfig)(nil),                                   // 33: google.cloud.orchestration.airflow.service.v1.NodeConfig
	(*PrivateClusterConfig)(nil),                         // 34: google.cloud.orchestration.airflow.service.v1.PrivateClusterConfig
	(*NetworkingConfig)(nil),                             // 35: google.cloud.orchestration.airflow.service.v1.NetworkingConfig
	(*PrivateEnvironmentConfig)(nil),                     // 36: google.cloud.orchestration.airflow.service.v1.PrivateEnvironmentConfig
	(*WorkloadsConfig)(nil),                              // 37: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig
	(*RecoveryConfig)(nil),                               // 38: google.cloud.orchestration.airflow.service.v1.RecoveryConfig
	(*ScheduledSnapshotsConfig)(nil),                     // 39: google.cloud.orchestration.airflow.service.v1.ScheduledSnapshotsConfig
	(*MasterAuthorizedNetworksConfig)(nil),               // 40: google.cloud.orchestration.airflow.service.v1.MasterAuthorizedNetworksConfig
	(*Environment)(nil),                                  // 41: google.cloud.orchestration.airflow.service.v1.Environment
	(*CheckUpgradeResponse)(nil),                         // 42: google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse
	(*PollAirflowCommandResponse_Line)(nil),              // 43: google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse.Line
	(*PollAirflowCommandResponse_ExitInfo)(nil),          // 44: google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse.ExitInfo
	(*WebServerNetworkAccessControl_AllowedIpRange)(nil), // 45: google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange
	nil, // 46: google.cloud.orchestration.airflow.service.v1.SoftwareConfig.AirflowConfigOverridesEntry
	nil, // 47: google.cloud.orchestration.airflow.service.v1.SoftwareConfig.PypiPackagesEntry
	nil, // 48: google.cloud.orchestration.airflow.service.v1.SoftwareConfig.EnvVariablesEntry
	(*WorkloadsConfig_SchedulerResource)(nil),        // 49: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.SchedulerResource
	(*WorkloadsConfig_WebServerResource)(nil),        // 50: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.WebServerResource
	(*WorkloadsConfig_WorkerResource)(nil),           // 51: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.WorkerResource
	(*MasterAuthorizedNetworksConfig_CidrBlock)(nil), // 52: google.cloud.orchestration.airflow.service.v1.MasterAuthorizedNetworksConfig.CidrBlock
	nil,                             // 53: google.cloud.orchestration.airflow.service.v1.Environment.LabelsEntry
	nil,                             // 54: google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse.PypiDependenciesEntry
	(*fieldmaskpb.FieldMask)(nil),   // 55: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),   // 56: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil), // 57: google.longrunning.Operation
}
var file_google_cloud_orchestration_airflow_service_v1_environments_proto_depIdxs = []int32{
	41, // 0: google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest.environment:type_name -> google.cloud.orchestration.airflow.service.v1.Environment
	41, // 1: google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse.environments:type_name -> google.cloud.orchestration.airflow.service.v1.Environment
	41, // 2: google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest.environment:type_name -> google.cloud.orchestration.airflow.service.v1.Environment
	55, // 3: google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest.update_mask:type_name -> google.protobuf.FieldMask
	43, // 4: google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse.output:type_name -> google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse.Line
	44, // 5: google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse.exit_info:type_name -> google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse.ExitInfo
	31, // 6: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.software_config:type_name -> google.cloud.orchestration.airflow.service.v1.SoftwareConfig
	33, // 7: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.node_config:type_name -> google.cloud.orchestration.airflow.service.v1.NodeConfig
	36, // 8: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.private_environment_config:type_name -> google.cloud.orchestration.airflow.service.v1.PrivateEnvironmentConfig
	26, // 9: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.web_server_network_access_control:type_name -> google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl
	27, // 10: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.database_config:type_name -> google.cloud.orchestration.airflow.service.v1.DatabaseConfig
	28, // 11: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.web_server_config:type_name -> google.cloud.orchestration.airflow.service.v1.WebServerConfig
	29, // 12: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.encryption_config:type_name -> google.cloud.orchestration.airflow.service.v1.EncryptionConfig
	30, // 13: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.maintenance_window:type_name -> google.cloud.orchestration.airflow.service.v1.MaintenanceWindow
	37, // 14: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.workloads_config:type_name -> google.cloud.orchestration.airflow.service.v1.WorkloadsConfig
	0,  // 15: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.environment_size:type_name -> google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.EnvironmentSize
	40, // 16: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.master_authorized_networks_config:type_name -> google.cloud.orchestration.airflow.service.v1.MasterAuthorizedNetworksConfig
	38, // 17: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.recovery_config:type_name -> google.cloud.orchestration.airflow.service.v1.RecoveryConfig
	1,  // 18: google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.resilience_mode:type_name -> google.cloud.orchestration.airflow.service.v1.EnvironmentConfig.ResilienceMode
	45, // 19: google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.allowed_ip_ranges:type_name -> google.cloud.orchestration.airflow.service.v1.WebServerNetworkAccessControl.AllowedIpRange
	56, // 20: google.cloud.orchestration.airflow.service.v1.MaintenanceWindow.start_time:type_name -> google.protobuf.Timestamp
	56, // 21: google.cloud.orchestration.airflow.service.v1.MaintenanceWindow.end_time:type_name -> google.protobuf.Timestamp
	46, // 22: google.cloud.orchestration.airflow.service.v1.SoftwareConfig.airflow_config_overrides:type_name -> google.cloud.orchestration.airflow.service.v1.SoftwareConfig.AirflowConfigOverridesEntry
	47, // 23: google.cloud.orchestration.airflow.service.v1.SoftwareConfig.pypi_packages:type_name -> google.cloud.orchestration.airflow.service.v1.SoftwareConfig.PypiPackagesEntry
	48, // 24: google.cloud.orchestration.airflow.service.v1.SoftwareConfig.env_variables:type_name -> google.cloud.orchestration.airflow.service.v1.SoftwareConfig.EnvVariablesEntry
	32, // 25: google.cloud.orchestration.airflow.service.v1.NodeConfig.ip_allocation_policy:type_name -> google.cloud.orchestration.airflow.service.v1.IPAllocationPolicy
	2,  // 26: google.cloud.orchestration.airflow.service.v1.NetworkingConfig.connection_type:type_name -> google.cloud.orchestration.airflow.service.v1.NetworkingConfig.ConnectionType
	34, // 27: google.cloud.orchestration.airflow.service.v1.PrivateEnvironmentConfig.private_cluster_config:type_name -> google.cloud.orchestration.airflow.service.v1.PrivateClusterConfig
	35, // 28: google.cloud.orchestration.airflow.service.v1.PrivateEnvironmentConfig.networking_config:type_name -> google.cloud.orchestration.airflow.service.v1.NetworkingConfig
	49, // 29: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.scheduler:type_name -> google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.SchedulerResource
	50, // 30: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.web_server:type_name -> google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.WebServerResource
	51, // 31: google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.worker:type_name -> google.cloud.orchestration.airflow.service.v1.WorkloadsConfig.WorkerResource
	39, // 32: google.cloud.orchestration.airflow.service.v1.RecoveryConfig.scheduled_snapshots_config:type_name -> google.cloud.orchestration.airflow.service.v1.ScheduledSnapshotsConfig
	52, // 33: google.cloud.orchestration.airflow.service.v1.MasterAuthorizedNetworksConfig.cidr_blocks:type_name -> google.cloud.orchestration.airflow.service.v1.MasterAuthorizedNetworksConfig.CidrBlock
	25, // 34: google.cloud.orchestration.airflow.service.v1.Environment.config:type_name -> google.cloud.orchestration.airflow.service.v1.EnvironmentConfig
	3,  // 35: google.cloud.orchestration.airflow.service.v1.Environment.state:type_name -> google.cloud.orchestration.airflow.service.v1.Environment.State
	56, // 36: google.cloud.orchestration.airflow.service.v1.Environment.create_time:type_name -> google.protobuf.Timestamp
	56, // 37: google.cloud.orchestration.airflow.service.v1.Environment.update_time:type_name -> google.protobuf.Timestamp
	53, // 38: google.cloud.orchestration.airflow.service.v1.Environment.labels:type_name -> google.cloud.orchestration.airflow.service.v1.Environment.LabelsEntry
	4,  // 39: google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse.contains_pypi_modules_conflict:type_name -> google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse.ConflictResult
	54, // 40: google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse.pypi_dependencies:type_name -> google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse.PypiDependenciesEntry
	5,  // 41: google.cloud.orchestration.airflow.service.v1.Environments.CreateEnvironment:input_type -> google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest
	6,  // 42: google.cloud.orchestration.airflow.service.v1.Environments.GetEnvironment:input_type -> google.cloud.orchestration.airflow.service.v1.GetEnvironmentRequest
	7,  // 43: google.cloud.orchestration.airflow.service.v1.Environments.ListEnvironments:input_type -> google.cloud.orchestration.airflow.service.v1.ListEnvironmentsRequest
	10, // 44: google.cloud.orchestration.airflow.service.v1.Environments.UpdateEnvironment:input_type -> google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest
	9,  // 45: google.cloud.orchestration.airflow.service.v1.Environments.DeleteEnvironment:input_type -> google.cloud.orchestration.airflow.service.v1.DeleteEnvironmentRequest
	11, // 46: google.cloud.orchestration.airflow.service.v1.Environments.ExecuteAirflowCommand:input_type -> google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandRequest
	13, // 47: google.cloud.orchestration.airflow.service.v1.Environments.StopAirflowCommand:input_type -> google.cloud.orchestration.airflow.service.v1.StopAirflowCommandRequest
	15, // 48: google.cloud.orchestration.airflow.service.v1.Environments.PollAirflowCommand:input_type -> google.cloud.orchestration.airflow.service.v1.PollAirflowCommandRequest
	17, // 49: google.cloud.orchestration.airflow.service.v1.Environments.SaveSnapshot:input_type -> google.cloud.orchestration.airflow.service.v1.SaveSnapshotRequest
	19, // 50: google.cloud.orchestration.airflow.service.v1.Environments.LoadSnapshot:input_type -> google.cloud.orchestration.airflow.service.v1.LoadSnapshotRequest
	21, // 51: google.cloud.orchestration.airflow.service.v1.Environments.DatabaseFailover:input_type -> google.cloud.orchestration.airflow.service.v1.DatabaseFailoverRequest
	23, // 52: google.cloud.orchestration.airflow.service.v1.Environments.FetchDatabaseProperties:input_type -> google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesRequest
	57, // 53: google.cloud.orchestration.airflow.service.v1.Environments.CreateEnvironment:output_type -> google.longrunning.Operation
	41, // 54: google.cloud.orchestration.airflow.service.v1.Environments.GetEnvironment:output_type -> google.cloud.orchestration.airflow.service.v1.Environment
	8,  // 55: google.cloud.orchestration.airflow.service.v1.Environments.ListEnvironments:output_type -> google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse
	57, // 56: google.cloud.orchestration.airflow.service.v1.Environments.UpdateEnvironment:output_type -> google.longrunning.Operation
	57, // 57: google.cloud.orchestration.airflow.service.v1.Environments.DeleteEnvironment:output_type -> google.longrunning.Operation
	12, // 58: google.cloud.orchestration.airflow.service.v1.Environments.ExecuteAirflowCommand:output_type -> google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandResponse
	14, // 59: google.cloud.orchestration.airflow.service.v1.Environments.StopAirflowCommand:output_type -> google.cloud.orchestration.airflow.service.v1.StopAirflowCommandResponse
	16, // 60: google.cloud.orchestration.airflow.service.v1.Environments.PollAirflowCommand:output_type -> google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse
	57, // 61: google.cloud.orchestration.airflow.service.v1.Environments.SaveSnapshot:output_type -> google.longrunning.Operation
	57, // 62: google.cloud.orchestration.airflow.service.v1.Environments.LoadSnapshot:output_type -> google.longrunning.Operation
	57, // 63: google.cloud.orchestration.airflow.service.v1.Environments.DatabaseFailover:output_type -> google.longrunning.Operation
	24, // 64: google.cloud.orchestration.airflow.service.v1.Environments.FetchDatabaseProperties:output_type -> google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesResponse
	53, // [53:65] is the sub-list for method output_type
	41, // [41:53] is the sub-list for method input_type
	41, // [41:41] is the sub-list for extension type_name
	41, // [41:41] is the sub-list for extension extendee
	0,  // [0:41] is the sub-list for field type_name
}

func init() { file_google_cloud_orchestration_airflow_service_v1_environments_proto_init() }
func file_google_cloud_orchestration_airflow_service_v1_environments_proto_init() {
	if File_google_cloud_orchestration_airflow_service_v1_environments_proto != nil {
		return
	}
	file_google_cloud_orchestration_airflow_service_v1_operations_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEnvironmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEnvironmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEnvironmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEnvironmentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEnvironmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEnvironmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteAirflowCommandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteAirflowCommandResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopAirflowCommandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopAirflowCommandResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollAirflowCommandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollAirflowCommandResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SaveSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SaveSnapshotResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadSnapshotResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseFailoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseFailoverResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDatabasePropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDatabasePropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvironmentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebServerNetworkAccessControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoftwareConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IPAllocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateEnvironmentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecoveryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScheduledSnapshotsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterAuthorizedNetworksConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Environment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckUpgradeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollAirflowCommandResponse_Line); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollAirflowCommandResponse_ExitInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebServerNetworkAccessControl_AllowedIpRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadsConfig_SchedulerResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadsConfig_WebServerResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadsConfig_WorkerResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterAuthorizedNetworksConfig_CidrBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*IPAllocationPolicy_ClusterSecondaryRangeName)(nil),
		(*IPAllocationPolicy_ClusterIpv4CidrBlock)(nil),
		(*IPAllocationPolicy_ServicesSecondaryRangeName)(nil),
		(*IPAllocationPolicy_ServicesIpv4CidrBlock)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_orchestration_airflow_service_v1_environments_proto_goTypes,
		DependencyIndexes: file_google_cloud_orchestration_airflow_service_v1_environments_proto_depIdxs,
		EnumInfos:         file_google_cloud_orchestration_airflow_service_v1_environments_proto_enumTypes,
		MessageInfos:      file_google_cloud_orchestration_airflow_service_v1_environments_proto_msgTypes,
	}.Build()
	File_google_cloud_orchestration_airflow_service_v1_environments_proto = out.File
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_rawDesc = nil
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_goTypes = nil
	file_google_cloud_orchestration_airflow_service_v1_environments_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EnvironmentsClient is the client API for Environments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EnvironmentsClient interface {
	// Create a new environment.
	CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get an existing environment.
	GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error)
	// List environments.
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
	// Update an environment.
	UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete an environment.
	DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Executes Airflow CLI command.
	ExecuteAirflowCommand(ctx context.Context, in *ExecuteAirflowCommandRequest, opts ...grpc.CallOption) (*ExecuteAirflowCommandResponse, error)
	// Stops Airflow CLI command execution.
	StopAirflowCommand(ctx context.Context, in *StopAirflowCommandRequest, opts ...grpc.CallOption) (*StopAirflowCommandResponse, error)
	// Polls Airflow CLI command execution and fetches logs.
	PollAirflowCommand(ctx context.Context, in *PollAirflowCommandRequest, opts ...grpc.CallOption) (*PollAirflowCommandResponse, error)
	// Creates a snapshots of a Cloud Composer environment.
	//
	// As a result of this operation, snapshot of environment's state is stored
	// in a location specified in the SaveSnapshotRequest.
	SaveSnapshot(ctx context.Context, in *SaveSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Loads a snapshot of a Cloud Composer environment.
	//
	// As a result of this operation, a snapshot of environment's specified in
	// LoadSnapshotRequest is loaded into the environment.
	LoadSnapshot(ctx context.Context, in *LoadSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Triggers database failover (only for highly resilient environments).
	DatabaseFailover(ctx context.Context, in *DatabaseFailoverRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches database properties.
	FetchDatabaseProperties(ctx context.Context, in *FetchDatabasePropertiesRequest, opts ...grpc.CallOption) (*FetchDatabasePropertiesResponse, error)
}

type environmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewEnvironmentsClient(cc grpc.ClientConnInterface) EnvironmentsClient {
	return &environmentsClient{cc}
}

func (c *environmentsClient) CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/CreateEnvironment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error) {
	out := new(Environment)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/GetEnvironment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/ListEnvironments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/UpdateEnvironment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/DeleteEnvironment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ExecuteAirflowCommand(ctx context.Context, in *ExecuteAirflowCommandRequest, opts ...grpc.CallOption) (*ExecuteAirflowCommandResponse, error) {
	out := new(ExecuteAirflowCommandResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/ExecuteAirflowCommand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) StopAirflowCommand(ctx context.Context, in *StopAirflowCommandRequest, opts ...grpc.CallOption) (*StopAirflowCommandResponse, error) {
	out := new(StopAirflowCommandResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/StopAirflowCommand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) PollAirflowCommand(ctx context.Context, in *PollAirflowCommandRequest, opts ...grpc.CallOption) (*PollAirflowCommandResponse, error) {
	out := new(PollAirflowCommandResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/PollAirflowCommand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) SaveSnapshot(ctx context.Context, in *SaveSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/SaveSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) LoadSnapshot(ctx context.Context, in *LoadSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/LoadSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DatabaseFailover(ctx context.Context, in *DatabaseFailoverRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/DatabaseFailover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) FetchDatabaseProperties(ctx context.Context, in *FetchDatabasePropertiesRequest, opts ...grpc.CallOption) (*FetchDatabasePropertiesResponse, error) {
	out := new(FetchDatabasePropertiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.orchestration.airflow.service.v1.Environments/FetchDatabaseProperties", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EnvironmentsServer is the server API for Environments service.
type EnvironmentsServer interface {
	// Create a new environment.
	CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Get an existing environment.
	GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error)
	// List environments.
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
	// Update an environment.
	UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Delete an environment.
	DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error)
	// Executes Airflow CLI command.
	ExecuteAirflowCommand(context.Context, *ExecuteAirflowCommandRequest) (*ExecuteAirflowCommandResponse, error)
	// Stops Airflow CLI command execution.
	StopAirflowCommand(context.Context, *StopAirflowCommandRequest) (*StopAirflowCommandResponse, error)
	// Polls Airflow CLI command execution and fetches logs.
	PollAirflowCommand(context.Context, *PollAirflowCommandRequest) (*PollAirflowCommandResponse, error)
	// Creates a snapshots of a Cloud Composer environment.
	//
	// As a result of this operation, snapshot of environment's state is stored
	// in a location specified in the SaveSnapshotRequest.
	SaveSnapshot(context.Context, *SaveSnapshotRequest) (*longrunningpb.Operation, error)
	// Loads a snapshot of a Cloud Composer environment.
	//
	// As a result of this operation, a snapshot of environment's specified in
	// LoadSnapshotRequest is loaded into the environment.
	LoadSnapshot(context.Context, *LoadSnapshotRequest) (*longrunningpb.Operation, error)
	// Triggers database failover (only for highly resilient environments).
	DatabaseFailover(context.Context, *DatabaseFailoverRequest) (*longrunningpb.Operation, error)
	// Fetches database properties.
	FetchDatabaseProperties(context.Context, *FetchDatabasePropertiesRequest) (*FetchDatabasePropertiesResponse, error)
}

// UnimplementedEnvironmentsServer can be embedded to have forward compatible implementations.
type UnimplementedEnvironmentsServer struct {
}

func (*UnimplementedEnvironmentsServer) CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEnvironment not implemented")
}
func (*UnimplementedEnvironmentsServer) GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnvironment not implemented")
}
func (*UnimplementedEnvironmentsServer) ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}
func (*UnimplementedEnvironmentsServer) UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnvironment not implemented")
}
func (*UnimplementedEnvironmentsServer) DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEnvironment not implemented")
}
func (*UnimplementedEnvironmentsServer) ExecuteAirflowCommand(context.Context, *ExecuteAirflowCommandRequest) (*ExecuteAirflowCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteAirflowCommand not implemented")
}
func (*UnimplementedEnvironmentsServer) StopAirflowCommand(context.Context, *StopAirflowCommandRequest) (*StopAirflowCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopAirflowCommand not implemented")
}
func (*UnimplementedEnvironmentsServer) PollAirflowCommand(context.Context, *PollAirflowCommandRequest) (*PollAirflowCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollAirflowCommand not implemented")
}
func (*UnimplementedEnvironmentsServer) SaveSnapshot(context.Context, *SaveSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SaveSnapshot not implemented")
}
func (*UnimplementedEnvironmentsServer) LoadSnapshot(context.Context, *LoadSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadSnapshot not implemented")
}
func (*UnimplementedEnvironmentsServer) DatabaseFailover(context.Context, *DatabaseFailoverRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DatabaseFailover not implemented")
}
func (*UnimplementedEnvironmentsServer) FetchDatabaseProperties(context.Context, *FetchDatabasePropertiesRequest) (*FetchDatabasePropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchDatabaseProperties not implemented")
}

func RegisterEnvironmentsServer(s *grpc.Server, srv EnvironmentsServer) {
	s.RegisterService(&_Environments_serviceDesc, srv)
}

func _Environments_CreateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).CreateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/CreateEnvironment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).CreateEnvironment(ctx, req.(*CreateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_GetEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).GetEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/GetEnvironment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).GetEnvironment(ctx, req.(*GetEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/ListEnvironments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_UpdateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).UpdateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/UpdateEnvironment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).UpdateEnvironment(ctx, req.(*UpdateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DeleteEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DeleteEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/DeleteEnvironment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DeleteEnvironment(ctx, req.(*DeleteEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ExecuteAirflowCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteAirflowCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ExecuteAirflowCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/ExecuteAirflowCommand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ExecuteAirflowCommand(ctx, req.(*ExecuteAirflowCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_StopAirflowCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopAirflowCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).StopAirflowCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/StopAirflowCommand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).StopAirflowCommand(ctx, req.(*StopAirflowCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_PollAirflowCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollAirflowCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).PollAirflowCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/PollAirflowCommand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).PollAirflowCommand(ctx, req.(*PollAirflowCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_SaveSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SaveSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).SaveSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/SaveSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).SaveSnapshot(ctx, req.(*SaveSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_LoadSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).LoadSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/LoadSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).LoadSnapshot(ctx, req.(*LoadSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DatabaseFailover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DatabaseFailoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DatabaseFailover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/DatabaseFailover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DatabaseFailover(ctx, req.(*DatabaseFailoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_FetchDatabaseProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchDatabasePropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).FetchDatabaseProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.orchestration.airflow.service.v1.Environments/FetchDatabaseProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).FetchDatabaseProperties(ctx, req.(*FetchDatabasePropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Environments_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.orchestration.airflow.service.v1.Environments",
	HandlerType: (*EnvironmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEnvironment",
			Handler:    _Environments_CreateEnvironment_Handler,
		},
		{
			MethodName: "GetEnvironment",
			Handler:    _Environments_GetEnvironment_Handler,
		},
		{
			MethodName: "ListEnvironments",
			Handler:    _Environments_ListEnvironments_Handler,
		},
		{
			MethodName: "UpdateEnvironment",
			Handler:    _Environments_UpdateEnvironment_Handler,
		},
		{
			MethodName: "DeleteEnvironment",
			Handler:    _Environments_DeleteEnvironment_Handler,
		},
		{
			MethodName: "ExecuteAirflowCommand",
			Handler:    _Environments_ExecuteAirflowCommand_Handler,
		},
		{
			MethodName: "StopAirflowCommand",
			Handler:    _Environments_StopAirflowCommand_Handler,
		},
		{
			MethodName: "PollAirflowCommand",
			Handler:    _Environments_PollAirflowCommand_Handler,
		},
		{
			MethodName: "SaveSnapshot",
			Handler:    _Environments_SaveSnapshot_Handler,
		},
		{
			MethodName: "LoadSnapshot",
			Handler:    _Environments_LoadSnapshot_Handler,
		},
		{
			MethodName: "DatabaseFailover",
			Handler:    _Environments_DatabaseFailover_Handler,
		},
		{
			MethodName: "FetchDatabaseProperties",
			Handler:    _Environments_FetchDatabaseProperties_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/orchestration/airflow/service/v1/environments.proto",
}
