// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/tpu/v1/cloud_tpu.proto

package tpupb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the different states of a TPU node during its lifecycle.
type Node_State int32

const (
	// TPU node state is not known/set.
	Node_STATE_UNSPECIFIED Node_State = 0
	// TPU node is being created.
	Node_CREATING Node_State = 1
	// TPU node has been created.
	Node_READY Node_State = 2
	// TPU node is restarting.
	Node_RESTARTING Node_State = 3
	// TPU node is undergoing reimaging.
	Node_REIMAGING Node_State = 4
	// TPU node is being deleted.
	Node_DELETING Node_State = 5
	// TPU node is being repaired and may be unusable. Details can be
	// found in the `help_description` field.
	Node_REPAIRING Node_State = 6
	// TPU node is stopped.
	Node_STOPPED Node_State = 8
	// TPU node is currently stopping.
	Node_STOPPING Node_State = 9
	// TPU node is currently starting.
	Node_STARTING Node_State = 10
	// TPU node has been preempted. Only applies to Preemptible TPU Nodes.
	Node_PREEMPTED Node_State = 11
	// TPU node has been terminated due to maintenance or has reached the end of
	// its life cycle (for preemptible nodes).
	Node_TERMINATED Node_State = 12
	// TPU node is currently hiding.
	Node_HIDING Node_State = 13
	// TPU node has been hidden.
	Node_HIDDEN Node_State = 14
	// TPU node is currently unhiding.
	Node_UNHIDING Node_State = 15
)

// Enum value maps for Node_State.
var (
	Node_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "CREATING",
		2:  "READY",
		3:  "RESTARTING",
		4:  "REIMAGING",
		5:  "DELETING",
		6:  "REPAIRING",
		8:  "STOPPED",
		9:  "STOPPING",
		10: "STARTING",
		11: "PREEMPTED",
		12: "TERMINATED",
		13: "HIDING",
		14: "HIDDEN",
		15: "UNHIDING",
	}
	Node_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"RESTARTING":        3,
		"REIMAGING":         4,
		"DELETING":          5,
		"REPAIRING":         6,
		"STOPPED":           8,
		"STOPPING":          9,
		"STARTING":          10,
		"PREEMPTED":         11,
		"TERMINATED":        12,
		"HIDING":            13,
		"HIDDEN":            14,
		"UNHIDING":          15,
	}
)

func (x Node_State) Enum() *Node_State {
	p := new(Node_State)
	*p = x
	return p
}

func (x Node_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Node_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[0].Descriptor()
}

func (Node_State) Type() protoreflect.EnumType {
	return &file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[0]
}

func (x Node_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Node_State.Descriptor instead.
func (Node_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{2, 0}
}

// Health defines the status of a TPU node as reported by
// Health Monitor.
type Node_Health int32

const (
	// Health status is unknown: not initialized or failed to retrieve.
	Node_HEALTH_UNSPECIFIED Node_Health = 0
	// The resource is healthy.
	Node_HEALTHY Node_Health = 1
	// The resource is unhealthy.
	Node_DEPRECATED_UNHEALTHY Node_Health = 2
	// The resource is unresponsive.
	Node_TIMEOUT Node_Health = 3
	// The in-guest ML stack is unhealthy.
	Node_UNHEALTHY_TENSORFLOW Node_Health = 4
	// The node is under maintenance/priority boost caused rescheduling and
	// will resume running once rescheduled.
	Node_UNHEALTHY_MAINTENANCE Node_Health = 5
)

// Enum value maps for Node_Health.
var (
	Node_Health_name = map[int32]string{
		0: "HEALTH_UNSPECIFIED",
		1: "HEALTHY",
		2: "DEPRECATED_UNHEALTHY",
		3: "TIMEOUT",
		4: "UNHEALTHY_TENSORFLOW",
		5: "UNHEALTHY_MAINTENANCE",
	}
	Node_Health_value = map[string]int32{
		"HEALTH_UNSPECIFIED":    0,
		"HEALTHY":               1,
		"DEPRECATED_UNHEALTHY":  2,
		"TIMEOUT":               3,
		"UNHEALTHY_TENSORFLOW":  4,
		"UNHEALTHY_MAINTENANCE": 5,
	}
)

func (x Node_Health) Enum() *Node_Health {
	p := new(Node_Health)
	*p = x
	return p
}

func (x Node_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Node_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[1].Descriptor()
}

func (Node_Health) Type() protoreflect.EnumType {
	return &file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[1]
}

func (x Node_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Node_Health.Descriptor instead.
func (Node_Health) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{2, 1}
}

// TPU API Version.
type Node_ApiVersion int32

const (
	// API version is unknown.
	Node_API_VERSION_UNSPECIFIED Node_ApiVersion = 0
	// TPU API V1Alpha1 version.
	Node_V1_ALPHA1 Node_ApiVersion = 1
	// TPU API V1 version.
	Node_V1 Node_ApiVersion = 2
	// TPU API V2Alpha1 version.
	Node_V2_ALPHA1 Node_ApiVersion = 3
)

// Enum value maps for Node_ApiVersion.
var (
	Node_ApiVersion_name = map[int32]string{
		0: "API_VERSION_UNSPECIFIED",
		1: "V1_ALPHA1",
		2: "V1",
		3: "V2_ALPHA1",
	}
	Node_ApiVersion_value = map[string]int32{
		"API_VERSION_UNSPECIFIED": 0,
		"V1_ALPHA1":               1,
		"V1":                      2,
		"V2_ALPHA1":               3,
	}
)

func (x Node_ApiVersion) Enum() *Node_ApiVersion {
	p := new(Node_ApiVersion)
	*p = x
	return p
}

func (x Node_ApiVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Node_ApiVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[2].Descriptor()
}

func (Node_ApiVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[2]
}

func (x Node_ApiVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Node_ApiVersion.Descriptor instead.
func (Node_ApiVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{2, 2}
}

// SymptomType represents the different types of Symptoms that a TPU can be
// at.
type Symptom_SymptomType int32

const (
	// Unspecified symptom.
	Symptom_SYMPTOM_TYPE_UNSPECIFIED Symptom_SymptomType = 0
	// TPU VM memory is low.
	Symptom_LOW_MEMORY Symptom_SymptomType = 1
	// TPU runtime is out of memory.
	Symptom_OUT_OF_MEMORY Symptom_SymptomType = 2
	// TPU runtime execution has timed out.
	Symptom_EXECUTE_TIMED_OUT Symptom_SymptomType = 3
	// TPU runtime fails to construct a mesh that recognizes each TPU device's
	// neighbors.
	Symptom_MESH_BUILD_FAIL Symptom_SymptomType = 4
	// TPU HBM is out of memory.
	Symptom_HBM_OUT_OF_MEMORY Symptom_SymptomType = 5
	// Abusive behaviors have been identified on the current project.
	Symptom_PROJECT_ABUSE Symptom_SymptomType = 6
)

// Enum value maps for Symptom_SymptomType.
var (
	Symptom_SymptomType_name = map[int32]string{
		0: "SYMPTOM_TYPE_UNSPECIFIED",
		1: "LOW_MEMORY",
		2: "OUT_OF_MEMORY",
		3: "EXECUTE_TIMED_OUT",
		4: "MESH_BUILD_FAIL",
		5: "HBM_OUT_OF_MEMORY",
		6: "PROJECT_ABUSE",
	}
	Symptom_SymptomType_value = map[string]int32{
		"SYMPTOM_TYPE_UNSPECIFIED": 0,
		"LOW_MEMORY":               1,
		"OUT_OF_MEMORY":            2,
		"EXECUTE_TIMED_OUT":        3,
		"MESH_BUILD_FAIL":          4,
		"HBM_OUT_OF_MEMORY":        5,
		"PROJECT_ABUSE":            6,
	}
)

func (x Symptom_SymptomType) Enum() *Symptom_SymptomType {
	p := new(Symptom_SymptomType)
	*p = x
	return p
}

func (x Symptom_SymptomType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Symptom_SymptomType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[3].Descriptor()
}

func (Symptom_SymptomType) Type() protoreflect.EnumType {
	return &file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes[3]
}

func (x Symptom_SymptomType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Symptom_SymptomType.Descriptor instead.
func (Symptom_SymptomType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{20, 0}
}

// Sets the scheduling options for this node.
type SchedulingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the node is preemptible.
	Preemptible bool `protobuf:"varint,1,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// Whether the node is created under a reservation.
	Reserved bool `protobuf:"varint,2,opt,name=reserved,proto3" json:"reserved,omitempty"`
}

func (x *SchedulingConfig) Reset() {
	*x = SchedulingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchedulingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulingConfig) ProtoMessage() {}

func (x *SchedulingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulingConfig.ProtoReflect.Descriptor instead.
func (*SchedulingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{0}
}

func (x *SchedulingConfig) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *SchedulingConfig) GetReserved() bool {
	if x != nil {
		return x.Reserved
	}
	return false
}

// A network endpoint over which a TPU worker can be reached.
type NetworkEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP address of this network endpoint.
	IpAddress string `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// The port of this network endpoint.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *NetworkEndpoint) Reset() {
	*x = NetworkEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkEndpoint) ProtoMessage() {}

func (x *NetworkEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkEndpoint.ProtoReflect.Descriptor instead.
func (*NetworkEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{1}
}

func (x *NetworkEndpoint) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *NetworkEndpoint) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// A TPU instance.
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The name of the TPU
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-supplied description of the TPU. Maximum of 512 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The type of hardware accelerators associated with this node.
	AcceleratorType string `protobuf:"bytes,5,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
	// Output only. DEPRECATED! Use network_endpoints instead.
	// The network address for the TPU Node as visible to Compute Engine
	// instances.
	//
	// Deprecated: Marked as deprecated in google/cloud/tpu/v1/cloud_tpu.proto.
	IpAddress string `protobuf:"bytes,8,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Output only. DEPRECATED! Use network_endpoints instead.
	// The network port for the TPU Node as visible to Compute Engine instances.
	//
	// Deprecated: Marked as deprecated in google/cloud/tpu/v1/cloud_tpu.proto.
	Port string `protobuf:"bytes,14,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current state for the TPU Node.
	State Node_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.tpu.v1.Node_State" json:"state,omitempty"`
	// Output only. If this field is populated, it contains a description of why
	// the TPU Node is unhealthy.
	HealthDescription string `protobuf:"bytes,10,opt,name=health_description,json=healthDescription,proto3" json:"health_description,omitempty"`
	// Required. The version of Tensorflow running in the Node.
	TensorflowVersion string `protobuf:"bytes,11,opt,name=tensorflow_version,json=tensorflowVersion,proto3" json:"tensorflow_version,omitempty"`
	// The name of a network they wish to peer the TPU node to. It must be a
	// preexisting Compute Engine network inside of the project on which this API
	// has been activated. If none is provided, "default" will be used.
	Network string `protobuf:"bytes,12,opt,name=network,proto3" json:"network,omitempty"`
	// The CIDR block that the TPU node will use when selecting an IP address.
	// This CIDR block must be a /29 block; the Compute Engine networks API
	// forbids a smaller block, and using a larger block would be wasteful (a
	// node can only consume one IP address). Errors will occur if the CIDR block
	// has already been used for a currently existing TPU node, the CIDR block
	// conflicts with any subnetworks in the user's provided network, or the
	// provided network is peered with another network that is using that CIDR
	// block.
	CidrBlock string `protobuf:"bytes,13,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
	// Output only. The service account used to run the tensor flow services
	// within the node. To share resources, including Google Cloud Storage data,
	// with the Tensorflow job running in the Node, this account must have
	// permissions to that data.
	ServiceAccount string `protobuf:"bytes,15,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. The time when the node was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The scheduling options for this node.
	SchedulingConfig *SchedulingConfig `protobuf:"bytes,17,opt,name=scheduling_config,json=schedulingConfig,proto3" json:"scheduling_config,omitempty"`
	// Output only. The network endpoints where TPU workers can be accessed and
	// sent work. It is recommended that Tensorflow clients of the node reach out
	// to the 0th entry in this map first.
	NetworkEndpoints []*NetworkEndpoint `protobuf:"bytes,21,rep,name=network_endpoints,json=networkEndpoints,proto3" json:"network_endpoints,omitempty"`
	// The health status of the TPU node.
	Health Node_Health `protobuf:"varint,22,opt,name=health,proto3,enum=google.cloud.tpu.v1.Node_Health" json:"health,omitempty"`
	// Resource labels to represent user-provided metadata.
	Labels map[string]string `protobuf:"bytes,24,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether the VPC peering for the node is set up through Service Networking
	// API. The VPC Peering should be set up before provisioning the node.
	// If this field is set, cidr_block field should not be specified. If the
	// network, that you want to peer the TPU Node to, is Shared VPC networks,
	// the node must be created with this this field enabled.
	UseServiceNetworking bool `protobuf:"varint,27,opt,name=use_service_networking,json=useServiceNetworking,proto3" json:"use_service_networking,omitempty"`
	// Output only. The API version that created this Node.
	ApiVersion Node_ApiVersion `protobuf:"varint,38,opt,name=api_version,json=apiVersion,proto3,enum=google.cloud.tpu.v1.Node_ApiVersion" json:"api_version,omitempty"`
	// Output only. The Symptoms that have occurred to the TPU Node.
	Symptoms []*Symptom `protobuf:"bytes,39,rep,name=symptoms,proto3" json:"symptoms,omitempty"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{2}
}

func (x *Node) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Node) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Node) GetAcceleratorType() string {
	if x != nil {
		return x.AcceleratorType
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/tpu/v1/cloud_tpu.proto.
func (x *Node) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/tpu/v1/cloud_tpu.proto.
func (x *Node) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *Node) GetState() Node_State {
	if x != nil {
		return x.State
	}
	return Node_STATE_UNSPECIFIED
}

func (x *Node) GetHealthDescription() string {
	if x != nil {
		return x.HealthDescription
	}
	return ""
}

func (x *Node) GetTensorflowVersion() string {
	if x != nil {
		return x.TensorflowVersion
	}
	return ""
}

func (x *Node) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Node) GetCidrBlock() string {
	if x != nil {
		return x.CidrBlock
	}
	return ""
}

func (x *Node) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Node) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Node) GetSchedulingConfig() *SchedulingConfig {
	if x != nil {
		return x.SchedulingConfig
	}
	return nil
}

func (x *Node) GetNetworkEndpoints() []*NetworkEndpoint {
	if x != nil {
		return x.NetworkEndpoints
	}
	return nil
}

func (x *Node) GetHealth() Node_Health {
	if x != nil {
		return x.Health
	}
	return Node_HEALTH_UNSPECIFIED
}

func (x *Node) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Node) GetUseServiceNetworking() bool {
	if x != nil {
		return x.UseServiceNetworking
	}
	return false
}

func (x *Node) GetApiVersion() Node_ApiVersion {
	if x != nil {
		return x.ApiVersion
	}
	return Node_API_VERSION_UNSPECIFIED
}

func (x *Node) GetSymptoms() []*Symptom {
	if x != nil {
		return x.Symptoms
	}
	return nil
}

// Request for [ListNodes][google.cloud.tpu.v1.Tpu.ListNodes].
type ListNodesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNodesRequest) Reset() {
	*x = ListNodesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodesRequest) ProtoMessage() {}

func (x *ListNodesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodesRequest.ProtoReflect.Descriptor instead.
func (*ListNodesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{3}
}

func (x *ListNodesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNodesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNodesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for [ListNodes][google.cloud.tpu.v1.Tpu.ListNodes].
type ListNodesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The listed nodes.
	Nodes []*Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// The next page token or empty if none.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNodesResponse) Reset() {
	*x = ListNodesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodesResponse) ProtoMessage() {}

func (x *ListNodesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodesResponse.ProtoReflect.Descriptor instead.
func (*ListNodesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{4}
}

func (x *ListNodesResponse) GetNodes() []*Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *ListNodesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNodesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [GetNode][google.cloud.tpu.v1.Tpu.GetNode].
type GetNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNodeRequest) Reset() {
	*x = GetNodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodeRequest) ProtoMessage() {}

func (x *GetNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodeRequest.ProtoReflect.Descriptor instead.
func (*GetNodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{5}
}

func (x *GetNodeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [CreateNode][google.cloud.tpu.v1.Tpu.CreateNode].
type CreateNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The unqualified resource name.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Required. The node.
	Node *Node `protobuf:"bytes,3,opt,name=node,proto3" json:"node,omitempty"`
}

func (x *CreateNodeRequest) Reset() {
	*x = CreateNodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNodeRequest) ProtoMessage() {}

func (x *CreateNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNodeRequest.ProtoReflect.Descriptor instead.
func (*CreateNodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{6}
}

func (x *CreateNodeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNodeRequest) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (x *CreateNodeRequest) GetNode() *Node {
	if x != nil {
		return x.Node
	}
	return nil
}

// Request for [DeleteNode][google.cloud.tpu.v1.Tpu.DeleteNode].
type DeleteNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNodeRequest) Reset() {
	*x = DeleteNodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNodeRequest) ProtoMessage() {}

func (x *DeleteNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNodeRequest.ProtoReflect.Descriptor instead.
func (*DeleteNodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteNodeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [ReimageNode][google.cloud.tpu.v1.Tpu.ReimageNode].
type ReimageNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version for reimage to create.
	TensorflowVersion string `protobuf:"bytes,2,opt,name=tensorflow_version,json=tensorflowVersion,proto3" json:"tensorflow_version,omitempty"`
}

func (x *ReimageNodeRequest) Reset() {
	*x = ReimageNodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReimageNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReimageNodeRequest) ProtoMessage() {}

func (x *ReimageNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReimageNodeRequest.ProtoReflect.Descriptor instead.
func (*ReimageNodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{8}
}

func (x *ReimageNodeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReimageNodeRequest) GetTensorflowVersion() string {
	if x != nil {
		return x.TensorflowVersion
	}
	return ""
}

// Request for [StopNode][google.cloud.tpu.v1.Tpu.StopNode].
type StopNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StopNodeRequest) Reset() {
	*x = StopNodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopNodeRequest) ProtoMessage() {}

func (x *StopNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopNodeRequest.ProtoReflect.Descriptor instead.
func (*StopNodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{9}
}

func (x *StopNodeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [StartNode][google.cloud.tpu.v1.Tpu.StartNode].
type StartNodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StartNodeRequest) Reset() {
	*x = StartNodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartNodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartNodeRequest) ProtoMessage() {}

func (x *StartNodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartNodeRequest.ProtoReflect.Descriptor instead.
func (*StartNodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{10}
}

func (x *StartNodeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A tensorflow version that a Node can be configured with.
type TensorFlowVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// the tensorflow version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *TensorFlowVersion) Reset() {
	*x = TensorFlowVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TensorFlowVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TensorFlowVersion) ProtoMessage() {}

func (x *TensorFlowVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TensorFlowVersion.ProtoReflect.Descriptor instead.
func (*TensorFlowVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{11}
}

func (x *TensorFlowVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TensorFlowVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Request for
// [GetTensorFlowVersion][google.cloud.tpu.v1.Tpu.GetTensorFlowVersion].
type GetTensorFlowVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTensorFlowVersionRequest) Reset() {
	*x = GetTensorFlowVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTensorFlowVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTensorFlowVersionRequest) ProtoMessage() {}

func (x *GetTensorFlowVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTensorFlowVersionRequest.ProtoReflect.Descriptor instead.
func (*GetTensorFlowVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{12}
}

func (x *GetTensorFlowVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [ListTensorFlowVersions][google.cloud.tpu.v1.Tpu.ListTensorFlowVersions].
type ListTensorFlowVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort results.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTensorFlowVersionsRequest) Reset() {
	*x = ListTensorFlowVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorFlowVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorFlowVersionsRequest) ProtoMessage() {}

func (x *ListTensorFlowVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorFlowVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListTensorFlowVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{13}
}

func (x *ListTensorFlowVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTensorFlowVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTensorFlowVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTensorFlowVersionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTensorFlowVersionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for
// [ListTensorFlowVersions][google.cloud.tpu.v1.Tpu.ListTensorFlowVersions].
type ListTensorFlowVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The listed nodes.
	TensorflowVersions []*TensorFlowVersion `protobuf:"bytes,1,rep,name=tensorflow_versions,json=tensorflowVersions,proto3" json:"tensorflow_versions,omitempty"`
	// The next page token or empty if none.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTensorFlowVersionsResponse) Reset() {
	*x = ListTensorFlowVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorFlowVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorFlowVersionsResponse) ProtoMessage() {}

func (x *ListTensorFlowVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorFlowVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListTensorFlowVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{14}
}

func (x *ListTensorFlowVersionsResponse) GetTensorflowVersions() []*TensorFlowVersion {
	if x != nil {
		return x.TensorflowVersions
	}
	return nil
}

func (x *ListTensorFlowVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTensorFlowVersionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A accelerator type that a Node can be configured with.
type AcceleratorType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// the accelerator type.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *AcceleratorType) Reset() {
	*x = AcceleratorType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorType) ProtoMessage() {}

func (x *AcceleratorType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorType.ProtoReflect.Descriptor instead.
func (*AcceleratorType) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{15}
}

func (x *AcceleratorType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AcceleratorType) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Request for [GetAcceleratorType][google.cloud.tpu.v1.Tpu.GetAcceleratorType].
type GetAcceleratorTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAcceleratorTypeRequest) Reset() {
	*x = GetAcceleratorTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAcceleratorTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAcceleratorTypeRequest) ProtoMessage() {}

func (x *GetAcceleratorTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAcceleratorTypeRequest.ProtoReflect.Descriptor instead.
func (*GetAcceleratorTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{16}
}

func (x *GetAcceleratorTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for
// [ListAcceleratorTypes][google.cloud.tpu.v1.Tpu.ListAcceleratorTypes].
type ListAcceleratorTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort results.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAcceleratorTypesRequest) Reset() {
	*x = ListAcceleratorTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAcceleratorTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAcceleratorTypesRequest) ProtoMessage() {}

func (x *ListAcceleratorTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAcceleratorTypesRequest.ProtoReflect.Descriptor instead.
func (*ListAcceleratorTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{17}
}

func (x *ListAcceleratorTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAcceleratorTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAcceleratorTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAcceleratorTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAcceleratorTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for
// [ListAcceleratorTypes][google.cloud.tpu.v1.Tpu.ListAcceleratorTypes].
type ListAcceleratorTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The listed nodes.
	AcceleratorTypes []*AcceleratorType `protobuf:"bytes,1,rep,name=accelerator_types,json=acceleratorTypes,proto3" json:"accelerator_types,omitempty"`
	// The next page token or empty if none.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAcceleratorTypesResponse) Reset() {
	*x = ListAcceleratorTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAcceleratorTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAcceleratorTypesResponse) ProtoMessage() {}

func (x *ListAcceleratorTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAcceleratorTypesResponse.ProtoReflect.Descriptor instead.
func (*ListAcceleratorTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{18}
}

func (x *ListAcceleratorTypesResponse) GetAcceleratorTypes() []*AcceleratorType {
	if x != nil {
		return x.AcceleratorTypes
	}
	return nil
}

func (x *ListAcceleratorTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAcceleratorTypesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Metadata describing an [Operation][google.longrunning.Operation]
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Target of the operation - for example
	// projects/project-1/connectivityTests/test-1
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Specifies if cancellation was requested for the operation.
	CancelRequested bool `protobuf:"varint,6,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	// API version.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{19}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *OperationMetadata) GetCancelRequested() bool {
	if x != nil {
		return x.CancelRequested
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// A Symptom instance.
type Symptom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when the Symptom is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Type of the Symptom.
	SymptomType Symptom_SymptomType `protobuf:"varint,2,opt,name=symptom_type,json=symptomType,proto3,enum=google.cloud.tpu.v1.Symptom_SymptomType" json:"symptom_type,omitempty"`
	// Detailed information of the current Symptom.
	Details string `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
	// A string used to uniquely distinguish a worker within a TPU node.
	WorkerId string `protobuf:"bytes,4,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
}

func (x *Symptom) Reset() {
	*x = Symptom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Symptom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Symptom) ProtoMessage() {}

func (x *Symptom) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Symptom.ProtoReflect.Descriptor instead.
func (*Symptom) Descriptor() ([]byte, []int) {
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP(), []int{20}
}

func (x *Symptom) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Symptom) GetSymptomType() Symptom_SymptomType {
	if x != nil {
		return x.SymptomType
	}
	return Symptom_SYMPTOM_TYPE_UNSPECIFIED
}

func (x *Symptom) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

func (x *Symptom) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

var File_google_cloud_tpu_v1_cloud_tpu_proto protoreflect.FileDescriptor

var file_google_cloud_tpu_v1_cloud_tpu_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x70, 0x75, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x74, 0x70, 0x75, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x50, 0x0a, 0x10, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d,
	0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x64, 0x22, 0x44, 0x0a, 0x0f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xb2, 0x0c, 0x0a, 0x04,
	0x4e, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x16, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3a, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x12, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a,
	0x12, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x63, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x11, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56,
	0x0a, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x12, 0x3d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x34, 0x0a, 0x16, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x75, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3d, 0x0a, 0x08, 0x73, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x73, 0x18, 0x27, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6d, 0x70, 0x74, 0x6f,
	0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe1, 0x01, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x49, 0x4d, 0x41, 0x47, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10,
	0x06, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52,
	0x45, 0x45, 0x4d, 0x50, 0x54, 0x45, 0x44, 0x10, 0x0b, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x52,
	0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x0c, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x49, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x0d, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x49, 0x44, 0x44, 0x45, 0x4e, 0x10,
	0x0e, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x48, 0x49, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x0f, 0x22,
	0x89, 0x01, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x12, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x01, 0x12,
	0x18, 0x0a, 0x14, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x55, 0x4e,
	0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x49, 0x4d,
	0x45, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x55, 0x4e, 0x48, 0x45, 0x41, 0x4c,
	0x54, 0x48, 0x59, 0x5f, 0x54, 0x45, 0x4e, 0x53, 0x4f, 0x52, 0x46, 0x4c, 0x4f, 0x57, 0x10, 0x04,
	0x12, 0x19, 0x0a, 0x15, 0x55, 0x4e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x5f, 0x4d, 0x41,
	0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x05, 0x22, 0x4f, 0x0a, 0x0a, 0x41,
	0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x50, 0x49,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x31, 0x5f, 0x41, 0x4c, 0x50,
	0x48, 0x41, 0x31, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x31, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x56, 0x32, 0x5f, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x31, 0x10, 0x03, 0x3a, 0x52, 0xea, 0x41,
	0x4f, 0x0a, 0x17, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x7d,
	0x22, 0x87, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x12, 0x17, 0x74,
	0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2f, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x45, 0x0a, 0x0e, 0x47,
	0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x19, 0x0a, 0x17, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19,
	0x12, 0x17, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x04, 0x6e, 0x6f,
	0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x22, 0x48,
	0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x0a, 0x17, 0x74, 0x70, 0x75, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f,
	0x64, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x57, 0x0a, 0x12, 0x52, 0x65, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x25, 0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x26, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xbe, 0x01, 0x0a, 0x11, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x24, 0x74, 0x70, 0x75, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46,
	0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x7d, 0x22, 0x5f, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c,
	0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x74, 0x70,
	0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc3, 0x01, 0x0a, 0x1e, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x13,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x12, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0xaf, 0x01, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x74, 0xea, 0x41, 0x71,
	0x0a, 0x22, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x7d, 0x22, 0x5b, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xbb, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x51, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0xa4, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf1, 0x02, 0x0a, 0x07, 0x53, 0x79, 0x6d, 0x70, 0x74,
	0x6f, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4b, 0x0a, 0x0c, 0x73, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6d, 0x70,
	0x74, 0x6f, 0x6d, 0x2e, 0x53, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x73, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x49, 0x64, 0x22, 0xa4, 0x01, 0x0a, 0x0b, 0x53, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x59, 0x4d, 0x50, 0x54, 0x4f, 0x4d, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x4f, 0x57, 0x5f, 0x4d, 0x45, 0x4d, 0x4f, 0x52, 0x59, 0x10,
	0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x4d, 0x45, 0x4d, 0x4f,
	0x52, 0x59, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x45, 0x5f,
	0x54, 0x49, 0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4d,
	0x45, 0x53, 0x48, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x10, 0x04,
	0x12, 0x15, 0x0a, 0x11, 0x48, 0x42, 0x4d, 0x5f, 0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x4d,
	0x45, 0x4d, 0x4f, 0x52, 0x59, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x4f, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x41, 0x42, 0x55, 0x53, 0x45, 0x10, 0x06, 0x32, 0xde, 0x0f, 0x0a, 0x03, 0x54,
	0x70, 0x75, 0x12, 0x96, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b,
	0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x07,
	0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x22, 0x38, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xbe, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xca, 0x41, 0x19, 0x0a, 0x04, 0x4e, 0x6f,
	0x64, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e,
	0x6f, 0x64, 0x65, 0x2c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x3a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0xa9, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0xca, 0x41, 0x19, 0x0a, 0x04, 0x4e,
	0x6f, 0x64, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2b, 0x2a, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf,
	0x01, 0x0a, 0x0b, 0x52, 0x65, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70,
	0x75, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x58, 0xca, 0x41, 0x19, 0x0a, 0x04, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x12, 0xa6, 0x01, 0x0a, 0x08, 0x53, 0x74, 0x6f, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x55, 0xca, 0x41, 0x19, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x01, 0x2a, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x12, 0xa9, 0x01, 0x0a, 0x09, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x56, 0xca,
	0x41, 0x19, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xca, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xb7, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0xaf, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x22, 0x43,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x74, 0x70, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x55, 0x0a, 0x17, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x70, 0x75, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x54, 0x70, 0x75,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x74, 0x70, 0x75,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x74, 0x70, 0x75, 0x70, 0x62, 0x3b, 0x74, 0x70, 0x75,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescOnce sync.Once
	file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescData = file_google_cloud_tpu_v1_cloud_tpu_proto_rawDesc
)

func file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescGZIP() []byte {
	file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescOnce.Do(func() {
		file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescData)
	})
	return file_google_cloud_tpu_v1_cloud_tpu_proto_rawDescData
}

var file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_tpu_v1_cloud_tpu_proto_goTypes = []interface{}{
	(Node_State)(0),                        // 0: google.cloud.tpu.v1.Node.State
	(Node_Health)(0),                       // 1: google.cloud.tpu.v1.Node.Health
	(Node_ApiVersion)(0),                   // 2: google.cloud.tpu.v1.Node.ApiVersion
	(Symptom_SymptomType)(0),               // 3: google.cloud.tpu.v1.Symptom.SymptomType
	(*SchedulingConfig)(nil),               // 4: google.cloud.tpu.v1.SchedulingConfig
	(*NetworkEndpoint)(nil),                // 5: google.cloud.tpu.v1.NetworkEndpoint
	(*Node)(nil),                           // 6: google.cloud.tpu.v1.Node
	(*ListNodesRequest)(nil),               // 7: google.cloud.tpu.v1.ListNodesRequest
	(*ListNodesResponse)(nil),              // 8: google.cloud.tpu.v1.ListNodesResponse
	(*GetNodeRequest)(nil),                 // 9: google.cloud.tpu.v1.GetNodeRequest
	(*CreateNodeRequest)(nil),              // 10: google.cloud.tpu.v1.CreateNodeRequest
	(*DeleteNodeRequest)(nil),              // 11: google.cloud.tpu.v1.DeleteNodeRequest
	(*ReimageNodeRequest)(nil),             // 12: google.cloud.tpu.v1.ReimageNodeRequest
	(*StopNodeRequest)(nil),                // 13: google.cloud.tpu.v1.StopNodeRequest
	(*StartNodeRequest)(nil),               // 14: google.cloud.tpu.v1.StartNodeRequest
	(*TensorFlowVersion)(nil),              // 15: google.cloud.tpu.v1.TensorFlowVersion
	(*GetTensorFlowVersionRequest)(nil),    // 16: google.cloud.tpu.v1.GetTensorFlowVersionRequest
	(*ListTensorFlowVersionsRequest)(nil),  // 17: google.cloud.tpu.v1.ListTensorFlowVersionsRequest
	(*ListTensorFlowVersionsResponse)(nil), // 18: google.cloud.tpu.v1.ListTensorFlowVersionsResponse
	(*AcceleratorType)(nil),                // 19: google.cloud.tpu.v1.AcceleratorType
	(*GetAcceleratorTypeRequest)(nil),      // 20: google.cloud.tpu.v1.GetAcceleratorTypeRequest
	(*ListAcceleratorTypesRequest)(nil),    // 21: google.cloud.tpu.v1.ListAcceleratorTypesRequest
	(*ListAcceleratorTypesResponse)(nil),   // 22: google.cloud.tpu.v1.ListAcceleratorTypesResponse
	(*OperationMetadata)(nil),              // 23: google.cloud.tpu.v1.OperationMetadata
	(*Symptom)(nil),                        // 24: google.cloud.tpu.v1.Symptom
	nil,                                    // 25: google.cloud.tpu.v1.Node.LabelsEntry
	(*timestamppb.Timestamp)(nil),          // 26: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),        // 27: google.longrunning.Operation
}
var file_google_cloud_tpu_v1_cloud_tpu_proto_depIdxs = []int32{
	0,  // 0: google.cloud.tpu.v1.Node.state:type_name -> google.cloud.tpu.v1.Node.State
	26, // 1: google.cloud.tpu.v1.Node.create_time:type_name -> google.protobuf.Timestamp
	4,  // 2: google.cloud.tpu.v1.Node.scheduling_config:type_name -> google.cloud.tpu.v1.SchedulingConfig
	5,  // 3: google.cloud.tpu.v1.Node.network_endpoints:type_name -> google.cloud.tpu.v1.NetworkEndpoint
	1,  // 4: google.cloud.tpu.v1.Node.health:type_name -> google.cloud.tpu.v1.Node.Health
	25, // 5: google.cloud.tpu.v1.Node.labels:type_name -> google.cloud.tpu.v1.Node.LabelsEntry
	2,  // 6: google.cloud.tpu.v1.Node.api_version:type_name -> google.cloud.tpu.v1.Node.ApiVersion
	24, // 7: google.cloud.tpu.v1.Node.symptoms:type_name -> google.cloud.tpu.v1.Symptom
	6,  // 8: google.cloud.tpu.v1.ListNodesResponse.nodes:type_name -> google.cloud.tpu.v1.Node
	6,  // 9: google.cloud.tpu.v1.CreateNodeRequest.node:type_name -> google.cloud.tpu.v1.Node
	15, // 10: google.cloud.tpu.v1.ListTensorFlowVersionsResponse.tensorflow_versions:type_name -> google.cloud.tpu.v1.TensorFlowVersion
	19, // 11: google.cloud.tpu.v1.ListAcceleratorTypesResponse.accelerator_types:type_name -> google.cloud.tpu.v1.AcceleratorType
	26, // 12: google.cloud.tpu.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	26, // 13: google.cloud.tpu.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	26, // 14: google.cloud.tpu.v1.Symptom.create_time:type_name -> google.protobuf.Timestamp
	3,  // 15: google.cloud.tpu.v1.Symptom.symptom_type:type_name -> google.cloud.tpu.v1.Symptom.SymptomType
	7,  // 16: google.cloud.tpu.v1.Tpu.ListNodes:input_type -> google.cloud.tpu.v1.ListNodesRequest
	9,  // 17: google.cloud.tpu.v1.Tpu.GetNode:input_type -> google.cloud.tpu.v1.GetNodeRequest
	10, // 18: google.cloud.tpu.v1.Tpu.CreateNode:input_type -> google.cloud.tpu.v1.CreateNodeRequest
	11, // 19: google.cloud.tpu.v1.Tpu.DeleteNode:input_type -> google.cloud.tpu.v1.DeleteNodeRequest
	12, // 20: google.cloud.tpu.v1.Tpu.ReimageNode:input_type -> google.cloud.tpu.v1.ReimageNodeRequest
	13, // 21: google.cloud.tpu.v1.Tpu.StopNode:input_type -> google.cloud.tpu.v1.StopNodeRequest
	14, // 22: google.cloud.tpu.v1.Tpu.StartNode:input_type -> google.cloud.tpu.v1.StartNodeRequest
	17, // 23: google.cloud.tpu.v1.Tpu.ListTensorFlowVersions:input_type -> google.cloud.tpu.v1.ListTensorFlowVersionsRequest
	16, // 24: google.cloud.tpu.v1.Tpu.GetTensorFlowVersion:input_type -> google.cloud.tpu.v1.GetTensorFlowVersionRequest
	21, // 25: google.cloud.tpu.v1.Tpu.ListAcceleratorTypes:input_type -> google.cloud.tpu.v1.ListAcceleratorTypesRequest
	20, // 26: google.cloud.tpu.v1.Tpu.GetAcceleratorType:input_type -> google.cloud.tpu.v1.GetAcceleratorTypeRequest
	8,  // 27: google.cloud.tpu.v1.Tpu.ListNodes:output_type -> google.cloud.tpu.v1.ListNodesResponse
	6,  // 28: google.cloud.tpu.v1.Tpu.GetNode:output_type -> google.cloud.tpu.v1.Node
	27, // 29: google.cloud.tpu.v1.Tpu.CreateNode:output_type -> google.longrunning.Operation
	27, // 30: google.cloud.tpu.v1.Tpu.DeleteNode:output_type -> google.longrunning.Operation
	27, // 31: google.cloud.tpu.v1.Tpu.ReimageNode:output_type -> google.longrunning.Operation
	27, // 32: google.cloud.tpu.v1.Tpu.StopNode:output_type -> google.longrunning.Operation
	27, // 33: google.cloud.tpu.v1.Tpu.StartNode:output_type -> google.longrunning.Operation
	18, // 34: google.cloud.tpu.v1.Tpu.ListTensorFlowVersions:output_type -> google.cloud.tpu.v1.ListTensorFlowVersionsResponse
	15, // 35: google.cloud.tpu.v1.Tpu.GetTensorFlowVersion:output_type -> google.cloud.tpu.v1.TensorFlowVersion
	22, // 36: google.cloud.tpu.v1.Tpu.ListAcceleratorTypes:output_type -> google.cloud.tpu.v1.ListAcceleratorTypesResponse
	19, // 37: google.cloud.tpu.v1.Tpu.GetAcceleratorType:output_type -> google.cloud.tpu.v1.AcceleratorType
	27, // [27:38] is the sub-list for method output_type
	16, // [16:27] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_tpu_v1_cloud_tpu_proto_init() }
func file_google_cloud_tpu_v1_cloud_tpu_proto_init() {
	if File_google_cloud_tpu_v1_cloud_tpu_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchedulingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReimageNodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopNodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartNodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TensorFlowVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTensorFlowVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorFlowVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorFlowVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcceleratorType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAcceleratorTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAcceleratorTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAcceleratorTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Symptom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_tpu_v1_cloud_tpu_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_tpu_v1_cloud_tpu_proto_goTypes,
		DependencyIndexes: file_google_cloud_tpu_v1_cloud_tpu_proto_depIdxs,
		EnumInfos:         file_google_cloud_tpu_v1_cloud_tpu_proto_enumTypes,
		MessageInfos:      file_google_cloud_tpu_v1_cloud_tpu_proto_msgTypes,
	}.Build()
	File_google_cloud_tpu_v1_cloud_tpu_proto = out.File
	file_google_cloud_tpu_v1_cloud_tpu_proto_rawDesc = nil
	file_google_cloud_tpu_v1_cloud_tpu_proto_goTypes = nil
	file_google_cloud_tpu_v1_cloud_tpu_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TpuClient is the client API for Tpu service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TpuClient interface {
	// Lists nodes.
	ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error)
	// Gets the details of a node.
	GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*Node, error)
	// Creates a node.
	CreateNode(ctx context.Context, in *CreateNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a node.
	DeleteNode(ctx context.Context, in *DeleteNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reimages a node's OS.
	ReimageNode(ctx context.Context, in *ReimageNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a node, this operation is only available with single TPU nodes.
	StopNode(ctx context.Context, in *StopNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a node.
	StartNode(ctx context.Context, in *StartNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List TensorFlow versions supported by this API.
	ListTensorFlowVersions(ctx context.Context, in *ListTensorFlowVersionsRequest, opts ...grpc.CallOption) (*ListTensorFlowVersionsResponse, error)
	// Gets TensorFlow Version.
	GetTensorFlowVersion(ctx context.Context, in *GetTensorFlowVersionRequest, opts ...grpc.CallOption) (*TensorFlowVersion, error)
	// Lists accelerator types supported by this API.
	ListAcceleratorTypes(ctx context.Context, in *ListAcceleratorTypesRequest, opts ...grpc.CallOption) (*ListAcceleratorTypesResponse, error)
	// Gets AcceleratorType.
	GetAcceleratorType(ctx context.Context, in *GetAcceleratorTypeRequest, opts ...grpc.CallOption) (*AcceleratorType, error)
}

type tpuClient struct {
	cc grpc.ClientConnInterface
}

func NewTpuClient(cc grpc.ClientConnInterface) TpuClient {
	return &tpuClient{cc}
}

func (c *tpuClient) ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error) {
	out := new(ListNodesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/ListNodes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*Node, error) {
	out := new(Node)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/GetNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) CreateNode(ctx context.Context, in *CreateNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/CreateNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) DeleteNode(ctx context.Context, in *DeleteNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/DeleteNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) ReimageNode(ctx context.Context, in *ReimageNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/ReimageNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) StopNode(ctx context.Context, in *StopNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/StopNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) StartNode(ctx context.Context, in *StartNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/StartNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) ListTensorFlowVersions(ctx context.Context, in *ListTensorFlowVersionsRequest, opts ...grpc.CallOption) (*ListTensorFlowVersionsResponse, error) {
	out := new(ListTensorFlowVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/ListTensorFlowVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) GetTensorFlowVersion(ctx context.Context, in *GetTensorFlowVersionRequest, opts ...grpc.CallOption) (*TensorFlowVersion, error) {
	out := new(TensorFlowVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/GetTensorFlowVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) ListAcceleratorTypes(ctx context.Context, in *ListAcceleratorTypesRequest, opts ...grpc.CallOption) (*ListAcceleratorTypesResponse, error) {
	out := new(ListAcceleratorTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/ListAcceleratorTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) GetAcceleratorType(ctx context.Context, in *GetAcceleratorTypeRequest, opts ...grpc.CallOption) (*AcceleratorType, error) {
	out := new(AcceleratorType)
	err := c.cc.Invoke(ctx, "/google.cloud.tpu.v1.Tpu/GetAcceleratorType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TpuServer is the server API for Tpu service.
type TpuServer interface {
	// Lists nodes.
	ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error)
	// Gets the details of a node.
	GetNode(context.Context, *GetNodeRequest) (*Node, error)
	// Creates a node.
	CreateNode(context.Context, *CreateNodeRequest) (*longrunningpb.Operation, error)
	// Deletes a node.
	DeleteNode(context.Context, *DeleteNodeRequest) (*longrunningpb.Operation, error)
	// Reimages a node's OS.
	ReimageNode(context.Context, *ReimageNodeRequest) (*longrunningpb.Operation, error)
	// Stops a node, this operation is only available with single TPU nodes.
	StopNode(context.Context, *StopNodeRequest) (*longrunningpb.Operation, error)
	// Starts a node.
	StartNode(context.Context, *StartNodeRequest) (*longrunningpb.Operation, error)
	// List TensorFlow versions supported by this API.
	ListTensorFlowVersions(context.Context, *ListTensorFlowVersionsRequest) (*ListTensorFlowVersionsResponse, error)
	// Gets TensorFlow Version.
	GetTensorFlowVersion(context.Context, *GetTensorFlowVersionRequest) (*TensorFlowVersion, error)
	// Lists accelerator types supported by this API.
	ListAcceleratorTypes(context.Context, *ListAcceleratorTypesRequest) (*ListAcceleratorTypesResponse, error)
	// Gets AcceleratorType.
	GetAcceleratorType(context.Context, *GetAcceleratorTypeRequest) (*AcceleratorType, error)
}

// UnimplementedTpuServer can be embedded to have forward compatible implementations.
type UnimplementedTpuServer struct {
}

func (*UnimplementedTpuServer) ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodes not implemented")
}
func (*UnimplementedTpuServer) GetNode(context.Context, *GetNodeRequest) (*Node, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNode not implemented")
}
func (*UnimplementedTpuServer) CreateNode(context.Context, *CreateNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNode not implemented")
}
func (*UnimplementedTpuServer) DeleteNode(context.Context, *DeleteNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNode not implemented")
}
func (*UnimplementedTpuServer) ReimageNode(context.Context, *ReimageNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReimageNode not implemented")
}
func (*UnimplementedTpuServer) StopNode(context.Context, *StopNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopNode not implemented")
}
func (*UnimplementedTpuServer) StartNode(context.Context, *StartNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNode not implemented")
}
func (*UnimplementedTpuServer) ListTensorFlowVersions(context.Context, *ListTensorFlowVersionsRequest) (*ListTensorFlowVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorFlowVersions not implemented")
}
func (*UnimplementedTpuServer) GetTensorFlowVersion(context.Context, *GetTensorFlowVersionRequest) (*TensorFlowVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorFlowVersion not implemented")
}
func (*UnimplementedTpuServer) ListAcceleratorTypes(context.Context, *ListAcceleratorTypesRequest) (*ListAcceleratorTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAcceleratorTypes not implemented")
}
func (*UnimplementedTpuServer) GetAcceleratorType(context.Context, *GetAcceleratorTypeRequest) (*AcceleratorType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAcceleratorType not implemented")
}

func RegisterTpuServer(s *grpc.Server, srv TpuServer) {
	s.RegisterService(&_Tpu_serviceDesc, srv)
}

func _Tpu_ListNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ListNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/ListNodes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ListNodes(ctx, req.(*ListNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_GetNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).GetNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/GetNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).GetNode(ctx, req.(*GetNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_CreateNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).CreateNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/CreateNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).CreateNode(ctx, req.(*CreateNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_DeleteNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).DeleteNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/DeleteNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).DeleteNode(ctx, req.(*DeleteNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_ReimageNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReimageNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ReimageNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/ReimageNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ReimageNode(ctx, req.(*ReimageNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_StopNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).StopNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/StopNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).StopNode(ctx, req.(*StopNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_StartNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).StartNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/StartNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).StartNode(ctx, req.(*StartNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_ListTensorFlowVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorFlowVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ListTensorFlowVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/ListTensorFlowVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ListTensorFlowVersions(ctx, req.(*ListTensorFlowVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_GetTensorFlowVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorFlowVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).GetTensorFlowVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/GetTensorFlowVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).GetTensorFlowVersion(ctx, req.(*GetTensorFlowVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_ListAcceleratorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAcceleratorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ListAcceleratorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/ListAcceleratorTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ListAcceleratorTypes(ctx, req.(*ListAcceleratorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_GetAcceleratorType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAcceleratorTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).GetAcceleratorType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tpu.v1.Tpu/GetAcceleratorType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).GetAcceleratorType(ctx, req.(*GetAcceleratorTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Tpu_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.tpu.v1.Tpu",
	HandlerType: (*TpuServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListNodes",
			Handler:    _Tpu_ListNodes_Handler,
		},
		{
			MethodName: "GetNode",
			Handler:    _Tpu_GetNode_Handler,
		},
		{
			MethodName: "CreateNode",
			Handler:    _Tpu_CreateNode_Handler,
		},
		{
			MethodName: "DeleteNode",
			Handler:    _Tpu_DeleteNode_Handler,
		},
		{
			MethodName: "ReimageNode",
			Handler:    _Tpu_ReimageNode_Handler,
		},
		{
			MethodName: "StopNode",
			Handler:    _Tpu_StopNode_Handler,
		},
		{
			MethodName: "StartNode",
			Handler:    _Tpu_StartNode_Handler,
		},
		{
			MethodName: "ListTensorFlowVersions",
			Handler:    _Tpu_ListTensorFlowVersions_Handler,
		},
		{
			MethodName: "GetTensorFlowVersion",
			Handler:    _Tpu_GetTensorFlowVersion_Handler,
		},
		{
			MethodName: "ListAcceleratorTypes",
			Handler:    _Tpu_ListAcceleratorTypes_Handler,
		},
		{
			MethodName: "GetAcceleratorType",
			Handler:    _Tpu_GetAcceleratorType_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/tpu/v1/cloud_tpu.proto",
}
