// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/spanner/executor/v1/cloud_executor.proto

package executorpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	databasepb "cloud.google.com/go/spanner/admin/database/apiv1/databasepb"
	instancepb "cloud.google.com/go/spanner/admin/instance/apiv1/instancepb"
	spannerpb "cloud.google.com/go/spanner/apiv1/spannerpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type controls whether "start" and "limit" are open or closed. By default,
// "start" is closed, and "limit" is open.
type KeyRange_Type int32

const (
	// "TYPE_UNSPECIFIED" is equivalent to "CLOSED_OPEN".
	KeyRange_TYPE_UNSPECIFIED KeyRange_Type = 0
	// [start,limit]
	KeyRange_CLOSED_CLOSED KeyRange_Type = 1
	// [start,limit)
	KeyRange_CLOSED_OPEN KeyRange_Type = 2
	// (start,limit]
	KeyRange_OPEN_CLOSED KeyRange_Type = 3
	// (start,limit)
	KeyRange_OPEN_OPEN KeyRange_Type = 4
)

// Enum value maps for KeyRange_Type.
var (
	KeyRange_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CLOSED_CLOSED",
		2: "CLOSED_OPEN",
		3: "OPEN_CLOSED",
		4: "OPEN_OPEN",
	}
	KeyRange_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"CLOSED_CLOSED":    1,
		"CLOSED_OPEN":      2,
		"OPEN_CLOSED":      3,
		"OPEN_OPEN":        4,
	}
)

func (x KeyRange_Type) Enum() *KeyRange_Type {
	p := new(KeyRange_Type)
	*p = x
	return p
}

func (x KeyRange_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyRange_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_executor_v1_cloud_executor_proto_enumTypes[0].Descriptor()
}

func (KeyRange_Type) Type() protoreflect.EnumType {
	return &file_google_spanner_executor_v1_cloud_executor_proto_enumTypes[0]
}

func (x KeyRange_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyRange_Type.Descriptor instead.
func (KeyRange_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{8, 0}
}

// Mode indicates how the transaction should be finished.
type FinishTransactionAction_Mode int32

const (
	// "MODE_UNSPECIFIED" is equivalent to "COMMIT".
	FinishTransactionAction_MODE_UNSPECIFIED FinishTransactionAction_Mode = 0
	// Commit the transaction.
	FinishTransactionAction_COMMIT FinishTransactionAction_Mode = 1
	// Drop the transaction without committing it.
	FinishTransactionAction_ABANDON FinishTransactionAction_Mode = 2
)

// Enum value maps for FinishTransactionAction_Mode.
var (
	FinishTransactionAction_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "COMMIT",
		2: "ABANDON",
	}
	FinishTransactionAction_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"COMMIT":           1,
		"ABANDON":          2,
	}
)

func (x FinishTransactionAction_Mode) Enum() *FinishTransactionAction_Mode {
	p := new(FinishTransactionAction_Mode)
	*p = x
	return p
}

func (x FinishTransactionAction_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FinishTransactionAction_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_executor_v1_cloud_executor_proto_enumTypes[1].Descriptor()
}

func (FinishTransactionAction_Mode) Type() protoreflect.EnumType {
	return &file_google_spanner_executor_v1_cloud_executor_proto_enumTypes[1]
}

func (x FinishTransactionAction_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FinishTransactionAction_Mode.Descriptor instead.
func (FinishTransactionAction_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{19, 0}
}

// Request to executor service that start a new Spanner action.
type SpannerAsyncActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action id to uniquely identify this action request.
	ActionId int32 `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The actual SpannerAction to perform.
	Action *SpannerAction `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *SpannerAsyncActionRequest) Reset() {
	*x = SpannerAsyncActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpannerAsyncActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpannerAsyncActionRequest) ProtoMessage() {}

func (x *SpannerAsyncActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpannerAsyncActionRequest.ProtoReflect.Descriptor instead.
func (*SpannerAsyncActionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{0}
}

func (x *SpannerAsyncActionRequest) GetActionId() int32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *SpannerAsyncActionRequest) GetAction() *SpannerAction {
	if x != nil {
		return x.Action
	}
	return nil
}

// Response from executor service.
type SpannerAsyncActionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action id corresponds to the request.
	ActionId int32 `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// If action results are split into multiple responses, only the last response
	// can and should contain status.
	Outcome *SpannerActionOutcome `protobuf:"bytes,2,opt,name=outcome,proto3" json:"outcome,omitempty"`
}

func (x *SpannerAsyncActionResponse) Reset() {
	*x = SpannerAsyncActionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpannerAsyncActionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpannerAsyncActionResponse) ProtoMessage() {}

func (x *SpannerAsyncActionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpannerAsyncActionResponse.ProtoReflect.Descriptor instead.
func (*SpannerAsyncActionResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{1}
}

func (x *SpannerAsyncActionResponse) GetActionId() int32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *SpannerAsyncActionResponse) GetOutcome() *SpannerActionOutcome {
	if x != nil {
		return x.Outcome
	}
	return nil
}

// SpannerAction defines a primitive action that can be performed against
// Spanner, such as begin or commit a transaction, or perform a read or
// mutation.
type SpannerAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database against which to perform action.
	// In a context where a series of actions take place, an action may omit
	// database path if it applies to the same database as the previous action.
	DatabasePath string `protobuf:"bytes,1,opt,name=database_path,json=databasePath,proto3" json:"database_path,omitempty"`
	// Action represents a spanner action kind, there will only be one action kind
	// per SpannerAction.
	//
	// Types that are assignable to Action:
	//
	//	*SpannerAction_Start
	//	*SpannerAction_Finish
	//	*SpannerAction_Read
	//	*SpannerAction_Query
	//	*SpannerAction_Mutation
	//	*SpannerAction_Dml
	//	*SpannerAction_BatchDml
	//	*SpannerAction_Write
	//	*SpannerAction_PartitionedUpdate
	//	*SpannerAction_Admin
	//	*SpannerAction_StartBatchTxn
	//	*SpannerAction_CloseBatchTxn
	//	*SpannerAction_GenerateDbPartitionsRead
	//	*SpannerAction_GenerateDbPartitionsQuery
	//	*SpannerAction_ExecutePartition
	//	*SpannerAction_ExecuteChangeStreamQuery
	Action isSpannerAction_Action `protobuf_oneof:"action"`
}

func (x *SpannerAction) Reset() {
	*x = SpannerAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpannerAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpannerAction) ProtoMessage() {}

func (x *SpannerAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpannerAction.ProtoReflect.Descriptor instead.
func (*SpannerAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{2}
}

func (x *SpannerAction) GetDatabasePath() string {
	if x != nil {
		return x.DatabasePath
	}
	return ""
}

func (m *SpannerAction) GetAction() isSpannerAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *SpannerAction) GetStart() *StartTransactionAction {
	if x, ok := x.GetAction().(*SpannerAction_Start); ok {
		return x.Start
	}
	return nil
}

func (x *SpannerAction) GetFinish() *FinishTransactionAction {
	if x, ok := x.GetAction().(*SpannerAction_Finish); ok {
		return x.Finish
	}
	return nil
}

func (x *SpannerAction) GetRead() *ReadAction {
	if x, ok := x.GetAction().(*SpannerAction_Read); ok {
		return x.Read
	}
	return nil
}

func (x *SpannerAction) GetQuery() *QueryAction {
	if x, ok := x.GetAction().(*SpannerAction_Query); ok {
		return x.Query
	}
	return nil
}

func (x *SpannerAction) GetMutation() *MutationAction {
	if x, ok := x.GetAction().(*SpannerAction_Mutation); ok {
		return x.Mutation
	}
	return nil
}

func (x *SpannerAction) GetDml() *DmlAction {
	if x, ok := x.GetAction().(*SpannerAction_Dml); ok {
		return x.Dml
	}
	return nil
}

func (x *SpannerAction) GetBatchDml() *BatchDmlAction {
	if x, ok := x.GetAction().(*SpannerAction_BatchDml); ok {
		return x.BatchDml
	}
	return nil
}

func (x *SpannerAction) GetWrite() *WriteMutationsAction {
	if x, ok := x.GetAction().(*SpannerAction_Write); ok {
		return x.Write
	}
	return nil
}

func (x *SpannerAction) GetPartitionedUpdate() *PartitionedUpdateAction {
	if x, ok := x.GetAction().(*SpannerAction_PartitionedUpdate); ok {
		return x.PartitionedUpdate
	}
	return nil
}

func (x *SpannerAction) GetAdmin() *AdminAction {
	if x, ok := x.GetAction().(*SpannerAction_Admin); ok {
		return x.Admin
	}
	return nil
}

func (x *SpannerAction) GetStartBatchTxn() *StartBatchTransactionAction {
	if x, ok := x.GetAction().(*SpannerAction_StartBatchTxn); ok {
		return x.StartBatchTxn
	}
	return nil
}

func (x *SpannerAction) GetCloseBatchTxn() *CloseBatchTransactionAction {
	if x, ok := x.GetAction().(*SpannerAction_CloseBatchTxn); ok {
		return x.CloseBatchTxn
	}
	return nil
}

func (x *SpannerAction) GetGenerateDbPartitionsRead() *GenerateDbPartitionsForReadAction {
	if x, ok := x.GetAction().(*SpannerAction_GenerateDbPartitionsRead); ok {
		return x.GenerateDbPartitionsRead
	}
	return nil
}

func (x *SpannerAction) GetGenerateDbPartitionsQuery() *GenerateDbPartitionsForQueryAction {
	if x, ok := x.GetAction().(*SpannerAction_GenerateDbPartitionsQuery); ok {
		return x.GenerateDbPartitionsQuery
	}
	return nil
}

func (x *SpannerAction) GetExecutePartition() *ExecutePartitionAction {
	if x, ok := x.GetAction().(*SpannerAction_ExecutePartition); ok {
		return x.ExecutePartition
	}
	return nil
}

func (x *SpannerAction) GetExecuteChangeStreamQuery() *ExecuteChangeStreamQuery {
	if x, ok := x.GetAction().(*SpannerAction_ExecuteChangeStreamQuery); ok {
		return x.ExecuteChangeStreamQuery
	}
	return nil
}

type isSpannerAction_Action interface {
	isSpannerAction_Action()
}

type SpannerAction_Start struct {
	// Action to start a transaction.
	Start *StartTransactionAction `protobuf:"bytes,10,opt,name=start,proto3,oneof"`
}

type SpannerAction_Finish struct {
	// Action to finish a transaction.
	Finish *FinishTransactionAction `protobuf:"bytes,11,opt,name=finish,proto3,oneof"`
}

type SpannerAction_Read struct {
	// Action to do a normal read.
	Read *ReadAction `protobuf:"bytes,20,opt,name=read,proto3,oneof"`
}

type SpannerAction_Query struct {
	// Action to do a query.
	Query *QueryAction `protobuf:"bytes,21,opt,name=query,proto3,oneof"`
}

type SpannerAction_Mutation struct {
	// Action to buffer a mutation.
	Mutation *MutationAction `protobuf:"bytes,22,opt,name=mutation,proto3,oneof"`
}

type SpannerAction_Dml struct {
	// Action to a DML.
	Dml *DmlAction `protobuf:"bytes,23,opt,name=dml,proto3,oneof"`
}

type SpannerAction_BatchDml struct {
	// Action to a batch DML.
	BatchDml *BatchDmlAction `protobuf:"bytes,24,opt,name=batch_dml,json=batchDml,proto3,oneof"`
}

type SpannerAction_Write struct {
	// Action to write a mutation.
	Write *WriteMutationsAction `protobuf:"bytes,25,opt,name=write,proto3,oneof"`
}

type SpannerAction_PartitionedUpdate struct {
	// Action to a partitioned update.
	PartitionedUpdate *PartitionedUpdateAction `protobuf:"bytes,27,opt,name=partitioned_update,json=partitionedUpdate,proto3,oneof"`
}

type SpannerAction_Admin struct {
	// Action that contains any administrative operation, like database,
	// instance manipulation.
	Admin *AdminAction `protobuf:"bytes,30,opt,name=admin,proto3,oneof"`
}

type SpannerAction_StartBatchTxn struct {
	// Action to start a batch transaction.
	StartBatchTxn *StartBatchTransactionAction `protobuf:"bytes,40,opt,name=start_batch_txn,json=startBatchTxn,proto3,oneof"`
}

type SpannerAction_CloseBatchTxn struct {
	// Action to close a batch transaction.
	CloseBatchTxn *CloseBatchTransactionAction `protobuf:"bytes,41,opt,name=close_batch_txn,json=closeBatchTxn,proto3,oneof"`
}

type SpannerAction_GenerateDbPartitionsRead struct {
	// Action to generate database partitions for batch read.
	GenerateDbPartitionsRead *GenerateDbPartitionsForReadAction `protobuf:"bytes,42,opt,name=generate_db_partitions_read,json=generateDbPartitionsRead,proto3,oneof"`
}

type SpannerAction_GenerateDbPartitionsQuery struct {
	// Action to generate database partitions for batch query.
	GenerateDbPartitionsQuery *GenerateDbPartitionsForQueryAction `protobuf:"bytes,43,opt,name=generate_db_partitions_query,json=generateDbPartitionsQuery,proto3,oneof"`
}

type SpannerAction_ExecutePartition struct {
	// Action to execute batch actions on generated partitions.
	ExecutePartition *ExecutePartitionAction `protobuf:"bytes,44,opt,name=execute_partition,json=executePartition,proto3,oneof"`
}

type SpannerAction_ExecuteChangeStreamQuery struct {
	// Action to execute change stream query.
	ExecuteChangeStreamQuery *ExecuteChangeStreamQuery `protobuf:"bytes,50,opt,name=execute_change_stream_query,json=executeChangeStreamQuery,proto3,oneof"`
}

func (*SpannerAction_Start) isSpannerAction_Action() {}

func (*SpannerAction_Finish) isSpannerAction_Action() {}

func (*SpannerAction_Read) isSpannerAction_Action() {}

func (*SpannerAction_Query) isSpannerAction_Action() {}

func (*SpannerAction_Mutation) isSpannerAction_Action() {}

func (*SpannerAction_Dml) isSpannerAction_Action() {}

func (*SpannerAction_BatchDml) isSpannerAction_Action() {}

func (*SpannerAction_Write) isSpannerAction_Action() {}

func (*SpannerAction_PartitionedUpdate) isSpannerAction_Action() {}

func (*SpannerAction_Admin) isSpannerAction_Action() {}

func (*SpannerAction_StartBatchTxn) isSpannerAction_Action() {}

func (*SpannerAction_CloseBatchTxn) isSpannerAction_Action() {}

func (*SpannerAction_GenerateDbPartitionsRead) isSpannerAction_Action() {}

func (*SpannerAction_GenerateDbPartitionsQuery) isSpannerAction_Action() {}

func (*SpannerAction_ExecutePartition) isSpannerAction_Action() {}

func (*SpannerAction_ExecuteChangeStreamQuery) isSpannerAction_Action() {}

// A single read request.
type ReadAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The table to read at.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// The index to read at if it's an index read.
	Index *string `protobuf:"bytes,2,opt,name=index,proto3,oneof" json:"index,omitempty"`
	// List of columns must begin with the key columns used for the read.
	Column []string `protobuf:"bytes,3,rep,name=column,proto3" json:"column,omitempty"`
	// Keys for performing this read.
	Keys *KeySet `protobuf:"bytes,4,opt,name=keys,proto3" json:"keys,omitempty"`
	// Limit on number of rows to read. If set, must be positive.
	Limit int32 `protobuf:"varint,5,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (x *ReadAction) Reset() {
	*x = ReadAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadAction) ProtoMessage() {}

func (x *ReadAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadAction.ProtoReflect.Descriptor instead.
func (*ReadAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{3}
}

func (x *ReadAction) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ReadAction) GetIndex() string {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return ""
}

func (x *ReadAction) GetColumn() []string {
	if x != nil {
		return x.Column
	}
	return nil
}

func (x *ReadAction) GetKeys() *KeySet {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ReadAction) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

// A SQL query request.
type QueryAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL string.
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameters for the SQL string.
	Params []*QueryAction_Parameter `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty"`
}

func (x *QueryAction) Reset() {
	*x = QueryAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAction) ProtoMessage() {}

func (x *QueryAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAction.ProtoReflect.Descriptor instead.
func (*QueryAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{4}
}

func (x *QueryAction) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *QueryAction) GetParams() []*QueryAction_Parameter {
	if x != nil {
		return x.Params
	}
	return nil
}

// A single DML statement.
type DmlAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DML statement.
	Update *QueryAction `protobuf:"bytes,1,opt,name=update,proto3" json:"update,omitempty"`
	// Whether to autocommit the transaction after executing the DML statement,
	// if the Executor supports autocommit.
	AutocommitIfSupported *bool `protobuf:"varint,2,opt,name=autocommit_if_supported,json=autocommitIfSupported,proto3,oneof" json:"autocommit_if_supported,omitempty"`
}

func (x *DmlAction) Reset() {
	*x = DmlAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DmlAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DmlAction) ProtoMessage() {}

func (x *DmlAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DmlAction.ProtoReflect.Descriptor instead.
func (*DmlAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{5}
}

func (x *DmlAction) GetUpdate() *QueryAction {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *DmlAction) GetAutocommitIfSupported() bool {
	if x != nil && x.AutocommitIfSupported != nil {
		return *x.AutocommitIfSupported
	}
	return false
}

// Batch of DML statements invoked using batched execution.
type BatchDmlAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DML statements.
	Updates []*QueryAction `protobuf:"bytes,1,rep,name=updates,proto3" json:"updates,omitempty"`
}

func (x *BatchDmlAction) Reset() {
	*x = BatchDmlAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDmlAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDmlAction) ProtoMessage() {}

func (x *BatchDmlAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDmlAction.ProtoReflect.Descriptor instead.
func (*BatchDmlAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{6}
}

func (x *BatchDmlAction) GetUpdates() []*QueryAction {
	if x != nil {
		return x.Updates
	}
	return nil
}

// Value represents a single value that can be read or written to/from
// Spanner.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one of the following fields will be present.
	//
	// Types that are assignable to ValueType:
	//
	//	*Value_IsNull
	//	*Value_IntValue
	//	*Value_BoolValue
	//	*Value_DoubleValue
	//	*Value_BytesValue
	//	*Value_StringValue
	//	*Value_StructValue
	//	*Value_TimestampValue
	//	*Value_DateDaysValue
	//	*Value_IsCommitTimestamp
	//	*Value_ArrayValue
	ValueType isValue_ValueType `protobuf_oneof:"value_type"`
	// Type of array element. Only set if value is an array.
	ArrayType *spannerpb.Type `protobuf:"bytes,12,opt,name=array_type,json=arrayType,proto3,oneof" json:"array_type,omitempty"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{7}
}

func (m *Value) GetValueType() isValue_ValueType {
	if m != nil {
		return m.ValueType
	}
	return nil
}

func (x *Value) GetIsNull() bool {
	if x, ok := x.GetValueType().(*Value_IsNull); ok {
		return x.IsNull
	}
	return false
}

func (x *Value) GetIntValue() int64 {
	if x, ok := x.GetValueType().(*Value_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *Value) GetBoolValue() bool {
	if x, ok := x.GetValueType().(*Value_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *Value) GetDoubleValue() float64 {
	if x, ok := x.GetValueType().(*Value_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *Value) GetBytesValue() []byte {
	if x, ok := x.GetValueType().(*Value_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetValueType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetStructValue() *ValueList {
	if x, ok := x.GetValueType().(*Value_StructValue); ok {
		return x.StructValue
	}
	return nil
}

func (x *Value) GetTimestampValue() *timestamppb.Timestamp {
	if x, ok := x.GetValueType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *Value) GetDateDaysValue() int32 {
	if x, ok := x.GetValueType().(*Value_DateDaysValue); ok {
		return x.DateDaysValue
	}
	return 0
}

func (x *Value) GetIsCommitTimestamp() bool {
	if x, ok := x.GetValueType().(*Value_IsCommitTimestamp); ok {
		return x.IsCommitTimestamp
	}
	return false
}

func (x *Value) GetArrayValue() *ValueList {
	if x, ok := x.GetValueType().(*Value_ArrayValue); ok {
		return x.ArrayValue
	}
	return nil
}

func (x *Value) GetArrayType() *spannerpb.Type {
	if x != nil {
		return x.ArrayType
	}
	return nil
}

type isValue_ValueType interface {
	isValue_ValueType()
}

type Value_IsNull struct {
	// If is_null is set, then this value is null.
	IsNull bool `protobuf:"varint,1,opt,name=is_null,json=isNull,proto3,oneof"`
}

type Value_IntValue struct {
	// Int type value. It's used for all integer number types, like int32 and
	// int64.
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type Value_BoolValue struct {
	// Bool type value.
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type Value_DoubleValue struct {
	// Double type value. It's used for all float point types, like float and
	// double.
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type Value_BytesValue struct {
	// Bytes type value, stored in CORD. It's also used for PROTO type value.
	BytesValue []byte `protobuf:"bytes,5,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}

type Value_StringValue struct {
	// String type value, stored in CORD.
	StringValue string `protobuf:"bytes,6,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_StructValue struct {
	// Struct type value. It contains a ValueList representing the values in
	// this struct.
	StructValue *ValueList `protobuf:"bytes,7,opt,name=struct_value,json=structValue,proto3,oneof"`
}

type Value_TimestampValue struct {
	// Timestamp type value.
	TimestampValue *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type Value_DateDaysValue struct {
	// Date type value. Date is specified as a number of days since Unix epoch.
	DateDaysValue int32 `protobuf:"varint,9,opt,name=date_days_value,json=dateDaysValue,proto3,oneof"`
}

type Value_IsCommitTimestamp struct {
	// If set, holds the sentinel value for the transaction CommitTimestamp.
	IsCommitTimestamp bool `protobuf:"varint,10,opt,name=is_commit_timestamp,json=isCommitTimestamp,proto3,oneof"`
}

type Value_ArrayValue struct {
	// Array type value. The underlying Valuelist should have values that have
	// the same type.
	ArrayValue *ValueList `protobuf:"bytes,11,opt,name=array_value,json=arrayValue,proto3,oneof"`
}

func (*Value_IsNull) isValue_ValueType() {}

func (*Value_IntValue) isValue_ValueType() {}

func (*Value_BoolValue) isValue_ValueType() {}

func (*Value_DoubleValue) isValue_ValueType() {}

func (*Value_BytesValue) isValue_ValueType() {}

func (*Value_StringValue) isValue_ValueType() {}

func (*Value_StructValue) isValue_ValueType() {}

func (*Value_TimestampValue) isValue_ValueType() {}

func (*Value_DateDaysValue) isValue_ValueType() {}

func (*Value_IsCommitTimestamp) isValue_ValueType() {}

func (*Value_ArrayValue) isValue_ValueType() {}

// KeyRange represents a range of rows in a table or index.
//
// A range has a start key and an end key. These keys can be open or
// closed, indicating if the range includes rows with that key.
//
// Keys are represented by "ValueList", where the ith value in the list
// corresponds to the ith component of the table or index primary key.
type KeyRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// "start" and "limit" must have the same number of key parts,
	// though they may name only a prefix of the table or index key.
	// The start key of this KeyRange.
	Start *ValueList `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// The end key of this KeyRange.
	Limit *ValueList `protobuf:"bytes,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// "start" and "limit" type for this KeyRange.
	Type *KeyRange_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.spanner.executor.v1.KeyRange_Type,oneof" json:"type,omitempty"`
}

func (x *KeyRange) Reset() {
	*x = KeyRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRange) ProtoMessage() {}

func (x *KeyRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRange.ProtoReflect.Descriptor instead.
func (*KeyRange) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{8}
}

func (x *KeyRange) GetStart() *ValueList {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *KeyRange) GetLimit() *ValueList {
	if x != nil {
		return x.Limit
	}
	return nil
}

func (x *KeyRange) GetType() KeyRange_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return KeyRange_TYPE_UNSPECIFIED
}

// KeySet defines a collection of Spanner keys and/or key ranges. All
// the keys are expected to be in the same table. The keys need not be
// sorted in any particular way.
type KeySet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of specific keys. Entries in "keys" should have exactly as
	// many elements as there are columns in the primary or index key
	// with which this "KeySet" is used.
	Point []*ValueList `protobuf:"bytes,1,rep,name=point,proto3" json:"point,omitempty"`
	// A list of key ranges.
	Range []*KeyRange `protobuf:"bytes,2,rep,name=range,proto3" json:"range,omitempty"`
	// For convenience "all" can be set to "true" to indicate that this
	// "KeySet" matches all keys in the table or index. Note that any keys
	// specified in "keys" or "ranges" are only yielded once.
	All bool `protobuf:"varint,3,opt,name=all,proto3" json:"all,omitempty"`
}

func (x *KeySet) Reset() {
	*x = KeySet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeySet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeySet) ProtoMessage() {}

func (x *KeySet) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeySet.ProtoReflect.Descriptor instead.
func (*KeySet) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{9}
}

func (x *KeySet) GetPoint() []*ValueList {
	if x != nil {
		return x.Point
	}
	return nil
}

func (x *KeySet) GetRange() []*KeyRange {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *KeySet) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

// List of values.
type ValueList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Values contained in this ValueList.
	Value []*Value `protobuf:"bytes,1,rep,name=value,proto3" json:"value,omitempty"`
}

func (x *ValueList) Reset() {
	*x = ValueList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueList) ProtoMessage() {}

func (x *ValueList) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueList.ProtoReflect.Descriptor instead.
func (*ValueList) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{10}
}

func (x *ValueList) GetValue() []*Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// A single mutation request.
type MutationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mods that contained in this mutation.
	Mod []*MutationAction_Mod `protobuf:"bytes,1,rep,name=mod,proto3" json:"mod,omitempty"`
}

func (x *MutationAction) Reset() {
	*x = MutationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutationAction) ProtoMessage() {}

func (x *MutationAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutationAction.ProtoReflect.Descriptor instead.
func (*MutationAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{11}
}

func (x *MutationAction) GetMod() []*MutationAction_Mod {
	if x != nil {
		return x.Mod
	}
	return nil
}

// WriteMutationAction defines an action of flushing the mutation so they
// are visible to subsequent operations in the transaction.
type WriteMutationsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mutation to write.
	Mutation *MutationAction `protobuf:"bytes,1,opt,name=mutation,proto3" json:"mutation,omitempty"`
}

func (x *WriteMutationsAction) Reset() {
	*x = WriteMutationsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteMutationsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteMutationsAction) ProtoMessage() {}

func (x *WriteMutationsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteMutationsAction.ProtoReflect.Descriptor instead.
func (*WriteMutationsAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{12}
}

func (x *WriteMutationsAction) GetMutation() *MutationAction {
	if x != nil {
		return x.Mutation
	}
	return nil
}

// PartitionedUpdateAction defines an action to execute a partitioned DML
// which runs different partitions in parallel.
type PartitionedUpdateAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Options for partitioned update.
	Options *PartitionedUpdateAction_ExecutePartitionedUpdateOptions `protobuf:"bytes,1,opt,name=options,proto3,oneof" json:"options,omitempty"`
	// Partitioned dml query.
	Update *QueryAction `protobuf:"bytes,2,opt,name=update,proto3" json:"update,omitempty"`
}

func (x *PartitionedUpdateAction) Reset() {
	*x = PartitionedUpdateAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionedUpdateAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionedUpdateAction) ProtoMessage() {}

func (x *PartitionedUpdateAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionedUpdateAction.ProtoReflect.Descriptor instead.
func (*PartitionedUpdateAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{13}
}

func (x *PartitionedUpdateAction) GetOptions() *PartitionedUpdateAction_ExecutePartitionedUpdateOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *PartitionedUpdateAction) GetUpdate() *QueryAction {
	if x != nil {
		return x.Update
	}
	return nil
}

// StartTransactionAction defines an action of initializing a transaction.
type StartTransactionAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Concurrency is for read-only transactions and must be omitted for
	// read-write transactions.
	Concurrency *Concurrency `protobuf:"bytes,1,opt,name=concurrency,proto3,oneof" json:"concurrency,omitempty"`
	// Metadata about tables and columns that will be involved in this
	// transaction. It is to convert values of key parts correctly.
	Table []*TableMetadata `protobuf:"bytes,2,rep,name=table,proto3" json:"table,omitempty"`
	// Transaction_seed contains workid and op pair for this transaction, used for
	// testing.
	TransactionSeed string `protobuf:"bytes,3,opt,name=transaction_seed,json=transactionSeed,proto3" json:"transaction_seed,omitempty"`
	// Execution options (e.g., whether transaction is opaque, optimistic).
	ExecutionOptions *TransactionExecutionOptions `protobuf:"bytes,4,opt,name=execution_options,json=executionOptions,proto3,oneof" json:"execution_options,omitempty"`
}

func (x *StartTransactionAction) Reset() {
	*x = StartTransactionAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartTransactionAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartTransactionAction) ProtoMessage() {}

func (x *StartTransactionAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartTransactionAction.ProtoReflect.Descriptor instead.
func (*StartTransactionAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{14}
}

func (x *StartTransactionAction) GetConcurrency() *Concurrency {
	if x != nil {
		return x.Concurrency
	}
	return nil
}

func (x *StartTransactionAction) GetTable() []*TableMetadata {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *StartTransactionAction) GetTransactionSeed() string {
	if x != nil {
		return x.TransactionSeed
	}
	return ""
}

func (x *StartTransactionAction) GetExecutionOptions() *TransactionExecutionOptions {
	if x != nil {
		return x.ExecutionOptions
	}
	return nil
}

// Concurrency for read-only transactions.
type Concurrency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Concurrency mode set for read-only transactions, exactly one mode below
	// should be set.
	//
	// Types that are assignable to ConcurrencyMode:
	//
	//	*Concurrency_StalenessSeconds
	//	*Concurrency_MinReadTimestampMicros
	//	*Concurrency_MaxStalenessSeconds
	//	*Concurrency_ExactTimestampMicros
	//	*Concurrency_Strong
	//	*Concurrency_Batch
	ConcurrencyMode isConcurrency_ConcurrencyMode `protobuf_oneof:"concurrency_mode"`
	// True if exact_timestamp_micros is set, and the chosen timestamp is that of
	// a snapshot epoch.
	SnapshotEpochRead bool `protobuf:"varint,7,opt,name=snapshot_epoch_read,json=snapshotEpochRead,proto3" json:"snapshot_epoch_read,omitempty"`
	// If set, this is a snapshot epoch read constrained to read only the
	// specified log scope root table, and its children. Will not be set for full
	// database epochs.
	SnapshotEpochRootTable string `protobuf:"bytes,8,opt,name=snapshot_epoch_root_table,json=snapshotEpochRootTable,proto3" json:"snapshot_epoch_root_table,omitempty"`
	// Set only when batch is true.
	BatchReadTimestampMicros int64 `protobuf:"varint,9,opt,name=batch_read_timestamp_micros,json=batchReadTimestampMicros,proto3" json:"batch_read_timestamp_micros,omitempty"`
}

func (x *Concurrency) Reset() {
	*x = Concurrency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Concurrency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Concurrency) ProtoMessage() {}

func (x *Concurrency) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Concurrency.ProtoReflect.Descriptor instead.
func (*Concurrency) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{15}
}

func (m *Concurrency) GetConcurrencyMode() isConcurrency_ConcurrencyMode {
	if m != nil {
		return m.ConcurrencyMode
	}
	return nil
}

func (x *Concurrency) GetStalenessSeconds() float64 {
	if x, ok := x.GetConcurrencyMode().(*Concurrency_StalenessSeconds); ok {
		return x.StalenessSeconds
	}
	return 0
}

func (x *Concurrency) GetMinReadTimestampMicros() int64 {
	if x, ok := x.GetConcurrencyMode().(*Concurrency_MinReadTimestampMicros); ok {
		return x.MinReadTimestampMicros
	}
	return 0
}

func (x *Concurrency) GetMaxStalenessSeconds() float64 {
	if x, ok := x.GetConcurrencyMode().(*Concurrency_MaxStalenessSeconds); ok {
		return x.MaxStalenessSeconds
	}
	return 0
}

func (x *Concurrency) GetExactTimestampMicros() int64 {
	if x, ok := x.GetConcurrencyMode().(*Concurrency_ExactTimestampMicros); ok {
		return x.ExactTimestampMicros
	}
	return 0
}

func (x *Concurrency) GetStrong() bool {
	if x, ok := x.GetConcurrencyMode().(*Concurrency_Strong); ok {
		return x.Strong
	}
	return false
}

func (x *Concurrency) GetBatch() bool {
	if x, ok := x.GetConcurrencyMode().(*Concurrency_Batch); ok {
		return x.Batch
	}
	return false
}

func (x *Concurrency) GetSnapshotEpochRead() bool {
	if x != nil {
		return x.SnapshotEpochRead
	}
	return false
}

func (x *Concurrency) GetSnapshotEpochRootTable() string {
	if x != nil {
		return x.SnapshotEpochRootTable
	}
	return ""
}

func (x *Concurrency) GetBatchReadTimestampMicros() int64 {
	if x != nil {
		return x.BatchReadTimestampMicros
	}
	return 0
}

type isConcurrency_ConcurrencyMode interface {
	isConcurrency_ConcurrencyMode()
}

type Concurrency_StalenessSeconds struct {
	// Indicates a read at a consistent timestamp that is specified relative to
	// now. That is, if the caller has specified an exact staleness of s
	// seconds, we will read at now - s.
	StalenessSeconds float64 `protobuf:"fixed64,1,opt,name=staleness_seconds,json=stalenessSeconds,proto3,oneof"`
}

type Concurrency_MinReadTimestampMicros struct {
	// Indicates a boundedly stale read that reads at a timestamp >= T.
	MinReadTimestampMicros int64 `protobuf:"varint,2,opt,name=min_read_timestamp_micros,json=minReadTimestampMicros,proto3,oneof"`
}

type Concurrency_MaxStalenessSeconds struct {
	// Indicates a boundedly stale read that is at most N seconds stale.
	MaxStalenessSeconds float64 `protobuf:"fixed64,3,opt,name=max_staleness_seconds,json=maxStalenessSeconds,proto3,oneof"`
}

type Concurrency_ExactTimestampMicros struct {
	// Indicates a read at a consistent timestamp.
	ExactTimestampMicros int64 `protobuf:"varint,4,opt,name=exact_timestamp_micros,json=exactTimestampMicros,proto3,oneof"`
}

type Concurrency_Strong struct {
	// Indicates a strong read, must only be set to true, or unset.
	Strong bool `protobuf:"varint,5,opt,name=strong,proto3,oneof"`
}

type Concurrency_Batch struct {
	// Indicates a batch read, must only be set to true, or unset.
	Batch bool `protobuf:"varint,6,opt,name=batch,proto3,oneof"`
}

func (*Concurrency_StalenessSeconds) isConcurrency_ConcurrencyMode() {}

func (*Concurrency_MinReadTimestampMicros) isConcurrency_ConcurrencyMode() {}

func (*Concurrency_MaxStalenessSeconds) isConcurrency_ConcurrencyMode() {}

func (*Concurrency_ExactTimestampMicros) isConcurrency_ConcurrencyMode() {}

func (*Concurrency_Strong) isConcurrency_ConcurrencyMode() {}

func (*Concurrency_Batch) isConcurrency_ConcurrencyMode() {}

// TableMetadata contains metadata of a single table.
type TableMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Columns, in the same order as in the schema.
	Column []*ColumnMetadata `protobuf:"bytes,2,rep,name=column,proto3" json:"column,omitempty"`
	// Keys, in order. Column name is currently not populated.
	KeyColumn []*ColumnMetadata `protobuf:"bytes,3,rep,name=key_column,json=keyColumn,proto3" json:"key_column,omitempty"`
}

func (x *TableMetadata) Reset() {
	*x = TableMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableMetadata) ProtoMessage() {}

func (x *TableMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableMetadata.ProtoReflect.Descriptor instead.
func (*TableMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{16}
}

func (x *TableMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TableMetadata) GetColumn() []*ColumnMetadata {
	if x != nil {
		return x.Column
	}
	return nil
}

func (x *TableMetadata) GetKeyColumn() []*ColumnMetadata {
	if x != nil {
		return x.KeyColumn
	}
	return nil
}

// ColumnMetadata represents metadata of a single column.
type ColumnMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Column type.
	Type *spannerpb.Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ColumnMetadata) Reset() {
	*x = ColumnMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnMetadata) ProtoMessage() {}

func (x *ColumnMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnMetadata.ProtoReflect.Descriptor instead.
func (*ColumnMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{17}
}

func (x *ColumnMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ColumnMetadata) GetType() *spannerpb.Type {
	if x != nil {
		return x.Type
	}
	return nil
}

// Options for executing the transaction.
type TransactionExecutionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether optimistic concurrency should be used to execute this transaction.
	Optimistic bool `protobuf:"varint,1,opt,name=optimistic,proto3" json:"optimistic,omitempty"`
}

func (x *TransactionExecutionOptions) Reset() {
	*x = TransactionExecutionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransactionExecutionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransactionExecutionOptions) ProtoMessage() {}

func (x *TransactionExecutionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransactionExecutionOptions.ProtoReflect.Descriptor instead.
func (*TransactionExecutionOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{18}
}

func (x *TransactionExecutionOptions) GetOptimistic() bool {
	if x != nil {
		return x.Optimistic
	}
	return false
}

// FinishTransactionAction defines an action of finishing a transaction.
type FinishTransactionAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines how exactly the transaction should be completed, e.g. with
	// commit or abortion.
	Mode FinishTransactionAction_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.spanner.executor.v1.FinishTransactionAction_Mode" json:"mode,omitempty"`
}

func (x *FinishTransactionAction) Reset() {
	*x = FinishTransactionAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinishTransactionAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinishTransactionAction) ProtoMessage() {}

func (x *FinishTransactionAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinishTransactionAction.ProtoReflect.Descriptor instead.
func (*FinishTransactionAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{19}
}

func (x *FinishTransactionAction) GetMode() FinishTransactionAction_Mode {
	if x != nil {
		return x.Mode
	}
	return FinishTransactionAction_MODE_UNSPECIFIED
}

// AdminAction defines all the cloud spanner admin actions, including
// instance/database admin ops, backup ops and operation actions.
type AdminAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one of the actions below will be performed in AdminAction.
	//
	// Types that are assignable to Action:
	//
	//	*AdminAction_CreateUserInstanceConfig
	//	*AdminAction_UpdateUserInstanceConfig
	//	*AdminAction_DeleteUserInstanceConfig
	//	*AdminAction_GetCloudInstanceConfig
	//	*AdminAction_ListInstanceConfigs
	//	*AdminAction_CreateCloudInstance
	//	*AdminAction_UpdateCloudInstance
	//	*AdminAction_DeleteCloudInstance
	//	*AdminAction_ListCloudInstances
	//	*AdminAction_GetCloudInstance
	//	*AdminAction_CreateCloudDatabase
	//	*AdminAction_UpdateCloudDatabaseDdl
	//	*AdminAction_UpdateCloudDatabase
	//	*AdminAction_DropCloudDatabase
	//	*AdminAction_ListCloudDatabases
	//	*AdminAction_ListCloudDatabaseOperations
	//	*AdminAction_RestoreCloudDatabase
	//	*AdminAction_GetCloudDatabase
	//	*AdminAction_CreateCloudBackup
	//	*AdminAction_CopyCloudBackup
	//	*AdminAction_GetCloudBackup
	//	*AdminAction_UpdateCloudBackup
	//	*AdminAction_DeleteCloudBackup
	//	*AdminAction_ListCloudBackups
	//	*AdminAction_ListCloudBackupOperations
	//	*AdminAction_GetOperation
	//	*AdminAction_CancelOperation
	//	*AdminAction_ReconfigureCloudDatabase
	Action isAdminAction_Action `protobuf_oneof:"action"`
}

func (x *AdminAction) Reset() {
	*x = AdminAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdminAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdminAction) ProtoMessage() {}

func (x *AdminAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdminAction.ProtoReflect.Descriptor instead.
func (*AdminAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{20}
}

func (m *AdminAction) GetAction() isAdminAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *AdminAction) GetCreateUserInstanceConfig() *CreateUserInstanceConfigAction {
	if x, ok := x.GetAction().(*AdminAction_CreateUserInstanceConfig); ok {
		return x.CreateUserInstanceConfig
	}
	return nil
}

func (x *AdminAction) GetUpdateUserInstanceConfig() *UpdateUserInstanceConfigAction {
	if x, ok := x.GetAction().(*AdminAction_UpdateUserInstanceConfig); ok {
		return x.UpdateUserInstanceConfig
	}
	return nil
}

func (x *AdminAction) GetDeleteUserInstanceConfig() *DeleteUserInstanceConfigAction {
	if x, ok := x.GetAction().(*AdminAction_DeleteUserInstanceConfig); ok {
		return x.DeleteUserInstanceConfig
	}
	return nil
}

func (x *AdminAction) GetGetCloudInstanceConfig() *GetCloudInstanceConfigAction {
	if x, ok := x.GetAction().(*AdminAction_GetCloudInstanceConfig); ok {
		return x.GetCloudInstanceConfig
	}
	return nil
}

func (x *AdminAction) GetListInstanceConfigs() *ListCloudInstanceConfigsAction {
	if x, ok := x.GetAction().(*AdminAction_ListInstanceConfigs); ok {
		return x.ListInstanceConfigs
	}
	return nil
}

func (x *AdminAction) GetCreateCloudInstance() *CreateCloudInstanceAction {
	if x, ok := x.GetAction().(*AdminAction_CreateCloudInstance); ok {
		return x.CreateCloudInstance
	}
	return nil
}

func (x *AdminAction) GetUpdateCloudInstance() *UpdateCloudInstanceAction {
	if x, ok := x.GetAction().(*AdminAction_UpdateCloudInstance); ok {
		return x.UpdateCloudInstance
	}
	return nil
}

func (x *AdminAction) GetDeleteCloudInstance() *DeleteCloudInstanceAction {
	if x, ok := x.GetAction().(*AdminAction_DeleteCloudInstance); ok {
		return x.DeleteCloudInstance
	}
	return nil
}

func (x *AdminAction) GetListCloudInstances() *ListCloudInstancesAction {
	if x, ok := x.GetAction().(*AdminAction_ListCloudInstances); ok {
		return x.ListCloudInstances
	}
	return nil
}

func (x *AdminAction) GetGetCloudInstance() *GetCloudInstanceAction {
	if x, ok := x.GetAction().(*AdminAction_GetCloudInstance); ok {
		return x.GetCloudInstance
	}
	return nil
}

func (x *AdminAction) GetCreateCloudDatabase() *CreateCloudDatabaseAction {
	if x, ok := x.GetAction().(*AdminAction_CreateCloudDatabase); ok {
		return x.CreateCloudDatabase
	}
	return nil
}

func (x *AdminAction) GetUpdateCloudDatabaseDdl() *UpdateCloudDatabaseDdlAction {
	if x, ok := x.GetAction().(*AdminAction_UpdateCloudDatabaseDdl); ok {
		return x.UpdateCloudDatabaseDdl
	}
	return nil
}

func (x *AdminAction) GetUpdateCloudDatabase() *UpdateCloudDatabaseAction {
	if x, ok := x.GetAction().(*AdminAction_UpdateCloudDatabase); ok {
		return x.UpdateCloudDatabase
	}
	return nil
}

func (x *AdminAction) GetDropCloudDatabase() *DropCloudDatabaseAction {
	if x, ok := x.GetAction().(*AdminAction_DropCloudDatabase); ok {
		return x.DropCloudDatabase
	}
	return nil
}

func (x *AdminAction) GetListCloudDatabases() *ListCloudDatabasesAction {
	if x, ok := x.GetAction().(*AdminAction_ListCloudDatabases); ok {
		return x.ListCloudDatabases
	}
	return nil
}

func (x *AdminAction) GetListCloudDatabaseOperations() *ListCloudDatabaseOperationsAction {
	if x, ok := x.GetAction().(*AdminAction_ListCloudDatabaseOperations); ok {
		return x.ListCloudDatabaseOperations
	}
	return nil
}

func (x *AdminAction) GetRestoreCloudDatabase() *RestoreCloudDatabaseAction {
	if x, ok := x.GetAction().(*AdminAction_RestoreCloudDatabase); ok {
		return x.RestoreCloudDatabase
	}
	return nil
}

func (x *AdminAction) GetGetCloudDatabase() *GetCloudDatabaseAction {
	if x, ok := x.GetAction().(*AdminAction_GetCloudDatabase); ok {
		return x.GetCloudDatabase
	}
	return nil
}

func (x *AdminAction) GetCreateCloudBackup() *CreateCloudBackupAction {
	if x, ok := x.GetAction().(*AdminAction_CreateCloudBackup); ok {
		return x.CreateCloudBackup
	}
	return nil
}

func (x *AdminAction) GetCopyCloudBackup() *CopyCloudBackupAction {
	if x, ok := x.GetAction().(*AdminAction_CopyCloudBackup); ok {
		return x.CopyCloudBackup
	}
	return nil
}

func (x *AdminAction) GetGetCloudBackup() *GetCloudBackupAction {
	if x, ok := x.GetAction().(*AdminAction_GetCloudBackup); ok {
		return x.GetCloudBackup
	}
	return nil
}

func (x *AdminAction) GetUpdateCloudBackup() *UpdateCloudBackupAction {
	if x, ok := x.GetAction().(*AdminAction_UpdateCloudBackup); ok {
		return x.UpdateCloudBackup
	}
	return nil
}

func (x *AdminAction) GetDeleteCloudBackup() *DeleteCloudBackupAction {
	if x, ok := x.GetAction().(*AdminAction_DeleteCloudBackup); ok {
		return x.DeleteCloudBackup
	}
	return nil
}

func (x *AdminAction) GetListCloudBackups() *ListCloudBackupsAction {
	if x, ok := x.GetAction().(*AdminAction_ListCloudBackups); ok {
		return x.ListCloudBackups
	}
	return nil
}

func (x *AdminAction) GetListCloudBackupOperations() *ListCloudBackupOperationsAction {
	if x, ok := x.GetAction().(*AdminAction_ListCloudBackupOperations); ok {
		return x.ListCloudBackupOperations
	}
	return nil
}

func (x *AdminAction) GetGetOperation() *GetOperationAction {
	if x, ok := x.GetAction().(*AdminAction_GetOperation); ok {
		return x.GetOperation
	}
	return nil
}

func (x *AdminAction) GetCancelOperation() *CancelOperationAction {
	if x, ok := x.GetAction().(*AdminAction_CancelOperation); ok {
		return x.CancelOperation
	}
	return nil
}

func (x *AdminAction) GetReconfigureCloudDatabase() *ReconfigureCloudDatabaseAction {
	if x, ok := x.GetAction().(*AdminAction_ReconfigureCloudDatabase); ok {
		return x.ReconfigureCloudDatabase
	}
	return nil
}

type isAdminAction_Action interface {
	isAdminAction_Action()
}

type AdminAction_CreateUserInstanceConfig struct {
	// Action that creates a user instance config.
	CreateUserInstanceConfig *CreateUserInstanceConfigAction `protobuf:"bytes,1,opt,name=create_user_instance_config,json=createUserInstanceConfig,proto3,oneof"`
}

type AdminAction_UpdateUserInstanceConfig struct {
	// Action that updates a user instance config.
	UpdateUserInstanceConfig *UpdateUserInstanceConfigAction `protobuf:"bytes,2,opt,name=update_user_instance_config,json=updateUserInstanceConfig,proto3,oneof"`
}

type AdminAction_DeleteUserInstanceConfig struct {
	// Action that deletes a user instance config.
	DeleteUserInstanceConfig *DeleteUserInstanceConfigAction `protobuf:"bytes,3,opt,name=delete_user_instance_config,json=deleteUserInstanceConfig,proto3,oneof"`
}

type AdminAction_GetCloudInstanceConfig struct {
	// Action that gets a user instance config.
	GetCloudInstanceConfig *GetCloudInstanceConfigAction `protobuf:"bytes,4,opt,name=get_cloud_instance_config,json=getCloudInstanceConfig,proto3,oneof"`
}

type AdminAction_ListInstanceConfigs struct {
	// Action that lists user instance configs.
	ListInstanceConfigs *ListCloudInstanceConfigsAction `protobuf:"bytes,5,opt,name=list_instance_configs,json=listInstanceConfigs,proto3,oneof"`
}

type AdminAction_CreateCloudInstance struct {
	// Action that creates a Cloud Spanner instance.
	CreateCloudInstance *CreateCloudInstanceAction `protobuf:"bytes,6,opt,name=create_cloud_instance,json=createCloudInstance,proto3,oneof"`
}

type AdminAction_UpdateCloudInstance struct {
	// Action that updates a Cloud Spanner instance.
	UpdateCloudInstance *UpdateCloudInstanceAction `protobuf:"bytes,7,opt,name=update_cloud_instance,json=updateCloudInstance,proto3,oneof"`
}

type AdminAction_DeleteCloudInstance struct {
	// Action that deletes a Cloud Spanner instance.
	DeleteCloudInstance *DeleteCloudInstanceAction `protobuf:"bytes,8,opt,name=delete_cloud_instance,json=deleteCloudInstance,proto3,oneof"`
}

type AdminAction_ListCloudInstances struct {
	// Action that lists Cloud Spanner instances.
	ListCloudInstances *ListCloudInstancesAction `protobuf:"bytes,9,opt,name=list_cloud_instances,json=listCloudInstances,proto3,oneof"`
}

type AdminAction_GetCloudInstance struct {
	// Action that retrieves a Cloud Spanner instance.
	GetCloudInstance *GetCloudInstanceAction `protobuf:"bytes,10,opt,name=get_cloud_instance,json=getCloudInstance,proto3,oneof"`
}

type AdminAction_CreateCloudDatabase struct {
	// Action that creates a Cloud Spanner database.
	CreateCloudDatabase *CreateCloudDatabaseAction `protobuf:"bytes,11,opt,name=create_cloud_database,json=createCloudDatabase,proto3,oneof"`
}

type AdminAction_UpdateCloudDatabaseDdl struct {
	// Action that updates the schema of a Cloud Spanner database.
	UpdateCloudDatabaseDdl *UpdateCloudDatabaseDdlAction `protobuf:"bytes,12,opt,name=update_cloud_database_ddl,json=updateCloudDatabaseDdl,proto3,oneof"`
}

type AdminAction_UpdateCloudDatabase struct {
	// Action that updates the schema of a Cloud Spanner database.
	UpdateCloudDatabase *UpdateCloudDatabaseAction `protobuf:"bytes,27,opt,name=update_cloud_database,json=updateCloudDatabase,proto3,oneof"`
}

type AdminAction_DropCloudDatabase struct {
	// Action that drops a Cloud Spanner database.
	DropCloudDatabase *DropCloudDatabaseAction `protobuf:"bytes,13,opt,name=drop_cloud_database,json=dropCloudDatabase,proto3,oneof"`
}

type AdminAction_ListCloudDatabases struct {
	// Action that lists Cloud Spanner databases.
	ListCloudDatabases *ListCloudDatabasesAction `protobuf:"bytes,14,opt,name=list_cloud_databases,json=listCloudDatabases,proto3,oneof"`
}

type AdminAction_ListCloudDatabaseOperations struct {
	// Action that lists Cloud Spanner database operations.
	ListCloudDatabaseOperations *ListCloudDatabaseOperationsAction `protobuf:"bytes,15,opt,name=list_cloud_database_operations,json=listCloudDatabaseOperations,proto3,oneof"`
}

type AdminAction_RestoreCloudDatabase struct {
	// Action that restores a Cloud Spanner database from a backup.
	RestoreCloudDatabase *RestoreCloudDatabaseAction `protobuf:"bytes,16,opt,name=restore_cloud_database,json=restoreCloudDatabase,proto3,oneof"`
}

type AdminAction_GetCloudDatabase struct {
	// Action that gets a Cloud Spanner database.
	GetCloudDatabase *GetCloudDatabaseAction `protobuf:"bytes,17,opt,name=get_cloud_database,json=getCloudDatabase,proto3,oneof"`
}

type AdminAction_CreateCloudBackup struct {
	// Action that creates a Cloud Spanner database backup.
	CreateCloudBackup *CreateCloudBackupAction `protobuf:"bytes,18,opt,name=create_cloud_backup,json=createCloudBackup,proto3,oneof"`
}

type AdminAction_CopyCloudBackup struct {
	// Action that copies a Cloud Spanner database backup.
	CopyCloudBackup *CopyCloudBackupAction `protobuf:"bytes,19,opt,name=copy_cloud_backup,json=copyCloudBackup,proto3,oneof"`
}

type AdminAction_GetCloudBackup struct {
	// Action that gets a Cloud Spanner database backup.
	GetCloudBackup *GetCloudBackupAction `protobuf:"bytes,20,opt,name=get_cloud_backup,json=getCloudBackup,proto3,oneof"`
}

type AdminAction_UpdateCloudBackup struct {
	// Action that updates a Cloud Spanner database backup.
	UpdateCloudBackup *UpdateCloudBackupAction `protobuf:"bytes,21,opt,name=update_cloud_backup,json=updateCloudBackup,proto3,oneof"`
}

type AdminAction_DeleteCloudBackup struct {
	// Action that deletes a Cloud Spanner database backup.
	DeleteCloudBackup *DeleteCloudBackupAction `protobuf:"bytes,22,opt,name=delete_cloud_backup,json=deleteCloudBackup,proto3,oneof"`
}

type AdminAction_ListCloudBackups struct {
	// Action that lists Cloud Spanner database backups.
	ListCloudBackups *ListCloudBackupsAction `protobuf:"bytes,23,opt,name=list_cloud_backups,json=listCloudBackups,proto3,oneof"`
}

type AdminAction_ListCloudBackupOperations struct {
	// Action that lists Cloud Spanner database backup operations.
	ListCloudBackupOperations *ListCloudBackupOperationsAction `protobuf:"bytes,24,opt,name=list_cloud_backup_operations,json=listCloudBackupOperations,proto3,oneof"`
}

type AdminAction_GetOperation struct {
	// Action that gets an operation.
	GetOperation *GetOperationAction `protobuf:"bytes,25,opt,name=get_operation,json=getOperation,proto3,oneof"`
}

type AdminAction_CancelOperation struct {
	// Action that cancels an operation.
	CancelOperation *CancelOperationAction `protobuf:"bytes,26,opt,name=cancel_operation,json=cancelOperation,proto3,oneof"`
}

type AdminAction_ReconfigureCloudDatabase struct {
	// Action that reconfigures a Cloud Spanner database.
	ReconfigureCloudDatabase *ReconfigureCloudDatabaseAction `protobuf:"bytes,28,opt,name=reconfigure_cloud_database,json=reconfigureCloudDatabase,proto3,oneof"`
}

func (*AdminAction_CreateUserInstanceConfig) isAdminAction_Action() {}

func (*AdminAction_UpdateUserInstanceConfig) isAdminAction_Action() {}

func (*AdminAction_DeleteUserInstanceConfig) isAdminAction_Action() {}

func (*AdminAction_GetCloudInstanceConfig) isAdminAction_Action() {}

func (*AdminAction_ListInstanceConfigs) isAdminAction_Action() {}

func (*AdminAction_CreateCloudInstance) isAdminAction_Action() {}

func (*AdminAction_UpdateCloudInstance) isAdminAction_Action() {}

func (*AdminAction_DeleteCloudInstance) isAdminAction_Action() {}

func (*AdminAction_ListCloudInstances) isAdminAction_Action() {}

func (*AdminAction_GetCloudInstance) isAdminAction_Action() {}

func (*AdminAction_CreateCloudDatabase) isAdminAction_Action() {}

func (*AdminAction_UpdateCloudDatabaseDdl) isAdminAction_Action() {}

func (*AdminAction_UpdateCloudDatabase) isAdminAction_Action() {}

func (*AdminAction_DropCloudDatabase) isAdminAction_Action() {}

func (*AdminAction_ListCloudDatabases) isAdminAction_Action() {}

func (*AdminAction_ListCloudDatabaseOperations) isAdminAction_Action() {}

func (*AdminAction_RestoreCloudDatabase) isAdminAction_Action() {}

func (*AdminAction_GetCloudDatabase) isAdminAction_Action() {}

func (*AdminAction_CreateCloudBackup) isAdminAction_Action() {}

func (*AdminAction_CopyCloudBackup) isAdminAction_Action() {}

func (*AdminAction_GetCloudBackup) isAdminAction_Action() {}

func (*AdminAction_UpdateCloudBackup) isAdminAction_Action() {}

func (*AdminAction_DeleteCloudBackup) isAdminAction_Action() {}

func (*AdminAction_ListCloudBackups) isAdminAction_Action() {}

func (*AdminAction_ListCloudBackupOperations) isAdminAction_Action() {}

func (*AdminAction_GetOperation) isAdminAction_Action() {}

func (*AdminAction_CancelOperation) isAdminAction_Action() {}

func (*AdminAction_ReconfigureCloudDatabase) isAdminAction_Action() {}

// Action that creates a user instance config.
type CreateUserInstanceConfigAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User instance config ID (not path), e.g. "custom-config".
	UserConfigId string `protobuf:"bytes,1,opt,name=user_config_id,json=userConfigId,proto3" json:"user_config_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Base config ID, e.g. "test-config".
	BaseConfigId string `protobuf:"bytes,3,opt,name=base_config_id,json=baseConfigId,proto3" json:"base_config_id,omitempty"`
	// Replicas that should be included in the user config.
	Replicas []*instancepb.ReplicaInfo `protobuf:"bytes,4,rep,name=replicas,proto3" json:"replicas,omitempty"`
}

func (x *CreateUserInstanceConfigAction) Reset() {
	*x = CreateUserInstanceConfigAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUserInstanceConfigAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUserInstanceConfigAction) ProtoMessage() {}

func (x *CreateUserInstanceConfigAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUserInstanceConfigAction.ProtoReflect.Descriptor instead.
func (*CreateUserInstanceConfigAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{21}
}

func (x *CreateUserInstanceConfigAction) GetUserConfigId() string {
	if x != nil {
		return x.UserConfigId
	}
	return ""
}

func (x *CreateUserInstanceConfigAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateUserInstanceConfigAction) GetBaseConfigId() string {
	if x != nil {
		return x.BaseConfigId
	}
	return ""
}

func (x *CreateUserInstanceConfigAction) GetReplicas() []*instancepb.ReplicaInfo {
	if x != nil {
		return x.Replicas
	}
	return nil
}

// Action that updates a user instance config.
type UpdateUserInstanceConfigAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User instance config ID (not path), e.g. "custom-config".
	UserConfigId string `protobuf:"bytes,1,opt,name=user_config_id,json=userConfigId,proto3" json:"user_config_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The descriptive name for this instance config as it appears in UIs.
	DisplayName *string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3,oneof" json:"display_name,omitempty"`
	// labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *UpdateUserInstanceConfigAction) Reset() {
	*x = UpdateUserInstanceConfigAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUserInstanceConfigAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserInstanceConfigAction) ProtoMessage() {}

func (x *UpdateUserInstanceConfigAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUserInstanceConfigAction.ProtoReflect.Descriptor instead.
func (*UpdateUserInstanceConfigAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateUserInstanceConfigAction) GetUserConfigId() string {
	if x != nil {
		return x.UserConfigId
	}
	return ""
}

func (x *UpdateUserInstanceConfigAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateUserInstanceConfigAction) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

func (x *UpdateUserInstanceConfigAction) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Action that gets a user instance config.
type GetCloudInstanceConfigAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance config ID (not path), e.g. "custom-config".
	InstanceConfigId string `protobuf:"bytes,1,opt,name=instance_config_id,json=instanceConfigId,proto3" json:"instance_config_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *GetCloudInstanceConfigAction) Reset() {
	*x = GetCloudInstanceConfigAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCloudInstanceConfigAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudInstanceConfigAction) ProtoMessage() {}

func (x *GetCloudInstanceConfigAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudInstanceConfigAction.ProtoReflect.Descriptor instead.
func (*GetCloudInstanceConfigAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{23}
}

func (x *GetCloudInstanceConfigAction) GetInstanceConfigId() string {
	if x != nil {
		return x.InstanceConfigId
	}
	return ""
}

func (x *GetCloudInstanceConfigAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Action that deletes a user instance configs.
type DeleteUserInstanceConfigAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User instance config ID (not path), e.g. "custom-config".
	UserConfigId string `protobuf:"bytes,1,opt,name=user_config_id,json=userConfigId,proto3" json:"user_config_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DeleteUserInstanceConfigAction) Reset() {
	*x = DeleteUserInstanceConfigAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUserInstanceConfigAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUserInstanceConfigAction) ProtoMessage() {}

func (x *DeleteUserInstanceConfigAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUserInstanceConfigAction.ProtoReflect.Descriptor instead.
func (*DeleteUserInstanceConfigAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteUserInstanceConfigAction) GetUserConfigId() string {
	if x != nil {
		return x.UserConfigId
	}
	return ""
}

func (x *DeleteUserInstanceConfigAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Action that lists user instance configs.
type ListCloudInstanceConfigsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Number of instance configs to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize *int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3,oneof" json:"page_size,omitempty"`
	// If non-empty, "page_token" should contain a next_page_token
	// from a previous ListInstanceConfigsResponse to the same "parent".
	PageToken *string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
}

func (x *ListCloudInstanceConfigsAction) Reset() {
	*x = ListCloudInstanceConfigsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloudInstanceConfigsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudInstanceConfigsAction) ProtoMessage() {}

func (x *ListCloudInstanceConfigsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudInstanceConfigsAction.ProtoReflect.Descriptor instead.
func (*ListCloudInstanceConfigsAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{25}
}

func (x *ListCloudInstanceConfigsAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListCloudInstanceConfigsAction) GetPageSize() int32 {
	if x != nil && x.PageSize != nil {
		return *x.PageSize
	}
	return 0
}

func (x *ListCloudInstanceConfigsAction) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

// Action that creates a Cloud Spanner instance.
type CreateCloudInstanceAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Instance config ID, e.g. "test-config".
	InstanceConfigId string `protobuf:"bytes,3,opt,name=instance_config_id,json=instanceConfigId,proto3" json:"instance_config_id,omitempty"`
	// Number of nodes (processing_units should not be set or set to 0 if used).
	NodeCount *int32 `protobuf:"varint,4,opt,name=node_count,json=nodeCount,proto3,oneof" json:"node_count,omitempty"`
	// Number of processing units (node_count should be set to 0 if used).
	ProcessingUnits *int32 `protobuf:"varint,6,opt,name=processing_units,json=processingUnits,proto3,oneof" json:"processing_units,omitempty"`
	// The autoscaling config for this instance. If non-empty, an autoscaling
	// instance will be created (processing_units and node_count should be set to
	// 0 if used).
	AutoscalingConfig *instancepb.AutoscalingConfig `protobuf:"bytes,7,opt,name=autoscaling_config,json=autoscalingConfig,proto3,oneof" json:"autoscaling_config,omitempty"`
	// labels.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CreateCloudInstanceAction) Reset() {
	*x = CreateCloudInstanceAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCloudInstanceAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudInstanceAction) ProtoMessage() {}

func (x *CreateCloudInstanceAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudInstanceAction.ProtoReflect.Descriptor instead.
func (*CreateCloudInstanceAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{26}
}

func (x *CreateCloudInstanceAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateCloudInstanceAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateCloudInstanceAction) GetInstanceConfigId() string {
	if x != nil {
		return x.InstanceConfigId
	}
	return ""
}

func (x *CreateCloudInstanceAction) GetNodeCount() int32 {
	if x != nil && x.NodeCount != nil {
		return *x.NodeCount
	}
	return 0
}

func (x *CreateCloudInstanceAction) GetProcessingUnits() int32 {
	if x != nil && x.ProcessingUnits != nil {
		return *x.ProcessingUnits
	}
	return 0
}

func (x *CreateCloudInstanceAction) GetAutoscalingConfig() *instancepb.AutoscalingConfig {
	if x != nil {
		return x.AutoscalingConfig
	}
	return nil
}

func (x *CreateCloudInstanceAction) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Action that updates a Cloud Spanner instance.
type UpdateCloudInstanceAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The descriptive name for this instance as it appears in UIs.
	// Must be unique per project and between 4 and 30 characters in length.
	DisplayName *string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3,oneof" json:"display_name,omitempty"`
	// The number of nodes allocated to this instance. At most one of either
	// node_count or processing_units should be present in the message.
	NodeCount *int32 `protobuf:"varint,4,opt,name=node_count,json=nodeCount,proto3,oneof" json:"node_count,omitempty"`
	// The number of processing units allocated to this instance. At most one of
	// processing_units or node_count should be present in the message.
	ProcessingUnits *int32 `protobuf:"varint,5,opt,name=processing_units,json=processingUnits,proto3,oneof" json:"processing_units,omitempty"`
	// The autoscaling config for this instance. If non-empty, this instance is
	// using autoscaling (processing_units and node_count should be set to
	// 0 if used).
	AutoscalingConfig *instancepb.AutoscalingConfig `protobuf:"bytes,7,opt,name=autoscaling_config,json=autoscalingConfig,proto3,oneof" json:"autoscaling_config,omitempty"`
	// labels.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *UpdateCloudInstanceAction) Reset() {
	*x = UpdateCloudInstanceAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCloudInstanceAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCloudInstanceAction) ProtoMessage() {}

func (x *UpdateCloudInstanceAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCloudInstanceAction.ProtoReflect.Descriptor instead.
func (*UpdateCloudInstanceAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateCloudInstanceAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *UpdateCloudInstanceAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateCloudInstanceAction) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

func (x *UpdateCloudInstanceAction) GetNodeCount() int32 {
	if x != nil && x.NodeCount != nil {
		return *x.NodeCount
	}
	return 0
}

func (x *UpdateCloudInstanceAction) GetProcessingUnits() int32 {
	if x != nil && x.ProcessingUnits != nil {
		return *x.ProcessingUnits
	}
	return 0
}

func (x *UpdateCloudInstanceAction) GetAutoscalingConfig() *instancepb.AutoscalingConfig {
	if x != nil {
		return x.AutoscalingConfig
	}
	return nil
}

func (x *UpdateCloudInstanceAction) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Action that deletes a Cloud Spanner instance.
type DeleteCloudInstanceAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DeleteCloudInstanceAction) Reset() {
	*x = DeleteCloudInstanceAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCloudInstanceAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCloudInstanceAction) ProtoMessage() {}

func (x *DeleteCloudInstanceAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCloudInstanceAction.ProtoReflect.Descriptor instead.
func (*DeleteCloudInstanceAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteCloudInstanceAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *DeleteCloudInstanceAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Action that creates a Cloud Spanner database.
type CreateCloudDatabaseAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud database ID (not full path), e.g. "db0".
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// SDL statements to apply to the new database.
	SdlStatement []string `protobuf:"bytes,4,rep,name=sdl_statement,json=sdlStatement,proto3" json:"sdl_statement,omitempty"`
	// The KMS key used to encrypt the database to be created if the database
	// should be CMEK protected.
	EncryptionConfig *databasepb.EncryptionConfig `protobuf:"bytes,5,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
	// Optional SQL dialect (GOOGLESQL or POSTGRESQL).  Default: GOOGLESQL.
	Dialect          *string `protobuf:"bytes,6,opt,name=dialect,proto3,oneof" json:"dialect,omitempty"`
	ProtoDescriptors []byte  `protobuf:"bytes,7,opt,name=proto_descriptors,json=protoDescriptors,proto3,oneof" json:"proto_descriptors,omitempty"`
}

func (x *CreateCloudDatabaseAction) Reset() {
	*x = CreateCloudDatabaseAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCloudDatabaseAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudDatabaseAction) ProtoMessage() {}

func (x *CreateCloudDatabaseAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudDatabaseAction.ProtoReflect.Descriptor instead.
func (*CreateCloudDatabaseAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{29}
}

func (x *CreateCloudDatabaseAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateCloudDatabaseAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateCloudDatabaseAction) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *CreateCloudDatabaseAction) GetSdlStatement() []string {
	if x != nil {
		return x.SdlStatement
	}
	return nil
}

func (x *CreateCloudDatabaseAction) GetEncryptionConfig() *databasepb.EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

func (x *CreateCloudDatabaseAction) GetDialect() string {
	if x != nil && x.Dialect != nil {
		return *x.Dialect
	}
	return ""
}

func (x *CreateCloudDatabaseAction) GetProtoDescriptors() []byte {
	if x != nil {
		return x.ProtoDescriptors
	}
	return nil
}

// Action that updates the schema of a Cloud Spanner database.
type UpdateCloudDatabaseDdlAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud database ID (not full path), e.g. "db0".
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// SDL statements to apply to the database.
	SdlStatement []string `protobuf:"bytes,4,rep,name=sdl_statement,json=sdlStatement,proto3" json:"sdl_statement,omitempty"`
	// Op ID can be used to track progress of the update. If set, it must be
	// unique per database. If not set, Cloud Spanner will generate operation ID
	// automatically.
	OperationId      string `protobuf:"bytes,5,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	ProtoDescriptors []byte `protobuf:"bytes,6,opt,name=proto_descriptors,json=protoDescriptors,proto3,oneof" json:"proto_descriptors,omitempty"`
}

func (x *UpdateCloudDatabaseDdlAction) Reset() {
	*x = UpdateCloudDatabaseDdlAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCloudDatabaseDdlAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCloudDatabaseDdlAction) ProtoMessage() {}

func (x *UpdateCloudDatabaseDdlAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCloudDatabaseDdlAction.ProtoReflect.Descriptor instead.
func (*UpdateCloudDatabaseDdlAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateCloudDatabaseDdlAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *UpdateCloudDatabaseDdlAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateCloudDatabaseDdlAction) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *UpdateCloudDatabaseDdlAction) GetSdlStatement() []string {
	if x != nil {
		return x.SdlStatement
	}
	return nil
}

func (x *UpdateCloudDatabaseDdlAction) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *UpdateCloudDatabaseDdlAction) GetProtoDescriptors() []byte {
	if x != nil {
		return x.ProtoDescriptors
	}
	return nil
}

// Action that updates a Cloud Spanner database.
type UpdateCloudDatabaseAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud database name (not full path), e.g. "db0".
	DatabaseName string `protobuf:"bytes,3,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Updated value of enable_drop_protection, this is the only field that has
	// supported to be updated.
	EnableDropProtection bool `protobuf:"varint,4,opt,name=enable_drop_protection,json=enableDropProtection,proto3" json:"enable_drop_protection,omitempty"`
}

func (x *UpdateCloudDatabaseAction) Reset() {
	*x = UpdateCloudDatabaseAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCloudDatabaseAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCloudDatabaseAction) ProtoMessage() {}

func (x *UpdateCloudDatabaseAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCloudDatabaseAction.ProtoReflect.Descriptor instead.
func (*UpdateCloudDatabaseAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateCloudDatabaseAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *UpdateCloudDatabaseAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateCloudDatabaseAction) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *UpdateCloudDatabaseAction) GetEnableDropProtection() bool {
	if x != nil {
		return x.EnableDropProtection
	}
	return false
}

// Action that drops a Cloud Spanner database.
type DropCloudDatabaseAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud database ID (not full path), e.g. "db0".
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
}

func (x *DropCloudDatabaseAction) Reset() {
	*x = DropCloudDatabaseAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DropCloudDatabaseAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DropCloudDatabaseAction) ProtoMessage() {}

func (x *DropCloudDatabaseAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DropCloudDatabaseAction.ProtoReflect.Descriptor instead.
func (*DropCloudDatabaseAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{32}
}

func (x *DropCloudDatabaseAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *DropCloudDatabaseAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DropCloudDatabaseAction) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

// Action that reconfigures a Cloud Spanner database.
type ReconfigureCloudDatabaseAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully qualified uri of the database to be reconfigured.
	DatabaseUri *string `protobuf:"bytes,1,opt,name=database_uri,json=databaseUri,proto3,oneof" json:"database_uri,omitempty"`
	// The locations of the serving regions, e.g. "asia-south1".
	ServingLocations []string `protobuf:"bytes,2,rep,name=serving_locations,json=servingLocations,proto3" json:"serving_locations,omitempty"`
}

func (x *ReconfigureCloudDatabaseAction) Reset() {
	*x = ReconfigureCloudDatabaseAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReconfigureCloudDatabaseAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconfigureCloudDatabaseAction) ProtoMessage() {}

func (x *ReconfigureCloudDatabaseAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconfigureCloudDatabaseAction.ProtoReflect.Descriptor instead.
func (*ReconfigureCloudDatabaseAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{33}
}

func (x *ReconfigureCloudDatabaseAction) GetDatabaseUri() string {
	if x != nil && x.DatabaseUri != nil {
		return *x.DatabaseUri
	}
	return ""
}

func (x *ReconfigureCloudDatabaseAction) GetServingLocations() []string {
	if x != nil {
		return x.ServingLocations
	}
	return nil
}

// Action that lists Cloud Spanner databases.
type ListCloudDatabasesAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path) to list databases from, e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Number of databases to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, "page_token" should contain a next_page_token
	// from a previous ListDatabasesResponse to the same "parent"
	// and with the same "filter".
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCloudDatabasesAction) Reset() {
	*x = ListCloudDatabasesAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloudDatabasesAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudDatabasesAction) ProtoMessage() {}

func (x *ListCloudDatabasesAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudDatabasesAction.ProtoReflect.Descriptor instead.
func (*ListCloudDatabasesAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{34}
}

func (x *ListCloudDatabasesAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListCloudDatabasesAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *ListCloudDatabasesAction) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudDatabasesAction) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Action that lists Cloud Spanner databases.
type ListCloudInstancesAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A filter expression that filters what operations are returned in the
	// response.
	// The expression must specify the field name, a comparison operator,
	// and the value that you want to use for filtering.
	// Refer spanner_instance_admin.proto.ListInstancesRequest for
	// detail.
	Filter *string `protobuf:"bytes,2,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Number of instances to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize *int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3,oneof" json:"page_size,omitempty"`
	// If non-empty, "page_token" should contain a next_page_token
	// from a previous ListInstancesResponse to the same "parent"
	// and with the same "filter".
	PageToken *string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
}

func (x *ListCloudInstancesAction) Reset() {
	*x = ListCloudInstancesAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloudInstancesAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudInstancesAction) ProtoMessage() {}

func (x *ListCloudInstancesAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudInstancesAction.ProtoReflect.Descriptor instead.
func (*ListCloudInstancesAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{35}
}

func (x *ListCloudInstancesAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListCloudInstancesAction) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *ListCloudInstancesAction) GetPageSize() int32 {
	if x != nil && x.PageSize != nil {
		return *x.PageSize
	}
	return 0
}

func (x *ListCloudInstancesAction) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

// Action that retrieves a Cloud Spanner instance.
type GetCloudInstanceAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path) to retrieve the instance from,
	// e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
}

func (x *GetCloudInstanceAction) Reset() {
	*x = GetCloudInstanceAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCloudInstanceAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudInstanceAction) ProtoMessage() {}

func (x *GetCloudInstanceAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudInstanceAction.ProtoReflect.Descriptor instead.
func (*GetCloudInstanceAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{36}
}

func (x *GetCloudInstanceAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetCloudInstanceAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

// Action that lists Cloud Spanner database operations.
type ListCloudDatabaseOperationsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path) to list database operations from,
	// e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// A filter expression that filters what operations are returned in the
	// response.
	// The expression must specify the field name, a comparison operator,
	// and the value that you want to use for filtering.
	// Refer spanner_database_admin.proto.ListDatabaseOperationsRequest for
	// detail.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of databases to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, "page_token" should contain a next_page_token
	// from a previous ListDatabaseOperationsResponse to the same "parent"
	// and with the same "filter".
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCloudDatabaseOperationsAction) Reset() {
	*x = ListCloudDatabaseOperationsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloudDatabaseOperationsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudDatabaseOperationsAction) ProtoMessage() {}

func (x *ListCloudDatabaseOperationsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudDatabaseOperationsAction.ProtoReflect.Descriptor instead.
func (*ListCloudDatabaseOperationsAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{37}
}

func (x *ListCloudDatabaseOperationsAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListCloudDatabaseOperationsAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *ListCloudDatabaseOperationsAction) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCloudDatabaseOperationsAction) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudDatabaseOperationsAction) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Action that restores a Cloud Spanner database from a backup.
type RestoreCloudDatabaseAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
	BackupInstanceId string `protobuf:"bytes,2,opt,name=backup_instance_id,json=backupInstanceId,proto3" json:"backup_instance_id,omitempty"`
	// The id of the backup from which to restore, e.g. "test-backup".
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Cloud instance ID (not path) containing the database, e.g.
	// "database-instance".
	DatabaseInstanceId string `protobuf:"bytes,4,opt,name=database_instance_id,json=databaseInstanceId,proto3" json:"database_instance_id,omitempty"`
	// The id of the database to create and restore to, e.g. "db0". Note that this
	// database must not already exist.
	DatabaseId string `protobuf:"bytes,5,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
}

func (x *RestoreCloudDatabaseAction) Reset() {
	*x = RestoreCloudDatabaseAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreCloudDatabaseAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreCloudDatabaseAction) ProtoMessage() {}

func (x *RestoreCloudDatabaseAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreCloudDatabaseAction.ProtoReflect.Descriptor instead.
func (*RestoreCloudDatabaseAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{38}
}

func (x *RestoreCloudDatabaseAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RestoreCloudDatabaseAction) GetBackupInstanceId() string {
	if x != nil {
		return x.BackupInstanceId
	}
	return ""
}

func (x *RestoreCloudDatabaseAction) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *RestoreCloudDatabaseAction) GetDatabaseInstanceId() string {
	if x != nil {
		return x.DatabaseInstanceId
	}
	return ""
}

func (x *RestoreCloudDatabaseAction) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

// Action that gets a Cloud Spanner database.
type GetCloudDatabaseAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The id of the database to get, e.g. "db0".
	DatabaseId string `protobuf:"bytes,3,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
}

func (x *GetCloudDatabaseAction) Reset() {
	*x = GetCloudDatabaseAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCloudDatabaseAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudDatabaseAction) ProtoMessage() {}

func (x *GetCloudDatabaseAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudDatabaseAction.ProtoReflect.Descriptor instead.
func (*GetCloudDatabaseAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{39}
}

func (x *GetCloudDatabaseAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetCloudDatabaseAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *GetCloudDatabaseAction) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

// Action that creates a Cloud Spanner database backup.
type CreateCloudBackupAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The id of the backup to be created, e.g. "test-backup".
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// The id of the database from which this backup was
	// created, e.g. "db0". Note that this needs to be in the
	// same instance as the backup.
	DatabaseId string `protobuf:"bytes,4,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// Output only. The expiration time of the backup, which must be at least 6
	// hours and at most 366 days from the time the request is received.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// The version time of the backup, which must be within the time range of
	// [earliest_version_time, NOW], where earliest_version_time is retrieved by
	// cloud spanner frontend API (See details: go/cs-pitr-lite-design).
	VersionTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=version_time,json=versionTime,proto3,oneof" json:"version_time,omitempty"`
}

func (x *CreateCloudBackupAction) Reset() {
	*x = CreateCloudBackupAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCloudBackupAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudBackupAction) ProtoMessage() {}

func (x *CreateCloudBackupAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudBackupAction.ProtoReflect.Descriptor instead.
func (*CreateCloudBackupAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{40}
}

func (x *CreateCloudBackupAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateCloudBackupAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateCloudBackupAction) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *CreateCloudBackupAction) GetDatabaseId() string {
	if x != nil {
		return x.DatabaseId
	}
	return ""
}

func (x *CreateCloudBackupAction) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *CreateCloudBackupAction) GetVersionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VersionTime
	}
	return nil
}

// Action that copies a Cloud Spanner database backup.
type CopyCloudBackupAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The id of the backup to be created, e.g. "test-backup".
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// The fully qualified uri of the source backup from which this
	// backup was copied. eg.
	// "projects/<project_id>/instances/<instance_id>/backups/<backup_id>".
	SourceBackup string `protobuf:"bytes,4,opt,name=source_backup,json=sourceBackup,proto3" json:"source_backup,omitempty"`
	// Output only. The expiration time of the backup, which must be at least 6
	// hours and at most 366 days from the time the request is received.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *CopyCloudBackupAction) Reset() {
	*x = CopyCloudBackupAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CopyCloudBackupAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CopyCloudBackupAction) ProtoMessage() {}

func (x *CopyCloudBackupAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CopyCloudBackupAction.ProtoReflect.Descriptor instead.
func (*CopyCloudBackupAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{41}
}

func (x *CopyCloudBackupAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CopyCloudBackupAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CopyCloudBackupAction) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *CopyCloudBackupAction) GetSourceBackup() string {
	if x != nil {
		return x.SourceBackup
	}
	return ""
}

func (x *CopyCloudBackupAction) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Action that gets a Cloud Spanner database backup.
type GetCloudBackupAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The id of the backup to get, e.g. "test-backup".
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
}

func (x *GetCloudBackupAction) Reset() {
	*x = GetCloudBackupAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCloudBackupAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudBackupAction) ProtoMessage() {}

func (x *GetCloudBackupAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudBackupAction.ProtoReflect.Descriptor instead.
func (*GetCloudBackupAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{42}
}

func (x *GetCloudBackupAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetCloudBackupAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *GetCloudBackupAction) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

// Action that updates a Cloud Spanner database backup.
type UpdateCloudBackupAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The id of the backup to update, e.g. "test-backup".
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Output only. Updated value of expire_time, this is the only field
	// that supported to be updated.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *UpdateCloudBackupAction) Reset() {
	*x = UpdateCloudBackupAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCloudBackupAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCloudBackupAction) ProtoMessage() {}

func (x *UpdateCloudBackupAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCloudBackupAction.ProtoReflect.Descriptor instead.
func (*UpdateCloudBackupAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{43}
}

func (x *UpdateCloudBackupAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateCloudBackupAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *UpdateCloudBackupAction) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *UpdateCloudBackupAction) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Action that deletes a Cloud Spanner database backup.
type DeleteCloudBackupAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path), e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The id of the backup to delete, e.g. "test-backup".
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
}

func (x *DeleteCloudBackupAction) Reset() {
	*x = DeleteCloudBackupAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCloudBackupAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCloudBackupAction) ProtoMessage() {}

func (x *DeleteCloudBackupAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCloudBackupAction.ProtoReflect.Descriptor instead.
func (*DeleteCloudBackupAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{44}
}

func (x *DeleteCloudBackupAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteCloudBackupAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *DeleteCloudBackupAction) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

// Action that lists Cloud Spanner database backups.
type ListCloudBackupsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path) to list backups from, e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// A filter expression that filters backups listed in the response.
	// The expression must specify the field name, a comparison operator,
	// and the value that you want to use for filtering.
	// Refer backup.proto.ListBackupsRequest for detail.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of backups to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, "page_token" should contain a next_page_token
	// from a previous ListBackupsResponse to the same "parent"
	// and with the same "filter".
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCloudBackupsAction) Reset() {
	*x = ListCloudBackupsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloudBackupsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudBackupsAction) ProtoMessage() {}

func (x *ListCloudBackupsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudBackupsAction.ProtoReflect.Descriptor instead.
func (*ListCloudBackupsAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{45}
}

func (x *ListCloudBackupsAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListCloudBackupsAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *ListCloudBackupsAction) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCloudBackupsAction) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudBackupsAction) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Action that lists Cloud Spanner database backup operations.
type ListCloudBackupOperationsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project ID, e.g. "spanner-cloud-systest".
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Cloud instance ID (not path) to list backup operations from,
	// e.g. "test-instance".
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// A filter expression that filters what operations are returned in the
	// response.
	// The expression must specify the field name, a comparison operator,
	// and the value that you want to use for filtering.
	// Refer backup.proto.ListBackupOperationsRequest for detail.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of backups to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, "page_token" should contain a next_page_token
	// from a previous ListBackupOperationsResponse to the same "parent"
	// and with the same "filter".
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCloudBackupOperationsAction) Reset() {
	*x = ListCloudBackupOperationsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCloudBackupOperationsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudBackupOperationsAction) ProtoMessage() {}

func (x *ListCloudBackupOperationsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudBackupOperationsAction.ProtoReflect.Descriptor instead.
func (*ListCloudBackupOperationsAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{46}
}

func (x *ListCloudBackupOperationsAction) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListCloudBackupOperationsAction) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *ListCloudBackupOperationsAction) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCloudBackupOperationsAction) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudBackupOperationsAction) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Action that gets an operation.
type GetOperationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the operation resource.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (x *GetOperationAction) Reset() {
	*x = GetOperationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOperationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOperationAction) ProtoMessage() {}

func (x *GetOperationAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOperationAction.ProtoReflect.Descriptor instead.
func (*GetOperationAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{47}
}

func (x *GetOperationAction) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

// Action that cancels an operation.
type CancelOperationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the operation resource to be cancelled.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (x *CancelOperationAction) Reset() {
	*x = CancelOperationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelOperationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelOperationAction) ProtoMessage() {}

func (x *CancelOperationAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelOperationAction.ProtoReflect.Descriptor instead.
func (*CancelOperationAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{48}
}

func (x *CancelOperationAction) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

// Starts a batch read-only transaction in executor. Successful outcomes of this
// action will contain batch_txn_id--the identificator that can be used to start
// the same transaction in other Executors to parallelize partition processing.
//
// Example of a batch read flow:
// 1. Start batch transaction with a timestamp (StartBatchTransactionAction)
// 2. Generate database partitions for a read or query
// (GenerateDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction)
// 3. Call ExecutePartitionAction for some or all partitions, process rows
// 4. Clean up the transaction (CloseBatchTransactionAction).
//
// More sophisticated example, with parallel processing:
// 1. Start batch transaction with a timestamp (StartBatchTransactionAction),
// note the returned BatchTransactionId
// 2. Generate database partitions for a read or query
// (GenerateDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction)
// 3. Distribute the partitions over a pool of workers, along with the
// transaction ID.
//
// In each worker:
// 4-1. StartBatchTransactionAction with the given transaction ID
// 4-2. ExecutePartitionAction for each partition it got, process read results
// 4-3. Close (not cleanup) the transaction (CloseBatchTransactionAction).
//
// When all workers are done:
// 5. Cleanup the transaction (CloseBatchTransactionAction). This can be done
// either by the last worker to finish the job, or by the main Executor that
// initialized this transaction in the first place. It is also possible to clean
// it up with a brand new Executor -- just execute StartBatchTransactionAction
// with the ID, then clean it up right away.
//
// Cleaning up is optional, but recommended.
type StartBatchTransactionAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// To start a new transaction, specify an exact timestamp. Alternatively, an
	// existing batch transaction ID can be used. Either one of two must be
	// set.
	//
	// Types that are assignable to Param:
	//
	//	*StartBatchTransactionAction_BatchTxnTime
	//	*StartBatchTransactionAction_Tid
	Param isStartBatchTransactionAction_Param `protobuf_oneof:"param"`
	// Database role to assume while performing this action. Setting the
	// database_role will enforce additional role-based access checks on this
	// action.
	CloudDatabaseRole string `protobuf:"bytes,3,opt,name=cloud_database_role,json=cloudDatabaseRole,proto3" json:"cloud_database_role,omitempty"`
}

func (x *StartBatchTransactionAction) Reset() {
	*x = StartBatchTransactionAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartBatchTransactionAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartBatchTransactionAction) ProtoMessage() {}

func (x *StartBatchTransactionAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartBatchTransactionAction.ProtoReflect.Descriptor instead.
func (*StartBatchTransactionAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{49}
}

func (m *StartBatchTransactionAction) GetParam() isStartBatchTransactionAction_Param {
	if m != nil {
		return m.Param
	}
	return nil
}

func (x *StartBatchTransactionAction) GetBatchTxnTime() *timestamppb.Timestamp {
	if x, ok := x.GetParam().(*StartBatchTransactionAction_BatchTxnTime); ok {
		return x.BatchTxnTime
	}
	return nil
}

func (x *StartBatchTransactionAction) GetTid() []byte {
	if x, ok := x.GetParam().(*StartBatchTransactionAction_Tid); ok {
		return x.Tid
	}
	return nil
}

func (x *StartBatchTransactionAction) GetCloudDatabaseRole() string {
	if x != nil {
		return x.CloudDatabaseRole
	}
	return ""
}

type isStartBatchTransactionAction_Param interface {
	isStartBatchTransactionAction_Param()
}

type StartBatchTransactionAction_BatchTxnTime struct {
	// The exact timestamp to start the batch transaction.
	BatchTxnTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=batch_txn_time,json=batchTxnTime,proto3,oneof"`
}

type StartBatchTransactionAction_Tid struct {
	// ID of a batch read-only transaction. It can be used to start the same
	// batch transaction on multiple executors and parallelize partition
	// processing.
	Tid []byte `protobuf:"bytes,2,opt,name=tid,proto3,oneof"`
}

func (*StartBatchTransactionAction_BatchTxnTime) isStartBatchTransactionAction_Param() {}

func (*StartBatchTransactionAction_Tid) isStartBatchTransactionAction_Param() {}

// Closes or cleans up the currently opened batch read-only transaction.
//
// Once a transaction is closed, the Executor can be disposed of or used to
// start start another transaction. Closing a batch transaction in one Executor
// doesn't affect the transaction's state in other Executors that also read from
// it.
//
// When a transaction is cleaned up, it becomes globally invalid. Cleaning up is
// optional, but recommended.
type CloseBatchTransactionAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the transaction needs to be cleaned up.
	Cleanup bool `protobuf:"varint,1,opt,name=cleanup,proto3" json:"cleanup,omitempty"`
}

func (x *CloseBatchTransactionAction) Reset() {
	*x = CloseBatchTransactionAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseBatchTransactionAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseBatchTransactionAction) ProtoMessage() {}

func (x *CloseBatchTransactionAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseBatchTransactionAction.ProtoReflect.Descriptor instead.
func (*CloseBatchTransactionAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{50}
}

func (x *CloseBatchTransactionAction) GetCleanup() bool {
	if x != nil {
		return x.Cleanup
	}
	return false
}

// Generate database partitions for the given read. Successful outcomes will
// contain database partitions in the db_partition field.
type GenerateDbPartitionsForReadAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Read to generate partitions for.
	Read *ReadAction `protobuf:"bytes,1,opt,name=read,proto3" json:"read,omitempty"`
	// Metadata related to the tables involved in the read.
	Table []*TableMetadata `protobuf:"bytes,2,rep,name=table,proto3" json:"table,omitempty"`
	// Desired size of data in each partition. Spanner doesn't guarantee to
	// respect this value.
	DesiredBytesPerPartition *int64 `protobuf:"varint,3,opt,name=desired_bytes_per_partition,json=desiredBytesPerPartition,proto3,oneof" json:"desired_bytes_per_partition,omitempty"`
	// If set, the desired max number of partitions. Spanner doesn't guarantee to
	// respect this value.
	MaxPartitionCount *int64 `protobuf:"varint,4,opt,name=max_partition_count,json=maxPartitionCount,proto3,oneof" json:"max_partition_count,omitempty"`
}

func (x *GenerateDbPartitionsForReadAction) Reset() {
	*x = GenerateDbPartitionsForReadAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDbPartitionsForReadAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDbPartitionsForReadAction) ProtoMessage() {}

func (x *GenerateDbPartitionsForReadAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDbPartitionsForReadAction.ProtoReflect.Descriptor instead.
func (*GenerateDbPartitionsForReadAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{51}
}

func (x *GenerateDbPartitionsForReadAction) GetRead() *ReadAction {
	if x != nil {
		return x.Read
	}
	return nil
}

func (x *GenerateDbPartitionsForReadAction) GetTable() []*TableMetadata {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *GenerateDbPartitionsForReadAction) GetDesiredBytesPerPartition() int64 {
	if x != nil && x.DesiredBytesPerPartition != nil {
		return *x.DesiredBytesPerPartition
	}
	return 0
}

func (x *GenerateDbPartitionsForReadAction) GetMaxPartitionCount() int64 {
	if x != nil && x.MaxPartitionCount != nil {
		return *x.MaxPartitionCount
	}
	return 0
}

// Generate database partitions for the given query. Successful outcomes will
// contain database partitions in the db_partition field.
type GenerateDbPartitionsForQueryAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Query to generate partitions for.
	Query *QueryAction `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Desired size of data in each partition. Spanner doesn't guarantee to
	// respect this value.
	DesiredBytesPerPartition *int64 `protobuf:"varint,2,opt,name=desired_bytes_per_partition,json=desiredBytesPerPartition,proto3,oneof" json:"desired_bytes_per_partition,omitempty"`
}

func (x *GenerateDbPartitionsForQueryAction) Reset() {
	*x = GenerateDbPartitionsForQueryAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDbPartitionsForQueryAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDbPartitionsForQueryAction) ProtoMessage() {}

func (x *GenerateDbPartitionsForQueryAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDbPartitionsForQueryAction.ProtoReflect.Descriptor instead.
func (*GenerateDbPartitionsForQueryAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{52}
}

func (x *GenerateDbPartitionsForQueryAction) GetQuery() *QueryAction {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *GenerateDbPartitionsForQueryAction) GetDesiredBytesPerPartition() int64 {
	if x != nil && x.DesiredBytesPerPartition != nil {
		return *x.DesiredBytesPerPartition
	}
	return 0
}

// Identifies a database partition generated for a particular read or query. To
// read rows from the partition, use ExecutePartitionAction.
type BatchPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Serialized Partition instance.
	Partition []byte `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// The partition token decrypted from partition.
	PartitionToken []byte `protobuf:"bytes,2,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	// Table name is set iff the partition was generated for a read (as opposed to
	// a query).
	Table *string `protobuf:"bytes,3,opt,name=table,proto3,oneof" json:"table,omitempty"`
	// Index name if the partition was generated for an index read.
	Index *string `protobuf:"bytes,4,opt,name=index,proto3,oneof" json:"index,omitempty"`
}

func (x *BatchPartition) Reset() {
	*x = BatchPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPartition) ProtoMessage() {}

func (x *BatchPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPartition.ProtoReflect.Descriptor instead.
func (*BatchPartition) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{53}
}

func (x *BatchPartition) GetPartition() []byte {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (x *BatchPartition) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

func (x *BatchPartition) GetTable() string {
	if x != nil && x.Table != nil {
		return *x.Table
	}
	return ""
}

func (x *BatchPartition) GetIndex() string {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return ""
}

// Performs a read or query for the given partitions. This action must be
// executed in the context of the same transaction that was used to generate
// given partitions.
type ExecutePartitionAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Batch partition to execute on.
	Partition *BatchPartition `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (x *ExecutePartitionAction) Reset() {
	*x = ExecutePartitionAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutePartitionAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutePartitionAction) ProtoMessage() {}

func (x *ExecutePartitionAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutePartitionAction.ProtoReflect.Descriptor instead.
func (*ExecutePartitionAction) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{54}
}

func (x *ExecutePartitionAction) GetPartition() *BatchPartition {
	if x != nil {
		return x.Partition
	}
	return nil
}

// Execute a change stream TVF query.
type ExecuteChangeStreamQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name for this change stream.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies that records with commit_timestamp greater than or equal to
	// start_time should be returned.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Specifies that records with commit_timestamp less than or equal to
	// end_time should be returned.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3,oneof" json:"end_time,omitempty"`
	// Specifies which change stream partition to query, based on the content of
	// child partitions records.
	PartitionToken *string `protobuf:"bytes,4,opt,name=partition_token,json=partitionToken,proto3,oneof" json:"partition_token,omitempty"`
	// Read options for this change stream query.
	ReadOptions []string `protobuf:"bytes,5,rep,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// Determines how frequently a heartbeat ChangeRecord will be returned in case
	// there are no transactions committed in this partition, in milliseconds.
	HeartbeatMilliseconds *int32 `protobuf:"varint,6,opt,name=heartbeat_milliseconds,json=heartbeatMilliseconds,proto3,oneof" json:"heartbeat_milliseconds,omitempty"`
	// Deadline for this change stream query, in seconds.
	DeadlineSeconds *int64 `protobuf:"varint,7,opt,name=deadline_seconds,json=deadlineSeconds,proto3,oneof" json:"deadline_seconds,omitempty"`
	// Database role to assume while performing this action. This should only be
	// set for cloud requests. Setting the database role will enforce additional
	// role-based access checks on this action.
	CloudDatabaseRole *string `protobuf:"bytes,8,opt,name=cloud_database_role,json=cloudDatabaseRole,proto3,oneof" json:"cloud_database_role,omitempty"`
}

func (x *ExecuteChangeStreamQuery) Reset() {
	*x = ExecuteChangeStreamQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteChangeStreamQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteChangeStreamQuery) ProtoMessage() {}

func (x *ExecuteChangeStreamQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteChangeStreamQuery.ProtoReflect.Descriptor instead.
func (*ExecuteChangeStreamQuery) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{55}
}

func (x *ExecuteChangeStreamQuery) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecuteChangeStreamQuery) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExecuteChangeStreamQuery) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExecuteChangeStreamQuery) GetPartitionToken() string {
	if x != nil && x.PartitionToken != nil {
		return *x.PartitionToken
	}
	return ""
}

func (x *ExecuteChangeStreamQuery) GetReadOptions() []string {
	if x != nil {
		return x.ReadOptions
	}
	return nil
}

func (x *ExecuteChangeStreamQuery) GetHeartbeatMilliseconds() int32 {
	if x != nil && x.HeartbeatMilliseconds != nil {
		return *x.HeartbeatMilliseconds
	}
	return 0
}

func (x *ExecuteChangeStreamQuery) GetDeadlineSeconds() int64 {
	if x != nil && x.DeadlineSeconds != nil {
		return *x.DeadlineSeconds
	}
	return 0
}

func (x *ExecuteChangeStreamQuery) GetCloudDatabaseRole() string {
	if x != nil && x.CloudDatabaseRole != nil {
		return *x.CloudDatabaseRole
	}
	return ""
}

// SpannerActionOutcome defines a result of execution of a single SpannerAction.
type SpannerActionOutcome struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If an outcome is split into multiple parts, status will be set only in the
	// last part.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3,oneof" json:"status,omitempty"`
	// Transaction timestamp. It must be set for successful committed actions.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=commit_time,json=commitTime,proto3,oneof" json:"commit_time,omitempty"`
	// Result of a ReadAction. This field must be set for ReadActions even if
	// no rows were read.
	ReadResult *ReadResult `protobuf:"bytes,3,opt,name=read_result,json=readResult,proto3,oneof" json:"read_result,omitempty"`
	// Result of a Query. This field must be set for Queries even if no rows were
	// read.
	QueryResult *QueryResult `protobuf:"bytes,4,opt,name=query_result,json=queryResult,proto3,oneof" json:"query_result,omitempty"`
	// This bit indicates that Spanner has restarted the current transaction. It
	// means that the client should replay all the reads and writes.
	// Setting it to true is only valid in the context of a read-write
	// transaction, as an outcome of a committing FinishTransactionAction.
	TransactionRestarted *bool `protobuf:"varint,5,opt,name=transaction_restarted,json=transactionRestarted,proto3,oneof" json:"transaction_restarted,omitempty"`
	// In successful StartBatchTransactionAction outcomes, this contains the ID of
	// the transaction.
	BatchTxnId []byte `protobuf:"bytes,6,opt,name=batch_txn_id,json=batchTxnId,proto3,oneof" json:"batch_txn_id,omitempty"`
	// Generated database partitions (result of a
	// GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
	DbPartition []*BatchPartition `protobuf:"bytes,7,rep,name=db_partition,json=dbPartition,proto3" json:"db_partition,omitempty"`
	// Result of admin related actions.
	AdminResult *AdminResult `protobuf:"bytes,8,opt,name=admin_result,json=adminResult,proto3,oneof" json:"admin_result,omitempty"`
	// Stores rows modified by query in single DML or batch DML action.
	// In case of batch DML action, stores 0 as row count of errored DML query.
	DmlRowsModified []int64 `protobuf:"varint,9,rep,packed,name=dml_rows_modified,json=dmlRowsModified,proto3" json:"dml_rows_modified,omitempty"`
	// Change stream records returned by a change stream query.
	ChangeStreamRecords []*ChangeStreamRecord `protobuf:"bytes,10,rep,name=change_stream_records,json=changeStreamRecords,proto3" json:"change_stream_records,omitempty"`
}

func (x *SpannerActionOutcome) Reset() {
	*x = SpannerActionOutcome{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpannerActionOutcome) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpannerActionOutcome) ProtoMessage() {}

func (x *SpannerActionOutcome) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpannerActionOutcome.ProtoReflect.Descriptor instead.
func (*SpannerActionOutcome) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{56}
}

func (x *SpannerActionOutcome) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *SpannerActionOutcome) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

func (x *SpannerActionOutcome) GetReadResult() *ReadResult {
	if x != nil {
		return x.ReadResult
	}
	return nil
}

func (x *SpannerActionOutcome) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *SpannerActionOutcome) GetTransactionRestarted() bool {
	if x != nil && x.TransactionRestarted != nil {
		return *x.TransactionRestarted
	}
	return false
}

func (x *SpannerActionOutcome) GetBatchTxnId() []byte {
	if x != nil {
		return x.BatchTxnId
	}
	return nil
}

func (x *SpannerActionOutcome) GetDbPartition() []*BatchPartition {
	if x != nil {
		return x.DbPartition
	}
	return nil
}

func (x *SpannerActionOutcome) GetAdminResult() *AdminResult {
	if x != nil {
		return x.AdminResult
	}
	return nil
}

func (x *SpannerActionOutcome) GetDmlRowsModified() []int64 {
	if x != nil {
		return x.DmlRowsModified
	}
	return nil
}

func (x *SpannerActionOutcome) GetChangeStreamRecords() []*ChangeStreamRecord {
	if x != nil {
		return x.ChangeStreamRecords
	}
	return nil
}

// AdminResult contains admin action results, for database/backup/operation.
type AdminResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of cloud backup related actions.
	BackupResponse *CloudBackupResponse `protobuf:"bytes,1,opt,name=backup_response,json=backupResponse,proto3" json:"backup_response,omitempty"`
	// Results of operation related actions.
	OperationResponse *OperationResponse `protobuf:"bytes,2,opt,name=operation_response,json=operationResponse,proto3" json:"operation_response,omitempty"`
	// Results of database related actions.
	DatabaseResponse *CloudDatabaseResponse `protobuf:"bytes,3,opt,name=database_response,json=databaseResponse,proto3" json:"database_response,omitempty"`
	// Results of instance related actions.
	InstanceResponse *CloudInstanceResponse `protobuf:"bytes,4,opt,name=instance_response,json=instanceResponse,proto3" json:"instance_response,omitempty"`
	// Results of instance config related actions.
	InstanceConfigResponse *CloudInstanceConfigResponse `protobuf:"bytes,5,opt,name=instance_config_response,json=instanceConfigResponse,proto3" json:"instance_config_response,omitempty"`
}

func (x *AdminResult) Reset() {
	*x = AdminResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdminResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdminResult) ProtoMessage() {}

func (x *AdminResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdminResult.ProtoReflect.Descriptor instead.
func (*AdminResult) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{57}
}

func (x *AdminResult) GetBackupResponse() *CloudBackupResponse {
	if x != nil {
		return x.BackupResponse
	}
	return nil
}

func (x *AdminResult) GetOperationResponse() *OperationResponse {
	if x != nil {
		return x.OperationResponse
	}
	return nil
}

func (x *AdminResult) GetDatabaseResponse() *CloudDatabaseResponse {
	if x != nil {
		return x.DatabaseResponse
	}
	return nil
}

func (x *AdminResult) GetInstanceResponse() *CloudInstanceResponse {
	if x != nil {
		return x.InstanceResponse
	}
	return nil
}

func (x *AdminResult) GetInstanceConfigResponse() *CloudInstanceConfigResponse {
	if x != nil {
		return x.InstanceConfigResponse
	}
	return nil
}

// CloudBackupResponse contains results returned by cloud backup related
// actions.
type CloudBackupResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of backups returned by ListCloudBackupsAction.
	ListedBackups []*databasepb.Backup `protobuf:"bytes,1,rep,name=listed_backups,json=listedBackups,proto3" json:"listed_backups,omitempty"`
	// List of operations returned by ListCloudBackupOperationsAction.
	ListedBackupOperations []*longrunningpb.Operation `protobuf:"bytes,2,rep,name=listed_backup_operations,json=listedBackupOperations,proto3" json:"listed_backup_operations,omitempty"`
	// "next_page_token" can be sent in a subsequent list action
	// to fetch more of the matching data.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Backup returned by GetCloudBackupAction/UpdateCloudBackupAction.
	Backup *databasepb.Backup `protobuf:"bytes,4,opt,name=backup,proto3" json:"backup,omitempty"`
}

func (x *CloudBackupResponse) Reset() {
	*x = CloudBackupResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudBackupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudBackupResponse) ProtoMessage() {}

func (x *CloudBackupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudBackupResponse.ProtoReflect.Descriptor instead.
func (*CloudBackupResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{58}
}

func (x *CloudBackupResponse) GetListedBackups() []*databasepb.Backup {
	if x != nil {
		return x.ListedBackups
	}
	return nil
}

func (x *CloudBackupResponse) GetListedBackupOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.ListedBackupOperations
	}
	return nil
}

func (x *CloudBackupResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *CloudBackupResponse) GetBackup() *databasepb.Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

// OperationResponse contains results returned by operation related actions.
type OperationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of operations returned by ListOperationsAction.
	ListedOperations []*longrunningpb.Operation `protobuf:"bytes,1,rep,name=listed_operations,json=listedOperations,proto3" json:"listed_operations,omitempty"`
	// "next_page_token" can be sent in a subsequent list action
	// to fetch more of the matching data.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Operation returned by GetOperationAction.
	Operation *longrunningpb.Operation `protobuf:"bytes,3,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (x *OperationResponse) Reset() {
	*x = OperationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationResponse) ProtoMessage() {}

func (x *OperationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationResponse.ProtoReflect.Descriptor instead.
func (*OperationResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{59}
}

func (x *OperationResponse) GetListedOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.ListedOperations
	}
	return nil
}

func (x *OperationResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *OperationResponse) GetOperation() *longrunningpb.Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

// CloudInstanceResponse contains results returned by cloud instance related
// actions.
type CloudInstanceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of instances returned by ListCloudInstancesAction.
	ListedInstances []*instancepb.Instance `protobuf:"bytes,1,rep,name=listed_instances,json=listedInstances,proto3" json:"listed_instances,omitempty"`
	// "next_page_token" can be sent in a subsequent list action
	// to fetch more of the matching data.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Instance returned by GetCloudInstanceAction
	Instance *instancepb.Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *CloudInstanceResponse) Reset() {
	*x = CloudInstanceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudInstanceResponse) ProtoMessage() {}

func (x *CloudInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudInstanceResponse.ProtoReflect.Descriptor instead.
func (*CloudInstanceResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{60}
}

func (x *CloudInstanceResponse) GetListedInstances() []*instancepb.Instance {
	if x != nil {
		return x.ListedInstances
	}
	return nil
}

func (x *CloudInstanceResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *CloudInstanceResponse) GetInstance() *instancepb.Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// CloudInstanceConfigResponse contains results returned by cloud instance
// config related actions.
type CloudInstanceConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of instance configs returned by ListCloudInstanceConfigsAction.
	ListedInstanceConfigs []*instancepb.InstanceConfig `protobuf:"bytes,1,rep,name=listed_instance_configs,json=listedInstanceConfigs,proto3" json:"listed_instance_configs,omitempty"`
	// "next_page_token" can be sent in a subsequent list action
	// to fetch more of the matching data.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Instance config returned by GetCloudInstanceConfigAction.
	InstanceConfig *instancepb.InstanceConfig `protobuf:"bytes,3,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
}

func (x *CloudInstanceConfigResponse) Reset() {
	*x = CloudInstanceConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudInstanceConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudInstanceConfigResponse) ProtoMessage() {}

func (x *CloudInstanceConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudInstanceConfigResponse.ProtoReflect.Descriptor instead.
func (*CloudInstanceConfigResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{61}
}

func (x *CloudInstanceConfigResponse) GetListedInstanceConfigs() []*instancepb.InstanceConfig {
	if x != nil {
		return x.ListedInstanceConfigs
	}
	return nil
}

func (x *CloudInstanceConfigResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *CloudInstanceConfigResponse) GetInstanceConfig() *instancepb.InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

// CloudDatabaseResponse contains results returned by cloud database related
// actions.
type CloudDatabaseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of databases returned by ListCloudDatabasesAction.
	ListedDatabases []*databasepb.Database `protobuf:"bytes,1,rep,name=listed_databases,json=listedDatabases,proto3" json:"listed_databases,omitempty"`
	// List of operations returned by ListCloudDatabaseOperationsAction.
	ListedDatabaseOperations []*longrunningpb.Operation `protobuf:"bytes,2,rep,name=listed_database_operations,json=listedDatabaseOperations,proto3" json:"listed_database_operations,omitempty"`
	// "next_page_token" can be sent in a subsequent list action
	// to fetch more of the matching data.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Database returned by GetCloudDatabaseAction
	Database *databasepb.Database `protobuf:"bytes,4,opt,name=database,proto3" json:"database,omitempty"`
}

func (x *CloudDatabaseResponse) Reset() {
	*x = CloudDatabaseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudDatabaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudDatabaseResponse) ProtoMessage() {}

func (x *CloudDatabaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudDatabaseResponse.ProtoReflect.Descriptor instead.
func (*CloudDatabaseResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{62}
}

func (x *CloudDatabaseResponse) GetListedDatabases() []*databasepb.Database {
	if x != nil {
		return x.ListedDatabases
	}
	return nil
}

func (x *CloudDatabaseResponse) GetListedDatabaseOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.ListedDatabaseOperations
	}
	return nil
}

func (x *CloudDatabaseResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *CloudDatabaseResponse) GetDatabase() *databasepb.Database {
	if x != nil {
		return x.Database
	}
	return nil
}

// ReadResult contains rows read.
type ReadResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Index name, if read from an index.
	Index *string `protobuf:"bytes,2,opt,name=index,proto3,oneof" json:"index,omitempty"`
	// Request index (multiread only).
	RequestIndex *int32 `protobuf:"varint,3,opt,name=request_index,json=requestIndex,proto3,oneof" json:"request_index,omitempty"`
	// Rows read. Each row is a struct with multiple fields, one for each column
	// in read result. All rows have the same type.
	Row []*ValueList `protobuf:"bytes,4,rep,name=row,proto3" json:"row,omitempty"`
	// The type of rows read. It must be set if at least one row was read.
	RowType *spannerpb.StructType `protobuf:"bytes,5,opt,name=row_type,json=rowType,proto3,oneof" json:"row_type,omitempty"`
}

func (x *ReadResult) Reset() {
	*x = ReadResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResult) ProtoMessage() {}

func (x *ReadResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResult.ProtoReflect.Descriptor instead.
func (*ReadResult) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{63}
}

func (x *ReadResult) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ReadResult) GetIndex() string {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return ""
}

func (x *ReadResult) GetRequestIndex() int32 {
	if x != nil && x.RequestIndex != nil {
		return *x.RequestIndex
	}
	return 0
}

func (x *ReadResult) GetRow() []*ValueList {
	if x != nil {
		return x.Row
	}
	return nil
}

func (x *ReadResult) GetRowType() *spannerpb.StructType {
	if x != nil {
		return x.RowType
	}
	return nil
}

// QueryResult contains result of a Query.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rows read. Each row is a struct with multiple fields, one for each column
	// in read result. All rows have the same type.
	Row []*ValueList `protobuf:"bytes,1,rep,name=row,proto3" json:"row,omitempty"`
	// The type of rows read. It must be set if at least one row was read.
	RowType *spannerpb.StructType `protobuf:"bytes,2,opt,name=row_type,json=rowType,proto3,oneof" json:"row_type,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{64}
}

func (x *QueryResult) GetRow() []*ValueList {
	if x != nil {
		return x.Row
	}
	return nil
}

func (x *QueryResult) GetRowType() *spannerpb.StructType {
	if x != nil {
		return x.RowType
	}
	return nil
}

// Raw ChangeStream records.
// Encodes one of: DataChangeRecord, HeartbeatRecord, ChildPartitionsRecord
// returned from the ChangeStream API.
type ChangeStreamRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Record represents one type of the change stream record.
	//
	// Types that are assignable to Record:
	//
	//	*ChangeStreamRecord_DataChange
	//	*ChangeStreamRecord_ChildPartition
	//	*ChangeStreamRecord_Heartbeat
	Record isChangeStreamRecord_Record `protobuf_oneof:"record"`
}

func (x *ChangeStreamRecord) Reset() {
	*x = ChangeStreamRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeStreamRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord) ProtoMessage() {}

func (x *ChangeStreamRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{65}
}

func (m *ChangeStreamRecord) GetRecord() isChangeStreamRecord_Record {
	if m != nil {
		return m.Record
	}
	return nil
}

func (x *ChangeStreamRecord) GetDataChange() *DataChangeRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_DataChange); ok {
		return x.DataChange
	}
	return nil
}

func (x *ChangeStreamRecord) GetChildPartition() *ChildPartitionsRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_ChildPartition); ok {
		return x.ChildPartition
	}
	return nil
}

func (x *ChangeStreamRecord) GetHeartbeat() *HeartbeatRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_Heartbeat); ok {
		return x.Heartbeat
	}
	return nil
}

type isChangeStreamRecord_Record interface {
	isChangeStreamRecord_Record()
}

type ChangeStreamRecord_DataChange struct {
	// Data change record.
	DataChange *DataChangeRecord `protobuf:"bytes,1,opt,name=data_change,json=dataChange,proto3,oneof"`
}

type ChangeStreamRecord_ChildPartition struct {
	// Child partitions record.
	ChildPartition *ChildPartitionsRecord `protobuf:"bytes,2,opt,name=child_partition,json=childPartition,proto3,oneof"`
}

type ChangeStreamRecord_Heartbeat struct {
	// Heartbeat record.
	Heartbeat *HeartbeatRecord `protobuf:"bytes,3,opt,name=heartbeat,proto3,oneof"`
}

func (*ChangeStreamRecord_DataChange) isChangeStreamRecord_Record() {}

func (*ChangeStreamRecord_ChildPartition) isChangeStreamRecord_Record() {}

func (*ChangeStreamRecord_Heartbeat) isChangeStreamRecord_Record() {}

// ChangeStream data change record.
type DataChangeRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp in which the change was committed.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
	// The sequence number for the record within the transaction.
	RecordSequence string `protobuf:"bytes,2,opt,name=record_sequence,json=recordSequence,proto3" json:"record_sequence,omitempty"`
	// A globally unique string that represents the transaction in which the
	// change was committed.
	TransactionId string `protobuf:"bytes,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	// Indicates whether this is the last record for a transaction in the current
	// partition.
	IsLastRecord bool `protobuf:"varint,4,opt,name=is_last_record,json=isLastRecord,proto3" json:"is_last_record,omitempty"`
	// Name of the table affected by the change.
	Table string `protobuf:"bytes,5,opt,name=table,proto3" json:"table,omitempty"`
	// Column types defined in the schema.
	ColumnTypes []*DataChangeRecord_ColumnType `protobuf:"bytes,6,rep,name=column_types,json=columnTypes,proto3" json:"column_types,omitempty"`
	// Changes made in the transaction.
	Mods []*DataChangeRecord_Mod `protobuf:"bytes,7,rep,name=mods,proto3" json:"mods,omitempty"`
	// Describes the type of change. One of INSERT, UPDATE or DELETE.
	ModType string `protobuf:"bytes,8,opt,name=mod_type,json=modType,proto3" json:"mod_type,omitempty"`
	// One of value capture type: NEW_VALUES, OLD_VALUES, OLD_AND_NEW_VALUES.
	ValueCaptureType string `protobuf:"bytes,9,opt,name=value_capture_type,json=valueCaptureType,proto3" json:"value_capture_type,omitempty"`
	// Number of records in transactions.
	RecordCount int64 `protobuf:"varint,10,opt,name=record_count,json=recordCount,proto3" json:"record_count,omitempty"`
	// Number of partitions in transactions.
	PartitionCount int64 `protobuf:"varint,11,opt,name=partition_count,json=partitionCount,proto3" json:"partition_count,omitempty"`
	// Transaction tag info.
	TransactionTag string `protobuf:"bytes,12,opt,name=transaction_tag,json=transactionTag,proto3" json:"transaction_tag,omitempty"`
	// Whether the transaction is a system transactionn.
	IsSystemTransaction bool `protobuf:"varint,13,opt,name=is_system_transaction,json=isSystemTransaction,proto3" json:"is_system_transaction,omitempty"`
}

func (x *DataChangeRecord) Reset() {
	*x = DataChangeRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataChangeRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataChangeRecord) ProtoMessage() {}

func (x *DataChangeRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataChangeRecord.ProtoReflect.Descriptor instead.
func (*DataChangeRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{66}
}

func (x *DataChangeRecord) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

func (x *DataChangeRecord) GetRecordSequence() string {
	if x != nil {
		return x.RecordSequence
	}
	return ""
}

func (x *DataChangeRecord) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

func (x *DataChangeRecord) GetIsLastRecord() bool {
	if x != nil {
		return x.IsLastRecord
	}
	return false
}

func (x *DataChangeRecord) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *DataChangeRecord) GetColumnTypes() []*DataChangeRecord_ColumnType {
	if x != nil {
		return x.ColumnTypes
	}
	return nil
}

func (x *DataChangeRecord) GetMods() []*DataChangeRecord_Mod {
	if x != nil {
		return x.Mods
	}
	return nil
}

func (x *DataChangeRecord) GetModType() string {
	if x != nil {
		return x.ModType
	}
	return ""
}

func (x *DataChangeRecord) GetValueCaptureType() string {
	if x != nil {
		return x.ValueCaptureType
	}
	return ""
}

func (x *DataChangeRecord) GetRecordCount() int64 {
	if x != nil {
		return x.RecordCount
	}
	return 0
}

func (x *DataChangeRecord) GetPartitionCount() int64 {
	if x != nil {
		return x.PartitionCount
	}
	return 0
}

func (x *DataChangeRecord) GetTransactionTag() string {
	if x != nil {
		return x.TransactionTag
	}
	return ""
}

func (x *DataChangeRecord) GetIsSystemTransaction() bool {
	if x != nil {
		return x.IsSystemTransaction
	}
	return false
}

// ChangeStream child partition record.
type ChildPartitionsRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data change records returned from child partitions in this child partitions
	// record will have a commit timestamp greater than or equal to start_time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// A monotonically increasing sequence number that can be used to define the
	// ordering of the child partitions record when there are multiple child
	// partitions records returned with the same start_time in a particular
	// partition.
	RecordSequence string `protobuf:"bytes,2,opt,name=record_sequence,json=recordSequence,proto3" json:"record_sequence,omitempty"`
	// A set of child partitions and their associated information.
	ChildPartitions []*ChildPartitionsRecord_ChildPartition `protobuf:"bytes,3,rep,name=child_partitions,json=childPartitions,proto3" json:"child_partitions,omitempty"`
}

func (x *ChildPartitionsRecord) Reset() {
	*x = ChildPartitionsRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChildPartitionsRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChildPartitionsRecord) ProtoMessage() {}

func (x *ChildPartitionsRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChildPartitionsRecord.ProtoReflect.Descriptor instead.
func (*ChildPartitionsRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{67}
}

func (x *ChildPartitionsRecord) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ChildPartitionsRecord) GetRecordSequence() string {
	if x != nil {
		return x.RecordSequence
	}
	return ""
}

func (x *ChildPartitionsRecord) GetChildPartitions() []*ChildPartitionsRecord_ChildPartition {
	if x != nil {
		return x.ChildPartitions
	}
	return nil
}

// ChangeStream heartbeat record.
type HeartbeatRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp for this heartbeat check.
	HeartbeatTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=heartbeat_time,json=heartbeatTime,proto3" json:"heartbeat_time,omitempty"`
}

func (x *HeartbeatRecord) Reset() {
	*x = HeartbeatRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeartbeatRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeartbeatRecord) ProtoMessage() {}

func (x *HeartbeatRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeartbeatRecord.ProtoReflect.Descriptor instead.
func (*HeartbeatRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{68}
}

func (x *HeartbeatRecord) GetHeartbeatTime() *timestamppb.Timestamp {
	if x != nil {
		return x.HeartbeatTime
	}
	return nil
}

// Parameter that bind to placeholders in the SQL string
type QueryAction_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the parameter (with no leading @).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of the parameter.
	Type *spannerpb.Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Value of the parameter.
	Value *Value `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *QueryAction_Parameter) Reset() {
	*x = QueryAction_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAction_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAction_Parameter) ProtoMessage() {}

func (x *QueryAction_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAction_Parameter.ProtoReflect.Descriptor instead.
func (*QueryAction_Parameter) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{4, 0}
}

func (x *QueryAction_Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryAction_Parameter) GetType() *spannerpb.Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *QueryAction_Parameter) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// Arguments to Insert, InsertOrUpdate, and Replace operations.
type MutationAction_InsertArgs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The names of the columns to be written.
	Column []string `protobuf:"bytes,1,rep,name=column,proto3" json:"column,omitempty"`
	// Type information for the "values" entries below.
	Type []*spannerpb.Type `protobuf:"bytes,2,rep,name=type,proto3" json:"type,omitempty"`
	// The values to be written.
	Values []*ValueList `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *MutationAction_InsertArgs) Reset() {
	*x = MutationAction_InsertArgs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutationAction_InsertArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutationAction_InsertArgs) ProtoMessage() {}

func (x *MutationAction_InsertArgs) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutationAction_InsertArgs.ProtoReflect.Descriptor instead.
func (*MutationAction_InsertArgs) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{11, 0}
}

func (x *MutationAction_InsertArgs) GetColumn() []string {
	if x != nil {
		return x.Column
	}
	return nil
}

func (x *MutationAction_InsertArgs) GetType() []*spannerpb.Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *MutationAction_InsertArgs) GetValues() []*ValueList {
	if x != nil {
		return x.Values
	}
	return nil
}

// Arguments to Update.
type MutationAction_UpdateArgs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The columns to be updated. Identical to InsertArgs.column.
	Column []string `protobuf:"bytes,1,rep,name=column,proto3" json:"column,omitempty"`
	// Type information for "values". Identical to InsertArgs.type.
	Type []*spannerpb.Type `protobuf:"bytes,2,rep,name=type,proto3" json:"type,omitempty"`
	// The values to be updated. Identical to InsertArgs.values.
	Values []*ValueList `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *MutationAction_UpdateArgs) Reset() {
	*x = MutationAction_UpdateArgs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutationAction_UpdateArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutationAction_UpdateArgs) ProtoMessage() {}

func (x *MutationAction_UpdateArgs) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutationAction_UpdateArgs.ProtoReflect.Descriptor instead.
func (*MutationAction_UpdateArgs) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{11, 1}
}

func (x *MutationAction_UpdateArgs) GetColumn() []string {
	if x != nil {
		return x.Column
	}
	return nil
}

func (x *MutationAction_UpdateArgs) GetType() []*spannerpb.Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *MutationAction_UpdateArgs) GetValues() []*ValueList {
	if x != nil {
		return x.Values
	}
	return nil
}

// Mod represents the write action that will be perform to a table. Each mod
// will specify exactly one action, from insert, update, insert_or_update,
// replace and delete.
type MutationAction_Mod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The table to write.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Exactly one of the remaining elements may be present.
	// Insert new rows into "table".
	Insert *MutationAction_InsertArgs `protobuf:"bytes,2,opt,name=insert,proto3" json:"insert,omitempty"`
	// Update columns stored in existing rows of "table".
	Update *MutationAction_UpdateArgs `protobuf:"bytes,3,opt,name=update,proto3" json:"update,omitempty"`
	// Insert or update existing rows of "table".
	InsertOrUpdate *MutationAction_InsertArgs `protobuf:"bytes,4,opt,name=insert_or_update,json=insertOrUpdate,proto3" json:"insert_or_update,omitempty"`
	// Replace existing rows of "table".
	Replace *MutationAction_InsertArgs `protobuf:"bytes,5,opt,name=replace,proto3" json:"replace,omitempty"`
	// Delete rows from "table".
	DeleteKeys *KeySet `protobuf:"bytes,6,opt,name=delete_keys,json=deleteKeys,proto3" json:"delete_keys,omitempty"`
}

func (x *MutationAction_Mod) Reset() {
	*x = MutationAction_Mod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutationAction_Mod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutationAction_Mod) ProtoMessage() {}

func (x *MutationAction_Mod) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutationAction_Mod.ProtoReflect.Descriptor instead.
func (*MutationAction_Mod) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{11, 2}
}

func (x *MutationAction_Mod) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *MutationAction_Mod) GetInsert() *MutationAction_InsertArgs {
	if x != nil {
		return x.Insert
	}
	return nil
}

func (x *MutationAction_Mod) GetUpdate() *MutationAction_UpdateArgs {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *MutationAction_Mod) GetInsertOrUpdate() *MutationAction_InsertArgs {
	if x != nil {
		return x.InsertOrUpdate
	}
	return nil
}

func (x *MutationAction_Mod) GetReplace() *MutationAction_InsertArgs {
	if x != nil {
		return x.Replace
	}
	return nil
}

func (x *MutationAction_Mod) GetDeleteKeys() *KeySet {
	if x != nil {
		return x.DeleteKeys
	}
	return nil
}

type PartitionedUpdateAction_ExecutePartitionedUpdateOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RPC Priority
	RpcPriority *spannerpb.RequestOptions_Priority `protobuf:"varint,1,opt,name=rpc_priority,json=rpcPriority,proto3,enum=google.spanner.v1.RequestOptions_Priority,oneof" json:"rpc_priority,omitempty"`
	// Transaction tag
	Tag *string `protobuf:"bytes,2,opt,name=tag,proto3,oneof" json:"tag,omitempty"`
}

func (x *PartitionedUpdateAction_ExecutePartitionedUpdateOptions) Reset() {
	*x = PartitionedUpdateAction_ExecutePartitionedUpdateOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionedUpdateAction_ExecutePartitionedUpdateOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionedUpdateAction_ExecutePartitionedUpdateOptions) ProtoMessage() {}

func (x *PartitionedUpdateAction_ExecutePartitionedUpdateOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionedUpdateAction_ExecutePartitionedUpdateOptions.ProtoReflect.Descriptor instead.
func (*PartitionedUpdateAction_ExecutePartitionedUpdateOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{13, 0}
}

func (x *PartitionedUpdateAction_ExecutePartitionedUpdateOptions) GetRpcPriority() spannerpb.RequestOptions_Priority {
	if x != nil && x.RpcPriority != nil {
		return *x.RpcPriority
	}
	return spannerpb.RequestOptions_Priority(0)
}

func (x *PartitionedUpdateAction_ExecutePartitionedUpdateOptions) GetTag() string {
	if x != nil && x.Tag != nil {
		return *x.Tag
	}
	return ""
}

// Column types.
type DataChangeRecord_ColumnType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Column type in JSON.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Whether the column is a primary key column.
	IsPrimaryKey bool `protobuf:"varint,3,opt,name=is_primary_key,json=isPrimaryKey,proto3" json:"is_primary_key,omitempty"`
	// The position of the column as defined in the schema.
	OrdinalPosition int64 `protobuf:"varint,4,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *DataChangeRecord_ColumnType) Reset() {
	*x = DataChangeRecord_ColumnType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataChangeRecord_ColumnType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataChangeRecord_ColumnType) ProtoMessage() {}

func (x *DataChangeRecord_ColumnType) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataChangeRecord_ColumnType.ProtoReflect.Descriptor instead.
func (*DataChangeRecord_ColumnType) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{66, 0}
}

func (x *DataChangeRecord_ColumnType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataChangeRecord_ColumnType) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DataChangeRecord_ColumnType) GetIsPrimaryKey() bool {
	if x != nil {
		return x.IsPrimaryKey
	}
	return false
}

func (x *DataChangeRecord_ColumnType) GetOrdinalPosition() int64 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// Describes the changes that were made.
type DataChangeRecord_Mod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The primary key values in JSON.
	Keys string `protobuf:"bytes,1,opt,name=keys,proto3" json:"keys,omitempty"`
	// The new values of the changed columns in JSON. Only contain the non-key
	// columns.
	NewValues string `protobuf:"bytes,2,opt,name=new_values,json=newValues,proto3" json:"new_values,omitempty"`
	// The old values of the changed columns in JSON. Only contain the non-key
	// columns.
	OldValues string `protobuf:"bytes,3,opt,name=old_values,json=oldValues,proto3" json:"old_values,omitempty"`
}

func (x *DataChangeRecord_Mod) Reset() {
	*x = DataChangeRecord_Mod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataChangeRecord_Mod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataChangeRecord_Mod) ProtoMessage() {}

func (x *DataChangeRecord_Mod) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataChangeRecord_Mod.ProtoReflect.Descriptor instead.
func (*DataChangeRecord_Mod) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{66, 1}
}

func (x *DataChangeRecord_Mod) GetKeys() string {
	if x != nil {
		return x.Keys
	}
	return ""
}

func (x *DataChangeRecord_Mod) GetNewValues() string {
	if x != nil {
		return x.NewValues
	}
	return ""
}

func (x *DataChangeRecord_Mod) GetOldValues() string {
	if x != nil {
		return x.OldValues
	}
	return ""
}

// A single child partition.
type ChildPartitionsRecord_ChildPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition token string used to identify the child partition in queries.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Parent partition tokens of this child partition.
	ParentPartitionTokens []string `protobuf:"bytes,2,rep,name=parent_partition_tokens,json=parentPartitionTokens,proto3" json:"parent_partition_tokens,omitempty"`
}

func (x *ChildPartitionsRecord_ChildPartition) Reset() {
	*x = ChildPartitionsRecord_ChildPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChildPartitionsRecord_ChildPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChildPartitionsRecord_ChildPartition) ProtoMessage() {}

func (x *ChildPartitionsRecord_ChildPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChildPartitionsRecord_ChildPartition.ProtoReflect.Descriptor instead.
func (*ChildPartitionsRecord_ChildPartition) Descriptor() ([]byte, []int) {
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP(), []int{67, 0}
}

func (x *ChildPartitionsRecord_ChildPartition) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ChildPartitionsRecord_ChildPartition) GetParentPartitionTokens() []string {
	if x != nil {
		return x.ParentPartitionTokens
	}
	return nil
}

var File_google_spanner_executor_v1_cloud_executor_proto protoreflect.FileDescriptor

var file_google_spanner_executor_v1_cloud_executor_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x7b, 0x0a, 0x19, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x41, 0x73, 0x79, 0x6e,
	0x63, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85,
	0x01, 0x0a, 0x1a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x07, 0x6f, 0x75,
	0x74, 0x63, 0x6f, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x52, 0x07, 0x6f,
	0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x22, 0xbd, 0x0b, 0x0a, 0x0d, 0x53, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x4a, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x66, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x06, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x12, 0x3c, 0x0a, 0x04, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x04, 0x72, 0x65, 0x61, 0x64, 0x12, 0x3f, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x48, 0x0a, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x0a, 0x03, 0x64, 0x6d, 0x6c, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6d, 0x6c, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x03, 0x64, 0x6d, 0x6c, 0x12, 0x49, 0x0a, 0x09,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x6d, 0x6c, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x6d, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x12, 0x48, 0x0a, 0x05, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x05, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x12, 0x64, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x05, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x12, 0x61, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x78, 0x6e, 0x18, 0x28, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x78, 0x6e, 0x12, 0x61, 0x0a, 0x0f, 0x63,
	0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x78, 0x6e, 0x18, 0x29,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0d, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x78, 0x6e, 0x12, 0x7e,
	0x0a, 0x1b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x62, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x2a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x62, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x6f, 0x72, 0x52, 0x65, 0x61, 0x64, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x18, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x62,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x61, 0x64, 0x12, 0x81,
	0x01, 0x0a, 0x1c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x62, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x62, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x44, 0x62, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x61, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x1b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x18, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x08, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x61, 0x64, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x36,
	0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74,
	0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xf2, 0x01, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x1a, 0x85, 0x01, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x37, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x09,
	0x44, 0x6d, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x06, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x61, 0x75,
	0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x66, 0x5f, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x15, 0x61,
	0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x66, 0x53, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x66, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x22, 0x53, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x22, 0xe2, 0x04, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x19, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x69, 0x73, 0x4e, 0x75, 0x6c, 0x6c, 0x12, 0x1d, 0x0a,
	0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a,
	0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x28, 0x0a,
	0x0f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x79, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x30, 0x0a, 0x13, 0x69, 0x73, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x11, 0x69, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x72, 0x72,
	0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x48, 0x01, 0x52, 0x09, 0x61, 0x72, 0x72, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x0c, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xb3, 0x02,
	0x0a, 0x08, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x3b, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x22, 0x60, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44,
	0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4c, 0x4f,
	0x53, 0x45, 0x44, 0x5f, 0x4f, 0x50, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x50,
	0x45, 0x4e, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x4f,
	0x50, 0x45, 0x4e, 0x5f, 0x4f, 0x50, 0x45, 0x4e, 0x10, 0x04, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x06, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x12, 0x3b,
	0x0a, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x22, 0x44, 0x0a, 0x09, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xab, 0x06, 0x0a, 0x0e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x03, 0x6d, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x64, 0x52,
	0x03, 0x6d, 0x6f, 0x64, 0x1a, 0x90, 0x01, 0x0a, 0x0a, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x41,
	0x72, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x2b, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x90, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x72, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x2b,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xb0, 0x03, 0x0a, 0x03, 0x4d,
	0x6f, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x41, 0x72, 0x67, 0x73, 0x52,
	0x06, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x72, 0x67, 0x73, 0x52, 0x06,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x5f, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74,
	0x5f, 0x6f, 0x72, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x41, 0x72, 0x67, 0x73, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f,
	0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x41, 0x72, 0x67, 0x73, 0x52,
	0x07, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x53, 0x65,
	0x74, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x5e, 0x0a,
	0x14, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x03,
	0x0a, 0x17, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x65, 0x64, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x65, 0x64, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a,
	0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x1a, 0xa5,
	0x01, 0x0a, 0x1f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x65, 0x64, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x52, 0x0a, 0x0c, 0x72, 0x70, 0x63, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x70, 0x63, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x03, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a,
	0x0d, 0x5f, 0x72, 0x70, 0x63, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x74, 0x61, 0x67, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0xe5, 0x02, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a,
	0x0b, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x65, 0x64, 0x12, 0x69, 0x0a, 0x11, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52,
	0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x79, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd7, 0x03, 0x0a, 0x0b, 0x43,
	0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x2d, 0x0a, 0x11, 0x73, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x3b, 0x0a, 0x19, 0x6d, 0x69, 0x6e,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x16,
	0x6d, 0x69, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x34, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x53, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x36, 0x0a, 0x16,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x14,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x12, 0x18, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x12, 0x16,
	0x0a, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x45, 0x70, 0x6f,
	0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x12, 0x39, 0x0a, 0x19, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x52, 0x6f, 0x6f, 0x74, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x3d, 0x0a, 0x1b, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x42, 0x12, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x49,
	0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x09,
	0x6b, 0x65, 0x79, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x22, 0x51, 0x0a, 0x0e, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3d, 0x0a, 0x1b,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x73, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x73, 0x74, 0x69, 0x63, 0x22, 0x9e, 0x01, 0x0a, 0x17,
	0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x35, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x41, 0x42, 0x41, 0x4e, 0x44, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x94, 0x18, 0x0a,
	0x0b, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7b, 0x0a, 0x1b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x18, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x18, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x18, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x19, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x16, 0x67, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x15, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x6b, 0x0a, 0x15,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x6b, 0x0a, 0x15, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x13, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x6b, 0x0a, 0x15, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x68, 0x0a, 0x14, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12, 0x6c, 0x69, 0x73, 0x74, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x62, 0x0a,
	0x12, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x10, 0x67, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x6b, 0x0a, 0x15, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x75,
	0x0a, 0x19, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x64, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x44, 0x64, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x44, 0x64, 0x6c, 0x12, 0x6b, 0x0a, 0x15, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x1b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x12, 0x65, 0x0a, 0x13, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x72, 0x6f,
	0x70, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x64, 0x72, 0x6f, 0x70, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x68, 0x0a, 0x14, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x12, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x1e, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1b, 0x6c,
	0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a, 0x16, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x67, 0x65,
	0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x67, 0x65,
	0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x65,
	0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x5f, 0x0a, 0x11, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x70, 0x79, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6f, 0x70, 0x79, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x5c, 0x0a, 0x10, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0x65, 0x0a, 0x13, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x65, 0x0a, 0x13, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x11, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x62, 0x0a, 0x12, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x7e, 0x0a, 0x1c, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x6c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0d, 0x67, 0x65, 0x74, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0c, 0x67, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a,
	0x10, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a,
	0x1a, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x18, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xd6, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x75, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49,
	0x64, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x22, 0xb9, 0x02, 0x0a,
	0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x65, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x75, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0xa2, 0x01, 0x0a,
	0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x97, 0x04, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x22, 0x0a,
	0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f,
	0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x02, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75,
	0x6e, 0x69, 0x74, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa2, 0x04, 0x0a, 0x19,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x02, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69,
	0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x03, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x59,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x5b, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a,
	0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0xf5, 0x02,
	0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x64, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x64, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x5f, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x30, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x01, 0x52, 0x10,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73,
	0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x73, 0x22, 0x8f, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x64, 0x6c,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x64, 0x6c, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x64, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x30, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x10, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x88, 0x01,
	0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x44, 0x72, 0x6f, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7a, 0x0a, 0x17, 0x44, 0x72, 0x6f, 0x70, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0x86, 0x01, 0x0a,
	0x1e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x55, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5f, 0x75, 0x72, 0x69, 0x22, 0x96, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc4,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a,
	0x07, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x58, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x22,
	0xb7, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd9, 0x01, 0x0a, 0x1a, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x49, 0x64, 0x22, 0x79, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64,
	0x22, 0xae, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00,
	0x52, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0xdb, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x70, 0x79, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x40, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x73, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x49, 0x64, 0x22, 0xb8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x12, 0x40, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x76, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x22, 0xac, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x32,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x35, 0x0a, 0x15, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x1b, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0e, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x74, 0x78, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52,
	0x0c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x54, 0x78, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x03, 0x74, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x03, 0x74, 0x69,
	0x64, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x6f, 0x6c,
	0x65, 0x42, 0x07, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x22, 0x37, 0x0a, 0x1b, 0x43, 0x6c,
	0x6f, 0x73, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x65,
	0x61, 0x6e, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x6c, 0x65, 0x61,
	0x6e, 0x75, 0x70, 0x22, 0xd1, 0x02, 0x0a, 0x21, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x44, 0x62, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x6f, 0x72, 0x52,
	0x65, 0x61, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x04, 0x72, 0x65, 0x61,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x72, 0x65, 0x61, 0x64, 0x12, 0x3f, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x18, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42,
	0x1e, 0x0a, 0x1c, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xc7, 0x01, 0x0a, 0x22, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x44, 0x62, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x46, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x42, 0x0a,
	0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x18, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x50, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01,
	0x01, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01,
	0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x62, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x48, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x04, 0x0a, 0x18, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x21, 0x0a, 0x0c, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x16, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f,
	0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x02, 0x52, 0x15, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x4d,
	0x69, 0x6c, 0x6c, 0x69, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2e,
	0x0a, 0x10, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x33,
	0x0a, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x11, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x6f, 0x6c, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65,
	0x61, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x22, 0xb1, 0x06, 0x0a,
	0x14, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75,
	0x74, 0x63, 0x6f, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x03, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x04, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x25, 0x0a, 0x0c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x78, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x05, 0x52, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x54, 0x78, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x0c, 0x64, 0x62, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x62, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x06, 0x52, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x6d, 0x6c, 0x5f,
	0x72, 0x6f, 0x77, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x0f, 0x64, 0x6d, 0x6c, 0x52, 0x6f, 0x77, 0x73, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x12, 0x62, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x42, 0x0f,
	0x0a, 0x0d, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x78, 0x6e, 0x5f, 0x69, 0x64, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0xf8, 0x03, 0x0a, 0x0b, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x58, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x12, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a, 0x18, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x52, 0x16, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa9, 0x02, 0x0a, 0x13,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x0d, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x73, 0x12, 0x57, 0x0a, 0x18, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0xc4, 0x01, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a,
	0x11, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x3b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xde,
	0x01, 0x0a, 0x15, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x6c, 0x69, 0x73, 0x74,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0f,
	0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22,
	0x8a, 0x02, 0x0a, 0x1b, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x68, 0x0a, 0x17, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x15, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x59, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xbb, 0x02, 0x0a,
	0x15, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x0f, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x5b, 0x0a,
	0x1a, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x18, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x22, 0x88, 0x02, 0x0a, 0x0a, 0x52,
	0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x19, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x03, 0x72, 0x6f, 0x77, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x03, 0x72, 0x6f, 0x77, 0x12, 0x3d, 0x0a,
	0x08, 0x72, 0x6f, 0x77, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x48, 0x02,
	0x52, 0x07, 0x72, 0x6f, 0x77, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x72, 0x6f, 0x77,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x92, 0x01, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x37, 0x0a, 0x03, 0x72, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x03, 0x72, 0x6f, 0x77, 0x12, 0x3d,
	0x0a, 0x08, 0x72, 0x6f, 0x77, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x48,
	0x00, 0x52, 0x07, 0x72, 0x6f, 0x77, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a,
	0x09, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x9a, 0x02, 0x0a, 0x12, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x12, 0x4f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x48, 0x00,
	0x52, 0x0e, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4b, 0x0a, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x48, 0x00, 0x52, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x42, 0x08, 0x0a,
	0x06, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0xd0, 0x06, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x3b, 0x0a, 0x0b,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x69, 0x73, 0x4c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x5a, 0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x44, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x4d, 0x6f,
	0x64, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x61, 0x67, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x73, 0x5f, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x73, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x85, 0x01, 0x0a, 0x0a, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x50, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x57, 0x0a, 0x03, 0x4d, 0x6f, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6e, 0x65, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6f,
	0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6f, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xc8, 0x02, 0x0a, 0x15, 0x43,
	0x68, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x27, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x6b, 0x0a, 0x10, 0x63, 0x68, 0x69, 0x6c,
	0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x5e, 0x0a, 0x0e, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x36, 0x0a,
	0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x22, 0x54, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65,
	0x61, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x41, 0x0a, 0x0e, 0x68, 0x65, 0x61, 0x72,
	0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x68, 0x65,
	0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xcc, 0x01, 0x0a, 0x14,
	0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x12, 0x89, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x41, 0x73, 0x79, 0x6e, 0x63, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01,
	0x1a, 0x28, 0xca, 0x41, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2d, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x78, 0x0a, 0x1e, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x40, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x70, 0x62, 0x3b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_executor_v1_cloud_executor_proto_rawDescOnce sync.Once
	file_google_spanner_executor_v1_cloud_executor_proto_rawDescData = file_google_spanner_executor_v1_cloud_executor_proto_rawDesc
)

func file_google_spanner_executor_v1_cloud_executor_proto_rawDescGZIP() []byte {
	file_google_spanner_executor_v1_cloud_executor_proto_rawDescOnce.Do(func() {
		file_google_spanner_executor_v1_cloud_executor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_executor_v1_cloud_executor_proto_rawDescData)
	})
	return file_google_spanner_executor_v1_cloud_executor_proto_rawDescData
}

var file_google_spanner_executor_v1_cloud_executor_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_spanner_executor_v1_cloud_executor_proto_msgTypes = make([]protoimpl.MessageInfo, 80)
var file_google_spanner_executor_v1_cloud_executor_proto_goTypes = []interface{}{
	(KeyRange_Type)(0),                                              // 0: google.spanner.executor.v1.KeyRange.Type
	(FinishTransactionAction_Mode)(0),                               // 1: google.spanner.executor.v1.FinishTransactionAction.Mode
	(*SpannerAsyncActionRequest)(nil),                               // 2: google.spanner.executor.v1.SpannerAsyncActionRequest
	(*SpannerAsyncActionResponse)(nil),                              // 3: google.spanner.executor.v1.SpannerAsyncActionResponse
	(*SpannerAction)(nil),                                           // 4: google.spanner.executor.v1.SpannerAction
	(*ReadAction)(nil),                                              // 5: google.spanner.executor.v1.ReadAction
	(*QueryAction)(nil),                                             // 6: google.spanner.executor.v1.QueryAction
	(*DmlAction)(nil),                                               // 7: google.spanner.executor.v1.DmlAction
	(*BatchDmlAction)(nil),                                          // 8: google.spanner.executor.v1.BatchDmlAction
	(*Value)(nil),                                                   // 9: google.spanner.executor.v1.Value
	(*KeyRange)(nil),                                                // 10: google.spanner.executor.v1.KeyRange
	(*KeySet)(nil),                                                  // 11: google.spanner.executor.v1.KeySet
	(*ValueList)(nil),                                               // 12: google.spanner.executor.v1.ValueList
	(*MutationAction)(nil),                                          // 13: google.spanner.executor.v1.MutationAction
	(*WriteMutationsAction)(nil),                                    // 14: google.spanner.executor.v1.WriteMutationsAction
	(*PartitionedUpdateAction)(nil),                                 // 15: google.spanner.executor.v1.PartitionedUpdateAction
	(*StartTransactionAction)(nil),                                  // 16: google.spanner.executor.v1.StartTransactionAction
	(*Concurrency)(nil),                                             // 17: google.spanner.executor.v1.Concurrency
	(*TableMetadata)(nil),                                           // 18: google.spanner.executor.v1.TableMetadata
	(*ColumnMetadata)(nil),                                          // 19: google.spanner.executor.v1.ColumnMetadata
	(*TransactionExecutionOptions)(nil),                             // 20: google.spanner.executor.v1.TransactionExecutionOptions
	(*FinishTransactionAction)(nil),                                 // 21: google.spanner.executor.v1.FinishTransactionAction
	(*AdminAction)(nil),                                             // 22: google.spanner.executor.v1.AdminAction
	(*CreateUserInstanceConfigAction)(nil),                          // 23: google.spanner.executor.v1.CreateUserInstanceConfigAction
	(*UpdateUserInstanceConfigAction)(nil),                          // 24: google.spanner.executor.v1.UpdateUserInstanceConfigAction
	(*GetCloudInstanceConfigAction)(nil),                            // 25: google.spanner.executor.v1.GetCloudInstanceConfigAction
	(*DeleteUserInstanceConfigAction)(nil),                          // 26: google.spanner.executor.v1.DeleteUserInstanceConfigAction
	(*ListCloudInstanceConfigsAction)(nil),                          // 27: google.spanner.executor.v1.ListCloudInstanceConfigsAction
	(*CreateCloudInstanceAction)(nil),                               // 28: google.spanner.executor.v1.CreateCloudInstanceAction
	(*UpdateCloudInstanceAction)(nil),                               // 29: google.spanner.executor.v1.UpdateCloudInstanceAction
	(*DeleteCloudInstanceAction)(nil),                               // 30: google.spanner.executor.v1.DeleteCloudInstanceAction
	(*CreateCloudDatabaseAction)(nil),                               // 31: google.spanner.executor.v1.CreateCloudDatabaseAction
	(*UpdateCloudDatabaseDdlAction)(nil),                            // 32: google.spanner.executor.v1.UpdateCloudDatabaseDdlAction
	(*UpdateCloudDatabaseAction)(nil),                               // 33: google.spanner.executor.v1.UpdateCloudDatabaseAction
	(*DropCloudDatabaseAction)(nil),                                 // 34: google.spanner.executor.v1.DropCloudDatabaseAction
	(*ReconfigureCloudDatabaseAction)(nil),                          // 35: google.spanner.executor.v1.ReconfigureCloudDatabaseAction
	(*ListCloudDatabasesAction)(nil),                                // 36: google.spanner.executor.v1.ListCloudDatabasesAction
	(*ListCloudInstancesAction)(nil),                                // 37: google.spanner.executor.v1.ListCloudInstancesAction
	(*GetCloudInstanceAction)(nil),                                  // 38: google.spanner.executor.v1.GetCloudInstanceAction
	(*ListCloudDatabaseOperationsAction)(nil),                       // 39: google.spanner.executor.v1.ListCloudDatabaseOperationsAction
	(*RestoreCloudDatabaseAction)(nil),                              // 40: google.spanner.executor.v1.RestoreCloudDatabaseAction
	(*GetCloudDatabaseAction)(nil),                                  // 41: google.spanner.executor.v1.GetCloudDatabaseAction
	(*CreateCloudBackupAction)(nil),                                 // 42: google.spanner.executor.v1.CreateCloudBackupAction
	(*CopyCloudBackupAction)(nil),                                   // 43: google.spanner.executor.v1.CopyCloudBackupAction
	(*GetCloudBackupAction)(nil),                                    // 44: google.spanner.executor.v1.GetCloudBackupAction
	(*UpdateCloudBackupAction)(nil),                                 // 45: google.spanner.executor.v1.UpdateCloudBackupAction
	(*DeleteCloudBackupAction)(nil),                                 // 46: google.spanner.executor.v1.DeleteCloudBackupAction
	(*ListCloudBackupsAction)(nil),                                  // 47: google.spanner.executor.v1.ListCloudBackupsAction
	(*ListCloudBackupOperationsAction)(nil),                         // 48: google.spanner.executor.v1.ListCloudBackupOperationsAction
	(*GetOperationAction)(nil),                                      // 49: google.spanner.executor.v1.GetOperationAction
	(*CancelOperationAction)(nil),                                   // 50: google.spanner.executor.v1.CancelOperationAction
	(*StartBatchTransactionAction)(nil),                             // 51: google.spanner.executor.v1.StartBatchTransactionAction
	(*CloseBatchTransactionAction)(nil),                             // 52: google.spanner.executor.v1.CloseBatchTransactionAction
	(*GenerateDbPartitionsForReadAction)(nil),                       // 53: google.spanner.executor.v1.GenerateDbPartitionsForReadAction
	(*GenerateDbPartitionsForQueryAction)(nil),                      // 54: google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
	(*BatchPartition)(nil),                                          // 55: google.spanner.executor.v1.BatchPartition
	(*ExecutePartitionAction)(nil),                                  // 56: google.spanner.executor.v1.ExecutePartitionAction
	(*ExecuteChangeStreamQuery)(nil),                                // 57: google.spanner.executor.v1.ExecuteChangeStreamQuery
	(*SpannerActionOutcome)(nil),                                    // 58: google.spanner.executor.v1.SpannerActionOutcome
	(*AdminResult)(nil),                                             // 59: google.spanner.executor.v1.AdminResult
	(*CloudBackupResponse)(nil),                                     // 60: google.spanner.executor.v1.CloudBackupResponse
	(*OperationResponse)(nil),                                       // 61: google.spanner.executor.v1.OperationResponse
	(*CloudInstanceResponse)(nil),                                   // 62: google.spanner.executor.v1.CloudInstanceResponse
	(*CloudInstanceConfigResponse)(nil),                             // 63: google.spanner.executor.v1.CloudInstanceConfigResponse
	(*CloudDatabaseResponse)(nil),                                   // 64: google.spanner.executor.v1.CloudDatabaseResponse
	(*ReadResult)(nil),                                              // 65: google.spanner.executor.v1.ReadResult
	(*QueryResult)(nil),                                             // 66: google.spanner.executor.v1.QueryResult
	(*ChangeStreamRecord)(nil),                                      // 67: google.spanner.executor.v1.ChangeStreamRecord
	(*DataChangeRecord)(nil),                                        // 68: google.spanner.executor.v1.DataChangeRecord
	(*ChildPartitionsRecord)(nil),                                   // 69: google.spanner.executor.v1.ChildPartitionsRecord
	(*HeartbeatRecord)(nil),                                         // 70: google.spanner.executor.v1.HeartbeatRecord
	(*QueryAction_Parameter)(nil),                                   // 71: google.spanner.executor.v1.QueryAction.Parameter
	(*MutationAction_InsertArgs)(nil),                               // 72: google.spanner.executor.v1.MutationAction.InsertArgs
	(*MutationAction_UpdateArgs)(nil),                               // 73: google.spanner.executor.v1.MutationAction.UpdateArgs
	(*MutationAction_Mod)(nil),                                      // 74: google.spanner.executor.v1.MutationAction.Mod
	(*PartitionedUpdateAction_ExecutePartitionedUpdateOptions)(nil), // 75: google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
	nil,                                 // 76: google.spanner.executor.v1.UpdateUserInstanceConfigAction.LabelsEntry
	nil,                                 // 77: google.spanner.executor.v1.CreateCloudInstanceAction.LabelsEntry
	nil,                                 // 78: google.spanner.executor.v1.UpdateCloudInstanceAction.LabelsEntry
	(*DataChangeRecord_ColumnType)(nil), // 79: google.spanner.executor.v1.DataChangeRecord.ColumnType
	(*DataChangeRecord_Mod)(nil),        // 80: google.spanner.executor.v1.DataChangeRecord.Mod
	(*ChildPartitionsRecord_ChildPartition)(nil), // 81: google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
	(*timestamppb.Timestamp)(nil),                // 82: google.protobuf.Timestamp
	(*spannerpb.Type)(nil),                       // 83: google.spanner.v1.Type
	(*instancepb.ReplicaInfo)(nil),               // 84: google.spanner.admin.instance.v1.ReplicaInfo
	(*instancepb.AutoscalingConfig)(nil),         // 85: google.spanner.admin.instance.v1.AutoscalingConfig
	(*databasepb.EncryptionConfig)(nil),          // 86: google.spanner.admin.database.v1.EncryptionConfig
	(*status.Status)(nil),                        // 87: google.rpc.Status
	(*databasepb.Backup)(nil),                    // 88: google.spanner.admin.database.v1.Backup
	(*longrunningpb.Operation)(nil),              // 89: google.longrunning.Operation
	(*instancepb.Instance)(nil),                  // 90: google.spanner.admin.instance.v1.Instance
	(*instancepb.InstanceConfig)(nil),            // 91: google.spanner.admin.instance.v1.InstanceConfig
	(*databasepb.Database)(nil),                  // 92: google.spanner.admin.database.v1.Database
	(*spannerpb.StructType)(nil),                 // 93: google.spanner.v1.StructType
	(spannerpb.RequestOptions_Priority)(0),       // 94: google.spanner.v1.RequestOptions.Priority
}
var file_google_spanner_executor_v1_cloud_executor_proto_depIdxs = []int32{
	4,   // 0: google.spanner.executor.v1.SpannerAsyncActionRequest.action:type_name -> google.spanner.executor.v1.SpannerAction
	58,  // 1: google.spanner.executor.v1.SpannerAsyncActionResponse.outcome:type_name -> google.spanner.executor.v1.SpannerActionOutcome
	16,  // 2: google.spanner.executor.v1.SpannerAction.start:type_name -> google.spanner.executor.v1.StartTransactionAction
	21,  // 3: google.spanner.executor.v1.SpannerAction.finish:type_name -> google.spanner.executor.v1.FinishTransactionAction
	5,   // 4: google.spanner.executor.v1.SpannerAction.read:type_name -> google.spanner.executor.v1.ReadAction
	6,   // 5: google.spanner.executor.v1.SpannerAction.query:type_name -> google.spanner.executor.v1.QueryAction
	13,  // 6: google.spanner.executor.v1.SpannerAction.mutation:type_name -> google.spanner.executor.v1.MutationAction
	7,   // 7: google.spanner.executor.v1.SpannerAction.dml:type_name -> google.spanner.executor.v1.DmlAction
	8,   // 8: google.spanner.executor.v1.SpannerAction.batch_dml:type_name -> google.spanner.executor.v1.BatchDmlAction
	14,  // 9: google.spanner.executor.v1.SpannerAction.write:type_name -> google.spanner.executor.v1.WriteMutationsAction
	15,  // 10: google.spanner.executor.v1.SpannerAction.partitioned_update:type_name -> google.spanner.executor.v1.PartitionedUpdateAction
	22,  // 11: google.spanner.executor.v1.SpannerAction.admin:type_name -> google.spanner.executor.v1.AdminAction
	51,  // 12: google.spanner.executor.v1.SpannerAction.start_batch_txn:type_name -> google.spanner.executor.v1.StartBatchTransactionAction
	52,  // 13: google.spanner.executor.v1.SpannerAction.close_batch_txn:type_name -> google.spanner.executor.v1.CloseBatchTransactionAction
	53,  // 14: google.spanner.executor.v1.SpannerAction.generate_db_partitions_read:type_name -> google.spanner.executor.v1.GenerateDbPartitionsForReadAction
	54,  // 15: google.spanner.executor.v1.SpannerAction.generate_db_partitions_query:type_name -> google.spanner.executor.v1.GenerateDbPartitionsForQueryAction
	56,  // 16: google.spanner.executor.v1.SpannerAction.execute_partition:type_name -> google.spanner.executor.v1.ExecutePartitionAction
	57,  // 17: google.spanner.executor.v1.SpannerAction.execute_change_stream_query:type_name -> google.spanner.executor.v1.ExecuteChangeStreamQuery
	11,  // 18: google.spanner.executor.v1.ReadAction.keys:type_name -> google.spanner.executor.v1.KeySet
	71,  // 19: google.spanner.executor.v1.QueryAction.params:type_name -> google.spanner.executor.v1.QueryAction.Parameter
	6,   // 20: google.spanner.executor.v1.DmlAction.update:type_name -> google.spanner.executor.v1.QueryAction
	6,   // 21: google.spanner.executor.v1.BatchDmlAction.updates:type_name -> google.spanner.executor.v1.QueryAction
	12,  // 22: google.spanner.executor.v1.Value.struct_value:type_name -> google.spanner.executor.v1.ValueList
	82,  // 23: google.spanner.executor.v1.Value.timestamp_value:type_name -> google.protobuf.Timestamp
	12,  // 24: google.spanner.executor.v1.Value.array_value:type_name -> google.spanner.executor.v1.ValueList
	83,  // 25: google.spanner.executor.v1.Value.array_type:type_name -> google.spanner.v1.Type
	12,  // 26: google.spanner.executor.v1.KeyRange.start:type_name -> google.spanner.executor.v1.ValueList
	12,  // 27: google.spanner.executor.v1.KeyRange.limit:type_name -> google.spanner.executor.v1.ValueList
	0,   // 28: google.spanner.executor.v1.KeyRange.type:type_name -> google.spanner.executor.v1.KeyRange.Type
	12,  // 29: google.spanner.executor.v1.KeySet.point:type_name -> google.spanner.executor.v1.ValueList
	10,  // 30: google.spanner.executor.v1.KeySet.range:type_name -> google.spanner.executor.v1.KeyRange
	9,   // 31: google.spanner.executor.v1.ValueList.value:type_name -> google.spanner.executor.v1.Value
	74,  // 32: google.spanner.executor.v1.MutationAction.mod:type_name -> google.spanner.executor.v1.MutationAction.Mod
	13,  // 33: google.spanner.executor.v1.WriteMutationsAction.mutation:type_name -> google.spanner.executor.v1.MutationAction
	75,  // 34: google.spanner.executor.v1.PartitionedUpdateAction.options:type_name -> google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
	6,   // 35: google.spanner.executor.v1.PartitionedUpdateAction.update:type_name -> google.spanner.executor.v1.QueryAction
	17,  // 36: google.spanner.executor.v1.StartTransactionAction.concurrency:type_name -> google.spanner.executor.v1.Concurrency
	18,  // 37: google.spanner.executor.v1.StartTransactionAction.table:type_name -> google.spanner.executor.v1.TableMetadata
	20,  // 38: google.spanner.executor.v1.StartTransactionAction.execution_options:type_name -> google.spanner.executor.v1.TransactionExecutionOptions
	19,  // 39: google.spanner.executor.v1.TableMetadata.column:type_name -> google.spanner.executor.v1.ColumnMetadata
	19,  // 40: google.spanner.executor.v1.TableMetadata.key_column:type_name -> google.spanner.executor.v1.ColumnMetadata
	83,  // 41: google.spanner.executor.v1.ColumnMetadata.type:type_name -> google.spanner.v1.Type
	1,   // 42: google.spanner.executor.v1.FinishTransactionAction.mode:type_name -> google.spanner.executor.v1.FinishTransactionAction.Mode
	23,  // 43: google.spanner.executor.v1.AdminAction.create_user_instance_config:type_name -> google.spanner.executor.v1.CreateUserInstanceConfigAction
	24,  // 44: google.spanner.executor.v1.AdminAction.update_user_instance_config:type_name -> google.spanner.executor.v1.UpdateUserInstanceConfigAction
	26,  // 45: google.spanner.executor.v1.AdminAction.delete_user_instance_config:type_name -> google.spanner.executor.v1.DeleteUserInstanceConfigAction
	25,  // 46: google.spanner.executor.v1.AdminAction.get_cloud_instance_config:type_name -> google.spanner.executor.v1.GetCloudInstanceConfigAction
	27,  // 47: google.spanner.executor.v1.AdminAction.list_instance_configs:type_name -> google.spanner.executor.v1.ListCloudInstanceConfigsAction
	28,  // 48: google.spanner.executor.v1.AdminAction.create_cloud_instance:type_name -> google.spanner.executor.v1.CreateCloudInstanceAction
	29,  // 49: google.spanner.executor.v1.AdminAction.update_cloud_instance:type_name -> google.spanner.executor.v1.UpdateCloudInstanceAction
	30,  // 50: google.spanner.executor.v1.AdminAction.delete_cloud_instance:type_name -> google.spanner.executor.v1.DeleteCloudInstanceAction
	37,  // 51: google.spanner.executor.v1.AdminAction.list_cloud_instances:type_name -> google.spanner.executor.v1.ListCloudInstancesAction
	38,  // 52: google.spanner.executor.v1.AdminAction.get_cloud_instance:type_name -> google.spanner.executor.v1.GetCloudInstanceAction
	31,  // 53: google.spanner.executor.v1.AdminAction.create_cloud_database:type_name -> google.spanner.executor.v1.CreateCloudDatabaseAction
	32,  // 54: google.spanner.executor.v1.AdminAction.update_cloud_database_ddl:type_name -> google.spanner.executor.v1.UpdateCloudDatabaseDdlAction
	33,  // 55: google.spanner.executor.v1.AdminAction.update_cloud_database:type_name -> google.spanner.executor.v1.UpdateCloudDatabaseAction
	34,  // 56: google.spanner.executor.v1.AdminAction.drop_cloud_database:type_name -> google.spanner.executor.v1.DropCloudDatabaseAction
	36,  // 57: google.spanner.executor.v1.AdminAction.list_cloud_databases:type_name -> google.spanner.executor.v1.ListCloudDatabasesAction
	39,  // 58: google.spanner.executor.v1.AdminAction.list_cloud_database_operations:type_name -> google.spanner.executor.v1.ListCloudDatabaseOperationsAction
	40,  // 59: google.spanner.executor.v1.AdminAction.restore_cloud_database:type_name -> google.spanner.executor.v1.RestoreCloudDatabaseAction
	41,  // 60: google.spanner.executor.v1.AdminAction.get_cloud_database:type_name -> google.spanner.executor.v1.GetCloudDatabaseAction
	42,  // 61: google.spanner.executor.v1.AdminAction.create_cloud_backup:type_name -> google.spanner.executor.v1.CreateCloudBackupAction
	43,  // 62: google.spanner.executor.v1.AdminAction.copy_cloud_backup:type_name -> google.spanner.executor.v1.CopyCloudBackupAction
	44,  // 63: google.spanner.executor.v1.AdminAction.get_cloud_backup:type_name -> google.spanner.executor.v1.GetCloudBackupAction
	45,  // 64: google.spanner.executor.v1.AdminAction.update_cloud_backup:type_name -> google.spanner.executor.v1.UpdateCloudBackupAction
	46,  // 65: google.spanner.executor.v1.AdminAction.delete_cloud_backup:type_name -> google.spanner.executor.v1.DeleteCloudBackupAction
	47,  // 66: google.spanner.executor.v1.AdminAction.list_cloud_backups:type_name -> google.spanner.executor.v1.ListCloudBackupsAction
	48,  // 67: google.spanner.executor.v1.AdminAction.list_cloud_backup_operations:type_name -> google.spanner.executor.v1.ListCloudBackupOperationsAction
	49,  // 68: google.spanner.executor.v1.AdminAction.get_operation:type_name -> google.spanner.executor.v1.GetOperationAction
	50,  // 69: google.spanner.executor.v1.AdminAction.cancel_operation:type_name -> google.spanner.executor.v1.CancelOperationAction
	35,  // 70: google.spanner.executor.v1.AdminAction.reconfigure_cloud_database:type_name -> google.spanner.executor.v1.ReconfigureCloudDatabaseAction
	84,  // 71: google.spanner.executor.v1.CreateUserInstanceConfigAction.replicas:type_name -> google.spanner.admin.instance.v1.ReplicaInfo
	76,  // 72: google.spanner.executor.v1.UpdateUserInstanceConfigAction.labels:type_name -> google.spanner.executor.v1.UpdateUserInstanceConfigAction.LabelsEntry
	85,  // 73: google.spanner.executor.v1.CreateCloudInstanceAction.autoscaling_config:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig
	77,  // 74: google.spanner.executor.v1.CreateCloudInstanceAction.labels:type_name -> google.spanner.executor.v1.CreateCloudInstanceAction.LabelsEntry
	85,  // 75: google.spanner.executor.v1.UpdateCloudInstanceAction.autoscaling_config:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig
	78,  // 76: google.spanner.executor.v1.UpdateCloudInstanceAction.labels:type_name -> google.spanner.executor.v1.UpdateCloudInstanceAction.LabelsEntry
	86,  // 77: google.spanner.executor.v1.CreateCloudDatabaseAction.encryption_config:type_name -> google.spanner.admin.database.v1.EncryptionConfig
	82,  // 78: google.spanner.executor.v1.CreateCloudBackupAction.expire_time:type_name -> google.protobuf.Timestamp
	82,  // 79: google.spanner.executor.v1.CreateCloudBackupAction.version_time:type_name -> google.protobuf.Timestamp
	82,  // 80: google.spanner.executor.v1.CopyCloudBackupAction.expire_time:type_name -> google.protobuf.Timestamp
	82,  // 81: google.spanner.executor.v1.UpdateCloudBackupAction.expire_time:type_name -> google.protobuf.Timestamp
	82,  // 82: google.spanner.executor.v1.StartBatchTransactionAction.batch_txn_time:type_name -> google.protobuf.Timestamp
	5,   // 83: google.spanner.executor.v1.GenerateDbPartitionsForReadAction.read:type_name -> google.spanner.executor.v1.ReadAction
	18,  // 84: google.spanner.executor.v1.GenerateDbPartitionsForReadAction.table:type_name -> google.spanner.executor.v1.TableMetadata
	6,   // 85: google.spanner.executor.v1.GenerateDbPartitionsForQueryAction.query:type_name -> google.spanner.executor.v1.QueryAction
	55,  // 86: google.spanner.executor.v1.ExecutePartitionAction.partition:type_name -> google.spanner.executor.v1.BatchPartition
	82,  // 87: google.spanner.executor.v1.ExecuteChangeStreamQuery.start_time:type_name -> google.protobuf.Timestamp
	82,  // 88: google.spanner.executor.v1.ExecuteChangeStreamQuery.end_time:type_name -> google.protobuf.Timestamp
	87,  // 89: google.spanner.executor.v1.SpannerActionOutcome.status:type_name -> google.rpc.Status
	82,  // 90: google.spanner.executor.v1.SpannerActionOutcome.commit_time:type_name -> google.protobuf.Timestamp
	65,  // 91: google.spanner.executor.v1.SpannerActionOutcome.read_result:type_name -> google.spanner.executor.v1.ReadResult
	66,  // 92: google.spanner.executor.v1.SpannerActionOutcome.query_result:type_name -> google.spanner.executor.v1.QueryResult
	55,  // 93: google.spanner.executor.v1.SpannerActionOutcome.db_partition:type_name -> google.spanner.executor.v1.BatchPartition
	59,  // 94: google.spanner.executor.v1.SpannerActionOutcome.admin_result:type_name -> google.spanner.executor.v1.AdminResult
	67,  // 95: google.spanner.executor.v1.SpannerActionOutcome.change_stream_records:type_name -> google.spanner.executor.v1.ChangeStreamRecord
	60,  // 96: google.spanner.executor.v1.AdminResult.backup_response:type_name -> google.spanner.executor.v1.CloudBackupResponse
	61,  // 97: google.spanner.executor.v1.AdminResult.operation_response:type_name -> google.spanner.executor.v1.OperationResponse
	64,  // 98: google.spanner.executor.v1.AdminResult.database_response:type_name -> google.spanner.executor.v1.CloudDatabaseResponse
	62,  // 99: google.spanner.executor.v1.AdminResult.instance_response:type_name -> google.spanner.executor.v1.CloudInstanceResponse
	63,  // 100: google.spanner.executor.v1.AdminResult.instance_config_response:type_name -> google.spanner.executor.v1.CloudInstanceConfigResponse
	88,  // 101: google.spanner.executor.v1.CloudBackupResponse.listed_backups:type_name -> google.spanner.admin.database.v1.Backup
	89,  // 102: google.spanner.executor.v1.CloudBackupResponse.listed_backup_operations:type_name -> google.longrunning.Operation
	88,  // 103: google.spanner.executor.v1.CloudBackupResponse.backup:type_name -> google.spanner.admin.database.v1.Backup
	89,  // 104: google.spanner.executor.v1.OperationResponse.listed_operations:type_name -> google.longrunning.Operation
	89,  // 105: google.spanner.executor.v1.OperationResponse.operation:type_name -> google.longrunning.Operation
	90,  // 106: google.spanner.executor.v1.CloudInstanceResponse.listed_instances:type_name -> google.spanner.admin.instance.v1.Instance
	90,  // 107: google.spanner.executor.v1.CloudInstanceResponse.instance:type_name -> google.spanner.admin.instance.v1.Instance
	91,  // 108: google.spanner.executor.v1.CloudInstanceConfigResponse.listed_instance_configs:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	91,  // 109: google.spanner.executor.v1.CloudInstanceConfigResponse.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	92,  // 110: google.spanner.executor.v1.CloudDatabaseResponse.listed_databases:type_name -> google.spanner.admin.database.v1.Database
	89,  // 111: google.spanner.executor.v1.CloudDatabaseResponse.listed_database_operations:type_name -> google.longrunning.Operation
	92,  // 112: google.spanner.executor.v1.CloudDatabaseResponse.database:type_name -> google.spanner.admin.database.v1.Database
	12,  // 113: google.spanner.executor.v1.ReadResult.row:type_name -> google.spanner.executor.v1.ValueList
	93,  // 114: google.spanner.executor.v1.ReadResult.row_type:type_name -> google.spanner.v1.StructType
	12,  // 115: google.spanner.executor.v1.QueryResult.row:type_name -> google.spanner.executor.v1.ValueList
	93,  // 116: google.spanner.executor.v1.QueryResult.row_type:type_name -> google.spanner.v1.StructType
	68,  // 117: google.spanner.executor.v1.ChangeStreamRecord.data_change:type_name -> google.spanner.executor.v1.DataChangeRecord
	69,  // 118: google.spanner.executor.v1.ChangeStreamRecord.child_partition:type_name -> google.spanner.executor.v1.ChildPartitionsRecord
	70,  // 119: google.spanner.executor.v1.ChangeStreamRecord.heartbeat:type_name -> google.spanner.executor.v1.HeartbeatRecord
	82,  // 120: google.spanner.executor.v1.DataChangeRecord.commit_time:type_name -> google.protobuf.Timestamp
	79,  // 121: google.spanner.executor.v1.DataChangeRecord.column_types:type_name -> google.spanner.executor.v1.DataChangeRecord.ColumnType
	80,  // 122: google.spanner.executor.v1.DataChangeRecord.mods:type_name -> google.spanner.executor.v1.DataChangeRecord.Mod
	82,  // 123: google.spanner.executor.v1.ChildPartitionsRecord.start_time:type_name -> google.protobuf.Timestamp
	81,  // 124: google.spanner.executor.v1.ChildPartitionsRecord.child_partitions:type_name -> google.spanner.executor.v1.ChildPartitionsRecord.ChildPartition
	82,  // 125: google.spanner.executor.v1.HeartbeatRecord.heartbeat_time:type_name -> google.protobuf.Timestamp
	83,  // 126: google.spanner.executor.v1.QueryAction.Parameter.type:type_name -> google.spanner.v1.Type
	9,   // 127: google.spanner.executor.v1.QueryAction.Parameter.value:type_name -> google.spanner.executor.v1.Value
	83,  // 128: google.spanner.executor.v1.MutationAction.InsertArgs.type:type_name -> google.spanner.v1.Type
	12,  // 129: google.spanner.executor.v1.MutationAction.InsertArgs.values:type_name -> google.spanner.executor.v1.ValueList
	83,  // 130: google.spanner.executor.v1.MutationAction.UpdateArgs.type:type_name -> google.spanner.v1.Type
	12,  // 131: google.spanner.executor.v1.MutationAction.UpdateArgs.values:type_name -> google.spanner.executor.v1.ValueList
	72,  // 132: google.spanner.executor.v1.MutationAction.Mod.insert:type_name -> google.spanner.executor.v1.MutationAction.InsertArgs
	73,  // 133: google.spanner.executor.v1.MutationAction.Mod.update:type_name -> google.spanner.executor.v1.MutationAction.UpdateArgs
	72,  // 134: google.spanner.executor.v1.MutationAction.Mod.insert_or_update:type_name -> google.spanner.executor.v1.MutationAction.InsertArgs
	72,  // 135: google.spanner.executor.v1.MutationAction.Mod.replace:type_name -> google.spanner.executor.v1.MutationAction.InsertArgs
	11,  // 136: google.spanner.executor.v1.MutationAction.Mod.delete_keys:type_name -> google.spanner.executor.v1.KeySet
	94,  // 137: google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions.rpc_priority:type_name -> google.spanner.v1.RequestOptions.Priority
	2,   // 138: google.spanner.executor.v1.SpannerExecutorProxy.ExecuteActionAsync:input_type -> google.spanner.executor.v1.SpannerAsyncActionRequest
	3,   // 139: google.spanner.executor.v1.SpannerExecutorProxy.ExecuteActionAsync:output_type -> google.spanner.executor.v1.SpannerAsyncActionResponse
	139, // [139:140] is the sub-list for method output_type
	138, // [138:139] is the sub-list for method input_type
	138, // [138:138] is the sub-list for extension type_name
	138, // [138:138] is the sub-list for extension extendee
	0,   // [0:138] is the sub-list for field type_name
}

func init() { file_google_spanner_executor_v1_cloud_executor_proto_init() }
func file_google_spanner_executor_v1_cloud_executor_proto_init() {
	if File_google_spanner_executor_v1_cloud_executor_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpannerAsyncActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpannerAsyncActionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpannerAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DmlAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDmlAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeySet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteMutationsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionedUpdateAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartTransactionAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Concurrency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransactionExecutionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinishTransactionAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdminAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateUserInstanceConfigAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateUserInstanceConfigAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCloudInstanceConfigAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteUserInstanceConfigAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloudInstanceConfigsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCloudInstanceAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCloudInstanceAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCloudInstanceAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCloudDatabaseAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCloudDatabaseDdlAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCloudDatabaseAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DropCloudDatabaseAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReconfigureCloudDatabaseAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloudDatabasesAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloudInstancesAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCloudInstanceAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloudDatabaseOperationsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreCloudDatabaseAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCloudDatabaseAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCloudBackupAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CopyCloudBackupAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCloudBackupAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCloudBackupAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCloudBackupAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloudBackupsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCloudBackupOperationsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOperationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelOperationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartBatchTransactionAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseBatchTransactionAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDbPartitionsForReadAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDbPartitionsForQueryAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutePartitionAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteChangeStreamQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpannerActionOutcome); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdminResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudBackupResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudInstanceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudInstanceConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudDatabaseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeStreamRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataChangeRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChildPartitionsRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeartbeatRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryAction_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutationAction_InsertArgs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutationAction_UpdateArgs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutationAction_Mod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionedUpdateAction_ExecutePartitionedUpdateOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataChangeRecord_ColumnType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataChangeRecord_Mod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChildPartitionsRecord_ChildPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*SpannerAction_Start)(nil),
		(*SpannerAction_Finish)(nil),
		(*SpannerAction_Read)(nil),
		(*SpannerAction_Query)(nil),
		(*SpannerAction_Mutation)(nil),
		(*SpannerAction_Dml)(nil),
		(*SpannerAction_BatchDml)(nil),
		(*SpannerAction_Write)(nil),
		(*SpannerAction_PartitionedUpdate)(nil),
		(*SpannerAction_Admin)(nil),
		(*SpannerAction_StartBatchTxn)(nil),
		(*SpannerAction_CloseBatchTxn)(nil),
		(*SpannerAction_GenerateDbPartitionsRead)(nil),
		(*SpannerAction_GenerateDbPartitionsQuery)(nil),
		(*SpannerAction_ExecutePartition)(nil),
		(*SpannerAction_ExecuteChangeStreamQuery)(nil),
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Value_IsNull)(nil),
		(*Value_IntValue)(nil),
		(*Value_BoolValue)(nil),
		(*Value_DoubleValue)(nil),
		(*Value_BytesValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_StructValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_DateDaysValue)(nil),
		(*Value_IsCommitTimestamp)(nil),
		(*Value_ArrayValue)(nil),
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*Concurrency_StalenessSeconds)(nil),
		(*Concurrency_MinReadTimestampMicros)(nil),
		(*Concurrency_MaxStalenessSeconds)(nil),
		(*Concurrency_ExactTimestampMicros)(nil),
		(*Concurrency_Strong)(nil),
		(*Concurrency_Batch)(nil),
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*AdminAction_CreateUserInstanceConfig)(nil),
		(*AdminAction_UpdateUserInstanceConfig)(nil),
		(*AdminAction_DeleteUserInstanceConfig)(nil),
		(*AdminAction_GetCloudInstanceConfig)(nil),
		(*AdminAction_ListInstanceConfigs)(nil),
		(*AdminAction_CreateCloudInstance)(nil),
		(*AdminAction_UpdateCloudInstance)(nil),
		(*AdminAction_DeleteCloudInstance)(nil),
		(*AdminAction_ListCloudInstances)(nil),
		(*AdminAction_GetCloudInstance)(nil),
		(*AdminAction_CreateCloudDatabase)(nil),
		(*AdminAction_UpdateCloudDatabaseDdl)(nil),
		(*AdminAction_UpdateCloudDatabase)(nil),
		(*AdminAction_DropCloudDatabase)(nil),
		(*AdminAction_ListCloudDatabases)(nil),
		(*AdminAction_ListCloudDatabaseOperations)(nil),
		(*AdminAction_RestoreCloudDatabase)(nil),
		(*AdminAction_GetCloudDatabase)(nil),
		(*AdminAction_CreateCloudBackup)(nil),
		(*AdminAction_CopyCloudBackup)(nil),
		(*AdminAction_GetCloudBackup)(nil),
		(*AdminAction_UpdateCloudBackup)(nil),
		(*AdminAction_DeleteCloudBackup)(nil),
		(*AdminAction_ListCloudBackups)(nil),
		(*AdminAction_ListCloudBackupOperations)(nil),
		(*AdminAction_GetOperation)(nil),
		(*AdminAction_CancelOperation)(nil),
		(*AdminAction_ReconfigureCloudDatabase)(nil),
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[22].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[25].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[26].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[27].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[29].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[30].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[33].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[35].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[40].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[49].OneofWrappers = []interface{}{
		(*StartBatchTransactionAction_BatchTxnTime)(nil),
		(*StartBatchTransactionAction_Tid)(nil),
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[51].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[52].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[53].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[55].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[56].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[63].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[64].OneofWrappers = []interface{}{}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[65].OneofWrappers = []interface{}{
		(*ChangeStreamRecord_DataChange)(nil),
		(*ChangeStreamRecord_ChildPartition)(nil),
		(*ChangeStreamRecord_Heartbeat)(nil),
	}
	file_google_spanner_executor_v1_cloud_executor_proto_msgTypes[73].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_executor_v1_cloud_executor_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   80,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_spanner_executor_v1_cloud_executor_proto_goTypes,
		DependencyIndexes: file_google_spanner_executor_v1_cloud_executor_proto_depIdxs,
		EnumInfos:         file_google_spanner_executor_v1_cloud_executor_proto_enumTypes,
		MessageInfos:      file_google_spanner_executor_v1_cloud_executor_proto_msgTypes,
	}.Build()
	File_google_spanner_executor_v1_cloud_executor_proto = out.File
	file_google_spanner_executor_v1_cloud_executor_proto_rawDesc = nil
	file_google_spanner_executor_v1_cloud_executor_proto_goTypes = nil
	file_google_spanner_executor_v1_cloud_executor_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpannerExecutorProxyClient is the client API for SpannerExecutorProxy service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpannerExecutorProxyClient interface {
	// ExecuteActionAsync is a streaming call that starts executing a new Spanner
	// action.
	//
	// For each request, the server will reply with one or more responses, but
	// only the last response will contain status in the outcome.
	//
	// Responses can be matched to requests by action_id. It is allowed to have
	// multiple actions in flight--in that case, actions are be executed in
	// parallel.
	ExecuteActionAsync(ctx context.Context, opts ...grpc.CallOption) (SpannerExecutorProxy_ExecuteActionAsyncClient, error)
}

type spannerExecutorProxyClient struct {
	cc grpc.ClientConnInterface
}

func NewSpannerExecutorProxyClient(cc grpc.ClientConnInterface) SpannerExecutorProxyClient {
	return &spannerExecutorProxyClient{cc}
}

func (c *spannerExecutorProxyClient) ExecuteActionAsync(ctx context.Context, opts ...grpc.CallOption) (SpannerExecutorProxy_ExecuteActionAsyncClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SpannerExecutorProxy_serviceDesc.Streams[0], "/google.spanner.executor.v1.SpannerExecutorProxy/ExecuteActionAsync", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerExecutorProxyExecuteActionAsyncClient{stream}
	return x, nil
}

type SpannerExecutorProxy_ExecuteActionAsyncClient interface {
	Send(*SpannerAsyncActionRequest) error
	Recv() (*SpannerAsyncActionResponse, error)
	grpc.ClientStream
}

type spannerExecutorProxyExecuteActionAsyncClient struct {
	grpc.ClientStream
}

func (x *spannerExecutorProxyExecuteActionAsyncClient) Send(m *SpannerAsyncActionRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *spannerExecutorProxyExecuteActionAsyncClient) Recv() (*SpannerAsyncActionResponse, error) {
	m := new(SpannerAsyncActionResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpannerExecutorProxyServer is the server API for SpannerExecutorProxy service.
type SpannerExecutorProxyServer interface {
	// ExecuteActionAsync is a streaming call that starts executing a new Spanner
	// action.
	//
	// For each request, the server will reply with one or more responses, but
	// only the last response will contain status in the outcome.
	//
	// Responses can be matched to requests by action_id. It is allowed to have
	// multiple actions in flight--in that case, actions are be executed in
	// parallel.
	ExecuteActionAsync(SpannerExecutorProxy_ExecuteActionAsyncServer) error
}

// UnimplementedSpannerExecutorProxyServer can be embedded to have forward compatible implementations.
type UnimplementedSpannerExecutorProxyServer struct {
}

func (*UnimplementedSpannerExecutorProxyServer) ExecuteActionAsync(SpannerExecutorProxy_ExecuteActionAsyncServer) error {
	return status1.Errorf(codes.Unimplemented, "method ExecuteActionAsync not implemented")
}

func RegisterSpannerExecutorProxyServer(s *grpc.Server, srv SpannerExecutorProxyServer) {
	s.RegisterService(&_SpannerExecutorProxy_serviceDesc, srv)
}

func _SpannerExecutorProxy_ExecuteActionAsync_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpannerExecutorProxyServer).ExecuteActionAsync(&spannerExecutorProxyExecuteActionAsyncServer{stream})
}

type SpannerExecutorProxy_ExecuteActionAsyncServer interface {
	Send(*SpannerAsyncActionResponse) error
	Recv() (*SpannerAsyncActionRequest, error)
	grpc.ServerStream
}

type spannerExecutorProxyExecuteActionAsyncServer struct {
	grpc.ServerStream
}

func (x *spannerExecutorProxyExecuteActionAsyncServer) Send(m *SpannerAsyncActionResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *spannerExecutorProxyExecuteActionAsyncServer) Recv() (*SpannerAsyncActionRequest, error) {
	m := new(SpannerAsyncActionRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _SpannerExecutorProxy_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.executor.v1.SpannerExecutorProxy",
	HandlerType: (*SpannerExecutorProxyServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ExecuteActionAsync",
			Handler:       _SpannerExecutorProxy_ExecuteActionAsync_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/spanner/executor/v1/cloud_executor.proto",
}
