// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package networkmanagement

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	networkmanagementpb "cloud.google.com/go/networkmanagement/apiv1/networkmanagementpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newReachabilityClientHook clientHook

// ReachabilityCallOptions contains the retry settings for each method of ReachabilityClient.
type ReachabilityCallOptions struct {
	ListConnectivityTests  []gax.CallOption
	GetConnectivityTest    []gax.CallOption
	CreateConnectivityTest []gax.CallOption
	UpdateConnectivityTest []gax.CallOption
	RerunConnectivityTest  []gax.CallOption
	DeleteConnectivityTest []gax.CallOption
}

func defaultReachabilityGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("networkmanagement.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("networkmanagement.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("networkmanagement.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://networkmanagement.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultReachabilityCallOptions() *ReachabilityCallOptions {
	return &ReachabilityCallOptions{
		ListConnectivityTests: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RerunConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

func defaultReachabilityRESTCallOptions() *ReachabilityCallOptions {
	return &ReachabilityCallOptions{
		ListConnectivityTests: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RerunConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteConnectivityTest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

// internalReachabilityClient is an interface that defines the methods available from Network Management API.
type internalReachabilityClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListConnectivityTests(context.Context, *networkmanagementpb.ListConnectivityTestsRequest, ...gax.CallOption) *ConnectivityTestIterator
	GetConnectivityTest(context.Context, *networkmanagementpb.GetConnectivityTestRequest, ...gax.CallOption) (*networkmanagementpb.ConnectivityTest, error)
	CreateConnectivityTest(context.Context, *networkmanagementpb.CreateConnectivityTestRequest, ...gax.CallOption) (*CreateConnectivityTestOperation, error)
	CreateConnectivityTestOperation(name string) *CreateConnectivityTestOperation
	UpdateConnectivityTest(context.Context, *networkmanagementpb.UpdateConnectivityTestRequest, ...gax.CallOption) (*UpdateConnectivityTestOperation, error)
	UpdateConnectivityTestOperation(name string) *UpdateConnectivityTestOperation
	RerunConnectivityTest(context.Context, *networkmanagementpb.RerunConnectivityTestRequest, ...gax.CallOption) (*RerunConnectivityTestOperation, error)
	RerunConnectivityTestOperation(name string) *RerunConnectivityTestOperation
	DeleteConnectivityTest(context.Context, *networkmanagementpb.DeleteConnectivityTestRequest, ...gax.CallOption) (*DeleteConnectivityTestOperation, error)
	DeleteConnectivityTestOperation(name string) *DeleteConnectivityTestOperation
}

// ReachabilityClient is a client for interacting with Network Management API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The Reachability service in the Google Cloud Network Management API provides
// services that analyze the reachability within a single Google Virtual Private
// Cloud (VPC) network, between peered VPC networks, between VPC and on-premises
// networks, or between VPC networks and internet hosts. A reachability analysis
// is based on Google Cloud network configurations.
//
// You can use the analysis results to verify these configurations and
// to troubleshoot connectivity issues.
type ReachabilityClient struct {
	// The internal transport-dependent client.
	internalClient internalReachabilityClient

	// The call options for this service.
	CallOptions *ReachabilityCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *ReachabilityClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *ReachabilityClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *ReachabilityClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListConnectivityTests lists all Connectivity Tests owned by a project.
func (c *ReachabilityClient) ListConnectivityTests(ctx context.Context, req *networkmanagementpb.ListConnectivityTestsRequest, opts ...gax.CallOption) *ConnectivityTestIterator {
	return c.internalClient.ListConnectivityTests(ctx, req, opts...)
}

// GetConnectivityTest gets the details of a specific Connectivity Test.
func (c *ReachabilityClient) GetConnectivityTest(ctx context.Context, req *networkmanagementpb.GetConnectivityTestRequest, opts ...gax.CallOption) (*networkmanagementpb.ConnectivityTest, error) {
	return c.internalClient.GetConnectivityTest(ctx, req, opts...)
}

// CreateConnectivityTest creates a new Connectivity Test.
// After you create a test, the reachability analysis is performed as part
// of the long running operation, which completes when the analysis completes.
//
// If the endpoint specifications in ConnectivityTest are invalid
// (for example, containing non-existent resources in the network, or you
// don’t have read permissions to the network configurations of listed
// projects), then the reachability result returns a value of UNKNOWN.
//
// If the endpoint specifications in ConnectivityTest are
// incomplete, the reachability result returns a value of
// AMBIGUOUS. For more information,
// see the Connectivity Test documentation.
func (c *ReachabilityClient) CreateConnectivityTest(ctx context.Context, req *networkmanagementpb.CreateConnectivityTestRequest, opts ...gax.CallOption) (*CreateConnectivityTestOperation, error) {
	return c.internalClient.CreateConnectivityTest(ctx, req, opts...)
}

// CreateConnectivityTestOperation returns a new CreateConnectivityTestOperation from a given name.
// The name must be that of a previously created CreateConnectivityTestOperation, possibly from a different process.
func (c *ReachabilityClient) CreateConnectivityTestOperation(name string) *CreateConnectivityTestOperation {
	return c.internalClient.CreateConnectivityTestOperation(name)
}

// UpdateConnectivityTest updates the configuration of an existing ConnectivityTest.
// After you update a test, the reachability analysis is performed as part
// of the long running operation, which completes when the analysis completes.
// The Reachability state in the test resource is updated with the new result.
//
// If the endpoint specifications in ConnectivityTest are invalid
// (for example, they contain non-existent resources in the network, or the
// user does not have read permissions to the network configurations of
// listed projects), then the reachability result returns a value of
// UNKNOWN.
//
// If the endpoint specifications in ConnectivityTest are incomplete, the
// reachability result returns a value of AMBIGUOUS. See the documentation
// in ConnectivityTest for for more details.
func (c *ReachabilityClient) UpdateConnectivityTest(ctx context.Context, req *networkmanagementpb.UpdateConnectivityTestRequest, opts ...gax.CallOption) (*UpdateConnectivityTestOperation, error) {
	return c.internalClient.UpdateConnectivityTest(ctx, req, opts...)
}

// UpdateConnectivityTestOperation returns a new UpdateConnectivityTestOperation from a given name.
// The name must be that of a previously created UpdateConnectivityTestOperation, possibly from a different process.
func (c *ReachabilityClient) UpdateConnectivityTestOperation(name string) *UpdateConnectivityTestOperation {
	return c.internalClient.UpdateConnectivityTestOperation(name)
}

// RerunConnectivityTest rerun an existing ConnectivityTest.
// After the user triggers the rerun, the reachability analysis is performed
// as part of the long running operation, which completes when the analysis
// completes.
//
// Even though the test configuration remains the same, the reachability
// result may change due to underlying network configuration changes.
//
// If the endpoint specifications in ConnectivityTest become invalid (for
// example, specified resources are deleted in the network, or you lost
// read permissions to the network configurations of listed projects), then
// the reachability result returns a value of UNKNOWN.
func (c *ReachabilityClient) RerunConnectivityTest(ctx context.Context, req *networkmanagementpb.RerunConnectivityTestRequest, opts ...gax.CallOption) (*RerunConnectivityTestOperation, error) {
	return c.internalClient.RerunConnectivityTest(ctx, req, opts...)
}

// RerunConnectivityTestOperation returns a new RerunConnectivityTestOperation from a given name.
// The name must be that of a previously created RerunConnectivityTestOperation, possibly from a different process.
func (c *ReachabilityClient) RerunConnectivityTestOperation(name string) *RerunConnectivityTestOperation {
	return c.internalClient.RerunConnectivityTestOperation(name)
}

// DeleteConnectivityTest deletes a specific ConnectivityTest.
func (c *ReachabilityClient) DeleteConnectivityTest(ctx context.Context, req *networkmanagementpb.DeleteConnectivityTestRequest, opts ...gax.CallOption) (*DeleteConnectivityTestOperation, error) {
	return c.internalClient.DeleteConnectivityTest(ctx, req, opts...)
}

// DeleteConnectivityTestOperation returns a new DeleteConnectivityTestOperation from a given name.
// The name must be that of a previously created DeleteConnectivityTestOperation, possibly from a different process.
func (c *ReachabilityClient) DeleteConnectivityTestOperation(name string) *DeleteConnectivityTestOperation {
	return c.internalClient.DeleteConnectivityTestOperation(name)
}

// reachabilityGRPCClient is a client for interacting with Network Management API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type reachabilityGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing ReachabilityClient
	CallOptions **ReachabilityCallOptions

	// The gRPC API client.
	reachabilityClient networkmanagementpb.ReachabilityServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewReachabilityClient creates a new reachability service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The Reachability service in the Google Cloud Network Management API provides
// services that analyze the reachability within a single Google Virtual Private
// Cloud (VPC) network, between peered VPC networks, between VPC and on-premises
// networks, or between VPC networks and internet hosts. A reachability analysis
// is based on Google Cloud network configurations.
//
// You can use the analysis results to verify these configurations and
// to troubleshoot connectivity issues.
func NewReachabilityClient(ctx context.Context, opts ...option.ClientOption) (*ReachabilityClient, error) {
	clientOpts := defaultReachabilityGRPCClientOptions()
	if newReachabilityClientHook != nil {
		hookOpts, err := newReachabilityClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := ReachabilityClient{CallOptions: defaultReachabilityCallOptions()}

	c := &reachabilityGRPCClient{
		connPool:           connPool,
		reachabilityClient: networkmanagementpb.NewReachabilityServiceClient(connPool),
		CallOptions:        &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *reachabilityGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *reachabilityGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *reachabilityGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type reachabilityRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing ReachabilityClient
	CallOptions **ReachabilityCallOptions
}

// NewReachabilityRESTClient creates a new reachability service rest client.
//
// The Reachability service in the Google Cloud Network Management API provides
// services that analyze the reachability within a single Google Virtual Private
// Cloud (VPC) network, between peered VPC networks, between VPC and on-premises
// networks, or between VPC networks and internet hosts. A reachability analysis
// is based on Google Cloud network configurations.
//
// You can use the analysis results to verify these configurations and
// to troubleshoot connectivity issues.
func NewReachabilityRESTClient(ctx context.Context, opts ...option.ClientOption) (*ReachabilityClient, error) {
	clientOpts := append(defaultReachabilityRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultReachabilityRESTCallOptions()
	c := &reachabilityRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &ReachabilityClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultReachabilityRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://networkmanagement.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://networkmanagement.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://networkmanagement.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://networkmanagement.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *reachabilityRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *reachabilityRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *reachabilityRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *reachabilityGRPCClient) ListConnectivityTests(ctx context.Context, req *networkmanagementpb.ListConnectivityTestsRequest, opts ...gax.CallOption) *ConnectivityTestIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListConnectivityTests[0:len((*c.CallOptions).ListConnectivityTests):len((*c.CallOptions).ListConnectivityTests)], opts...)
	it := &ConnectivityTestIterator{}
	req = proto.Clone(req).(*networkmanagementpb.ListConnectivityTestsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkmanagementpb.ConnectivityTest, string, error) {
		resp := &networkmanagementpb.ListConnectivityTestsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.reachabilityClient.ListConnectivityTests(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetResources(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *reachabilityGRPCClient) GetConnectivityTest(ctx context.Context, req *networkmanagementpb.GetConnectivityTestRequest, opts ...gax.CallOption) (*networkmanagementpb.ConnectivityTest, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetConnectivityTest[0:len((*c.CallOptions).GetConnectivityTest):len((*c.CallOptions).GetConnectivityTest)], opts...)
	var resp *networkmanagementpb.ConnectivityTest
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.reachabilityClient.GetConnectivityTest(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *reachabilityGRPCClient) CreateConnectivityTest(ctx context.Context, req *networkmanagementpb.CreateConnectivityTestRequest, opts ...gax.CallOption) (*CreateConnectivityTestOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateConnectivityTest[0:len((*c.CallOptions).CreateConnectivityTest):len((*c.CallOptions).CreateConnectivityTest)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.reachabilityClient.CreateConnectivityTest(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *reachabilityGRPCClient) UpdateConnectivityTest(ctx context.Context, req *networkmanagementpb.UpdateConnectivityTestRequest, opts ...gax.CallOption) (*UpdateConnectivityTestOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource.name", url.QueryEscape(req.GetResource().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateConnectivityTest[0:len((*c.CallOptions).UpdateConnectivityTest):len((*c.CallOptions).UpdateConnectivityTest)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.reachabilityClient.UpdateConnectivityTest(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *reachabilityGRPCClient) RerunConnectivityTest(ctx context.Context, req *networkmanagementpb.RerunConnectivityTestRequest, opts ...gax.CallOption) (*RerunConnectivityTestOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RerunConnectivityTest[0:len((*c.CallOptions).RerunConnectivityTest):len((*c.CallOptions).RerunConnectivityTest)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.reachabilityClient.RerunConnectivityTest(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RerunConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *reachabilityGRPCClient) DeleteConnectivityTest(ctx context.Context, req *networkmanagementpb.DeleteConnectivityTestRequest, opts ...gax.CallOption) (*DeleteConnectivityTestOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteConnectivityTest[0:len((*c.CallOptions).DeleteConnectivityTest):len((*c.CallOptions).DeleteConnectivityTest)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.reachabilityClient.DeleteConnectivityTest(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

// ListConnectivityTests lists all Connectivity Tests owned by a project.
func (c *reachabilityRESTClient) ListConnectivityTests(ctx context.Context, req *networkmanagementpb.ListConnectivityTestsRequest, opts ...gax.CallOption) *ConnectivityTestIterator {
	it := &ConnectivityTestIterator{}
	req = proto.Clone(req).(*networkmanagementpb.ListConnectivityTestsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkmanagementpb.ConnectivityTest, string, error) {
		resp := &networkmanagementpb.ListConnectivityTestsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/connectivityTests", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetResources(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetConnectivityTest gets the details of a specific Connectivity Test.
func (c *reachabilityRESTClient) GetConnectivityTest(ctx context.Context, req *networkmanagementpb.GetConnectivityTestRequest, opts ...gax.CallOption) (*networkmanagementpb.ConnectivityTest, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetConnectivityTest[0:len((*c.CallOptions).GetConnectivityTest):len((*c.CallOptions).GetConnectivityTest)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkmanagementpb.ConnectivityTest{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateConnectivityTest creates a new Connectivity Test.
// After you create a test, the reachability analysis is performed as part
// of the long running operation, which completes when the analysis completes.
//
// If the endpoint specifications in ConnectivityTest are invalid
// (for example, containing non-existent resources in the network, or you
// don’t have read permissions to the network configurations of listed
// projects), then the reachability result returns a value of UNKNOWN.
//
// If the endpoint specifications in ConnectivityTest are
// incomplete, the reachability result returns a value of
// AMBIGUOUS. For more information,
// see the Connectivity Test documentation.
func (c *reachabilityRESTClient) CreateConnectivityTest(ctx context.Context, req *networkmanagementpb.CreateConnectivityTestRequest, opts ...gax.CallOption) (*CreateConnectivityTestOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetResource()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/connectivityTests", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("testId", fmt.Sprintf("%v", req.GetTestId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateConnectivityTest updates the configuration of an existing ConnectivityTest.
// After you update a test, the reachability analysis is performed as part
// of the long running operation, which completes when the analysis completes.
// The Reachability state in the test resource is updated with the new result.
//
// If the endpoint specifications in ConnectivityTest are invalid
// (for example, they contain non-existent resources in the network, or the
// user does not have read permissions to the network configurations of
// listed projects), then the reachability result returns a value of
// UNKNOWN.
//
// If the endpoint specifications in ConnectivityTest are incomplete, the
// reachability result returns a value of AMBIGUOUS. See the documentation
// in ConnectivityTest for for more details.
func (c *reachabilityRESTClient) UpdateConnectivityTest(ctx context.Context, req *networkmanagementpb.UpdateConnectivityTestRequest, opts ...gax.CallOption) (*UpdateConnectivityTestOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetResource()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetResource().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource.name", url.QueryEscape(req.GetResource().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RerunConnectivityTest rerun an existing ConnectivityTest.
// After the user triggers the rerun, the reachability analysis is performed
// as part of the long running operation, which completes when the analysis
// completes.
//
// Even though the test configuration remains the same, the reachability
// result may change due to underlying network configuration changes.
//
// If the endpoint specifications in ConnectivityTest become invalid (for
// example, specified resources are deleted in the network, or you lost
// read permissions to the network configurations of listed projects), then
// the reachability result returns a value of UNKNOWN.
func (c *reachabilityRESTClient) RerunConnectivityTest(ctx context.Context, req *networkmanagementpb.RerunConnectivityTestRequest, opts ...gax.CallOption) (*RerunConnectivityTestOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:rerun", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RerunConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteConnectivityTest deletes a specific ConnectivityTest.
func (c *reachabilityRESTClient) DeleteConnectivityTest(ctx context.Context, req *networkmanagementpb.DeleteConnectivityTestRequest, opts ...gax.CallOption) (*DeleteConnectivityTestOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateConnectivityTestOperation returns a new CreateConnectivityTestOperation from a given name.
// The name must be that of a previously created CreateConnectivityTestOperation, possibly from a different process.
func (c *reachabilityGRPCClient) CreateConnectivityTestOperation(name string) *CreateConnectivityTestOperation {
	return &CreateConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateConnectivityTestOperation returns a new CreateConnectivityTestOperation from a given name.
// The name must be that of a previously created CreateConnectivityTestOperation, possibly from a different process.
func (c *reachabilityRESTClient) CreateConnectivityTestOperation(name string) *CreateConnectivityTestOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteConnectivityTestOperation returns a new DeleteConnectivityTestOperation from a given name.
// The name must be that of a previously created DeleteConnectivityTestOperation, possibly from a different process.
func (c *reachabilityGRPCClient) DeleteConnectivityTestOperation(name string) *DeleteConnectivityTestOperation {
	return &DeleteConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteConnectivityTestOperation returns a new DeleteConnectivityTestOperation from a given name.
// The name must be that of a previously created DeleteConnectivityTestOperation, possibly from a different process.
func (c *reachabilityRESTClient) DeleteConnectivityTestOperation(name string) *DeleteConnectivityTestOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RerunConnectivityTestOperation returns a new RerunConnectivityTestOperation from a given name.
// The name must be that of a previously created RerunConnectivityTestOperation, possibly from a different process.
func (c *reachabilityGRPCClient) RerunConnectivityTestOperation(name string) *RerunConnectivityTestOperation {
	return &RerunConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RerunConnectivityTestOperation returns a new RerunConnectivityTestOperation from a given name.
// The name must be that of a previously created RerunConnectivityTestOperation, possibly from a different process.
func (c *reachabilityRESTClient) RerunConnectivityTestOperation(name string) *RerunConnectivityTestOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RerunConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateConnectivityTestOperation returns a new UpdateConnectivityTestOperation from a given name.
// The name must be that of a previously created UpdateConnectivityTestOperation, possibly from a different process.
func (c *reachabilityGRPCClient) UpdateConnectivityTestOperation(name string) *UpdateConnectivityTestOperation {
	return &UpdateConnectivityTestOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateConnectivityTestOperation returns a new UpdateConnectivityTestOperation from a given name.
// The name must be that of a previously created UpdateConnectivityTestOperation, possibly from a different process.
func (c *reachabilityRESTClient) UpdateConnectivityTestOperation(name string) *UpdateConnectivityTestOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateConnectivityTestOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
