// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/gaming/v1beta/common.proto

package gamingpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type OperationStatus_ErrorCode int32

const (
	OperationStatus_ERROR_CODE_UNSPECIFIED OperationStatus_ErrorCode = 0
	OperationStatus_INTERNAL_ERROR         OperationStatus_ErrorCode = 1
	OperationStatus_PERMISSION_DENIED      OperationStatus_ErrorCode = 2
	OperationStatus_CLUSTER_CONNECTION     OperationStatus_ErrorCode = 3
)

// Enum value maps for OperationStatus_ErrorCode.
var (
	OperationStatus_ErrorCode_name = map[int32]string{
		0: "ERROR_CODE_UNSPECIFIED",
		1: "INTERNAL_ERROR",
		2: "PERMISSION_DENIED",
		3: "CLUSTER_CONNECTION",
	}
	OperationStatus_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED": 0,
		"INTERNAL_ERROR":         1,
		"PERMISSION_DENIED":      2,
		"CLUSTER_CONNECTION":     3,
	}
)

func (x OperationStatus_ErrorCode) Enum() *OperationStatus_ErrorCode {
	p := new(OperationStatus_ErrorCode)
	*p = x
	return p
}

func (x OperationStatus_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationStatus_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gaming_v1beta_common_proto_enumTypes[0].Descriptor()
}

func (OperationStatus_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_gaming_v1beta_common_proto_enumTypes[0]
}

func (x OperationStatus_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationStatus_ErrorCode.Descriptor instead.
func (OperationStatus_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{1, 0}
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Output only. List of Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,8,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	// Output only. Operation status for Game Services API operations. Operation status is in
	// the form of key-value pairs where keys are resource IDs and the values show
	// the status of the operation. In case of failures, the value includes an
	// error code and error message.
	OperationStatus map[string]*OperationStatus `protobuf:"bytes,9,rep,name=operation_status,json=operationStatus,proto3" json:"operation_status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *OperationMetadata) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

func (x *OperationMetadata) GetOperationStatus() map[string]*OperationStatus {
	if x != nil {
		return x.OperationStatus
	}
	return nil
}

type OperationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Whether the operation is done or still in progress.
	Done bool `protobuf:"varint,1,opt,name=done,proto3" json:"done,omitempty"`
	// The error code in case of failures.
	ErrorCode OperationStatus_ErrorCode `protobuf:"varint,2,opt,name=error_code,json=errorCode,proto3,enum=google.cloud.gaming.v1beta.OperationStatus_ErrorCode" json:"error_code,omitempty"`
	// The human-readable error message.
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *OperationStatus) Reset() {
	*x = OperationStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationStatus) ProtoMessage() {}

func (x *OperationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationStatus.ProtoReflect.Descriptor instead.
func (*OperationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{1}
}

func (x *OperationStatus) GetDone() bool {
	if x != nil {
		return x.Done
	}
	return false
}

func (x *OperationStatus) GetErrorCode() OperationStatus_ErrorCode {
	if x != nil {
		return x.ErrorCode
	}
	return OperationStatus_ERROR_CODE_UNSPECIFIED
}

func (x *OperationStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// The label selector, used to group labels on the resources.
type LabelSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource labels for this selector.
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LabelSelector) Reset() {
	*x = LabelSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelSelector) ProtoMessage() {}

func (x *LabelSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelSelector.ProtoReflect.Descriptor instead.
func (*LabelSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{2}
}

func (x *LabelSelector) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// The realm selector, used to match realm resources.
type RealmSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of realms to match.
	Realms []string `protobuf:"bytes,1,rep,name=realms,proto3" json:"realms,omitempty"`
}

func (x *RealmSelector) Reset() {
	*x = RealmSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RealmSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RealmSelector) ProtoMessage() {}

func (x *RealmSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RealmSelector.ProtoReflect.Descriptor instead.
func (*RealmSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{3}
}

func (x *RealmSelector) GetRealms() []string {
	if x != nil {
		return x.Realms
	}
	return nil
}

// The schedule of a recurring or one time event. The event's time span is
// specified by start_time and end_time. If the scheduled event's timespan is
// larger than the cron_spec + cron_job_duration, the event will be recurring.
// If only cron_spec + cron_job_duration are specified, the event is effective
// starting at the local time specified by cron_spec, and is recurring.
//
// ```
// start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time
// cron job: cron spec start time + duration
// ```
type Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of the event.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the event.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The duration for the cron job event. The duration of the event is effective
	// after the cron job's start time.
	CronJobDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=cron_job_duration,json=cronJobDuration,proto3" json:"cron_job_duration,omitempty"`
	// The cron definition of the scheduled event. See
	// https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
	// defined by the realm.
	CronSpec string `protobuf:"bytes,4,opt,name=cron_spec,json=cronSpec,proto3" json:"cron_spec,omitempty"`
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{4}
}

func (x *Schedule) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Schedule) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Schedule) GetCronJobDuration() *durationpb.Duration {
	if x != nil {
		return x.CronJobDuration
	}
	return nil
}

func (x *Schedule) GetCronSpec() string {
	if x != nil {
		return x.CronSpec
	}
	return ""
}

// Encapsulates Agones fleet spec and Agones autoscaler spec sources.
type SpecSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The game server config resource. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}/configs/{config_id}`.
	GameServerConfigName string `protobuf:"bytes,1,opt,name=game_server_config_name,json=gameServerConfigName,proto3" json:"game_server_config_name,omitempty"`
	// The name of the Agones leet config or Agones scaling config used to derive
	// the Agones fleet or Agones autoscaler spec.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SpecSource) Reset() {
	*x = SpecSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpecSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpecSource) ProtoMessage() {}

func (x *SpecSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpecSource.ProtoReflect.Descriptor instead.
func (*SpecSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{5}
}

func (x *SpecSource) GetGameServerConfigName() string {
	if x != nil {
		return x.GameServerConfigName
	}
	return ""
}

func (x *SpecSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details about the Agones resources.
type TargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The game server cluster name. Uses the form:
	//
	// `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
	GameServerClusterName string `protobuf:"bytes,1,opt,name=game_server_cluster_name,json=gameServerClusterName,proto3" json:"game_server_cluster_name,omitempty"`
	// The game server deployment name. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment_id}`.
	GameServerDeploymentName string `protobuf:"bytes,2,opt,name=game_server_deployment_name,json=gameServerDeploymentName,proto3" json:"game_server_deployment_name,omitempty"`
	// Agones fleet details for game server clusters and game server deployments.
	FleetDetails []*TargetDetails_TargetFleetDetails `protobuf:"bytes,3,rep,name=fleet_details,json=fleetDetails,proto3" json:"fleet_details,omitempty"`
}

func (x *TargetDetails) Reset() {
	*x = TargetDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetDetails) ProtoMessage() {}

func (x *TargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetDetails.ProtoReflect.Descriptor instead.
func (*TargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{6}
}

func (x *TargetDetails) GetGameServerClusterName() string {
	if x != nil {
		return x.GameServerClusterName
	}
	return ""
}

func (x *TargetDetails) GetGameServerDeploymentName() string {
	if x != nil {
		return x.GameServerDeploymentName
	}
	return ""
}

func (x *TargetDetails) GetFleetDetails() []*TargetDetails_TargetFleetDetails {
	if x != nil {
		return x.FleetDetails
	}
	return nil
}

// Encapsulates the Target state.
type TargetState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about Agones fleets.
	Details []*TargetDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *TargetState) Reset() {
	*x = TargetState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState) ProtoMessage() {}

func (x *TargetState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState.ProtoReflect.Descriptor instead.
func (*TargetState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{7}
}

func (x *TargetState) GetDetails() []*TargetDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// Details of the deployed Agones fleet.
type DeployedFleetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the Agones fleet.
	DeployedFleet *DeployedFleetDetails_DeployedFleet `protobuf:"bytes,1,opt,name=deployed_fleet,json=deployedFleet,proto3" json:"deployed_fleet,omitempty"`
	// Information about the Agones autoscaler for that fleet.
	DeployedAutoscaler *DeployedFleetDetails_DeployedFleetAutoscaler `protobuf:"bytes,2,opt,name=deployed_autoscaler,json=deployedAutoscaler,proto3" json:"deployed_autoscaler,omitempty"`
}

func (x *DeployedFleetDetails) Reset() {
	*x = DeployedFleetDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployedFleetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedFleetDetails) ProtoMessage() {}

func (x *DeployedFleetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedFleetDetails.ProtoReflect.Descriptor instead.
func (*DeployedFleetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{8}
}

func (x *DeployedFleetDetails) GetDeployedFleet() *DeployedFleetDetails_DeployedFleet {
	if x != nil {
		return x.DeployedFleet
	}
	return nil
}

func (x *DeployedFleetDetails) GetDeployedAutoscaler() *DeployedFleetDetails_DeployedFleetAutoscaler {
	if x != nil {
		return x.DeployedAutoscaler
	}
	return nil
}

// Details of the target Agones fleet.
type TargetDetails_TargetFleetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference to target Agones fleet.
	Fleet *TargetDetails_TargetFleetDetails_TargetFleet `protobuf:"bytes,1,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Reference to target Agones fleet autoscaling policy.
	Autoscaler *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler `protobuf:"bytes,2,opt,name=autoscaler,proto3" json:"autoscaler,omitempty"`
}

func (x *TargetDetails_TargetFleetDetails) Reset() {
	*x = TargetDetails_TargetFleetDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetDetails_TargetFleetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetDetails_TargetFleetDetails) ProtoMessage() {}

func (x *TargetDetails_TargetFleetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetDetails_TargetFleetDetails.ProtoReflect.Descriptor instead.
func (*TargetDetails_TargetFleetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{6, 0}
}

func (x *TargetDetails_TargetFleetDetails) GetFleet() *TargetDetails_TargetFleetDetails_TargetFleet {
	if x != nil {
		return x.Fleet
	}
	return nil
}

func (x *TargetDetails_TargetFleetDetails) GetAutoscaler() *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler {
	if x != nil {
		return x.Autoscaler
	}
	return nil
}

// Target Agones fleet specification.
type TargetDetails_TargetFleetDetails_TargetFleet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Agones fleet.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Encapsulates the source of the Agones fleet spec.
	// The Agones fleet spec source.
	SpecSource *SpecSource `protobuf:"bytes,2,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
}

func (x *TargetDetails_TargetFleetDetails_TargetFleet) Reset() {
	*x = TargetDetails_TargetFleetDetails_TargetFleet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetDetails_TargetFleetDetails_TargetFleet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetDetails_TargetFleetDetails_TargetFleet) ProtoMessage() {}

func (x *TargetDetails_TargetFleetDetails_TargetFleet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetDetails_TargetFleetDetails_TargetFleet.ProtoReflect.Descriptor instead.
func (*TargetDetails_TargetFleetDetails_TargetFleet) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (x *TargetDetails_TargetFleetDetails_TargetFleet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TargetDetails_TargetFleetDetails_TargetFleet) GetSpecSource() *SpecSource {
	if x != nil {
		return x.SpecSource
	}
	return nil
}

// Target Agones autoscaler policy reference.
type TargetDetails_TargetFleetDetails_TargetFleetAutoscaler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Agones autoscaler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Encapsulates the source of the Agones fleet spec.
	// Details about the Agones autoscaler spec.
	SpecSource *SpecSource `protobuf:"bytes,2,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
}

func (x *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) Reset() {
	*x = TargetDetails_TargetFleetDetails_TargetFleetAutoscaler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) ProtoMessage() {}

func (x *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetDetails_TargetFleetDetails_TargetFleetAutoscaler.ProtoReflect.Descriptor instead.
func (*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{6, 0, 1}
}

func (x *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TargetDetails_TargetFleetDetails_TargetFleetAutoscaler) GetSpecSource() *SpecSource {
	if x != nil {
		return x.SpecSource
	}
	return nil
}

// Agones fleet specification and details.
type DeployedFleetDetails_DeployedFleet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Agones fleet.
	Fleet string `protobuf:"bytes,1,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// The fleet spec retrieved from the Agones fleet.
	FleetSpec string `protobuf:"bytes,2,opt,name=fleet_spec,json=fleetSpec,proto3" json:"fleet_spec,omitempty"`
	// The source spec that is used to create the Agones fleet.
	// The GameServerConfig resource may no longer exist in the system.
	SpecSource *SpecSource `protobuf:"bytes,3,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
	// The current status of the Agones fleet.
	// Includes count of game servers in various states.
	Status *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *DeployedFleetDetails_DeployedFleet) Reset() {
	*x = DeployedFleetDetails_DeployedFleet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployedFleetDetails_DeployedFleet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedFleetDetails_DeployedFleet) ProtoMessage() {}

func (x *DeployedFleetDetails_DeployedFleet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedFleetDetails_DeployedFleet.ProtoReflect.Descriptor instead.
func (*DeployedFleetDetails_DeployedFleet) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{8, 0}
}

func (x *DeployedFleetDetails_DeployedFleet) GetFleet() string {
	if x != nil {
		return x.Fleet
	}
	return ""
}

func (x *DeployedFleetDetails_DeployedFleet) GetFleetSpec() string {
	if x != nil {
		return x.FleetSpec
	}
	return ""
}

func (x *DeployedFleetDetails_DeployedFleet) GetSpecSource() *SpecSource {
	if x != nil {
		return x.SpecSource
	}
	return nil
}

func (x *DeployedFleetDetails_DeployedFleet) GetStatus() *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

// Details about the Agones autoscaler.
type DeployedFleetDetails_DeployedFleetAutoscaler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Agones autoscaler.
	Autoscaler string `protobuf:"bytes,1,opt,name=autoscaler,proto3" json:"autoscaler,omitempty"`
	// The source spec that is used to create the autoscaler.
	// The GameServerConfig resource may no longer exist in the system.
	SpecSource *SpecSource `protobuf:"bytes,4,opt,name=spec_source,json=specSource,proto3" json:"spec_source,omitempty"`
	// The autoscaler spec retrieved from Agones.
	FleetAutoscalerSpec string `protobuf:"bytes,3,opt,name=fleet_autoscaler_spec,json=fleetAutoscalerSpec,proto3" json:"fleet_autoscaler_spec,omitempty"`
}

func (x *DeployedFleetDetails_DeployedFleetAutoscaler) Reset() {
	*x = DeployedFleetDetails_DeployedFleetAutoscaler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployedFleetDetails_DeployedFleetAutoscaler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedFleetDetails_DeployedFleetAutoscaler) ProtoMessage() {}

func (x *DeployedFleetDetails_DeployedFleetAutoscaler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedFleetDetails_DeployedFleetAutoscaler.ProtoReflect.Descriptor instead.
func (*DeployedFleetDetails_DeployedFleetAutoscaler) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{8, 1}
}

func (x *DeployedFleetDetails_DeployedFleetAutoscaler) GetAutoscaler() string {
	if x != nil {
		return x.Autoscaler
	}
	return ""
}

func (x *DeployedFleetDetails_DeployedFleetAutoscaler) GetSpecSource() *SpecSource {
	if x != nil {
		return x.SpecSource
	}
	return nil
}

func (x *DeployedFleetDetails_DeployedFleetAutoscaler) GetFleetAutoscalerSpec() string {
	if x != nil {
		return x.FleetAutoscalerSpec
	}
	return ""
}

// DeployedFleetStatus has details about the Agones fleets such as how many
// are running, how many allocated, and so on.
type DeployedFleetDetails_DeployedFleet_DeployedFleetStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of GameServer replicas in the READY state in this fleet.
	ReadyReplicas int64 `protobuf:"varint,1,opt,name=ready_replicas,json=readyReplicas,proto3" json:"ready_replicas,omitempty"`
	// The number of GameServer replicas in the ALLOCATED state in this fleet.
	AllocatedReplicas int64 `protobuf:"varint,2,opt,name=allocated_replicas,json=allocatedReplicas,proto3" json:"allocated_replicas,omitempty"`
	// The number of GameServer replicas in the RESERVED state in this fleet.
	// Reserved instances won't be deleted on scale down, but won't cause
	// an autoscaler to scale up.
	ReservedReplicas int64 `protobuf:"varint,3,opt,name=reserved_replicas,json=reservedReplicas,proto3" json:"reserved_replicas,omitempty"`
	// The total number of current GameServer replicas in this fleet.
	Replicas int64 `protobuf:"varint,4,opt,name=replicas,proto3" json:"replicas,omitempty"`
}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) Reset() {
	*x = DeployedFleetDetails_DeployedFleet_DeployedFleetStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) ProtoMessage() {}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_common_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedFleetDetails_DeployedFleet_DeployedFleetStatus.ProtoReflect.Descriptor instead.
func (*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP(), []int{8, 0, 0}
}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetReadyReplicas() int64 {
	if x != nil {
		return x.ReadyReplicas
	}
	return 0
}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetAllocatedReplicas() int64 {
	if x != nil {
		return x.AllocatedReplicas
	}
	return 0
}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetReservedReplicas() int64 {
	if x != nil {
		return x.ReservedReplicas
	}
	return 0
}

func (x *DeployedFleetDetails_DeployedFleet_DeployedFleetStatus) GetReplicas() int64 {
	if x != nil {
		return x.Replicas
	}
	return 0
}

var File_google_cloud_gaming_v1beta_common_proto protoreflect.FileDescriptor

var file_google_cloud_gaming_v1beta_common_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe1, 0x04, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a,
	0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x72, 0x0a, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x6f, 0x0a, 0x14, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x91, 0x02, 0x0a, 0x0f,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x17, 0x0a, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x6a, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x01,
	0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44,
	0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4c, 0x55, 0x53, 0x54,
	0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22,
	0x99, 0x01, 0x0a, 0x0d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x27, 0x0a, 0x0d, 0x52,
	0x65, 0x61, 0x6c, 0x6d, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06,
	0x72, 0x65, 0x61, 0x6c, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65,
	0x61, 0x6c, 0x6d, 0x73, 0x22, 0xe0, 0x01, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x11, 0x63, 0x72, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x72, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x72,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x72, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x57, 0x0a, 0x0a, 0x53, 0x70, 0x65, 0x63, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xb7, 0x05, 0x0a, 0x0d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x1b, 0x67,
	0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x18, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x0d, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x0c, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0xca, 0x03,
	0x0a, 0x12, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x5e, 0x0a, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x52, 0x05, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x12, 0x72, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x65,
	0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x1a, 0x6a, 0x0a, 0x0b, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0b, 0x73,
	0x70, 0x65, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x70,
	0x65, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0a, 0x73, 0x70, 0x65, 0x63, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x1a, 0x74, 0x0a, 0x15, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c,
	0x65, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0a,
	0x73, 0x70, 0x65, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x52, 0x0a, 0x0b, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xe4,
	0x06, 0x0a, 0x14, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x65, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x5f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x52,
	0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x12, 0x79,
	0x0a, 0x13, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65,
	0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x72, 0x52, 0x12, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x1a, 0xb0, 0x03, 0x0a, 0x0d, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x47, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0a, 0x73,
	0x70, 0x65, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6a, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46,
	0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0xb4, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x79, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x1a, 0xb6, 0x01, 0x0a,
	0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x63,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0a, 0x73, 0x70, 0x65, 0x63, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x5a, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gaming_v1beta_common_proto_rawDescOnce sync.Once
	file_google_cloud_gaming_v1beta_common_proto_rawDescData = file_google_cloud_gaming_v1beta_common_proto_rawDesc
)

func file_google_cloud_gaming_v1beta_common_proto_rawDescGZIP() []byte {
	file_google_cloud_gaming_v1beta_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_gaming_v1beta_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gaming_v1beta_common_proto_rawDescData)
	})
	return file_google_cloud_gaming_v1beta_common_proto_rawDescData
}

var file_google_cloud_gaming_v1beta_common_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gaming_v1beta_common_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_gaming_v1beta_common_proto_goTypes = []interface{}{
	(OperationStatus_ErrorCode)(0),           // 0: google.cloud.gaming.v1beta.OperationStatus.ErrorCode
	(*OperationMetadata)(nil),                // 1: google.cloud.gaming.v1beta.OperationMetadata
	(*OperationStatus)(nil),                  // 2: google.cloud.gaming.v1beta.OperationStatus
	(*LabelSelector)(nil),                    // 3: google.cloud.gaming.v1beta.LabelSelector
	(*RealmSelector)(nil),                    // 4: google.cloud.gaming.v1beta.RealmSelector
	(*Schedule)(nil),                         // 5: google.cloud.gaming.v1beta.Schedule
	(*SpecSource)(nil),                       // 6: google.cloud.gaming.v1beta.SpecSource
	(*TargetDetails)(nil),                    // 7: google.cloud.gaming.v1beta.TargetDetails
	(*TargetState)(nil),                      // 8: google.cloud.gaming.v1beta.TargetState
	(*DeployedFleetDetails)(nil),             // 9: google.cloud.gaming.v1beta.DeployedFleetDetails
	nil,                                      // 10: google.cloud.gaming.v1beta.OperationMetadata.OperationStatusEntry
	nil,                                      // 11: google.cloud.gaming.v1beta.LabelSelector.LabelsEntry
	(*TargetDetails_TargetFleetDetails)(nil), // 12: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails
	(*TargetDetails_TargetFleetDetails_TargetFleet)(nil),           // 13: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleet
	(*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler)(nil), // 14: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
	(*DeployedFleetDetails_DeployedFleet)(nil),                     // 15: google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet
	(*DeployedFleetDetails_DeployedFleetAutoscaler)(nil),           // 16: google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleetAutoscaler
	(*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus)(nil), // 17: google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
	(*timestamppb.Timestamp)(nil),                                  // 18: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                                    // 19: google.protobuf.Duration
}
var file_google_cloud_gaming_v1beta_common_proto_depIdxs = []int32{
	18, // 0: google.cloud.gaming.v1beta.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	18, // 1: google.cloud.gaming.v1beta.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.gaming.v1beta.OperationMetadata.operation_status:type_name -> google.cloud.gaming.v1beta.OperationMetadata.OperationStatusEntry
	0,  // 3: google.cloud.gaming.v1beta.OperationStatus.error_code:type_name -> google.cloud.gaming.v1beta.OperationStatus.ErrorCode
	11, // 4: google.cloud.gaming.v1beta.LabelSelector.labels:type_name -> google.cloud.gaming.v1beta.LabelSelector.LabelsEntry
	18, // 5: google.cloud.gaming.v1beta.Schedule.start_time:type_name -> google.protobuf.Timestamp
	18, // 6: google.cloud.gaming.v1beta.Schedule.end_time:type_name -> google.protobuf.Timestamp
	19, // 7: google.cloud.gaming.v1beta.Schedule.cron_job_duration:type_name -> google.protobuf.Duration
	12, // 8: google.cloud.gaming.v1beta.TargetDetails.fleet_details:type_name -> google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails
	7,  // 9: google.cloud.gaming.v1beta.TargetState.details:type_name -> google.cloud.gaming.v1beta.TargetDetails
	15, // 10: google.cloud.gaming.v1beta.DeployedFleetDetails.deployed_fleet:type_name -> google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet
	16, // 11: google.cloud.gaming.v1beta.DeployedFleetDetails.deployed_autoscaler:type_name -> google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleetAutoscaler
	2,  // 12: google.cloud.gaming.v1beta.OperationMetadata.OperationStatusEntry.value:type_name -> google.cloud.gaming.v1beta.OperationStatus
	13, // 13: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.fleet:type_name -> google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleet
	14, // 14: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.autoscaler:type_name -> google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler
	6,  // 15: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleet.spec_source:type_name -> google.cloud.gaming.v1beta.SpecSource
	6,  // 16: google.cloud.gaming.v1beta.TargetDetails.TargetFleetDetails.TargetFleetAutoscaler.spec_source:type_name -> google.cloud.gaming.v1beta.SpecSource
	6,  // 17: google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet.spec_source:type_name -> google.cloud.gaming.v1beta.SpecSource
	17, // 18: google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet.status:type_name -> google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleet.DeployedFleetStatus
	6,  // 19: google.cloud.gaming.v1beta.DeployedFleetDetails.DeployedFleetAutoscaler.spec_source:type_name -> google.cloud.gaming.v1beta.SpecSource
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_gaming_v1beta_common_proto_init() }
func file_google_cloud_gaming_v1beta_common_proto_init() {
	if File_google_cloud_gaming_v1beta_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RealmSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpecSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployedFleetDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetDetails_TargetFleetDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetDetails_TargetFleetDetails_TargetFleet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetDetails_TargetFleetDetails_TargetFleetAutoscaler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployedFleetDetails_DeployedFleet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployedFleetDetails_DeployedFleetAutoscaler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_common_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployedFleetDetails_DeployedFleet_DeployedFleetStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gaming_v1beta_common_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gaming_v1beta_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_gaming_v1beta_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_gaming_v1beta_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_gaming_v1beta_common_proto_msgTypes,
	}.Build()
	File_google_cloud_gaming_v1beta_common_proto = out.File
	file_google_cloud_gaming_v1beta_common_proto_rawDesc = nil
	file_google_cloud_gaming_v1beta_common_proto_goTypes = nil
	file_google_cloud_gaming_v1beta_common_proto_depIdxs = nil
}
