// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RenameObjectInput {
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
    /// <p>Key name of the object to rename.</p>
    pub key: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub rename_source: ::std::option::Option<::std::string::String>,
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub destination_if_match: ::std::option::Option<::std::string::String>,
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub destination_if_none_match: ::std::option::Option<::std::string::String>,
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub destination_if_modified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub destination_if_unmodified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub source_if_match: ::std::option::Option<::std::string::String>,
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub source_if_none_match: ::std::option::Option<::std::string::String>,
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub source_if_modified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub source_if_unmodified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub client_token: ::std::option::Option<::std::string::String>,
}
impl RenameObjectInput {
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Key name of the object to rename.</p>
    pub fn key(&self) -> ::std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub fn rename_source(&self) -> ::std::option::Option<&str> {
        self.rename_source.as_deref()
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn destination_if_match(&self) -> ::std::option::Option<&str> {
        self.destination_if_match.as_deref()
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn destination_if_none_match(&self) -> ::std::option::Option<&str> {
        self.destination_if_none_match.as_deref()
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn destination_if_modified_since(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.destination_if_modified_since.as_ref()
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn destination_if_unmodified_since(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.destination_if_unmodified_since.as_ref()
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn source_if_match(&self) -> ::std::option::Option<&str> {
        self.source_if_match.as_deref()
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn source_if_none_match(&self) -> ::std::option::Option<&str> {
        self.source_if_none_match.as_deref()
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn source_if_modified_since(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.source_if_modified_since.as_ref()
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn source_if_unmodified_since(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.source_if_unmodified_since.as_ref()
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn client_token(&self) -> ::std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl RenameObjectInput {
    /// Creates a new builder-style object to manufacture [`RenameObjectInput`](crate::operation::rename_object::RenameObjectInput).
    pub fn builder() -> crate::operation::rename_object::builders::RenameObjectInputBuilder {
        crate::operation::rename_object::builders::RenameObjectInputBuilder::default()
    }
}

/// A builder for [`RenameObjectInput`](crate::operation::rename_object::RenameObjectInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RenameObjectInputBuilder {
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) key: ::std::option::Option<::std::string::String>,
    pub(crate) rename_source: ::std::option::Option<::std::string::String>,
    pub(crate) destination_if_match: ::std::option::Option<::std::string::String>,
    pub(crate) destination_if_none_match: ::std::option::Option<::std::string::String>,
    pub(crate) destination_if_modified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) destination_if_unmodified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) source_if_match: ::std::option::Option<::std::string::String>,
    pub(crate) source_if_none_match: ::std::option::Option<::std::string::String>,
    pub(crate) source_if_modified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) source_if_unmodified_since: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) client_token: ::std::option::Option<::std::string::String>,
}
impl RenameObjectInputBuilder {
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>Key name of the object to rename.</p>
    /// This field is required.
    pub fn key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Key name of the object to rename.</p>
    pub fn set_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key = input;
        self
    }
    /// <p>Key name of the object to rename.</p>
    pub fn get_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.key
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    /// This field is required.
    pub fn rename_source(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.rename_source = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub fn set_rename_source(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.rename_source = input;
        self
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub fn get_rename_source(&self) -> &::std::option::Option<::std::string::String> {
        &self.rename_source
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn destination_if_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.destination_if_match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn set_destination_if_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.destination_if_match = input;
        self
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn get_destination_if_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.destination_if_match
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn destination_if_none_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.destination_if_none_match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn set_destination_if_none_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.destination_if_none_match = input;
        self
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn get_destination_if_none_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.destination_if_none_match
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn destination_if_modified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.destination_if_modified_since = ::std::option::Option::Some(input);
        self
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn set_destination_if_modified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.destination_if_modified_since = input;
        self
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn get_destination_if_modified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.destination_if_modified_since
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn destination_if_unmodified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.destination_if_unmodified_since = ::std::option::Option::Some(input);
        self
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn set_destination_if_unmodified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.destination_if_unmodified_since = input;
        self
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn get_destination_if_unmodified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.destination_if_unmodified_since
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn source_if_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_if_match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn set_source_if_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_if_match = input;
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn get_source_if_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_if_match
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn source_if_none_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_if_none_match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn set_source_if_none_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_if_none_match = input;
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn get_source_if_none_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_if_none_match
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn source_if_modified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.source_if_modified_since = ::std::option::Option::Some(input);
        self
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn set_source_if_modified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.source_if_modified_since = input;
        self
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn get_source_if_modified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.source_if_modified_since
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn source_if_unmodified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.source_if_unmodified_since = ::std::option::Option::Some(input);
        self
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn set_source_if_unmodified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.source_if_unmodified_since = input;
        self
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn get_source_if_unmodified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.source_if_unmodified_since
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn client_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn set_client_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_token = input;
        self
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn get_client_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_token
    }
    /// Consumes the builder and constructs a [`RenameObjectInput`](crate::operation::rename_object::RenameObjectInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::rename_object::RenameObjectInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::rename_object::RenameObjectInput {
            bucket: self.bucket,
            key: self.key,
            rename_source: self.rename_source,
            destination_if_match: self.destination_if_match,
            destination_if_none_match: self.destination_if_none_match,
            destination_if_modified_since: self.destination_if_modified_since,
            destination_if_unmodified_since: self.destination_if_unmodified_since,
            source_if_match: self.source_if_match,
            source_if_none_match: self.source_if_none_match,
            source_if_modified_since: self.source_if_modified_since,
            source_if_unmodified_since: self.source_if_unmodified_since,
            client_token: self.client_token,
        })
    }
}
